# Property4\[T1: T1, T2: T2, T3: T3, T4: T4\]
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-163)</span>
```pony
trait ref Property4[T1: T1, T2: T2, T3: T3, T4: T4] is
  Property1[(T1 , T2 , T3 , T4)] ref
```

#### Implements

* [Property1](pony_check-Property1.md)\[(T1 , T2 , T3 , T4)\] ref

---

## Public Functions

### gen1
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-165)</span>


The Generator for the first argument to your `property4` method.


```pony
fun box gen1()
: Generator[T1] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T1\] box

---

### gen2
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-170)</span>


The Generator for the second argument to your `property4` method.


```pony
fun box gen2()
: Generator[T2] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T2\] box

---

### gen3
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-175)</span>


The Generator for the third argument to your `property4` method.


```pony
fun box gen3()
: Generator[T3] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T3\] box

---

### gen4
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-180)</span>


The Generator for the fourth argument to your `property4` method.


```pony
fun box gen4()
: Generator[T4] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T4\] box

---

### gen
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-185)</span>


```pony
fun box gen()
: Generator[(T1 , T2 , T3 , T4)] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[(T1 , T2 , T3 , T4)\] box

---

### property
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-192)</span>


```pony
fun ref property(
  arg1: (T1 , T2 , T3 , 
    T4),
  h: PropertyHelper val)
: None val ?
```
#### Parameters

*   arg1: (T1 , T2 , T3 , 
    T4)
*   h: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### property4
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-196)</span>


A method verifying that a certain property holds for all given
`arg1`, `arg2`, `arg3`, and `arg4`
with the help of [PropertyHelper](pony_check-PropertyHelper.md) `h`.


```pony
fun ref property4(
  arg1: T1,
  arg2: T2,
  arg3: T3,
  arg4: T4,
  h: PropertyHelper val)
: None val ?
```
#### Parameters

*   arg1: T1
*   arg2: T2
*   arg3: T3
*   arg4: T4
*   h: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### name
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-79)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### params
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-84)</span>


```pony
fun box params()
: PropertyParams val
```

#### Returns

* [PropertyParams](pony_check-PropertyParams.md) val

---

