/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;

public final class ThreadLocalX509TrustEngineContext {
    @Nonnull
    private static ThreadLocal<Data> current = new ThreadLocal();

    private ThreadLocalX509TrustEngineContext() {
    }

    public static void loadCurrent(@Nonnull TrustEngine<? super X509Credential> trustEngine, @Nonnull CriteriaSet criteria, @Nullable Boolean fatal) {
        Constraint.isNotNull(trustEngine, "TrustEngine may not be null");
        Constraint.isNotNull(criteria, "CriteriaSet may not be null");
        current.set(new Data(trustEngine, criteria, fatal));
    }

    public static void clearCurrent() {
        current.remove();
    }

    public static boolean haveCurrent() {
        return current.get() != null;
    }

    @Nullable
    public static TrustEngine<? super X509Credential> getTrustEngine() {
        return current.get() != null ? ThreadLocalX509TrustEngineContext.current.get().trustEngine : null;
    }

    @Nullable
    public static CriteriaSet getCriteria() {
        return current.get() != null ? ThreadLocalX509TrustEngineContext.current.get().criteriaSet : null;
    }

    @Nonnull
    public static Boolean isFailureFatal() {
        return current.get() != null ? ThreadLocalX509TrustEngineContext.current.get().failureFatal : Boolean.TRUE;
    }

    @Nullable
    public static Boolean getTrusted() {
        return current.get() != null ? ThreadLocalX509TrustEngineContext.current.get().trusted : null;
    }

    public static void setTrusted(@Nullable Boolean trusted) {
        if (current.get() != null) {
            ThreadLocalX509TrustEngineContext.current.get().trusted = trusted;
        }
    }

    private static final class Data {
        @Nonnull
        private TrustEngine<? super X509Credential> trustEngine;
        @Nonnull
        private CriteriaSet criteriaSet;
        @Nullable
        private Boolean trusted;
        @Nonnull
        private Boolean failureFatal;

        private Data(@Nonnull TrustEngine<? super X509Credential> engine, @Nonnull CriteriaSet criteria, @Nullable Boolean fatal) {
            this.trustEngine = engine;
            this.criteriaSet = criteria;
            this.failureFatal = fatal != null ? fatal : Boolean.TRUE;
        }
    }
}

