(window["visTypeVega_bundle_jsonpfunction"]=window["visTypeVega_bundle_jsonpfunction"]||[]).push([[0],Array(62).concat([function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function accessor(fn,fields,name){fn.fields=fields||[];fn.fname=name;return fn}function accessorName(fn){return fn==null?null:fn.fname}function accessorFields(fn){return fn==null?null:fn.fields}function getter(path){return path.length===1?get1(path[0]):getN(path)}const get1=field=>function(obj){return obj[field]};const getN=path=>{const len=path.length;return function(obj){for(let i=0;i<len;++i){obj=obj[path[i]]}return obj}};function error(message){throw Error(message)}function splitAccessPath(p){const path=[],n=p.length;let q=null,b=0,s="",i,j,c;p=p+"";function push(){path.push(s+p.substring(i,j));s="";i=j+1}for(i=j=0;j<n;++j){c=p[j];if(c==="\\"){s+=p.substring(i,j++);i=j}else if(c===q){push();q=null;b=-1}else if(q){continue}else if(i===b&&c==='"'){i=j+1;q=c}else if(i===b&&c==="'"){i=j+1;q=c}else if(c==="."&&!b){if(j>i){push()}else{i=j+1}}else if(c==="["){if(j>i)push();b=i=j+1}else if(c==="]"){if(!b)error("Access path missing open bracket: "+p);if(b>0)push();b=0;i=j+1}}if(b)error("Access path missing closing bracket: "+p);if(q)error("Access path missing closing quote: "+p);if(j>i){j++;push()}return path}function field(field,name,opt){const path=splitAccessPath(field);field=path.length===1?path[0]:field;return accessor((opt&&opt.get||getter)(path),[field],name||field)}const id=field("id");const identity=accessor(_=>_,[],"identity");const zero=accessor(()=>0,[],"zero");const one=accessor(()=>1,[],"one");const truthy=accessor(()=>true,[],"true");const falsy=accessor(()=>false,[],"false");function log$1(method,level,input){const args=[level].concat([].slice.call(input));console[method].apply(console,args)}const None=0;const Error$1=1;const Warn=2;const Info=3;const Debug=4;function logger(_,method,handler=log$1){let level=_||None;return{level(_){if(arguments.length){level=+_;return this}else{return level}},error(){if(level>=Error$1)handler(method||"error","ERROR",arguments);return this},warn(){if(level>=Warn)handler(method||"warn","WARN",arguments);return this},info(){if(level>=Info)handler(method||"log","INFO",arguments);return this},debug(){if(level>=Debug)handler(method||"log","DEBUG",arguments);return this}}}var isArray=Array.isArray;function isObject(_){return _===Object(_)}const isLegalKey=key=>key!=="__proto__";function mergeConfig(...configs){return configs.reduce((out,source)=>{for(const key in source){if(key==="signals"){out.signals=mergeNamed(out.signals,source.signals)}else{const r=key==="legend"?{layout:1}:key==="style"?true:null;writeConfig(out,key,source[key],r)}}return out},{})}function writeConfig(output,key,value,recurse){if(!isLegalKey(key))return;let k,o;if(isObject(value)&&!isArray(value)){o=isObject(output[key])?output[key]:output[key]={};for(k in value){if(recurse&&(recurse===true||recurse[k])){writeConfig(o,k,value[k])}else if(isLegalKey(k)){o[k]=value[k]}}}else{output[key]=value}}function mergeNamed(a,b){if(a==null)return b;const map={},out=[];function add(_){if(!map[_.name]){map[_.name]=1;out.push(_)}}b.forEach(add);a.forEach(add);return out}function peek(array){return array[array.length-1]}function toNumber(_){return _==null||_===""?null:+_}const exp=sign=>x=>sign*Math.exp(x);const log=sign=>x=>Math.log(sign*x);const symlog=c=>x=>Math.sign(x)*Math.log1p(Math.abs(x/c));const symexp=c=>x=>Math.sign(x)*Math.expm1(Math.abs(x))*c;const pow=exponent=>x=>x<0?-Math.pow(-x,exponent):Math.pow(x,exponent);function pan(domain,delta,lift,ground){const d0=lift(domain[0]),d1=lift(peek(domain)),dd=(d1-d0)*delta;return[ground(d0-dd),ground(d1-dd)]}function panLinear(domain,delta){return pan(domain,delta,toNumber,identity)}function panLog(domain,delta){var sign=Math.sign(domain[0]);return pan(domain,delta,log(sign),exp(sign))}function panPow(domain,delta,exponent){return pan(domain,delta,pow(exponent),pow(1/exponent))}function panSymlog(domain,delta,constant){return pan(domain,delta,symlog(constant),symexp(constant))}function zoom(domain,anchor,scale,lift,ground){const d0=lift(domain[0]),d1=lift(peek(domain)),da=anchor!=null?lift(anchor):(d0+d1)/2;return[ground(da+(d0-da)*scale),ground(da+(d1-da)*scale)]}function zoomLinear(domain,anchor,scale){return zoom(domain,anchor,scale,toNumber,identity)}function zoomLog(domain,anchor,scale){const sign=Math.sign(domain[0]);return zoom(domain,anchor,scale,log(sign),exp(sign))}function zoomPow(domain,anchor,scale,exponent){return zoom(domain,anchor,scale,pow(exponent),pow(1/exponent))}function zoomSymlog(domain,anchor,scale,constant){return zoom(domain,anchor,scale,symlog(constant),symexp(constant))}function quarter(date){return 1+~~(new Date(date).getMonth()/3)}function utcquarter(date){return 1+~~(new Date(date).getUTCMonth()/3)}function array(_){return _!=null?isArray(_)?_:[_]:[]}function clampRange(range,min,max){let lo=range[0],hi=range[1],span;if(hi<lo){span=hi;hi=lo;lo=span}span=hi-lo;return span>=max-min?[min,max]:[lo=Math.min(Math.max(lo,min),max-span),lo+span]}function isFunction(_){return typeof _==="function"}const DESCENDING="descending";function compare(fields,orders,opt){opt=opt||{};orders=array(orders)||[];const ord=[],get=[],fmap={},gen=opt.comparator||comparator;array(fields).forEach((f,i)=>{if(f==null)return;ord.push(orders[i]===DESCENDING?-1:1);get.push(f=isFunction(f)?f:field(f,null,opt));(accessorFields(f)||[]).forEach(_=>fmap[_]=1)});return get.length===0?null:accessor(gen(get,ord),Object.keys(fmap))}const ascending=(u,v)=>(u<v||u==null)&&v!=null?-1:(u>v||v==null)&&u!=null?1:(v=v instanceof Date?+v:v,u=u instanceof Date?+u:u)!==u&&v===v?-1:v!==v&&u===u?1:0;const comparator=(fields,orders)=>fields.length===1?compare1(fields[0],orders[0]):compareN(fields,orders,fields.length);const compare1=(field,order)=>function(a,b){return ascending(field(a),field(b))*order};const compareN=(fields,orders,n)=>{orders.push(0);return function(a,b){let f,c=0,i=-1;while(c===0&&++i<n){f=fields[i];c=ascending(f(a),f(b))}return c*orders[i]}};function constant(_){return isFunction(_)?_:()=>_}function debounce(delay,handler){let tid;return e=>{if(tid)clearTimeout(tid);tid=setTimeout(()=>(handler(e),tid=null),delay)}}function extend(_){for(let x,k,i=1,len=arguments.length;i<len;++i){x=arguments[i];for(k in x){_[k]=x[k]}}return _}function extent(array,f){let i=0,n,v,min,max;if(array&&(n=array.length)){if(f==null){for(v=array[i];i<n&&(v==null||v!==v);v=array[++i]);min=max=v;for(;i<n;++i){v=array[i];if(v!=null){if(v<min)min=v;if(v>max)max=v}}}else{for(v=f(array[i]);i<n&&(v==null||v!==v);v=f(array[++i]));min=max=v;for(;i<n;++i){v=f(array[i]);if(v!=null){if(v<min)min=v;if(v>max)max=v}}}}return[min,max]}function extentIndex(array,f){const n=array.length;let i=-1,a,b,c,u,v;if(f==null){while(++i<n){b=array[i];if(b!=null&&b>=b){a=c=b;break}}if(i===n)return[-1,-1];u=v=i;while(++i<n){b=array[i];if(b!=null){if(a>b){a=b;u=i}if(c<b){c=b;v=i}}}}else{while(++i<n){b=f(array[i],i,array);if(b!=null&&b>=b){a=c=b;break}}if(i===n)return[-1,-1];u=v=i;while(++i<n){b=f(array[i],i,array);if(b!=null){if(a>b){a=b;u=i}if(c<b){c=b;v=i}}}}return[u,v]}function has(object,property){return Object.hasOwn(object,property)}const NULL={};function fastmap(input){let obj={},test;function has$1(key){return has(obj,key)&&obj[key]!==NULL}const map={size:0,empty:0,object:obj,has:has$1,get(key){return has$1(key)?obj[key]:undefined},set(key,value){if(!has$1(key)){++map.size;if(obj[key]===NULL)--map.empty}obj[key]=value;return this},delete(key){if(has$1(key)){--map.size;++map.empty;obj[key]=NULL}return this},clear(){map.size=map.empty=0;map.object=obj={}},test(_){if(arguments.length){test=_;return map}else{return test}},clean(){const next={};let size=0;for(const key in obj){const value=obj[key];if(value!==NULL&&(!test||!test(value))){next[key]=value;++size}}map.size=size;map.empty=0;map.object=obj=next}};if(input)Object.keys(input).forEach(key=>{map.set(key,input[key])});return map}function flush(range,value,threshold,left,right,center){if(!threshold&&threshold!==0)return center;const t=+threshold;let a=range[0],b=peek(range),l;if(b<a){l=a;a=b;b=l}l=Math.abs(value-a);const r=Math.abs(b-value);return l<r&&l<=t?left:r<=t?right:center}function inherits(child,parent,members){const proto=child.prototype=Object.create(parent.prototype);Object.defineProperty(proto,"constructor",{value:child,writable:true,enumerable:true,configurable:true});return extend(proto,members)}function inrange(value,range,left,right){let r0=range[0],r1=range[range.length-1],t;if(r0>r1){t=r0;r0=r1;r1=t}left=left===undefined||left;right=right===undefined||right;return(left?r0<=value:r0<value)&&(right?value<=r1:value<r1)}function isBoolean(_){return typeof _==="boolean"}function isDate(_){return Object.prototype.toString.call(_)==="[object Date]"}function isIterable(_){return _&&isFunction(_[Symbol.iterator])}function isNumber(_){return typeof _==="number"}function isRegExp(_){return Object.prototype.toString.call(_)==="[object RegExp]"}function isString(_){return typeof _==="string"}function key(fields,flat,opt){if(fields){fields=flat?array(fields).map(f=>f.replace(/\\(.)/g,"$1")):array(fields)}const len=fields&&fields.length,gen=opt&&opt.get||getter,map=f=>gen(flat?[f]:splitAccessPath(f));let fn;if(!len){fn=function(){return""}}else if(len===1){const get=map(fields[0]);fn=function(_){return""+get(_)}}else{const get=fields.map(map);fn=function(_){let s=""+get[0](_),i=0;while(++i<len)s+="|"+get[i](_);return s}}return accessor(fn,fields,"key")}function lerp(array,frac){const lo=array[0],hi=peek(array),f=+frac;return!f?lo:f===1?hi:lo+f*(hi-lo)}const DEFAULT_MAX_SIZE=1e4;function lruCache(maxsize){maxsize=+maxsize||DEFAULT_MAX_SIZE;let curr,prev,size;const clear=()=>{curr={};prev={};size=0};const update=(key,value)=>{if(++size>maxsize){prev=curr;curr={};size=1}return curr[key]=value};clear();return{clear:clear,has:key=>has(curr,key)||has(prev,key),get:key=>has(curr,key)?curr[key]:has(prev,key)?update(key,prev[key]):undefined,set:(key,value)=>has(curr,key)?curr[key]=value:update(key,value)}}function merge(compare,array0,array1,output){const n0=array0.length,n1=array1.length;if(!n1)return array0;if(!n0)return array1;const merged=output||new array0.constructor(n0+n1);let i0=0,i1=0,i=0;for(;i0<n0&&i1<n1;++i){merged[i]=compare(array0[i0],array1[i1])>0?array1[i1++]:array0[i0++]}for(;i0<n0;++i0,++i){merged[i]=array0[i0]}for(;i1<n1;++i1,++i){merged[i]=array1[i1]}return merged}function repeat(str,reps){let s="";while(--reps>=0)s+=str;return s}function pad(str,length,padchar,align){const c=padchar||" ",s=str+"",n=length-s.length;return n<=0?s:align==="left"?repeat(c,n)+s:align==="center"?repeat(c,~~(n/2))+s+repeat(c,Math.ceil(n/2)):s+repeat(c,n)}function span(array){return array&&peek(array)-array[0]||0}function $(x){return isArray(x)?"["+x.map($)+"]":isObject(x)||isString(x)?JSON.stringify(x).replace("\u2028","\\u2028").replace("\u2029","\\u2029"):x}function toBoolean(_){return _==null||_===""?null:!_||_==="false"||_==="0"?false:!!_}const defaultParser=_=>isNumber(_)?_:isDate(_)?_:Date.parse(_);function toDate(_,parser){parser=parser||defaultParser;return _==null||_===""?null:parser(_)}function toString(_){return _==null||_===""?null:_+""}function toSet(_){const s={},n=_.length;for(let i=0;i<n;++i)s[_[i]]=true;return s}function truncate(str,length,align,ellipsis){const e=ellipsis!=null?ellipsis:"…",s=str+"",n=s.length,l=Math.max(0,length-e.length);return n<=length?s:align==="left"?e+s.slice(n-l):align==="center"?s.slice(0,Math.ceil(l/2))+e+s.slice(n-~~(l/2)):s.slice(0,l)+e}function visitArray(array,filter,visitor){if(array){if(filter){const n=array.length;for(let i=0;i<n;++i){const t=filter(array[i]);if(t)visitor(t,i,array)}}else{array.forEach(visitor)}}}exports.Debug=Debug;exports.Error=Error$1;exports.Info=Info;exports.None=None;exports.Warn=Warn;exports.accessor=accessor;exports.accessorFields=accessorFields;exports.accessorName=accessorName;exports.array=array;exports.ascending=ascending;exports.clampRange=clampRange;exports.compare=compare;exports.constant=constant;exports.debounce=debounce;exports.error=error;exports.extend=extend;exports.extent=extent;exports.extentIndex=extentIndex;exports.falsy=falsy;exports.fastmap=fastmap;exports.field=field;exports.flush=flush;exports.hasOwnProperty=has;exports.id=id;exports.identity=identity;exports.inherits=inherits;exports.inrange=inrange;exports.isArray=isArray;exports.isBoolean=isBoolean;exports.isDate=isDate;exports.isFunction=isFunction;exports.isIterable=isIterable;exports.isNumber=isNumber;exports.isObject=isObject;exports.isRegExp=isRegExp;exports.isString=isString;exports.key=key;exports.lerp=lerp;exports.logger=logger;exports.lruCache=lruCache;exports.merge=merge;exports.mergeConfig=mergeConfig;exports.one=one;exports.pad=pad;exports.panLinear=panLinear;exports.panLog=panLog;exports.panPow=panPow;exports.panSymlog=panSymlog;exports.peek=peek;exports.quarter=quarter;exports.repeat=repeat;exports.span=span;exports.splitAccessPath=splitAccessPath;exports.stringValue=$;exports.toBoolean=toBoolean;exports.toDate=toDate;exports.toNumber=toNumber;exports.toSet=toSet;exports.toString=toString;exports.truncate=truncate;exports.truthy=truthy;exports.utcquarter=utcquarter;exports.visitArray=visitArray;exports.writeConfig=writeConfig;exports.zero=zero;exports.zoomLinear=zoomLinear;exports.zoomLog=zoomLog;exports.zoomPow=zoomPow;exports.zoomSymlog=zoomSymlog}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(62),__webpack_require__(76),__webpack_require__(74)):undefined})(this,(function(exports,vegaUtil,vegaLoader,vegaFormat){"use strict";function UniqueList(idFunc){const $=idFunc||vegaUtil.identity,list=[],ids={};list.add=_=>{const id=$(_);if(!ids[id]){ids[id]=1;list.push(_)}return list};list.remove=_=>{const id=$(_);if(ids[id]){ids[id]=0;const idx=list.indexOf(_);if(idx>=0)list.splice(idx,1)}return list};return list}async function asyncCallback(df,callback){try{await callback(df)}catch(err){df.error(err)}}const TUPLE_ID_KEY=Symbol("vega_id");let TUPLE_ID=1;function isTuple(t){return!!(t&&tupleid(t))}function tupleid(t){return t[TUPLE_ID_KEY]}function setid(t,id){t[TUPLE_ID_KEY]=id;return t}function ingest$1(datum){const t=datum===Object(datum)?datum:{data:datum};return tupleid(t)?t:setid(t,TUPLE_ID++)}function derive(t){return rederive(t,ingest$1({}))}function rederive(t,d){for(const k in t)d[k]=t[k];return d}function replace(t,d){return setid(d,tupleid(t))}function stableCompare(cmp,f){return!cmp?null:f?(a,b)=>cmp(a,b)||tupleid(f(a))-tupleid(f(b)):(a,b)=>cmp(a,b)||tupleid(a)-tupleid(b)}function isChangeSet(v){return v&&v.constructor===changeset}function changeset(){const add=[],rem=[],mod=[],remp=[],modp=[];let clean=null,reflow=false;return{constructor:changeset,insert(t){const d=vegaUtil.array(t),n=d.length;for(let i=0;i<n;++i)add.push(d[i]);return this},remove(t){const a=vegaUtil.isFunction(t)?remp:rem,d=vegaUtil.array(t),n=d.length;for(let i=0;i<n;++i)a.push(d[i]);return this},modify(t,field,value){const m={field:field,value:vegaUtil.constant(value)};if(vegaUtil.isFunction(t)){m.filter=t;modp.push(m)}else{m.tuple=t;mod.push(m)}return this},encode(t,set){if(vegaUtil.isFunction(t))modp.push({filter:t,field:set});else mod.push({tuple:t,field:set});return this},clean(value){clean=value;return this},reflow(){reflow=true;return this},pulse(pulse,tuples){const cur={},out={};let i,n,m,f,t,id;for(i=0,n=tuples.length;i<n;++i){cur[tupleid(tuples[i])]=1}for(i=0,n=rem.length;i<n;++i){t=rem[i];cur[tupleid(t)]=-1}for(i=0,n=remp.length;i<n;++i){f=remp[i];tuples.forEach(t=>{if(f(t))cur[tupleid(t)]=-1})}for(i=0,n=add.length;i<n;++i){t=add[i];id=tupleid(t);if(cur[id]){cur[id]=1}else{pulse.add.push(ingest$1(add[i]))}}for(i=0,n=tuples.length;i<n;++i){t=tuples[i];if(cur[tupleid(t)]<0)pulse.rem.push(t)}function modify(t,f,v){if(v){t[f]=v(t)}else{pulse.encode=f}if(!reflow)out[tupleid(t)]=t}for(i=0,n=mod.length;i<n;++i){m=mod[i];t=m.tuple;f=m.field;id=cur[tupleid(t)];if(id>0){modify(t,f,m.value);pulse.modifies(f)}}for(i=0,n=modp.length;i<n;++i){m=modp[i];f=m.filter;tuples.forEach(t=>{if(f(t)&&cur[tupleid(t)]>0){modify(t,m.field,m.value)}});pulse.modifies(m.field)}if(reflow){pulse.mod=rem.length||remp.length?tuples.filter(t=>cur[tupleid(t)]>0):tuples.slice()}else{for(id in out)pulse.mod.push(out[id])}if(clean||clean==null&&(rem.length||remp.length)){pulse.clean(true)}return pulse}}}const CACHE="_:mod:_";function Parameters(){Object.defineProperty(this,CACHE,{writable:true,value:{}})}Parameters.prototype={set(name,index,value,force){const o=this,v=o[name],mod=o[CACHE];if(index!=null&&index>=0){if(v[index]!==value||force){v[index]=value;mod[index+":"+name]=-1;mod[name]=-1}}else if(v!==value||force){o[name]=value;mod[name]=vegaUtil.isArray(value)?1+value.length:-1}return o},modified(name,index){const mod=this[CACHE];if(!arguments.length){for(const k in mod){if(mod[k])return true}return false}else if(vegaUtil.isArray(name)){for(let k=0;k<name.length;++k){if(mod[name[k]])return true}return false}return index!=null&&index>=0?index+1<mod[name]||!!mod[index+":"+name]:!!mod[name]},clear(){this[CACHE]={};return this}};let OP_ID=0;const PULSE="pulse",NO_PARAMS=new Parameters;const SKIP$1=1,MODIFIED=2;function Operator(init,update,params,react){this.id=++OP_ID;this.value=init;this.stamp=-1;this.rank=-1;this.qrank=-1;this.flags=0;if(update){this._update=update}if(params)this.parameters(params,react)}function flag(bit){return function(state){const f=this.flags;if(arguments.length===0)return!!(f&bit);this.flags=state?f|bit:f&~bit;return this}}Operator.prototype={targets(){return this._targets||(this._targets=UniqueList(vegaUtil.id))},set(value){if(this.value!==value){this.value=value;return 1}else{return 0}},skip:flag(SKIP$1),modified:flag(MODIFIED),parameters(params,react,initonly){react=react!==false;const argval=this._argval=this._argval||new Parameters,argops=this._argops=this._argops||[],deps=[];let name,value,n,i;const add=(name,index,value)=>{if(value instanceof Operator){if(value!==this){if(react)value.targets().add(this);deps.push(value)}argops.push({op:value,name:name,index:index})}else{argval.set(name,index,value)}};for(name in params){value=params[name];if(name===PULSE){vegaUtil.array(value).forEach(op=>{if(!(op instanceof Operator)){vegaUtil.error("Pulse parameters must be operator instances.")}else if(op!==this){op.targets().add(this);deps.push(op)}});this.source=value}else if(vegaUtil.isArray(value)){argval.set(name,-1,Array(n=value.length));for(i=0;i<n;++i)add(name,i,value[i])}else{add(name,-1,value)}}this.marshall().clear();if(initonly)argops.initonly=true;return deps},marshall(stamp){const argval=this._argval||NO_PARAMS,argops=this._argops;let item,i,op,mod;if(argops){const n=argops.length;for(i=0;i<n;++i){item=argops[i];op=item.op;mod=op.modified()&&op.stamp===stamp;argval.set(item.name,item.index,op.value,mod)}if(argops.initonly){for(i=0;i<n;++i){item=argops[i];item.op.targets().remove(this)}this._argops=null;this._update=null}}return argval},detach(){const argops=this._argops;let i,n,item,op;if(argops){for(i=0,n=argops.length;i<n;++i){item=argops[i];op=item.op;if(op._targets){op._targets.remove(this)}}}this.pulse=null;this.source=null},evaluate(pulse){const update=this._update;if(update){const params=this.marshall(pulse.stamp),v=update.call(this,params,pulse);params.clear();if(v!==this.value){this.value=v}else if(!this.modified()){return pulse.StopPropagation}}},run(pulse){if(pulse.stamp<this.stamp)return pulse.StopPropagation;let rv;if(this.skip()){this.skip(false);rv=0}else{rv=this.evaluate(pulse)}return this.pulse=rv||pulse}};function add(init,update,params,react){let shift=1,op;if(init instanceof Operator){op=init}else if(init&&init.prototype instanceof Operator){op=new init}else if(vegaUtil.isFunction(init)){op=new Operator(null,init)}else{shift=0;op=new Operator(init,update)}this.rank(op);if(shift){react=params;params=update}if(params)this.connect(op,op.parameters(params,react));this.touch(op);return op}function connect(target,sources){const targetRank=target.rank,n=sources.length;for(let i=0;i<n;++i){if(targetRank<sources[i].rank){this.rerank(target);return}}}let STREAM_ID=0;function EventStream(filter,apply,receive){this.id=++STREAM_ID;this.value=null;if(receive)this.receive=receive;if(filter)this._filter=filter;if(apply)this._apply=apply}function stream(filter,apply,receive){return new EventStream(filter,apply,receive)}EventStream.prototype={_filter:vegaUtil.truthy,_apply:vegaUtil.identity,targets(){return this._targets||(this._targets=UniqueList(vegaUtil.id))},consume(_){if(!arguments.length)return!!this._consume;this._consume=!!_;return this},receive(evt){if(this._filter(evt)){const val=this.value=this._apply(evt),trg=this._targets,n=trg?trg.length:0;for(let i=0;i<n;++i)trg[i].receive(val);if(this._consume){evt.preventDefault();evt.stopPropagation()}}},filter(filter){const s=stream(filter);this.targets().add(s);return s},apply(apply){const s=stream(null,apply);this.targets().add(s);return s},merge(){const s=stream();this.targets().add(s);for(let i=0,n=arguments.length;i<n;++i){arguments[i].targets().add(s)}return s},throttle(pause){let t=-1;return this.filter(()=>{const now=Date.now();if(now-t>pause){t=now;return 1}else{return 0}})},debounce(delay){const s=stream();this.targets().add(stream(null,null,vegaUtil.debounce(delay,e=>{const df=e.dataflow;s.receive(e);if(df&&df.run)df.run()})));return s},between(a,b){let active=false;a.targets().add(stream(null,null,()=>active=true));b.targets().add(stream(null,null,()=>active=false));return this.filter(()=>active)},detach(){this._filter=vegaUtil.truthy;this._targets=null}};function events(source,type,filter,apply){const df=this,s=stream(filter,apply),send=function(e){e.dataflow=df;try{s.receive(e)}catch(error){df.error(error)}finally{df.run()}};let sources;if(typeof source==="string"&&typeof document!=="undefined"){sources=document.querySelectorAll(source)}else{sources=vegaUtil.array(source)}const n=sources.length;for(let i=0;i<n;++i){sources[i].addEventListener(type,send)}return s}function parse(data,format){const locale=this.locale();return vegaLoader.read(data,format,locale.timeParse,locale.utcParse)}function ingest(target,data,format){data=this.parse(data,format);return this.pulse(target,this.changeset().insert(data))}async function request(url,format){const df=this;let status=0,data;try{data=await df.loader().load(url,{context:"dataflow",response:vegaLoader.responseType(format&&format.type)});try{data=df.parse(data,format)}catch(err){status=-2;df.warn("Data ingestion failed",url,err)}}catch(err){status=-1;df.warn("Loading failed",url,err)}return{data:data,status:status}}async function preload(target,url,format){const df=this,pending=df._pending||loadPending(df);pending.requests+=1;const res=await df.request(url,format);df.pulse(target,df.changeset().remove(vegaUtil.truthy).insert(res.data||[]));pending.done();return res}function loadPending(df){let accept;const pending=new Promise(a=>accept=a);pending.requests=0;pending.done=()=>{if(--pending.requests===0){df._pending=null;accept(df)}};return df._pending=pending}const SKIP={skip:true};function on(source,target,update,params,options){const fn=source instanceof Operator?onOperator:onStream;fn(this,source,target,update,params,options);return this}function onStream(df,stream,target,update,params,options){const opt=vegaUtil.extend({},options,SKIP);let func,op;if(!vegaUtil.isFunction(target))target=vegaUtil.constant(target);if(update===undefined){func=e=>df.touch(target(e))}else if(vegaUtil.isFunction(update)){op=new Operator(null,update,params,false);func=e=>{op.evaluate(e);const t=target(e),v=op.value;isChangeSet(v)?df.pulse(t,v,options):df.update(t,v,opt)}}else{func=e=>df.update(target(e),update,opt)}stream.apply(func)}function onOperator(df,source,target,update,params,options){if(update===undefined){source.targets().add(target)}else{const opt=options||{},op=new Operator(null,updater(target,update),params,false);op.modified(opt.force);op.rank=source.rank;source.targets().add(op);if(target){op.skip(true);op.value=target.value;op.targets().add(target);df.connect(target,[op])}}}function updater(target,update){update=vegaUtil.isFunction(update)?update:vegaUtil.constant(update);return target?function(_,pulse){const value=update(_,pulse);if(!target.skip()){target.skip(value!==this.value).value=value}return value}:update}function rank(op){op.rank=++this._rank}function rerank(op){const queue=[op];let cur,list,i;while(queue.length){this.rank(cur=queue.pop());if(list=cur._targets){for(i=list.length;--i>=0;){queue.push(cur=list[i]);if(cur===op)vegaUtil.error("Cycle detected in dataflow graph.")}}}}const StopPropagation={};const ADD=1<<0,REM=1<<1,MOD=1<<2,ADD_REM=ADD|REM,ADD_MOD=ADD|MOD,ALL=ADD|REM|MOD,REFLOW=1<<3,SOURCE=1<<4,NO_SOURCE=1<<5,NO_FIELDS=1<<6;function Pulse(dataflow,stamp,encode){this.dataflow=dataflow;this.stamp=stamp==null?-1:stamp;this.add=[];this.rem=[];this.mod=[];this.fields=null;this.encode=encode||null}function materialize(data,filter){const out=[];vegaUtil.visitArray(data,filter,_=>out.push(_));return out}function filter(pulse,flags){const map={};pulse.visit(flags,t=>{map[tupleid(t)]=1});return t=>map[tupleid(t)]?null:t}function addFilter(a,b){return a?(t,i)=>a(t,i)&&b(t,i):b}Pulse.prototype={StopPropagation:StopPropagation,ADD:ADD,REM:REM,MOD:MOD,ADD_REM:ADD_REM,ADD_MOD:ADD_MOD,ALL:ALL,REFLOW:REFLOW,SOURCE:SOURCE,NO_SOURCE:NO_SOURCE,NO_FIELDS:NO_FIELDS,fork(flags){return new Pulse(this.dataflow).init(this,flags)},clone(){const p=this.fork(ALL);p.add=p.add.slice();p.rem=p.rem.slice();p.mod=p.mod.slice();if(p.source)p.source=p.source.slice();return p.materialize(ALL|SOURCE)},addAll(){let p=this;const reuse=!p.source||p.add===p.rem||!p.rem.length&&p.source.length===p.add.length;if(reuse){return p}else{p=new Pulse(this.dataflow).init(this);p.add=p.source;p.rem=[];return p}},init(src,flags){const p=this;p.stamp=src.stamp;p.encode=src.encode;if(src.fields&&!(flags&NO_FIELDS)){p.fields=src.fields}if(flags&ADD){p.addF=src.addF;p.add=src.add}else{p.addF=null;p.add=[]}if(flags&REM){p.remF=src.remF;p.rem=src.rem}else{p.remF=null;p.rem=[]}if(flags&MOD){p.modF=src.modF;p.mod=src.mod}else{p.modF=null;p.mod=[]}if(flags&NO_SOURCE){p.srcF=null;p.source=null}else{p.srcF=src.srcF;p.source=src.source;if(src.cleans)p.cleans=src.cleans}return p},runAfter(func){this.dataflow.runAfter(func)},changed(flags){const f=flags||ALL;return f&ADD&&this.add.length||f&REM&&this.rem.length||f&MOD&&this.mod.length},reflow(fork){if(fork)return this.fork(ALL).reflow();const len=this.add.length,src=this.source&&this.source.length;if(src&&src!==len){this.mod=this.source;if(len)this.filter(MOD,filter(this,ADD))}return this},clean(value){if(arguments.length){this.cleans=!!value;return this}else{return this.cleans}},modifies(_){const hash=this.fields||(this.fields={});if(vegaUtil.isArray(_)){_.forEach(f=>hash[f]=true)}else{hash[_]=true}return this},modified(_,nomod){const fields=this.fields;return!((nomod||this.mod.length)&&fields)?false:!arguments.length?!!fields:vegaUtil.isArray(_)?_.some(f=>fields[f]):fields[_]},filter(flags,filter){const p=this;if(flags&ADD)p.addF=addFilter(p.addF,filter);if(flags&REM)p.remF=addFilter(p.remF,filter);if(flags&MOD)p.modF=addFilter(p.modF,filter);if(flags&SOURCE)p.srcF=addFilter(p.srcF,filter);return p},materialize(flags){flags=flags||ALL;const p=this;if(flags&ADD&&p.addF){p.add=materialize(p.add,p.addF);p.addF=null}if(flags&REM&&p.remF){p.rem=materialize(p.rem,p.remF);p.remF=null}if(flags&MOD&&p.modF){p.mod=materialize(p.mod,p.modF);p.modF=null}if(flags&SOURCE&&p.srcF){p.source=p.source.filter(p.srcF);p.srcF=null}return p},visit(flags,visitor){const p=this,v=visitor;if(flags&SOURCE){vegaUtil.visitArray(p.source,p.srcF,v);return p}if(flags&ADD)vegaUtil.visitArray(p.add,p.addF,v);if(flags&REM)vegaUtil.visitArray(p.rem,p.remF,v);if(flags&MOD)vegaUtil.visitArray(p.mod,p.modF,v);const src=p.source;if(flags&REFLOW&&src){const sum=p.add.length+p.mod.length;if(sum===src.length);else if(sum){vegaUtil.visitArray(src,filter(p,ADD_MOD),v)}else{vegaUtil.visitArray(src,p.srcF,v)}}return p}};function MultiPulse(dataflow,stamp,pulses,encode){const p=this;let c=0;this.dataflow=dataflow;this.stamp=stamp;this.fields=null;this.encode=encode||null;this.pulses=pulses;for(const pulse of pulses){if(pulse.stamp!==stamp)continue;if(pulse.fields){const hash=p.fields||(p.fields={});for(const f in pulse.fields){hash[f]=1}}if(pulse.changed(p.ADD))c|=p.ADD;if(pulse.changed(p.REM))c|=p.REM;if(pulse.changed(p.MOD))c|=p.MOD}this.changes=c}vegaUtil.inherits(MultiPulse,Pulse,{fork(flags){const p=new Pulse(this.dataflow).init(this,flags&this.NO_FIELDS);if(flags!==undefined){if(flags&p.ADD)this.visit(p.ADD,t=>p.add.push(t));if(flags&p.REM)this.visit(p.REM,t=>p.rem.push(t));if(flags&p.MOD)this.visit(p.MOD,t=>p.mod.push(t))}return p},changed(flags){return this.changes&flags},modified(_){const p=this,fields=p.fields;return!(fields&&p.changes&p.MOD)?0:vegaUtil.isArray(_)?_.some(f=>fields[f]):fields[_]},filter(){vegaUtil.error("MultiPulse does not support filtering.")},materialize(){vegaUtil.error("MultiPulse does not support materialization.")},visit(flags,visitor){const p=this,pulses=p.pulses,n=pulses.length;let i=0;if(flags&p.SOURCE){for(;i<n;++i){pulses[i].visit(flags,visitor)}}else{for(;i<n;++i){if(pulses[i].stamp===p.stamp){pulses[i].visit(flags,visitor)}}}return p}});async function evaluate(encode,prerun,postrun){const df=this,async=[];if(df._pulse)return reentrant(df);if(df._pending)await df._pending;if(prerun)await asyncCallback(df,prerun);if(!df._touched.length){df.debug("Dataflow invoked, but nothing to do.");return df}const stamp=++df._clock;df._pulse=new Pulse(df,stamp,encode);df._touched.forEach(op=>df._enqueue(op,true));df._touched=UniqueList(vegaUtil.id);let count=0,op,next,error;try{while(df._heap.size()>0){op=df._heap.pop();if(op.rank!==op.qrank){df._enqueue(op,true);continue}next=op.run(df._getPulse(op,encode));if(next.then){next=await next}else if(next.async){async.push(next.async);next=StopPropagation}if(next!==StopPropagation){if(op._targets)op._targets.forEach(op=>df._enqueue(op))}++count}}catch(err){df._heap.clear();error=err}df._input={};df._pulse=null;df.debug(`Pulse ${stamp}: ${count} operators`);if(error){df._postrun=[];df.error(error)}if(df._postrun.length){const pr=df._postrun.sort((a,b)=>b.priority-a.priority);df._postrun=[];for(let i=0;i<pr.length;++i){await asyncCallback(df,pr[i].callback)}}if(postrun)await asyncCallback(df,postrun);if(async.length){Promise.all(async).then(cb=>df.runAsync(null,()=>{cb.forEach(f=>{try{f(df)}catch(err){df.error(err)}})}))}return df}async function runAsync(encode,prerun,postrun){while(this._running)await this._running;const clear=()=>this._running=null;(this._running=this.evaluate(encode,prerun,postrun)).then(clear,clear);return this._running}function run(encode,prerun,postrun){return this._pulse?reentrant(this):(this.evaluate(encode,prerun,postrun),this)}function runAfter(callback,enqueue,priority){if(this._pulse||enqueue){this._postrun.push({priority:priority||0,callback:callback})}else{try{callback(this)}catch(err){this.error(err)}}}function reentrant(df){df.error("Dataflow already running. Use runAsync() to chain invocations.");return df}function enqueue(op,force){const q=op.stamp<this._clock;if(q)op.stamp=this._clock;if(q||force){op.qrank=op.rank;this._heap.push(op)}}function getPulse(op,encode){const s=op.source,stamp=this._clock;return s&&vegaUtil.isArray(s)?new MultiPulse(this,stamp,s.map(_=>_.pulse),encode):this._input[op.id]||singlePulse(this._pulse,s&&s.pulse)}function singlePulse(p,s){if(s&&s.stamp===p.stamp){return s}p=p.fork();if(s&&s!==StopPropagation){p.source=s.source}return p}const NO_OPT={skip:false,force:false};function touch(op,options){const opt=options||NO_OPT;if(this._pulse){this._enqueue(op)}else{this._touched.add(op)}if(opt.skip)op.skip(true);return this}function update(op,value,options){const opt=options||NO_OPT;if(op.set(value)||opt.force){this.touch(op,opt)}return this}function pulse(op,changeset,options){this.touch(op,options||NO_OPT);const p=new Pulse(this,this._clock+(this._pulse?0:1)),t=op.pulse&&op.pulse.source||[];p.target=op;this._input[op.id]=changeset.pulse(p,t);return this}function Heap(cmp){let nodes=[];return{clear:()=>nodes=[],size:()=>nodes.length,peek:()=>nodes[0],push:x=>{nodes.push(x);return siftdown(nodes,0,nodes.length-1,cmp)},pop:()=>{const last=nodes.pop();let item;if(nodes.length){item=nodes[0];nodes[0]=last;siftup(nodes,0,cmp)}else{item=last}return item}}}function siftdown(array,start,idx,cmp){let parent,pidx;const item=array[idx];while(idx>start){pidx=idx-1>>1;parent=array[pidx];if(cmp(item,parent)<0){array[idx]=parent;idx=pidx;continue}break}return array[idx]=item}function siftup(array,idx,cmp){const start=idx,end=array.length,item=array[idx];let cidx=(idx<<1)+1,ridx;while(cidx<end){ridx=cidx+1;if(ridx<end&&cmp(array[cidx],array[ridx])>=0){cidx=ridx}array[idx]=array[cidx];idx=cidx;cidx=(idx<<1)+1}array[idx]=item;return siftdown(array,start,idx,cmp)}function Dataflow(){this.logger(vegaUtil.logger());this.logLevel(vegaUtil.Error);this._clock=0;this._rank=0;this._locale=vegaFormat.defaultLocale();try{this._loader=vegaLoader.loader()}catch(e){}this._touched=UniqueList(vegaUtil.id);this._input={};this._pulse=null;this._heap=Heap((a,b)=>a.qrank-b.qrank);this._postrun=[]}function logMethod(method){return function(){return this._log[method].apply(this,arguments)}}Dataflow.prototype={stamp(){return this._clock},loader(_){if(arguments.length){this._loader=_;return this}else{return this._loader}},locale(_){if(arguments.length){this._locale=_;return this}else{return this._locale}},logger(logger){if(arguments.length){this._log=logger;return this}else{return this._log}},error:logMethod("error"),warn:logMethod("warn"),info:logMethod("info"),debug:logMethod("debug"),logLevel:logMethod("level"),cleanThreshold:1e4,add:add,connect:connect,rank:rank,rerank:rerank,pulse:pulse,touch:touch,update:update,changeset:changeset,ingest:ingest,parse:parse,preload:preload,request:request,events:events,on:on,evaluate:evaluate,run:run,runAsync:runAsync,runAfter:runAfter,_enqueue:enqueue,_getPulse:getPulse};function Transform(init,params){Operator.call(this,init,null,params)}vegaUtil.inherits(Transform,Operator,{run(pulse){if(pulse.stamp<this.stamp)return pulse.StopPropagation;let rv;if(this.skip()){this.skip(false)}else{rv=this.evaluate(pulse)}rv=rv||pulse;if(rv.then){rv=rv.then(_=>this.pulse=_)}else if(rv!==pulse.StopPropagation){this.pulse=rv}return rv},evaluate(pulse){const params=this.marshall(pulse.stamp),out=this.transform(params,pulse);params.clear();return out},transform(){}});const transforms={};function definition(type){const t=transform(type);return t&&t.Definition||null}function transform(type){type=type&&type.toLowerCase();return vegaUtil.hasOwnProperty(transforms,type)?transforms[type]:null}exports.Dataflow=Dataflow;exports.EventStream=EventStream;exports.MultiPulse=MultiPulse;exports.Operator=Operator;exports.Parameters=Parameters;exports.Pulse=Pulse;exports.Transform=Transform;exports.UniqueList=UniqueList;exports.asyncCallback=asyncCallback;exports.changeset=changeset;exports.definition=definition;exports.derive=derive;exports.ingest=ingest$1;exports.isChangeSet=isChangeSet;exports.isTuple=isTuple;exports.rederive=rederive;exports.replace=replace;exports.stableCompare=stableCompare;exports.transform=transform;exports.transforms=transforms;exports.tupleid=tupleid}))},function(module,exports,__webpack_require__){"use strict";var vegaUtil=__webpack_require__(62);var vegaDataflow=__webpack_require__(63);var tx=__webpack_require__(94);var vtx=__webpack_require__(95);var encode=__webpack_require__(96);var geo=__webpack_require__(97);var force=__webpack_require__(98);var tree=__webpack_require__(99);var label=__webpack_require__(100);var reg=__webpack_require__(101);var voronoi=__webpack_require__(102);var wordcloud=__webpack_require__(103);var xf=__webpack_require__(104);var vegaStatistics=__webpack_require__(68);var vegaTime=__webpack_require__(71);var vegaLoader=__webpack_require__(76);var vegaScenegraph=__webpack_require__(72);var vegaScale=__webpack_require__(67);var vegaProjection=__webpack_require__(84);var vegaView=__webpack_require__(105);var vegaFormat=__webpack_require__(74);var vegaFunctions=__webpack_require__(78);var vegaParser=__webpack_require__(107);var vegaRuntime=__webpack_require__(85);var vegaExpression=__webpack_require__(79);var vegaEventSelector=__webpack_require__(66);function _interopNamespaceDefault(e){var n=Object.create(null);if(e){Object.keys(e).forEach((function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}}))}n.default=e;return Object.freeze(n)}var tx__namespace=_interopNamespaceDefault(tx);var vtx__namespace=_interopNamespaceDefault(vtx);var encode__namespace=_interopNamespaceDefault(encode);var geo__namespace=_interopNamespaceDefault(geo);var force__namespace=_interopNamespaceDefault(force);var tree__namespace=_interopNamespaceDefault(tree);var label__namespace=_interopNamespaceDefault(label);var reg__namespace=_interopNamespaceDefault(reg);var voronoi__namespace=_interopNamespaceDefault(voronoi);var wordcloud__namespace=_interopNamespaceDefault(wordcloud);var xf__namespace=_interopNamespaceDefault(xf);var version="5.33.0";vegaUtil.extend(vegaDataflow.transforms,tx__namespace,vtx__namespace,encode__namespace,geo__namespace,force__namespace,label__namespace,tree__namespace,reg__namespace,voronoi__namespace,wordcloud__namespace,xf__namespace);Object.defineProperty(exports,"Dataflow",{enumerable:true,get:function(){return vegaDataflow.Dataflow}});Object.defineProperty(exports,"EventStream",{enumerable:true,get:function(){return vegaDataflow.EventStream}});Object.defineProperty(exports,"MultiPulse",{enumerable:true,get:function(){return vegaDataflow.MultiPulse}});Object.defineProperty(exports,"Operator",{enumerable:true,get:function(){return vegaDataflow.Operator}});Object.defineProperty(exports,"Parameters",{enumerable:true,get:function(){return vegaDataflow.Parameters}});Object.defineProperty(exports,"Pulse",{enumerable:true,get:function(){return vegaDataflow.Pulse}});Object.defineProperty(exports,"Transform",{enumerable:true,get:function(){return vegaDataflow.Transform}});Object.defineProperty(exports,"changeset",{enumerable:true,get:function(){return vegaDataflow.changeset}});Object.defineProperty(exports,"definition",{enumerable:true,get:function(){return vegaDataflow.definition}});Object.defineProperty(exports,"ingest",{enumerable:true,get:function(){return vegaDataflow.ingest}});Object.defineProperty(exports,"isTuple",{enumerable:true,get:function(){return vegaDataflow.isTuple}});Object.defineProperty(exports,"transform",{enumerable:true,get:function(){return vegaDataflow.transform}});Object.defineProperty(exports,"transforms",{enumerable:true,get:function(){return vegaDataflow.transforms}});Object.defineProperty(exports,"tupleid",{enumerable:true,get:function(){return vegaDataflow.tupleid}});Object.defineProperty(exports,"interpolate",{enumerable:true,get:function(){return vegaScale.interpolate}});Object.defineProperty(exports,"interpolateColors",{enumerable:true,get:function(){return vegaScale.interpolateColors}});Object.defineProperty(exports,"interpolateRange",{enumerable:true,get:function(){return vegaScale.interpolateRange}});Object.defineProperty(exports,"quantizeInterpolator",{enumerable:true,get:function(){return vegaScale.quantizeInterpolator}});Object.defineProperty(exports,"scale",{enumerable:true,get:function(){return vegaScale.scale}});Object.defineProperty(exports,"scheme",{enumerable:true,get:function(){return vegaScale.scheme}});Object.defineProperty(exports,"projection",{enumerable:true,get:function(){return vegaProjection.projection}});Object.defineProperty(exports,"View",{enumerable:true,get:function(){return vegaView.View}});Object.defineProperty(exports,"defaultLocale",{enumerable:true,get:function(){return vegaFormat.defaultLocale}});Object.defineProperty(exports,"formatLocale",{enumerable:true,get:function(){return vegaFormat.numberFormatDefaultLocale}});Object.defineProperty(exports,"locale",{enumerable:true,get:function(){return vegaFormat.locale}});Object.defineProperty(exports,"resetDefaultLocale",{enumerable:true,get:function(){return vegaFormat.resetDefaultLocale}});Object.defineProperty(exports,"timeFormatLocale",{enumerable:true,get:function(){return vegaFormat.timeFormatDefaultLocale}});Object.defineProperty(exports,"expressionFunction",{enumerable:true,get:function(){return vegaFunctions.expressionFunction}});Object.defineProperty(exports,"parse",{enumerable:true,get:function(){return vegaParser.parse}});Object.defineProperty(exports,"runtimeContext",{enumerable:true,get:function(){return vegaRuntime.context}});Object.defineProperty(exports,"codegenExpression",{enumerable:true,get:function(){return vegaExpression.codegenExpression}});Object.defineProperty(exports,"parseExpression",{enumerable:true,get:function(){return vegaExpression.parseExpression}});Object.defineProperty(exports,"parseSelector",{enumerable:true,get:function(){return vegaEventSelector.parseSelector}});exports.version=version;Object.keys(vegaUtil).forEach((function(k){if(k!=="default"&&!Object.prototype.hasOwnProperty.call(exports,k))Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaUtil[k]}})}));Object.keys(vegaStatistics).forEach((function(k){if(k!=="default"&&!Object.prototype.hasOwnProperty.call(exports,k))Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaStatistics[k]}})}));Object.keys(vegaTime).forEach((function(k){if(k!=="default"&&!Object.prototype.hasOwnProperty.call(exports,k))Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaTime[k]}})}));Object.keys(vegaLoader).forEach((function(k){if(k!=="default"&&!Object.prototype.hasOwnProperty.call(exports,k))Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaLoader[k]}})}));Object.keys(vegaScenegraph).forEach((function(k){if(k!=="default"&&!Object.prototype.hasOwnProperty.call(exports,k))Object.defineProperty(exports,k,{enumerable:true,get:function(){return vegaScenegraph[k]}})}))},,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";const VIEW="view",LBRACK="[",RBRACK="]",LBRACE="{",RBRACE="}",COLON=":",COMMA=",",NAME="@",GT=">",ILLEGAL=/[[\]{}]/,DEFAULT_MARKS={"*":1,arc:1,area:1,group:1,image:1,line:1,path:1,rect:1,rule:1,shape:1,symbol:1,text:1,trail:1};let DEFAULT_SOURCE,MARKS;function eventSelector(selector,source,marks){DEFAULT_SOURCE=source||VIEW;MARKS=marks||DEFAULT_MARKS;return parseMerge(selector.trim()).map(parseSelector)}function isMarkType(type){return MARKS[type]}function find(s,i,endChar,pushChar,popChar){const n=s.length;let count=0,c;for(;i<n;++i){c=s[i];if(!count&&c===endChar)return i;else if(popChar&&popChar.indexOf(c)>=0)--count;else if(pushChar&&pushChar.indexOf(c)>=0)++count}return i}function parseMerge(s){const output=[],n=s.length;let start=0,i=0;while(i<n){i=find(s,i,COMMA,LBRACK+LBRACE,RBRACK+RBRACE);output.push(s.substring(start,i).trim());start=++i}if(output.length===0){throw"Empty event selector: "+s}return output}function parseSelector(s){return s[0]==="["?parseBetween(s):parseStream(s)}function parseBetween(s){const n=s.length;let i=1,b;i=find(s,i,RBRACK,LBRACK,RBRACK);if(i===n){throw"Empty between selector: "+s}b=parseMerge(s.substring(1,i));if(b.length!==2){throw"Between selector must have two elements: "+s}s=s.slice(i+1).trim();if(s[0]!==GT){throw"Expected '>' after between selector: "+s}b=b.map(parseSelector);const stream=parseSelector(s.slice(1).trim());if(stream.between){return{between:b,stream:stream}}else{stream.between=b}return stream}function parseStream(s){const stream={source:DEFAULT_SOURCE},source=[];let throttle=[0,0],markname=0,start=0,n=s.length,i=0,j,filter;if(s[n-1]===RBRACE){i=s.lastIndexOf(LBRACE);if(i>=0){try{throttle=parseThrottle(s.substring(i+1,n-1))}catch(e){throw"Invalid throttle specification: "+s}s=s.slice(0,i).trim();n=s.length}else throw"Unmatched right brace: "+s;i=0}if(!n)throw s;if(s[0]===NAME)markname=++i;j=find(s,i,COLON);if(j<n){source.push(s.substring(start,j).trim());start=i=++j}i=find(s,i,LBRACK);if(i===n){source.push(s.substring(start,n).trim())}else{source.push(s.substring(start,i).trim());filter=[];start=++i;if(start===n)throw"Unmatched left bracket: "+s}while(i<n){i=find(s,i,RBRACK);if(i===n)throw"Unmatched left bracket: "+s;filter.push(s.substring(start,i).trim());if(i<n-1&&s[++i]!==LBRACK)throw"Expected left bracket: "+s;start=++i}if(!(n=source.length)||ILLEGAL.test(source[n-1])){throw"Invalid event selector: "+s}if(n>1){stream.type=source[1];if(markname){stream.markname=source[0].slice(1)}else if(isMarkType(source[0])){stream.marktype=source[0]}else{stream.source=source[0]}}else{stream.type=source[0]}if(stream.type.slice(-1)==="!"){stream.consume=true;stream.type=stream.type.slice(0,-1)}if(filter!=null)stream.filter=filter;if(throttle[0])stream.throttle=throttle[0];if(throttle[1])stream.debounce=throttle[1];return stream}function parseThrottle(s){const a=s.split(COMMA);if(!s.length||a.length>2)throw s;return a.map(_=>{const x=+_;if(x!==x)throw s;return x})}exports.parseSelector=eventSelector}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(62),__webpack_require__(71)):undefined})(this,(function(exports,vegaUtil,vegaTime){"use strict";function bandSpace(count,paddingInner,paddingOuter){const space=count-paddingInner+paddingOuter*2;return count?space>0?space:1:0}const Identity="identity";const Linear="linear";const Log="log";const Pow="pow";const Sqrt="sqrt";const Symlog="symlog";const Time="time";const UTC="utc";const Sequential="sequential";const Diverging="diverging";const Quantile="quantile";const Quantize="quantize";const Threshold="threshold";const Ordinal="ordinal";const Point="point";const Band="band";const BinOrdinal="bin-ordinal";const Continuous="continuous";const Discrete="discrete";const Discretizing="discretizing";const Interpolating="interpolating";const Temporal="temporal";function invertRange(scale){return function(_){let lo=_[0],hi=_[1],t;if(hi<lo){t=lo;lo=hi;hi=t}return[scale.invert(lo),scale.invert(hi)]}}function invertRangeExtent(scale){return function(_){const range=scale.range();let lo=_[0],hi=_[1],min=-1,max,t,i,n;if(hi<lo){t=lo;lo=hi;hi=t}for(i=0,n=range.length;i<n;++i){if(range[i]>=lo&&range[i]<=hi){if(min<0)min=i;max=i}}if(min<0)return undefined;lo=scale.invertExtent(range[min]);hi=scale.invertExtent(range[max]);return[lo[0]===undefined?lo[1]:lo[0],hi[1]===undefined?hi[0]:hi[1]]}}function ascending$1(a,b){return a==null||b==null?NaN:a<b?-1:a>b?1:a>=b?0:NaN}function descending$1(a,b){return a==null||b==null?NaN:b<a?-1:b>a?1:b>=a?0:NaN}function bisector(f){let compare1,compare2,delta;if(f.length!==2){compare1=ascending$1;compare2=(d,x)=>ascending$1(f(d),x);delta=(d,x)=>f(d)-x}else{compare1=f===ascending$1||f===descending$1?f:zero$1;compare2=f;delta=f}function left(a,x,lo=0,hi=a.length){if(lo<hi){if(compare1(x,x)!==0)return hi;do{const mid=lo+hi>>>1;if(compare2(a[mid],x)<0)lo=mid+1;else hi=mid}while(lo<hi)}return lo}function right(a,x,lo=0,hi=a.length){if(lo<hi){if(compare1(x,x)!==0)return hi;do{const mid=lo+hi>>>1;if(compare2(a[mid],x)<=0)lo=mid+1;else hi=mid}while(lo<hi)}return lo}function center(a,x,lo=0,hi=a.length){const i=left(a,x,lo,hi-1);return i>lo&&delta(a[i-1],x)>-delta(a[i],x)?i-1:i}return{left:left,center:center,right:right}}function zero$1(){return 0}function number$2(x){return x===null?NaN:+x}const ascendingBisect=bisector(ascending$1);const bisectRight=ascendingBisect.right;bisector(number$2).center;class InternMap extends Map{constructor(entries,key=keyof){super();Object.defineProperties(this,{_intern:{value:new Map},_key:{value:key}});if(entries!=null)for(const[key,value]of entries)this.set(key,value)}get(key){return super.get(intern_get(this,key))}has(key){return super.has(intern_get(this,key))}set(key,value){return super.set(intern_set(this,key),value)}delete(key){return super.delete(intern_delete(this,key))}}function intern_get({_intern:_intern,_key:_key},value){const key=_key(value);return _intern.has(key)?_intern.get(key):value}function intern_set({_intern:_intern,_key:_key},value){const key=_key(value);if(_intern.has(key))return _intern.get(key);_intern.set(key,value);return value}function intern_delete({_intern:_intern,_key:_key},value){const key=_key(value);if(_intern.has(key)){value=_intern.get(key);_intern.delete(key)}return value}function keyof(value){return value!==null&&typeof value==="object"?value.valueOf():value}const e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function tickSpec(start,stop,count){const step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log10(step)),error=step/Math.pow(10,power),factor=error>=e10?10:error>=e5?5:error>=e2?2:1;let i1,i2,inc;if(power<0){inc=Math.pow(10,-power)/factor;i1=Math.round(start*inc);i2=Math.round(stop*inc);if(i1/inc<start)++i1;if(i2/inc>stop)--i2;inc=-inc}else{inc=Math.pow(10,power)*factor;i1=Math.round(start/inc);i2=Math.round(stop/inc);if(i1*inc<start)++i1;if(i2*inc>stop)--i2}if(i2<i1&&.5<=count&&count<2)return tickSpec(start,stop,count*2);return[i1,i2,inc]}function ticks(start,stop,count){stop=+stop,start=+start,count=+count;if(!(count>0))return[];if(start===stop)return[start];const reverse=stop<start,[i1,i2,inc]=reverse?tickSpec(stop,start,count):tickSpec(start,stop,count);if(!(i2>=i1))return[];const n=i2-i1+1,ticks=new Array(n);if(reverse){if(inc<0)for(let i=0;i<n;++i)ticks[i]=(i2-i)/-inc;else for(let i=0;i<n;++i)ticks[i]=(i2-i)*inc}else{if(inc<0)for(let i=0;i<n;++i)ticks[i]=(i1+i)/-inc;else for(let i=0;i<n;++i)ticks[i]=(i1+i)*inc}return ticks}function tickIncrement(start,stop,count){stop=+stop,start=+start,count=+count;return tickSpec(start,stop,count)[2]}function tickStep(start,stop,count){stop=+stop,start=+start,count=+count;const reverse=stop<start,inc=reverse?tickIncrement(stop,start,count):tickIncrement(start,stop,count);return(reverse?-1:1)*(inc<0?1/-inc:inc)}function quantileSorted(values,p,valueof=number$2){if(!(n=values.length)||isNaN(p=+p))return;if(p<=0||n<2)return+valueof(values[0],0,values);if(p>=1)return+valueof(values[n-1],n-1,values);var n,i=(n-1)*p,i0=Math.floor(i),value0=+valueof(values[i0],i0,values),value1=+valueof(values[i0+1],i0+1,values);return value0+(value1-value0)*(i-i0)}function range(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;var i=-1,n=Math.max(0,Math.ceil((stop-start)/step))|0,range=new Array(n);while(++i<n){range[i]=start+i*step}return range}function initRange(domain,range){switch(arguments.length){case 0:break;case 1:this.range(domain);break;default:this.range(range).domain(domain);break}return this}function initInterpolator(domain,interpolator){switch(arguments.length){case 0:break;case 1:{if(typeof domain==="function")this.interpolator(domain);else this.range(domain);break}default:{this.domain(domain);if(typeof interpolator==="function")this.interpolator(interpolator);else this.range(interpolator);break}}return this}const implicit=Symbol("implicit");function ordinal(){var index=new InternMap,domain=[],range=[],unknown=implicit;function scale(d){let i=index.get(d);if(i===undefined){if(unknown!==implicit)return unknown;index.set(d,i=domain.push(d)-1)}return range[i%range.length]}scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[],index=new InternMap;for(const value of _){if(index.has(value))continue;index.set(value,domain.push(value)-1)}return scale};scale.range=function(_){return arguments.length?(range=Array.from(_),scale):range.slice()};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};scale.copy=function(){return ordinal(domain,range).unknown(unknown)};initRange.apply(scale,arguments);return scale}function define(constructor,factory,prototype){constructor.prototype=factory.prototype=prototype;prototype.constructor=constructor}function extend(parent,definition){var prototype=Object.create(parent.prototype);for(var key in definition)prototype[key]=definition[key];return prototype}function Color(){}var darker=.7;var brighter=1/darker;var reI="\\s*([+-]?\\d+)\\s*",reN="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",reP="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",reHex=/^#([0-9a-f]{3,8})$/,reRgbInteger=new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`),reRgbPercent=new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`),reRgbaInteger=new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`),reRgbaPercent=new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`),reHslPercent=new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`),reHslaPercent=new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);var named={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};define(Color,color,{copy(channels){return Object.assign(new this.constructor,this,channels)},displayable(){return this.rgb().displayable()},hex:color_formatHex,formatHex:color_formatHex,formatHex8:color_formatHex8,formatHsl:color_formatHsl,formatRgb:color_formatRgb,toString:color_formatRgb});function color_formatHex(){return this.rgb().formatHex()}function color_formatHex8(){return this.rgb().formatHex8()}function color_formatHsl(){return hslConvert(this).formatHsl()}function color_formatRgb(){return this.rgb().formatRgb()}function color(format){var m,l;format=(format+"").trim().toLowerCase();return(m=reHex.exec(format))?(l=m[1].length,m=parseInt(m[1],16),l===6?rgbn(m):l===3?new Rgb(m>>8&15|m>>4&240,m>>4&15|m&240,(m&15)<<4|m&15,1):l===8?rgba(m>>24&255,m>>16&255,m>>8&255,(m&255)/255):l===4?rgba(m>>12&15|m>>8&240,m>>8&15|m>>4&240,m>>4&15|m&240,((m&15)<<4|m&15)/255):null):(m=reRgbInteger.exec(format))?new Rgb(m[1],m[2],m[3],1):(m=reRgbPercent.exec(format))?new Rgb(m[1]*255/100,m[2]*255/100,m[3]*255/100,1):(m=reRgbaInteger.exec(format))?rgba(m[1],m[2],m[3],m[4]):(m=reRgbaPercent.exec(format))?rgba(m[1]*255/100,m[2]*255/100,m[3]*255/100,m[4]):(m=reHslPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,1):(m=reHslaPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,m[4]):named.hasOwnProperty(format)?rgbn(named[format]):format==="transparent"?new Rgb(NaN,NaN,NaN,0):null}function rgbn(n){return new Rgb(n>>16&255,n>>8&255,n&255,1)}function rgba(r,g,b,a){if(a<=0)r=g=b=NaN;return new Rgb(r,g,b,a)}function rgbConvert(o){if(!(o instanceof Color))o=color(o);if(!o)return new Rgb;o=o.rgb();return new Rgb(o.r,o.g,o.b,o.opacity)}function rgb$1(r,g,b,opacity){return arguments.length===1?rgbConvert(r):new Rgb(r,g,b,opacity==null?1:opacity)}function Rgb(r,g,b,opacity){this.r=+r;this.g=+g;this.b=+b;this.opacity=+opacity}define(Rgb,rgb$1,extend(Color,{brighter(k){k=k==null?brighter:Math.pow(brighter,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},darker(k){k=k==null?darker:Math.pow(darker,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},rgb(){return this},clamp(){return new Rgb(clampi(this.r),clampi(this.g),clampi(this.b),clampa(this.opacity))},displayable(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:rgb_formatHex,formatHex:rgb_formatHex,formatHex8:rgb_formatHex8,formatRgb:rgb_formatRgb,toString:rgb_formatRgb}));function rgb_formatHex(){return`#${hex(this.r)}${hex(this.g)}${hex(this.b)}`}function rgb_formatHex8(){return`#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity)?1:this.opacity)*255)}`}function rgb_formatRgb(){const a=clampa(this.opacity);return`${a===1?"rgb(":"rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a===1?")":`, ${a})`}`}function clampa(opacity){return isNaN(opacity)?1:Math.max(0,Math.min(1,opacity))}function clampi(value){return Math.max(0,Math.min(255,Math.round(value)||0))}function hex(value){value=clampi(value);return(value<16?"0":"")+value.toString(16)}function hsla(h,s,l,a){if(a<=0)h=s=l=NaN;else if(l<=0||l>=1)h=s=NaN;else if(s<=0)h=NaN;return new Hsl(h,s,l,a)}function hslConvert(o){if(o instanceof Hsl)return new Hsl(o.h,o.s,o.l,o.opacity);if(!(o instanceof Color))o=color(o);if(!o)return new Hsl;if(o instanceof Hsl)return o;o=o.rgb();var r=o.r/255,g=o.g/255,b=o.b/255,min=Math.min(r,g,b),max=Math.max(r,g,b),h=NaN,s=max-min,l=(max+min)/2;if(s){if(r===max)h=(g-b)/s+(g<b)*6;else if(g===max)h=(b-r)/s+2;else h=(r-g)/s+4;s/=l<.5?max+min:2-max-min;h*=60}else{s=l>0&&l<1?0:h}return new Hsl(h,s,l,o.opacity)}function hsl$2(h,s,l,opacity){return arguments.length===1?hslConvert(h):new Hsl(h,s,l,opacity==null?1:opacity)}function Hsl(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Hsl,hsl$2,extend(Color,{brighter(k){k=k==null?brighter:Math.pow(brighter,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},darker(k){k=k==null?darker:Math.pow(darker,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},rgb(){var h=this.h%360+(this.h<0)*360,s=isNaN(h)||isNaN(this.s)?0:this.s,l=this.l,m2=l+(l<.5?l:1-l)*s,m1=2*l-m2;return new Rgb(hsl2rgb(h>=240?h-240:h+120,m1,m2),hsl2rgb(h,m1,m2),hsl2rgb(h<120?h+240:h-120,m1,m2),this.opacity)},clamp(){return new Hsl(clamph(this.h),clampt(this.s),clampt(this.l),clampa(this.opacity))},displayable(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl(){const a=clampa(this.opacity);return`${a===1?"hsl(":"hsla("}${clamph(this.h)}, ${clampt(this.s)*100}%, ${clampt(this.l)*100}%${a===1?")":`, ${a})`}`}}));function clamph(value){value=(value||0)%360;return value<0?value+360:value}function clampt(value){return Math.max(0,Math.min(1,value||0))}function hsl2rgb(h,m1,m2){return(h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1)*255}const radians=Math.PI/180;const degrees$1=180/Math.PI;const K=18,Xn=.96422,Yn=1,Zn=.82521,t0$1=4/29,t1$1=6/29,t2=3*t1$1*t1$1,t3=t1$1*t1$1*t1$1;function labConvert(o){if(o instanceof Lab)return new Lab(o.l,o.a,o.b,o.opacity);if(o instanceof Hcl)return hcl2lab(o);if(!(o instanceof Rgb))o=rgbConvert(o);var r=rgb2lrgb(o.r),g=rgb2lrgb(o.g),b=rgb2lrgb(o.b),y=xyz2lab((.2225045*r+.7168786*g+.0606169*b)/Yn),x,z;if(r===g&&g===b)x=z=y;else{x=xyz2lab((.4360747*r+.3850649*g+.1430804*b)/Xn);z=xyz2lab((.0139322*r+.0971045*g+.7141733*b)/Zn)}return new Lab(116*y-16,500*(x-y),200*(y-z),o.opacity)}function lab$1(l,a,b,opacity){return arguments.length===1?labConvert(l):new Lab(l,a,b,opacity==null?1:opacity)}function Lab(l,a,b,opacity){this.l=+l;this.a=+a;this.b=+b;this.opacity=+opacity}define(Lab,lab$1,extend(Color,{brighter(k){return new Lab(this.l+K*(k==null?1:k),this.a,this.b,this.opacity)},darker(k){return new Lab(this.l-K*(k==null?1:k),this.a,this.b,this.opacity)},rgb(){var y=(this.l+16)/116,x=isNaN(this.a)?y:y+this.a/500,z=isNaN(this.b)?y:y-this.b/200;x=Xn*lab2xyz(x);y=Yn*lab2xyz(y);z=Zn*lab2xyz(z);return new Rgb(lrgb2rgb(3.1338561*x-1.6168667*y-.4906146*z),lrgb2rgb(-.9787684*x+1.9161415*y+.033454*z),lrgb2rgb(.0719453*x-.2289914*y+1.4052427*z),this.opacity)}}));function xyz2lab(t){return t>t3?Math.pow(t,1/3):t/t2+t0$1}function lab2xyz(t){return t>t1$1?t*t*t:t2*(t-t0$1)}function lrgb2rgb(x){return 255*(x<=.0031308?12.92*x:1.055*Math.pow(x,1/2.4)-.055)}function rgb2lrgb(x){return(x/=255)<=.04045?x/12.92:Math.pow((x+.055)/1.055,2.4)}function hclConvert(o){if(o instanceof Hcl)return new Hcl(o.h,o.c,o.l,o.opacity);if(!(o instanceof Lab))o=labConvert(o);if(o.a===0&&o.b===0)return new Hcl(NaN,0<o.l&&o.l<100?0:NaN,o.l,o.opacity);var h=Math.atan2(o.b,o.a)*degrees$1;return new Hcl(h<0?h+360:h,Math.sqrt(o.a*o.a+o.b*o.b),o.l,o.opacity)}function hcl$2(h,c,l,opacity){return arguments.length===1?hclConvert(h):new Hcl(h,c,l,opacity==null?1:opacity)}function Hcl(h,c,l,opacity){this.h=+h;this.c=+c;this.l=+l;this.opacity=+opacity}function hcl2lab(o){if(isNaN(o.h))return new Lab(o.l,0,0,o.opacity);var h=o.h*radians;return new Lab(o.l,Math.cos(h)*o.c,Math.sin(h)*o.c,o.opacity)}define(Hcl,hcl$2,extend(Color,{brighter(k){return new Hcl(this.h,this.c,this.l+K*(k==null?1:k),this.opacity)},darker(k){return new Hcl(this.h,this.c,this.l-K*(k==null?1:k),this.opacity)},rgb(){return hcl2lab(this).rgb()}}));var A=-.14861,B=1.78277,C=-.29227,D=-.90649,E=1.97294,ED=E*D,EB=E*B,BC_DA=B*C-D*A;function cubehelixConvert(o){if(o instanceof Cubehelix)return new Cubehelix(o.h,o.s,o.l,o.opacity);if(!(o instanceof Rgb))o=rgbConvert(o);var r=o.r/255,g=o.g/255,b=o.b/255,l=(BC_DA*b+ED*r-EB*g)/(BC_DA+ED-EB),bl=b-l,k=(E*(g-l)-C*bl)/D,s=Math.sqrt(k*k+bl*bl)/(E*l*(1-l)),h=s?Math.atan2(k,bl)*degrees$1-120:NaN;return new Cubehelix(h<0?h+360:h,s,l,o.opacity)}function cubehelix$2(h,s,l,opacity){return arguments.length===1?cubehelixConvert(h):new Cubehelix(h,s,l,opacity==null?1:opacity)}function Cubehelix(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Cubehelix,cubehelix$2,extend(Color,{brighter(k){k=k==null?brighter:Math.pow(brighter,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},darker(k){k=k==null?darker:Math.pow(darker,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},rgb(){var h=isNaN(this.h)?0:(this.h+120)*radians,l=+this.l,a=isNaN(this.s)?0:this.s*l*(1-l),cosh=Math.cos(h),sinh=Math.sin(h);return new Rgb(255*(l+a*(A*cosh+B*sinh)),255*(l+a*(C*cosh+D*sinh)),255*(l+a*(E*cosh)),this.opacity)}}));function basis(t1,v0,v1,v2,v3){var t2=t1*t1,t3=t2*t1;return((1-3*t1+3*t2-t3)*v0+(4-6*t2+3*t3)*v1+(1+3*t1+3*t2-3*t3)*v2+t3*v3)/6}function basis$1(values){var n=values.length-1;return function(t){var i=t<=0?t=0:t>=1?(t=1,n-1):Math.floor(t*n),v1=values[i],v2=values[i+1],v0=i>0?values[i-1]:2*v1-v2,v3=i<n-1?values[i+2]:2*v2-v1;return basis((t-i/n)*n,v0,v1,v2,v3)}}function basisClosed(values){var n=values.length;return function(t){var i=Math.floor(((t%=1)<0?++t:t)*n),v0=values[(i+n-1)%n],v1=values[i%n],v2=values[(i+1)%n],v3=values[(i+2)%n];return basis((t-i/n)*n,v0,v1,v2,v3)}}var constant=x=>()=>x;function linear$1(a,d){return function(t){return a+t*d}}function exponential(a,b,y){return a=Math.pow(a,y),b=Math.pow(b,y)-a,y=1/y,function(t){return Math.pow(a+t*b,y)}}function hue$1(a,b){var d=b-a;return d?linear$1(a,d>180||d<-180?d-360*Math.round(d/360):d):constant(isNaN(a)?b:a)}function gamma(y){return(y=+y)===1?nogamma:function(a,b){return b-a?exponential(a,b,y):constant(isNaN(a)?b:a)}}function nogamma(a,b){var d=b-a;return d?linear$1(a,d):constant(isNaN(a)?b:a)}var rgb=function rgbGamma(y){var color=gamma(y);function rgb(start,end){var r=color((start=rgb$1(start)).r,(end=rgb$1(end)).r),g=color(start.g,end.g),b=color(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){start.r=r(t);start.g=g(t);start.b=b(t);start.opacity=opacity(t);return start+""}}rgb.gamma=rgbGamma;return rgb}(1);function rgbSpline(spline){return function(colors){var n=colors.length,r=new Array(n),g=new Array(n),b=new Array(n),i,color;for(i=0;i<n;++i){color=rgb$1(colors[i]);r[i]=color.r||0;g[i]=color.g||0;b[i]=color.b||0}r=spline(r);g=spline(g);b=spline(b);color.opacity=1;return function(t){color.r=r(t);color.g=g(t);color.b=b(t);return color+""}}}var rgbBasis=rgbSpline(basis$1);var rgbBasisClosed=rgbSpline(basisClosed);function numberArray(a,b){if(!b)b=[];var n=a?Math.min(b.length,a.length):0,c=b.slice(),i;return function(t){for(i=0;i<n;++i)c[i]=a[i]*(1-t)+b[i]*t;return c}}function isNumberArray(x){return ArrayBuffer.isView(x)&&!(x instanceof DataView)}function array(a,b){return(isNumberArray(b)?numberArray:genericArray)(a,b)}function genericArray(a,b){var nb=b?b.length:0,na=a?Math.min(nb,a.length):0,x=new Array(na),c=new Array(nb),i;for(i=0;i<na;++i)x[i]=interpolate$1(a[i],b[i]);for(;i<nb;++i)c[i]=b[i];return function(t){for(i=0;i<na;++i)c[i]=x[i](t);return c}}function date$1(a,b){var d=new Date;return a=+a,b=+b,function(t){return d.setTime(a*(1-t)+b*t),d}}function interpolateNumber(a,b){return a=+a,b=+b,function(t){return a*(1-t)+b*t}}function object(a,b){var i={},c={},k;if(a===null||typeof a!=="object")a={};if(b===null||typeof b!=="object")b={};for(k in b){if(k in a){i[k]=interpolate$1(a[k],b[k])}else{c[k]=b[k]}}return function(t){for(k in i)c[k]=i[k](t);return c}}var reA=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,reB=new RegExp(reA.source,"g");function zero(b){return function(){return b}}function one(b){return function(t){return b(t)+""}}function string(a,b){var bi=reA.lastIndex=reB.lastIndex=0,am,bm,bs,i=-1,s=[],q=[];a=a+"",b=b+"";while((am=reA.exec(a))&&(bm=reB.exec(b))){if((bs=bm.index)>bi){bs=b.slice(bi,bs);if(s[i])s[i]+=bs;else s[++i]=bs}if((am=am[0])===(bm=bm[0])){if(s[i])s[i]+=bm;else s[++i]=bm}else{s[++i]=null;q.push({i:i,x:interpolateNumber(am,bm)})}bi=reB.lastIndex}if(bi<b.length){bs=b.slice(bi);if(s[i])s[i]+=bs;else s[++i]=bs}return s.length<2?q[0]?one(q[0].x):zero(b):(b=q.length,function(t){for(var i=0,o;i<b;++i)s[(o=q[i]).i]=o.x(t);return s.join("")})}function interpolate$1(a,b){var t=typeof b,c;return b==null||t==="boolean"?constant(b):(t==="number"?interpolateNumber:t==="string"?(c=color(b))?(b=c,rgb):string:b instanceof color?rgb:b instanceof Date?date$1:isNumberArray(b)?numberArray:Array.isArray(b)?genericArray:typeof b.valueOf!=="function"&&typeof b.toString!=="function"||isNaN(b)?object:interpolateNumber)(a,b)}function discrete$1(range){var n=range.length;return function(t){return range[Math.max(0,Math.min(n-1,Math.floor(t*n)))]}}function hue(a,b){var i=hue$1(+a,+b);return function(t){var x=i(t);return x-360*Math.floor(x/360)}}function interpolateRound(a,b){return a=+a,b=+b,function(t){return Math.round(a*(1-t)+b*t)}}var degrees=180/Math.PI;var identity$3={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function decompose(a,b,c,d,e,f){var scaleX,scaleY,skewX;if(scaleX=Math.sqrt(a*a+b*b))a/=scaleX,b/=scaleX;if(skewX=a*c+b*d)c-=a*skewX,d-=b*skewX;if(scaleY=Math.sqrt(c*c+d*d))c/=scaleY,d/=scaleY,skewX/=scaleY;if(a*d<b*c)a=-a,b=-b,skewX=-skewX,scaleX=-scaleX;return{translateX:e,translateY:f,rotate:Math.atan2(b,a)*degrees,skewX:Math.atan(skewX)*degrees,scaleX:scaleX,scaleY:scaleY}}var svgNode;function parseCss(value){const m=new(typeof DOMMatrix==="function"?DOMMatrix:WebKitCSSMatrix)(value+"");return m.isIdentity?identity$3:decompose(m.a,m.b,m.c,m.d,m.e,m.f)}function parseSvg(value){if(value==null)return identity$3;if(!svgNode)svgNode=document.createElementNS("http://www.w3.org/2000/svg","g");svgNode.setAttribute("transform",value);if(!(value=svgNode.transform.baseVal.consolidate()))return identity$3;value=value.matrix;return decompose(value.a,value.b,value.c,value.d,value.e,value.f)}function interpolateTransform(parse,pxComma,pxParen,degParen){function pop(s){return s.length?s.pop()+" ":""}function translate(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push("translate(",null,pxComma,null,pxParen);q.push({i:i-4,x:interpolateNumber(xa,xb)},{i:i-2,x:interpolateNumber(ya,yb)})}else if(xb||yb){s.push("translate("+xb+pxComma+yb+pxParen)}}function rotate(a,b,s,q){if(a!==b){if(a-b>180)b+=360;else if(b-a>180)a+=360;q.push({i:s.push(pop(s)+"rotate(",null,degParen)-2,x:interpolateNumber(a,b)})}else if(b){s.push(pop(s)+"rotate("+b+degParen)}}function skewX(a,b,s,q){if(a!==b){q.push({i:s.push(pop(s)+"skewX(",null,degParen)-2,x:interpolateNumber(a,b)})}else if(b){s.push(pop(s)+"skewX("+b+degParen)}}function scale(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push(pop(s)+"scale(",null,",",null,")");q.push({i:i-4,x:interpolateNumber(xa,xb)},{i:i-2,x:interpolateNumber(ya,yb)})}else if(xb!==1||yb!==1){s.push(pop(s)+"scale("+xb+","+yb+")")}}return function(a,b){var s=[],q=[];a=parse(a),b=parse(b);translate(a.translateX,a.translateY,b.translateX,b.translateY,s,q);rotate(a.rotate,b.rotate,s,q);skewX(a.skewX,b.skewX,s,q);scale(a.scaleX,a.scaleY,b.scaleX,b.scaleY,s,q);a=b=null;return function(t){var i=-1,n=q.length,o;while(++i<n)s[(o=q[i]).i]=o.x(t);return s.join("")}}}var interpolateTransformCss=interpolateTransform(parseCss,"px, ","px)","deg)");var interpolateTransformSvg=interpolateTransform(parseSvg,", ",")",")");var epsilon2=1e-12;function cosh(x){return((x=Math.exp(x))+1/x)/2}function sinh(x){return((x=Math.exp(x))-1/x)/2}function tanh(x){return((x=Math.exp(2*x))-1)/(x+1)}var zoom=function zoomRho(rho,rho2,rho4){function zoom(p0,p1){var ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2],dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy,i,S;if(d2<epsilon2){S=Math.log(w1/w0)/rho;i=function(t){return[ux0+t*dx,uy0+t*dy,w0*Math.exp(rho*t*S)]}}else{var d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+rho4*d2)/(2*w0*rho2*d1),b1=(w1*w1-w0*w0-rho4*d2)/(2*w1*rho2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1);S=(r1-r0)/rho;i=function(t){var s=t*S,coshr0=cosh(r0),u=w0/(rho2*d1)*(coshr0*tanh(rho*s+r0)-sinh(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/cosh(rho*s+r0)]}}i.duration=S*1e3*rho/Math.SQRT2;return i}zoom.rho=function(_){var _1=Math.max(.001,+_),_2=_1*_1,_4=_2*_2;return zoomRho(_1,_2,_4)};return zoom}(Math.SQRT2,2,4);function hsl(hue){return function(start,end){var h=hue((start=hsl$2(start)).h,(end=hsl$2(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.s=s(t);start.l=l(t);start.opacity=opacity(t);return start+""}}}var hsl$1=hsl(hue$1);var hslLong=hsl(nogamma);function lab(start,end){var l=nogamma((start=lab$1(start)).l,(end=lab$1(end)).l),a=nogamma(start.a,end.a),b=nogamma(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){start.l=l(t);start.a=a(t);start.b=b(t);start.opacity=opacity(t);return start+""}}function hcl(hue){return function(start,end){var h=hue((start=hcl$2(start)).h,(end=hcl$2(end)).h),c=nogamma(start.c,end.c),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.c=c(t);start.l=l(t);start.opacity=opacity(t);return start+""}}}var hcl$1=hcl(hue$1);var hclLong=hcl(nogamma);function cubehelix(hue){return function cubehelixGamma(y){y=+y;function cubehelix(start,end){var h=hue((start=cubehelix$2(start)).h,(end=cubehelix$2(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.s=s(t);start.l=l(Math.pow(t,y));start.opacity=opacity(t);return start+""}}cubehelix.gamma=cubehelixGamma;return cubehelix}(1)}var cubehelix$1=cubehelix(hue$1);var cubehelixLong=cubehelix(nogamma);function piecewise(interpolate,values){if(values===undefined)values=interpolate,interpolate=interpolate$1;var i=0,n=values.length-1,v=values[0],I=new Array(n<0?0:n);while(i<n)I[i]=interpolate(v,v=values[++i]);return function(t){var i=Math.max(0,Math.min(n-1,Math.floor(t*=n)));return I[i](t-i)}}function quantize$1(interpolator,n){var samples=new Array(n);for(var i=0;i<n;++i)samples[i]=interpolator(i/(n-1));return samples}var $=Object.freeze({__proto__:null,interpolate:interpolate$1,interpolateArray:array,interpolateBasis:basis$1,interpolateBasisClosed:basisClosed,interpolateCubehelix:cubehelix$1,interpolateCubehelixLong:cubehelixLong,interpolateDate:date$1,interpolateDiscrete:discrete$1,interpolateHcl:hcl$1,interpolateHclLong:hclLong,interpolateHsl:hsl$1,interpolateHslLong:hslLong,interpolateHue:hue,interpolateLab:lab,interpolateNumber:interpolateNumber,interpolateNumberArray:numberArray,interpolateObject:object,interpolateRgb:rgb,interpolateRgbBasis:rgbBasis,interpolateRgbBasisClosed:rgbBasisClosed,interpolateRound:interpolateRound,interpolateString:string,interpolateTransformCss:interpolateTransformCss,interpolateTransformSvg:interpolateTransformSvg,interpolateZoom:zoom,piecewise:piecewise,quantize:quantize$1});function constants(x){return function(){return x}}function number$1(x){return+x}var unit=[0,1];function identity$2(x){return x}function normalize(a,b){return(b-=a=+a)?function(x){return(x-a)/b}:constants(isNaN(b)?NaN:.5)}function clamper(a,b){var t;if(a>b)t=a,a=b,b=t;return function(x){return Math.max(a,Math.min(b,x))}}function bimap(domain,range,interpolate){var d0=domain[0],d1=domain[1],r0=range[0],r1=range[1];if(d1<d0)d0=normalize(d1,d0),r0=interpolate(r1,r0);else d0=normalize(d0,d1),r0=interpolate(r0,r1);return function(x){return r0(d0(x))}}function polymap(domain,range,interpolate){var j=Math.min(domain.length,range.length)-1,d=new Array(j),r=new Array(j),i=-1;if(domain[j]<domain[0]){domain=domain.slice().reverse();range=range.slice().reverse()}while(++i<j){d[i]=normalize(domain[i],domain[i+1]);r[i]=interpolate(range[i],range[i+1])}return function(x){var i=bisectRight(domain,x,1,j)-1;return r[i](d[i](x))}}function copy$1(source,target){return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp()).unknown(source.unknown())}function transformer$2(){var domain=unit,range=unit,interpolate=interpolate$1,transform,untransform,unknown,clamp=identity$2,piecewise,output,input;function rescale(){var n=Math.min(domain.length,range.length);if(clamp!==identity$2)clamp=clamper(domain[0],domain[n-1]);piecewise=n>2?polymap:bimap;output=input=null;return scale}function scale(x){return x==null||isNaN(x=+x)?unknown:(output||(output=piecewise(domain.map(transform),range,interpolate)))(transform(clamp(x)))}scale.invert=function(y){return clamp(untransform((input||(input=piecewise(range,domain.map(transform),interpolateNumber)))(y)))};scale.domain=function(_){return arguments.length?(domain=Array.from(_,number$1),rescale()):domain.slice()};scale.range=function(_){return arguments.length?(range=Array.from(_),rescale()):range.slice()};scale.rangeRound=function(_){return range=Array.from(_),interpolate=interpolateRound,rescale()};scale.clamp=function(_){return arguments.length?(clamp=_?true:identity$2,rescale()):clamp!==identity$2};scale.interpolate=function(_){return arguments.length?(interpolate=_,rescale()):interpolate};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};return function(t,u){transform=t,untransform=u;return rescale()}}function continuous$1(){return transformer$2()(identity$2,identity$2)}function formatDecimal(x){return Math.abs(x=Math.round(x))>=1e21?x.toLocaleString("en").replace(/,/g,""):x.toString(10)}function formatDecimalParts(x,p){if((i=(x=p?x.toExponential(p-1):x.toExponential()).indexOf("e"))<0)return null;var i,coefficient=x.slice(0,i);return[coefficient.length>1?coefficient[0]+coefficient.slice(2):coefficient,+x.slice(i+1)]}function exponent(x){return x=formatDecimalParts(Math.abs(x)),x?x[1]:NaN}function formatGroup(grouping,thousands){return function(value,width){var i=value.length,t=[],j=0,g=grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=grouping[j=(j+1)%grouping.length]}return t.reverse().join(thousands)}}function formatNumerals(numerals){return function(value){return value.replace(/[0-9]/g,(function(i){return numerals[+i]}))}}var re=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function formatSpecifier(specifier){if(!(match=re.exec(specifier)))throw new Error("invalid format: "+specifier);var match;return new FormatSpecifier({fill:match[1],align:match[2],sign:match[3],symbol:match[4],zero:match[5],width:match[6],comma:match[7],precision:match[8]&&match[8].slice(1),trim:match[9],type:match[10]})}formatSpecifier.prototype=FormatSpecifier.prototype;function FormatSpecifier(specifier){this.fill=specifier.fill===undefined?" ":specifier.fill+"";this.align=specifier.align===undefined?">":specifier.align+"";this.sign=specifier.sign===undefined?"-":specifier.sign+"";this.symbol=specifier.symbol===undefined?"":specifier.symbol+"";this.zero=!!specifier.zero;this.width=specifier.width===undefined?undefined:+specifier.width;this.comma=!!specifier.comma;this.precision=specifier.precision===undefined?undefined:+specifier.precision;this.trim=!!specifier.trim;this.type=specifier.type===undefined?"":specifier.type+""}FormatSpecifier.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(this.width===undefined?"":Math.max(1,this.width|0))+(this.comma?",":"")+(this.precision===undefined?"":"."+Math.max(0,this.precision|0))+(this.trim?"~":"")+this.type};function formatTrim(s){out:for(var n=s.length,i=1,i0=-1,i1;i<n;++i){switch(s[i]){case".":i0=i1=i;break;case"0":if(i0===0)i0=i;i1=i;break;default:if(!+s[i])break out;if(i0>0)i0=0;break}}return i0>0?s.slice(0,i0)+s.slice(i1+1):s}var prefixExponent;function formatPrefixAuto(x,p){var d=formatDecimalParts(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1],i=exponent-(prefixExponent=Math.max(-8,Math.min(8,Math.floor(exponent/3)))*3)+1,n=coefficient.length;return i===n?coefficient:i>n?coefficient+new Array(i-n+1).join("0"):i>0?coefficient.slice(0,i)+"."+coefficient.slice(i):"0."+new Array(1-i).join("0")+formatDecimalParts(x,Math.max(0,p+i-1))[0]}function formatRounded(x,p){var d=formatDecimalParts(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1];return exponent<0?"0."+new Array(-exponent).join("0")+coefficient:coefficient.length>exponent+1?coefficient.slice(0,exponent+1)+"."+coefficient.slice(exponent+1):coefficient+new Array(exponent-coefficient.length+2).join("0")}var formatTypes={"%":(x,p)=>(x*100).toFixed(p),b:x=>Math.round(x).toString(2),c:x=>x+"",d:formatDecimal,e:(x,p)=>x.toExponential(p),f:(x,p)=>x.toFixed(p),g:(x,p)=>x.toPrecision(p),o:x=>Math.round(x).toString(8),p:(x,p)=>formatRounded(x*100,p),r:formatRounded,s:formatPrefixAuto,X:x=>Math.round(x).toString(16).toUpperCase(),x:x=>Math.round(x).toString(16)};function identity$1(x){return x}var map$1=Array.prototype.map,prefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function formatLocale$1(locale){var group=locale.grouping===undefined||locale.thousands===undefined?identity$1:formatGroup(map$1.call(locale.grouping,Number),locale.thousands+""),currencyPrefix=locale.currency===undefined?"":locale.currency[0]+"",currencySuffix=locale.currency===undefined?"":locale.currency[1]+"",decimal=locale.decimal===undefined?".":locale.decimal+"",numerals=locale.numerals===undefined?identity$1:formatNumerals(map$1.call(locale.numerals,String)),percent=locale.percent===undefined?"%":locale.percent+"",minus=locale.minus===undefined?"−":locale.minus+"",nan=locale.nan===undefined?"NaN":locale.nan+"";function newFormat(specifier){specifier=formatSpecifier(specifier);var fill=specifier.fill,align=specifier.align,sign=specifier.sign,symbol=specifier.symbol,zero=specifier.zero,width=specifier.width,comma=specifier.comma,precision=specifier.precision,trim=specifier.trim,type=specifier.type;if(type==="n")comma=true,type="g";else if(!formatTypes[type])precision===undefined&&(precision=12),trim=true,type="g";if(zero||fill==="0"&&align==="=")zero=true,fill="0",align="=";var prefix=symbol==="$"?currencyPrefix:symbol==="#"&&/[boxX]/.test(type)?"0"+type.toLowerCase():"",suffix=symbol==="$"?currencySuffix:/[%p]/.test(type)?percent:"";var formatType=formatTypes[type],maybeSuffix=/[defgprs%]/.test(type);precision=precision===undefined?6:/[gprs]/.test(type)?Math.max(1,Math.min(21,precision)):Math.max(0,Math.min(20,precision));function format(value){var valuePrefix=prefix,valueSuffix=suffix,i,n,c;if(type==="c"){valueSuffix=formatType(value)+valueSuffix;value=""}else{value=+value;var valueNegative=value<0||1/value<0;value=isNaN(value)?nan:formatType(Math.abs(value),precision);if(trim)value=formatTrim(value);if(valueNegative&&+value===0&&sign!=="+")valueNegative=false;valuePrefix=(valueNegative?sign==="("?sign:minus:sign==="-"||sign==="("?"":sign)+valuePrefix;valueSuffix=(type==="s"?prefixes[8+prefixExponent/3]:"")+valueSuffix+(valueNegative&&sign==="("?")":"");if(maybeSuffix){i=-1,n=value.length;while(++i<n){if(c=value.charCodeAt(i),48>c||c>57){valueSuffix=(c===46?decimal+value.slice(i+1):value.slice(i))+valueSuffix;value=value.slice(0,i);break}}}}if(comma&&!zero)value=group(value,Infinity);var length=valuePrefix.length+value.length+valueSuffix.length,padding=length<width?new Array(width-length+1).join(fill):"";if(comma&&zero)value=group(padding+value,padding.length?width-valueSuffix.length:Infinity),padding="";switch(align){case"<":value=valuePrefix+value+valueSuffix+padding;break;case"=":value=valuePrefix+padding+value+valueSuffix;break;case"^":value=padding.slice(0,length=padding.length>>1)+valuePrefix+value+valueSuffix+padding.slice(length);break;default:value=padding+valuePrefix+value+valueSuffix;break}return numerals(value)}format.toString=function(){return specifier+""};return format}function formatPrefix(specifier,value){var f=newFormat((specifier=formatSpecifier(specifier),specifier.type="f",specifier)),e=Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3,k=Math.pow(10,-e),prefix=prefixes[8+e/3];return function(value){return f(k*value)+prefix}}return{format:newFormat,formatPrefix:formatPrefix}}var locale$1;var format$1;var formatPrefix;defaultLocale$1({thousands:",",grouping:[3],currency:["$",""]});function defaultLocale$1(definition){locale$1=formatLocale$1(definition);format$1=locale$1.format;formatPrefix=locale$1.formatPrefix;return locale$1}function precisionFixed(step){return Math.max(0,-exponent(Math.abs(step)))}function precisionPrefix(step,value){return Math.max(0,Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3-exponent(Math.abs(step)))}function precisionRound(step,max){step=Math.abs(step),max=Math.abs(max)-step;return Math.max(0,exponent(max)-exponent(step))+1}function tickFormat$1(start,stop,count,specifier){var step=tickStep(start,stop,count),precision;specifier=formatSpecifier(specifier==null?",f":specifier);switch(specifier.type){case"s":{var value=Math.max(Math.abs(start),Math.abs(stop));if(specifier.precision==null&&!isNaN(precision=precisionPrefix(step,value)))specifier.precision=precision;return formatPrefix(specifier,value)}case"":case"e":case"g":case"p":case"r":{if(specifier.precision==null&&!isNaN(precision=precisionRound(step,Math.max(Math.abs(start),Math.abs(stop)))))specifier.precision=precision-(specifier.type==="e");break}case"f":case"%":{if(specifier.precision==null&&!isNaN(precision=precisionFixed(step)))specifier.precision=precision-(specifier.type==="%")*2;break}}return format$1(specifier)}function linearish(scale){var domain=scale.domain;scale.ticks=function(count){var d=domain();return ticks(d[0],d[d.length-1],count==null?10:count)};scale.tickFormat=function(count,specifier){var d=domain();return tickFormat$1(d[0],d[d.length-1],count==null?10:count,specifier)};scale.nice=function(count){if(count==null)count=10;var d=domain();var i0=0;var i1=d.length-1;var start=d[i0];var stop=d[i1];var prestep;var step;var maxIter=10;if(stop<start){step=start,start=stop,stop=step;step=i0,i0=i1,i1=step}while(maxIter-- >0){step=tickIncrement(start,stop,count);if(step===prestep){d[i0]=start;d[i1]=stop;return domain(d)}else if(step>0){start=Math.floor(start/step)*step;stop=Math.ceil(stop/step)*step}else if(step<0){start=Math.ceil(start*step)/step;stop=Math.floor(stop*step)/step}else{break}prestep=step}return scale};return scale}function linear(){var scale=continuous$1();scale.copy=function(){return copy$1(scale,linear())};initRange.apply(scale,arguments);return linearish(scale)}function identity(domain){var unknown;function scale(x){return x==null||isNaN(x=+x)?unknown:x}scale.invert=scale;scale.domain=scale.range=function(_){return arguments.length?(domain=Array.from(_,number$1),scale):domain.slice()};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};scale.copy=function(){return identity(domain).unknown(unknown)};domain=arguments.length?Array.from(domain,number$1):[0,1];return linearish(scale)}function nice(domain,interval){domain=domain.slice();var i0=0,i1=domain.length-1,x0=domain[i0],x1=domain[i1],t;if(x1<x0){t=i0,i0=i1,i1=t;t=x0,x0=x1,x1=t}domain[i0]=interval.floor(x0);domain[i1]=interval.ceil(x1);return domain}function transformLog(x){return Math.log(x)}function transformExp(x){return Math.exp(x)}function transformLogn(x){return-Math.log(-x)}function transformExpn(x){return-Math.exp(-x)}function pow10(x){return isFinite(x)?+("1e"+x):x<0?0:x}function powp(base){return base===10?pow10:base===Math.E?Math.exp:x=>Math.pow(base,x)}function logp(base){return base===Math.E?Math.log:base===10&&Math.log10||base===2&&Math.log2||(base=Math.log(base),x=>Math.log(x)/base)}function reflect(f){return(x,k)=>-f(-x,k)}function loggish(transform){const scale=transform(transformLog,transformExp);const domain=scale.domain;let base=10;let logs;let pows;function rescale(){logs=logp(base),pows=powp(base);if(domain()[0]<0){logs=reflect(logs),pows=reflect(pows);transform(transformLogn,transformExpn)}else{transform(transformLog,transformExp)}return scale}scale.base=function(_){return arguments.length?(base=+_,rescale()):base};scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()};scale.ticks=count=>{const d=domain();let u=d[0];let v=d[d.length-1];const r=v<u;if(r)[u,v]=[v,u];let i=logs(u);let j=logs(v);let k;let t;const n=count==null?10:+count;let z=[];if(!(base%1)&&j-i<n){i=Math.floor(i),j=Math.ceil(j);if(u>0)for(;i<=j;++i){for(k=1;k<base;++k){t=i<0?k/pows(-i):k*pows(i);if(t<u)continue;if(t>v)break;z.push(t)}}else for(;i<=j;++i){for(k=base-1;k>=1;--k){t=i>0?k/pows(-i):k*pows(i);if(t<u)continue;if(t>v)break;z.push(t)}}if(z.length*2<n)z=ticks(u,v,n)}else{z=ticks(i,j,Math.min(j-i,n)).map(pows)}return r?z.reverse():z};scale.tickFormat=(count,specifier)=>{if(count==null)count=10;if(specifier==null)specifier=base===10?"s":",";if(typeof specifier!=="function"){if(!(base%1)&&(specifier=formatSpecifier(specifier)).precision==null)specifier.trim=true;specifier=format$1(specifier)}if(count===Infinity)return specifier;const k=Math.max(1,base*count/scale.ticks().length);return d=>{let i=d/pows(Math.round(logs(d)));if(i*base<base-.5)i*=base;return i<=k?specifier(d):""}};scale.nice=()=>domain(nice(domain(),{floor:x=>pows(Math.floor(logs(x))),ceil:x=>pows(Math.ceil(logs(x)))}));return scale}function log(){const scale=loggish(transformer$2()).domain([1,10]);scale.copy=()=>copy$1(scale,log()).base(scale.base());initRange.apply(scale,arguments);return scale}function transformSymlog(c){return function(x){return Math.sign(x)*Math.log1p(Math.abs(x/c))}}function transformSymexp(c){return function(x){return Math.sign(x)*Math.expm1(Math.abs(x))*c}}function symlogish(transform){var c=1,scale=transform(transformSymlog(c),transformSymexp(c));scale.constant=function(_){return arguments.length?transform(transformSymlog(c=+_),transformSymexp(c)):c};return linearish(scale)}function symlog(){var scale=symlogish(transformer$2());scale.copy=function(){return copy$1(scale,symlog()).constant(scale.constant())};return initRange.apply(scale,arguments)}function transformPow(exponent){return function(x){return x<0?-Math.pow(-x,exponent):Math.pow(x,exponent)}}function transformSqrt(x){return x<0?-Math.sqrt(-x):Math.sqrt(x)}function transformSquare(x){return x<0?-x*x:x*x}function powish(transform){var scale=transform(identity$2,identity$2),exponent=1;function rescale(){return exponent===1?transform(identity$2,identity$2):exponent===.5?transform(transformSqrt,transformSquare):transform(transformPow(exponent),transformPow(1/exponent))}scale.exponent=function(_){return arguments.length?(exponent=+_,rescale()):exponent};return linearish(scale)}function pow(){var scale=powish(transformer$2());scale.copy=function(){return copy$1(scale,pow()).exponent(scale.exponent())};initRange.apply(scale,arguments);return scale}function sqrt(){return pow.apply(null,arguments).exponent(.5)}function quantile(){var domain=[],range=[],thresholds=[],unknown;function rescale(){var i=0,n=Math.max(1,range.length);thresholds=new Array(n-1);while(++i<n)thresholds[i-1]=quantileSorted(domain,i/n);return scale}function scale(x){return x==null||isNaN(x=+x)?unknown:range[bisectRight(thresholds,x)]}scale.invertExtent=function(y){var i=range.indexOf(y);return i<0?[NaN,NaN]:[i>0?thresholds[i-1]:domain[0],i<thresholds.length?thresholds[i]:domain[domain.length-1]]};scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[];for(let d of _)if(d!=null&&!isNaN(d=+d))domain.push(d);domain.sort(ascending$1);return rescale()};scale.range=function(_){return arguments.length?(range=Array.from(_),rescale()):range.slice()};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};scale.quantiles=function(){return thresholds.slice()};scale.copy=function(){return quantile().domain(domain).range(range).unknown(unknown)};return initRange.apply(scale,arguments)}function quantize(){var x0=0,x1=1,n=1,domain=[.5],range=[0,1],unknown;function scale(x){return x!=null&&x<=x?range[bisectRight(domain,x,0,n)]:unknown}function rescale(){var i=-1;domain=new Array(n);while(++i<n)domain[i]=((i+1)*x1-(i-n)*x0)/(n+1);return scale}scale.domain=function(_){return arguments.length?([x0,x1]=_,x0=+x0,x1=+x1,rescale()):[x0,x1]};scale.range=function(_){return arguments.length?(n=(range=Array.from(_)).length-1,rescale()):range.slice()};scale.invertExtent=function(y){var i=range.indexOf(y);return i<0?[NaN,NaN]:i<1?[x0,domain[0]]:i>=n?[domain[n-1],x1]:[domain[i-1],domain[i]]};scale.unknown=function(_){return arguments.length?(unknown=_,scale):scale};scale.thresholds=function(){return domain.slice()};scale.copy=function(){return quantize().domain([x0,x1]).range(range).unknown(unknown)};return initRange.apply(linearish(scale),arguments)}function threshold(){var domain=[.5],range=[0,1],unknown,n=1;function scale(x){return x!=null&&x<=x?range[bisectRight(domain,x,0,n)]:unknown}scale.domain=function(_){return arguments.length?(domain=Array.from(_),n=Math.min(domain.length,range.length-1),scale):domain.slice()};scale.range=function(_){return arguments.length?(range=Array.from(_),n=Math.min(domain.length,range.length-1),scale):range.slice()};scale.invertExtent=function(y){var i=range.indexOf(y);return[domain[i-1],domain[i]]};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};scale.copy=function(){return threshold().domain(domain).range(range).unknown(unknown)};return initRange.apply(scale,arguments)}const t0=new Date,t1=new Date;function timeInterval(floori,offseti,count,field){function interval(date){return floori(date=arguments.length===0?new Date:new Date(+date)),date}interval.floor=date=>(floori(date=new Date(+date)),date);interval.ceil=date=>(floori(date=new Date(date-1)),offseti(date,1),floori(date),date);interval.round=date=>{const d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1};interval.offset=(date,step)=>(offseti(date=new Date(+date),step==null?1:Math.floor(step)),date);interval.range=(start,stop,step)=>{const range=[];start=interval.ceil(start);step=step==null?1:Math.floor(step);if(!(start<stop)||!(step>0))return range;let previous;do{range.push(previous=new Date(+start)),offseti(start,step),floori(start)}while(previous<start&&start<stop);return range};interval.filter=test=>timeInterval(date=>{if(date>=date)while(floori(date),!test(date))date.setTime(date-1)},(date,step)=>{if(date>=date){if(step<0)while(++step<=0){while(offseti(date,-1),!test(date)){}}else while(--step>=0){while(offseti(date,1),!test(date)){}}}});if(count){interval.count=(start,end)=>{t0.setTime(+start),t1.setTime(+end);floori(t0),floori(t1);return Math.floor(count(t0,t1))};interval.every=step=>{step=Math.floor(step);return!isFinite(step)||!(step>0)?null:!(step>1)?interval:interval.filter(field?d=>field(d)%step===0:d=>interval.count(0,d)%step===0)}}return interval}const millisecond=timeInterval(()=>{},(date,step)=>{date.setTime(+date+step)},(start,end)=>end-start);millisecond.every=k=>{k=Math.floor(k);if(!isFinite(k)||!(k>0))return null;if(!(k>1))return millisecond;return timeInterval(date=>{date.setTime(Math.floor(date/k)*k)},(date,step)=>{date.setTime(+date+step*k)},(start,end)=>(end-start)/k)};millisecond.range;const durationSecond=1e3;const durationMinute=durationSecond*60;const durationHour=durationMinute*60;const durationDay=durationHour*24;const durationWeek=durationDay*7;const durationMonth=durationDay*30;const durationYear=durationDay*365;const second=timeInterval(date=>{date.setTime(date-date.getMilliseconds())},(date,step)=>{date.setTime(+date+step*durationSecond)},(start,end)=>(end-start)/durationSecond,date=>date.getUTCSeconds());second.range;const timeMinute=timeInterval(date=>{date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond)},(date,step)=>{date.setTime(+date+step*durationMinute)},(start,end)=>(end-start)/durationMinute,date=>date.getMinutes());timeMinute.range;const utcMinute=timeInterval(date=>{date.setUTCSeconds(0,0)},(date,step)=>{date.setTime(+date+step*durationMinute)},(start,end)=>(end-start)/durationMinute,date=>date.getUTCMinutes());utcMinute.range;const timeHour=timeInterval(date=>{date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond-date.getMinutes()*durationMinute)},(date,step)=>{date.setTime(+date+step*durationHour)},(start,end)=>(end-start)/durationHour,date=>date.getHours());timeHour.range;const utcHour=timeInterval(date=>{date.setUTCMinutes(0,0,0)},(date,step)=>{date.setTime(+date+step*durationHour)},(start,end)=>(end-start)/durationHour,date=>date.getUTCHours());utcHour.range;const timeDay=timeInterval(date=>date.setHours(0,0,0,0),(date,step)=>date.setDate(date.getDate()+step),(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationDay,date=>date.getDate()-1);timeDay.range;const utcDay=timeInterval(date=>{date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step)},(start,end)=>(end-start)/durationDay,date=>date.getUTCDate()-1);utcDay.range;const unixDay=timeInterval(date=>{date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step)},(start,end)=>(end-start)/durationDay,date=>Math.floor(date/durationDay));unixDay.range;function timeWeekday(i){return timeInterval(date=>{date.setDate(date.getDate()-(date.getDay()+7-i)%7);date.setHours(0,0,0,0)},(date,step)=>{date.setDate(date.getDate()+step*7)},(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationWeek)}const timeSunday=timeWeekday(0);const timeMonday=timeWeekday(1);const timeTuesday=timeWeekday(2);const timeWednesday=timeWeekday(3);const timeThursday=timeWeekday(4);const timeFriday=timeWeekday(5);const timeSaturday=timeWeekday(6);timeSunday.range;timeMonday.range;timeTuesday.range;timeWednesday.range;timeThursday.range;timeFriday.range;timeSaturday.range;function utcWeekday(i){return timeInterval(date=>{date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step*7)},(start,end)=>(end-start)/durationWeek)}const utcSunday=utcWeekday(0);const utcMonday=utcWeekday(1);const utcTuesday=utcWeekday(2);const utcWednesday=utcWeekday(3);const utcThursday=utcWeekday(4);const utcFriday=utcWeekday(5);const utcSaturday=utcWeekday(6);utcSunday.range;utcMonday.range;utcTuesday.range;utcWednesday.range;utcThursday.range;utcFriday.range;utcSaturday.range;const timeMonth=timeInterval(date=>{date.setDate(1);date.setHours(0,0,0,0)},(date,step)=>{date.setMonth(date.getMonth()+step)},(start,end)=>end.getMonth()-start.getMonth()+(end.getFullYear()-start.getFullYear())*12,date=>date.getMonth());timeMonth.range;const utcMonth=timeInterval(date=>{date.setUTCDate(1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCMonth(date.getUTCMonth()+step)},(start,end)=>end.getUTCMonth()-start.getUTCMonth()+(end.getUTCFullYear()-start.getUTCFullYear())*12,date=>date.getUTCMonth());utcMonth.range;const timeYear=timeInterval(date=>{date.setMonth(0,1);date.setHours(0,0,0,0)},(date,step)=>{date.setFullYear(date.getFullYear()+step)},(start,end)=>end.getFullYear()-start.getFullYear(),date=>date.getFullYear());timeYear.every=k=>!isFinite(k=Math.floor(k))||!(k>0)?null:timeInterval(date=>{date.setFullYear(Math.floor(date.getFullYear()/k)*k);date.setMonth(0,1);date.setHours(0,0,0,0)},(date,step)=>{date.setFullYear(date.getFullYear()+step*k)});timeYear.range;const utcYear=timeInterval(date=>{date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCFullYear(date.getUTCFullYear()+step)},(start,end)=>end.getUTCFullYear()-start.getUTCFullYear(),date=>date.getUTCFullYear());utcYear.every=k=>!isFinite(k=Math.floor(k))||!(k>0)?null:timeInterval(date=>{date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k);date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCFullYear(date.getUTCFullYear()+step*k)});utcYear.range;function ticker(year,month,week,day,hour,minute){const tickIntervals=[[second,1,durationSecond],[second,5,5*durationSecond],[second,15,15*durationSecond],[second,30,30*durationSecond],[minute,1,durationMinute],[minute,5,5*durationMinute],[minute,15,15*durationMinute],[minute,30,30*durationMinute],[hour,1,durationHour],[hour,3,3*durationHour],[hour,6,6*durationHour],[hour,12,12*durationHour],[day,1,durationDay],[day,2,2*durationDay],[week,1,durationWeek],[month,1,durationMonth],[month,3,3*durationMonth],[year,1,durationYear]];function ticks(start,stop,count){const reverse=stop<start;if(reverse)[start,stop]=[stop,start];const interval=count&&typeof count.range==="function"?count:tickInterval(start,stop,count);const ticks=interval?interval.range(start,+stop+1):[];return reverse?ticks.reverse():ticks}function tickInterval(start,stop,count){const target=Math.abs(stop-start)/count;const i=bisector(([,,step])=>step).right(tickIntervals,target);if(i===tickIntervals.length)return year.every(tickStep(start/durationYear,stop/durationYear,count));if(i===0)return millisecond.every(Math.max(tickStep(start,stop,count),1));const[t,step]=tickIntervals[target/tickIntervals[i-1][2]<tickIntervals[i][2]/target?i-1:i];return t.every(step)}return[ticks,tickInterval]}const[utcTicks,utcTickInterval]=ticker(utcYear,utcMonth,utcSunday,unixDay,utcHour,utcMinute);const[timeTicks,timeTickInterval]=ticker(timeYear,timeMonth,timeSunday,timeDay,timeHour,timeMinute);function localDate(d){if(0<=d.y&&d.y<100){var date=new Date(-1,d.m,d.d,d.H,d.M,d.S,d.L);date.setFullYear(d.y);return date}return new Date(d.y,d.m,d.d,d.H,d.M,d.S,d.L)}function utcDate(d){if(0<=d.y&&d.y<100){var date=new Date(Date.UTC(-1,d.m,d.d,d.H,d.M,d.S,d.L));date.setUTCFullYear(d.y);return date}return new Date(Date.UTC(d.y,d.m,d.d,d.H,d.M,d.S,d.L))}function newDate(y,m,d){return{y:y,m:m,d:d,H:0,M:0,S:0,L:0}}function formatLocale(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_weekdays=locale.days,locale_shortWeekdays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;var periodRe=formatRe(locale_periods),periodLookup=formatLookup(locale_periods),weekdayRe=formatRe(locale_weekdays),weekdayLookup=formatLookup(locale_weekdays),shortWeekdayRe=formatRe(locale_shortWeekdays),shortWeekdayLookup=formatLookup(locale_shortWeekdays),monthRe=formatRe(locale_months),monthLookup=formatLookup(locale_months),shortMonthRe=formatRe(locale_shortMonths),shortMonthLookup=formatLookup(locale_shortMonths);var formats={a:formatShortWeekday,A:formatWeekday,b:formatShortMonth,B:formatMonth,c:null,d:formatDayOfMonth,e:formatDayOfMonth,f:formatMicroseconds,g:formatYearISO,G:formatFullYearISO,H:formatHour24,I:formatHour12,j:formatDayOfYear,L:formatMilliseconds,m:formatMonthNumber,M:formatMinutes,p:formatPeriod,q:formatQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatSeconds,u:formatWeekdayNumberMonday,U:formatWeekNumberSunday,V:formatWeekNumberISO,w:formatWeekdayNumberSunday,W:formatWeekNumberMonday,x:null,X:null,y:formatYear,Y:formatFullYear,Z:formatZone,"%":formatLiteralPercent};var utcFormats={a:formatUTCShortWeekday,A:formatUTCWeekday,b:formatUTCShortMonth,B:formatUTCMonth,c:null,d:formatUTCDayOfMonth,e:formatUTCDayOfMonth,f:formatUTCMicroseconds,g:formatUTCYearISO,G:formatUTCFullYearISO,H:formatUTCHour24,I:formatUTCHour12,j:formatUTCDayOfYear,L:formatUTCMilliseconds,m:formatUTCMonthNumber,M:formatUTCMinutes,p:formatUTCPeriod,q:formatUTCQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatUTCSeconds,u:formatUTCWeekdayNumberMonday,U:formatUTCWeekNumberSunday,V:formatUTCWeekNumberISO,w:formatUTCWeekdayNumberSunday,W:formatUTCWeekNumberMonday,x:null,X:null,y:formatUTCYear,Y:formatUTCFullYear,Z:formatUTCZone,"%":formatLiteralPercent};var parses={a:parseShortWeekday,A:parseWeekday,b:parseShortMonth,B:parseMonth,c:parseLocaleDateTime,d:parseDayOfMonth,e:parseDayOfMonth,f:parseMicroseconds,g:parseYear,G:parseFullYear,H:parseHour24,I:parseHour24,j:parseDayOfYear,L:parseMilliseconds,m:parseMonthNumber,M:parseMinutes,p:parsePeriod,q:parseQuarter,Q:parseUnixTimestamp,s:parseUnixTimestampSeconds,S:parseSeconds,u:parseWeekdayNumberMonday,U:parseWeekNumberSunday,V:parseWeekNumberISO,w:parseWeekdayNumberSunday,W:parseWeekNumberMonday,x:parseLocaleDate,X:parseLocaleTime,y:parseYear,Y:parseFullYear,Z:parseZone,"%":parseLiteralPercent};formats.x=newFormat(locale_date,formats);formats.X=newFormat(locale_time,formats);formats.c=newFormat(locale_dateTime,formats);utcFormats.x=newFormat(locale_date,utcFormats);utcFormats.X=newFormat(locale_time,utcFormats);utcFormats.c=newFormat(locale_dateTime,utcFormats);function newFormat(specifier,formats){return function(date){var string=[],i=-1,j=0,n=specifier.length,c,pad,format;if(!(date instanceof Date))date=new Date(+date);while(++i<n){if(specifier.charCodeAt(i)===37){string.push(specifier.slice(j,i));if((pad=pads[c=specifier.charAt(++i)])!=null)c=specifier.charAt(++i);else pad=c==="e"?" ":"0";if(format=formats[c])c=format(date,pad);string.push(c);j=i+1}}string.push(specifier.slice(j,i));return string.join("")}}function newParse(specifier,Z){return function(string){var d=newDate(1900,undefined,1),i=parseSpecifier(d,specifier,string+="",0),week,day;if(i!=string.length)return null;if("Q"in d)return new Date(d.Q);if("s"in d)return new Date(d.s*1e3+("L"in d?d.L:0));if(Z&&!("Z"in d))d.Z=0;if("p"in d)d.H=d.H%12+d.p*12;if(d.m===undefined)d.m="q"in d?d.q:0;if("V"in d){if(d.V<1||d.V>53)return null;if(!("w"in d))d.w=1;if("Z"in d){week=utcDate(newDate(d.y,0,1)),day=week.getUTCDay();week=day>4||day===0?utcMonday.ceil(week):utcMonday(week);week=utcDay.offset(week,(d.V-1)*7);d.y=week.getUTCFullYear();d.m=week.getUTCMonth();d.d=week.getUTCDate()+(d.w+6)%7}else{week=localDate(newDate(d.y,0,1)),day=week.getDay();week=day>4||day===0?timeMonday.ceil(week):timeMonday(week);week=timeDay.offset(week,(d.V-1)*7);d.y=week.getFullYear();d.m=week.getMonth();d.d=week.getDate()+(d.w+6)%7}}else if("W"in d||"U"in d){if(!("w"in d))d.w="u"in d?d.u%7:"W"in d?1:0;day="Z"in d?utcDate(newDate(d.y,0,1)).getUTCDay():localDate(newDate(d.y,0,1)).getDay();d.m=0;d.d="W"in d?(d.w+6)%7+d.W*7-(day+5)%7:d.w+d.U*7-(day+6)%7}if("Z"in d){d.H+=d.Z/100|0;d.M+=d.Z%100;return utcDate(d)}return localDate(d)}}function parseSpecifier(d,specifier,string,j){var i=0,n=specifier.length,m=string.length,c,parse;while(i<n){if(j>=m)return-1;c=specifier.charCodeAt(i++);if(c===37){c=specifier.charAt(i++);parse=parses[c in pads?specifier.charAt(i++):c];if(!parse||(j=parse(d,string,j))<0)return-1}else if(c!=string.charCodeAt(j++)){return-1}}return j}function parsePeriod(d,string,i){var n=periodRe.exec(string.slice(i));return n?(d.p=periodLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseShortWeekday(d,string,i){var n=shortWeekdayRe.exec(string.slice(i));return n?(d.w=shortWeekdayLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseWeekday(d,string,i){var n=weekdayRe.exec(string.slice(i));return n?(d.w=weekdayLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseShortMonth(d,string,i){var n=shortMonthRe.exec(string.slice(i));return n?(d.m=shortMonthLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseMonth(d,string,i){var n=monthRe.exec(string.slice(i));return n?(d.m=monthLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseLocaleDateTime(d,string,i){return parseSpecifier(d,locale_dateTime,string,i)}function parseLocaleDate(d,string,i){return parseSpecifier(d,locale_date,string,i)}function parseLocaleTime(d,string,i){return parseSpecifier(d,locale_time,string,i)}function formatShortWeekday(d){return locale_shortWeekdays[d.getDay()]}function formatWeekday(d){return locale_weekdays[d.getDay()]}function formatShortMonth(d){return locale_shortMonths[d.getMonth()]}function formatMonth(d){return locale_months[d.getMonth()]}function formatPeriod(d){return locale_periods[+(d.getHours()>=12)]}function formatQuarter(d){return 1+~~(d.getMonth()/3)}function formatUTCShortWeekday(d){return locale_shortWeekdays[d.getUTCDay()]}function formatUTCWeekday(d){return locale_weekdays[d.getUTCDay()]}function formatUTCShortMonth(d){return locale_shortMonths[d.getUTCMonth()]}function formatUTCMonth(d){return locale_months[d.getUTCMonth()]}function formatUTCPeriod(d){return locale_periods[+(d.getUTCHours()>=12)]}function formatUTCQuarter(d){return 1+~~(d.getUTCMonth()/3)}return{format:function(specifier){var f=newFormat(specifier+="",formats);f.toString=function(){return specifier};return f},parse:function(specifier){var p=newParse(specifier+="",false);p.toString=function(){return specifier};return p},utcFormat:function(specifier){var f=newFormat(specifier+="",utcFormats);f.toString=function(){return specifier};return f},utcParse:function(specifier){var p=newParse(specifier+="",true);p.toString=function(){return specifier};return p}}}var pads={"-":"",_:" ",0:"0"},numberRe=/^\s*\d+/,percentRe=/^%/,requoteRe=/[\\^$*+?|[\]().{}]/g;function pad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string)}function requote(s){return s.replace(requoteRe,"\\$&")}function formatRe(names){return new RegExp("^(?:"+names.map(requote).join("|")+")","i")}function formatLookup(names){return new Map(names.map((name,i)=>[name.toLowerCase(),i]))}function parseWeekdayNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.w=+n[0],i+n[0].length):-1}function parseWeekdayNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.u=+n[0],i+n[0].length):-1}function parseWeekNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.U=+n[0],i+n[0].length):-1}function parseWeekNumberISO(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.V=+n[0],i+n[0].length):-1}function parseWeekNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.W=+n[0],i+n[0].length):-1}function parseFullYear(d,string,i){var n=numberRe.exec(string.slice(i,i+4));return n?(d.y=+n[0],i+n[0].length):-1}function parseYear(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.y=+n[0]+(+n[0]>68?1900:2e3),i+n[0].length):-1}function parseZone(d,string,i){var n=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i,i+6));return n?(d.Z=n[1]?0:-(n[2]+(n[3]||"00")),i+n[0].length):-1}function parseQuarter(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.q=n[0]*3-3,i+n[0].length):-1}function parseMonthNumber(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.m=n[0]-1,i+n[0].length):-1}function parseDayOfMonth(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.d=+n[0],i+n[0].length):-1}function parseDayOfYear(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.m=0,d.d=+n[0],i+n[0].length):-1}function parseHour24(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.H=+n[0],i+n[0].length):-1}function parseMinutes(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.M=+n[0],i+n[0].length):-1}function parseSeconds(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.S=+n[0],i+n[0].length):-1}function parseMilliseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.L=+n[0],i+n[0].length):-1}function parseMicroseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+6));return n?(d.L=Math.floor(n[0]/1e3),i+n[0].length):-1}function parseLiteralPercent(d,string,i){var n=percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1}function parseUnixTimestamp(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.Q=+n[0],i+n[0].length):-1}function parseUnixTimestampSeconds(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.s=+n[0],i+n[0].length):-1}function formatDayOfMonth(d,p){return pad(d.getDate(),p,2)}function formatHour24(d,p){return pad(d.getHours(),p,2)}function formatHour12(d,p){return pad(d.getHours()%12||12,p,2)}function formatDayOfYear(d,p){return pad(1+timeDay.count(timeYear(d),d),p,3)}function formatMilliseconds(d,p){return pad(d.getMilliseconds(),p,3)}function formatMicroseconds(d,p){return formatMilliseconds(d,p)+"000"}function formatMonthNumber(d,p){return pad(d.getMonth()+1,p,2)}function formatMinutes(d,p){return pad(d.getMinutes(),p,2)}function formatSeconds(d,p){return pad(d.getSeconds(),p,2)}function formatWeekdayNumberMonday(d){var day=d.getDay();return day===0?7:day}function formatWeekNumberSunday(d,p){return pad(timeSunday.count(timeYear(d)-1,d),p,2)}function dISO(d){var day=d.getDay();return day>=4||day===0?timeThursday(d):timeThursday.ceil(d)}function formatWeekNumberISO(d,p){d=dISO(d);return pad(timeThursday.count(timeYear(d),d)+(timeYear(d).getDay()===4),p,2)}function formatWeekdayNumberSunday(d){return d.getDay()}function formatWeekNumberMonday(d,p){return pad(timeMonday.count(timeYear(d)-1,d),p,2)}function formatYear(d,p){return pad(d.getFullYear()%100,p,2)}function formatYearISO(d,p){d=dISO(d);return pad(d.getFullYear()%100,p,2)}function formatFullYear(d,p){return pad(d.getFullYear()%1e4,p,4)}function formatFullYearISO(d,p){var day=d.getDay();d=day>=4||day===0?timeThursday(d):timeThursday.ceil(d);return pad(d.getFullYear()%1e4,p,4)}function formatZone(d){var z=d.getTimezoneOffset();return(z>0?"-":(z*=-1,"+"))+pad(z/60|0,"0",2)+pad(z%60,"0",2)}function formatUTCDayOfMonth(d,p){return pad(d.getUTCDate(),p,2)}function formatUTCHour24(d,p){return pad(d.getUTCHours(),p,2)}function formatUTCHour12(d,p){return pad(d.getUTCHours()%12||12,p,2)}function formatUTCDayOfYear(d,p){return pad(1+utcDay.count(utcYear(d),d),p,3)}function formatUTCMilliseconds(d,p){return pad(d.getUTCMilliseconds(),p,3)}function formatUTCMicroseconds(d,p){return formatUTCMilliseconds(d,p)+"000"}function formatUTCMonthNumber(d,p){return pad(d.getUTCMonth()+1,p,2)}function formatUTCMinutes(d,p){return pad(d.getUTCMinutes(),p,2)}function formatUTCSeconds(d,p){return pad(d.getUTCSeconds(),p,2)}function formatUTCWeekdayNumberMonday(d){var dow=d.getUTCDay();return dow===0?7:dow}function formatUTCWeekNumberSunday(d,p){return pad(utcSunday.count(utcYear(d)-1,d),p,2)}function UTCdISO(d){var day=d.getUTCDay();return day>=4||day===0?utcThursday(d):utcThursday.ceil(d)}function formatUTCWeekNumberISO(d,p){d=UTCdISO(d);return pad(utcThursday.count(utcYear(d),d)+(utcYear(d).getUTCDay()===4),p,2)}function formatUTCWeekdayNumberSunday(d){return d.getUTCDay()}function formatUTCWeekNumberMonday(d,p){return pad(utcMonday.count(utcYear(d)-1,d),p,2)}function formatUTCYear(d,p){return pad(d.getUTCFullYear()%100,p,2)}function formatUTCYearISO(d,p){d=UTCdISO(d);return pad(d.getUTCFullYear()%100,p,2)}function formatUTCFullYear(d,p){return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCFullYearISO(d,p){var day=d.getUTCDay();d=day>=4||day===0?utcThursday(d):utcThursday.ceil(d);return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCZone(){return"+0000"}function formatLiteralPercent(){return"%"}function formatUnixTimestamp(d){return+d}function formatUnixTimestampSeconds(d){return Math.floor(+d/1e3)}var locale;var timeFormat;var utcFormat;defaultLocale({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});function defaultLocale(definition){locale=formatLocale(definition);timeFormat=locale.format;locale.parse;utcFormat=locale.utcFormat;locale.utcParse;return locale}function date(t){return new Date(t)}function number(t){return t instanceof Date?+t:+new Date(+t)}function calendar(ticks,tickInterval,year,month,week,day,hour,minute,second,format){var scale=continuous$1(),invert=scale.invert,domain=scale.domain;var formatMillisecond=format(".%L"),formatSecond=format(":%S"),formatMinute=format("%I:%M"),formatHour=format("%I %p"),formatDay=format("%a %d"),formatWeek=format("%b %d"),formatMonth=format("%B"),formatYear=format("%Y");function tickFormat(date){return(second(date)<date?formatMillisecond:minute(date)<date?formatSecond:hour(date)<date?formatMinute:day(date)<date?formatHour:month(date)<date?week(date)<date?formatDay:formatWeek:year(date)<date?formatMonth:formatYear)(date)}scale.invert=function(y){return new Date(invert(y))};scale.domain=function(_){return arguments.length?domain(Array.from(_,number)):domain().map(date)};scale.ticks=function(interval){var d=domain();return ticks(d[0],d[d.length-1],interval==null?10:interval)};scale.tickFormat=function(count,specifier){return specifier==null?tickFormat:format(specifier)};scale.nice=function(interval){var d=domain();if(!interval||typeof interval.range!=="function")interval=tickInterval(d[0],d[d.length-1],interval==null?10:interval);return interval?domain(nice(d,interval)):scale};scale.copy=function(){return copy$1(scale,calendar(ticks,tickInterval,year,month,week,day,hour,minute,second,format))};return scale}function time(){return initRange.apply(calendar(timeTicks,timeTickInterval,timeYear,timeMonth,timeSunday,timeDay,timeHour,timeMinute,second,timeFormat).domain([new Date(2e3,0,1),new Date(2e3,0,2)]),arguments)}function utcTime(){return initRange.apply(calendar(utcTicks,utcTickInterval,utcYear,utcMonth,utcSunday,utcDay,utcHour,utcMinute,second,utcFormat).domain([Date.UTC(2e3,0,1),Date.UTC(2e3,0,2)]),arguments)}function transformer$1(){var x0=0,x1=1,t0,t1,k10,transform,interpolator=identity$2,clamp=false,unknown;function scale(x){return x==null||isNaN(x=+x)?unknown:interpolator(k10===0?.5:(x=(transform(x)-t0)*k10,clamp?Math.max(0,Math.min(1,x)):x))}scale.domain=function(_){return arguments.length?([x0,x1]=_,t0=transform(x0=+x0),t1=transform(x1=+x1),k10=t0===t1?0:1/(t1-t0),scale):[x0,x1]};scale.clamp=function(_){return arguments.length?(clamp=!!_,scale):clamp};scale.interpolator=function(_){return arguments.length?(interpolator=_,scale):interpolator};function range(interpolate){return function(_){var r0,r1;return arguments.length?([r0,r1]=_,interpolator=interpolate(r0,r1),scale):[interpolator(0),interpolator(1)]}}scale.range=range(interpolate$1);scale.rangeRound=range(interpolateRound);scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};return function(t){transform=t,t0=t(x0),t1=t(x1),k10=t0===t1?0:1/(t1-t0);return scale}}function copy(source,target){return target.domain(source.domain()).interpolator(source.interpolator()).clamp(source.clamp()).unknown(source.unknown())}function sequential(){var scale=linearish(transformer$1()(identity$2));scale.copy=function(){return copy(scale,sequential())};return initInterpolator.apply(scale,arguments)}function sequentialLog(){var scale=loggish(transformer$1()).domain([1,10]);scale.copy=function(){return copy(scale,sequentialLog()).base(scale.base())};return initInterpolator.apply(scale,arguments)}function sequentialSymlog(){var scale=symlogish(transformer$1());scale.copy=function(){return copy(scale,sequentialSymlog()).constant(scale.constant())};return initInterpolator.apply(scale,arguments)}function sequentialPow(){var scale=powish(transformer$1());scale.copy=function(){return copy(scale,sequentialPow()).exponent(scale.exponent())};return initInterpolator.apply(scale,arguments)}function sequentialSqrt(){return sequentialPow.apply(null,arguments).exponent(.5)}function transformer(){var x0=0,x1=.5,x2=1,s=1,t0,t1,t2,k10,k21,interpolator=identity$2,transform,clamp=false,unknown;function scale(x){return isNaN(x=+x)?unknown:(x=.5+((x=+transform(x))-t1)*(s*x<s*t1?k10:k21),interpolator(clamp?Math.max(0,Math.min(1,x)):x))}scale.domain=function(_){return arguments.length?([x0,x1,x2]=_,t0=transform(x0=+x0),t1=transform(x1=+x1),t2=transform(x2=+x2),k10=t0===t1?0:.5/(t1-t0),k21=t1===t2?0:.5/(t2-t1),s=t1<t0?-1:1,scale):[x0,x1,x2]};scale.clamp=function(_){return arguments.length?(clamp=!!_,scale):clamp};scale.interpolator=function(_){return arguments.length?(interpolator=_,scale):interpolator};function range(interpolate){return function(_){var r0,r1,r2;return arguments.length?([r0,r1,r2]=_,interpolator=piecewise(interpolate,[r0,r1,r2]),scale):[interpolator(0),interpolator(.5),interpolator(1)]}}scale.range=range(interpolate$1);scale.rangeRound=range(interpolateRound);scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};return function(t){transform=t,t0=t(x0),t1=t(x1),t2=t(x2),k10=t0===t1?0:.5/(t1-t0),k21=t1===t2?0:.5/(t2-t1),s=t1<t0?-1:1;return scale}}function diverging(){var scale=linearish(transformer()(identity$2));scale.copy=function(){return copy(scale,diverging())};return initInterpolator.apply(scale,arguments)}function divergingLog(){var scale=loggish(transformer()).domain([.1,1,10]);scale.copy=function(){return copy(scale,divergingLog()).base(scale.base())};return initInterpolator.apply(scale,arguments)}function divergingSymlog(){var scale=symlogish(transformer());scale.copy=function(){return copy(scale,divergingSymlog()).constant(scale.constant())};return initInterpolator.apply(scale,arguments)}function divergingPow(){var scale=powish(transformer());scale.copy=function(){return copy(scale,divergingPow()).exponent(scale.exponent())};return initInterpolator.apply(scale,arguments)}function divergingSqrt(){return divergingPow.apply(null,arguments).exponent(.5)}function band(){const scale=ordinal().unknown(undefined),domain=scale.domain,ordinalRange=scale.range;let range$1=[0,1],step,bandwidth,round=false,paddingInner=0,paddingOuter=0,align=.5;delete scale.unknown;function rescale(){const n=domain().length,reverse=range$1[1]<range$1[0],stop=range$1[1-reverse],space=bandSpace(n,paddingInner,paddingOuter);let start=range$1[reverse-0];step=(stop-start)/(space||1);if(round){step=Math.floor(step)}start+=(stop-start-step*(n-paddingInner))*align;bandwidth=step*(1-paddingInner);if(round){start=Math.round(start);bandwidth=Math.round(bandwidth)}const values=range(n).map(i=>start+step*i);return ordinalRange(reverse?values.reverse():values)}scale.domain=function(_){if(arguments.length){domain(_);return rescale()}else{return domain()}};scale.range=function(_){if(arguments.length){range$1=[+_[0],+_[1]];return rescale()}else{return range$1.slice()}};scale.rangeRound=function(_){range$1=[+_[0],+_[1]];round=true;return rescale()};scale.bandwidth=function(){return bandwidth};scale.step=function(){return step};scale.round=function(_){if(arguments.length){round=!!_;return rescale()}else{return round}};scale.padding=function(_){if(arguments.length){paddingOuter=Math.max(0,Math.min(1,_));paddingInner=paddingOuter;return rescale()}else{return paddingInner}};scale.paddingInner=function(_){if(arguments.length){paddingInner=Math.max(0,Math.min(1,_));return rescale()}else{return paddingInner}};scale.paddingOuter=function(_){if(arguments.length){paddingOuter=Math.max(0,Math.min(1,_));return rescale()}else{return paddingOuter}};scale.align=function(_){if(arguments.length){align=Math.max(0,Math.min(1,_));return rescale()}else{return align}};scale.invertRange=function(_){if(_[0]==null||_[1]==null)return;const reverse=range$1[1]<range$1[0],values=reverse?ordinalRange().reverse():ordinalRange(),n=values.length-1;let lo=+_[0],hi=+_[1],a,b,t;if(lo!==lo||hi!==hi)return;if(hi<lo){t=lo;lo=hi;hi=t}if(hi<values[0]||lo>range$1[1-reverse])return;a=Math.max(0,bisectRight(values,lo)-1);b=lo===hi?a:bisectRight(values,hi)-1;if(lo-values[a]>bandwidth+1e-10)++a;if(reverse){t=a;a=n-b;b=n-t}return a>b?undefined:domain().slice(a,b+1)};scale.invert=function(_){const value=scale.invertRange([_,_]);return value?value[0]:value};scale.copy=function(){return band().domain(domain()).range(range$1).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align)};return rescale()}function pointish(scale){const copy=scale.copy;scale.padding=scale.paddingOuter;delete scale.paddingInner;scale.copy=function(){return pointish(copy())};return scale}function point(){return pointish(band().paddingInner(1))}var map=Array.prototype.map;function numbers(_){return map.call(_,vegaUtil.toNumber)}const slice=Array.prototype.slice;function scaleBinOrdinal(){let domain=[],range=[];function scale(x){return x==null||x!==x?undefined:range[(bisectRight(domain,x)-1)%range.length]}scale.domain=function(_){if(arguments.length){domain=numbers(_);return scale}else{return domain.slice()}};scale.range=function(_){if(arguments.length){range=slice.call(_);return scale}else{return range.slice()}};scale.tickFormat=function(count,specifier){return tickFormat$1(domain[0],vegaUtil.peek(domain),count==null?10:count,specifier)};scale.copy=function(){return scaleBinOrdinal().domain(scale.domain()).range(scale.range())};return scale}const scales=new Map;const VEGA_SCALE=Symbol("vega_scale");function registerScale(scale){scale[VEGA_SCALE]=true;return scale}function isRegisteredScale(scale){return scale&&scale[VEGA_SCALE]===true}function create(type,constructor,metadata){const ctr=function scale(){const s=constructor();if(!s.invertRange){s.invertRange=s.invert?invertRange(s):s.invertExtent?invertRangeExtent(s):undefined}s.type=type;return registerScale(s)};ctr.metadata=vegaUtil.toSet(vegaUtil.array(metadata));return ctr}function scale(type,scale,metadata){if(arguments.length>1){scales.set(type,create(type,scale,metadata));return this}else{return isValidScaleType(type)?scales.get(type):undefined}}scale(Identity,identity);scale(Linear,linear,Continuous);scale(Log,log,[Continuous,Log]);scale(Pow,pow,Continuous);scale(Sqrt,sqrt,Continuous);scale(Symlog,symlog,Continuous);scale(Time,time,[Continuous,Temporal]);scale(UTC,utcTime,[Continuous,Temporal]);scale(Sequential,sequential,[Continuous,Interpolating]);scale(`${Sequential}-${Linear}`,sequential,[Continuous,Interpolating]);scale(`${Sequential}-${Log}`,sequentialLog,[Continuous,Interpolating,Log]);scale(`${Sequential}-${Pow}`,sequentialPow,[Continuous,Interpolating]);scale(`${Sequential}-${Sqrt}`,sequentialSqrt,[Continuous,Interpolating]);scale(`${Sequential}-${Symlog}`,sequentialSymlog,[Continuous,Interpolating]);scale(`${Diverging}-${Linear}`,diverging,[Continuous,Interpolating]);scale(`${Diverging}-${Log}`,divergingLog,[Continuous,Interpolating,Log]);scale(`${Diverging}-${Pow}`,divergingPow,[Continuous,Interpolating]);scale(`${Diverging}-${Sqrt}`,divergingSqrt,[Continuous,Interpolating]);scale(`${Diverging}-${Symlog}`,divergingSymlog,[Continuous,Interpolating]);scale(Quantile,quantile,[Discretizing,Quantile]);scale(Quantize,quantize,Discretizing);scale(Threshold,threshold,Discretizing);scale(BinOrdinal,scaleBinOrdinal,[Discrete,Discretizing]);scale(Ordinal,ordinal,Discrete);scale(Band,band,Discrete);scale(Point,point,Discrete);function isValidScaleType(type){return scales.has(type)}function hasType(key,type){const s=scales.get(key);return s&&s.metadata[type]}function isContinuous(key){return hasType(key,Continuous)}function isDiscrete(key){return hasType(key,Discrete)}function isDiscretizing(key){return hasType(key,Discretizing)}function isLogarithmic(key){return hasType(key,Log)}function isTemporal(key){return hasType(key,Temporal)}function isInterpolating(key){return hasType(key,Interpolating)}function isQuantile(key){return hasType(key,Quantile)}const scaleProps=["clamp","base","constant","exponent"];function interpolateRange(interpolator,range){const start=range[0],span=vegaUtil.peek(range)-start;return function(i){return interpolator(start+i*span)}}function interpolateColors(colors,type,gamma){return piecewise(interpolate(type||"rgb",gamma),colors)}function quantizeInterpolator(interpolator,count){const samples=new Array(count),n=count+1;for(let i=0;i<count;)samples[i]=interpolator(++i/n);return samples}function scaleCopy(scale){const t=scale.type,s=scale.copy();s.type=t;return s}function scaleFraction(scale$1,min,max){const delta=max-min;let i,t,s;if(!delta||!Number.isFinite(delta)){return vegaUtil.constant(.5)}else{i=(t=scale$1.type).indexOf("-");t=i<0?t:t.slice(i+1);s=scale(t)().domain([min,max]).range([0,1]);scaleProps.forEach(m=>scale$1[m]?s[m](scale$1[m]()):0);return s}}function interpolate(type,gamma){const interp=$[method(type)];return gamma!=null&&interp&&interp.gamma?interp.gamma(gamma):interp}function method(type){return"interpolate"+type.toLowerCase().split("-").map(s=>s[0].toUpperCase()+s.slice(1)).join("")}function colors$1(specifier){var n=specifier.length/6|0,colors=new Array(n),i=0;while(i<n)colors[i]="#"+specifier.slice(i*6,++i*6);return colors}var schemeCategory10=colors$1("1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf");var schemeAccent=colors$1("7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666");var schemeDark2=colors$1("1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666");var schemeObservable10=colors$1("4269d0efb118ff725c6cc5b03ca951ff8ab7a463f297bbf59c6b4e9498a0");var schemePaired=colors$1("a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928");var schemePastel1=colors$1("fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2");var schemePastel2=colors$1("b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc");var schemeSet1=colors$1("e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999");var schemeSet2=colors$1("66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3");var schemeSet3=colors$1("8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f");const continuous={blues:"cfe1f2bed8eca8cee58fc1de74b2d75ba3cf4592c63181bd206fb2125ca40a4a90",greens:"d3eecdc0e6baabdda594d3917bc77d60ba6c46ab5e329a512089430e7735036429",greys:"e2e2e2d4d4d4c4c4c4b1b1b19d9d9d8888887575756262624d4d4d3535351e1e1e",oranges:"fdd8b3fdc998fdb87bfda55efc9244f87f2cf06b18e4580bd14904b93d029f3303",purples:"e2e1efd4d4e8c4c5e0b4b3d6a3a0cc928ec3827cb97566ae684ea25c3696501f8c",reds:"fdc9b4fcb49afc9e80fc8767fa7051f6573fec3f2fdc2a25c81b1db21218970b13",blueGreen:"d5efedc1e8e0a7ddd18bd2be70c6a958ba9144ad77319c5d2089460e7736036429",bluePurple:"ccddecbad0e4a8c2dd9ab0d4919cc98d85be8b6db28a55a6873c99822287730f71",greenBlue:"d3eecec5e8c3b1e1bb9bd8bb82cec269c2ca51b2cd3c9fc7288abd1675b10b60a1",orangeRed:"fddcaffdcf9bfdc18afdad77fb9562f67d53ee6545e24932d32d1ebf130da70403",purpleBlue:"dbdaebc8cee4b1c3de97b7d87bacd15b9fc93a90c01e7fb70b70ab056199045281",purpleBlueGreen:"dbd8eac8cee4b0c3de93b7d872acd1549fc83892bb1c88a3097f8702736b016353",purpleRed:"dcc9e2d3b3d7ce9eccd186c0da6bb2e14da0e23189d91e6fc61159ab07498f023a",redPurple:"fccfccfcbec0faa9b8f98faff571a5ec539ddb3695c41b8aa908808d0179700174",yellowGreen:"e4f4acd1eca0b9e2949ed68880c97c62bb6e47aa5e3297502083440e723b036034",yellowOrangeBrown:"feeaa1fedd84fecc63feb746fca031f68921eb7215db5e0bc54c05ab3d038f3204",yellowOrangeRed:"fee087fed16ffebd59fea849fd903efc7335f9522bee3423de1b20ca0b22af0225",blueOrange:"134b852f78b35da2cb9dcae1d2e5eff2f0ebfce0bafbbf74e8932fc5690d994a07",brownBlueGreen:"704108a0651ac79548e3c78af3e6c6eef1eac9e9e48ed1c74da79e187a72025147",purpleGreen:"5b1667834792a67fb6c9aed3e6d6e8eff0efd9efd5aedda971bb75368e490e5e29",purpleOrange:"4114696647968f83b7b9b4d6dadbebf3eeeafce0bafbbf74e8932fc5690d994a07",redBlue:"8c0d25bf363adf745ef4ae91fbdbc9f2efeed2e5ef9dcae15da2cb2f78b3134b85",redGrey:"8c0d25bf363adf745ef4ae91fcdccbfaf4f1e2e2e2c0c0c0969696646464343434",yellowGreenBlue:"eff9bddbf1b4bde5b594d5b969c5be45b4c22c9ec02182b82163aa23479c1c3185",redYellowBlue:"a50026d4322cf16e43fcac64fedd90faf8c1dcf1ecabd6e875abd04a74b4313695",redYellowGreen:"a50026d4322cf16e43fcac63fedd8df9f7aed7ee8ea4d86e64bc6122964f006837",pinkYellowGreen:"8e0152c0267edd72adf0b3d6faddedf5f3efe1f2cab6de8780bb474f9125276419",spectral:"9e0142d13c4bf0704afcac63fedd8dfbf8b0e0f3a1a9dda269bda94288b55e4fa2",viridis:"440154470e61481a6c482575472f7d443a834144873d4e8a39568c35608d31688e2d708e2a788e27818e23888e21918d1f988b1fa08822a8842ab07f35b77943bf7154c56866cc5d7ad1518fd744a5db36bcdf27d2e21be9e51afde725",magma:"0000040404130b0924150e3720114b2c11603b0f704a107957157e651a80721f817f24828c29819a2e80a8327db6377ac43c75d1426fde4968e95462f1605df76f5cfa7f5efc8f65fe9f6dfeaf78febf84fece91fddea0fcedaffcfdbf",inferno:"0000040403130c0826170c3b240c4f330a5f420a68500d6c5d126e6b176e781c6d86216b932667a12b62ae305cbb3755c73e4cd24644dd513ae65c30ed6925f3771af8850ffb9506fca50afcb519fac62df6d645f2e661f3f484fcffa4",plasma:"0d088723069033059742039d5002a25d01a66a00a87801a88405a7900da49c179ea72198b12a90ba3488c33d80cb4779d35171da5a69e16462e76e5bed7953f2834cf68f44fa9a3dfca636fdb32ffec029fcce25f9dc24f5ea27f0f921",cividis:"00205100235800265d002961012b65042e670831690d346b11366c16396d1c3c6e213f6e26426e2c456e31476e374a6e3c4d6e42506e47536d4c566d51586e555b6e5a5e6e5e616e62646f66676f6a6a706e6d717270717573727976737c79747f7c75827f758682768985778c8877908b78938e789691789a94789e9778a19b78a59e77a9a177aea575b2a874b6ab73bbaf71c0b26fc5b66dc9b96acebd68d3c065d8c462ddc85fe2cb5ce7cf58ebd355f0d652f3da4ff7de4cfae249fce647",rainbow:"6e40aa883eb1a43db3bf3cafd83fa4ee4395fe4b83ff576eff6659ff7847ff8c38f3a130e2b72fcfcc36bee044aff05b8ff4576ff65b52f6673af27828ea8d1ddfa319d0b81cbecb23abd82f96e03d82e14c6edb5a5dd0664dbf6e40aa",sinebow:"ff4040fc582af47218e78d0bd5a703bfbf00a7d5038de70b72f41858fc2a40ff402afc5818f4720be78d03d5a700bfbf03a7d50b8de71872f42a58fc4040ff582afc7218f48d0be7a703d5bf00bfd503a7e70b8df41872fc2a58ff4040",turbo:"23171b32204a3e2a71453493493eae4b49c54a53d7485ee44569ee4074f53c7ff8378af93295f72e9ff42ba9ef28b3e926bce125c5d925cdcf27d5c629dcbc2de3b232e9a738ee9d3ff39347f68950f9805afc7765fd6e70fe667cfd5e88fc5795fb51a1f84badf545b9f140c5ec3cd0e637dae034e4d931ecd12ef4c92bfac029ffb626ffad24ffa223ff9821ff8d1fff821dff771cfd6c1af76118f05616e84b14df4111d5380fcb2f0dc0260ab61f07ac1805a313029b0f00950c00910b00",browns:"eedbbdecca96e9b97ae4a865dc9856d18954c7784cc0673fb85536ad44339f3632",tealBlues:"bce4d89dd3d181c3cb65b3c245a2b9368fae347da0306a932c5985",teals:"bbdfdfa2d4d58ac9c975bcbb61b0af4da5a43799982b8b8c1e7f7f127273006667",warmGreys:"dcd4d0cec5c1c0b8b4b3aaa7a59c9998908c8b827f7e7673726866665c5a59504e",goldGreen:"f4d166d5ca60b6c35c98bb597cb25760a6564b9c533f8f4f33834a257740146c36",goldOrange:"f4d166f8be5cf8aa4cf5983bf3852aef701be2621fd65322c54923b142239e3a26",goldRed:"f4d166f6be59f9aa51fc964ef6834bee734ae56249db5247cf4244c43141b71d3e",lightGreyRed:"efe9e6e1dad7d5cbc8c8bdb9bbaea9cd967ddc7b43e15f19df4011dc000b",lightGreyTeal:"e4eaead6dcddc8ced2b7c2c7a6b4bc64b0bf22a6c32295c11f85be1876bc",lightMulti:"e0f1f2c4e9d0b0de9fd0e181f6e072f6c053f3993ef77440ef4a3c",lightOrange:"f2e7daf7d5baf9c499fab184fa9c73f68967ef7860e8645bde515bd43d5b",lightTealBlue:"e3e9e0c0dccf9aceca7abfc859afc0389fb9328dad2f7ca0276b95255988",darkBlue:"3232322d46681a5c930074af008cbf05a7ce25c0dd38daed50f3faffffff",darkGold:"3c3c3c584b37725e348c7631ae8b2bcfa424ecc31ef9de30fff184ffffff",darkGreen:"3a3a3a215748006f4d048942489e4276b340a6c63dd2d836ffeb2cffffaa",darkMulti:"3737371f5287197d8c29a86995ce3fffe800ffffff",darkRed:"3434347036339e3c38cc4037e75d1eec8620eeab29f0ce32ffeb2c"};const discrete={accent:schemeAccent,category10:schemeCategory10,category20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",category20b:"393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6",category20c:"3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9",dark2:schemeDark2,observable10:schemeObservable10,paired:schemePaired,pastel1:schemePastel1,pastel2:schemePastel2,set1:schemeSet1,set2:schemeSet2,set3:schemeSet3,tableau10:"4c78a8f58518e4575672b7b254a24beeca3bb279a2ff9da69d755dbab0ac",tableau20:"4c78a89ecae9f58518ffbf7954a24b88d27ab79a20f2cf5b43989483bcb6e45756ff9d9879706ebab0acd67195fcbfd2b279a2d6a5c99e765fd8b5a5"};function colors(palette){if(vegaUtil.isArray(palette))return palette;const n=palette.length/6|0,c=new Array(n);for(let i=0;i<n;){c[i]="#"+palette.slice(i*6,++i*6)}return c}function apply(_,f){for(const k in _)scheme(k,f(_[k]))}const schemes={};apply(discrete,colors);apply(continuous,_=>interpolateColors(colors(_)));function scheme(name,scheme){name=name&&name.toLowerCase();if(arguments.length>1){schemes[name]=scheme;return this}else{return schemes[name]}}const SymbolLegend="symbol";const DiscreteLegend="discrete";const GradientLegend="gradient";const defaultFormatter=value=>vegaUtil.isArray(value)?value.map(v=>String(v)):String(value);const ascending=(a,b)=>a[1]-b[1];const descending=(a,b)=>b[1]-a[1];function tickCount(scale,count,minStep){let step;if(vegaUtil.isNumber(count)){if(scale.bins){count=Math.max(count,scale.bins.length)}if(minStep!=null){count=Math.min(count,Math.floor(vegaUtil.span(scale.domain())/minStep||1)+1)}}if(vegaUtil.isObject(count)){step=count.step;count=count.interval}if(vegaUtil.isString(count)){count=scale.type===Time?vegaTime.timeInterval(count):scale.type==UTC?vegaTime.utcInterval(count):vegaUtil.error("Only time and utc scales accept interval strings.");if(step)count=count.every(step)}return count}function validTicks(scale,ticks,count){let range=scale.range(),lo=range[0],hi=vegaUtil.peek(range),cmp=ascending;if(lo>hi){range=hi;hi=lo;lo=range;cmp=descending}lo=Math.floor(lo);hi=Math.ceil(hi);ticks=ticks.map(v=>[v,scale(v)]).filter(_=>lo<=_[1]&&_[1]<=hi).sort(cmp).map(_=>_[0]);if(count>0&&ticks.length>1){const endpoints=[ticks[0],vegaUtil.peek(ticks)];while(ticks.length>count&&ticks.length>=3){ticks=ticks.filter((_,i)=>!(i%2))}if(ticks.length<3){ticks=endpoints}}return ticks}function tickValues(scale,count){return scale.bins?validTicks(scale,scale.bins,count):scale.ticks?scale.ticks(count):scale.domain()}function tickFormat(locale,scale,count,specifier,formatType,noSkip){const type=scale.type;let format=defaultFormatter;if(type===Time||formatType===Time){format=locale.timeFormat(specifier)}else if(type===UTC||formatType===UTC){format=locale.utcFormat(specifier)}else if(isLogarithmic(type)){const varfmt=locale.formatFloat(specifier);if(noSkip||scale.bins){format=varfmt}else{const test=tickLog(scale,count,false);format=_=>test(_)?varfmt(_):""}}else if(scale.tickFormat){const d=scale.domain();format=locale.formatSpan(d[0],d[d.length-1],count,specifier)}else if(specifier){format=locale.format(specifier)}return format}function tickLog(scale,count,values){const ticks=tickValues(scale,count),base=scale.base(),logb=Math.log(base),k=Math.max(1,base*count/ticks.length);const test=d=>{let i=d/Math.pow(base,Math.round(Math.log(d)/logb));if(i*base<base-.5)i*=base;return i<=k};return values?ticks.filter(test):test}const symbols={[Quantile]:"quantiles",[Quantize]:"thresholds",[Threshold]:"domain"};const formats={[Quantile]:"quantiles",[Quantize]:"domain"};function labelValues(scale,count){return scale.bins?binValues(scale.bins):scale.type===Log?tickLog(scale,count,true):symbols[scale.type]?thresholdValues(scale[symbols[scale.type]]()):tickValues(scale,count)}function thresholdFormat(locale,scale,specifier){const _=scale[formats[scale.type]](),n=_.length;let d=n>1?_[1]-_[0]:_[0],i;for(i=1;i<n;++i){d=Math.min(d,_[i]-_[i-1])}return locale.formatSpan(0,d,3*10,specifier)}function thresholdValues(thresholds){const values=[-Infinity].concat(thresholds);values.max=+Infinity;return values}function binValues(bins){const values=bins.slice(0,-1);values.max=vegaUtil.peek(bins);return values}const isDiscreteRange=scale=>symbols[scale.type]||scale.bins;function labelFormat(locale,scale,count,type,specifier,formatType,noSkip){const format=formats[scale.type]&&formatType!==Time&&formatType!==UTC?thresholdFormat(locale,scale,specifier):tickFormat(locale,scale,count,specifier,formatType,noSkip);return type===SymbolLegend&&isDiscreteRange(scale)?formatRange(format):type===DiscreteLegend?formatDiscrete(format):formatPoint(format)}const formatRange=format=>(value,index,array)=>{const limit=get(array[index+1],get(array.max,+Infinity)),lo=formatValue(value,format),hi=formatValue(limit,format);return lo&&hi?lo+" – "+hi:hi?"< "+hi:"≥ "+lo};const get=(value,dflt)=>value!=null?value:dflt;const formatDiscrete=format=>(value,index)=>index?format(value):null;const formatPoint=format=>value=>format(value);const formatValue=(value,format)=>Number.isFinite(value)?format(value):null;function labelFraction(scale){const domain=scale.domain(),count=domain.length-1;let lo=+domain[0],hi=+vegaUtil.peek(domain),span=hi-lo;if(scale.type===Threshold){const adjust=count?span/count:.1;lo-=adjust;hi+=adjust;span=hi-lo}return value=>(value-lo)/span}function format(locale,scale,specifier,formatType){const type=formatType||scale.type;if(vegaUtil.isString(specifier)&&isTemporal(type)){specifier=specifier.replace(/%a/g,"%A").replace(/%b/g,"%B")}return!specifier&&type===Time?locale.timeFormat("%A, %d %B %Y, %X"):!specifier&&type===UTC?locale.utcFormat("%A, %d %B %Y, %X UTC"):labelFormat(locale,scale,5,null,specifier,formatType,true)}function domainCaption(locale,scale,opt){opt=opt||{};const max=Math.max(3,opt.maxlen||7),fmt=format(locale,scale,opt.format,opt.formatType);if(isDiscretizing(scale.type)){const v=labelValues(scale).slice(1).map(fmt),n=v.length;return`${n} boundar${n===1?"y":"ies"}: ${v.join(", ")}`}else if(isDiscrete(scale.type)){const d=scale.domain(),n=d.length,v=n>max?d.slice(0,max-2).map(fmt).join(", ")+", ending with "+d.slice(-1).map(fmt):d.map(fmt).join(", ");return`${n} value${n===1?"":"s"}: ${v}`}else{const d=scale.domain();return`values from ${fmt(d[0])} to ${fmt(vegaUtil.peek(d))}`}}exports.Band=Band;exports.BinOrdinal=BinOrdinal;exports.DiscreteLegend=DiscreteLegend;exports.Diverging=Diverging;exports.GradientLegend=GradientLegend;exports.Identity=Identity;exports.Linear=Linear;exports.Log=Log;exports.Ordinal=Ordinal;exports.Point=Point;exports.Pow=Pow;exports.Quantile=Quantile;exports.Quantize=Quantize;exports.Sequential=Sequential;exports.Sqrt=Sqrt;exports.SymbolLegend=SymbolLegend;exports.Symlog=Symlog;exports.Threshold=Threshold;exports.Time=Time;exports.UTC=UTC;exports.bandSpace=bandSpace;exports.domainCaption=domainCaption;exports.interpolate=interpolate;exports.interpolateColors=interpolateColors;exports.interpolateRange=interpolateRange;exports.isContinuous=isContinuous;exports.isDiscrete=isDiscrete;exports.isDiscretizing=isDiscretizing;exports.isInterpolating=isInterpolating;exports.isLogarithmic=isLogarithmic;exports.isQuantile=isQuantile;exports.isRegisteredScale=isRegisteredScale;exports.isTemporal=isTemporal;exports.isValidScaleType=isValidScaleType;exports.labelFormat=labelFormat;exports.labelFraction=labelFraction;exports.labelValues=labelValues;exports.quantizeInterpolator=quantizeInterpolator;exports.registerScale=registerScale;exports.scale=scale;exports.scaleCopy=scaleCopy;exports.scaleFraction=scaleFraction;exports.scaleImplicit=implicit;exports.scheme=scheme;exports.tickCount=tickCount;exports.tickFormat=tickFormat;exports.tickValues=tickValues;exports.validTicks=validTicks}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function*numbers$1(values,valueof){if(valueof==null){for(let value of values){if(value!=null&&value!==""&&(value=+value)>=value){yield value}}}else{let index=-1;for(let value of values){value=valueof(value,++index,values);if(value!=null&&value!==""&&(value=+value)>=value){yield value}}}}function ascending(a,b){return a==null||b==null?NaN:a<b?-1:a>b?1:a>=b?0:NaN}function number(x){return x===null?NaN:+x}function*numbers(values,valueof){if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){yield value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){yield value}}}}function variance(values,valueof){let count=0;let delta;let mean=0;let sum=0;if(valueof===undefined){for(let value of values){if(value!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(value=+value)>=value){delta=value-mean;mean+=delta/++count;sum+=delta*(value-mean)}}}if(count>1)return sum/(count-1)}function deviation(values,valueof){const v=variance(values,valueof);return v?Math.sqrt(v):v}function compareDefined(compare=ascending){if(compare===ascending)return ascendingDefined;if(typeof compare!=="function")throw new TypeError("compare is not a function");return(a,b)=>{const x=compare(a,b);if(x||x===0)return x;return(compare(b,b)===0)-(compare(a,a)===0)}}function ascendingDefined(a,b){return(a==null||!(a>=a))-(b==null||!(b>=b))||(a<b?-1:a>b?1:0)}function max(values,valueof){let max;if(valueof===undefined){for(const value of values){if(value!=null&&(max<value||max===undefined&&value>=value)){max=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(max<value||max===undefined&&value>=value)){max=value}}}return max}function min(values,valueof){let min;if(valueof===undefined){for(const value of values){if(value!=null&&(min>value||min===undefined&&value>=value)){min=value}}}else{let index=-1;for(let value of values){if((value=valueof(value,++index,values))!=null&&(min>value||min===undefined&&value>=value)){min=value}}}return min}function quickselect(array,k,left=0,right=Infinity,compare){k=Math.floor(k);left=Math.floor(Math.max(0,left));right=Math.floor(Math.min(array.length-1,right));if(!(left<=k&&k<=right))return array;compare=compare===undefined?ascendingDefined:compareDefined(compare);while(right>left){if(right-left>600){const n=right-left+1;const m=k-left+1;const z=Math.log(n);const s=.5*Math.exp(2*z/3);const sd=.5*Math.sqrt(z*s*(n-s)/n)*(m-n/2<0?-1:1);const newLeft=Math.max(left,Math.floor(k-m*s/n+sd));const newRight=Math.min(right,Math.floor(k+(n-m)*s/n+sd));quickselect(array,k,newLeft,newRight,compare)}const t=array[k];let i=left;let j=right;swap(array,left,k);if(compare(array[right],t)>0)swap(array,left,right);while(i<j){swap(array,i,j),++i,--j;while(compare(array[i],t)<0)++i;while(compare(array[j],t)>0)--j}if(compare(array[left],t)===0)swap(array,left,j);else++j,swap(array,j,right);if(j<=k)left=j+1;if(k<=j)right=j-1}return array}function swap(array,i,j){const t=array[i];array[i]=array[j];array[j]=t}function quantile(values,p,valueof){values=Float64Array.from(numbers(values,valueof));if(!(n=values.length)||isNaN(p=+p))return;if(p<=0||n<2)return min(values);if(p>=1)return max(values);var n,i=(n-1)*p,i0=Math.floor(i),value0=max(quickselect(values,i0).subarray(0,i0+1)),value1=min(values.subarray(i0+1));return value0+(value1-value0)*(i-i0)}function quantileSorted(values,p,valueof=number){if(!(n=values.length)||isNaN(p=+p))return;if(p<=0||n<2)return+valueof(values[0],0,values);if(p>=1)return+valueof(values[n-1],n-1,values);var n,i=(n-1)*p,i0=Math.floor(i),value0=+valueof(values[i0],i0,values),value1=+valueof(values[i0+1],i0+1,values);return value0+(value1-value0)*(i-i0)}function median(values,valueof){return quantile(values,.5,valueof)}function quantiles(array,p,f){const values=Float64Array.from(numbers$1(array,f));values.sort(ascending);return p.map(_=>quantileSorted(values,_))}function quartiles(array,f){return quantiles(array,[.25,.5,.75],f)}function estimateBandwidth(array,f){const n=array.length,d=deviation(array,f),q=quartiles(array,f),h=(q[2]-q[0])/1.34,v=Math.min(d,h)||d||Math.abs(q[0])||1;return 1.06*v*Math.pow(n,-.2)}function bin(_){const maxb=_.maxbins||20,base=_.base||10,logb=Math.log(base),div=_.divide||[5,2];let min=_.extent[0],max=_.extent[1],step,level,minstep,v,i,n;const span=_.span||max-min||Math.abs(min)||1;if(_.step){step=_.step}else if(_.steps){v=span/maxb;for(i=0,n=_.steps.length;i<n&&_.steps[i]<v;++i);step=_.steps[Math.max(0,i-1)]}else{level=Math.ceil(Math.log(maxb)/logb);minstep=_.minstep||0;step=Math.max(minstep,Math.pow(base,Math.round(Math.log(span)/logb)-level));while(Math.ceil(span/step)>maxb){step*=base}for(i=0,n=div.length;i<n;++i){v=step/div[i];if(v>=minstep&&span/v<=maxb)step=v}}v=Math.log(step);const precision=v>=0?0:~~(-v/logb)+1,eps=Math.pow(base,-precision-1);if(_.nice||_.nice===undefined){v=Math.floor(min/step+eps)*step;min=min<v?v-step:v;max=Math.ceil(max/step)*step}return{start:min,stop:max===min?min+step:max,step:step}}exports.random=Math.random;function setRandom(r){exports.random=r}function bootstrapCI(array,samples,alpha,f){if(!array.length)return[undefined,undefined];const values=Float64Array.from(numbers$1(array,f)),n=values.length,m=samples;let a,i,j,mu;for(j=0,mu=Array(m);j<m;++j){for(a=0,i=0;i<n;++i){a+=values[~~(exports.random()*n)]}mu[j]=a/n}mu.sort(ascending);return[quantile(mu,alpha/2),quantile(mu,1-alpha/2)]}function dotbin(array,step,smooth,f){f=f||(_=>_);const n=array.length,v=new Float64Array(n);let i=0,j=1,a=f(array[0]),b=a,w=a+step,x;for(;j<n;++j){x=f(array[j]);if(x>=w){b=(a+b)/2;for(;i<j;++i)v[i]=b;w=x+step;a=x}b=x}b=(a+b)/2;for(;i<j;++i)v[i]=b;return smooth?smoothing(v,step+step/4):v}function smoothing(v,thresh){const n=v.length;let a=0,b=1,c,d;while(v[a]===v[b])++b;while(b<n){c=b+1;while(v[b]===v[c])++c;if(v[b]-v[b-1]<thresh){d=b+(a+c-b-b>>1);while(d<b)v[d++]=v[b];while(d>b)v[d--]=v[a]}a=b;b=c}return v}function lcg(seed){return function(){seed=(1103515245*seed+12345)%2147483647;return seed/2147483647}}function integer(min,max){if(max==null){max=min;min=0}let a,b,d;const dist={min(_){if(arguments.length){a=_||0;d=b-a;return dist}else{return a}},max(_){if(arguments.length){b=_||0;d=b-a;return dist}else{return b}},sample(){return a+Math.floor(d*exports.random())},pdf(x){return x===Math.floor(x)&&x>=a&&x<b?1/d:0},cdf(x){const v=Math.floor(x);return v<a?0:v>=b?1:(v-a+1)/d},icdf(p){return p>=0&&p<=1?a-1+Math.floor(p*d):NaN}};return dist.min(min).max(max)}const SQRT2PI=Math.sqrt(2*Math.PI);const SQRT2=Math.SQRT2;let nextSample=NaN;function sampleNormal(mean,stdev){mean=mean||0;stdev=stdev==null?1:stdev;let x=0,y=0,rds,c;if(nextSample===nextSample){x=nextSample;nextSample=NaN}else{do{x=exports.random()*2-1;y=exports.random()*2-1;rds=x*x+y*y}while(rds===0||rds>1);c=Math.sqrt(-2*Math.log(rds)/rds);x*=c;nextSample=y*c}return mean+x*stdev}function densityNormal(value,mean,stdev){stdev=stdev==null?1:stdev;const z=(value-(mean||0))/stdev;return Math.exp(-.5*z*z)/(stdev*SQRT2PI)}function cumulativeNormal(value,mean,stdev){mean=mean||0;stdev=stdev==null?1:stdev;const z=(value-mean)/stdev,Z=Math.abs(z);let cd;if(Z>37){cd=0}else{const exp=Math.exp(-Z*Z/2);let sum;if(Z<7.07106781186547){sum=.0352624965998911*Z+.700383064443688;sum=sum*Z+6.37396220353165;sum=sum*Z+33.912866078383;sum=sum*Z+112.079291497871;sum=sum*Z+221.213596169931;sum=sum*Z+220.206867912376;cd=exp*sum;sum=.0883883476483184*Z+1.75566716318264;sum=sum*Z+16.064177579207;sum=sum*Z+86.7807322029461;sum=sum*Z+296.564248779674;sum=sum*Z+637.333633378831;sum=sum*Z+793.826512519948;sum=sum*Z+440.413735824752;cd=cd/sum}else{sum=Z+.65;sum=Z+4/sum;sum=Z+3/sum;sum=Z+2/sum;sum=Z+1/sum;cd=exp/sum/2.506628274631}}return z>0?1-cd:cd}function quantileNormal(p,mean,stdev){if(p<0||p>1)return NaN;return(mean||0)+(stdev==null?1:stdev)*SQRT2*erfinv(2*p-1)}function erfinv(x){let w=-Math.log((1-x)*(1+x)),p;if(w<6.25){w-=3.125;p=-364441206401782e-35;p=-16850591381820166e-35+p*w;p=128584807152564e-32+p*w;p=11157877678025181e-33+p*w;p=-1333171662854621e-31+p*w;p=20972767875968562e-33+p*w;p=6637638134358324e-30+p*w;p=-4054566272975207e-29+p*w;p=-8151934197605472e-29+p*w;p=26335093153082323e-28+p*w;p=-12975133253453532e-27+p*w;p=-5415412054294628e-26+p*w;p=1.0512122733215323e-9+p*w;p=-4.112633980346984e-9+p*w;p=-2.9070369957882005e-8+p*w;p=4.2347877827932404e-7+p*w;p=-13654692000834679e-22+p*w;p=-13882523362786469e-21+p*w;p=.00018673420803405714+p*w;p=-.000740702534166267+p*w;p=-.006033670871430149+p*w;p=.24015818242558962+p*w;p=1.6536545626831027+p*w}else if(w<16){w=Math.sqrt(w)-3.25;p=2.2137376921775787e-9;p=9.075656193888539e-8+p*w;p=-2.7517406297064545e-7+p*w;p=1.8239629214389228e-8+p*w;p=15027403968909828e-22+p*w;p=-4013867526981546e-21+p*w;p=29234449089955446e-22+p*w;p=12475304481671779e-21+p*w;p=-47318229009055734e-21+p*w;p=6828485145957318e-20+p*w;p=24031110387097894e-21+p*w;p=-.0003550375203628475+p*w;p=.0009532893797373805+p*w;p=-.0016882755560235047+p*w;p=.002491442096107851+p*w;p=-.003751208507569241+p*w;p=.005370914553590064+p*w;p=1.0052589676941592+p*w;p=3.0838856104922208+p*w}else if(Number.isFinite(w)){w=Math.sqrt(w)-5;p=-27109920616438573e-27;p=-2.555641816996525e-10+p*w;p=1.5076572693500548e-9+p*w;p=-3.789465440126737e-9+p*w;p=7.61570120807834e-9+p*w;p=-1.496002662714924e-8+p*w;p=2.914795345090108e-8+p*w;p=-6.771199775845234e-8+p*w;p=2.2900482228026655e-7+p*w;p=-9.9298272942317e-7+p*w;p=4526062597223154e-21+p*w;p=-1968177810553167e-20+p*w;p=7599527703001776e-20+p*w;p=-.00021503011930044477+p*w;p=-.00013871931833623122+p*w;p=1.0103004648645344+p*w;p=4.849906401408584+p*w}else{p=Infinity}return p*x}function gaussian(mean,stdev){let mu,sigma;const dist={mean(_){if(arguments.length){mu=_||0;return dist}else{return mu}},stdev(_){if(arguments.length){sigma=_==null?1:_;return dist}else{return sigma}},sample:()=>sampleNormal(mu,sigma),pdf:value=>densityNormal(value,mu,sigma),cdf:value=>cumulativeNormal(value,mu,sigma),icdf:p=>quantileNormal(p,mu,sigma)};return dist.mean(mean).stdev(stdev)}function kde(support,bandwidth){const kernel=gaussian();let n=0;const dist={data(_){if(arguments.length){support=_;n=_?_.length:0;return dist.bandwidth(bandwidth)}else{return support}},bandwidth(_){if(!arguments.length)return bandwidth;bandwidth=_;if(!bandwidth&&support)bandwidth=estimateBandwidth(support);return dist},sample(){return support[~~(exports.random()*n)]+bandwidth*kernel.sample()},pdf(x){let y=0,i=0;for(;i<n;++i){y+=kernel.pdf((x-support[i])/bandwidth)}return y/bandwidth/n},cdf(x){let y=0,i=0;for(;i<n;++i){y+=kernel.cdf((x-support[i])/bandwidth)}return y/n},icdf(){throw Error("KDE icdf not supported.")}};return dist.data(support)}function sampleLogNormal(mean,stdev){mean=mean||0;stdev=stdev==null?1:stdev;return Math.exp(mean+sampleNormal()*stdev)}function densityLogNormal(value,mean,stdev){if(value<=0)return 0;mean=mean||0;stdev=stdev==null?1:stdev;const z=(Math.log(value)-mean)/stdev;return Math.exp(-.5*z*z)/(stdev*SQRT2PI*value)}function cumulativeLogNormal(value,mean,stdev){return cumulativeNormal(Math.log(value),mean,stdev)}function quantileLogNormal(p,mean,stdev){return Math.exp(quantileNormal(p,mean,stdev))}function lognormal(mean,stdev){let mu,sigma;const dist={mean(_){if(arguments.length){mu=_||0;return dist}else{return mu}},stdev(_){if(arguments.length){sigma=_==null?1:_;return dist}else{return sigma}},sample:()=>sampleLogNormal(mu,sigma),pdf:value=>densityLogNormal(value,mu,sigma),cdf:value=>cumulativeLogNormal(value,mu,sigma),icdf:p=>quantileLogNormal(p,mu,sigma)};return dist.mean(mean).stdev(stdev)}function mixture(dists,weights){let m=0,w;function normalize(x){const w=[];let sum=0,i;for(i=0;i<m;++i){sum+=w[i]=x[i]==null?1:+x[i]}for(i=0;i<m;++i){w[i]/=sum}return w}const dist={weights(_){if(arguments.length){w=normalize(weights=_||[]);return dist}return weights},distributions(_){if(arguments.length){if(_){m=_.length;dists=_}else{m=0;dists=[]}return dist.weights(weights)}return dists},sample(){const r=exports.random();let d=dists[m-1],v=w[0],i=0;for(;i<m-1;v+=w[++i]){if(r<v){d=dists[i];break}}return d.sample()},pdf(x){let p=0,i=0;for(;i<m;++i){p+=w[i]*dists[i].pdf(x)}return p},cdf(x){let p=0,i=0;for(;i<m;++i){p+=w[i]*dists[i].cdf(x)}return p},icdf(){throw Error("Mixture icdf not supported.")}};return dist.distributions(dists).weights(weights)}function sampleUniform(min,max){if(max==null){max=min==null?1:min;min=0}return min+(max-min)*exports.random()}function densityUniform(value,min,max){if(max==null){max=min==null?1:min;min=0}return value>=min&&value<=max?1/(max-min):0}function cumulativeUniform(value,min,max){if(max==null){max=min==null?1:min;min=0}return value<min?0:value>max?1:(value-min)/(max-min)}function quantileUniform(p,min,max){if(max==null){max=min==null?1:min;min=0}return p>=0&&p<=1?min+p*(max-min):NaN}function uniform(min,max){let a,b;const dist={min(_){if(arguments.length){a=_||0;return dist}else{return a}},max(_){if(arguments.length){b=_==null?1:_;return dist}else{return b}},sample:()=>sampleUniform(a,b),pdf:value=>densityUniform(value,a,b),cdf:value=>cumulativeUniform(value,a,b),icdf:p=>quantileUniform(p,a,b)};if(max==null){max=min==null?1:min;min=0}return dist.min(min).max(max)}function constant(data,x,y){let mean=0,n=0;for(const d of data){const val=y(d);if(x(d)==null||val==null||isNaN(val))continue;mean+=(val-mean)/++n}return{coef:[mean],predict:()=>mean,rSquared:0}}function ols(uX,uY,uXY,uX2){const delta=uX2-uX*uX,slope=Math.abs(delta)<1e-24?0:(uXY-uX*uY)/delta,intercept=uY-slope*uX;return[intercept,slope]}function points(data,x,y,sort){data=data.filter(d=>{let u=x(d),v=y(d);return u!=null&&(u=+u)>=u&&v!=null&&(v=+v)>=v});if(sort){data.sort((a,b)=>x(a)-x(b))}const n=data.length,X=new Float64Array(n),Y=new Float64Array(n);let i=0,ux=0,uy=0,xv,yv,d;for(d of data){X[i]=xv=+x(d);Y[i]=yv=+y(d);++i;ux+=(xv-ux)/i;uy+=(yv-uy)/i}for(i=0;i<n;++i){X[i]-=ux;Y[i]-=uy}return[X,Y,ux,uy]}function visitPoints(data,x,y,callback){let i=-1,u,v;for(const d of data){u=x(d);v=y(d);if(u!=null&&(u=+u)>=u&&v!=null&&(v=+v)>=v){callback(u,v,++i)}}}function rSquared(data,x,y,uY,predict){let SSE=0,SST=0;visitPoints(data,x,y,(dx,dy)=>{const sse=dy-predict(dx),sst=dy-uY;SSE+=sse*sse;SST+=sst*sst});return 1-SSE/SST}function linear(data,x,y){let X=0,Y=0,XY=0,X2=0,n=0;visitPoints(data,x,y,(dx,dy)=>{++n;X+=(dx-X)/n;Y+=(dy-Y)/n;XY+=(dx*dy-XY)/n;X2+=(dx*dx-X2)/n});const coef=ols(X,Y,XY,X2),predict=x=>coef[0]+coef[1]*x;return{coef:coef,predict:predict,rSquared:rSquared(data,x,y,Y,predict)}}function log(data,x,y){let X=0,Y=0,XY=0,X2=0,n=0;visitPoints(data,x,y,(dx,dy)=>{++n;dx=Math.log(dx);X+=(dx-X)/n;Y+=(dy-Y)/n;XY+=(dx*dy-XY)/n;X2+=(dx*dx-X2)/n});const coef=ols(X,Y,XY,X2),predict=x=>coef[0]+coef[1]*Math.log(x);return{coef:coef,predict:predict,rSquared:rSquared(data,x,y,Y,predict)}}function exp(data,x,y){const[xv,yv,ux,uy]=points(data,x,y);let YL=0,XY=0,XYL=0,X2Y=0,n=0,dx,ly,xy;visitPoints(data,x,y,(_,dy)=>{dx=xv[n++];ly=Math.log(dy);xy=dx*dy;YL+=(dy*ly-YL)/n;XY+=(xy-XY)/n;XYL+=(xy*ly-XYL)/n;X2Y+=(dx*xy-X2Y)/n});const[c0,c1]=ols(XY/uy,YL/uy,XYL/uy,X2Y/uy),predict=x=>Math.exp(c0+c1*(x-ux));return{coef:[Math.exp(c0-c1*ux),c1],predict:predict,rSquared:rSquared(data,x,y,uy,predict)}}function pow(data,x,y){let X=0,Y=0,XY=0,X2=0,YS=0,n=0;visitPoints(data,x,y,(dx,dy)=>{const lx=Math.log(dx),ly=Math.log(dy);++n;X+=(lx-X)/n;Y+=(ly-Y)/n;XY+=(lx*ly-XY)/n;X2+=(lx*lx-X2)/n;YS+=(dy-YS)/n});const coef=ols(X,Y,XY,X2),predict=x=>coef[0]*Math.pow(x,coef[1]);coef[0]=Math.exp(coef[0]);return{coef:coef,predict:predict,rSquared:rSquared(data,x,y,YS,predict)}}function quad(data,x,y){const[xv,yv,ux,uy]=points(data,x,y),n=xv.length;let X2=0,X3=0,X4=0,XY=0,X2Y=0,i,dx,dy,x2;for(i=0;i<n;){dx=xv[i];dy=yv[i++];x2=dx*dx;X2+=(x2-X2)/i;X3+=(x2*dx-X3)/i;X4+=(x2*x2-X4)/i;XY+=(dx*dy-XY)/i;X2Y+=(x2*dy-X2Y)/i}const X2X2=X4-X2*X2,d=X2*X2X2-X3*X3,a=(X2Y*X2-XY*X3)/d,b=(XY*X2X2-X2Y*X3)/d,c=-a*X2,predict=x=>{x=x-ux;return a*x*x+b*x+c+uy};return{coef:[c-b*ux+a*ux*ux+uy,b-2*a*ux,a],predict:predict,rSquared:rSquared(data,x,y,uy,predict)}}function poly(data,x,y,order){if(order===0)return constant(data,x,y);if(order===1)return linear(data,x,y);if(order===2)return quad(data,x,y);const[xv,yv,ux,uy]=points(data,x,y),n=xv.length,lhs=[],rhs=[],k=order+1;let i,j,l,v,c;for(i=0;i<k;++i){for(l=0,v=0;l<n;++l){v+=Math.pow(xv[l],i)*yv[l]}lhs.push(v);c=new Float64Array(k);for(j=0;j<k;++j){for(l=0,v=0;l<n;++l){v+=Math.pow(xv[l],i+j)}c[j]=v}rhs.push(c)}rhs.push(lhs);const coef=gaussianElimination(rhs),predict=x=>{x-=ux;let y=uy+coef[0]+coef[1]*x+coef[2]*x*x;for(i=3;i<k;++i)y+=coef[i]*Math.pow(x,i);return y};return{coef:uncenter(k,coef,-ux,uy),predict:predict,rSquared:rSquared(data,x,y,uy,predict)}}function uncenter(k,a,x,y){const z=Array(k);let i,j,v,c;for(i=0;i<k;++i)z[i]=0;for(i=k-1;i>=0;--i){v=a[i];c=1;z[i]+=v;for(j=1;j<=i;++j){c*=(i+1-j)/j;z[i-j]+=v*Math.pow(x,j)*c}}z[0]+=y;return z}function gaussianElimination(matrix){const n=matrix.length-1,coef=[];let i,j,k,r,t;for(i=0;i<n;++i){r=i;for(j=i+1;j<n;++j){if(Math.abs(matrix[i][j])>Math.abs(matrix[i][r])){r=j}}for(k=i;k<n+1;++k){t=matrix[k][i];matrix[k][i]=matrix[k][r];matrix[k][r]=t}for(j=i+1;j<n;++j){for(k=n;k>=i;k--){matrix[k][j]-=matrix[k][i]*matrix[i][j]/matrix[i][i]}}}for(j=n-1;j>=0;--j){t=0;for(k=j+1;k<n;++k){t+=matrix[k][j]*coef[k]}coef[j]=(matrix[n][j]-t)/matrix[j][j]}return coef}const maxiters=2,epsilon=1e-12;function loess(data,x,y,bandwidth){const[xv,yv,ux,uy]=points(data,x,y,true),n=xv.length,bw=Math.max(2,~~(bandwidth*n)),yhat=new Float64Array(n),residuals=new Float64Array(n),robustWeights=new Float64Array(n).fill(1);for(let iter=-1;++iter<=maxiters;){const interval=[0,bw-1];for(let i=0;i<n;++i){const dx=xv[i],i0=interval[0],i1=interval[1],edge=dx-xv[i0]>xv[i1]-dx?i0:i1;let W=0,X=0,Y=0,XY=0,X2=0;const denom=1/Math.abs(xv[edge]-dx||1);for(let k=i0;k<=i1;++k){const xk=xv[k],yk=yv[k],w=tricube(Math.abs(dx-xk)*denom)*robustWeights[k],xkw=xk*w;W+=w;X+=xkw;Y+=yk*w;XY+=yk*xkw;X2+=xk*xkw}const[a,b]=ols(X/W,Y/W,XY/W,X2/W);yhat[i]=a+b*dx;residuals[i]=Math.abs(yv[i]-yhat[i]);updateInterval(xv,i+1,interval)}if(iter===maxiters){break}const medianResidual=median(residuals);if(Math.abs(medianResidual)<epsilon)break;for(let i=0,arg,w;i<n;++i){arg=residuals[i]/(6*medianResidual);robustWeights[i]=arg>=1?epsilon:(w=1-arg*arg)*w}}return output(xv,yhat,ux,uy)}function tricube(x){return(x=1-x*x*x)*x*x}function updateInterval(xv,i,interval){const val=xv[i];let left=interval[0],right=interval[1]+1;if(right>=xv.length)return;while(i>left&&xv[right]-val<=val-xv[left]){interval[0]=++left;interval[1]=right;++right}}function output(xv,yhat,ux,uy){const n=xv.length,out=[];let i=0,cnt=0,prev=[],v;for(;i<n;++i){v=xv[i]+ux;if(prev[0]===v){prev[1]+=(yhat[i]-prev[1])/++cnt}else{cnt=0;prev[1]+=uy;prev=[v,yhat[i]];out.push(prev)}}prev[1]+=uy;return out}const MIN_RADIANS=.5*Math.PI/180;function sampleCurve(f,extent,minSteps,maxSteps){minSteps=minSteps||25;maxSteps=Math.max(minSteps,maxSteps||200);const point=x=>[x,f(x)],minX=extent[0],maxX=extent[1],span=maxX-minX,stop=span/maxSteps,prev=[point(minX)],next=[];if(minSteps===maxSteps){for(let i=1;i<maxSteps;++i){prev.push(point(minX+i/minSteps*span))}prev.push(point(maxX));return prev}else{next.push(point(maxX));for(let i=minSteps;--i>0;){next.push(point(minX+i/minSteps*span))}}let p0=prev[0];let p1=next[next.length-1];const sx=1/span;const sy=scaleY(p0[1],next);while(p1){const pm=point((p0[0]+p1[0])/2);const dx=pm[0]-p0[0]>=stop;if(dx&&angleDelta(p0,pm,p1,sx,sy)>MIN_RADIANS){next.push(pm)}else{p0=p1;prev.push(p1);next.pop()}p1=next[next.length-1]}return prev}function scaleY(init,points){let ymin=init;let ymax=init;const n=points.length;for(let i=0;i<n;++i){const y=points[i][1];if(y<ymin)ymin=y;if(y>ymax)ymax=y}return 1/(ymax-ymin)}function angleDelta(p,q,r,sx,sy){const a0=Math.atan2(sy*(r[1]-p[1]),sx*(r[0]-p[0])),a1=Math.atan2(sy*(q[1]-p[1]),sx*(q[0]-p[0]));return Math.abs(a0-a1)}exports.bandwidthNRD=estimateBandwidth;exports.bin=bin;exports.bootstrapCI=bootstrapCI;exports.cumulativeLogNormal=cumulativeLogNormal;exports.cumulativeNormal=cumulativeNormal;exports.cumulativeUniform=cumulativeUniform;exports.densityLogNormal=densityLogNormal;exports.densityNormal=densityNormal;exports.densityUniform=densityUniform;exports.dotbin=dotbin;exports.quantileLogNormal=quantileLogNormal;exports.quantileNormal=quantileNormal;exports.quantileUniform=quantileUniform;exports.quantiles=quantiles;exports.quartiles=quartiles;exports.randomInteger=integer;exports.randomKDE=kde;exports.randomLCG=lcg;exports.randomLogNormal=lognormal;exports.randomMixture=mixture;exports.randomNormal=gaussian;exports.randomUniform=uniform;exports.regressionConstant=constant;exports.regressionExp=exp;exports.regressionLinear=linear;exports.regressionLoess=loess;exports.regressionLog=log;exports.regressionPoly=poly;exports.regressionPow=pow;exports.regressionQuad=quad;exports.sampleCurve=sampleCurve;exports.sampleLogNormal=sampleLogNormal;exports.sampleNormal=sampleNormal;exports.sampleUniform=sampleUniform;exports.setRandom=setRandom}))},function(module,__webpack_exports__,__webpack_require__){"use strict";(function(setImmediate){__webpack_require__.d(__webpack_exports__,"a",(function(){return expression}));function adjustSpatial(item,encode,swap){let t;if(encode.x2){if(encode.x){if(swap&&item.x>item.x2){t=item.x;item.x=item.x2;item.x2=t}item.width=item.x2-item.x}else{item.x=item.x2-(item.width||0)}}if(encode.xc){item.x=item.xc-(item.width||0)/2}if(encode.y2){if(encode.y){if(swap&&item.y>item.y2){t=item.y;item.y=item.y2;item.y2=t}item.height=item.y2-item.y}else{item.y=item.y2-(item.height||0)}}if(encode.yc){item.y=item.yc-(item.height||0)/2}}var Constants={NaN:NaN,E:Math.E,LN2:Math.LN2,LN10:Math.LN10,LOG2E:Math.LOG2E,LOG10E:Math.LOG10E,PI:Math.PI,SQRT1_2:Math.SQRT1_2,SQRT2:Math.SQRT2,MIN_VALUE:Number.MIN_VALUE,MAX_VALUE:Number.MAX_VALUE};var Ops={"*":(a,b)=>a*b,"+":(a,b)=>a+b,"-":(a,b)=>a-b,"/":(a,b)=>a/b,"%":(a,b)=>a%b,">":(a,b)=>a>b,"<":(a,b)=>a<b,"<=":(a,b)=>a<=b,">=":(a,b)=>a>=b,"==":(a,b)=>a==b,"!=":(a,b)=>a!=b,"===":(a,b)=>a===b,"!==":(a,b)=>a!==b,"&":(a,b)=>a&b,"|":(a,b)=>a|b,"^":(a,b)=>a^b,"<<":(a,b)=>a<<b,">>":(a,b)=>a>>b,">>>":(a,b)=>a>>>b};var Unary={"+":a=>+a,"-":a=>-a,"~":a=>~a,"!":a=>!a};const slice=Array.prototype.slice;const apply=(m,args,cast)=>{const obj=cast?cast(args[0]):args[0];return obj[m].apply(obj,slice.call(args,1))};const datetime=(y,m,d,H,M,S,ms)=>new Date(y,m||0,d!=null?d:1,H||0,M||0,S||0,ms||0);var Functions={isNaN:Number.isNaN,isFinite:Number.isFinite,abs:Math.abs,acos:Math.acos,asin:Math.asin,atan:Math.atan,atan2:Math.atan2,ceil:Math.ceil,cos:Math.cos,exp:Math.exp,floor:Math.floor,log:Math.log,max:Math.max,min:Math.min,pow:Math.pow,random:Math.random,round:Math.round,sin:Math.sin,sqrt:Math.sqrt,tan:Math.tan,clamp:(a,b,c)=>Math.max(b,Math.min(c,a)),now:Date.now,utc:Date.UTC,datetime:datetime,date:d=>new Date(d).getDate(),day:d=>new Date(d).getDay(),year:d=>new Date(d).getFullYear(),month:d=>new Date(d).getMonth(),hours:d=>new Date(d).getHours(),minutes:d=>new Date(d).getMinutes(),seconds:d=>new Date(d).getSeconds(),milliseconds:d=>new Date(d).getMilliseconds(),time:d=>new Date(d).getTime(),timezoneoffset:d=>new Date(d).getTimezoneOffset(),utcdate:d=>new Date(d).getUTCDate(),utcday:d=>new Date(d).getUTCDay(),utcyear:d=>new Date(d).getUTCFullYear(),utcmonth:d=>new Date(d).getUTCMonth(),utchours:d=>new Date(d).getUTCHours(),utcminutes:d=>new Date(d).getUTCMinutes(),utcseconds:d=>new Date(d).getUTCSeconds(),utcmilliseconds:d=>new Date(d).getUTCMilliseconds(),length:x=>x.length,join:function(){return apply("join",arguments)},indexof:function(){return apply("indexOf",arguments)},lastindexof:function(){return apply("lastIndexOf",arguments)},slice:function(){return apply("slice",arguments)},reverse:x=>x.slice().reverse(),parseFloat:parseFloat,parseInt:parseInt,upper:x=>String(x).toUpperCase(),lower:x=>String(x).toLowerCase(),substring:function(){return apply("substring",arguments,String)},split:function(){return apply("split",arguments,String)},replace:function(){return apply("replace",arguments,String)},trim:x=>String(x).trim(),regexp:RegExp,test:(r,t)=>RegExp(r).test(t)};const EventFunctions=["view","item","group","xy","x","y"];const DisallowedMethods=new Set([Function,eval,setTimeout,setInterval]);if(typeof setImmediate==="function")DisallowedMethods.add(setImmediate);const Visitors={Literal:($,n)=>n.value,Identifier:($,n)=>{const id=n.name;return $.memberDepth>0?id:id==="datum"?$.datum:id==="event"?$.event:id==="item"?$.item:Constants[id]||$.params["$"+id]},MemberExpression:($,n)=>{const d=!n.computed,o=$(n.object);if(d)$.memberDepth+=1;const p=$(n.property);if(d)$.memberDepth-=1;if(DisallowedMethods.has(o[p])){console.error(`Prevented interpretation of member "${p}" which could lead to insecure code execution`);return}return o[p]},CallExpression:($,n)=>{const args=n.arguments;let name=n.callee.name;if(name.startsWith("_")){name=name.slice(1)}return name==="if"?$(args[0])?$(args[1]):$(args[2]):($.fn[name]||Functions[name]).apply($.fn,args.map($))},ArrayExpression:($,n)=>n.elements.map($),BinaryExpression:($,n)=>Ops[n.operator]($(n.left),$(n.right)),UnaryExpression:($,n)=>Unary[n.operator]($(n.argument)),ConditionalExpression:($,n)=>$(n.test)?$(n.consequent):$(n.alternate),LogicalExpression:($,n)=>n.operator==="&&"?$(n.left)&&$(n.right):$(n.left)||$(n.right),ObjectExpression:($,n)=>n.properties.reduce((o,p)=>{$.memberDepth+=1;const k=$(p.key);$.memberDepth-=1;if(DisallowedMethods.has($(p.value))){console.error(`Prevented interpretation of property "${k}" which could lead to insecure code execution`)}else{o[k]=$(p.value)}return o},{})};function interpret(ast,fn,params,datum,event,item){const $=n=>Visitors[n.type]($,n);$.memberDepth=0;$.fn=Object.create(fn);$.params=params;$.datum=datum;$.event=event;$.item=item;EventFunctions.forEach(f=>$.fn[f]=function(){return event.vega[f](...arguments)});return $(ast)}var expression={operator(ctx,expr){const ast=expr.ast,fn=ctx.functions;return _=>interpret(ast,fn,_)},parameter(ctx,expr){const ast=expr.ast,fn=ctx.functions;return(datum,_)=>interpret(ast,fn,_,datum)},event(ctx,expr){const ast=expr.ast,fn=ctx.functions;return event=>interpret(ast,fn,undefined,undefined,event)},handler(ctx,expr){const ast=expr.ast,fn=ctx.functions;return(_,event)=>{const datum=event.item&&event.item.datum;return interpret(ast,fn,_,datum,event)}},encode(ctx,encode){const{marktype:marktype,channels:channels}=encode,fn=ctx.functions,swap=marktype==="group"||marktype==="image"||marktype==="rect";return(item,_)=>{const datum=item.datum;let m=0,v;for(const name in channels){v=interpret(channels[name].ast,fn,_,datum,undefined,item);if(item[name]!==v){item[name]=v;m=1}}if(marktype!=="rule"){adjustSpatial(item,channels,swap)}return m}}}}).call(this,__webpack_require__(109).setImmediate)},,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(62)):undefined})(this,(function(exports,vegaUtil){"use strict";const YEAR="year";const QUARTER="quarter";const MONTH="month";const WEEK="week";const DATE="date";const DAY="day";const DAYOFYEAR="dayofyear";const HOURS="hours";const MINUTES="minutes";const SECONDS="seconds";const MILLISECONDS="milliseconds";const TIME_UNITS=[YEAR,QUARTER,MONTH,WEEK,DATE,DAY,DAYOFYEAR,HOURS,MINUTES,SECONDS,MILLISECONDS];const UNITS=TIME_UNITS.reduce((o,u,i)=>(o[u]=1+i,o),{});function timeUnits(units){const u=vegaUtil.array(units).slice(),m={};if(!u.length)vegaUtil.error("Missing time unit.");u.forEach(unit=>{if(vegaUtil.hasOwnProperty(UNITS,unit)){m[unit]=1}else{vegaUtil.error(`Invalid time unit: ${unit}.`)}});const numTypes=(m[WEEK]||m[DAY]?1:0)+(m[QUARTER]||m[MONTH]||m[DATE]?1:0)+(m[DAYOFYEAR]?1:0);if(numTypes>1){vegaUtil.error(`Incompatible time units: ${units}`)}u.sort((a,b)=>UNITS[a]-UNITS[b]);return u}const defaultSpecifiers={[YEAR]:"%Y ",[QUARTER]:"Q%q ",[MONTH]:"%b ",[DATE]:"%d ",[WEEK]:"W%U ",[DAY]:"%a ",[DAYOFYEAR]:"%j ",[HOURS]:"%H:00",[MINUTES]:"00:%M",[SECONDS]:":%S",[MILLISECONDS]:".%L",[`${YEAR}-${MONTH}`]:"%Y-%m ",[`${YEAR}-${MONTH}-${DATE}`]:"%Y-%m-%d ",[`${HOURS}-${MINUTES}`]:"%H:%M"};function timeUnitSpecifier(units,specifiers){const s=vegaUtil.extend({},defaultSpecifiers,specifiers),u=timeUnits(units),n=u.length;let fmt="",start=0,end,key;for(start=0;start<n;){for(end=u.length;end>start;--end){key=u.slice(start,end).join("-");if(s[key]!=null){fmt+=s[key];start=end;break}}}return fmt.trim()}const t0$1=new Date,t1=new Date;function timeInterval$1(floori,offseti,count,field){function interval(date){return floori(date=arguments.length===0?new Date:new Date(+date)),date}interval.floor=date=>(floori(date=new Date(+date)),date);interval.ceil=date=>(floori(date=new Date(date-1)),offseti(date,1),floori(date),date);interval.round=date=>{const d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1};interval.offset=(date,step)=>(offseti(date=new Date(+date),step==null?1:Math.floor(step)),date);interval.range=(start,stop,step)=>{const range=[];start=interval.ceil(start);step=step==null?1:Math.floor(step);if(!(start<stop)||!(step>0))return range;let previous;do{range.push(previous=new Date(+start)),offseti(start,step),floori(start)}while(previous<start&&start<stop);return range};interval.filter=test=>timeInterval$1(date=>{if(date>=date)while(floori(date),!test(date))date.setTime(date-1)},(date,step)=>{if(date>=date){if(step<0)while(++step<=0){while(offseti(date,-1),!test(date)){}}else while(--step>=0){while(offseti(date,1),!test(date)){}}}});if(count){interval.count=(start,end)=>{t0$1.setTime(+start),t1.setTime(+end);floori(t0$1),floori(t1);return Math.floor(count(t0$1,t1))};interval.every=step=>{step=Math.floor(step);return!isFinite(step)||!(step>0)?null:!(step>1)?interval:interval.filter(field?d=>field(d)%step===0:d=>interval.count(0,d)%step===0)}}return interval}const millisecond=timeInterval$1(()=>{},(date,step)=>{date.setTime(+date+step)},(start,end)=>end-start);millisecond.every=k=>{k=Math.floor(k);if(!isFinite(k)||!(k>0))return null;if(!(k>1))return millisecond;return timeInterval$1(date=>{date.setTime(Math.floor(date/k)*k)},(date,step)=>{date.setTime(+date+step*k)},(start,end)=>(end-start)/k)};millisecond.range;const durationSecond$1=1e3;const durationMinute$1=durationSecond$1*60;const durationHour$1=durationMinute$1*60;const durationDay$1=durationHour$1*24;const durationWeek$1=durationDay$1*7;const second=timeInterval$1(date=>{date.setTime(date-date.getMilliseconds())},(date,step)=>{date.setTime(+date+step*durationSecond$1)},(start,end)=>(end-start)/durationSecond$1,date=>date.getUTCSeconds());second.range;const timeMinute=timeInterval$1(date=>{date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond$1)},(date,step)=>{date.setTime(+date+step*durationMinute$1)},(start,end)=>(end-start)/durationMinute$1,date=>date.getMinutes());timeMinute.range;const utcMinute=timeInterval$1(date=>{date.setUTCSeconds(0,0)},(date,step)=>{date.setTime(+date+step*durationMinute$1)},(start,end)=>(end-start)/durationMinute$1,date=>date.getUTCMinutes());utcMinute.range;const timeHour=timeInterval$1(date=>{date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond$1-date.getMinutes()*durationMinute$1)},(date,step)=>{date.setTime(+date+step*durationHour$1)},(start,end)=>(end-start)/durationHour$1,date=>date.getHours());timeHour.range;const utcHour=timeInterval$1(date=>{date.setUTCMinutes(0,0,0)},(date,step)=>{date.setTime(+date+step*durationHour$1)},(start,end)=>(end-start)/durationHour$1,date=>date.getUTCHours());utcHour.range;const timeDay=timeInterval$1(date=>date.setHours(0,0,0,0),(date,step)=>date.setDate(date.getDate()+step),(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute$1)/durationDay$1,date=>date.getDate()-1);timeDay.range;const utcDay=timeInterval$1(date=>{date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step)},(start,end)=>(end-start)/durationDay$1,date=>date.getUTCDate()-1);utcDay.range;const unixDay=timeInterval$1(date=>{date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step)},(start,end)=>(end-start)/durationDay$1,date=>Math.floor(date/durationDay$1));unixDay.range;function timeWeekday(i){return timeInterval$1(date=>{date.setDate(date.getDate()-(date.getDay()+7-i)%7);date.setHours(0,0,0,0)},(date,step)=>{date.setDate(date.getDate()+step*7)},(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute$1)/durationWeek$1)}const timeSunday=timeWeekday(0);const timeMonday=timeWeekday(1);const timeTuesday=timeWeekday(2);const timeWednesday=timeWeekday(3);const timeThursday=timeWeekday(4);const timeFriday=timeWeekday(5);const timeSaturday=timeWeekday(6);timeSunday.range;timeMonday.range;timeTuesday.range;timeWednesday.range;timeThursday.range;timeFriday.range;timeSaturday.range;function utcWeekday(i){return timeInterval$1(date=>{date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step*7)},(start,end)=>(end-start)/durationWeek$1)}const utcSunday=utcWeekday(0);const utcMonday=utcWeekday(1);const utcTuesday=utcWeekday(2);const utcWednesday=utcWeekday(3);const utcThursday=utcWeekday(4);const utcFriday=utcWeekday(5);const utcSaturday=utcWeekday(6);utcSunday.range;utcMonday.range;utcTuesday.range;utcWednesday.range;utcThursday.range;utcFriday.range;utcSaturday.range;const timeMonth=timeInterval$1(date=>{date.setDate(1);date.setHours(0,0,0,0)},(date,step)=>{date.setMonth(date.getMonth()+step)},(start,end)=>end.getMonth()-start.getMonth()+(end.getFullYear()-start.getFullYear())*12,date=>date.getMonth());timeMonth.range;const utcMonth=timeInterval$1(date=>{date.setUTCDate(1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCMonth(date.getUTCMonth()+step)},(start,end)=>end.getUTCMonth()-start.getUTCMonth()+(end.getUTCFullYear()-start.getUTCFullYear())*12,date=>date.getUTCMonth());utcMonth.range;const timeYear=timeInterval$1(date=>{date.setMonth(0,1);date.setHours(0,0,0,0)},(date,step)=>{date.setFullYear(date.getFullYear()+step)},(start,end)=>end.getFullYear()-start.getFullYear(),date=>date.getFullYear());timeYear.every=k=>!isFinite(k=Math.floor(k))||!(k>0)?null:timeInterval$1(date=>{date.setFullYear(Math.floor(date.getFullYear()/k)*k);date.setMonth(0,1);date.setHours(0,0,0,0)},(date,step)=>{date.setFullYear(date.getFullYear()+step*k)});timeYear.range;const utcYear=timeInterval$1(date=>{date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCFullYear(date.getUTCFullYear()+step)},(start,end)=>end.getUTCFullYear()-start.getUTCFullYear(),date=>date.getUTCFullYear());utcYear.every=k=>!isFinite(k=Math.floor(k))||!(k>0)?null:timeInterval$1(date=>{date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k);date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCFullYear(date.getUTCFullYear()+step*k)});utcYear.range;function ascending(a,b){return a==null||b==null?NaN:a<b?-1:a>b?1:a>=b?0:NaN}function descending(a,b){return a==null||b==null?NaN:b<a?-1:b>a?1:b>=a?0:NaN}function bisector(f){let compare1,compare2,delta;if(f.length!==2){compare1=ascending;compare2=(d,x)=>ascending(f(d),x);delta=(d,x)=>f(d)-x}else{compare1=f===ascending||f===descending?f:zero;compare2=f;delta=f}function left(a,x,lo=0,hi=a.length){if(lo<hi){if(compare1(x,x)!==0)return hi;do{const mid=lo+hi>>>1;if(compare2(a[mid],x)<0)lo=mid+1;else hi=mid}while(lo<hi)}return lo}function right(a,x,lo=0,hi=a.length){if(lo<hi){if(compare1(x,x)!==0)return hi;do{const mid=lo+hi>>>1;if(compare2(a[mid],x)<=0)lo=mid+1;else hi=mid}while(lo<hi)}return lo}function center(a,x,lo=0,hi=a.length){const i=left(a,x,lo,hi-1);return i>lo&&delta(a[i-1],x)>-delta(a[i],x)?i-1:i}return{left:left,center:center,right:right}}function zero(){return 0}const e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function tickSpec(start,stop,count){const step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log10(step)),error=step/Math.pow(10,power),factor=error>=e10?10:error>=e5?5:error>=e2?2:1;let i1,i2,inc;if(power<0){inc=Math.pow(10,-power)/factor;i1=Math.round(start*inc);i2=Math.round(stop*inc);if(i1/inc<start)++i1;if(i2/inc>stop)--i2;inc=-inc}else{inc=Math.pow(10,power)*factor;i1=Math.round(start/inc);i2=Math.round(stop/inc);if(i1*inc<start)++i1;if(i2*inc>stop)--i2}if(i2<i1&&.5<=count&&count<2)return tickSpec(start,stop,count*2);return[i1,i2,inc]}function tickIncrement(start,stop,count){stop=+stop,start=+start,count=+count;return tickSpec(start,stop,count)[2]}function tickStep(start,stop,count){stop=+stop,start=+start,count=+count;const reverse=stop<start,inc=reverse?tickIncrement(stop,start,count):tickIncrement(start,stop,count);return(reverse?-1:1)*(inc<0?1/-inc:inc)}const t0=new Date;function localYear(y){t0.setFullYear(y);t0.setMonth(0);t0.setDate(1);t0.setHours(0,0,0,0);return t0}function dayofyear(d){return localDayOfYear(new Date(d))}function week(d){return localWeekNum(new Date(d))}function localDayOfYear(d){return timeDay.count(localYear(d.getFullYear())-1,d)}function localWeekNum(d){return timeSunday.count(localYear(d.getFullYear())-1,d)}function localFirst(y){return localYear(y).getDay()}function localDate(y,m,d,H,M,S,L){if(0<=y&&y<100){const date=new Date(-1,m,d,H,M,S,L);date.setFullYear(y);return date}return new Date(y,m,d,H,M,S,L)}function utcdayofyear(d){return utcDayOfYear(new Date(d))}function utcweek(d){return utcWeekNum(new Date(d))}function utcDayOfYear(d){const y=Date.UTC(d.getUTCFullYear(),0,1);return utcDay.count(y-1,d)}function utcWeekNum(d){const y=Date.UTC(d.getUTCFullYear(),0,1);return utcSunday.count(y-1,d)}function utcFirst(y){t0.setTime(Date.UTC(y,0,1));return t0.getUTCDay()}function utcDate(y,m,d,H,M,S,L){if(0<=y&&y<100){const date=new Date(Date.UTC(-1,m,d,H,M,S,L));date.setUTCFullYear(d.y);return date}return new Date(Date.UTC(y,m,d,H,M,S,L))}function floor(units,step,get,inv,newDate){const s=step||1,b=vegaUtil.peek(units),_=(unit,p,key)=>{key=key||unit;return getUnit(get[key],inv[key],unit===b&&s,p)};const t=new Date,u=vegaUtil.toSet(units),y=u[YEAR]?_(YEAR):vegaUtil.constant(2012),m=u[MONTH]?_(MONTH):u[QUARTER]?_(QUARTER):vegaUtil.zero,d=u[WEEK]&&u[DAY]?_(DAY,1,WEEK+DAY):u[WEEK]?_(WEEK,1):u[DAY]?_(DAY,1):u[DATE]?_(DATE,1):u[DAYOFYEAR]?_(DAYOFYEAR,1):vegaUtil.one,H=u[HOURS]?_(HOURS):vegaUtil.zero,M=u[MINUTES]?_(MINUTES):vegaUtil.zero,S=u[SECONDS]?_(SECONDS):vegaUtil.zero,L=u[MILLISECONDS]?_(MILLISECONDS):vegaUtil.zero;return function(v){t.setTime(+v);const year=y(t);return newDate(year,m(t),d(t,year),H(t),M(t),S(t),L(t))}}function getUnit(f,inv,step,phase){const u=step<=1?f:phase?(d,y)=>phase+step*Math.floor((f(d,y)-phase)/step):(d,y)=>step*Math.floor(f(d,y)/step);return inv?(d,y)=>inv(u(d,y),y):u}function weekday(week,day,firstDay){return day+week*7-(firstDay+6)%7}const localGet={[YEAR]:d=>d.getFullYear(),[QUARTER]:d=>Math.floor(d.getMonth()/3),[MONTH]:d=>d.getMonth(),[DATE]:d=>d.getDate(),[HOURS]:d=>d.getHours(),[MINUTES]:d=>d.getMinutes(),[SECONDS]:d=>d.getSeconds(),[MILLISECONDS]:d=>d.getMilliseconds(),[DAYOFYEAR]:d=>localDayOfYear(d),[WEEK]:d=>localWeekNum(d),[WEEK+DAY]:(d,y)=>weekday(localWeekNum(d),d.getDay(),localFirst(y)),[DAY]:(d,y)=>weekday(1,d.getDay(),localFirst(y))};const localInv={[QUARTER]:q=>3*q,[WEEK]:(w,y)=>weekday(w,0,localFirst(y))};function timeFloor(units,step){return floor(units,step||1,localGet,localInv,localDate)}const utcGet={[YEAR]:d=>d.getUTCFullYear(),[QUARTER]:d=>Math.floor(d.getUTCMonth()/3),[MONTH]:d=>d.getUTCMonth(),[DATE]:d=>d.getUTCDate(),[HOURS]:d=>d.getUTCHours(),[MINUTES]:d=>d.getUTCMinutes(),[SECONDS]:d=>d.getUTCSeconds(),[MILLISECONDS]:d=>d.getUTCMilliseconds(),[DAYOFYEAR]:d=>utcDayOfYear(d),[WEEK]:d=>utcWeekNum(d),[DAY]:(d,y)=>weekday(1,d.getUTCDay(),utcFirst(y)),[WEEK+DAY]:(d,y)=>weekday(utcWeekNum(d),d.getUTCDay(),utcFirst(y))};const utcInv={[QUARTER]:q=>3*q,[WEEK]:(w,y)=>weekday(w,0,utcFirst(y))};function utcFloor(units,step){return floor(units,step||1,utcGet,utcInv,utcDate)}const timeIntervals={[YEAR]:timeYear,[QUARTER]:timeMonth.every(3),[MONTH]:timeMonth,[WEEK]:timeSunday,[DATE]:timeDay,[DAY]:timeDay,[DAYOFYEAR]:timeDay,[HOURS]:timeHour,[MINUTES]:timeMinute,[SECONDS]:second,[MILLISECONDS]:millisecond};const utcIntervals={[YEAR]:utcYear,[QUARTER]:utcMonth.every(3),[MONTH]:utcMonth,[WEEK]:utcSunday,[DATE]:utcDay,[DAY]:utcDay,[DAYOFYEAR]:utcDay,[HOURS]:utcHour,[MINUTES]:utcMinute,[SECONDS]:second,[MILLISECONDS]:millisecond};function timeInterval(unit){return timeIntervals[unit]}function utcInterval(unit){return utcIntervals[unit]}function offset(ival,date,step){return ival?ival.offset(date,step):undefined}function timeOffset(unit,date,step){return offset(timeInterval(unit),date,step)}function utcOffset(unit,date,step){return offset(utcInterval(unit),date,step)}function sequence(ival,start,stop,step){return ival?ival.range(start,stop,step):undefined}function timeSequence(unit,start,stop,step){return sequence(timeInterval(unit),start,stop,step)}function utcSequence(unit,start,stop,step){return sequence(utcInterval(unit),start,stop,step)}const durationSecond=1e3,durationMinute=durationSecond*60,durationHour=durationMinute*60,durationDay=durationHour*24,durationWeek=durationDay*7,durationMonth=durationDay*30,durationYear=durationDay*365;const Milli=[YEAR,MONTH,DATE,HOURS,MINUTES,SECONDS,MILLISECONDS],Seconds=Milli.slice(0,-1),Minutes=Seconds.slice(0,-1),Hours=Minutes.slice(0,-1),Day=Hours.slice(0,-1),Week=[YEAR,WEEK],Month=[YEAR,MONTH],Year=[YEAR];const intervals=[[Seconds,1,durationSecond],[Seconds,5,5*durationSecond],[Seconds,15,15*durationSecond],[Seconds,30,30*durationSecond],[Minutes,1,durationMinute],[Minutes,5,5*durationMinute],[Minutes,15,15*durationMinute],[Minutes,30,30*durationMinute],[Hours,1,durationHour],[Hours,3,3*durationHour],[Hours,6,6*durationHour],[Hours,12,12*durationHour],[Day,1,durationDay],[Week,1,durationWeek],[Month,1,durationMonth],[Month,3,3*durationMonth],[Year,1,durationYear]];function bin(opt){const ext=opt.extent,max=opt.maxbins||40,target=Math.abs(vegaUtil.span(ext))/max;let i=bisector(i=>i[2]).right(intervals,target),units,step;if(i===intervals.length){units=Year,step=tickStep(ext[0]/durationYear,ext[1]/durationYear,max)}else if(i){i=intervals[target/intervals[i-1][2]<intervals[i][2]/target?i-1:i];units=i[0];step=i[1]}else{units=Milli;step=Math.max(tickStep(ext[0],ext[1],max),1)}return{units:units,step:step}}exports.DATE=DATE;exports.DAY=DAY;exports.DAYOFYEAR=DAYOFYEAR;exports.HOURS=HOURS;exports.MILLISECONDS=MILLISECONDS;exports.MINUTES=MINUTES;exports.MONTH=MONTH;exports.QUARTER=QUARTER;exports.SECONDS=SECONDS;exports.TIME_UNITS=TIME_UNITS;exports.WEEK=WEEK;exports.YEAR=YEAR;exports.dayofyear=dayofyear;exports.timeBin=bin;exports.timeFloor=timeFloor;exports.timeInterval=timeInterval;exports.timeOffset=timeOffset;exports.timeSequence=timeSequence;exports.timeUnitSpecifier=timeUnitSpecifier;exports.timeUnits=timeUnits;exports.utcFloor=utcFloor;exports.utcInterval=utcInterval;exports.utcOffset=utcOffset;exports.utcSequence=utcSequence;exports.utcdayofyear=utcdayofyear;exports.utcweek=utcweek;exports.week=week}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(62),__webpack_require__(75),__webpack_require__(76),__webpack_require__(67)):undefined})(this,(function(exports,vegaUtil,vegaCanvas,vegaLoader,vegaScale){"use strict";let gradient_id=0;function resetSVGGradientId(){gradient_id=0}const patternPrefix="p_";function isGradient(value){return value&&value.gradient}function gradientRef(g,defs,base){const type=g.gradient;let id=g.id,prefix=type==="radial"?patternPrefix:"";if(!id){id=g.id="gradient_"+gradient_id++;if(type==="radial"){g.x1=get(g.x1,.5);g.y1=get(g.y1,.5);g.r1=get(g.r1,0);g.x2=get(g.x2,.5);g.y2=get(g.y2,.5);g.r2=get(g.r2,.5);prefix=patternPrefix}else{g.x1=get(g.x1,0);g.y1=get(g.y1,0);g.x2=get(g.x2,1);g.y2=get(g.y2,0)}}defs[id]=g;return"url("+(base||"")+"#"+prefix+id+")"}function get(val,def){return val!=null?val:def}function Gradient(p0,p1){var stops=[],gradient;return gradient={gradient:"linear",x1:p0?p0[0]:0,y1:p0?p0[1]:0,x2:p1?p1[0]:1,y2:p1?p1[1]:0,stops:stops,stop:function(offset,color){stops.push({offset:offset,color:color});return gradient}}}function constant(x){return function constant(){return x}}const abs=Math.abs;const atan2=Math.atan2;const cos=Math.cos;const max=Math.max;const min=Math.min;const sin=Math.sin;const sqrt=Math.sqrt;const epsilon$1=1e-12;const pi$1=Math.PI;const halfPi=pi$1/2;const tau$1=2*pi$1;function acos(x){return x>1?0:x<-1?pi$1:Math.acos(x)}function asin(x){return x>=1?halfPi:x<=-1?-halfPi:Math.asin(x)}const pi=Math.PI,tau=2*pi,epsilon=1e-6,tauEpsilon=tau-epsilon;function append(strings){this._+=strings[0];for(let i=1,n=strings.length;i<n;++i){this._+=arguments[i]+strings[i]}}function appendRound(digits){let d=Math.floor(digits);if(!(d>=0))throw new Error(`invalid digits: ${digits}`);if(d>15)return append;const k=10**d;return function(strings){this._+=strings[0];for(let i=1,n=strings.length;i<n;++i){this._+=Math.round(arguments[i]*k)/k+strings[i]}}}class Path{constructor(digits){this._x0=this._y0=this._x1=this._y1=null;this._="";this._append=digits==null?append:appendRound(digits)}moveTo(x,y){this._append`M${this._x0=this._x1=+x},${this._y0=this._y1=+y}`}closePath(){if(this._x1!==null){this._x1=this._x0,this._y1=this._y0;this._append`Z`}}lineTo(x,y){this._append`L${this._x1=+x},${this._y1=+y}`}quadraticCurveTo(x1,y1,x,y){this._append`Q${+x1},${+y1},${this._x1=+x},${this._y1=+y}`}bezierCurveTo(x1,y1,x2,y2,x,y){this._append`C${+x1},${+y1},${+x2},${+y2},${this._x1=+x},${this._y1=+y}`}arcTo(x1,y1,x2,y2,r){x1=+x1,y1=+y1,x2=+x2,y2=+y2,r=+r;if(r<0)throw new Error(`negative radius: ${r}`);let x0=this._x1,y0=this._y1,x21=x2-x1,y21=y2-y1,x01=x0-x1,y01=y0-y1,l01_2=x01*x01+y01*y01;if(this._x1===null){this._append`M${this._x1=x1},${this._y1=y1}`}else if(!(l01_2>epsilon));else if(!(Math.abs(y01*x21-y21*x01)>epsilon)||!r){this._append`L${this._x1=x1},${this._y1=y1}`}else{let x20=x2-x0,y20=y2-y0,l21_2=x21*x21+y21*y21,l20_2=x20*x20+y20*y20,l21=Math.sqrt(l21_2),l01=Math.sqrt(l01_2),l=r*Math.tan((pi-Math.acos((l21_2+l01_2-l20_2)/(2*l21*l01)))/2),t01=l/l01,t21=l/l21;if(Math.abs(t01-1)>epsilon){this._append`L${x1+t01*x01},${y1+t01*y01}`}this._append`A${r},${r},0,0,${+(y01*x20>x01*y20)},${this._x1=x1+t21*x21},${this._y1=y1+t21*y21}`}}arc(x,y,r,a0,a1,ccw){x=+x,y=+y,r=+r,ccw=!!ccw;if(r<0)throw new Error(`negative radius: ${r}`);let dx=r*Math.cos(a0),dy=r*Math.sin(a0),x0=x+dx,y0=y+dy,cw=1^ccw,da=ccw?a0-a1:a1-a0;if(this._x1===null){this._append`M${x0},${y0}`}else if(Math.abs(this._x1-x0)>epsilon||Math.abs(this._y1-y0)>epsilon){this._append`L${x0},${y0}`}if(!r)return;if(da<0)da=da%tau+tau;if(da>tauEpsilon){this._append`A${r},${r},0,1,${cw},${x-dx},${y-dy}A${r},${r},0,1,${cw},${this._x1=x0},${this._y1=y0}`}else if(da>epsilon){this._append`A${r},${r},0,${+(da>=pi)},${cw},${this._x1=x+r*Math.cos(a1)},${this._y1=y+r*Math.sin(a1)}`}}rect(x,y,w,h){this._append`M${this._x0=this._x1=+x},${this._y0=this._y1=+y}h${w=+w}v${+h}h${-w}Z`}toString(){return this._}}function path$3(){return new Path}path$3.prototype=Path.prototype;function withPath(shape){let digits=3;shape.digits=function(_){if(!arguments.length)return digits;if(_==null){digits=null}else{const d=Math.floor(_);if(!(d>=0))throw new RangeError(`invalid digits: ${_}`);digits=d}return shape};return()=>new Path(digits)}function arcInnerRadius(d){return d.innerRadius}function arcOuterRadius(d){return d.outerRadius}function arcStartAngle(d){return d.startAngle}function arcEndAngle(d){return d.endAngle}function arcPadAngle(d){return d&&d.padAngle}function intersect$1(x0,y0,x1,y1,x2,y2,x3,y3){var x10=x1-x0,y10=y1-y0,x32=x3-x2,y32=y3-y2,t=y32*x10-x32*y10;if(t*t<epsilon$1)return;t=(x32*(y0-y2)-y32*(x0-x2))/t;return[x0+t*x10,y0+t*y10]}function cornerTangents(x0,y0,x1,y1,r1,rc,cw){var x01=x0-x1,y01=y0-y1,lo=(cw?rc:-rc)/sqrt(x01*x01+y01*y01),ox=lo*y01,oy=-lo*x01,x11=x0+ox,y11=y0+oy,x10=x1+ox,y10=y1+oy,x00=(x11+x10)/2,y00=(y11+y10)/2,dx=x10-x11,dy=y10-y11,d2=dx*dx+dy*dy,r=r1-rc,D=x11*y10-x10*y11,d=(dy<0?-1:1)*sqrt(max(0,r*r*d2-D*D)),cx0=(D*dy-dx*d)/d2,cy0=(-D*dx-dy*d)/d2,cx1=(D*dy+dx*d)/d2,cy1=(-D*dx+dy*d)/d2,dx0=cx0-x00,dy0=cy0-y00,dx1=cx1-x00,dy1=cy1-y00;if(dx0*dx0+dy0*dy0>dx1*dx1+dy1*dy1)cx0=cx1,cy0=cy1;return{cx:cx0,cy:cy0,x01:-ox,y01:-oy,x11:cx0*(r1/r-1),y11:cy0*(r1/r-1)}}function d3_arc(){var innerRadius=arcInnerRadius,outerRadius=arcOuterRadius,cornerRadius=constant(0),padRadius=null,startAngle=arcStartAngle,endAngle=arcEndAngle,padAngle=arcPadAngle,context=null,path=withPath(arc);function arc(){var buffer,r,r0=+innerRadius.apply(this,arguments),r1=+outerRadius.apply(this,arguments),a0=startAngle.apply(this,arguments)-halfPi,a1=endAngle.apply(this,arguments)-halfPi,da=abs(a1-a0),cw=a1>a0;if(!context)context=buffer=path();if(r1<r0)r=r1,r1=r0,r0=r;if(!(r1>epsilon$1))context.moveTo(0,0);else if(da>tau$1-epsilon$1){context.moveTo(r1*cos(a0),r1*sin(a0));context.arc(0,0,r1,a0,a1,!cw);if(r0>epsilon$1){context.moveTo(r0*cos(a1),r0*sin(a1));context.arc(0,0,r0,a1,a0,cw)}}else{var a01=a0,a11=a1,a00=a0,a10=a1,da0=da,da1=da,ap=padAngle.apply(this,arguments)/2,rp=ap>epsilon$1&&(padRadius?+padRadius.apply(this,arguments):sqrt(r0*r0+r1*r1)),rc=min(abs(r1-r0)/2,+cornerRadius.apply(this,arguments)),rc0=rc,rc1=rc,t0,t1;if(rp>epsilon$1){var p0=asin(rp/r0*sin(ap)),p1=asin(rp/r1*sin(ap));if((da0-=p0*2)>epsilon$1)p0*=cw?1:-1,a00+=p0,a10-=p0;else da0=0,a00=a10=(a0+a1)/2;if((da1-=p1*2)>epsilon$1)p1*=cw?1:-1,a01+=p1,a11-=p1;else da1=0,a01=a11=(a0+a1)/2}var x01=r1*cos(a01),y01=r1*sin(a01),x10=r0*cos(a10),y10=r0*sin(a10);if(rc>epsilon$1){var x11=r1*cos(a11),y11=r1*sin(a11),x00=r0*cos(a00),y00=r0*sin(a00),oc;if(da<pi$1){if(oc=intersect$1(x01,y01,x00,y00,x11,y11,x10,y10)){var ax=x01-oc[0],ay=y01-oc[1],bx=x11-oc[0],by=y11-oc[1],kc=1/sin(acos((ax*bx+ay*by)/(sqrt(ax*ax+ay*ay)*sqrt(bx*bx+by*by)))/2),lc=sqrt(oc[0]*oc[0]+oc[1]*oc[1]);rc0=min(rc,(r0-lc)/(kc-1));rc1=min(rc,(r1-lc)/(kc+1))}else{rc0=rc1=0}}}if(!(da1>epsilon$1))context.moveTo(x01,y01);else if(rc1>epsilon$1){t0=cornerTangents(x00,y00,x01,y01,r1,rc1,cw);t1=cornerTangents(x11,y11,x10,y10,r1,rc1,cw);context.moveTo(t0.cx+t0.x01,t0.cy+t0.y01);if(rc1<rc)context.arc(t0.cx,t0.cy,rc1,atan2(t0.y01,t0.x01),atan2(t1.y01,t1.x01),!cw);else{context.arc(t0.cx,t0.cy,rc1,atan2(t0.y01,t0.x01),atan2(t0.y11,t0.x11),!cw);context.arc(0,0,r1,atan2(t0.cy+t0.y11,t0.cx+t0.x11),atan2(t1.cy+t1.y11,t1.cx+t1.x11),!cw);context.arc(t1.cx,t1.cy,rc1,atan2(t1.y11,t1.x11),atan2(t1.y01,t1.x01),!cw)}}else context.moveTo(x01,y01),context.arc(0,0,r1,a01,a11,!cw);if(!(r0>epsilon$1)||!(da0>epsilon$1))context.lineTo(x10,y10);else if(rc0>epsilon$1){t0=cornerTangents(x10,y10,x11,y11,r0,-rc0,cw);t1=cornerTangents(x01,y01,x00,y00,r0,-rc0,cw);context.lineTo(t0.cx+t0.x01,t0.cy+t0.y01);if(rc0<rc)context.arc(t0.cx,t0.cy,rc0,atan2(t0.y01,t0.x01),atan2(t1.y01,t1.x01),!cw);else{context.arc(t0.cx,t0.cy,rc0,atan2(t0.y01,t0.x01),atan2(t0.y11,t0.x11),!cw);context.arc(0,0,r0,atan2(t0.cy+t0.y11,t0.cx+t0.x11),atan2(t1.cy+t1.y11,t1.cx+t1.x11),cw);context.arc(t1.cx,t1.cy,rc0,atan2(t1.y11,t1.x11),atan2(t1.y01,t1.x01),!cw)}}else context.arc(0,0,r0,a10,a00,cw)}context.closePath();if(buffer)return context=null,buffer+""||null}arc.centroid=function(){var r=(+innerRadius.apply(this,arguments)+ +outerRadius.apply(this,arguments))/2,a=(+startAngle.apply(this,arguments)+ +endAngle.apply(this,arguments))/2-pi$1/2;return[cos(a)*r,sin(a)*r]};arc.innerRadius=function(_){return arguments.length?(innerRadius=typeof _==="function"?_:constant(+_),arc):innerRadius};arc.outerRadius=function(_){return arguments.length?(outerRadius=typeof _==="function"?_:constant(+_),arc):outerRadius};arc.cornerRadius=function(_){return arguments.length?(cornerRadius=typeof _==="function"?_:constant(+_),arc):cornerRadius};arc.padRadius=function(_){return arguments.length?(padRadius=_==null?null:typeof _==="function"?_:constant(+_),arc):padRadius};arc.startAngle=function(_){return arguments.length?(startAngle=typeof _==="function"?_:constant(+_),arc):startAngle};arc.endAngle=function(_){return arguments.length?(endAngle=typeof _==="function"?_:constant(+_),arc):endAngle};arc.padAngle=function(_){return arguments.length?(padAngle=typeof _==="function"?_:constant(+_),arc):padAngle};arc.context=function(_){return arguments.length?(context=_==null?null:_,arc):context};return arc}function array(x){return typeof x==="object"&&"length"in x?x:Array.from(x)}function Linear(context){this._context=context}Linear.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:this._context.lineTo(x,y);break}}};function curveLinear(context){return new Linear(context)}function x$1(p){return p[0]}function y$1(p){return p[1]}function d3_line(x,y){var defined=constant(true),context=null,curve=curveLinear,output=null,path=withPath(line);x=typeof x==="function"?x:x===undefined?x$1:constant(x);y=typeof y==="function"?y:y===undefined?y$1:constant(y);function line(data){var i,n=(data=array(data)).length,d,defined0=false,buffer;if(context==null)output=curve(buffer=path());for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0)output.lineStart();else output.lineEnd()}if(defined0)output.point(+x(d,i,data),+y(d,i,data))}if(buffer)return output=null,buffer+""||null}line.x=function(_){return arguments.length?(x=typeof _==="function"?_:constant(+_),line):x};line.y=function(_){return arguments.length?(y=typeof _==="function"?_:constant(+_),line):y};line.defined=function(_){return arguments.length?(defined=typeof _==="function"?_:constant(!!_),line):defined};line.curve=function(_){return arguments.length?(curve=_,context!=null&&(output=curve(context)),line):curve};line.context=function(_){return arguments.length?(_==null?context=output=null:output=curve(context=_),line):context};return line}function d3_area(x0,y0,y1){var x1=null,defined=constant(true),context=null,curve=curveLinear,output=null,path=withPath(area);x0=typeof x0==="function"?x0:x0===undefined?x$1:constant(+x0);y0=typeof y0==="function"?y0:y0===undefined?constant(0):constant(+y0);y1=typeof y1==="function"?y1:y1===undefined?y$1:constant(+y1);function area(data){var i,j,k,n=(data=array(data)).length,d,defined0=false,buffer,x0z=new Array(n),y0z=new Array(n);if(context==null)output=curve(buffer=path());for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0){j=i;output.areaStart();output.lineStart()}else{output.lineEnd();output.lineStart();for(k=i-1;k>=j;--k){output.point(x0z[k],y0z[k])}output.lineEnd();output.areaEnd()}}if(defined0){x0z[i]=+x0(d,i,data),y0z[i]=+y0(d,i,data);output.point(x1?+x1(d,i,data):x0z[i],y1?+y1(d,i,data):y0z[i])}}if(buffer)return output=null,buffer+""||null}function arealine(){return d3_line().defined(defined).curve(curve).context(context)}area.x=function(_){return arguments.length?(x0=typeof _==="function"?_:constant(+_),x1=null,area):x0};area.x0=function(_){return arguments.length?(x0=typeof _==="function"?_:constant(+_),area):x0};area.x1=function(_){return arguments.length?(x1=_==null?null:typeof _==="function"?_:constant(+_),area):x1};area.y=function(_){return arguments.length?(y0=typeof _==="function"?_:constant(+_),y1=null,area):y0};area.y0=function(_){return arguments.length?(y0=typeof _==="function"?_:constant(+_),area):y0};area.y1=function(_){return arguments.length?(y1=_==null?null:typeof _==="function"?_:constant(+_),area):y1};area.lineX0=area.lineY0=function(){return arealine().x(x0).y(y0)};area.lineY1=function(){return arealine().x(x0).y(y1)};area.lineX1=function(){return arealine().x(x1).y(y0)};area.defined=function(_){return arguments.length?(defined=typeof _==="function"?_:constant(!!_),area):defined};area.curve=function(_){return arguments.length?(curve=_,context!=null&&(output=curve(context)),area):curve};area.context=function(_){return arguments.length?(_==null?context=output=null:output=curve(context=_),area):context};return area}var circle={draw(context,size){const r=sqrt(size/pi$1);context.moveTo(r,0);context.arc(0,0,r,0,tau$1)}};function Symbol(type,size){let context=null,path=withPath(symbol);type=typeof type==="function"?type:constant(type||circle);size=typeof size==="function"?size:constant(size===undefined?64:+size);function symbol(){let buffer;if(!context)context=buffer=path();type.apply(this,arguments).draw(context,+size.apply(this,arguments));if(buffer)return context=null,buffer+""||null}symbol.type=function(_){return arguments.length?(type=typeof _==="function"?_:constant(_),symbol):type};symbol.size=function(_){return arguments.length?(size=typeof _==="function"?_:constant(+_),symbol):size};symbol.context=function(_){return arguments.length?(context=_==null?null:_,symbol):context};return symbol}function noop(){}function point$4(that,x,y){that._context.bezierCurveTo((2*that._x0+that._x1)/3,(2*that._y0+that._y1)/3,(that._x0+2*that._x1)/3,(that._y0+2*that._y1)/3,(that._x0+4*that._x1+x)/6,(that._y0+4*that._y1+y)/6)}function Basis(context){this._context=context}Basis.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN;this._point=0},lineEnd:function(){switch(this._point){case 3:point$4(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:point$4(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function curveBasis(context){return new Basis(context)}function BasisClosed(context){this._context=context}BasisClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN;this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x2,this._y2);this._context.closePath();break}case 2:{this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3);this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3);this._context.closePath();break}case 3:{this.point(this._x2,this._y2);this.point(this._x3,this._y3);this.point(this._x4,this._y4);break}}},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._x2=x,this._y2=y;break;case 1:this._point=2;this._x3=x,this._y3=y;break;case 2:this._point=3;this._x4=x,this._y4=y;this._context.moveTo((this._x0+4*this._x1+x)/6,(this._y0+4*this._y1+y)/6);break;default:point$4(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function curveBasisClosed(context){return new BasisClosed(context)}function BasisOpen(context){this._context=context}BasisOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN;this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var x0=(this._x0+4*this._x1+x)/6,y0=(this._y0+4*this._y1+y)/6;this._line?this._context.lineTo(x0,y0):this._context.moveTo(x0,y0);break;case 3:this._point=4;default:point$4(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function curveBasisOpen(context){return new BasisOpen(context)}function Bundle(context,beta){this._basis=new Basis(context);this._beta=beta}Bundle.prototype={lineStart:function(){this._x=[];this._y=[];this._basis.lineStart()},lineEnd:function(){var x=this._x,y=this._y,j=x.length-1;if(j>0){var x0=x[0],y0=y[0],dx=x[j]-x0,dy=y[j]-y0,i=-1,t;while(++i<=j){t=i/j;this._basis.point(this._beta*x[i]+(1-this._beta)*(x0+t*dx),this._beta*y[i]+(1-this._beta)*(y0+t*dy))}}this._x=this._y=null;this._basis.lineEnd()},point:function(x,y){this._x.push(+x);this._y.push(+y)}};var curveBundle=function custom(beta){function bundle(context){return beta===1?new Basis(context):new Bundle(context,beta)}bundle.beta=function(beta){return custom(+beta)};return bundle}(.85);function point$3(that,x,y){that._context.bezierCurveTo(that._x1+that._k*(that._x2-that._x0),that._y1+that._k*(that._y2-that._y0),that._x2+that._k*(that._x1-x),that._y2+that._k*(that._y1-y),that._x2,that._y2)}function Cardinal(context,tension){this._context=context;this._k=(1-tension)/6}Cardinal.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:point$3(this,this._x1,this._y1);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;this._x1=x,this._y1=y;break;case 2:this._point=3;default:point$3(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var curveCardinal=function custom(tension){function cardinal(context){return new Cardinal(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function CardinalClosed(context,tension){this._context=context;this._k=(1-tension)/6}CardinalClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN;this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x3,this._y3);this._context.closePath();break}case 2:{this._context.lineTo(this._x3,this._y3);this._context.closePath();break}case 3:{this.point(this._x3,this._y3);this.point(this._x4,this._y4);this.point(this._x5,this._y5);break}}},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._x3=x,this._y3=y;break;case 1:this._point=2;this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3;this._x5=x,this._y5=y;break;default:point$3(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var curveCardinalClosed=function custom(tension){function cardinal(context){return new CardinalClosed(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function CardinalOpen(context,tension){this._context=context;this._k=(1-tension)/6}CardinalOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$3(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var curveCardinalOpen=function custom(tension){function cardinal(context){return new CardinalOpen(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function point$2(that,x,y){var x1=that._x1,y1=that._y1,x2=that._x2,y2=that._y2;if(that._l01_a>epsilon$1){var a=2*that._l01_2a+3*that._l01_a*that._l12_a+that._l12_2a,n=3*that._l01_a*(that._l01_a+that._l12_a);x1=(x1*a-that._x0*that._l12_2a+that._x2*that._l01_2a)/n;y1=(y1*a-that._y0*that._l12_2a+that._y2*that._l01_2a)/n}if(that._l23_a>epsilon$1){var b=2*that._l23_2a+3*that._l23_a*that._l12_a+that._l12_2a,m=3*that._l23_a*(that._l23_a+that._l12_a);x2=(x2*b+that._x1*that._l23_2a-x*that._l12_2a)/m;y2=(y2*b+that._y1*that._l23_2a-y*that._l12_2a)/m}that._context.bezierCurveTo(x1,y1,x2,y2,that._x2,that._y2)}function CatmullRom(context,alpha){this._context=context;this._alpha=alpha}CatmullRom.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var curveCatmullRom=function custom(alpha){function catmullRom(context){return alpha?new CatmullRom(context,alpha):new Cardinal(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function CatmullRomClosed(context,alpha){this._context=context;this._alpha=alpha}CatmullRomClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x3,this._y3);this._context.closePath();break}case 2:{this._context.lineTo(this._x3,this._y3);this._context.closePath();break}case 3:{this.point(this._x3,this._y3);this.point(this._x4,this._y4);this.point(this._x5,this._y5);break}}},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;this._x3=x,this._y3=y;break;case 1:this._point=2;this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3;this._x5=x,this._y5=y;break;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var curveCatmullRomClosed=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomClosed(context,alpha):new CardinalClosed(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function CatmullRomOpen(context,alpha){this._context=context;this._alpha=alpha}CatmullRomOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var curveCatmullRomOpen=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomOpen(context,alpha):new CardinalOpen(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function LinearClosed(context){this._context=context}LinearClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._point=0},lineEnd:function(){if(this._point)this._context.closePath()},point:function(x,y){x=+x,y=+y;if(this._point)this._context.lineTo(x,y);else this._point=1,this._context.moveTo(x,y)}};function curveLinearClosed(context){return new LinearClosed(context)}function sign(x){return x<0?-1:1}function slope3(that,x2,y2){var h0=that._x1-that._x0,h1=x2-that._x1,s0=(that._y1-that._y0)/(h0||h1<0&&-0),s1=(y2-that._y1)/(h1||h0<0&&-0),p=(s0*h1+s1*h0)/(h0+h1);return(sign(s0)+sign(s1))*Math.min(Math.abs(s0),Math.abs(s1),.5*Math.abs(p))||0}function slope2(that,t){var h=that._x1-that._x0;return h?(3*(that._y1-that._y0)/h-t)/2:t}function point$1(that,t0,t1){var x0=that._x0,y0=that._y0,x1=that._x1,y1=that._y1,dx=(x1-x0)/3;that._context.bezierCurveTo(x0+dx,y0+dx*t0,x1-dx,y1-dx*t1,x1,y1)}function MonotoneX(context){this._context=context}MonotoneX.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN;this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:point$1(this,this._t0,slope2(this,this._t0));break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){var t1=NaN;x=+x,y=+y;if(x===this._x1&&y===this._y1)return;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;point$1(this,slope2(this,t1=slope3(this,x,y)),t1);break;default:point$1(this,this._t0,t1=slope3(this,x,y));break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y;this._t0=t1}};function MonotoneY(context){this._context=new ReflectContext(context)}(MonotoneY.prototype=Object.create(MonotoneX.prototype)).point=function(x,y){MonotoneX.prototype.point.call(this,y,x)};function ReflectContext(context){this._context=context}ReflectContext.prototype={moveTo:function(x,y){this._context.moveTo(y,x)},closePath:function(){this._context.closePath()},lineTo:function(x,y){this._context.lineTo(y,x)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._context.bezierCurveTo(y1,x1,y2,x2,y,x)}};function monotoneX(context){return new MonotoneX(context)}function monotoneY(context){return new MonotoneY(context)}function Natural(context){this._context=context}Natural.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=[];this._y=[]},lineEnd:function(){var x=this._x,y=this._y,n=x.length;if(n){this._line?this._context.lineTo(x[0],y[0]):this._context.moveTo(x[0],y[0]);if(n===2){this._context.lineTo(x[1],y[1])}else{var px=controlPoints(x),py=controlPoints(y);for(var i0=0,i1=1;i1<n;++i0,++i1){this._context.bezierCurveTo(px[0][i0],py[0][i0],px[1][i0],py[1][i0],x[i1],y[i1])}}}if(this._line||this._line!==0&&n===1)this._context.closePath();this._line=1-this._line;this._x=this._y=null},point:function(x,y){this._x.push(+x);this._y.push(+y)}};function controlPoints(x){var i,n=x.length-1,m,a=new Array(n),b=new Array(n),r=new Array(n);a[0]=0,b[0]=2,r[0]=x[0]+2*x[1];for(i=1;i<n-1;++i)a[i]=1,b[i]=4,r[i]=4*x[i]+2*x[i+1];a[n-1]=2,b[n-1]=7,r[n-1]=8*x[n-1]+x[n];for(i=1;i<n;++i)m=a[i]/b[i-1],b[i]-=m,r[i]-=m*r[i-1];a[n-1]=r[n-1]/b[n-1];for(i=n-2;i>=0;--i)a[i]=(r[i]-a[i+1])/b[i];b[n-1]=(x[n]+a[n-1])/2;for(i=0;i<n-1;++i)b[i]=2*x[i+1]-a[i+1];return[a,b]}function curveNatural(context){return new Natural(context)}function Step(context,t){this._context=context;this._t=t}Step.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=this._y=NaN;this._point=0},lineEnd:function(){if(0<this._t&&this._t<1&&this._point===2)this._context.lineTo(this._x,this._y);if(this._line||this._line!==0&&this._point===1)this._context.closePath();if(this._line>=0)this._t=1-this._t,this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:{if(this._t<=0){this._context.lineTo(this._x,y);this._context.lineTo(x,y)}else{var x1=this._x*(1-this._t)+x*this._t;this._context.lineTo(x1,this._y);this._context.lineTo(x1,y)}break}}this._x=x,this._y=y}};function curveStep(context){return new Step(context,.5)}function stepBefore(context){return new Step(context,0)}function stepAfter(context){return new Step(context,1)}const lookup={basis:{curve:curveBasis},"basis-closed":{curve:curveBasisClosed},"basis-open":{curve:curveBasisOpen},bundle:{curve:curveBundle,tension:"beta",value:.85},cardinal:{curve:curveCardinal,tension:"tension",value:0},"cardinal-open":{curve:curveCardinalOpen,tension:"tension",value:0},"cardinal-closed":{curve:curveCardinalClosed,tension:"tension",value:0},"catmull-rom":{curve:curveCatmullRom,tension:"alpha",value:.5},"catmull-rom-closed":{curve:curveCatmullRomClosed,tension:"alpha",value:.5},"catmull-rom-open":{curve:curveCatmullRomOpen,tension:"alpha",value:.5},linear:{curve:curveLinear},"linear-closed":{curve:curveLinearClosed},monotone:{horizontal:monotoneY,vertical:monotoneX},natural:{curve:curveNatural},step:{curve:curveStep},"step-after":{curve:stepAfter},"step-before":{curve:stepBefore}};function curves(type,orientation,tension){var entry=vegaUtil.hasOwnProperty(lookup,type)&&lookup[type],curve=null;if(entry){curve=entry.curve||entry[orientation||"vertical"];if(entry.tension&&tension!=null){curve=curve[entry.tension](tension)}}return curve}const paramCounts={m:2,l:2,h:1,v:1,z:0,c:6,s:4,q:4,t:2,a:7};const commandPattern=/[mlhvzcsqta]([^mlhvzcsqta]+|$)/gi;const numberPattern=/^[+-]?(([0-9]*\.[0-9]+)|([0-9]+\.)|([0-9]+))([eE][+-]?[0-9]+)?/;const spacePattern=/^((\s+,?\s*)|(,\s*))/;const flagPattern=/^[01]/;function parse(path){const commands=[];const matches=path.match(commandPattern)||[];matches.forEach(str=>{let cmd=str[0];const type=cmd.toLowerCase();const paramCount=paramCounts[type];const params=parseParams(type,paramCount,str.slice(1).trim());const count=params.length;if(count<paramCount||count&&count%paramCount!==0){throw Error("Invalid SVG path, incorrect parameter count")}commands.push([cmd,...params.slice(0,paramCount)]);if(count===paramCount){return}if(type==="m"){cmd=cmd==="M"?"L":"l"}for(let i=paramCount;i<count;i+=paramCount){commands.push([cmd,...params.slice(i,i+paramCount)])}});return commands}function parseParams(type,paramCount,segment){const params=[];for(let index=0;paramCount&&index<segment.length;){for(let i=0;i<paramCount;++i){const pattern=type==="a"&&(i===3||i===4)?flagPattern:numberPattern;const match=segment.slice(index).match(pattern);if(match===null){throw Error("Invalid SVG path, incorrect parameter type")}index+=match[0].length;params.push(+match[0]);const ws=segment.slice(index).match(spacePattern);if(ws!==null){index+=ws[0].length}}}return params}const DegToRad=Math.PI/180;const Epsilon=1e-14;const HalfPi=Math.PI/2;const Tau=Math.PI*2;const HalfSqrt3=Math.sqrt(3)/2;var segmentCache={};var bezierCache={};var join=[].join;function segments(x,y,rx,ry,large,sweep,rotateX,ox,oy){const key=join.call(arguments);if(segmentCache[key]){return segmentCache[key]}const th=rotateX*DegToRad;const sin_th=Math.sin(th);const cos_th=Math.cos(th);rx=Math.abs(rx);ry=Math.abs(ry);const px=cos_th*(ox-x)*.5+sin_th*(oy-y)*.5;const py=cos_th*(oy-y)*.5-sin_th*(ox-x)*.5;let pl=px*px/(rx*rx)+py*py/(ry*ry);if(pl>1){pl=Math.sqrt(pl);rx*=pl;ry*=pl}const a00=cos_th/rx;const a01=sin_th/rx;const a10=-sin_th/ry;const a11=cos_th/ry;const x0=a00*ox+a01*oy;const y0=a10*ox+a11*oy;const x1=a00*x+a01*y;const y1=a10*x+a11*y;const d=(x1-x0)*(x1-x0)+(y1-y0)*(y1-y0);let sfactor_sq=1/d-.25;if(sfactor_sq<0)sfactor_sq=0;let sfactor=Math.sqrt(sfactor_sq);if(sweep==large)sfactor=-sfactor;const xc=.5*(x0+x1)-sfactor*(y1-y0);const yc=.5*(y0+y1)+sfactor*(x1-x0);const th0=Math.atan2(y0-yc,x0-xc);const th1=Math.atan2(y1-yc,x1-xc);let th_arc=th1-th0;if(th_arc<0&&sweep===1){th_arc+=Tau}else if(th_arc>0&&sweep===0){th_arc-=Tau}const segs=Math.ceil(Math.abs(th_arc/(HalfPi+.001)));const result=[];for(let i=0;i<segs;++i){const th2=th0+i*th_arc/segs;const th3=th0+(i+1)*th_arc/segs;result[i]=[xc,yc,th2,th3,rx,ry,sin_th,cos_th]}return segmentCache[key]=result}function bezier(params){const key=join.call(params);if(bezierCache[key]){return bezierCache[key]}var cx=params[0],cy=params[1],th0=params[2],th1=params[3],rx=params[4],ry=params[5],sin_th=params[6],cos_th=params[7];const a00=cos_th*rx;const a01=-sin_th*ry;const a10=sin_th*rx;const a11=cos_th*ry;const cos_th0=Math.cos(th0);const sin_th0=Math.sin(th0);const cos_th1=Math.cos(th1);const sin_th1=Math.sin(th1);const th_half=.5*(th1-th0);const sin_th_h2=Math.sin(th_half*.5);const t=8/3*sin_th_h2*sin_th_h2/Math.sin(th_half);const x1=cx+cos_th0-t*sin_th0;const y1=cy+sin_th0+t*cos_th0;const x3=cx+cos_th1;const y3=cy+sin_th1;const x2=x3+t*sin_th1;const y2=y3-t*cos_th1;return bezierCache[key]=[a00*x1+a01*y1,a10*x1+a11*y1,a00*x2+a01*y2,a10*x2+a11*y2,a00*x3+a01*y3,a10*x3+a11*y3]}const temp=["l",0,0,0,0,0,0,0];function scale$1(current,sX,sY){const c=temp[0]=current[0];if(c==="a"||c==="A"){temp[1]=sX*current[1];temp[2]=sY*current[2];temp[3]=current[3];temp[4]=current[4];temp[5]=current[5];temp[6]=sX*current[6];temp[7]=sY*current[7]}else if(c==="h"||c==="H"){temp[1]=sX*current[1]}else if(c==="v"||c==="V"){temp[1]=sY*current[1]}else{for(var i=1,n=current.length;i<n;++i){temp[i]=(i%2==1?sX:sY)*current[i]}}return temp}function pathRender(context,path,l,t,sX,sY){var current,previous=null,x=0,y=0,controlX=0,controlY=0,tempX,tempY,tempControlX,tempControlY,anchorX=0,anchorY=0;if(l==null)l=0;if(t==null)t=0;if(sX==null)sX=1;if(sY==null)sY=sX;if(context.beginPath)context.beginPath();for(var i=0,len=path.length;i<len;++i){current=path[i];if(sX!==1||sY!==1){current=scale$1(current,sX,sY)}switch(current[0]){case"l":x+=current[1];y+=current[2];context.lineTo(x+l,y+t);break;case"L":x=current[1];y=current[2];context.lineTo(x+l,y+t);break;case"h":x+=current[1];context.lineTo(x+l,y+t);break;case"H":x=current[1];context.lineTo(x+l,y+t);break;case"v":y+=current[1];context.lineTo(x+l,y+t);break;case"V":y=current[1];context.lineTo(x+l,y+t);break;case"m":x+=current[1];y+=current[2];anchorX=x;anchorY=y;context.moveTo(x+l,y+t);break;case"M":x=current[1];y=current[2];anchorX=x;anchorY=y;context.moveTo(x+l,y+t);break;case"c":tempX=x+current[5];tempY=y+current[6];controlX=x+current[3];controlY=y+current[4];context.bezierCurveTo(x+current[1]+l,y+current[2]+t,controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case"C":x=current[5];y=current[6];controlX=current[3];controlY=current[4];context.bezierCurveTo(current[1]+l,current[2]+t,controlX+l,controlY+t,x+l,y+t);break;case"s":tempX=x+current[3];tempY=y+current[4];controlX=2*x-controlX;controlY=2*y-controlY;context.bezierCurveTo(controlX+l,controlY+t,x+current[1]+l,y+current[2]+t,tempX+l,tempY+t);controlX=x+current[1];controlY=y+current[2];x=tempX;y=tempY;break;case"S":tempX=current[3];tempY=current[4];controlX=2*x-controlX;controlY=2*y-controlY;context.bezierCurveTo(controlX+l,controlY+t,current[1]+l,current[2]+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=current[1];controlY=current[2];break;case"q":tempX=x+current[3];tempY=y+current[4];controlX=x+current[1];controlY=y+current[2];context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case"Q":tempX=current[3];tempY=current[4];context.quadraticCurveTo(current[1]+l,current[2]+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=current[1];controlY=current[2];break;case"t":tempX=x+current[1];tempY=y+current[2];if(previous[0].match(/[QqTt]/)===null){controlX=x;controlY=y}else if(previous[0]==="t"){controlX=2*x-tempControlX;controlY=2*y-tempControlY}else if(previous[0]==="q"){controlX=2*x-controlX;controlY=2*y-controlY}tempControlX=controlX;tempControlY=controlY;context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;controlX=x+current[1];controlY=y+current[2];break;case"T":tempX=current[1];tempY=current[2];controlX=2*x-controlX;controlY=2*y-controlY;context.quadraticCurveTo(controlX+l,controlY+t,tempX+l,tempY+t);x=tempX;y=tempY;break;case"a":drawArc(context,x+l,y+t,[current[1],current[2],current[3],current[4],current[5],current[6]+x+l,current[7]+y+t]);x+=current[6];y+=current[7];break;case"A":drawArc(context,x+l,y+t,[current[1],current[2],current[3],current[4],current[5],current[6]+l,current[7]+t]);x=current[6];y=current[7];break;case"z":case"Z":x=anchorX;y=anchorY;context.closePath();break}previous=current}}function drawArc(context,x,y,coords){const seg=segments(coords[5],coords[6],coords[0],coords[1],coords[3],coords[4],coords[2],x,y);for(let i=0;i<seg.length;++i){const bez=bezier(seg[i]);context.bezierCurveTo(bez[0],bez[1],bez[2],bez[3],bez[4],bez[5])}}const Tan30=.5773502691896257;const builtins={circle:{draw:function(context,size){const r=Math.sqrt(size)/2;context.moveTo(r,0);context.arc(0,0,r,0,Tau)}},cross:{draw:function(context,size){var r=Math.sqrt(size)/2,s=r/2.5;context.moveTo(-r,-s);context.lineTo(-r,s);context.lineTo(-s,s);context.lineTo(-s,r);context.lineTo(s,r);context.lineTo(s,s);context.lineTo(r,s);context.lineTo(r,-s);context.lineTo(s,-s);context.lineTo(s,-r);context.lineTo(-s,-r);context.lineTo(-s,-s);context.closePath()}},diamond:{draw:function(context,size){const r=Math.sqrt(size)/2;context.moveTo(-r,0);context.lineTo(0,-r);context.lineTo(r,0);context.lineTo(0,r);context.closePath()}},square:{draw:function(context,size){var w=Math.sqrt(size),x=-w/2;context.rect(x,x,w,w)}},arrow:{draw:function(context,size){var r=Math.sqrt(size)/2,s=r/7,t=r/2.5,v=r/8;context.moveTo(-s,r);context.lineTo(s,r);context.lineTo(s,-v);context.lineTo(t,-v);context.lineTo(0,-r);context.lineTo(-t,-v);context.lineTo(-s,-v);context.closePath()}},wedge:{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r,o=h-r*Tan30,b=r/4;context.moveTo(0,-h-o);context.lineTo(-b,h-o);context.lineTo(b,h-o);context.closePath()}},triangle:{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r,o=h-r*Tan30;context.moveTo(0,-h-o);context.lineTo(-r,h-o);context.lineTo(r,h-o);context.closePath()}},"triangle-up":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(0,-h);context.lineTo(-r,h);context.lineTo(r,h);context.closePath()}},"triangle-down":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(0,h);context.lineTo(-r,-h);context.lineTo(r,-h);context.closePath()}},"triangle-right":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(h,0);context.lineTo(-h,-r);context.lineTo(-h,r);context.closePath()}},"triangle-left":{draw:function(context,size){var r=Math.sqrt(size)/2,h=HalfSqrt3*r;context.moveTo(-h,0);context.lineTo(h,-r);context.lineTo(h,r);context.closePath()}},stroke:{draw:function(context,size){const r=Math.sqrt(size)/2;context.moveTo(-r,0);context.lineTo(r,0)}}};function symbols(_){return vegaUtil.hasOwnProperty(builtins,_)?builtins[_]:customSymbol(_)}var custom={};function customSymbol(path){if(!vegaUtil.hasOwnProperty(custom,path)){const parsed=parse(path);custom[path]={draw:function(context,size){pathRender(context,parsed,0,0,Math.sqrt(size)/2)}}}return custom[path]}const C=.448084975506;function rectangleX(d){return d.x}function rectangleY(d){return d.y}function rectangleWidth(d){return d.width}function rectangleHeight(d){return d.height}function number(_){return typeof _==="function"?_:()=>+_}function clamp(value,min,max){return Math.max(min,Math.min(value,max))}function vg_rect(){var x=rectangleX,y=rectangleY,width=rectangleWidth,height=rectangleHeight,crTL=number(0),crTR=crTL,crBL=crTL,crBR=crTL,context=null;function rectangle(_,x0,y0){var buffer,x1=x0!=null?x0:+x.call(this,_),y1=y0!=null?y0:+y.call(this,_),w=+width.call(this,_),h=+height.call(this,_),s=Math.min(w,h)/2,tl=clamp(+crTL.call(this,_),0,s),tr=clamp(+crTR.call(this,_),0,s),bl=clamp(+crBL.call(this,_),0,s),br=clamp(+crBR.call(this,_),0,s);if(!context)context=buffer=path$3();if(tl<=0&&tr<=0&&bl<=0&&br<=0){context.rect(x1,y1,w,h)}else{var x2=x1+w,y2=y1+h;context.moveTo(x1+tl,y1);context.lineTo(x2-tr,y1);context.bezierCurveTo(x2-C*tr,y1,x2,y1+C*tr,x2,y1+tr);context.lineTo(x2,y2-br);context.bezierCurveTo(x2,y2-C*br,x2-C*br,y2,x2-br,y2);context.lineTo(x1+bl,y2);context.bezierCurveTo(x1+C*bl,y2,x1,y2-C*bl,x1,y2-bl);context.lineTo(x1,y1+tl);context.bezierCurveTo(x1,y1+C*tl,x1+C*tl,y1,x1+tl,y1);context.closePath()}if(buffer){context=null;return buffer+""||null}}rectangle.x=function(_){if(arguments.length){x=number(_);return rectangle}else{return x}};rectangle.y=function(_){if(arguments.length){y=number(_);return rectangle}else{return y}};rectangle.width=function(_){if(arguments.length){width=number(_);return rectangle}else{return width}};rectangle.height=function(_){if(arguments.length){height=number(_);return rectangle}else{return height}};rectangle.cornerRadius=function(tl,tr,br,bl){if(arguments.length){crTL=number(tl);crTR=tr!=null?number(tr):crTL;crBR=br!=null?number(br):crTL;crBL=bl!=null?number(bl):crTR;return rectangle}else{return crTL}};rectangle.context=function(_){if(arguments.length){context=_==null?null:_;return rectangle}else{return context}};return rectangle}function vg_trail(){var x,y,size,defined,context=null,ready,x1,y1,r1;function point(x2,y2,w2){const r2=w2/2;if(ready){var ux=y1-y2,uy=x2-x1;if(ux||uy){var ud=Math.hypot(ux,uy),rx=(ux/=ud)*r1,ry=(uy/=ud)*r1,t=Math.atan2(uy,ux);context.moveTo(x1-rx,y1-ry);context.lineTo(x2-ux*r2,y2-uy*r2);context.arc(x2,y2,r2,t-Math.PI,t);context.lineTo(x1+rx,y1+ry);context.arc(x1,y1,r1,t,t+Math.PI)}else{context.arc(x2,y2,r2,0,Tau)}context.closePath()}else{ready=1}x1=x2;y1=y2;r1=r2}function trail(data){var i,n=data.length,d,defined0=false,buffer;if(context==null)context=buffer=path$3();for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0)ready=0}if(defined0)point(+x(d,i,data),+y(d,i,data),+size(d,i,data))}if(buffer){context=null;return buffer+""||null}}trail.x=function(_){if(arguments.length){x=_;return trail}else{return x}};trail.y=function(_){if(arguments.length){y=_;return trail}else{return y}};trail.size=function(_){if(arguments.length){size=_;return trail}else{return size}};trail.defined=function(_){if(arguments.length){defined=_;return trail}else{return defined}};trail.context=function(_){if(arguments.length){if(_==null){context=null}else{context=_}return trail}else{return context}};return trail}function value$1(a,b){return a!=null?a:b}const x=item=>item.x||0,y=item=>item.y||0,w=item=>item.width||0,h=item=>item.height||0,xw=item=>(item.x||0)+(item.width||0),yh=item=>(item.y||0)+(item.height||0),sa=item=>item.startAngle||0,ea=item=>item.endAngle||0,pa=item=>item.padAngle||0,ir=item=>item.innerRadius||0,or=item=>item.outerRadius||0,cr=item=>item.cornerRadius||0,tl=item=>value$1(item.cornerRadiusTopLeft,item.cornerRadius)||0,tr=item=>value$1(item.cornerRadiusTopRight,item.cornerRadius)||0,br=item=>value$1(item.cornerRadiusBottomRight,item.cornerRadius)||0,bl=item=>value$1(item.cornerRadiusBottomLeft,item.cornerRadius)||0,sz=item=>value$1(item.size,64),ts=item=>item.size||1,def=item=>!(item.defined===false),type=item=>symbols(item.shape||"circle");const arcShape=d3_arc().startAngle(sa).endAngle(ea).padAngle(pa).innerRadius(ir).outerRadius(or).cornerRadius(cr),areavShape=d3_area().x(x).y1(y).y0(yh).defined(def),areahShape=d3_area().y(y).x1(x).x0(xw).defined(def),lineShape=d3_line().x(x).y(y).defined(def),rectShape=vg_rect().x(x).y(y).width(w).height(h).cornerRadius(tl,tr,br,bl),symbolShape=Symbol().type(type).size(sz),trailShape=vg_trail().x(x).y(y).defined(def).size(ts);function hasCornerRadius(item){return item.cornerRadius||item.cornerRadiusTopLeft||item.cornerRadiusTopRight||item.cornerRadiusBottomRight||item.cornerRadiusBottomLeft}function arc$1(context,item){return arcShape.context(context)(item)}function area$1(context,items){const item=items[0],interp=item.interpolate||"linear";return(item.orient==="horizontal"?areahShape:areavShape).curve(curves(interp,item.orient,item.tension)).context(context)(items)}function line$1(context,items){const item=items[0],interp=item.interpolate||"linear";return lineShape.curve(curves(interp,item.orient,item.tension)).context(context)(items)}function rectangle(context,item,x,y){return rectShape.context(context)(item,x,y)}function shape$1(context,item){return(item.mark.shape||item.shape).context(context)(item)}function symbol$1(context,item){return symbolShape.context(context)(item)}function trail$1(context,items){return trailShape.context(context)(items)}var clip_id=1;function resetSVGClipId(){clip_id=1}function clip$1(renderer,item,size){var clip=item.clip,defs=renderer._defs,id=item.clip_id||(item.clip_id="clip"+clip_id++),c=defs.clipping[id]||(defs.clipping[id]={id:id});if(vegaUtil.isFunction(clip)){c.path=clip(null)}else if(hasCornerRadius(size)){c.path=rectangle(null,size,0,0)}else{c.width=size.width||0;c.height=size.height||0}return"url(#"+id+")"}function Bounds(b){this.clear();if(b)this.union(b)}Bounds.prototype={clone(){return new Bounds(this)},clear(){this.x1=+Number.MAX_VALUE;this.y1=+Number.MAX_VALUE;this.x2=-Number.MAX_VALUE;this.y2=-Number.MAX_VALUE;return this},empty(){return this.x1===+Number.MAX_VALUE&&this.y1===+Number.MAX_VALUE&&this.x2===-Number.MAX_VALUE&&this.y2===-Number.MAX_VALUE},equals(b){return this.x1===b.x1&&this.y1===b.y1&&this.x2===b.x2&&this.y2===b.y2},set(x1,y1,x2,y2){if(x2<x1){this.x2=x1;this.x1=x2}else{this.x1=x1;this.x2=x2}if(y2<y1){this.y2=y1;this.y1=y2}else{this.y1=y1;this.y2=y2}return this},add(x,y){if(x<this.x1)this.x1=x;if(y<this.y1)this.y1=y;if(x>this.x2)this.x2=x;if(y>this.y2)this.y2=y;return this},expand(d){this.x1-=d;this.y1-=d;this.x2+=d;this.y2+=d;return this},round(){this.x1=Math.floor(this.x1);this.y1=Math.floor(this.y1);this.x2=Math.ceil(this.x2);this.y2=Math.ceil(this.y2);return this},scale(s){this.x1*=s;this.y1*=s;this.x2*=s;this.y2*=s;return this},translate(dx,dy){this.x1+=dx;this.x2+=dx;this.y1+=dy;this.y2+=dy;return this},rotate(angle,x,y){const p=this.rotatedPoints(angle,x,y);return this.clear().add(p[0],p[1]).add(p[2],p[3]).add(p[4],p[5]).add(p[6],p[7])},rotatedPoints(angle,x,y){var{x1:x1,y1:y1,x2:x2,y2:y2}=this,cos=Math.cos(angle),sin=Math.sin(angle),cx=x-x*cos+y*sin,cy=y-x*sin-y*cos;return[cos*x1-sin*y1+cx,sin*x1+cos*y1+cy,cos*x1-sin*y2+cx,sin*x1+cos*y2+cy,cos*x2-sin*y1+cx,sin*x2+cos*y1+cy,cos*x2-sin*y2+cx,sin*x2+cos*y2+cy]},union(b){if(b.x1<this.x1)this.x1=b.x1;if(b.y1<this.y1)this.y1=b.y1;if(b.x2>this.x2)this.x2=b.x2;if(b.y2>this.y2)this.y2=b.y2;return this},intersect(b){if(b.x1>this.x1)this.x1=b.x1;if(b.y1>this.y1)this.y1=b.y1;if(b.x2<this.x2)this.x2=b.x2;if(b.y2<this.y2)this.y2=b.y2;return this},encloses(b){return b&&this.x1<=b.x1&&this.x2>=b.x2&&this.y1<=b.y1&&this.y2>=b.y2},alignsWith(b){return b&&(this.x1==b.x1||this.x2==b.x2||this.y1==b.y1||this.y2==b.y2)},intersects(b){return b&&!(this.x2<b.x1||this.x1>b.x2||this.y2<b.y1||this.y1>b.y2)},contains(x,y){return!(x<this.x1||x>this.x2||y<this.y1||y>this.y2)},width(){return this.x2-this.x1},height(){return this.y2-this.y1}};function Item(mark){this.mark=mark;this.bounds=this.bounds||new Bounds}function GroupItem(mark){Item.call(this,mark);this.items=this.items||[]}vegaUtil.inherits(GroupItem,Item);class ResourceLoader{constructor(customLoader){this._pending=0;this._loader=customLoader||vegaLoader.loader()}pending(){return this._pending}sanitizeURL(uri){const loader=this;increment(loader);return loader._loader.sanitize(uri,{context:"href"}).then(opt=>{decrement(loader);return opt}).catch(()=>{decrement(loader);return null})}loadImage(uri){const loader=this,Image=vegaCanvas.image();increment(loader);return loader._loader.sanitize(uri,{context:"image"}).then(opt=>{const url=opt.href;if(!url||!Image)throw{url:url};const img=new Image;const cors=vegaUtil.hasOwnProperty(opt,"crossOrigin")?opt.crossOrigin:"anonymous";if(cors!=null)img.crossOrigin=cors;img.onload=()=>decrement(loader);img.onerror=()=>decrement(loader);img.src=url;return img}).catch(e=>{decrement(loader);return{complete:false,width:0,height:0,src:e&&e.url||""}})}ready(){const loader=this;return new Promise(accept=>{function poll(value){if(!loader.pending())accept(value);else setTimeout(()=>{poll(true)},10)}poll(false)})}}function increment(loader){loader._pending+=1}function decrement(loader){loader._pending-=1}function boundStroke(bounds,item,miter){if(item.stroke&&item.opacity!==0&&item.strokeOpacity!==0){const sw=item.strokeWidth!=null?+item.strokeWidth:1;bounds.expand(sw+(miter?miterAdjustment(item,sw):0))}return bounds}function miterAdjustment(item,strokeWidth){return item.strokeJoin&&item.strokeJoin!=="miter"?0:strokeWidth}const circleThreshold=Tau-1e-8;let bounds,lx,ly,rot,ma,mb,mc,md;const add=(x,y)=>bounds.add(x,y);const addL=(x,y)=>add(lx=x,ly=y);const addX=x=>add(x,bounds.y1);const addY=y=>add(bounds.x1,y);const px=(x,y)=>ma*x+mc*y;const py=(x,y)=>mb*x+md*y;const addp=(x,y)=>add(px(x,y),py(x,y));const addpL=(x,y)=>addL(px(x,y),py(x,y));function boundContext(_,deg){bounds=_;if(deg){rot=deg*DegToRad;ma=md=Math.cos(rot);mb=Math.sin(rot);mc=-mb}else{ma=md=1;rot=mb=mc=0}return context$1}const context$1={beginPath(){},closePath(){},moveTo:addpL,lineTo:addpL,rect(x,y,w,h){if(rot){addp(x+w,y);addp(x+w,y+h);addp(x,y+h);addpL(x,y)}else{add(x+w,y+h);addL(x,y)}},quadraticCurveTo(x1,y1,x2,y2){const px1=px(x1,y1),py1=py(x1,y1),px2=px(x2,y2),py2=py(x2,y2);quadExtrema(lx,px1,px2,addX);quadExtrema(ly,py1,py2,addY);addL(px2,py2)},bezierCurveTo(x1,y1,x2,y2,x3,y3){const px1=px(x1,y1),py1=py(x1,y1),px2=px(x2,y2),py2=py(x2,y2),px3=px(x3,y3),py3=py(x3,y3);cubicExtrema(lx,px1,px2,px3,addX);cubicExtrema(ly,py1,py2,py3,addY);addL(px3,py3)},arc(cx,cy,r,sa,ea,ccw){sa+=rot;ea+=rot;lx=r*Math.cos(ea)+cx;ly=r*Math.sin(ea)+cy;if(Math.abs(ea-sa)>circleThreshold){add(cx-r,cy-r);add(cx+r,cy+r)}else{const update=a=>add(r*Math.cos(a)+cx,r*Math.sin(a)+cy);let s,i;update(sa);update(ea);if(ea!==sa){sa=sa%Tau;if(sa<0)sa+=Tau;ea=ea%Tau;if(ea<0)ea+=Tau;if(ea<sa){ccw=!ccw;s=sa;sa=ea;ea=s}if(ccw){ea-=Tau;s=sa-sa%HalfPi;for(i=0;i<4&&s>ea;++i,s-=HalfPi)update(s)}else{s=sa-sa%HalfPi+HalfPi;for(i=0;i<4&&s<ea;++i,s=s+HalfPi)update(s)}}}}};function quadExtrema(x0,x1,x2,cb){const t=(x0-x1)/(x0+x2-2*x1);if(0<t&&t<1)cb(x0+(x1-x0)*t)}function cubicExtrema(x0,x1,x2,x3,cb){const a=x3-x0+3*x1-3*x2,b=x0+x2-2*x1,c=x0-x1;let t0=0,t1=0,r;if(Math.abs(a)>Epsilon){r=b*b+c*a;if(r>=0){r=Math.sqrt(r);t0=(-b+r)/a;t1=(-b-r)/a}}else{t0=.5*c/b}if(0<t0&&t0<1)cb(cubic(t0,x0,x1,x2,x3));if(0<t1&&t1<1)cb(cubic(t1,x0,x1,x2,x3))}function cubic(t,x0,x1,x2,x3){const s=1-t,s2=s*s,t2=t*t;return s2*s*x0+3*s2*t*x1+3*s*t2*x2+t2*t*x3}var context=(context=vegaCanvas.canvas(1,1))?context.getContext("2d"):null;const b=new Bounds;function intersectPath(draw){return function(item,brush){if(!context)return true;draw(context,item);b.clear().union(item.bounds).intersect(brush).round();const{x1:x1,y1:y1,x2:x2,y2:y2}=b;for(let y=y1;y<=y2;++y){for(let x=x1;x<=x2;++x){if(context.isPointInPath(x,y)){return true}}}return false}}function intersectPoint(item,box){return box.contains(item.x||0,item.y||0)}function intersectRect(item,box){const x=item.x||0,y=item.y||0,w=item.width||0,h=item.height||0;return box.intersects(b.set(x,y,x+w,y+h))}function intersectRule(item,box){const x=item.x||0,y=item.y||0,x2=item.x2!=null?item.x2:x,y2=item.y2!=null?item.y2:y;return intersectBoxLine(box,x,y,x2,y2)}function intersectBoxLine(box,x,y,u,v){const{x1:x1,y1:y1,x2:x2,y2:y2}=box,dx=u-x,dy=v-y;let t0=0,t1=1,p,q,r,e;for(e=0;e<4;++e){if(e===0){p=-dx;q=-(x1-x)}if(e===1){p=dx;q=x2-x}if(e===2){p=-dy;q=-(y1-y)}if(e===3){p=dy;q=y2-y}if(Math.abs(p)<1e-10&&q<0)return false;r=q/p;if(p<0){if(r>t1)return false;else if(r>t0)t0=r}else if(p>0){if(r<t0)return false;else if(r<t1)t1=r}}return true}function blend(context,item){context.globalCompositeOperation=item.blend||"source-over"}function value(value,dflt){return value==null?dflt:value}function addStops(gradient,stops){const n=stops.length;for(let i=0;i<n;++i){gradient.addColorStop(stops[i].offset,stops[i].color)}return gradient}function gradient(context,spec,bounds){const w=bounds.width(),h=bounds.height();let gradient;if(spec.gradient==="radial"){gradient=context.createRadialGradient(bounds.x1+value(spec.x1,.5)*w,bounds.y1+value(spec.y1,.5)*h,Math.max(w,h)*value(spec.r1,0),bounds.x1+value(spec.x2,.5)*w,bounds.y1+value(spec.y2,.5)*h,Math.max(w,h)*value(spec.r2,.5))}else{const x1=value(spec.x1,0),y1=value(spec.y1,0),x2=value(spec.x2,1),y2=value(spec.y2,0);if(x1===x2||y1===y2||w===h){gradient=context.createLinearGradient(bounds.x1+x1*w,bounds.y1+y1*h,bounds.x1+x2*w,bounds.y1+y2*h)}else{const image=vegaCanvas.canvas(Math.ceil(w),Math.ceil(h)),ictx=image.getContext("2d");ictx.scale(w,h);ictx.fillStyle=addStops(ictx.createLinearGradient(x1,y1,x2,y2),spec.stops);ictx.fillRect(0,0,w,h);return context.createPattern(image,"no-repeat")}}return addStops(gradient,spec.stops)}function color(context,item,value){return isGradient(value)?gradient(context,value,item.bounds):value}function fill(context,item,opacity){opacity*=item.fillOpacity==null?1:item.fillOpacity;if(opacity>0){context.globalAlpha=opacity;context.fillStyle=color(context,item,item.fill);return true}else{return false}}var Empty=[];function stroke(context,item,opacity){var lw=(lw=item.strokeWidth)!=null?lw:1;if(lw<=0)return false;opacity*=item.strokeOpacity==null?1:item.strokeOpacity;if(opacity>0){context.globalAlpha=opacity;context.strokeStyle=color(context,item,item.stroke);context.lineWidth=lw;context.lineCap=item.strokeCap||"butt";context.lineJoin=item.strokeJoin||"miter";context.miterLimit=item.strokeMiterLimit||10;if(context.setLineDash){context.setLineDash(item.strokeDash||Empty);context.lineDashOffset=item.strokeDashOffset||0}return true}else{return false}}function compare(a,b){return a.zindex-b.zindex||a.index-b.index}function zorder(scene){if(!scene.zdirty)return scene.zitems;var items=scene.items,output=[],item,i,n;for(i=0,n=items.length;i<n;++i){item=items[i];item.index=i;if(item.zindex)output.push(item)}scene.zdirty=false;return scene.zitems=output.sort(compare)}function visit(scene,visitor){var items=scene.items,i,n;if(!items||!items.length)return;const zitems=zorder(scene);if(zitems&&zitems.length){for(i=0,n=items.length;i<n;++i){if(!items[i].zindex)visitor(items[i])}items=zitems}for(i=0,n=items.length;i<n;++i){visitor(items[i])}}function pickVisit(scene,visitor){var items=scene.items,hit,i;if(!items||!items.length)return null;const zitems=zorder(scene);if(zitems&&zitems.length)items=zitems;for(i=items.length;--i>=0;){if(hit=visitor(items[i]))return hit}if(items===zitems){for(items=scene.items,i=items.length;--i>=0;){if(!items[i].zindex){if(hit=visitor(items[i]))return hit}}}return null}function drawAll(path){return function(context,scene,bounds){visit(scene,item=>{if(!bounds||bounds.intersects(item.bounds)){drawPath(path,context,item,item)}})}}function drawOne(path){return function(context,scene,bounds){if(scene.items.length&&(!bounds||bounds.intersects(scene.bounds))){drawPath(path,context,scene.items[0],scene.items)}}}function drawPath(path,context,item,items){var opacity=item.opacity==null?1:item.opacity;if(opacity===0)return;if(path(context,items))return;blend(context,item);if(item.fill&&fill(context,item,opacity)){context.fill()}if(item.stroke&&stroke(context,item,opacity)){context.stroke()}}function pick$1(test){test=test||vegaUtil.truthy;return function(context,scene,x,y,gx,gy){x*=context.pixelRatio;y*=context.pixelRatio;return pickVisit(scene,item=>{const b=item.bounds;if(b&&!b.contains(gx,gy)||!b)return;if(test(context,item,x,y,gx,gy))return item})}}function hitPath(path,filled){return function(context,o,x,y){var item=Array.isArray(o)?o[0]:o,fill=filled==null?item.fill:filled,stroke=item.stroke&&context.isPointInStroke,lw,lc;if(stroke){lw=item.strokeWidth;lc=item.strokeCap;context.lineWidth=lw!=null?lw:1;context.lineCap=lc!=null?lc:"butt"}return path(context,o)?false:fill&&context.isPointInPath(x,y)||stroke&&context.isPointInStroke(x,y)}}function pickPath(path){return pick$1(hitPath(path))}function translate(x,y){return"translate("+x+","+y+")"}function rotate(a){return"rotate("+a+")"}function scale(scaleX,scaleY){return"scale("+scaleX+","+scaleY+")"}function translateItem(item){return translate(item.x||0,item.y||0)}function rotateItem(item){return translate(item.x||0,item.y||0)+(item.angle?" "+rotate(item.angle):"")}function transformItem(item){return translate(item.x||0,item.y||0)+(item.angle?" "+rotate(item.angle):"")+(item.scaleX||item.scaleY?" "+scale(item.scaleX||1,item.scaleY||1):"")}function markItemPath(type,shape,isect){function attr(emit,item){emit("transform",rotateItem(item));emit("d",shape(null,item))}function bound(bounds,item){shape(boundContext(bounds,item.angle),item);return boundStroke(bounds,item).translate(item.x||0,item.y||0)}function draw(context,item){var x=item.x||0,y=item.y||0,a=item.angle||0;context.translate(x,y);if(a)context.rotate(a*=DegToRad);context.beginPath();shape(context,item);if(a)context.rotate(-a);context.translate(-x,-y)}return{type:type,tag:"path",nested:false,attr:attr,bound:bound,draw:drawAll(draw),pick:pickPath(draw),isect:isect||intersectPath(draw)}}var arc=markItemPath("arc",arc$1);function pickArea(a,p){var v=a[0].orient==="horizontal"?p[1]:p[0],z=a[0].orient==="horizontal"?"y":"x",i=a.length,min=+Infinity,hit,d;while(--i>=0){if(a[i].defined===false)continue;d=Math.abs(a[i][z]-v);if(d<min){min=d;hit=a[i]}}return hit}function pickLine(a,p){var t=Math.pow(a[0].strokeWidth||1,2),i=a.length,dx,dy,dd;while(--i>=0){if(a[i].defined===false)continue;dx=a[i].x-p[0];dy=a[i].y-p[1];dd=dx*dx+dy*dy;if(dd<t)return a[i]}return null}function pickTrail(a,p){var i=a.length,dx,dy,dd;while(--i>=0){if(a[i].defined===false)continue;dx=a[i].x-p[0];dy=a[i].y-p[1];dd=dx*dx+dy*dy;dx=a[i].size||1;if(dd<dx*dx)return a[i]}return null}function markMultiItemPath(type,shape,tip){function attr(emit,item){var items=item.mark.items;if(items.length)emit("d",shape(null,items))}function bound(bounds,mark){var items=mark.items;if(items.length===0){return bounds}else{shape(boundContext(bounds),items);return boundStroke(bounds,items[0])}}function draw(context,items){context.beginPath();shape(context,items)}const hit=hitPath(draw);function pick(context,scene,x,y,gx,gy){var items=scene.items,b=scene.bounds;if(!items||!items.length||b&&!b.contains(gx,gy)){return null}x*=context.pixelRatio;y*=context.pixelRatio;return hit(context,items,x,y)?items[0]:null}return{type:type,tag:"path",nested:true,attr:attr,bound:bound,draw:drawOne(draw),pick:pick,isect:intersectPoint,tip:tip}}var area=markMultiItemPath("area",area$1,pickArea);function clip(context,scene){var clip=scene.clip;context.save();if(vegaUtil.isFunction(clip)){context.beginPath();clip(context);context.clip()}else{clipGroup(context,scene.group)}}function clipGroup(context,group){context.beginPath();hasCornerRadius(group)?rectangle(context,group,0,0):context.rect(0,0,group.width||0,group.height||0);context.clip()}function offset$1(item){const sw=value(item.strokeWidth,1);return item.strokeOffset!=null?item.strokeOffset:item.stroke&&sw>.5&&sw<1.5?.5-Math.abs(sw-1):0}function attr$5(emit,item){emit("transform",translateItem(item))}function emitRectangle(emit,item){const off=offset$1(item);emit("d",rectangle(null,item,off,off))}function background(emit,item){emit("class","background");emit("aria-hidden",true);emitRectangle(emit,item)}function foreground(emit,item){emit("class","foreground");emit("aria-hidden",true);if(item.strokeForeground){emitRectangle(emit,item)}else{emit("d","")}}function content(emit,item,renderer){const url=item.clip?clip$1(renderer,item,item):null;emit("clip-path",url)}function bound$5(bounds,group){if(!group.clip&&group.items){const items=group.items,m=items.length;for(let j=0;j<m;++j){bounds.union(items[j].bounds)}}if((group.clip||group.width||group.height)&&!group.noBound){bounds.add(0,0).add(group.width||0,group.height||0)}boundStroke(bounds,group);return bounds.translate(group.x||0,group.y||0)}function rectanglePath(context,group,x,y){const off=offset$1(group);context.beginPath();rectangle(context,group,(x||0)+off,(y||0)+off)}const hitBackground=hitPath(rectanglePath);const hitForeground=hitPath(rectanglePath,false);const hitCorner=hitPath(rectanglePath,true);function draw$4(context,scene,bounds,markTypes){visit(scene,group=>{const gx=group.x||0,gy=group.y||0,fore=group.strokeForeground,opacity=group.opacity==null?1:group.opacity;if((group.stroke||group.fill)&&opacity){rectanglePath(context,group,gx,gy);blend(context,group);if(group.fill&&fill(context,group,opacity)){context.fill()}if(group.stroke&&!fore&&stroke(context,group,opacity)){context.stroke()}}context.save();context.translate(gx,gy);if(group.clip)clipGroup(context,group);if(bounds)bounds.translate(-gx,-gy);visit(group,item=>{if(item.marktype==="group"||markTypes==null||markTypes.includes(item.marktype)){this.draw(context,item,bounds,markTypes)}});if(bounds)bounds.translate(gx,gy);context.restore();if(fore&&group.stroke&&opacity){rectanglePath(context,group,gx,gy);blend(context,group);if(stroke(context,group,opacity)){context.stroke()}}})}function pick(context,scene,x,y,gx,gy){if(scene.bounds&&!scene.bounds.contains(gx,gy)||!scene.items){return null}const cx=x*context.pixelRatio,cy=y*context.pixelRatio;return pickVisit(scene,group=>{let hit,dx,dy;const b=group.bounds;if(b&&!b.contains(gx,gy))return;dx=group.x||0;dy=group.y||0;const dw=dx+(group.width||0),dh=dy+(group.height||0),c=group.clip;if(c&&(gx<dx||gx>dw||gy<dy||gy>dh))return;context.save();context.translate(dx,dy);dx=gx-dx;dy=gy-dy;if(c&&hasCornerRadius(group)&&!hitCorner(context,group,cx,cy)){context.restore();return null}const fore=group.strokeForeground,ix=scene.interactive!==false;if(ix&&fore&&group.stroke&&hitForeground(context,group,cx,cy)){context.restore();return group}hit=pickVisit(group,mark=>pickMark(mark,dx,dy)?this.pick(mark,x,y,dx,dy):null);if(!hit&&ix&&(group.fill||!fore&&group.stroke)&&hitBackground(context,group,cx,cy)){hit=group}context.restore();return hit||null})}function pickMark(mark,x,y){return(mark.interactive!==false||mark.marktype==="group")&&mark.bounds&&mark.bounds.contains(x,y)}var group={type:"group",tag:"g",nested:false,attr:attr$5,bound:bound$5,draw:draw$4,pick:pick,isect:intersectRect,content:content,background:background,foreground:foreground};var metadata={xmlns:"http://www.w3.org/2000/svg","xmlns:xlink":"http://www.w3.org/1999/xlink",version:"1.1"};function getImage(item,renderer){var image=item.image;if(!image||item.url&&item.url!==image.url){image={complete:false,width:0,height:0};renderer.loadImage(item.url).then(image=>{item.image=image;item.image.url=item.url})}return image}function imageWidth(item,image){return item.width!=null?item.width:!image||!image.width?0:item.aspect!==false&&item.height?item.height*image.width/image.height:image.width}function imageHeight(item,image){return item.height!=null?item.height:!image||!image.height?0:item.aspect!==false&&item.width?item.width*image.height/image.width:image.height}function imageXOffset(align,w){return align==="center"?w/2:align==="right"?w:0}function imageYOffset(baseline,h){return baseline==="middle"?h/2:baseline==="bottom"?h:0}function attr$4(emit,item,renderer){const img=getImage(item,renderer),w=imageWidth(item,img),h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h),i=!img.src&&img.toDataURL?img.toDataURL():img.src||"";emit("href",i,metadata["xmlns:xlink"],"xlink:href");emit("transform",translate(x,y));emit("width",w);emit("height",h);emit("preserveAspectRatio",item.aspect===false?"none":"xMidYMid")}function bound$4(bounds,item){const img=item.image,w=imageWidth(item,img),h=imageHeight(item,img),x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h);return bounds.set(x,y,x+w,y+h)}function draw$3(context,scene,bounds){visit(scene,item=>{if(bounds&&!bounds.intersects(item.bounds))return;const img=getImage(item,this);let w=imageWidth(item,img);let h=imageHeight(item,img);if(w===0||h===0)return;let x=(item.x||0)-imageXOffset(item.align,w),y=(item.y||0)-imageYOffset(item.baseline,h),opacity,ar0,ar1,t;if(item.aspect!==false){ar0=img.width/img.height;ar1=item.width/item.height;if(ar0===ar0&&ar1===ar1&&ar0!==ar1){if(ar1<ar0){t=w/ar0;y+=(h-t)/2;h=t}else{t=h*ar0;x+=(w-t)/2;w=t}}}if(img.complete||img.toDataURL){blend(context,item);context.globalAlpha=(opacity=item.opacity)!=null?opacity:1;context.imageSmoothingEnabled=item.smooth!==false;context.drawImage(img,x,y,w,h)}})}var image={type:"image",tag:"image",nested:false,attr:attr$4,bound:bound$4,draw:draw$3,pick:pick$1(),isect:vegaUtil.truthy,get:getImage,xOffset:imageXOffset,yOffset:imageYOffset};var line=markMultiItemPath("line",line$1,pickLine);function attr$3(emit,item){var sx=item.scaleX||1,sy=item.scaleY||1;if(sx!==1||sy!==1){emit("vector-effect","non-scaling-stroke")}emit("transform",transformItem(item));emit("d",item.path)}function path$1(context,item){var path=item.path;if(path==null)return true;var x=item.x||0,y=item.y||0,sx=item.scaleX||1,sy=item.scaleY||1,a=(item.angle||0)*DegToRad,cache=item.pathCache;if(!cache||cache.path!==path){(item.pathCache=cache=parse(path)).path=path}if(a&&context.rotate&&context.translate){context.translate(x,y);context.rotate(a);pathRender(context,cache,0,0,sx,sy);context.rotate(-a);context.translate(-x,-y)}else{pathRender(context,cache,x,y,sx,sy)}}function bound$3(bounds,item){return path$1(boundContext(bounds,item.angle),item)?bounds.set(0,0,0,0):boundStroke(bounds,item,true)}var path$2={type:"path",tag:"path",nested:false,attr:attr$3,bound:bound$3,draw:drawAll(path$1),pick:pickPath(path$1),isect:intersectPath(path$1)};function attr$2(emit,item){emit("d",rectangle(null,item))}function bound$2(bounds,item){var x,y;return boundStroke(bounds.set(x=item.x||0,y=item.y||0,x+item.width||0,y+item.height||0),item)}function draw$2(context,item){context.beginPath();rectangle(context,item)}var rect={type:"rect",tag:"path",nested:false,attr:attr$2,bound:bound$2,draw:drawAll(draw$2),pick:pickPath(draw$2),isect:intersectRect};function attr$1(emit,item){emit("transform",translateItem(item));emit("x2",item.x2!=null?item.x2-(item.x||0):0);emit("y2",item.y2!=null?item.y2-(item.y||0):0)}function bound$1(bounds,item){var x1,y1;return boundStroke(bounds.set(x1=item.x||0,y1=item.y||0,item.x2!=null?item.x2:x1,item.y2!=null?item.y2:y1),item)}function path(context,item,opacity){var x1,y1,x2,y2;if(item.stroke&&stroke(context,item,opacity)){x1=item.x||0;y1=item.y||0;x2=item.x2!=null?item.x2:x1;y2=item.y2!=null?item.y2:y1;context.beginPath();context.moveTo(x1,y1);context.lineTo(x2,y2);return true}return false}function draw$1(context,scene,bounds){visit(scene,item=>{if(bounds&&!bounds.intersects(item.bounds))return;var opacity=item.opacity==null?1:item.opacity;if(opacity&&path(context,item,opacity)){blend(context,item);context.stroke()}})}function hit$1(context,item,x,y){if(!context.isPointInStroke)return false;return path(context,item,1)&&context.isPointInStroke(x,y)}var rule={type:"rule",tag:"line",nested:false,attr:attr$1,bound:bound$1,draw:draw$1,pick:pick$1(hit$1),isect:intersectRule};var shape=markItemPath("shape",shape$1);var symbol=markItemPath("symbol",symbol$1,intersectPoint);const widthCache=vegaUtil.lruCache();var textMetrics={height:fontSize,measureWidth:measureWidth,estimateWidth:estimateWidth,width:estimateWidth,canvas:useCanvas};useCanvas(true);function useCanvas(use){textMetrics.width=use&&context?measureWidth:estimateWidth}function estimateWidth(item,text){return _estimateWidth(textValue(item,text),fontSize(item))}function _estimateWidth(text,currentFontHeight){return~~(.8*text.length*currentFontHeight)}function measureWidth(item,text){return fontSize(item)<=0||!(text=textValue(item,text))?0:_measureWidth(text,font(item))}function _measureWidth(text,currentFont){const key=`(${currentFont}) ${text}`;let width=widthCache.get(key);if(width===undefined){context.font=currentFont;width=context.measureText(text).width;widthCache.set(key,width)}return width}function fontSize(item){return item.fontSize!=null?+item.fontSize||0:11}function lineHeight(item){return item.lineHeight!=null?item.lineHeight:fontSize(item)+2}function lineArray(_){return vegaUtil.isArray(_)?_.length>1?_:_[0]:_}function textLines(item){return lineArray(item.lineBreak&&item.text&&!vegaUtil.isArray(item.text)?item.text.split(item.lineBreak):item.text)}function multiLineOffset(item){const tl=textLines(item);return(vegaUtil.isArray(tl)?tl.length-1:0)*lineHeight(item)}function textValue(item,line){const text=line==null?"":(line+"").trim();return item.limit>0&&text.length?truncate(item,text):text}function widthGetter(item){if(textMetrics.width===measureWidth){const currentFont=font(item);return text=>_measureWidth(text,currentFont)}else if(textMetrics.width===estimateWidth){const currentFontHeight=fontSize(item);return text=>_estimateWidth(text,currentFontHeight)}else{return text=>textMetrics.width(item,text)}}function truncate(item,text){var limit=+item.limit,width=widthGetter(item);if(width(text)<limit)return text;var ellipsis=item.ellipsis||"…",rtl=item.dir==="rtl",lo=0,hi=text.length,mid;limit-=width(ellipsis);if(rtl){while(lo<hi){mid=lo+hi>>>1;if(width(text.slice(mid))>limit)lo=mid+1;else hi=mid}return ellipsis+text.slice(lo)}else{while(lo<hi){mid=1+(lo+hi>>>1);if(width(text.slice(0,mid))<limit)lo=mid;else hi=mid-1}return text.slice(0,lo)+ellipsis}}function fontFamily(item,quote){var font=item.font;return(quote&&font?String(font).replace(/"/g,"'"):font)||"sans-serif"}function font(item,quote){return""+(item.fontStyle?item.fontStyle+" ":"")+(item.fontVariant?item.fontVariant+" ":"")+(item.fontWeight?item.fontWeight+" ":"")+fontSize(item)+"px "+fontFamily(item,quote)}function offset(item){var baseline=item.baseline,h=fontSize(item);return Math.round(baseline==="top"?.79*h:baseline==="middle"?.3*h:baseline==="bottom"?-.21*h:baseline==="line-top"?.29*h+.5*lineHeight(item):baseline==="line-bottom"?.29*h-.5*lineHeight(item):0)}const textAlign={left:"start",center:"middle",right:"end"};const tempBounds=new Bounds;function anchorPoint(item){var x=item.x||0,y=item.y||0,r=item.radius||0,t;if(r){t=(item.theta||0)-HalfPi;x+=r*Math.cos(t);y+=r*Math.sin(t)}tempBounds.x1=x;tempBounds.y1=y;return tempBounds}function attr(emit,item){var dx=item.dx||0,dy=(item.dy||0)+offset(item),p=anchorPoint(item),x=p.x1,y=p.y1,a=item.angle||0,t;emit("text-anchor",textAlign[item.align]||"start");if(a){t=translate(x,y)+" "+rotate(a);if(dx||dy)t+=" "+translate(dx,dy)}else{t=translate(x+dx,y+dy)}emit("transform",t)}function bound(bounds,item,mode){var h=textMetrics.height(item),a=item.align,p=anchorPoint(item),x=p.x1,y=p.y1,dx=item.dx||0,dy=(item.dy||0)+offset(item)-Math.round(.8*h),tl=textLines(item),w;if(vegaUtil.isArray(tl)){h+=lineHeight(item)*(tl.length-1);w=tl.reduce((w,t)=>Math.max(w,textMetrics.width(item,t)),0)}else{w=textMetrics.width(item,tl)}if(a==="center"){dx-=w/2}else if(a==="right"){dx-=w}else;bounds.set(dx+=x,dy+=y,dx+w,dy+h);if(item.angle&&!mode){bounds.rotate(item.angle*DegToRad,x,y)}else if(mode===2){return bounds.rotatedPoints(item.angle*DegToRad,x,y)}return bounds}function draw(context,scene,bounds){visit(scene,item=>{var opacity=item.opacity==null?1:item.opacity,p,x,y,i,lh,tl,str;if(bounds&&!bounds.intersects(item.bounds)||opacity===0||item.fontSize<=0||item.text==null||item.text.length===0)return;context.font=font(item);context.textAlign=item.align||"left";p=anchorPoint(item);x=p.x1,y=p.y1;if(item.angle){context.save();context.translate(x,y);context.rotate(item.angle*DegToRad);x=y=0}x+=item.dx||0;y+=(item.dy||0)+offset(item);tl=textLines(item);blend(context,item);if(vegaUtil.isArray(tl)){lh=lineHeight(item);for(i=0;i<tl.length;++i){str=textValue(item,tl[i]);if(item.fill&&fill(context,item,opacity)){context.fillText(str,x,y)}if(item.stroke&&stroke(context,item,opacity)){context.strokeText(str,x,y)}y+=lh}}else{str=textValue(item,tl);if(item.fill&&fill(context,item,opacity)){context.fillText(str,x,y)}if(item.stroke&&stroke(context,item,opacity)){context.strokeText(str,x,y)}}if(item.angle)context.restore()})}function hit(context,item,x,y,gx,gy){if(item.fontSize<=0)return false;if(!item.angle)return true;var p=anchorPoint(item),ax=p.x1,ay=p.y1,b=bound(tempBounds,item,1),a=-item.angle*DegToRad,cos=Math.cos(a),sin=Math.sin(a),px=cos*gx-sin*gy+(ax-cos*ax+sin*ay),py=sin*gx+cos*gy+(ay-sin*ax-cos*ay);return b.contains(px,py)}function intersectText(item,box){const p=bound(tempBounds,item,2);return intersectBoxLine(box,p[0],p[1],p[2],p[3])||intersectBoxLine(box,p[0],p[1],p[4],p[5])||intersectBoxLine(box,p[4],p[5],p[6],p[7])||intersectBoxLine(box,p[2],p[3],p[6],p[7])}var text={type:"text",tag:"text",nested:false,attr:attr,bound:bound,draw:draw,pick:pick$1(hit),isect:intersectText};var trail=markMultiItemPath("trail",trail$1,pickTrail);var Marks={arc:arc,area:area,group:group,image:image,line:line,path:path$2,rect:rect,rule:rule,shape:shape,symbol:symbol,text:text,trail:trail};function boundItem(item,func,opt){var type=Marks[item.mark.marktype],bound=func||type.bound;if(type.nested)item=item.mark;return bound(item.bounds||(item.bounds=new Bounds),item,opt)}var DUMMY={mark:null};function boundMark(mark,bounds,opt){var type=Marks[mark.marktype],bound=type.bound,items=mark.items,hasItems=items&&items.length,i,n,item,b;if(type.nested){if(hasItems){item=items[0]}else{DUMMY.mark=mark;item=DUMMY}b=boundItem(item,bound,opt);bounds=bounds&&bounds.union(b)||b;return bounds}bounds=bounds||mark.bounds&&mark.bounds.clear()||new Bounds;if(hasItems){for(i=0,n=items.length;i<n;++i){bounds.union(boundItem(items[i],bound,opt))}}return mark.bounds=bounds}const keys=["marktype","name","role","interactive","clip","items","zindex","x","y","width","height","align","baseline","fill","fillOpacity","opacity","blend","stroke","strokeOpacity","strokeWidth","strokeCap","strokeDash","strokeDashOffset","strokeForeground","strokeOffset","startAngle","endAngle","innerRadius","outerRadius","cornerRadius","padAngle","cornerRadiusTopLeft","cornerRadiusTopRight","cornerRadiusBottomLeft","cornerRadiusBottomRight","interpolate","tension","orient","defined","url","aspect","smooth","path","scaleX","scaleY","x2","y2","size","shape","text","angle","theta","radius","dir","dx","dy","ellipsis","limit","lineBreak","lineHeight","font","fontSize","fontWeight","fontStyle","fontVariant","description","aria","ariaRole","ariaRoleDescription"];function sceneToJSON(scene,indent){return JSON.stringify(scene,keys,indent)}function sceneFromJSON(json){const scene=typeof json==="string"?JSON.parse(json):json;return initialize(scene)}function initialize(scene){var type=scene.marktype,items=scene.items,parent,i,n;if(items){for(i=0,n=items.length;i<n;++i){parent=type?"mark":"group";items[i][parent]=scene;if(items[i].zindex)items[i][parent].zdirty=true;if("group"===(type||parent))initialize(items[i])}}if(type)boundMark(scene);return scene}class Scenegraph{constructor(scene){if(arguments.length){this.root=sceneFromJSON(scene)}else{this.root=createMark({marktype:"group",name:"root",role:"frame"});this.root.items=[new GroupItem(this.root)]}}toJSON(indent){return sceneToJSON(this.root,indent||0)}mark(markdef,group,index){group=group||this.root.items[0];const mark=createMark(markdef,group);group.items[index]=mark;if(mark.zindex)mark.group.zdirty=true;return mark}}function createMark(def,group){const mark={bounds:new Bounds,clip:!!def.clip,group:group,interactive:def.interactive===false?false:true,items:[],marktype:def.marktype,name:def.name||undefined,role:def.role||undefined,zindex:def.zindex||0};if(def.aria!=null){mark.aria=def.aria}if(def.description){mark.description=def.description}return mark}function domCreate(doc,tag,ns){if(!doc&&typeof document!=="undefined"&&document.createElement){doc=document}return doc?ns?doc.createElementNS(ns,tag):doc.createElement(tag):null}function domFind(el,tag){tag=tag.toLowerCase();var nodes=el.childNodes,i=0,n=nodes.length;for(;i<n;++i)if(nodes[i].tagName.toLowerCase()===tag){return nodes[i]}}function domChild(el,index,tag,ns){var a=el.childNodes[index],b;if(!a||a.tagName.toLowerCase()!==tag.toLowerCase()){b=a||null;a=domCreate(el.ownerDocument,tag,ns);el.insertBefore(a,b)}return a}function domClear(el,index){var nodes=el.childNodes,curr=nodes.length;while(curr>index)el.removeChild(nodes[--curr]);return el}function cssClass(mark){return"mark-"+mark.marktype+(mark.role?" role-"+mark.role:"")+(mark.name?" "+mark.name:"")}function point(event,el){const rect=el.getBoundingClientRect();return[event.clientX-rect.left-(el.clientLeft||0),event.clientY-rect.top-(el.clientTop||0)]}function resolveItem(item,event,el,origin){var mark=item&&item.mark,mdef,p;if(mark&&(mdef=Marks[mark.marktype]).tip){p=point(event,el);p[0]-=origin[0];p[1]-=origin[1];while(item=item.mark.group){p[0]-=item.x||0;p[1]-=item.y||0}item=mdef.tip(mark.items,p)}return item}class Handler{constructor(customLoader,customTooltip){this._active=null;this._handlers={};this._loader=customLoader||vegaLoader.loader();this._tooltip=customTooltip||defaultTooltip}initialize(el,origin,obj){this._el=el;this._obj=obj||null;return this.origin(origin)}element(){return this._el}canvas(){return this._el&&this._el.firstChild}origin(origin){if(arguments.length){this._origin=origin||[0,0];return this}else{return this._origin.slice()}}scene(scene){if(!arguments.length)return this._scene;this._scene=scene;return this}on(){}off(){}_handlerIndex(h,type,handler){for(let i=h?h.length:0;--i>=0;){if(h[i].type===type&&(!handler||h[i].handler===handler)){return i}}return-1}handlers(type){const h=this._handlers,a=[];if(type){a.push(...h[this.eventName(type)])}else{for(const k in h){a.push(...h[k])}}return a}eventName(name){const i=name.indexOf(".");return i<0?name:name.slice(0,i)}handleHref(event,item,href){this._loader.sanitize(href,{context:"href"}).then(opt=>{const e=new MouseEvent(event.type,event),a=domCreate(null,"a");for(const name in opt)a.setAttribute(name,opt[name]);a.dispatchEvent(e)}).catch(()=>{})}handleTooltip(event,item,show){if(item&&item.tooltip!=null){item=resolveItem(item,event,this.canvas(),this._origin);const value=show&&item&&item.tooltip||null;this._tooltip.call(this._obj,this,event,item,value)}}getItemBoundingClientRect(item){const el=this.canvas();if(!el)return;const rect=el.getBoundingClientRect(),origin=this._origin,bounds=item.bounds,width=bounds.width(),height=bounds.height();let x=bounds.x1+origin[0]+rect.left,y=bounds.y1+origin[1]+rect.top;while(item.mark&&(item=item.mark.group)){x+=item.x||0;y+=item.y||0}return{x:x,y:y,width:width,height:height,left:x,top:y,right:x+width,bottom:y+height}}}function defaultTooltip(handler,event,item,value){handler.element().setAttribute("title",value||"")}class Renderer{constructor(loader){this._el=null;this._bgcolor=null;this._loader=new ResourceLoader(loader)}initialize(el,width,height,origin,scaleFactor){this._el=el;return this.resize(width,height,origin,scaleFactor)}element(){return this._el}canvas(){return this._el&&this._el.firstChild}background(bgcolor){if(arguments.length===0)return this._bgcolor;this._bgcolor=bgcolor;return this}resize(width,height,origin,scaleFactor){this._width=width;this._height=height;this._origin=origin||[0,0];this._scale=scaleFactor||1;return this}dirty(){}render(scene,markTypes){const r=this;r._call=function(){r._render(scene,markTypes)};r._call();r._call=null;return r}_render(){}renderAsync(scene,markTypes){const r=this.render(scene,markTypes);return this._ready?this._ready.then(()=>r):Promise.resolve(r)}_load(method,uri){var r=this,p=r._loader[method](uri);if(!r._ready){const call=r._call;r._ready=r._loader.ready().then(redraw=>{if(redraw)call();r._ready=null})}return p}sanitizeURL(uri){return this._load("sanitizeURL",uri)}loadImage(uri){return this._load("loadImage",uri)}}const KeyDownEvent="keydown";const KeyPressEvent="keypress";const KeyUpEvent="keyup";const DragEnterEvent="dragenter";const DragLeaveEvent="dragleave";const DragOverEvent="dragover";const PointerDownEvent="pointerdown";const PointerUpEvent="pointerup";const PointerMoveEvent="pointermove";const PointerOutEvent="pointerout";const PointerOverEvent="pointerover";const MouseDownEvent="mousedown";const MouseUpEvent="mouseup";const MouseMoveEvent="mousemove";const MouseOutEvent="mouseout";const MouseOverEvent="mouseover";const ClickEvent="click";const DoubleClickEvent="dblclick";const WheelEvent="wheel";const MouseWheelEvent="mousewheel";const TouchStartEvent="touchstart";const TouchMoveEvent="touchmove";const TouchEndEvent="touchend";const Events=[KeyDownEvent,KeyPressEvent,KeyUpEvent,DragEnterEvent,DragLeaveEvent,DragOverEvent,PointerDownEvent,PointerUpEvent,PointerMoveEvent,PointerOutEvent,PointerOverEvent,MouseDownEvent,MouseUpEvent,MouseMoveEvent,MouseOutEvent,MouseOverEvent,ClickEvent,DoubleClickEvent,WheelEvent,MouseWheelEvent,TouchStartEvent,TouchMoveEvent,TouchEndEvent];const TooltipShowEvent=PointerMoveEvent;const TooltipHideEvent=MouseOutEvent;const HrefEvent=ClickEvent;class CanvasHandler extends Handler{constructor(loader,tooltip){super(loader,tooltip);this._down=null;this._touch=null;this._first=true;this._events={};this.events=Events;this.pointermove=move([PointerMoveEvent,MouseMoveEvent],[PointerOverEvent,MouseOverEvent],[PointerOutEvent,MouseOutEvent]);this.dragover=move([DragOverEvent],[DragEnterEvent],[DragLeaveEvent]),this.pointerout=inactive([PointerOutEvent,MouseOutEvent]);this.dragleave=inactive([DragLeaveEvent])}initialize(el,origin,obj){this._canvas=el&&domFind(el,"canvas");[ClickEvent,MouseDownEvent,PointerDownEvent,PointerMoveEvent,PointerOutEvent,DragLeaveEvent].forEach(type=>eventListenerCheck(this,type));return super.initialize(el,origin,obj)}canvas(){return this._canvas}context(){return this._canvas.getContext("2d")}DOMMouseScroll(evt){this.fire(MouseWheelEvent,evt)}pointerdown(evt){this._down=this._active;this.fire(PointerDownEvent,evt)}mousedown(evt){this._down=this._active;this.fire(MouseDownEvent,evt)}click(evt){if(this._down===this._active){this.fire(ClickEvent,evt);this._down=null}}touchstart(evt){this._touch=this.pickEvent(evt.changedTouches[0]);if(this._first){this._active=this._touch;this._first=false}this.fire(TouchStartEvent,evt,true)}touchmove(evt){this.fire(TouchMoveEvent,evt,true)}touchend(evt){this.fire(TouchEndEvent,evt,true);this._touch=null}fire(type,evt,touch){const a=touch?this._touch:this._active,h=this._handlers[type];evt.vegaType=type;if(type===HrefEvent&&a&&a.href){this.handleHref(evt,a,a.href)}else if(type===TooltipShowEvent||type===TooltipHideEvent){this.handleTooltip(evt,a,type!==TooltipHideEvent)}if(h){for(let i=0,len=h.length;i<len;++i){h[i].handler.call(this._obj,evt,a)}}}on(type,handler){const name=this.eventName(type),h=this._handlers,i=this._handlerIndex(h[name],type,handler);if(i<0){eventListenerCheck(this,type);(h[name]||(h[name]=[])).push({type:type,handler:handler})}return this}off(type,handler){const name=this.eventName(type),h=this._handlers[name],i=this._handlerIndex(h,type,handler);if(i>=0){h.splice(i,1)}return this}pickEvent(evt){const p=point(evt,this._canvas),o=this._origin;return this.pick(this._scene,p[0],p[1],p[0]-o[0],p[1]-o[1])}pick(scene,x,y,gx,gy){const g=this.context(),mark=Marks[scene.marktype];return mark.pick.call(this,g,scene,x,y,gx,gy)}}const eventBundle=type=>type===TouchStartEvent||type===TouchMoveEvent||type===TouchEndEvent?[TouchStartEvent,TouchMoveEvent,TouchEndEvent]:[type];function eventListenerCheck(handler,type){eventBundle(type).forEach(_=>addEventListener(handler,_))}function addEventListener(handler,type){const canvas=handler.canvas();if(canvas&&!handler._events[type]){handler._events[type]=1;canvas.addEventListener(type,handler[type]?evt=>handler[type](evt):evt=>handler.fire(type,evt))}}function fireAll(handler,types,event){types.forEach(type=>handler.fire(type,event))}function move(moveEvents,overEvents,outEvents){return function(evt){const a=this._active,p=this.pickEvent(evt);if(p===a){fireAll(this,moveEvents,evt)}else{if(!a||!a.exit){fireAll(this,outEvents,evt)}this._active=p;fireAll(this,overEvents,evt);fireAll(this,moveEvents,evt)}}}function inactive(types){return function(evt){fireAll(this,types,evt);this._active=null}}function devicePixelRatio(){return typeof window!=="undefined"?window.devicePixelRatio||1:1}function resize(canvas,width,height,origin,scaleFactor,opt){const inDOM=typeof HTMLElement!=="undefined"&&canvas instanceof HTMLElement&&canvas.parentNode!=null,context=canvas.getContext("2d"),ratio=inDOM?devicePixelRatio():scaleFactor;canvas.width=width*ratio;canvas.height=height*ratio;for(const key in opt){context[key]=opt[key]}if(inDOM&&ratio!==1){canvas.style.width=width+"px";canvas.style.height=height+"px"}context.pixelRatio=ratio;context.setTransform(ratio,0,0,ratio,ratio*origin[0],ratio*origin[1]);return canvas}class CanvasRenderer extends Renderer{constructor(loader){super(loader);this._options={};this._redraw=false;this._dirty=new Bounds;this._tempb=new Bounds}initialize(el,width,height,origin,scaleFactor,options){this._options=options||{};this._canvas=this._options.externalContext?null:vegaCanvas.canvas(1,1,this._options.type);if(el&&this._canvas){domClear(el,0).appendChild(this._canvas);this._canvas.setAttribute("class","marks")}return super.initialize(el,width,height,origin,scaleFactor)}resize(width,height,origin,scaleFactor){super.resize(width,height,origin,scaleFactor);if(this._canvas){resize(this._canvas,this._width,this._height,this._origin,this._scale,this._options.context)}else{const ctx=this._options.externalContext;if(!ctx)vegaUtil.error("CanvasRenderer is missing a valid canvas or context");ctx.scale(this._scale,this._scale);ctx.translate(this._origin[0],this._origin[1])}this._redraw=true;return this}canvas(){return this._canvas}context(){return this._options.externalContext||(this._canvas?this._canvas.getContext("2d"):null)}dirty(item){const b=this._tempb.clear().union(item.bounds);let g=item.mark.group;while(g){b.translate(g.x||0,g.y||0);g=g.mark.group}this._dirty.union(b)}_render(scene,markTypes){const g=this.context(),o=this._origin,w=this._width,h=this._height,db=this._dirty,vb=viewBounds(o,w,h);g.save();const b=this._redraw||db.empty()?(this._redraw=false,vb.expand(1)):clipToBounds(g,vb.intersect(db),o);this.clear(-o[0],-o[1],w,h);this.draw(g,scene,b,markTypes);g.restore();db.clear();return this}draw(ctx,scene,bounds,markTypes){if(scene.marktype!=="group"&&markTypes!=null&&!markTypes.includes(scene.marktype)){return}const mark=Marks[scene.marktype];if(scene.clip)clip(ctx,scene);mark.draw.call(this,ctx,scene,bounds,markTypes);if(scene.clip)ctx.restore()}clear(x,y,w,h){const opt=this._options,g=this.context();if(opt.type!=="pdf"&&!opt.externalContext){g.clearRect(x,y,w,h)}if(this._bgcolor!=null){g.fillStyle=this._bgcolor;g.fillRect(x,y,w,h)}}}const viewBounds=(origin,width,height)=>(new Bounds).set(0,0,width,height).translate(-origin[0],-origin[1]);function clipToBounds(g,b,origin){b.expand(1).round();if(g.pixelRatio%1){b.scale(g.pixelRatio).round().scale(1/g.pixelRatio)}b.translate(-(origin[0]%1),-(origin[1]%1));g.beginPath();g.rect(b.x1,b.y1,b.width(),b.height());g.clip();return b}class SVGHandler extends Handler{constructor(loader,tooltip){super(loader,tooltip);const h=this;h._hrefHandler=listener(h,(evt,item)=>{if(item&&item.href)h.handleHref(evt,item,item.href)});h._tooltipHandler=listener(h,(evt,item)=>{h.handleTooltip(evt,item,evt.type!==TooltipHideEvent)})}initialize(el,origin,obj){let svg=this._svg;if(svg){svg.removeEventListener(HrefEvent,this._hrefHandler);svg.removeEventListener(TooltipShowEvent,this._tooltipHandler);svg.removeEventListener(TooltipHideEvent,this._tooltipHandler)}this._svg=svg=el&&domFind(el,"svg");if(svg){svg.addEventListener(HrefEvent,this._hrefHandler);svg.addEventListener(TooltipShowEvent,this._tooltipHandler);svg.addEventListener(TooltipHideEvent,this._tooltipHandler)}return super.initialize(el,origin,obj)}canvas(){return this._svg}on(type,handler){const name=this.eventName(type),h=this._handlers,i=this._handlerIndex(h[name],type,handler);if(i<0){const x={type:type,handler:handler,listener:listener(this,handler)};(h[name]||(h[name]=[])).push(x);if(this._svg){this._svg.addEventListener(name,x.listener)}}return this}off(type,handler){const name=this.eventName(type),h=this._handlers[name],i=this._handlerIndex(h,type,handler);if(i>=0){if(this._svg){this._svg.removeEventListener(name,h[i].listener)}h.splice(i,1)}return this}}const listener=(context,handler)=>evt=>{let item=evt.target.__data__;item=Array.isArray(item)?item[0]:item;evt.vegaType=evt.type;handler.call(context._obj,evt,item)};const ARIA_HIDDEN="aria-hidden";const ARIA_LABEL="aria-label";const ARIA_ROLE="role";const ARIA_ROLEDESCRIPTION="aria-roledescription";const GRAPHICS_OBJECT="graphics-object";const GRAPHICS_SYMBOL="graphics-symbol";const bundle=(role,roledesc,label)=>({[ARIA_ROLE]:role,[ARIA_ROLEDESCRIPTION]:roledesc,[ARIA_LABEL]:label||undefined});const AriaIgnore=vegaUtil.toSet(["axis-domain","axis-grid","axis-label","axis-tick","axis-title","legend-band","legend-entry","legend-gradient","legend-label","legend-title","legend-symbol","title"]);const AriaGuides={axis:{desc:"axis",caption:axisCaption},legend:{desc:"legend",caption:legendCaption},"title-text":{desc:"title",caption:item=>`Title text '${titleCaption(item)}'`},"title-subtitle":{desc:"subtitle",caption:item=>`Subtitle text '${titleCaption(item)}'`}};const AriaEncode={ariaRole:ARIA_ROLE,ariaRoleDescription:ARIA_ROLEDESCRIPTION,description:ARIA_LABEL};function ariaItemAttributes(emit,item){const hide=item.aria===false;emit(ARIA_HIDDEN,hide||undefined);if(hide||item.description==null){for(const prop in AriaEncode){emit(AriaEncode[prop],undefined)}}else{const type=item.mark.marktype;emit(ARIA_LABEL,item.description);emit(ARIA_ROLE,item.ariaRole||(type==="group"?GRAPHICS_OBJECT:GRAPHICS_SYMBOL));emit(ARIA_ROLEDESCRIPTION,item.ariaRoleDescription||`${type} mark`)}}function ariaMarkAttributes(mark){return mark.aria===false?{[ARIA_HIDDEN]:true}:AriaIgnore[mark.role]?null:AriaGuides[mark.role]?ariaGuide(mark,AriaGuides[mark.role]):ariaMark(mark)}function ariaMark(mark){const type=mark.marktype;const recurse=type==="group"||type==="text"||mark.items.some(_=>_.description!=null&&_.aria!==false);return bundle(recurse?GRAPHICS_OBJECT:GRAPHICS_SYMBOL,`${type} mark container`,mark.description)}function ariaGuide(mark,opt){try{const item=mark.items[0],caption=opt.caption||(()=>"");return bundle(opt.role||GRAPHICS_SYMBOL,opt.desc,item.description||caption(item))}catch(err){return null}}function titleCaption(item){return vegaUtil.array(item.text).join(" ")}function axisCaption(item){const datum=item.datum,orient=item.orient,title=datum.title?extractTitle(item):null,ctx=item.context,scale=ctx.scales[datum.scale].value,locale=ctx.dataflow.locale(),type=scale.type,xy=orient==="left"||orient==="right"?"Y":"X";return`${xy}-axis`+(title?` titled '${title}'`:"")+` for a ${vegaScale.isDiscrete(type)?"discrete":type} scale`+` with ${vegaScale.domainCaption(locale,scale,item)}`}function legendCaption(item){const datum=item.datum,title=datum.title?extractTitle(item):null,type=`${datum.type||""} legend`.trim(),scales=datum.scales,props=Object.keys(scales),ctx=item.context,scale=ctx.scales[scales[props[0]]].value,locale=ctx.dataflow.locale();return capitalize(type)+(title?` titled '${title}'`:"")+` for ${channelCaption(props)}`+` with ${vegaScale.domainCaption(locale,scale,item)}`}function extractTitle(item){try{return vegaUtil.array(vegaUtil.peek(item.items).items[0].text).join(" ")}catch(err){return null}}function channelCaption(props){props=props.map(p=>p+(p==="fill"||p==="stroke"?" color":""));return props.length<2?props[0]:props.slice(0,-1).join(", ")+" and "+vegaUtil.peek(props)}function capitalize(s){return s.length?s[0].toUpperCase()+s.slice(1):s}const innerText=val=>(val+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");const attrText=val=>innerText(val).replace(/"/g,"&quot;").replace(/\t/g,"&#x9;").replace(/\n/g,"&#xA;").replace(/\r/g,"&#xD;");function markup(){let buf="",outer="",inner="";const stack=[],clear=()=>outer=inner="",push=tag=>{if(outer){buf+=`${outer}>${inner}`;clear()}stack.push(tag)},attr=(name,value)=>{if(value!=null)outer+=` ${name}="${attrText(value)}"`;return m},m={open(tag){push(tag);outer="<"+tag;for(var _len=arguments.length,attrs=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){attrs[_key-1]=arguments[_key]}for(const set of attrs){for(const key in set)attr(key,set[key])}return m},close(){const tag=stack.pop();if(outer){buf+=outer+(inner?`>${inner}</${tag}>`:"/>")}else{buf+=`</${tag}>`}clear();return m},attr:attr,text:t=>(inner+=innerText(t),m),toString:()=>buf};return m}const serializeXML=node=>_serialize(markup(),node)+"";function _serialize(m,node){m.open(node.tagName);if(node.hasAttributes()){const attrs=node.attributes,n=attrs.length;for(let i=0;i<n;++i){m.attr(attrs[i].name,attrs[i].value)}}if(node.hasChildNodes()){const children=node.childNodes;for(const child of children){child.nodeType===3?m.text(child.nodeValue):_serialize(m,child)}}return m.close()}const stylesAttr={fill:"fill",fillOpacity:"fill-opacity",stroke:"stroke",strokeOpacity:"stroke-opacity",strokeWidth:"stroke-width",strokeCap:"stroke-linecap",strokeJoin:"stroke-linejoin",strokeDash:"stroke-dasharray",strokeDashOffset:"stroke-dashoffset",strokeMiterLimit:"stroke-miterlimit",opacity:"opacity"};const stylesCss={blend:"mix-blend-mode"};const rootAttributes={fill:"none","stroke-miterlimit":10};const RootIndex=0,xmlns="http://www.w3.org/2000/xmlns/",svgns=metadata.xmlns;class SVGRenderer extends Renderer{constructor(loader){super(loader);this._dirtyID=0;this._dirty=[];this._svg=null;this._root=null;this._defs=null}initialize(el,width,height,origin,scaleFactor){this._defs={};this._clearDefs();if(el){this._svg=domChild(el,0,"svg",svgns);this._svg.setAttributeNS(xmlns,"xmlns",svgns);this._svg.setAttributeNS(xmlns,"xmlns:xlink",metadata["xmlns:xlink"]);this._svg.setAttribute("version",metadata["version"]);this._svg.setAttribute("class","marks");domClear(el,1);this._root=domChild(this._svg,RootIndex,"g",svgns);setAttributes(this._root,rootAttributes);domClear(this._svg,RootIndex+1)}this.background(this._bgcolor);return super.initialize(el,width,height,origin,scaleFactor)}background(bgcolor){if(arguments.length&&this._svg){this._svg.style.setProperty("background-color",bgcolor)}return super.background(...arguments)}resize(width,height,origin,scaleFactor){super.resize(width,height,origin,scaleFactor);if(this._svg){setAttributes(this._svg,{width:this._width*this._scale,height:this._height*this._scale,viewBox:`0 0 ${this._width} ${this._height}`});this._root.setAttribute("transform",`translate(${this._origin})`)}this._dirty=[];return this}canvas(){return this._svg}svg(){const svg=this._svg,bg=this._bgcolor;if(!svg)return null;let node;if(bg){svg.removeAttribute("style");node=domChild(svg,RootIndex,"rect",svgns);setAttributes(node,{width:this._width,height:this._height,fill:bg})}const text=serializeXML(svg);if(bg){svg.removeChild(node);this._svg.style.setProperty("background-color",bg)}return text}_render(scene,markTypes){if(this._dirtyCheck()){if(this._dirtyAll)this._clearDefs();this.mark(this._root,scene,undefined,markTypes);domClear(this._root,1)}this.defs();this._dirty=[];++this._dirtyID;return this}dirty(item){if(item.dirty!==this._dirtyID){item.dirty=this._dirtyID;this._dirty.push(item)}}isDirty(item){return this._dirtyAll||!item._svg||!item._svg.ownerSVGElement||item.dirty===this._dirtyID}_dirtyCheck(){this._dirtyAll=true;const items=this._dirty;if(!items.length||!this._dirtyID)return true;const id=++this._dirtyID;let item,mark,type,mdef,i,n,o;for(i=0,n=items.length;i<n;++i){item=items[i];mark=item.mark;if(mark.marktype!==type){type=mark.marktype;mdef=Marks[type]}if(mark.zdirty&&mark.dirty!==id){this._dirtyAll=false;dirtyParents(item,id);mark.items.forEach(i=>{i.dirty=id})}if(mark.zdirty)continue;if(item.exit){if(mdef.nested&&mark.items.length){o=mark.items[0];if(o._svg)this._update(mdef,o._svg,o)}else if(item._svg){o=item._svg.parentNode;if(o)o.removeChild(item._svg)}item._svg=null;continue}item=mdef.nested?mark.items[0]:item;if(item._update===id)continue;if(!item._svg||!item._svg.ownerSVGElement){this._dirtyAll=false;dirtyParents(item,id)}else{this._update(mdef,item._svg,item)}item._update=id}return!this._dirtyAll}mark(el,scene,prev,markTypes){if(!this.isDirty(scene)){return scene._svg}const svg=this._svg,markType=scene.marktype,mdef=Marks[markType],events=scene.interactive===false?"none":null,isGroup=mdef.tag==="g";const parent=bind(scene,el,prev,"g",svg);if(markType!=="group"&&markTypes!=null&&!markTypes.includes(markType)){domClear(parent,0);return scene._svg}parent.setAttribute("class",cssClass(scene));const aria=ariaMarkAttributes(scene);for(const key in aria)setAttribute(parent,key,aria[key]);if(!isGroup){setAttribute(parent,"pointer-events",events)}setAttribute(parent,"clip-path",scene.clip?clip$1(this,scene,scene.group):null);let sibling=null,i=0;const process=item=>{const dirty=this.isDirty(item),node=bind(item,parent,sibling,mdef.tag,svg);if(dirty){this._update(mdef,node,item);if(isGroup)recurse(this,node,item,markTypes)}sibling=node;++i};if(mdef.nested){if(scene.items.length)process(scene.items[0])}else{visit(scene,process)}domClear(parent,i);return parent}_update(mdef,el,item){element=el;values=el.__values__;ariaItemAttributes(emit,item);mdef.attr(emit,item,this);const extra=mark_extras[mdef.type];if(extra)extra.call(this,mdef,el,item);if(element)this.style(element,item)}style(el,item){if(item==null)return;for(const prop in stylesAttr){let value=prop==="font"?fontFamily(item):item[prop];if(value===values[prop])continue;const name=stylesAttr[prop];if(value==null){el.removeAttribute(name)}else{if(isGradient(value)){value=gradientRef(value,this._defs.gradient,href())}el.setAttribute(name,value+"")}values[prop]=value}for(const prop in stylesCss){setStyle(el,stylesCss[prop],item[prop])}}defs(){const svg=this._svg,defs=this._defs;let el=defs.el,index=0;for(const id in defs.gradient){if(!el)defs.el=el=domChild(svg,RootIndex+1,"defs",svgns);index=updateGradient(el,defs.gradient[id],index)}for(const id in defs.clipping){if(!el)defs.el=el=domChild(svg,RootIndex+1,"defs",svgns);index=updateClipping(el,defs.clipping[id],index)}if(el){index===0?(svg.removeChild(el),defs.el=null):domClear(el,index)}}_clearDefs(){const def=this._defs;def.gradient={};def.clipping={}}}function dirtyParents(item,id){for(;item&&item.dirty!==id;item=item.mark.group){item.dirty=id;if(item.mark&&item.mark.dirty!==id){item.mark.dirty=id}else return}}function updateGradient(el,grad,index){let i,n,stop;if(grad.gradient==="radial"){let pt=domChild(el,index++,"pattern",svgns);setAttributes(pt,{id:patternPrefix+grad.id,viewBox:"0,0,1,1",width:"100%",height:"100%",preserveAspectRatio:"xMidYMid slice"});pt=domChild(pt,0,"rect",svgns);setAttributes(pt,{width:1,height:1,fill:`url(${href()}#${grad.id})`});el=domChild(el,index++,"radialGradient",svgns);setAttributes(el,{id:grad.id,fx:grad.x1,fy:grad.y1,fr:grad.r1,cx:grad.x2,cy:grad.y2,r:grad.r2})}else{el=domChild(el,index++,"linearGradient",svgns);setAttributes(el,{id:grad.id,x1:grad.x1,x2:grad.x2,y1:grad.y1,y2:grad.y2})}for(i=0,n=grad.stops.length;i<n;++i){stop=domChild(el,i,"stop",svgns);stop.setAttribute("offset",grad.stops[i].offset);stop.setAttribute("stop-color",grad.stops[i].color)}domClear(el,i);return index}function updateClipping(el,clip,index){let mask;el=domChild(el,index,"clipPath",svgns);el.setAttribute("id",clip.id);if(clip.path){mask=domChild(el,0,"path",svgns);mask.setAttribute("d",clip.path)}else{mask=domChild(el,0,"rect",svgns);setAttributes(mask,{x:0,y:0,width:clip.width,height:clip.height})}domClear(el,1);return index+1}function recurse(renderer,el,group,markTypes){el=el.lastChild.previousSibling;let prev,idx=0;visit(group,item=>{prev=renderer.mark(el,item,prev,markTypes);++idx});domClear(el,1+idx)}function bind(item,el,sibling,tag,svg){let node=item._svg,doc;if(!node){doc=el.ownerDocument;node=domCreate(doc,tag,svgns);item._svg=node;if(item.mark){node.__data__=item;node.__values__={fill:"default"};if(tag==="g"){const bg=domCreate(doc,"path",svgns);node.appendChild(bg);bg.__data__=item;const cg=domCreate(doc,"g",svgns);node.appendChild(cg);cg.__data__=item;const fg=domCreate(doc,"path",svgns);node.appendChild(fg);fg.__data__=item;fg.__values__={fill:"default"}}}}if(node.ownerSVGElement!==svg||siblingCheck(node,sibling)){el.insertBefore(node,sibling?sibling.nextSibling:el.firstChild)}return node}function siblingCheck(node,sibling){return node.parentNode&&node.parentNode.childNodes.length>1&&node.previousSibling!=sibling}let element=null,values=null;const mark_extras={group(mdef,el,item){const fg=element=el.childNodes[2];values=fg.__values__;mdef.foreground(emit,item,this);values=el.__values__;element=el.childNodes[1];mdef.content(emit,item,this);const bg=element=el.childNodes[0];mdef.background(emit,item,this);const value=item.mark.interactive===false?"none":null;if(value!==values.events){setAttribute(fg,"pointer-events",value);setAttribute(bg,"pointer-events",value);values.events=value}if(item.strokeForeground&&item.stroke){const fill=item.fill;setAttribute(fg,"display",null);this.style(bg,item);setAttribute(bg,"stroke",null);if(fill)item.fill=null;values=fg.__values__;this.style(fg,item);if(fill)item.fill=fill;element=null}else{setAttribute(fg,"display","none")}},image(mdef,el,item){if(item.smooth===false){setStyle(el,"image-rendering","optimizeSpeed");setStyle(el,"image-rendering","pixelated")}else{setStyle(el,"image-rendering",null)}},text(mdef,el,item){const tl=textLines(item);let key,value,doc,lh;if(vegaUtil.isArray(tl)){value=tl.map(_=>textValue(item,_));key=value.join("\n");if(key!==values.text){domClear(el,0);doc=el.ownerDocument;lh=lineHeight(item);value.forEach((t,i)=>{const ts=domCreate(doc,"tspan",svgns);ts.__data__=item;ts.textContent=t;if(i){ts.setAttribute("x",0);ts.setAttribute("dy",lh)}el.appendChild(ts)});values.text=key}}else{value=textValue(item,tl);if(value!==values.text){el.textContent=value;values.text=value}}setAttribute(el,"font-family",fontFamily(item));setAttribute(el,"font-size",fontSize(item)+"px");setAttribute(el,"font-style",item.fontStyle);setAttribute(el,"font-variant",item.fontVariant);setAttribute(el,"font-weight",item.fontWeight)}};function emit(name,value,ns){if(value===values[name])return;if(ns){setAttributeNS(element,name,value,ns)}else{setAttribute(element,name,value)}values[name]=value}function setStyle(el,name,value){if(value!==values[name]){if(value==null){el.style.removeProperty(name)}else{el.style.setProperty(name,value+"")}values[name]=value}}function setAttributes(el,attrs){for(const key in attrs){setAttribute(el,key,attrs[key])}}function setAttribute(el,name,value){if(value!=null){el.setAttribute(name,value)}else{el.removeAttribute(name)}}function setAttributeNS(el,name,value,ns){if(value!=null){el.setAttributeNS(ns,name,value)}else{el.removeAttributeNS(ns,name)}}function href(){let loc;return typeof window==="undefined"?"":(loc=window.location).hash?loc.href.slice(0,-loc.hash.length):loc.href}class SVGStringRenderer extends Renderer{constructor(loader){super(loader);this._text=null;this._defs={gradient:{},clipping:{}}}svg(){return this._text}_render(scene){const m=markup();m.open("svg",vegaUtil.extend({},metadata,{class:"marks",width:this._width*this._scale,height:this._height*this._scale,viewBox:`0 0 ${this._width} ${this._height}`}));const bg=this._bgcolor;if(bg&&bg!=="transparent"&&bg!=="none"){m.open("rect",{width:this._width,height:this._height,fill:bg}).close()}m.open("g",rootAttributes,{transform:"translate("+this._origin+")"});this.mark(m,scene);m.close();this.defs(m);this._text=m.close()+"";return this}mark(m,scene){const mdef=Marks[scene.marktype],tag=mdef.tag,attrList=[ariaItemAttributes,mdef.attr];m.open("g",{class:cssClass(scene),"clip-path":scene.clip?clip$1(this,scene,scene.group):null},ariaMarkAttributes(scene),{"pointer-events":tag!=="g"&&scene.interactive===false?"none":null});const process=item=>{const href=this.href(item);if(href)m.open("a",href);m.open(tag,this.attr(scene,item,attrList,tag!=="g"?tag:null));if(tag==="text"){const tl=textLines(item);if(vegaUtil.isArray(tl)){const attrs={x:0,dy:lineHeight(item)};for(let i=0;i<tl.length;++i){m.open("tspan",i?attrs:null).text(textValue(item,tl[i])).close()}}else{m.text(textValue(item,tl))}}else if(tag==="g"){const fore=item.strokeForeground,fill=item.fill,stroke=item.stroke;if(fore&&stroke){item.stroke=null}m.open("path",this.attr(scene,item,mdef.background,"bgrect")).close();m.open("g",this.attr(scene,item,mdef.content));visit(item,scene=>this.mark(m,scene));m.close();if(fore&&stroke){if(fill)item.fill=null;item.stroke=stroke;m.open("path",this.attr(scene,item,mdef.foreground,"bgrect")).close();if(fill)item.fill=fill}else{m.open("path",this.attr(scene,item,mdef.foreground,"bgfore")).close()}}m.close();if(href)m.close()};if(mdef.nested){if(scene.items&&scene.items.length)process(scene.items[0])}else{visit(scene,process)}return m.close()}href(item){const href=item.href;let attr;if(href){if(attr=this._hrefs&&this._hrefs[href]){return attr}else{this.sanitizeURL(href).then(attr=>{attr["xlink:href"]=attr.href;attr.href=null;(this._hrefs||(this._hrefs={}))[href]=attr})}}return null}attr(scene,item,attrs,tag){const object={},emit=(name,value,ns,prefixed)=>{object[prefixed||name]=value};if(Array.isArray(attrs)){attrs.forEach(fn=>fn(emit,item,this))}else{attrs(emit,item,this)}if(tag){style(object,item,scene,tag,this._defs)}return object}defs(m){const gradient=this._defs.gradient,clipping=this._defs.clipping,count=Object.keys(gradient).length+Object.keys(clipping).length;if(count===0)return;m.open("defs");for(const id in gradient){const def=gradient[id],stops=def.stops;if(def.gradient==="radial"){m.open("pattern",{id:patternPrefix+id,viewBox:"0,0,1,1",width:"100%",height:"100%",preserveAspectRatio:"xMidYMid slice"});m.open("rect",{width:"1",height:"1",fill:"url(#"+id+")"}).close();m.close();m.open("radialGradient",{id:id,fx:def.x1,fy:def.y1,fr:def.r1,cx:def.x2,cy:def.y2,r:def.r2})}else{m.open("linearGradient",{id:id,x1:def.x1,x2:def.x2,y1:def.y1,y2:def.y2})}for(let i=0;i<stops.length;++i){m.open("stop",{offset:stops[i].offset,"stop-color":stops[i].color}).close()}m.close()}for(const id in clipping){const def=clipping[id];m.open("clipPath",{id:id});if(def.path){m.open("path",{d:def.path}).close()}else{m.open("rect",{x:0,y:0,width:def.width,height:def.height}).close()}m.close()}m.close()}}function style(s,item,scene,tag,defs){let styleList;if(item==null)return s;if(tag==="bgrect"&&scene.interactive===false){s["pointer-events"]="none"}if(tag==="bgfore"){if(scene.interactive===false){s["pointer-events"]="none"}s.display="none";if(item.fill!==null)return s}if(tag==="image"&&item.smooth===false){styleList=["image-rendering: optimizeSpeed;","image-rendering: pixelated;"]}if(tag==="text"){s["font-family"]=fontFamily(item);s["font-size"]=fontSize(item)+"px";s["font-style"]=item.fontStyle;s["font-variant"]=item.fontVariant;s["font-weight"]=item.fontWeight}for(const prop in stylesAttr){let value=item[prop];const name=stylesAttr[prop];if(value==="transparent"&&(name==="fill"||name==="stroke"));else if(value!=null){if(isGradient(value)){value=gradientRef(value,defs.gradient,"")}s[name]=value}}for(const prop in stylesCss){const value=item[prop];if(value!=null){styleList=styleList||[];styleList.push(`${stylesCss[prop]}: ${value};`)}}if(styleList){s.style=styleList.join(" ")}return s}const OPTS={svgMarkTypes:["text"],svgOnTop:true,debug:false};function setHybridRendererOptions(options){var _options$svgMarkTypes,_options$svgOnTop,_options$debug;OPTS["svgMarkTypes"]=(_options$svgMarkTypes=options.svgMarkTypes)!==null&&_options$svgMarkTypes!==void 0?_options$svgMarkTypes:["text"];OPTS["svgOnTop"]=(_options$svgOnTop=options.svgOnTop)!==null&&_options$svgOnTop!==void 0?_options$svgOnTop:true;OPTS["debug"]=(_options$debug=options.debug)!==null&&_options$debug!==void 0?_options$debug:false}class HybridRenderer extends Renderer{constructor(loader){super(loader);this._svgRenderer=new SVGRenderer(loader);this._canvasRenderer=new CanvasRenderer(loader)}initialize(el,width,height,origin,scaleFactor){this._root_el=domChild(el,0,"div");const bottomEl=domChild(this._root_el,0,"div");const topEl=domChild(this._root_el,1,"div");this._root_el.style.position="relative";if(!OPTS.debug){bottomEl.style.height="100%";topEl.style.position="absolute";topEl.style.top="0";topEl.style.left="0";topEl.style.height="100%";topEl.style.width="100%"}this._svgEl=OPTS.svgOnTop?topEl:bottomEl;this._canvasEl=OPTS.svgOnTop?bottomEl:topEl;this._svgEl.style.pointerEvents="none";this._canvasRenderer.initialize(this._canvasEl,width,height,origin,scaleFactor);this._svgRenderer.initialize(this._svgEl,width,height,origin,scaleFactor);return super.initialize(el,width,height,origin,scaleFactor)}dirty(item){if(OPTS.svgMarkTypes.includes(item.mark.marktype)){this._svgRenderer.dirty(item)}else{this._canvasRenderer.dirty(item)}return this}_render(scene,markTypes){const allMarkTypes=markTypes!==null&&markTypes!==void 0?markTypes:["arc","area","image","line","path","rect","rule","shape","symbol","text","trail"];const canvasMarkTypes=allMarkTypes.filter(m=>!OPTS.svgMarkTypes.includes(m));this._svgRenderer.render(scene,OPTS.svgMarkTypes);this._canvasRenderer.render(scene,canvasMarkTypes)}resize(width,height,origin,scaleFactor){super.resize(width,height,origin,scaleFactor);this._svgRenderer.resize(width,height,origin,scaleFactor);this._canvasRenderer.resize(width,height,origin,scaleFactor);return this}background(bgcolor){if(OPTS.svgOnTop){this._canvasRenderer.background(bgcolor)}else{this._svgRenderer.background(bgcolor)}return this}}class HybridHandler extends CanvasHandler{constructor(loader,tooltip){super(loader,tooltip)}initialize(el,origin,obj){const canvas=domChild(domChild(el,0,"div"),OPTS.svgOnTop?0:1,"div");return super.initialize(canvas,origin,obj)}}const Canvas="canvas";const Hybrid="hybrid";const PNG="png";const SVG="svg";const None="none";const RenderType={Canvas:Canvas,PNG:PNG,SVG:SVG,Hybrid:Hybrid,None:None};const modules={};modules[Canvas]=modules[PNG]={renderer:CanvasRenderer,headless:CanvasRenderer,handler:CanvasHandler};modules[SVG]={renderer:SVGRenderer,headless:SVGStringRenderer,handler:SVGHandler};modules[Hybrid]={renderer:HybridRenderer,headless:HybridRenderer,handler:HybridHandler};modules[None]={};function renderModule(name,_){name=String(name||"").toLowerCase();if(arguments.length>1){modules[name]=_;return this}else{return modules[name]}}function intersect(scene,bounds,filter){const hits=[],box=(new Bounds).union(bounds),type=scene.marktype;return type?intersectMark(scene,box,filter,hits):type==="group"?intersectGroup(scene,box,filter,hits):vegaUtil.error("Intersect scene must be mark node or group item.")}function intersectMark(mark,box,filter,hits){if(visitMark(mark,box,filter)){const items=mark.items,type=mark.marktype,n=items.length;let i=0;if(type==="group"){for(;i<n;++i){intersectGroup(items[i],box,filter,hits)}}else{for(const test=Marks[type].isect;i<n;++i){const item=items[i];if(intersectItem(item,box,test))hits.push(item)}}}return hits}function visitMark(mark,box,filter){return mark.bounds&&box.intersects(mark.bounds)&&(mark.marktype==="group"||mark.interactive!==false&&(!filter||filter(mark)))}function intersectGroup(group,box,filter,hits){if(filter&&filter(group.mark)&&intersectItem(group,box,Marks.group.isect)){hits.push(group)}const marks=group.items,n=marks&&marks.length;if(n){const x=group.x||0,y=group.y||0;box.translate(-x,-y);for(let i=0;i<n;++i){intersectMark(marks[i],box,filter,hits)}box.translate(x,y)}return hits}function intersectItem(item,box,test){const bounds=item.bounds;return box.encloses(bounds)||box.intersects(bounds)&&test(item,box)}const clipBounds=new Bounds;function boundClip(mark){const clip=mark.clip;if(vegaUtil.isFunction(clip)){clip(boundContext(clipBounds.clear()))}else if(clip){clipBounds.set(0,0,mark.group.width,mark.group.height)}else return;mark.bounds.intersect(clipBounds)}const TOLERANCE=1e-9;function sceneEqual(a,b,key){return a===b?true:key==="path"?pathEqual(a,b):a instanceof Date&&b instanceof Date?+a===+b:vegaUtil.isNumber(a)&&vegaUtil.isNumber(b)?Math.abs(a-b)<=TOLERANCE:!a||!b||!vegaUtil.isObject(a)&&!vegaUtil.isObject(b)?a==b:objectEqual(a,b)}function pathEqual(a,b){return sceneEqual(parse(a),parse(b))}function objectEqual(a,b){var ka=Object.keys(a),kb=Object.keys(b),key,i;if(ka.length!==kb.length)return false;ka.sort();kb.sort();for(i=ka.length-1;i>=0;i--){if(ka[i]!=kb[i])return false}for(i=ka.length-1;i>=0;i--){key=ka[i];if(!sceneEqual(a[key],b[key],key))return false}return typeof a===typeof b}function resetSVGDefIds(){resetSVGClipId();resetSVGGradientId()}exports.Bounds=Bounds;exports.CanvasHandler=CanvasHandler;exports.CanvasRenderer=CanvasRenderer;exports.Gradient=Gradient;exports.GroupItem=GroupItem;exports.Handler=Handler;exports.HybridHandler=HybridHandler;exports.HybridRenderer=HybridRenderer;exports.Item=Item;exports.Marks=Marks;exports.RenderType=RenderType;exports.Renderer=Renderer;exports.ResourceLoader=ResourceLoader;exports.SVGHandler=SVGHandler;exports.SVGRenderer=SVGRenderer;exports.SVGStringRenderer=SVGStringRenderer;exports.Scenegraph=Scenegraph;exports.boundClip=boundClip;exports.boundContext=boundContext;exports.boundItem=boundItem;exports.boundMark=boundMark;exports.boundStroke=boundStroke;exports.domChild=domChild;exports.domClear=domClear;exports.domCreate=domCreate;exports.domFind=domFind;exports.font=font;exports.fontFamily=fontFamily;exports.fontSize=fontSize;exports.intersect=intersect;exports.intersectBoxLine=intersectBoxLine;exports.intersectPath=intersectPath;exports.intersectPoint=intersectPoint;exports.intersectRule=intersectRule;exports.lineHeight=lineHeight;exports.markup=markup;exports.multiLineOffset=multiLineOffset;exports.path=path$3;exports.pathCurves=curves;exports.pathEqual=pathEqual;exports.pathParse=parse;exports.pathRectangle=vg_rect;exports.pathRender=pathRender;exports.pathSymbols=symbols;exports.pathTrail=vg_trail;exports.point=point;exports.renderModule=renderModule;exports.resetSVGClipId=resetSVGClipId;exports.resetSVGDefIds=resetSVGDefIds;exports.sceneEqual=sceneEqual;exports.sceneFromJSON=sceneFromJSON;exports.scenePickVisit=pickVisit;exports.sceneToJSON=sceneToJSON;exports.sceneVisit=visit;exports.sceneZOrder=zorder;exports.serializeXML=serializeXML;exports.setHybridRendererOptions=setHybridRendererOptions;exports.textMetrics=textMetrics}))},,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(71),__webpack_require__(62)):undefined})(this,(function(exports,vegaTime,vegaUtil){"use strict";function memoize(method){const cache={};return spec=>cache[spec]||(cache[spec]=method(spec))}const e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2);function tickSpec(start,stop,count){const step=(stop-start)/Math.max(0,count),power=Math.floor(Math.log10(step)),error=step/Math.pow(10,power),factor=error>=e10?10:error>=e5?5:error>=e2?2:1;let i1,i2,inc;if(power<0){inc=Math.pow(10,-power)/factor;i1=Math.round(start*inc);i2=Math.round(stop*inc);if(i1/inc<start)++i1;if(i2/inc>stop)--i2;inc=-inc}else{inc=Math.pow(10,power)*factor;i1=Math.round(start/inc);i2=Math.round(stop/inc);if(i1*inc<start)++i1;if(i2*inc>stop)--i2}if(i2<i1&&.5<=count&&count<2)return tickSpec(start,stop,count*2);return[i1,i2,inc]}function tickIncrement(start,stop,count){stop=+stop,start=+start,count=+count;return tickSpec(start,stop,count)[2]}function tickStep(start,stop,count){stop=+stop,start=+start,count=+count;const reverse=stop<start,inc=reverse?tickIncrement(stop,start,count):tickIncrement(start,stop,count);return(reverse?-1:1)*(inc<0?1/-inc:inc)}function formatDecimal(x){return Math.abs(x=Math.round(x))>=1e21?x.toLocaleString("en").replace(/,/g,""):x.toString(10)}function formatDecimalParts(x,p){if((i=(x=p?x.toExponential(p-1):x.toExponential()).indexOf("e"))<0)return null;var i,coefficient=x.slice(0,i);return[coefficient.length>1?coefficient[0]+coefficient.slice(2):coefficient,+x.slice(i+1)]}function exponent(x){return x=formatDecimalParts(Math.abs(x)),x?x[1]:NaN}function formatGroup(grouping,thousands){return function(value,width){var i=value.length,t=[],j=0,g=grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=grouping[j=(j+1)%grouping.length]}return t.reverse().join(thousands)}}function formatNumerals(numerals){return function(value){return value.replace(/[0-9]/g,(function(i){return numerals[+i]}))}}var re=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function formatSpecifier(specifier){if(!(match=re.exec(specifier)))throw new Error("invalid format: "+specifier);var match;return new FormatSpecifier({fill:match[1],align:match[2],sign:match[3],symbol:match[4],zero:match[5],width:match[6],comma:match[7],precision:match[8]&&match[8].slice(1),trim:match[9],type:match[10]})}formatSpecifier.prototype=FormatSpecifier.prototype;function FormatSpecifier(specifier){this.fill=specifier.fill===undefined?" ":specifier.fill+"";this.align=specifier.align===undefined?">":specifier.align+"";this.sign=specifier.sign===undefined?"-":specifier.sign+"";this.symbol=specifier.symbol===undefined?"":specifier.symbol+"";this.zero=!!specifier.zero;this.width=specifier.width===undefined?undefined:+specifier.width;this.comma=!!specifier.comma;this.precision=specifier.precision===undefined?undefined:+specifier.precision;this.trim=!!specifier.trim;this.type=specifier.type===undefined?"":specifier.type+""}FormatSpecifier.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(this.width===undefined?"":Math.max(1,this.width|0))+(this.comma?",":"")+(this.precision===undefined?"":"."+Math.max(0,this.precision|0))+(this.trim?"~":"")+this.type};function formatTrim(s){out:for(var n=s.length,i=1,i0=-1,i1;i<n;++i){switch(s[i]){case".":i0=i1=i;break;case"0":if(i0===0)i0=i;i1=i;break;default:if(!+s[i])break out;if(i0>0)i0=0;break}}return i0>0?s.slice(0,i0)+s.slice(i1+1):s}var prefixExponent;function formatPrefixAuto(x,p){var d=formatDecimalParts(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1],i=exponent-(prefixExponent=Math.max(-8,Math.min(8,Math.floor(exponent/3)))*3)+1,n=coefficient.length;return i===n?coefficient:i>n?coefficient+new Array(i-n+1).join("0"):i>0?coefficient.slice(0,i)+"."+coefficient.slice(i):"0."+new Array(1-i).join("0")+formatDecimalParts(x,Math.max(0,p+i-1))[0]}function formatRounded(x,p){var d=formatDecimalParts(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1];return exponent<0?"0."+new Array(-exponent).join("0")+coefficient:coefficient.length>exponent+1?coefficient.slice(0,exponent+1)+"."+coefficient.slice(exponent+1):coefficient+new Array(exponent-coefficient.length+2).join("0")}var formatTypes={"%":(x,p)=>(x*100).toFixed(p),b:x=>Math.round(x).toString(2),c:x=>x+"",d:formatDecimal,e:(x,p)=>x.toExponential(p),f:(x,p)=>x.toFixed(p),g:(x,p)=>x.toPrecision(p),o:x=>Math.round(x).toString(8),p:(x,p)=>formatRounded(x*100,p),r:formatRounded,s:formatPrefixAuto,X:x=>Math.round(x).toString(16).toUpperCase(),x:x=>Math.round(x).toString(16)};function identity(x){return x}var map=Array.prototype.map,prefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function d3_formatLocale(locale){var group=locale.grouping===undefined||locale.thousands===undefined?identity:formatGroup(map.call(locale.grouping,Number),locale.thousands+""),currencyPrefix=locale.currency===undefined?"":locale.currency[0]+"",currencySuffix=locale.currency===undefined?"":locale.currency[1]+"",decimal=locale.decimal===undefined?".":locale.decimal+"",numerals=locale.numerals===undefined?identity:formatNumerals(map.call(locale.numerals,String)),percent=locale.percent===undefined?"%":locale.percent+"",minus=locale.minus===undefined?"−":locale.minus+"",nan=locale.nan===undefined?"NaN":locale.nan+"";function newFormat(specifier){specifier=formatSpecifier(specifier);var fill=specifier.fill,align=specifier.align,sign=specifier.sign,symbol=specifier.symbol,zero=specifier.zero,width=specifier.width,comma=specifier.comma,precision=specifier.precision,trim=specifier.trim,type=specifier.type;if(type==="n")comma=true,type="g";else if(!formatTypes[type])precision===undefined&&(precision=12),trim=true,type="g";if(zero||fill==="0"&&align==="=")zero=true,fill="0",align="=";var prefix=symbol==="$"?currencyPrefix:symbol==="#"&&/[boxX]/.test(type)?"0"+type.toLowerCase():"",suffix=symbol==="$"?currencySuffix:/[%p]/.test(type)?percent:"";var formatType=formatTypes[type],maybeSuffix=/[defgprs%]/.test(type);precision=precision===undefined?6:/[gprs]/.test(type)?Math.max(1,Math.min(21,precision)):Math.max(0,Math.min(20,precision));function format(value){var valuePrefix=prefix,valueSuffix=suffix,i,n,c;if(type==="c"){valueSuffix=formatType(value)+valueSuffix;value=""}else{value=+value;var valueNegative=value<0||1/value<0;value=isNaN(value)?nan:formatType(Math.abs(value),precision);if(trim)value=formatTrim(value);if(valueNegative&&+value===0&&sign!=="+")valueNegative=false;valuePrefix=(valueNegative?sign==="("?sign:minus:sign==="-"||sign==="("?"":sign)+valuePrefix;valueSuffix=(type==="s"?prefixes[8+prefixExponent/3]:"")+valueSuffix+(valueNegative&&sign==="("?")":"");if(maybeSuffix){i=-1,n=value.length;while(++i<n){if(c=value.charCodeAt(i),48>c||c>57){valueSuffix=(c===46?decimal+value.slice(i+1):value.slice(i))+valueSuffix;value=value.slice(0,i);break}}}}if(comma&&!zero)value=group(value,Infinity);var length=valuePrefix.length+value.length+valueSuffix.length,padding=length<width?new Array(width-length+1).join(fill):"";if(comma&&zero)value=group(padding+value,padding.length?width-valueSuffix.length:Infinity),padding="";switch(align){case"<":value=valuePrefix+value+valueSuffix+padding;break;case"=":value=valuePrefix+padding+value+valueSuffix;break;case"^":value=padding.slice(0,length=padding.length>>1)+valuePrefix+value+valueSuffix+padding.slice(length);break;default:value=padding+valuePrefix+value+valueSuffix;break}return numerals(value)}format.toString=function(){return specifier+""};return format}function formatPrefix(specifier,value){var f=newFormat((specifier=formatSpecifier(specifier),specifier.type="f",specifier)),e=Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3,k=Math.pow(10,-e),prefix=prefixes[8+e/3];return function(value){return f(k*value)+prefix}}return{format:newFormat,formatPrefix:formatPrefix}}var locale$2;var format;var formatPrefix;defaultLocale$2({thousands:",",grouping:[3],currency:["$",""]});function defaultLocale$2(definition){locale$2=d3_formatLocale(definition);format=locale$2.format;formatPrefix=locale$2.formatPrefix;return locale$2}function precisionFixed(step){return Math.max(0,-exponent(Math.abs(step)))}function precisionPrefix(step,value){return Math.max(0,Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3-exponent(Math.abs(step)))}function precisionRound(step,max){step=Math.abs(step),max=Math.abs(max)-step;return Math.max(0,exponent(max)-exponent(step))+1}function trimZeroes(numberFormat,decimalChar){return x=>{const str=numberFormat(x),dec=str.indexOf(decimalChar);if(dec<0)return str;let idx=rightmostDigit(str,dec);const end=idx<str.length?str.slice(idx):"";while(--idx>dec)if(str[idx]!=="0"){++idx;break}return str.slice(0,idx)+end}}function rightmostDigit(str,dec){let i=str.lastIndexOf("e"),c;if(i>0)return i;for(i=str.length;--i>dec;){c=str.charCodeAt(i);if(c>=48&&c<=57)return i+1}}function numberLocale(locale){const format=memoize(locale.format),formatPrefix=locale.formatPrefix;return{format:format,formatPrefix:formatPrefix,formatFloat(spec){const s=formatSpecifier(spec||",");if(s.precision==null){s.precision=12;switch(s.type){case"%":s.precision-=2;break;case"e":s.precision-=1;break}return trimZeroes(format(s),format(".1f")(1)[1])}else{return format(s)}},formatSpan(start,stop,count,specifier){specifier=formatSpecifier(specifier==null?",f":specifier);const step=tickStep(start,stop,count),value=Math.max(Math.abs(start),Math.abs(stop));let precision;if(specifier.precision==null){switch(specifier.type){case"s":{if(!isNaN(precision=precisionPrefix(step,value))){specifier.precision=precision}return formatPrefix(specifier,value)}case"":case"e":case"g":case"p":case"r":{if(!isNaN(precision=precisionRound(step,value))){specifier.precision=precision-(specifier.type==="e")}break}case"f":case"%":{if(!isNaN(precision=precisionFixed(step))){specifier.precision=precision-(specifier.type==="%")*2}break}}}return format(specifier)}}}let defaultNumberLocale;resetNumberFormatDefaultLocale();function resetNumberFormatDefaultLocale(){return defaultNumberLocale=numberLocale({format:format,formatPrefix:formatPrefix})}function numberFormatLocale(definition){return numberLocale(d3_formatLocale(definition))}function numberFormatDefaultLocale(definition){return arguments.length?defaultNumberLocale=numberFormatLocale(definition):defaultNumberLocale}const t0=new Date,t1=new Date;function timeInterval(floori,offseti,count,field){function interval(date){return floori(date=arguments.length===0?new Date:new Date(+date)),date}interval.floor=date=>(floori(date=new Date(+date)),date);interval.ceil=date=>(floori(date=new Date(date-1)),offseti(date,1),floori(date),date);interval.round=date=>{const d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1};interval.offset=(date,step)=>(offseti(date=new Date(+date),step==null?1:Math.floor(step)),date);interval.range=(start,stop,step)=>{const range=[];start=interval.ceil(start);step=step==null?1:Math.floor(step);if(!(start<stop)||!(step>0))return range;let previous;do{range.push(previous=new Date(+start)),offseti(start,step),floori(start)}while(previous<start&&start<stop);return range};interval.filter=test=>timeInterval(date=>{if(date>=date)while(floori(date),!test(date))date.setTime(date-1)},(date,step)=>{if(date>=date){if(step<0)while(++step<=0){while(offseti(date,-1),!test(date)){}}else while(--step>=0){while(offseti(date,1),!test(date)){}}}});if(count){interval.count=(start,end)=>{t0.setTime(+start),t1.setTime(+end);floori(t0),floori(t1);return Math.floor(count(t0,t1))};interval.every=step=>{step=Math.floor(step);return!isFinite(step)||!(step>0)?null:!(step>1)?interval:interval.filter(field?d=>field(d)%step===0:d=>interval.count(0,d)%step===0)}}return interval}const durationSecond=1e3;const durationMinute=durationSecond*60;const durationHour=durationMinute*60;const durationDay=durationHour*24;const durationWeek=durationDay*7;const timeDay=timeInterval(date=>date.setHours(0,0,0,0),(date,step)=>date.setDate(date.getDate()+step),(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationDay,date=>date.getDate()-1);timeDay.range;const utcDay=timeInterval(date=>{date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step)},(start,end)=>(end-start)/durationDay,date=>date.getUTCDate()-1);utcDay.range;const unixDay=timeInterval(date=>{date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step)},(start,end)=>(end-start)/durationDay,date=>Math.floor(date/durationDay));unixDay.range;function timeWeekday(i){return timeInterval(date=>{date.setDate(date.getDate()-(date.getDay()+7-i)%7);date.setHours(0,0,0,0)},(date,step)=>{date.setDate(date.getDate()+step*7)},(start,end)=>(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationWeek)}const timeSunday=timeWeekday(0);const timeMonday=timeWeekday(1);const timeTuesday=timeWeekday(2);const timeWednesday=timeWeekday(3);const timeThursday=timeWeekday(4);const timeFriday=timeWeekday(5);const timeSaturday=timeWeekday(6);timeSunday.range;timeMonday.range;timeTuesday.range;timeWednesday.range;timeThursday.range;timeFriday.range;timeSaturday.range;function utcWeekday(i){return timeInterval(date=>{date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCDate(date.getUTCDate()+step*7)},(start,end)=>(end-start)/durationWeek)}const utcSunday=utcWeekday(0);const utcMonday=utcWeekday(1);const utcTuesday=utcWeekday(2);const utcWednesday=utcWeekday(3);const utcThursday=utcWeekday(4);const utcFriday=utcWeekday(5);const utcSaturday=utcWeekday(6);utcSunday.range;utcMonday.range;utcTuesday.range;utcWednesday.range;utcThursday.range;utcFriday.range;utcSaturday.range;const timeYear=timeInterval(date=>{date.setMonth(0,1);date.setHours(0,0,0,0)},(date,step)=>{date.setFullYear(date.getFullYear()+step)},(start,end)=>end.getFullYear()-start.getFullYear(),date=>date.getFullYear());timeYear.every=k=>!isFinite(k=Math.floor(k))||!(k>0)?null:timeInterval(date=>{date.setFullYear(Math.floor(date.getFullYear()/k)*k);date.setMonth(0,1);date.setHours(0,0,0,0)},(date,step)=>{date.setFullYear(date.getFullYear()+step*k)});timeYear.range;const utcYear=timeInterval(date=>{date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCFullYear(date.getUTCFullYear()+step)},(start,end)=>end.getUTCFullYear()-start.getUTCFullYear(),date=>date.getUTCFullYear());utcYear.every=k=>!isFinite(k=Math.floor(k))||!(k>0)?null:timeInterval(date=>{date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k);date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)},(date,step)=>{date.setUTCFullYear(date.getUTCFullYear()+step*k)});utcYear.range;function localDate(d){if(0<=d.y&&d.y<100){var date=new Date(-1,d.m,d.d,d.H,d.M,d.S,d.L);date.setFullYear(d.y);return date}return new Date(d.y,d.m,d.d,d.H,d.M,d.S,d.L)}function utcDate(d){if(0<=d.y&&d.y<100){var date=new Date(Date.UTC(-1,d.m,d.d,d.H,d.M,d.S,d.L));date.setUTCFullYear(d.y);return date}return new Date(Date.UTC(d.y,d.m,d.d,d.H,d.M,d.S,d.L))}function newDate(y,m,d){return{y:y,m:m,d:d,H:0,M:0,S:0,L:0}}function formatLocale(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_weekdays=locale.days,locale_shortWeekdays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;var periodRe=formatRe(locale_periods),periodLookup=formatLookup(locale_periods),weekdayRe=formatRe(locale_weekdays),weekdayLookup=formatLookup(locale_weekdays),shortWeekdayRe=formatRe(locale_shortWeekdays),shortWeekdayLookup=formatLookup(locale_shortWeekdays),monthRe=formatRe(locale_months),monthLookup=formatLookup(locale_months),shortMonthRe=formatRe(locale_shortMonths),shortMonthLookup=formatLookup(locale_shortMonths);var formats={a:formatShortWeekday,A:formatWeekday,b:formatShortMonth,B:formatMonth,c:null,d:formatDayOfMonth,e:formatDayOfMonth,f:formatMicroseconds,g:formatYearISO,G:formatFullYearISO,H:formatHour24,I:formatHour12,j:formatDayOfYear,L:formatMilliseconds,m:formatMonthNumber,M:formatMinutes,p:formatPeriod,q:formatQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatSeconds,u:formatWeekdayNumberMonday,U:formatWeekNumberSunday,V:formatWeekNumberISO,w:formatWeekdayNumberSunday,W:formatWeekNumberMonday,x:null,X:null,y:formatYear,Y:formatFullYear,Z:formatZone,"%":formatLiteralPercent};var utcFormats={a:formatUTCShortWeekday,A:formatUTCWeekday,b:formatUTCShortMonth,B:formatUTCMonth,c:null,d:formatUTCDayOfMonth,e:formatUTCDayOfMonth,f:formatUTCMicroseconds,g:formatUTCYearISO,G:formatUTCFullYearISO,H:formatUTCHour24,I:formatUTCHour12,j:formatUTCDayOfYear,L:formatUTCMilliseconds,m:formatUTCMonthNumber,M:formatUTCMinutes,p:formatUTCPeriod,q:formatUTCQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatUTCSeconds,u:formatUTCWeekdayNumberMonday,U:formatUTCWeekNumberSunday,V:formatUTCWeekNumberISO,w:formatUTCWeekdayNumberSunday,W:formatUTCWeekNumberMonday,x:null,X:null,y:formatUTCYear,Y:formatUTCFullYear,Z:formatUTCZone,"%":formatLiteralPercent};var parses={a:parseShortWeekday,A:parseWeekday,b:parseShortMonth,B:parseMonth,c:parseLocaleDateTime,d:parseDayOfMonth,e:parseDayOfMonth,f:parseMicroseconds,g:parseYear,G:parseFullYear,H:parseHour24,I:parseHour24,j:parseDayOfYear,L:parseMilliseconds,m:parseMonthNumber,M:parseMinutes,p:parsePeriod,q:parseQuarter,Q:parseUnixTimestamp,s:parseUnixTimestampSeconds,S:parseSeconds,u:parseWeekdayNumberMonday,U:parseWeekNumberSunday,V:parseWeekNumberISO,w:parseWeekdayNumberSunday,W:parseWeekNumberMonday,x:parseLocaleDate,X:parseLocaleTime,y:parseYear,Y:parseFullYear,Z:parseZone,"%":parseLiteralPercent};formats.x=newFormat(locale_date,formats);formats.X=newFormat(locale_time,formats);formats.c=newFormat(locale_dateTime,formats);utcFormats.x=newFormat(locale_date,utcFormats);utcFormats.X=newFormat(locale_time,utcFormats);utcFormats.c=newFormat(locale_dateTime,utcFormats);function newFormat(specifier,formats){return function(date){var string=[],i=-1,j=0,n=specifier.length,c,pad,format;if(!(date instanceof Date))date=new Date(+date);while(++i<n){if(specifier.charCodeAt(i)===37){string.push(specifier.slice(j,i));if((pad=pads[c=specifier.charAt(++i)])!=null)c=specifier.charAt(++i);else pad=c==="e"?" ":"0";if(format=formats[c])c=format(date,pad);string.push(c);j=i+1}}string.push(specifier.slice(j,i));return string.join("")}}function newParse(specifier,Z){return function(string){var d=newDate(1900,undefined,1),i=parseSpecifier(d,specifier,string+="",0),week,day;if(i!=string.length)return null;if("Q"in d)return new Date(d.Q);if("s"in d)return new Date(d.s*1e3+("L"in d?d.L:0));if(Z&&!("Z"in d))d.Z=0;if("p"in d)d.H=d.H%12+d.p*12;if(d.m===undefined)d.m="q"in d?d.q:0;if("V"in d){if(d.V<1||d.V>53)return null;if(!("w"in d))d.w=1;if("Z"in d){week=utcDate(newDate(d.y,0,1)),day=week.getUTCDay();week=day>4||day===0?utcMonday.ceil(week):utcMonday(week);week=utcDay.offset(week,(d.V-1)*7);d.y=week.getUTCFullYear();d.m=week.getUTCMonth();d.d=week.getUTCDate()+(d.w+6)%7}else{week=localDate(newDate(d.y,0,1)),day=week.getDay();week=day>4||day===0?timeMonday.ceil(week):timeMonday(week);week=timeDay.offset(week,(d.V-1)*7);d.y=week.getFullYear();d.m=week.getMonth();d.d=week.getDate()+(d.w+6)%7}}else if("W"in d||"U"in d){if(!("w"in d))d.w="u"in d?d.u%7:"W"in d?1:0;day="Z"in d?utcDate(newDate(d.y,0,1)).getUTCDay():localDate(newDate(d.y,0,1)).getDay();d.m=0;d.d="W"in d?(d.w+6)%7+d.W*7-(day+5)%7:d.w+d.U*7-(day+6)%7}if("Z"in d){d.H+=d.Z/100|0;d.M+=d.Z%100;return utcDate(d)}return localDate(d)}}function parseSpecifier(d,specifier,string,j){var i=0,n=specifier.length,m=string.length,c,parse;while(i<n){if(j>=m)return-1;c=specifier.charCodeAt(i++);if(c===37){c=specifier.charAt(i++);parse=parses[c in pads?specifier.charAt(i++):c];if(!parse||(j=parse(d,string,j))<0)return-1}else if(c!=string.charCodeAt(j++)){return-1}}return j}function parsePeriod(d,string,i){var n=periodRe.exec(string.slice(i));return n?(d.p=periodLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseShortWeekday(d,string,i){var n=shortWeekdayRe.exec(string.slice(i));return n?(d.w=shortWeekdayLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseWeekday(d,string,i){var n=weekdayRe.exec(string.slice(i));return n?(d.w=weekdayLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseShortMonth(d,string,i){var n=shortMonthRe.exec(string.slice(i));return n?(d.m=shortMonthLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseMonth(d,string,i){var n=monthRe.exec(string.slice(i));return n?(d.m=monthLookup.get(n[0].toLowerCase()),i+n[0].length):-1}function parseLocaleDateTime(d,string,i){return parseSpecifier(d,locale_dateTime,string,i)}function parseLocaleDate(d,string,i){return parseSpecifier(d,locale_date,string,i)}function parseLocaleTime(d,string,i){return parseSpecifier(d,locale_time,string,i)}function formatShortWeekday(d){return locale_shortWeekdays[d.getDay()]}function formatWeekday(d){return locale_weekdays[d.getDay()]}function formatShortMonth(d){return locale_shortMonths[d.getMonth()]}function formatMonth(d){return locale_months[d.getMonth()]}function formatPeriod(d){return locale_periods[+(d.getHours()>=12)]}function formatQuarter(d){return 1+~~(d.getMonth()/3)}function formatUTCShortWeekday(d){return locale_shortWeekdays[d.getUTCDay()]}function formatUTCWeekday(d){return locale_weekdays[d.getUTCDay()]}function formatUTCShortMonth(d){return locale_shortMonths[d.getUTCMonth()]}function formatUTCMonth(d){return locale_months[d.getUTCMonth()]}function formatUTCPeriod(d){return locale_periods[+(d.getUTCHours()>=12)]}function formatUTCQuarter(d){return 1+~~(d.getUTCMonth()/3)}return{format:function(specifier){var f=newFormat(specifier+="",formats);f.toString=function(){return specifier};return f},parse:function(specifier){var p=newParse(specifier+="",false);p.toString=function(){return specifier};return p},utcFormat:function(specifier){var f=newFormat(specifier+="",utcFormats);f.toString=function(){return specifier};return f},utcParse:function(specifier){var p=newParse(specifier+="",true);p.toString=function(){return specifier};return p}}}var pads={"-":"",_:" ",0:"0"},numberRe=/^\s*\d+/,percentRe=/^%/,requoteRe=/[\\^$*+?|[\]().{}]/g;function pad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string)}function requote(s){return s.replace(requoteRe,"\\$&")}function formatRe(names){return new RegExp("^(?:"+names.map(requote).join("|")+")","i")}function formatLookup(names){return new Map(names.map((name,i)=>[name.toLowerCase(),i]))}function parseWeekdayNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.w=+n[0],i+n[0].length):-1}function parseWeekdayNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.u=+n[0],i+n[0].length):-1}function parseWeekNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.U=+n[0],i+n[0].length):-1}function parseWeekNumberISO(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.V=+n[0],i+n[0].length):-1}function parseWeekNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.W=+n[0],i+n[0].length):-1}function parseFullYear(d,string,i){var n=numberRe.exec(string.slice(i,i+4));return n?(d.y=+n[0],i+n[0].length):-1}function parseYear(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.y=+n[0]+(+n[0]>68?1900:2e3),i+n[0].length):-1}function parseZone(d,string,i){var n=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i,i+6));return n?(d.Z=n[1]?0:-(n[2]+(n[3]||"00")),i+n[0].length):-1}function parseQuarter(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.q=n[0]*3-3,i+n[0].length):-1}function parseMonthNumber(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.m=n[0]-1,i+n[0].length):-1}function parseDayOfMonth(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.d=+n[0],i+n[0].length):-1}function parseDayOfYear(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.m=0,d.d=+n[0],i+n[0].length):-1}function parseHour24(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.H=+n[0],i+n[0].length):-1}function parseMinutes(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.M=+n[0],i+n[0].length):-1}function parseSeconds(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.S=+n[0],i+n[0].length):-1}function parseMilliseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.L=+n[0],i+n[0].length):-1}function parseMicroseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+6));return n?(d.L=Math.floor(n[0]/1e3),i+n[0].length):-1}function parseLiteralPercent(d,string,i){var n=percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1}function parseUnixTimestamp(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.Q=+n[0],i+n[0].length):-1}function parseUnixTimestampSeconds(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.s=+n[0],i+n[0].length):-1}function formatDayOfMonth(d,p){return pad(d.getDate(),p,2)}function formatHour24(d,p){return pad(d.getHours(),p,2)}function formatHour12(d,p){return pad(d.getHours()%12||12,p,2)}function formatDayOfYear(d,p){return pad(1+timeDay.count(timeYear(d),d),p,3)}function formatMilliseconds(d,p){return pad(d.getMilliseconds(),p,3)}function formatMicroseconds(d,p){return formatMilliseconds(d,p)+"000"}function formatMonthNumber(d,p){return pad(d.getMonth()+1,p,2)}function formatMinutes(d,p){return pad(d.getMinutes(),p,2)}function formatSeconds(d,p){return pad(d.getSeconds(),p,2)}function formatWeekdayNumberMonday(d){var day=d.getDay();return day===0?7:day}function formatWeekNumberSunday(d,p){return pad(timeSunday.count(timeYear(d)-1,d),p,2)}function dISO(d){var day=d.getDay();return day>=4||day===0?timeThursday(d):timeThursday.ceil(d)}function formatWeekNumberISO(d,p){d=dISO(d);return pad(timeThursday.count(timeYear(d),d)+(timeYear(d).getDay()===4),p,2)}function formatWeekdayNumberSunday(d){return d.getDay()}function formatWeekNumberMonday(d,p){return pad(timeMonday.count(timeYear(d)-1,d),p,2)}function formatYear(d,p){return pad(d.getFullYear()%100,p,2)}function formatYearISO(d,p){d=dISO(d);return pad(d.getFullYear()%100,p,2)}function formatFullYear(d,p){return pad(d.getFullYear()%1e4,p,4)}function formatFullYearISO(d,p){var day=d.getDay();d=day>=4||day===0?timeThursday(d):timeThursday.ceil(d);return pad(d.getFullYear()%1e4,p,4)}function formatZone(d){var z=d.getTimezoneOffset();return(z>0?"-":(z*=-1,"+"))+pad(z/60|0,"0",2)+pad(z%60,"0",2)}function formatUTCDayOfMonth(d,p){return pad(d.getUTCDate(),p,2)}function formatUTCHour24(d,p){return pad(d.getUTCHours(),p,2)}function formatUTCHour12(d,p){return pad(d.getUTCHours()%12||12,p,2)}function formatUTCDayOfYear(d,p){return pad(1+utcDay.count(utcYear(d),d),p,3)}function formatUTCMilliseconds(d,p){return pad(d.getUTCMilliseconds(),p,3)}function formatUTCMicroseconds(d,p){return formatUTCMilliseconds(d,p)+"000"}function formatUTCMonthNumber(d,p){return pad(d.getUTCMonth()+1,p,2)}function formatUTCMinutes(d,p){return pad(d.getUTCMinutes(),p,2)}function formatUTCSeconds(d,p){return pad(d.getUTCSeconds(),p,2)}function formatUTCWeekdayNumberMonday(d){var dow=d.getUTCDay();return dow===0?7:dow}function formatUTCWeekNumberSunday(d,p){return pad(utcSunday.count(utcYear(d)-1,d),p,2)}function UTCdISO(d){var day=d.getUTCDay();return day>=4||day===0?utcThursday(d):utcThursday.ceil(d)}function formatUTCWeekNumberISO(d,p){d=UTCdISO(d);return pad(utcThursday.count(utcYear(d),d)+(utcYear(d).getUTCDay()===4),p,2)}function formatUTCWeekdayNumberSunday(d){return d.getUTCDay()}function formatUTCWeekNumberMonday(d,p){return pad(utcMonday.count(utcYear(d)-1,d),p,2)}function formatUTCYear(d,p){return pad(d.getUTCFullYear()%100,p,2)}function formatUTCYearISO(d,p){d=UTCdISO(d);return pad(d.getUTCFullYear()%100,p,2)}function formatUTCFullYear(d,p){return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCFullYearISO(d,p){var day=d.getUTCDay();d=day>=4||day===0?utcThursday(d):utcThursday.ceil(d);return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCZone(){return"+0000"}function formatLiteralPercent(){return"%"}function formatUnixTimestamp(d){return+d}function formatUnixTimestampSeconds(d){return Math.floor(+d/1e3)}var locale$1;var timeFormat;var timeParse;var utcFormat;var utcParse;defaultLocale$1({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});function defaultLocale$1(definition){locale$1=formatLocale(definition);timeFormat=locale$1.format;timeParse=locale$1.parse;utcFormat=locale$1.utcFormat;utcParse=locale$1.utcParse;return locale$1}function timeMultiFormat(format,interval,spec){spec=spec||{};if(!vegaUtil.isObject(spec)){vegaUtil.error(`Invalid time multi-format specifier: ${spec}`)}const second=interval(vegaTime.SECONDS),minute=interval(vegaTime.MINUTES),hour=interval(vegaTime.HOURS),day=interval(vegaTime.DATE),week=interval(vegaTime.WEEK),month=interval(vegaTime.MONTH),quarter=interval(vegaTime.QUARTER),year=interval(vegaTime.YEAR),L=format(spec[vegaTime.MILLISECONDS]||".%L"),S=format(spec[vegaTime.SECONDS]||":%S"),M=format(spec[vegaTime.MINUTES]||"%I:%M"),H=format(spec[vegaTime.HOURS]||"%I %p"),d=format(spec[vegaTime.DATE]||spec[vegaTime.DAY]||"%a %d"),w=format(spec[vegaTime.WEEK]||"%b %d"),m=format(spec[vegaTime.MONTH]||"%B"),q=format(spec[vegaTime.QUARTER]||"%B"),y=format(spec[vegaTime.YEAR]||"%Y");return date=>(second(date)<date?L:minute(date)<date?S:hour(date)<date?M:day(date)<date?H:month(date)<date?week(date)<date?d:w:year(date)<date?quarter(date)<date?m:q:y)(date)}function timeLocale(locale){const timeFormat=memoize(locale.format),utcFormat=memoize(locale.utcFormat);return{timeFormat:spec=>vegaUtil.isString(spec)?timeFormat(spec):timeMultiFormat(timeFormat,vegaTime.timeInterval,spec),utcFormat:spec=>vegaUtil.isString(spec)?utcFormat(spec):timeMultiFormat(utcFormat,vegaTime.utcInterval,spec),timeParse:memoize(locale.parse),utcParse:memoize(locale.utcParse)}}let defaultTimeLocale;resetTimeFormatDefaultLocale();function resetTimeFormatDefaultLocale(){return defaultTimeLocale=timeLocale({format:timeFormat,parse:timeParse,utcFormat:utcFormat,utcParse:utcParse})}function timeFormatLocale(definition){return timeLocale(formatLocale(definition))}function timeFormatDefaultLocale(definition){return arguments.length?defaultTimeLocale=timeFormatLocale(definition):defaultTimeLocale}const createLocale=(number,time)=>vegaUtil.extend({},number,time);function locale(numberSpec,timeSpec){const number=numberSpec?numberFormatLocale(numberSpec):numberFormatDefaultLocale();const time=timeSpec?timeFormatLocale(timeSpec):timeFormatDefaultLocale();return createLocale(number,time)}function defaultLocale(numberSpec,timeSpec){const args=arguments.length;if(args&&args!==2){vegaUtil.error("defaultLocale expects either zero or two arguments.")}return args?createLocale(numberFormatDefaultLocale(numberSpec),timeFormatDefaultLocale(timeSpec)):createLocale(numberFormatDefaultLocale(),timeFormatDefaultLocale())}function resetDefaultLocale(){resetNumberFormatDefaultLocale();resetTimeFormatDefaultLocale();return defaultLocale()}exports.defaultLocale=defaultLocale;exports.locale=locale;exports.numberFormatDefaultLocale=numberFormatDefaultLocale;exports.numberFormatLocale=numberFormatLocale;exports.resetDefaultLocale=resetDefaultLocale;exports.resetNumberFormatDefaultLocale=resetNumberFormatDefaultLocale;exports.resetTimeFormatDefaultLocale=resetTimeFormatDefaultLocale;exports.timeFormatDefaultLocale=timeFormatDefaultLocale;exports.timeFormatLocale=timeFormatLocale}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function domCanvas(w,h){if(typeof document!=="undefined"&&document.createElement){const c=document.createElement("canvas");if(c&&c.getContext){c.width=w;c.height=h;return c}}return null}const domImage=()=>typeof Image!=="undefined"?Image:null;exports.canvas=domCanvas;exports.domCanvas=domCanvas;exports.image=domImage}))},function(module,exports,__webpack_require__){(function(Buffer){(function(global,factory){true?factory(exports,__webpack_require__(62),__webpack_require__(93),__webpack_require__(74)):undefined})(this,(function(exports,vegaUtil,topojsonClient,vegaFormat){"use strict";const protocol_re=/^(data:|([A-Za-z]+:)?\/\/)/;const allowed_re=/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp|file|data):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i;const whitespace_re=/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205f\u3000]/g;const fileProtocol="file://";function loaderFactory(fetch,fs){return options=>({options:options||{},sanitize:sanitize,load:load,fileAccess:false,file:fileLoader(fs),http:httpLoader(fetch)})}async function load(uri,options){const opt=await this.sanitize(uri,options),url=opt.href;return opt.localFile?this.file(url):this.http(url,options)}async function sanitize(uri,options){options=vegaUtil.extend({},this.options,options);const fileAccess=this.fileAccess,result={href:null};let isFile,loadFile,base;const isAllowed=allowed_re.test(uri.replace(whitespace_re,""));if(uri==null||typeof uri!=="string"||!isAllowed){vegaUtil.error("Sanitize failure, invalid URI: "+vegaUtil.stringValue(uri))}const hasProtocol=protocol_re.test(uri);if((base=options.baseURL)&&!hasProtocol){if(!uri.startsWith("/")&&!base.endsWith("/")){uri="/"+uri}uri=base+uri}loadFile=(isFile=uri.startsWith(fileProtocol))||options.mode==="file"||options.mode!=="http"&&!hasProtocol&&fileAccess;if(isFile){uri=uri.slice(fileProtocol.length)}else if(uri.startsWith("//")){if(options.defaultProtocol==="file"){uri=uri.slice(2);loadFile=true}else{uri=(options.defaultProtocol||"http")+":"+uri}}Object.defineProperty(result,"localFile",{value:!!loadFile});result.href=uri;if(options.target){result.target=options.target+""}if(options.rel){result.rel=options.rel+""}if(options.context==="image"&&options.crossOrigin){result.crossOrigin=options.crossOrigin+""}return result}function fileLoader(fs){return fs?filename=>new Promise((accept,reject)=>{fs.readFile(filename,(error,data)=>{if(error)reject(error);else accept(data)})}):fileReject}async function fileReject(){vegaUtil.error("No file system access.")}function httpLoader(fetch){return fetch?async function(url,options){const opt=vegaUtil.extend({},this.options.http,options),type=options&&options.response,response=await fetch(url,opt);return!response.ok?vegaUtil.error(response.status+""+response.statusText):vegaUtil.isFunction(response[type])?response[type]():response.text()}:httpReject}async function httpReject(){vegaUtil.error("No HTTP fetch method available.")}const isValid=_=>_!=null&&_===_;const isBoolean=_=>_==="true"||_==="false"||_===true||_===false;const isDate=_=>!Number.isNaN(Date.parse(_));const isNumber=_=>!Number.isNaN(+_)&&!(_ instanceof Date);const isInteger=_=>isNumber(_)&&Number.isInteger(+_);const typeParsers={boolean:vegaUtil.toBoolean,integer:vegaUtil.toNumber,number:vegaUtil.toNumber,date:vegaUtil.toDate,string:vegaUtil.toString,unknown:vegaUtil.identity};const typeTests=[isBoolean,isInteger,isNumber,isDate];const typeList=["boolean","integer","number","date"];function inferType(values,field){if(!values||!values.length)return"unknown";const n=values.length,m=typeTests.length,a=typeTests.map((_,i)=>i+1);for(let i=0,t=0,j,value;i<n;++i){value=field?values[i][field]:values[i];for(j=0;j<m;++j){if(a[j]&&isValid(value)&&!typeTests[j](value)){a[j]=0;++t;if(t===typeTests.length)return"string"}}}return typeList[a.reduce((u,v)=>u===0?v:u,0)-1]}function inferTypes(data,fields){return fields.reduce((types,field)=>{types[field]=inferType(data,field);return types},{})}var EOL={},EOF={},QUOTE=34,NEWLINE=10,RETURN=13;function objectConverter(columns){return new Function("d","return {"+columns.map((function(name,i){return JSON.stringify(name)+": d["+i+'] || ""'})).join(",")+"}")}function customConverter(columns,f){var object=objectConverter(columns);return function(row,i){return f(object(row),i,columns)}}function inferColumns(rows){var columnSet=Object.create(null),columns=[];rows.forEach((function(row){for(var column in row){if(!(column in columnSet)){columns.push(columnSet[column]=column)}}}));return columns}function pad(value,width){var s=value+"",length=s.length;return length<width?new Array(width-length+1).join(0)+s:s}function formatYear(year){return year<0?"-"+pad(-year,6):year>9999?"+"+pad(year,6):pad(year,4)}function formatDate(date){var hours=date.getUTCHours(),minutes=date.getUTCMinutes(),seconds=date.getUTCSeconds(),milliseconds=date.getUTCMilliseconds();return isNaN(date)?"Invalid Date":formatYear(date.getUTCFullYear())+"-"+pad(date.getUTCMonth()+1,2)+"-"+pad(date.getUTCDate(),2)+(milliseconds?"T"+pad(hours,2)+":"+pad(minutes,2)+":"+pad(seconds,2)+"."+pad(milliseconds,3)+"Z":seconds?"T"+pad(hours,2)+":"+pad(minutes,2)+":"+pad(seconds,2)+"Z":minutes||hours?"T"+pad(hours,2)+":"+pad(minutes,2)+"Z":"")}function dsvFormat(delimiter){var reFormat=new RegExp('["'+delimiter+"\n\r]"),DELIMITER=delimiter.charCodeAt(0);function parse(text,f){var convert,columns,rows=parseRows(text,(function(row,i){if(convert)return convert(row,i-1);columns=row,convert=f?customConverter(row,f):objectConverter(row)}));rows.columns=columns||[];return rows}function parseRows(text,f){var rows=[],N=text.length,I=0,n=0,t,eof=N<=0,eol=false;if(text.charCodeAt(N-1)===NEWLINE)--N;if(text.charCodeAt(N-1)===RETURN)--N;function token(){if(eof)return EOF;if(eol)return eol=false,EOL;var i,j=I,c;if(text.charCodeAt(j)===QUOTE){while(I++<N&&text.charCodeAt(I)!==QUOTE||text.charCodeAt(++I)===QUOTE);if((i=I)>=N)eof=true;else if((c=text.charCodeAt(I++))===NEWLINE)eol=true;else if(c===RETURN){eol=true;if(text.charCodeAt(I)===NEWLINE)++I}return text.slice(j+1,i-1).replace(/""/g,'"')}while(I<N){if((c=text.charCodeAt(i=I++))===NEWLINE)eol=true;else if(c===RETURN){eol=true;if(text.charCodeAt(I)===NEWLINE)++I}else if(c!==DELIMITER)continue;return text.slice(j,i)}return eof=true,text.slice(j,N)}while((t=token())!==EOF){var row=[];while(t!==EOL&&t!==EOF)row.push(t),t=token();if(f&&(row=f(row,n++))==null)continue;rows.push(row)}return rows}function preformatBody(rows,columns){return rows.map((function(row){return columns.map((function(column){return formatValue(row[column])})).join(delimiter)}))}function format(rows,columns){if(columns==null)columns=inferColumns(rows);return[columns.map(formatValue).join(delimiter)].concat(preformatBody(rows,columns)).join("\n")}function formatBody(rows,columns){if(columns==null)columns=inferColumns(rows);return preformatBody(rows,columns).join("\n")}function formatRows(rows){return rows.map(formatRow).join("\n")}function formatRow(row){return row.map(formatValue).join(delimiter)}function formatValue(value){return value==null?"":value instanceof Date?formatDate(value):reFormat.test(value+="")?'"'+value.replace(/"/g,'""')+'"':value}return{parse:parse,parseRows:parseRows,format:format,formatBody:formatBody,formatRows:formatRows,formatRow:formatRow,formatValue:formatValue}}function delimitedFormat(delimiter){const parse=function(data,format){const delim={delimiter:delimiter};return dsv(data,format?vegaUtil.extend(format,delim):delim)};parse.responseType="text";return parse}function dsv(data,format){if(format.header){data=format.header.map(vegaUtil.stringValue).join(format.delimiter)+"\n"+data}return dsvFormat(format.delimiter).parse(data+"")}dsv.responseType="text";function isBuffer(_){return typeof Buffer==="function"&&vegaUtil.isFunction(Buffer.isBuffer)?Buffer.isBuffer(_):false}function json(data,format){const prop=format&&format.property?vegaUtil.field(format.property):vegaUtil.identity;return vegaUtil.isObject(data)&&!isBuffer(data)?parseJSON(prop(data),format):prop(JSON.parse(data))}json.responseType="json";function parseJSON(data,format){if(!vegaUtil.isArray(data)&&vegaUtil.isIterable(data)){data=[...data]}return format&&format.copy?JSON.parse(JSON.stringify(data)):data}const filters={interior:(a,b)=>a!==b,exterior:(a,b)=>a===b};function topojson(data,format){let method,object,property,filter;data=json(data,format);if(format&&format.feature){method=topojsonClient.feature;property=format.feature}else if(format&&format.mesh){method=topojsonClient.mesh;property=format.mesh;filter=filters[format.filter]}else{vegaUtil.error("Missing TopoJSON feature or mesh parameter.")}object=(object=data.objects[property])?method(data,object,filter):vegaUtil.error("Invalid TopoJSON object: "+property);return object&&object.features||[object]}topojson.responseType="json";const format={dsv:dsv,csv:delimitedFormat(","),tsv:delimitedFormat("\t"),json:json,topojson:topojson};function formats(name,reader){if(arguments.length>1){format[name]=reader;return this}else{return vegaUtil.hasOwnProperty(format,name)?format[name]:null}}function responseType(type){const f=formats(type);return f&&f.responseType||"text"}function read(data,schema,timeParser,utcParser){schema=schema||{};const reader=formats(schema.type||"json");if(!reader)vegaUtil.error("Unknown data format type: "+schema.type);data=reader(data,schema);if(schema.parse)parse(data,schema.parse,timeParser,utcParser);if(vegaUtil.hasOwnProperty(data,"columns"))delete data.columns;return data}function parse(data,types,timeParser,utcParser){if(!data.length)return;const locale=vegaFormat.timeFormatDefaultLocale();timeParser=timeParser||locale.timeParse;utcParser=utcParser||locale.utcParse;let fields=data.columns||Object.keys(data[0]),datum,field,i,j,n,m;if(types==="auto")types=inferTypes(data,fields);fields=Object.keys(types);const parsers=fields.map(field=>{const type=types[field];let parts,pattern;if(type&&(type.startsWith("date:")||type.startsWith("utc:"))){parts=type.split(/:(.+)?/,2);pattern=parts[1];if(pattern[0]==="'"&&pattern[pattern.length-1]==="'"||pattern[0]==='"'&&pattern[pattern.length-1]==='"'){pattern=pattern.slice(1,-1)}const parse=parts[0]==="utc"?utcParser:timeParser;return parse(pattern)}if(!typeParsers[type]){throw Error("Illegal format pattern: "+field+":"+type)}return typeParsers[type]});for(i=0,n=data.length,m=fields.length;i<n;++i){datum=data[i];for(j=0;j<m;++j){field=fields[j];datum[field]=parsers[j](datum[field])}}}const loader=loaderFactory(typeof fetch!=="undefined"&&fetch,null);exports.format=format;exports.formats=formats;exports.inferType=inferType;exports.inferTypes=inferTypes;exports.loader=loader;exports.read=read;exports.responseType=responseType;exports.typeParsers=typeParsers}))}).call(this,__webpack_require__(89).Buffer)},function(module,exports){var g;g=function(){return this}();try{g=g||new Function("return this")()}catch(e){if(typeof window==="object")g=window}module.exports=g},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(62),__webpack_require__(79),__webpack_require__(67),__webpack_require__(63),__webpack_require__(72),__webpack_require__(106),__webpack_require__(68),__webpack_require__(71)):undefined})(this,(function(exports,vegaUtil,vegaExpression,vegaScale,vegaDataflow,vegaScenegraph,vegaSelections,vegaStatistics,vegaTime){"use strict";function data(name){const data=this.context.data[name];return data?data.values.value:[]}function indata(name,field,value){const index=this.context.data[name]["index:"+field],entry=index?index.value.get(value):undefined;return entry?entry.count:entry}function setdata(name,tuples){const df=this.context.dataflow,data=this.context.data[name],input=data.input;df.pulse(input,df.changeset().remove(vegaUtil.truthy).insert(tuples));return 1}function encode(item,name,retval){if(item){const df=this.context.dataflow,target=item.mark.source;df.pulse(target,df.changeset().encode(item,name))}return retval!==undefined?retval:item}const wrap=method=>function(value,spec){const locale=this.context.dataflow.locale();return value===null?"null":locale[method](spec)(value)};const format=wrap("format");const timeFormat=wrap("timeFormat");const utcFormat=wrap("utcFormat");const timeParse=wrap("timeParse");const utcParse=wrap("utcParse");const dateObj=new Date(2e3,0,1);function time(month,day,specifier){if(!Number.isInteger(month)||!Number.isInteger(day))return"";dateObj.setYear(2e3);dateObj.setMonth(month);dateObj.setDate(day);return timeFormat.call(this,dateObj,specifier)}function monthFormat(month){return time.call(this,month,1,"%B")}function monthAbbrevFormat(month){return time.call(this,month,1,"%b")}function dayFormat(day){return time.call(this,0,2+day,"%A")}function dayAbbrevFormat(day){return time.call(this,0,2+day,"%a")}const DataPrefix=":";const IndexPrefix="@";const ScalePrefix="%";const SignalPrefix="$";function dataVisitor(name,args,scope,params){if(args[0].type!==vegaExpression.Literal){vegaUtil.error("First argument to data functions must be a string literal.")}const data=args[0].value,dataName=DataPrefix+data;if(!vegaUtil.hasOwnProperty(dataName,params)){try{params[dataName]=scope.getData(data).tuplesRef()}catch(err){}}}function indataVisitor(name,args,scope,params){if(args[0].type!==vegaExpression.Literal)vegaUtil.error("First argument to indata must be a string literal.");if(args[1].type!==vegaExpression.Literal)vegaUtil.error("Second argument to indata must be a string literal.");const data=args[0].value,field=args[1].value,indexName=IndexPrefix+field;if(!vegaUtil.hasOwnProperty(indexName,params)){params[indexName]=scope.getData(data).indataRef(scope,field)}}function scaleVisitor(name,args,scope,params){if(args[0].type===vegaExpression.Literal){addScaleDependency(scope,params,args[0].value)}else{for(name in scope.scales){addScaleDependency(scope,params,name)}}}function addScaleDependency(scope,params,name){const scaleName=ScalePrefix+name;if(!vegaUtil.hasOwnProperty(params,scaleName)){try{params[scaleName]=scope.scaleRef(name)}catch(err){}}}function getScale(nameOrFunction,ctx){if(vegaUtil.isString(nameOrFunction)){const maybeScale=ctx.scales[nameOrFunction];return maybeScale&&vegaScale.isRegisteredScale(maybeScale.value)?maybeScale.value:undefined}else if(vegaUtil.isFunction(nameOrFunction)){return vegaScale.isRegisteredScale(nameOrFunction)?nameOrFunction:undefined}return undefined}function internalScaleFunctions(codegen,fnctx,visitors){fnctx.__bandwidth=s=>s&&s.bandwidth?s.bandwidth():0;visitors._bandwidth=scaleVisitor;visitors._range=scaleVisitor;visitors._scale=scaleVisitor;const ref=arg=>"_["+(arg.type===vegaExpression.Literal?vegaUtil.stringValue(ScalePrefix+arg.value):vegaUtil.stringValue(ScalePrefix)+"+"+codegen(arg))+"]";return{_bandwidth:args=>`this.__bandwidth(${ref(args[0])})`,_range:args=>`${ref(args[0])}.range()`,_scale:args=>`${ref(args[0])}(${codegen(args[1])})`}}class Adder{constructor(){this._partials=new Float64Array(32);this._n=0}add(x){const p=this._partials;let i=0;for(let j=0;j<this._n&&j<32;j++){const y=p[j],hi=x+y,lo=Math.abs(x)<Math.abs(y)?x-(hi-y):y-(hi-x);if(lo)p[i++]=lo;x=hi}p[i]=x;this._n=i+1;return this}valueOf(){const p=this._partials;let n=this._n,x,y,lo,hi=0;if(n>0){hi=p[--n];while(n>0){x=hi;y=p[--n];hi=x+y;lo=y-(hi-x);if(lo)break}if(n>0&&(lo<0&&p[n-1]<0||lo>0&&p[n-1]>0)){y=lo*2;x=hi+y;if(y==x-hi)hi=x}}return hi}}function range$2(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;var i=-1,n=Math.max(0,Math.ceil((stop-start)/step))|0,range=new Array(n);while(++i<n){range[i]=start+i*step}return range}var epsilon=1e-6;var epsilon2=1e-12;var pi=Math.PI;var halfPi=pi/2;var quarterPi=pi/4;var tau=pi*2;var degrees$1=180/pi;var radians$1=pi/180;var abs=Math.abs;var atan2=Math.atan2;var cos=Math.cos;var hypot=Math.hypot;var sin=Math.sin;var sqrt=Math.sqrt;function asin(x){return x>1?halfPi:x<-1?-halfPi:Math.asin(x)}function noop(){}function streamGeometry(geometry,stream){if(geometry&&streamGeometryType.hasOwnProperty(geometry.type)){streamGeometryType[geometry.type](geometry,stream)}}var streamObjectType={Feature:function(object,stream){streamGeometry(object.geometry,stream)},FeatureCollection:function(object,stream){var features=object.features,i=-1,n=features.length;while(++i<n)streamGeometry(features[i].geometry,stream)}};var streamGeometryType={Sphere:function(object,stream){stream.sphere()},Point:function(object,stream){object=object.coordinates;stream.point(object[0],object[1],object[2])},MultiPoint:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)object=coordinates[i],stream.point(object[0],object[1],object[2])},LineString:function(object,stream){streamLine(object.coordinates,stream,0)},MultiLineString:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)streamLine(coordinates[i],stream,0)},Polygon:function(object,stream){streamPolygon(object.coordinates,stream)},MultiPolygon:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)streamPolygon(coordinates[i],stream)},GeometryCollection:function(object,stream){var geometries=object.geometries,i=-1,n=geometries.length;while(++i<n)streamGeometry(geometries[i],stream)}};function streamLine(coordinates,stream,closed){var i=-1,n=coordinates.length-closed,coordinate;stream.lineStart();while(++i<n)coordinate=coordinates[i],stream.point(coordinate[0],coordinate[1],coordinate[2]);stream.lineEnd()}function streamPolygon(coordinates,stream){var i=-1,n=coordinates.length;stream.polygonStart();while(++i<n)streamLine(coordinates[i],stream,1);stream.polygonEnd()}function geoStream(object,stream){if(object&&streamObjectType.hasOwnProperty(object.type)){streamObjectType[object.type](object,stream)}else{streamGeometry(object,stream)}}var areaRingSum=new Adder;var areaSum=new Adder,lambda00$2,phi00$2,lambda0$1,cosPhi0,sinPhi0;var areaStream={point:noop,lineStart:noop,lineEnd:noop,polygonStart:function(){areaRingSum=new Adder;areaStream.lineStart=areaRingStart;areaStream.lineEnd=areaRingEnd},polygonEnd:function(){var areaRing=+areaRingSum;areaSum.add(areaRing<0?tau+areaRing:areaRing);this.lineStart=this.lineEnd=this.point=noop},sphere:function(){areaSum.add(tau)}};function areaRingStart(){areaStream.point=areaPointFirst}function areaRingEnd(){areaPoint(lambda00$2,phi00$2)}function areaPointFirst(lambda,phi){areaStream.point=areaPoint;lambda00$2=lambda,phi00$2=phi;lambda*=radians$1,phi*=radians$1;lambda0$1=lambda,cosPhi0=cos(phi=phi/2+quarterPi),sinPhi0=sin(phi)}function areaPoint(lambda,phi){lambda*=radians$1,phi*=radians$1;phi=phi/2+quarterPi;var dLambda=lambda-lambda0$1,sdLambda=dLambda>=0?1:-1,adLambda=sdLambda*dLambda,cosPhi=cos(phi),sinPhi=sin(phi),k=sinPhi0*sinPhi,u=cosPhi0*cosPhi+k*cos(adLambda),v=k*sdLambda*sin(adLambda);areaRingSum.add(atan2(v,u));lambda0$1=lambda,cosPhi0=cosPhi,sinPhi0=sinPhi}function area(object){areaSum=new Adder;geoStream(object,areaStream);return areaSum*2}function spherical(cartesian){return[atan2(cartesian[1],cartesian[0]),asin(cartesian[2])]}function cartesian(spherical){var lambda=spherical[0],phi=spherical[1],cosPhi=cos(phi);return[cosPhi*cos(lambda),cosPhi*sin(lambda),sin(phi)]}function cartesianCross(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]]}function cartesianNormalizeInPlace(d){var l=sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);d[0]/=l,d[1]/=l,d[2]/=l}var lambda0,phi0,lambda1,phi1,lambda2,lambda00$1,phi00$1,p0,deltaSum,ranges,range$1;var boundsStream={point:boundsPoint,lineStart:boundsLineStart,lineEnd:boundsLineEnd,polygonStart:function(){boundsStream.point=boundsRingPoint;boundsStream.lineStart=boundsRingStart;boundsStream.lineEnd=boundsRingEnd;deltaSum=new Adder;areaStream.polygonStart()},polygonEnd:function(){areaStream.polygonEnd();boundsStream.point=boundsPoint;boundsStream.lineStart=boundsLineStart;boundsStream.lineEnd=boundsLineEnd;if(areaRingSum<0)lambda0=-(lambda1=180),phi0=-(phi1=90);else if(deltaSum>epsilon)phi1=90;else if(deltaSum<-1e-6)phi0=-90;range$1[0]=lambda0,range$1[1]=lambda1},sphere:function(){lambda0=-(lambda1=180),phi0=-(phi1=90)}};function boundsPoint(lambda,phi){ranges.push(range$1=[lambda0=lambda,lambda1=lambda]);if(phi<phi0)phi0=phi;if(phi>phi1)phi1=phi}function linePoint(lambda,phi){var p=cartesian([lambda*radians$1,phi*radians$1]);if(p0){var normal=cartesianCross(p0,p),equatorial=[normal[1],-normal[0],0],inflection=cartesianCross(equatorial,normal);cartesianNormalizeInPlace(inflection);inflection=spherical(inflection);var delta=lambda-lambda2,sign=delta>0?1:-1,lambdai=inflection[0]*degrees$1*sign,phii,antimeridian=abs(delta)>180;if(antimeridian^(sign*lambda2<lambdai&&lambdai<sign*lambda)){phii=inflection[1]*degrees$1;if(phii>phi1)phi1=phii}else if(lambdai=(lambdai+360)%360-180,antimeridian^(sign*lambda2<lambdai&&lambdai<sign*lambda)){phii=-inflection[1]*degrees$1;if(phii<phi0)phi0=phii}else{if(phi<phi0)phi0=phi;if(phi>phi1)phi1=phi}if(antimeridian){if(lambda<lambda2){if(angle(lambda0,lambda)>angle(lambda0,lambda1))lambda1=lambda}else{if(angle(lambda,lambda1)>angle(lambda0,lambda1))lambda0=lambda}}else{if(lambda1>=lambda0){if(lambda<lambda0)lambda0=lambda;if(lambda>lambda1)lambda1=lambda}else{if(lambda>lambda2){if(angle(lambda0,lambda)>angle(lambda0,lambda1))lambda1=lambda}else{if(angle(lambda,lambda1)>angle(lambda0,lambda1))lambda0=lambda}}}}else{ranges.push(range$1=[lambda0=lambda,lambda1=lambda])}if(phi<phi0)phi0=phi;if(phi>phi1)phi1=phi;p0=p,lambda2=lambda}function boundsLineStart(){boundsStream.point=linePoint}function boundsLineEnd(){range$1[0]=lambda0,range$1[1]=lambda1;boundsStream.point=boundsPoint;p0=null}function boundsRingPoint(lambda,phi){if(p0){var delta=lambda-lambda2;deltaSum.add(abs(delta)>180?delta+(delta>0?360:-360):delta)}else{lambda00$1=lambda,phi00$1=phi}areaStream.point(lambda,phi);linePoint(lambda,phi)}function boundsRingStart(){areaStream.lineStart()}function boundsRingEnd(){boundsRingPoint(lambda00$1,phi00$1);areaStream.lineEnd();if(abs(deltaSum)>epsilon)lambda0=-(lambda1=180);range$1[0]=lambda0,range$1[1]=lambda1;p0=null}function angle(lambda0,lambda1){return(lambda1-=lambda0)<0?lambda1+360:lambda1}function rangeCompare(a,b){return a[0]-b[0]}function rangeContains(range,x){return range[0]<=range[1]?range[0]<=x&&x<=range[1]:x<range[0]||range[1]<x}function bounds(feature){var i,n,a,b,merged,deltaMax,delta;phi1=lambda1=-(lambda0=phi0=Infinity);ranges=[];geoStream(feature,boundsStream);if(n=ranges.length){ranges.sort(rangeCompare);for(i=1,a=ranges[0],merged=[a];i<n;++i){b=ranges[i];if(rangeContains(a,b[0])||rangeContains(a,b[1])){if(angle(a[0],b[1])>angle(a[0],a[1]))a[1]=b[1];if(angle(b[0],a[1])>angle(a[0],a[1]))a[0]=b[0]}else{merged.push(a=b)}}for(deltaMax=-Infinity,n=merged.length-1,i=0,a=merged[n];i<=n;a=b,++i){b=merged[i];if((delta=angle(a[1],b[0]))>deltaMax)deltaMax=delta,lambda0=b[0],lambda1=a[1]}}ranges=range$1=null;return lambda0===Infinity||phi0===Infinity?[[NaN,NaN],[NaN,NaN]]:[[lambda0,phi0],[lambda1,phi1]]}var W0,W1,X0,Y0,Z0,X1,Y1,Z1,X2,Y2,Z2,lambda00,phi00,x0,y0,z0;var centroidStream={sphere:noop,point:centroidPoint,lineStart:centroidLineStart,lineEnd:centroidLineEnd,polygonStart:function(){centroidStream.lineStart=centroidRingStart;centroidStream.lineEnd=centroidRingEnd},polygonEnd:function(){centroidStream.lineStart=centroidLineStart;centroidStream.lineEnd=centroidLineEnd}};function centroidPoint(lambda,phi){lambda*=radians$1,phi*=radians$1;var cosPhi=cos(phi);centroidPointCartesian(cosPhi*cos(lambda),cosPhi*sin(lambda),sin(phi))}function centroidPointCartesian(x,y,z){++W0;X0+=(x-X0)/W0;Y0+=(y-Y0)/W0;Z0+=(z-Z0)/W0}function centroidLineStart(){centroidStream.point=centroidLinePointFirst}function centroidLinePointFirst(lambda,phi){lambda*=radians$1,phi*=radians$1;var cosPhi=cos(phi);x0=cosPhi*cos(lambda);y0=cosPhi*sin(lambda);z0=sin(phi);centroidStream.point=centroidLinePoint;centroidPointCartesian(x0,y0,z0)}function centroidLinePoint(lambda,phi){lambda*=radians$1,phi*=radians$1;var cosPhi=cos(phi),x=cosPhi*cos(lambda),y=cosPhi*sin(lambda),z=sin(phi),w=atan2(sqrt((w=y0*z-z0*y)*w+(w=z0*x-x0*z)*w+(w=x0*y-y0*x)*w),x0*x+y0*y+z0*z);W1+=w;X1+=w*(x0+(x0=x));Y1+=w*(y0+(y0=y));Z1+=w*(z0+(z0=z));centroidPointCartesian(x0,y0,z0)}function centroidLineEnd(){centroidStream.point=centroidPoint}function centroidRingStart(){centroidStream.point=centroidRingPointFirst}function centroidRingEnd(){centroidRingPoint(lambda00,phi00);centroidStream.point=centroidPoint}function centroidRingPointFirst(lambda,phi){lambda00=lambda,phi00=phi;lambda*=radians$1,phi*=radians$1;centroidStream.point=centroidRingPoint;var cosPhi=cos(phi);x0=cosPhi*cos(lambda);y0=cosPhi*sin(lambda);z0=sin(phi);centroidPointCartesian(x0,y0,z0)}function centroidRingPoint(lambda,phi){lambda*=radians$1,phi*=radians$1;var cosPhi=cos(phi),x=cosPhi*cos(lambda),y=cosPhi*sin(lambda),z=sin(phi),cx=y0*z-z0*y,cy=z0*x-x0*z,cz=x0*y-y0*x,m=hypot(cx,cy,cz),w=asin(m),v=m&&-w/m;X2.add(v*cx);Y2.add(v*cy);Z2.add(v*cz);W1+=w;X1+=w*(x0+(x0=x));Y1+=w*(y0+(y0=y));Z1+=w*(z0+(z0=z));centroidPointCartesian(x0,y0,z0)}function centroid(object){W0=W1=X0=Y0=Z0=X1=Y1=Z1=0;X2=new Adder;Y2=new Adder;Z2=new Adder;geoStream(object,centroidStream);var x=+X2,y=+Y2,z=+Z2,m=hypot(x,y,z);if(m<epsilon2){x=X1,y=Y1,z=Z1;if(W1<epsilon)x=X0,y=Y0,z=Z0;m=hypot(x,y,z);if(m<epsilon2)return[NaN,NaN]}return[atan2(y,x)*degrees$1,asin(z/m)*degrees$1]}function geoMethod(methodName,globalMethod){return function(projection,geojson,group){if(projection){const p=getScale(projection,(group||this).context);return p&&p.path[methodName](geojson)}else{return globalMethod(geojson)}}}const geoArea=geoMethod("area",area);const geoBounds=geoMethod("bounds",bounds);const geoCentroid=geoMethod("centroid",centroid);function geoScale(projection,group){const p=getScale(projection,(group||this).context);return p&&p.scale()}function inScope(item){const group=this.context.group;let value=false;if(group)while(item){if(item===group){value=true;break}item=item.mark.group}return value}function log(df,method,args){try{df[method].apply(df,["EXPRESSION"].concat([].slice.call(args)))}catch(err){df.warn(err)}return args[args.length-1]}function warn(){return log(this.context.dataflow,"warn",arguments)}function info(){return log(this.context.dataflow,"info",arguments)}function debug(){return log(this.context.dataflow,"debug",arguments)}function define(constructor,factory,prototype){constructor.prototype=factory.prototype=prototype;prototype.constructor=constructor}function extend(parent,definition){var prototype=Object.create(parent.prototype);for(var key in definition)prototype[key]=definition[key];return prototype}function Color(){}var darker=.7;var brighter=1/darker;var reI="\\s*([+-]?\\d+)\\s*",reN="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",reP="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",reHex=/^#([0-9a-f]{3,8})$/,reRgbInteger=new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`),reRgbPercent=new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`),reRgbaInteger=new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`),reRgbaPercent=new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`),reHslPercent=new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`),reHslaPercent=new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);var named={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};define(Color,color,{copy(channels){return Object.assign(new this.constructor,this,channels)},displayable(){return this.rgb().displayable()},hex:color_formatHex,formatHex:color_formatHex,formatHex8:color_formatHex8,formatHsl:color_formatHsl,formatRgb:color_formatRgb,toString:color_formatRgb});function color_formatHex(){return this.rgb().formatHex()}function color_formatHex8(){return this.rgb().formatHex8()}function color_formatHsl(){return hslConvert(this).formatHsl()}function color_formatRgb(){return this.rgb().formatRgb()}function color(format){var m,l;format=(format+"").trim().toLowerCase();return(m=reHex.exec(format))?(l=m[1].length,m=parseInt(m[1],16),l===6?rgbn(m):l===3?new Rgb(m>>8&15|m>>4&240,m>>4&15|m&240,(m&15)<<4|m&15,1):l===8?rgba(m>>24&255,m>>16&255,m>>8&255,(m&255)/255):l===4?rgba(m>>12&15|m>>8&240,m>>8&15|m>>4&240,m>>4&15|m&240,((m&15)<<4|m&15)/255):null):(m=reRgbInteger.exec(format))?new Rgb(m[1],m[2],m[3],1):(m=reRgbPercent.exec(format))?new Rgb(m[1]*255/100,m[2]*255/100,m[3]*255/100,1):(m=reRgbaInteger.exec(format))?rgba(m[1],m[2],m[3],m[4]):(m=reRgbaPercent.exec(format))?rgba(m[1]*255/100,m[2]*255/100,m[3]*255/100,m[4]):(m=reHslPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,1):(m=reHslaPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,m[4]):named.hasOwnProperty(format)?rgbn(named[format]):format==="transparent"?new Rgb(NaN,NaN,NaN,0):null}function rgbn(n){return new Rgb(n>>16&255,n>>8&255,n&255,1)}function rgba(r,g,b,a){if(a<=0)r=g=b=NaN;return new Rgb(r,g,b,a)}function rgbConvert(o){if(!(o instanceof Color))o=color(o);if(!o)return new Rgb;o=o.rgb();return new Rgb(o.r,o.g,o.b,o.opacity)}function rgb(r,g,b,opacity){return arguments.length===1?rgbConvert(r):new Rgb(r,g,b,opacity==null?1:opacity)}function Rgb(r,g,b,opacity){this.r=+r;this.g=+g;this.b=+b;this.opacity=+opacity}define(Rgb,rgb,extend(Color,{brighter(k){k=k==null?brighter:Math.pow(brighter,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},darker(k){k=k==null?darker:Math.pow(darker,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},rgb(){return this},clamp(){return new Rgb(clampi(this.r),clampi(this.g),clampi(this.b),clampa(this.opacity))},displayable(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:rgb_formatHex,formatHex:rgb_formatHex,formatHex8:rgb_formatHex8,formatRgb:rgb_formatRgb,toString:rgb_formatRgb}));function rgb_formatHex(){return`#${hex(this.r)}${hex(this.g)}${hex(this.b)}`}function rgb_formatHex8(){return`#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity)?1:this.opacity)*255)}`}function rgb_formatRgb(){const a=clampa(this.opacity);return`${a===1?"rgb(":"rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a===1?")":`, ${a})`}`}function clampa(opacity){return isNaN(opacity)?1:Math.max(0,Math.min(1,opacity))}function clampi(value){return Math.max(0,Math.min(255,Math.round(value)||0))}function hex(value){value=clampi(value);return(value<16?"0":"")+value.toString(16)}function hsla(h,s,l,a){if(a<=0)h=s=l=NaN;else if(l<=0||l>=1)h=s=NaN;else if(s<=0)h=NaN;return new Hsl(h,s,l,a)}function hslConvert(o){if(o instanceof Hsl)return new Hsl(o.h,o.s,o.l,o.opacity);if(!(o instanceof Color))o=color(o);if(!o)return new Hsl;if(o instanceof Hsl)return o;o=o.rgb();var r=o.r/255,g=o.g/255,b=o.b/255,min=Math.min(r,g,b),max=Math.max(r,g,b),h=NaN,s=max-min,l=(max+min)/2;if(s){if(r===max)h=(g-b)/s+(g<b)*6;else if(g===max)h=(b-r)/s+2;else h=(r-g)/s+4;s/=l<.5?max+min:2-max-min;h*=60}else{s=l>0&&l<1?0:h}return new Hsl(h,s,l,o.opacity)}function hsl(h,s,l,opacity){return arguments.length===1?hslConvert(h):new Hsl(h,s,l,opacity==null?1:opacity)}function Hsl(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Hsl,hsl,extend(Color,{brighter(k){k=k==null?brighter:Math.pow(brighter,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},darker(k){k=k==null?darker:Math.pow(darker,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},rgb(){var h=this.h%360+(this.h<0)*360,s=isNaN(h)||isNaN(this.s)?0:this.s,l=this.l,m2=l+(l<.5?l:1-l)*s,m1=2*l-m2;return new Rgb(hsl2rgb(h>=240?h-240:h+120,m1,m2),hsl2rgb(h,m1,m2),hsl2rgb(h<120?h+240:h-120,m1,m2),this.opacity)},clamp(){return new Hsl(clamph(this.h),clampt(this.s),clampt(this.l),clampa(this.opacity))},displayable(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl(){const a=clampa(this.opacity);return`${a===1?"hsl(":"hsla("}${clamph(this.h)}, ${clampt(this.s)*100}%, ${clampt(this.l)*100}%${a===1?")":`, ${a})`}`}}));function clamph(value){value=(value||0)%360;return value<0?value+360:value}function clampt(value){return Math.max(0,Math.min(1,value||0))}function hsl2rgb(h,m1,m2){return(h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1)*255}const radians=Math.PI/180;const degrees=180/Math.PI;const K=18,Xn=.96422,Yn=1,Zn=.82521,t0=4/29,t1=6/29,t2=3*t1*t1,t3=t1*t1*t1;function labConvert(o){if(o instanceof Lab)return new Lab(o.l,o.a,o.b,o.opacity);if(o instanceof Hcl)return hcl2lab(o);if(!(o instanceof Rgb))o=rgbConvert(o);var r=rgb2lrgb(o.r),g=rgb2lrgb(o.g),b=rgb2lrgb(o.b),y=xyz2lab((.2225045*r+.7168786*g+.0606169*b)/Yn),x,z;if(r===g&&g===b)x=z=y;else{x=xyz2lab((.4360747*r+.3850649*g+.1430804*b)/Xn);z=xyz2lab((.0139322*r+.0971045*g+.7141733*b)/Zn)}return new Lab(116*y-16,500*(x-y),200*(y-z),o.opacity)}function lab(l,a,b,opacity){return arguments.length===1?labConvert(l):new Lab(l,a,b,opacity==null?1:opacity)}function Lab(l,a,b,opacity){this.l=+l;this.a=+a;this.b=+b;this.opacity=+opacity}define(Lab,lab,extend(Color,{brighter(k){return new Lab(this.l+K*(k==null?1:k),this.a,this.b,this.opacity)},darker(k){return new Lab(this.l-K*(k==null?1:k),this.a,this.b,this.opacity)},rgb(){var y=(this.l+16)/116,x=isNaN(this.a)?y:y+this.a/500,z=isNaN(this.b)?y:y-this.b/200;x=Xn*lab2xyz(x);y=Yn*lab2xyz(y);z=Zn*lab2xyz(z);return new Rgb(lrgb2rgb(3.1338561*x-1.6168667*y-.4906146*z),lrgb2rgb(-.9787684*x+1.9161415*y+.033454*z),lrgb2rgb(.0719453*x-.2289914*y+1.4052427*z),this.opacity)}}));function xyz2lab(t){return t>t3?Math.pow(t,1/3):t/t2+t0}function lab2xyz(t){return t>t1?t*t*t:t2*(t-t0)}function lrgb2rgb(x){return 255*(x<=.0031308?12.92*x:1.055*Math.pow(x,1/2.4)-.055)}function rgb2lrgb(x){return(x/=255)<=.04045?x/12.92:Math.pow((x+.055)/1.055,2.4)}function hclConvert(o){if(o instanceof Hcl)return new Hcl(o.h,o.c,o.l,o.opacity);if(!(o instanceof Lab))o=labConvert(o);if(o.a===0&&o.b===0)return new Hcl(NaN,0<o.l&&o.l<100?0:NaN,o.l,o.opacity);var h=Math.atan2(o.b,o.a)*degrees;return new Hcl(h<0?h+360:h,Math.sqrt(o.a*o.a+o.b*o.b),o.l,o.opacity)}function hcl(h,c,l,opacity){return arguments.length===1?hclConvert(h):new Hcl(h,c,l,opacity==null?1:opacity)}function Hcl(h,c,l,opacity){this.h=+h;this.c=+c;this.l=+l;this.opacity=+opacity}function hcl2lab(o){if(isNaN(o.h))return new Lab(o.l,0,0,o.opacity);var h=o.h*radians;return new Lab(o.l,Math.cos(h)*o.c,Math.sin(h)*o.c,o.opacity)}define(Hcl,hcl,extend(Color,{brighter(k){return new Hcl(this.h,this.c,this.l+K*(k==null?1:k),this.opacity)},darker(k){return new Hcl(this.h,this.c,this.l-K*(k==null?1:k),this.opacity)},rgb(){return hcl2lab(this).rgb()}}));function channel_luminance_value(channelValue){const val=channelValue/255;if(val<=.03928){return val/12.92}return Math.pow((val+.055)/1.055,2.4)}function luminance(color){const c=rgb(color),r=channel_luminance_value(c.r),g=channel_luminance_value(c.g),b=channel_luminance_value(c.b);return.2126*r+.7152*g+.0722*b}function contrast(color1,color2){const lum1=luminance(color1),lum2=luminance(color2),lumL=Math.max(lum1,lum2),lumD=Math.min(lum1,lum2);return(lumL+.05)/(lumD+.05)}function merge(){const args=[].slice.call(arguments);args.unshift({});return vegaUtil.extend(...args)}function equal(a,b){return a===b||a!==a&&b!==b?true:vegaUtil.isArray(a)?vegaUtil.isArray(b)&&a.length===b.length?equalArray(a,b):false:vegaUtil.isObject(a)&&vegaUtil.isObject(b)?equalObject(a,b):false}function equalArray(a,b){for(let i=0,n=a.length;i<n;++i){if(!equal(a[i],b[i]))return false}return true}function equalObject(a,b){for(const key in a){if(!equal(a[key],b[key]))return false}return true}function removePredicate(props){return _=>equalObject(props,_)}function modify(name,insert,remove,toggle,modify,values){const df=this.context.dataflow,data=this.context.data[name],input=data.input,stamp=df.stamp();let changes=data.changes,predicate,key;if(df._trigger===false||!(input.value.length||insert||toggle)){return 0}if(!changes||changes.stamp<stamp){data.changes=changes=df.changeset();changes.stamp=stamp;df.runAfter(()=>{data.modified=true;df.pulse(input,changes).run()},true,1)}if(remove){predicate=remove===true?vegaUtil.truthy:vegaUtil.isArray(remove)||vegaDataflow.isTuple(remove)?remove:removePredicate(remove);changes.remove(predicate)}if(insert){changes.insert(insert)}if(toggle){predicate=removePredicate(toggle);if(input.value.some(predicate)){changes.remove(predicate)}else{changes.insert(toggle)}}if(modify){for(key in values){changes.modify(modify,key,values[key])}}return 1}function pinchDistance(event){const t=event.touches,dx=t[0].clientX-t[1].clientX,dy=t[0].clientY-t[1].clientY;return Math.hypot(dx,dy)}function pinchAngle(event){const t=event.touches;return Math.atan2(t[0].clientY-t[1].clientY,t[0].clientX-t[1].clientX)}const accessors={};function pluck(data,name){const accessor=accessors[name]||(accessors[name]=vegaUtil.field(name));return vegaUtil.isArray(data)?data.map(accessor):accessor(data)}function array(seq){return vegaUtil.isArray(seq)||ArrayBuffer.isView(seq)?seq:null}function sequence(seq){return array(seq)||(vegaUtil.isString(seq)?seq:null)}function join(seq){for(var _len=arguments.length,args=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}return array(seq).join(...args)}function indexof(seq){for(var _len2=arguments.length,args=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++){args[_key2-1]=arguments[_key2]}return sequence(seq).indexOf(...args)}function lastindexof(seq){for(var _len3=arguments.length,args=new Array(_len3>1?_len3-1:0),_key3=1;_key3<_len3;_key3++){args[_key3-1]=arguments[_key3]}return sequence(seq).lastIndexOf(...args)}function slice(seq){for(var _len4=arguments.length,args=new Array(_len4>1?_len4-1:0),_key4=1;_key4<_len4;_key4++){args[_key4-1]=arguments[_key4]}return sequence(seq).slice(...args)}function replace(str,pattern,repl){if(vegaUtil.isFunction(repl))vegaUtil.error("Function argument passed to replace.");if(!vegaUtil.isString(pattern)&&!vegaUtil.isRegExp(pattern))vegaUtil.error("Please pass a string or RegExp argument to replace.");return String(str).replace(pattern,repl)}function reverse(seq){return array(seq).slice().reverse()}function sort(seq){return array(seq).slice().sort(vegaUtil.ascending)}function bandspace(count,paddingInner,paddingOuter){return vegaScale.bandSpace(count||0,paddingInner||0,paddingOuter||0)}function bandwidth(name,group){const s=getScale(name,(group||this).context);return s&&s.bandwidth?s.bandwidth():0}function copy(name,group){const s=getScale(name,(group||this).context);return s?s.copy():undefined}function domain(name,group){const s=getScale(name,(group||this).context);return s?s.domain():[]}function invert(name,range,group){const s=getScale(name,(group||this).context);return!s?undefined:vegaUtil.isArray(range)?(s.invertRange||s.invert)(range):(s.invert||s.invertExtent)(range)}function range(name,group){const s=getScale(name,(group||this).context);return s&&s.range?s.range():[]}function scale(name,value,group){const s=getScale(name,(group||this).context);return s?s(value):undefined}function scaleGradient(scale,p0,p1,count,group){scale=getScale(scale,(group||this).context);const gradient=vegaScenegraph.Gradient(p0,p1);let stops=scale.domain(),min=stops[0],max=vegaUtil.peek(stops),fraction=vegaUtil.identity;if(!(max-min)){scale=(scale.interpolator?vegaScale.scale("sequential")().interpolator(scale.interpolator()):vegaScale.scale("linear")().interpolate(scale.interpolate()).range(scale.range())).domain([min=0,max=1])}else{fraction=vegaScale.scaleFraction(scale,min,max)}if(scale.ticks){stops=scale.ticks(+count||15);if(min!==stops[0])stops.unshift(min);if(max!==vegaUtil.peek(stops))stops.push(max)}stops.forEach(_=>gradient.stop(fraction(_),scale(_)));return gradient}function geoShape(projection,geojson,group){const p=getScale(projection,(group||this).context);return function(context){return p?p.path.context(context)(geojson):""}}function pathShape(path){let p=null;return function(context){return context?vegaScenegraph.pathRender(context,p=p||vegaScenegraph.pathParse(path)):path}}const datum=d=>d.data;function treeNodes(name,context){const tree=data.call(context,name);return tree.root&&tree.root.lookup||{}}function treePath(name,source,target){const nodes=treeNodes(name,this),s=nodes[source],t=nodes[target];return s&&t?s.path(t).map(datum):undefined}function treeAncestors(name,node){const n=treeNodes(name,this)[node];return n?n.ancestors().map(datum):undefined}const _window=()=>typeof window!=="undefined"&&window||null;function screen(){const w=_window();return w?w.screen:{}}function windowSize(){const w=_window();return w?[w.innerWidth,w.innerHeight]:[undefined,undefined]}function containerSize(){const view=this.context.dataflow,el=view.container&&view.container();return el?[el.clientWidth,el.clientHeight]:[undefined,undefined]}function intersect(b,opt,group){if(!b)return[];const[u,v]=b,box=(new vegaScenegraph.Bounds).set(u[0],u[1],v[0],v[1]),scene=group||this.context.dataflow.scenegraph().root;return vegaScenegraph.intersect(scene,box,filter(opt))}function filter(opt){let p=null;if(opt){const types=vegaUtil.array(opt.marktype),names=vegaUtil.array(opt.markname);p=_=>(!types.length||types.some(t=>_.marktype===t))&&(!names.length||names.some(s=>_.name===s))}return p}function lassoAppend(lasso,x,y){let minDist=arguments.length>3&&arguments[3]!==undefined?arguments[3]:5;lasso=vegaUtil.array(lasso);const last=lasso[lasso.length-1];return last===undefined||Math.hypot(last[0]-x,last[1]-y)>minDist?[...lasso,[x,y]]:lasso}function lassoPath(lasso){return vegaUtil.array(lasso).reduce((svg,_ref,i)=>{let[x,y]=_ref;return svg+=i==0?`M ${x},${y} `:i===lasso.length-1?" Z":`L ${x},${y} `},"")}function intersectLasso(markname,pixelLasso,unit){const{x:x,y:y,mark:mark}=unit;const bb=(new vegaScenegraph.Bounds).set(Number.MAX_SAFE_INTEGER,Number.MAX_SAFE_INTEGER,Number.MIN_SAFE_INTEGER,Number.MIN_SAFE_INTEGER);for(const[px,py]of pixelLasso){if(px<bb.x1)bb.x1=px;if(px>bb.x2)bb.x2=px;if(py<bb.y1)bb.y1=py;if(py>bb.y2)bb.y2=py}bb.translate(x,y);const intersection=intersect([[bb.x1,bb.y1],[bb.x2,bb.y2]],markname,mark);return intersection.filter(tuple=>pointInPolygon(tuple.x,tuple.y,pixelLasso))}function pointInPolygon(testx,testy,polygon){let intersections=0;for(let i=0,j=polygon.length-1;i<polygon.length;j=i++){const[prevX,prevY]=polygon[j];const[x,y]=polygon[i];if(y>testy!=prevY>testy&&testx<(prevX-x)*(testy-y)/(prevY-y)+x){intersections++}}return intersections&1}const functionContext={random(){return vegaStatistics.random()},cumulativeNormal:vegaStatistics.cumulativeNormal,cumulativeLogNormal:vegaStatistics.cumulativeLogNormal,cumulativeUniform:vegaStatistics.cumulativeUniform,densityNormal:vegaStatistics.densityNormal,densityLogNormal:vegaStatistics.densityLogNormal,densityUniform:vegaStatistics.densityUniform,quantileNormal:vegaStatistics.quantileNormal,quantileLogNormal:vegaStatistics.quantileLogNormal,quantileUniform:vegaStatistics.quantileUniform,sampleNormal:vegaStatistics.sampleNormal,sampleLogNormal:vegaStatistics.sampleLogNormal,sampleUniform:vegaStatistics.sampleUniform,isArray:vegaUtil.isArray,isBoolean:vegaUtil.isBoolean,isDate:vegaUtil.isDate,isDefined(_){return _!==undefined},isNumber:vegaUtil.isNumber,isObject:vegaUtil.isObject,isRegExp:vegaUtil.isRegExp,isString:vegaUtil.isString,isTuple:vegaDataflow.isTuple,isValid(_){return _!=null&&_===_},toBoolean:vegaUtil.toBoolean,toDate(_){return vegaUtil.toDate(_)},toNumber:vegaUtil.toNumber,toString:vegaUtil.toString,indexof:indexof,join:join,lastindexof:lastindexof,replace:replace,reverse:reverse,sort:sort,slice:slice,flush:vegaUtil.flush,lerp:vegaUtil.lerp,merge:merge,pad:vegaUtil.pad,peek:vegaUtil.peek,pluck:pluck,span:vegaUtil.span,inrange:vegaUtil.inrange,truncate:vegaUtil.truncate,rgb:rgb,lab:lab,hcl:hcl,hsl:hsl,luminance:luminance,contrast:contrast,sequence:range$2,format:format,utcFormat:utcFormat,utcParse:utcParse,utcOffset:vegaTime.utcOffset,utcSequence:vegaTime.utcSequence,timeFormat:timeFormat,timeParse:timeParse,timeOffset:vegaTime.timeOffset,timeSequence:vegaTime.timeSequence,timeUnitSpecifier:vegaTime.timeUnitSpecifier,monthFormat:monthFormat,monthAbbrevFormat:monthAbbrevFormat,dayFormat:dayFormat,dayAbbrevFormat:dayAbbrevFormat,quarter:vegaUtil.quarter,utcquarter:vegaUtil.utcquarter,week:vegaTime.week,utcweek:vegaTime.utcweek,dayofyear:vegaTime.dayofyear,utcdayofyear:vegaTime.utcdayofyear,warn:warn,info:info,debug:debug,extent(_){return vegaUtil.extent(_)},inScope:inScope,intersect:intersect,clampRange:vegaUtil.clampRange,pinchDistance:pinchDistance,pinchAngle:pinchAngle,screen:screen,containerSize:containerSize,windowSize:windowSize,bandspace:bandspace,setdata:setdata,pathShape:pathShape,panLinear:vegaUtil.panLinear,panLog:vegaUtil.panLog,panPow:vegaUtil.panPow,panSymlog:vegaUtil.panSymlog,zoomLinear:vegaUtil.zoomLinear,zoomLog:vegaUtil.zoomLog,zoomPow:vegaUtil.zoomPow,zoomSymlog:vegaUtil.zoomSymlog,encode:encode,modify:modify,lassoAppend:lassoAppend,lassoPath:lassoPath,intersectLasso:intersectLasso};const eventFunctions=["view","item","group","xy","x","y"],eventPrefix="event.vega.",thisPrefix="this.",astVisitors={};const codegenParams={forbidden:["_"],allowed:["datum","event","item"],fieldvar:"datum",globalvar:id=>`_[${vegaUtil.stringValue(SignalPrefix+id)}]`,functions:buildFunctions,constants:vegaExpression.constants,visitors:astVisitors};const codeGenerator=vegaExpression.codegenExpression(codegenParams);function buildFunctions(codegen){const fn=vegaExpression.functions(codegen);eventFunctions.forEach(name=>fn[name]=eventPrefix+name);for(const name in functionContext){fn[name]=thisPrefix+name}vegaUtil.extend(fn,internalScaleFunctions(codegen,functionContext,astVisitors));return fn}function expressionFunction(name,fn,visitor){if(arguments.length===1){return functionContext[name]}functionContext[name]=fn;if(visitor)astVisitors[name]=visitor;if(codeGenerator)codeGenerator.functions[name]=thisPrefix+name;return this}expressionFunction("bandwidth",bandwidth,scaleVisitor);expressionFunction("copy",copy,scaleVisitor);expressionFunction("domain",domain,scaleVisitor);expressionFunction("range",range,scaleVisitor);expressionFunction("invert",invert,scaleVisitor);expressionFunction("scale",scale,scaleVisitor);expressionFunction("gradient",scaleGradient,scaleVisitor);expressionFunction("geoArea",geoArea,scaleVisitor);expressionFunction("geoBounds",geoBounds,scaleVisitor);expressionFunction("geoCentroid",geoCentroid,scaleVisitor);expressionFunction("geoShape",geoShape,scaleVisitor);expressionFunction("geoScale",geoScale,scaleVisitor);expressionFunction("indata",indata,indataVisitor);expressionFunction("data",data,dataVisitor);expressionFunction("treePath",treePath,dataVisitor);expressionFunction("treeAncestors",treeAncestors,dataVisitor);expressionFunction("vlSelectionTest",vegaSelections.selectionTest,vegaSelections.selectionVisitor);expressionFunction("vlSelectionIdTest",vegaSelections.selectionIdTest,vegaSelections.selectionVisitor);expressionFunction("vlSelectionResolve",vegaSelections.selectionResolve,vegaSelections.selectionVisitor);expressionFunction("vlSelectionTuples",vegaSelections.selectionTuples);function parser(expr,scope){const params={};let ast;try{expr=vegaUtil.isString(expr)?expr:vegaUtil.stringValue(expr)+"";ast=vegaExpression.parseExpression(expr)}catch(err){vegaUtil.error("Expression parse error: "+expr)}ast.visit(node=>{if(node.type!==vegaExpression.CallExpression)return;const name=node.callee.name,visit=codegenParams.visitors[name];if(visit)visit(name,node.arguments,scope,params)});const gen=codeGenerator(ast);gen.globals.forEach(name=>{const signalName=SignalPrefix+name;if(!vegaUtil.hasOwnProperty(params,signalName)&&scope.getSignal(name)){params[signalName]=scope.signalRef(name)}});return{$expr:vegaUtil.extend({code:gen.code},scope.options.ast?{ast:ast}:null),$fields:gen.fields,$params:params}}exports.DataPrefix=DataPrefix;exports.IndexPrefix=IndexPrefix;exports.ScalePrefix=ScalePrefix;exports.SignalPrefix=SignalPrefix;exports.bandspace=bandspace;exports.bandwidth=bandwidth;exports.codeGenerator=codeGenerator;exports.codegenParams=codegenParams;exports.containerSize=containerSize;exports.contrast=contrast;exports.copy=copy;exports.data=data;exports.dataVisitor=dataVisitor;exports.dayAbbrevFormat=dayAbbrevFormat;exports.dayFormat=dayFormat;exports.debug=debug;exports.domain=domain;exports.encode=encode;exports.expressionFunction=expressionFunction;exports.format=format;exports.functionContext=functionContext;exports.geoArea=geoArea;exports.geoBounds=geoBounds;exports.geoCentroid=geoCentroid;exports.geoScale=geoScale;exports.geoShape=geoShape;exports.inScope=inScope;exports.indata=indata;exports.indataVisitor=indataVisitor;exports.indexof=indexof;exports.info=info;exports.invert=invert;exports.join=join;exports.lastindexof=lastindexof;exports.luminance=luminance;exports.merge=merge;exports.modify=modify;exports.monthAbbrevFormat=monthAbbrevFormat;exports.monthFormat=monthFormat;exports.parseExpression=parser;exports.pathShape=pathShape;exports.pinchAngle=pinchAngle;exports.pinchDistance=pinchDistance;exports.pluck=pluck;exports.range=range;exports.replace=replace;exports.reverse=reverse;exports.scale=scale;exports.scaleGradient=scaleGradient;exports.scaleVisitor=scaleVisitor;exports.screen=screen;exports.setdata=setdata;exports.slice=slice;exports.sort=sort;exports.timeFormat=timeFormat;exports.timeParse=timeParse;exports.treeAncestors=treeAncestors;exports.treePath=treePath;exports.utcFormat=utcFormat;exports.utcParse=utcParse;exports.warn=warn;exports.windowSize=windowSize}))},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(62)):undefined})(this,(function(exports,vegaUtil){"use strict";const RawCode="RawCode";const Literal="Literal";const Property="Property";const Identifier="Identifier";const ArrayExpression="ArrayExpression";const BinaryExpression="BinaryExpression";const CallExpression="CallExpression";const ConditionalExpression="ConditionalExpression";const LogicalExpression="LogicalExpression";const MemberExpression="MemberExpression";const ObjectExpression="ObjectExpression";const UnaryExpression="UnaryExpression";function ASTNode(type){this.type=type}ASTNode.prototype.visit=function(visitor){let c,i,n;if(visitor(this))return 1;for(c=children(this),i=0,n=c.length;i<n;++i){if(c[i].visit(visitor))return 1}};function children(node){switch(node.type){case ArrayExpression:return node.elements;case BinaryExpression:case LogicalExpression:return[node.left,node.right];case CallExpression:return[node.callee].concat(node.arguments);case ConditionalExpression:return[node.test,node.consequent,node.alternate];case MemberExpression:return[node.object,node.property];case ObjectExpression:return node.properties;case Property:return[node.key,node.value];case UnaryExpression:return[node.argument];case Identifier:case Literal:case RawCode:default:return[]}}var TokenName,source,index,length,lookahead;var TokenBooleanLiteral=1,TokenEOF=2,TokenIdentifier=3,TokenKeyword=4,TokenNullLiteral=5,TokenNumericLiteral=6,TokenPunctuator=7,TokenStringLiteral=8,TokenRegularExpression=9;TokenName={};TokenName[TokenBooleanLiteral]="Boolean";TokenName[TokenEOF]="<end>";TokenName[TokenIdentifier]="Identifier";TokenName[TokenKeyword]="Keyword";TokenName[TokenNullLiteral]="Null";TokenName[TokenNumericLiteral]="Numeric";TokenName[TokenPunctuator]="Punctuator";TokenName[TokenStringLiteral]="String";TokenName[TokenRegularExpression]="RegularExpression";var SyntaxArrayExpression="ArrayExpression",SyntaxBinaryExpression="BinaryExpression",SyntaxCallExpression="CallExpression",SyntaxConditionalExpression="ConditionalExpression",SyntaxIdentifier="Identifier",SyntaxLiteral="Literal",SyntaxLogicalExpression="LogicalExpression",SyntaxMemberExpression="MemberExpression",SyntaxObjectExpression="ObjectExpression",SyntaxProperty="Property",SyntaxUnaryExpression="UnaryExpression";var MessageUnexpectedToken="Unexpected token %0",MessageUnexpectedNumber="Unexpected number",MessageUnexpectedString="Unexpected string",MessageUnexpectedIdentifier="Unexpected identifier",MessageUnexpectedReserved="Unexpected reserved word",MessageUnexpectedEOS="Unexpected end of input",MessageInvalidRegExp="Invalid regular expression",MessageUnterminatedRegExp="Invalid regular expression: missing /",MessageStrictOctalLiteral="Octal literals are not allowed in strict mode.",MessageStrictDuplicateProperty="Duplicate data property in object literal not allowed in strict mode";var ILLEGAL="ILLEGAL",DISABLED="Disabled.";var RegexNonAsciiIdentifierStart=new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0620-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0800-\\u0815\\u081A\\u0824\\u0828\\u0840-\\u0858\\u08A0-\\u08B2\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971-\\u0980\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC-\\u0EDF\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1877\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1AA7\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BBA-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1CE9-\\u1CEC\\u1CEE-\\u1CF1\\u1CF5\\u1CF6\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u209C\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CEE\\u2CF2\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2E2F\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA66E\\uA67F-\\uA69D\\uA6A0-\\uA6EF\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uA9CF\\uA9E0-\\uA9E4\\uA9E6-\\uA9EF\\uA9FA-\\uA9FE\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA76\\uAA7A\\uAA7E-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEA\\uAAF2-\\uAAF4\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABE2\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]"),RegexNonAsciiIdentifierPart=new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u0800-\\u082D\\u0840-\\u085B\\u08A0-\\u08B2\\u08E4-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B56\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C03\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58\\u0C59\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C81-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D01-\\u0D03\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D57\\u0D60-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D82\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB9\\u0EBB-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1877\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19D9\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1CD0-\\u1CD2\\u1CD4-\\u1CF6\\u1CF8\\u1CF9\\u1D00-\\u1DF5\\u1DFC-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u2E2F\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099\\u309A\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA69D\\uA69F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA827\\uA840-\\uA873\\uA880-\\uA8C4\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA900-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2D\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]");function assert(condition,message){if(!condition){throw new Error("ASSERT: "+message)}}function isDecimalDigit(ch){return ch>=48&&ch<=57}function isHexDigit(ch){return"0123456789abcdefABCDEF".includes(ch)}function isOctalDigit(ch){return"01234567".includes(ch)}function isWhiteSpace(ch){return ch===32||ch===9||ch===11||ch===12||ch===160||ch>=5760&&[5760,6158,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8239,8287,12288,65279].includes(ch)}function isLineTerminator(ch){return ch===10||ch===13||ch===8232||ch===8233}function isIdentifierStart(ch){return ch===36||ch===95||ch>=65&&ch<=90||ch>=97&&ch<=122||ch===92||ch>=128&&RegexNonAsciiIdentifierStart.test(String.fromCharCode(ch))}function isIdentifierPart(ch){return ch===36||ch===95||ch>=65&&ch<=90||ch>=97&&ch<=122||ch>=48&&ch<=57||ch===92||ch>=128&&RegexNonAsciiIdentifierPart.test(String.fromCharCode(ch))}const keywords={if:1,in:1,do:1,var:1,for:1,new:1,try:1,let:1,this:1,else:1,case:1,void:1,with:1,enum:1,while:1,break:1,catch:1,throw:1,const:1,yield:1,class:1,super:1,return:1,typeof:1,delete:1,switch:1,export:1,import:1,public:1,static:1,default:1,finally:1,extends:1,package:1,private:1,function:1,continue:1,debugger:1,interface:1,protected:1,instanceof:1,implements:1};function skipComment(){while(index<length){const ch=source.charCodeAt(index);if(isWhiteSpace(ch)||isLineTerminator(ch)){++index}else{break}}}function scanHexEscape(prefix){var i,len,ch,code=0;len=prefix==="u"?4:2;for(i=0;i<len;++i){if(index<length&&isHexDigit(source[index])){ch=source[index++];code=code*16+"0123456789abcdef".indexOf(ch.toLowerCase())}else{throwError({},MessageUnexpectedToken,ILLEGAL)}}return String.fromCharCode(code)}function scanUnicodeCodePointEscape(){var ch,code,cu1,cu2;ch=source[index];code=0;if(ch==="}"){throwError({},MessageUnexpectedToken,ILLEGAL)}while(index<length){ch=source[index++];if(!isHexDigit(ch)){break}code=code*16+"0123456789abcdef".indexOf(ch.toLowerCase())}if(code>1114111||ch!=="}"){throwError({},MessageUnexpectedToken,ILLEGAL)}if(code<=65535){return String.fromCharCode(code)}cu1=(code-65536>>10)+55296;cu2=(code-65536&1023)+56320;return String.fromCharCode(cu1,cu2)}function getEscapedIdentifier(){var ch,id;ch=source.charCodeAt(index++);id=String.fromCharCode(ch);if(ch===92){if(source.charCodeAt(index)!==117){throwError({},MessageUnexpectedToken,ILLEGAL)}++index;ch=scanHexEscape("u");if(!ch||ch==="\\"||!isIdentifierStart(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL)}id=ch}while(index<length){ch=source.charCodeAt(index);if(!isIdentifierPart(ch)){break}++index;id+=String.fromCharCode(ch);if(ch===92){id=id.substr(0,id.length-1);if(source.charCodeAt(index)!==117){throwError({},MessageUnexpectedToken,ILLEGAL)}++index;ch=scanHexEscape("u");if(!ch||ch==="\\"||!isIdentifierPart(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL)}id+=ch}}return id}function getIdentifier(){var start,ch;start=index++;while(index<length){ch=source.charCodeAt(index);if(ch===92){index=start;return getEscapedIdentifier()}if(isIdentifierPart(ch)){++index}else{break}}return source.slice(start,index)}function scanIdentifier(){var start,id,type;start=index;id=source.charCodeAt(index)===92?getEscapedIdentifier():getIdentifier();if(id.length===1){type=TokenIdentifier}else if(keywords.hasOwnProperty(id)){type=TokenKeyword}else if(id==="null"){type=TokenNullLiteral}else if(id==="true"||id==="false"){type=TokenBooleanLiteral}else{type=TokenIdentifier}return{type:type,value:id,start:start,end:index}}function scanPunctuator(){var start=index,code=source.charCodeAt(index),code2,ch1=source[index],ch2,ch3,ch4;switch(code){case 46:case 40:case 41:case 59:case 44:case 123:case 125:case 91:case 93:case 58:case 63:case 126:++index;return{type:TokenPunctuator,value:String.fromCharCode(code),start:start,end:index};default:code2=source.charCodeAt(index+1);if(code2===61){switch(code){case 43:case 45:case 47:case 60:case 62:case 94:case 124:case 37:case 38:case 42:index+=2;return{type:TokenPunctuator,value:String.fromCharCode(code)+String.fromCharCode(code2),start:start,end:index};case 33:case 61:index+=2;if(source.charCodeAt(index)===61){++index}return{type:TokenPunctuator,value:source.slice(start,index),start:start,end:index}}}}ch4=source.substr(index,4);if(ch4===">>>="){index+=4;return{type:TokenPunctuator,value:ch4,start:start,end:index}}ch3=ch4.substr(0,3);if(ch3===">>>"||ch3==="<<="||ch3===">>="){index+=3;return{type:TokenPunctuator,value:ch3,start:start,end:index}}ch2=ch3.substr(0,2);if(ch1===ch2[1]&&"+-<>&|".includes(ch1)||ch2==="=>"){index+=2;return{type:TokenPunctuator,value:ch2,start:start,end:index}}if(ch2==="//"){throwError({},MessageUnexpectedToken,ILLEGAL)}if("<>=!+-*%&|^/".includes(ch1)){++index;return{type:TokenPunctuator,value:ch1,start:start,end:index}}throwError({},MessageUnexpectedToken,ILLEGAL)}function scanHexLiteral(start){let number="";while(index<length){if(!isHexDigit(source[index])){break}number+=source[index++]}if(number.length===0){throwError({},MessageUnexpectedToken,ILLEGAL)}if(isIdentifierStart(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenNumericLiteral,value:parseInt("0x"+number,16),start:start,end:index}}function scanOctalLiteral(start){let number="0"+source[index++];while(index<length){if(!isOctalDigit(source[index])){break}number+=source[index++]}if(isIdentifierStart(source.charCodeAt(index))||isDecimalDigit(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenNumericLiteral,value:parseInt(number,8),octal:true,start:start,end:index}}function scanNumericLiteral(){var number,start,ch;ch=source[index];assert(isDecimalDigit(ch.charCodeAt(0))||ch===".","Numeric literal must start with a decimal digit or a decimal point");start=index;number="";if(ch!=="."){number=source[index++];ch=source[index];if(number==="0"){if(ch==="x"||ch==="X"){++index;return scanHexLiteral(start)}if(isOctalDigit(ch)){return scanOctalLiteral(start)}if(ch&&isDecimalDigit(ch.charCodeAt(0))){throwError({},MessageUnexpectedToken,ILLEGAL)}}while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}ch=source[index]}if(ch==="."){number+=source[index++];while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}ch=source[index]}if(ch==="e"||ch==="E"){number+=source[index++];ch=source[index];if(ch==="+"||ch==="-"){number+=source[index++]}if(isDecimalDigit(source.charCodeAt(index))){while(isDecimalDigit(source.charCodeAt(index))){number+=source[index++]}}else{throwError({},MessageUnexpectedToken,ILLEGAL)}}if(isIdentifierStart(source.charCodeAt(index))){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenNumericLiteral,value:parseFloat(number),start:start,end:index}}function scanStringLiteral(){var str="",quote,start,ch,code,octal=false;quote=source[index];assert(quote==="'"||quote==='"',"String literal must starts with a quote");start=index;++index;while(index<length){ch=source[index++];if(ch===quote){quote="";break}else if(ch==="\\"){ch=source[index++];if(!ch||!isLineTerminator(ch.charCodeAt(0))){switch(ch){case"u":case"x":if(source[index]==="{"){++index;str+=scanUnicodeCodePointEscape()}else{str+=scanHexEscape(ch)}break;case"n":str+="\n";break;case"r":str+="\r";break;case"t":str+="\t";break;case"b":str+="\b";break;case"f":str+="\f";break;case"v":str+="\v";break;default:if(isOctalDigit(ch)){code="01234567".indexOf(ch);if(code!==0){octal=true}if(index<length&&isOctalDigit(source[index])){octal=true;code=code*8+"01234567".indexOf(source[index++]);if("0123".includes(ch)&&index<length&&isOctalDigit(source[index])){code=code*8+"01234567".indexOf(source[index++])}}str+=String.fromCharCode(code)}else{str+=ch}break}}else{if(ch==="\r"&&source[index]==="\n"){++index}}}else if(isLineTerminator(ch.charCodeAt(0))){break}else{str+=ch}}if(quote!==""){throwError({},MessageUnexpectedToken,ILLEGAL)}return{type:TokenStringLiteral,value:str,octal:octal,start:start,end:index}}function testRegExp(pattern,flags){let tmp=pattern;if(flags.includes("u")){tmp=tmp.replace(/\\u\{([0-9a-fA-F]+)\}/g,($0,$1)=>{if(parseInt($1,16)<=1114111){return"x"}throwError({},MessageInvalidRegExp)}).replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g,"x")}try{new RegExp(tmp)}catch(e){throwError({},MessageInvalidRegExp)}try{return new RegExp(pattern,flags)}catch(exception){return null}}function scanRegExpBody(){var ch,str,classMarker,terminated,body;ch=source[index];assert(ch==="/","Regular expression literal must start with a slash");str=source[index++];classMarker=false;terminated=false;while(index<length){ch=source[index++];str+=ch;if(ch==="\\"){ch=source[index++];if(isLineTerminator(ch.charCodeAt(0))){throwError({},MessageUnterminatedRegExp)}str+=ch}else if(isLineTerminator(ch.charCodeAt(0))){throwError({},MessageUnterminatedRegExp)}else if(classMarker){if(ch==="]"){classMarker=false}}else{if(ch==="/"){terminated=true;break}else if(ch==="["){classMarker=true}}}if(!terminated){throwError({},MessageUnterminatedRegExp)}body=str.substr(1,str.length-2);return{value:body,literal:str}}function scanRegExpFlags(){var ch,str,flags;str="";flags="";while(index<length){ch=source[index];if(!isIdentifierPart(ch.charCodeAt(0))){break}++index;if(ch==="\\"&&index<length){throwError({},MessageUnexpectedToken,ILLEGAL)}else{flags+=ch;str+=ch}}if(flags.search(/[^gimuy]/g)>=0){throwError({},MessageInvalidRegExp,flags)}return{value:flags,literal:str}}function scanRegExp(){var start,body,flags,value;lookahead=null;skipComment();start=index;body=scanRegExpBody();flags=scanRegExpFlags();value=testRegExp(body.value,flags.value);return{literal:body.literal+flags.literal,value:value,regex:{pattern:body.value,flags:flags.value},start:start,end:index}}function isIdentifierName(token){return token.type===TokenIdentifier||token.type===TokenKeyword||token.type===TokenBooleanLiteral||token.type===TokenNullLiteral}function advance(){skipComment();if(index>=length){return{type:TokenEOF,start:index,end:index}}const ch=source.charCodeAt(index);if(isIdentifierStart(ch)){return scanIdentifier()}if(ch===40||ch===41||ch===59){return scanPunctuator()}if(ch===39||ch===34){return scanStringLiteral()}if(ch===46){if(isDecimalDigit(source.charCodeAt(index+1))){return scanNumericLiteral()}return scanPunctuator()}if(isDecimalDigit(ch)){return scanNumericLiteral()}return scanPunctuator()}function lex(){const token=lookahead;index=token.end;lookahead=advance();index=token.end;return token}function peek(){const pos=index;lookahead=advance();index=pos}function finishArrayExpression(elements){const node=new ASTNode(SyntaxArrayExpression);node.elements=elements;return node}function finishBinaryExpression(operator,left,right){const node=new ASTNode(operator==="||"||operator==="&&"?SyntaxLogicalExpression:SyntaxBinaryExpression);node.operator=operator;node.left=left;node.right=right;return node}function finishCallExpression(callee,args){const node=new ASTNode(SyntaxCallExpression);node.callee=callee;node.arguments=args;return node}function finishConditionalExpression(test,consequent,alternate){const node=new ASTNode(SyntaxConditionalExpression);node.test=test;node.consequent=consequent;node.alternate=alternate;return node}function finishIdentifier(name){const node=new ASTNode(SyntaxIdentifier);node.name=name;return node}function finishLiteral(token){const node=new ASTNode(SyntaxLiteral);node.value=token.value;node.raw=source.slice(token.start,token.end);if(token.regex){if(node.raw==="//"){node.raw="/(?:)/"}node.regex=token.regex}return node}function finishMemberExpression(accessor,object,property){const node=new ASTNode(SyntaxMemberExpression);node.computed=accessor==="[";node.object=object;node.property=property;if(!node.computed)property.member=true;return node}function finishObjectExpression(properties){const node=new ASTNode(SyntaxObjectExpression);node.properties=properties;return node}function finishProperty(kind,key,value){const node=new ASTNode(SyntaxProperty);node.key=key;node.value=value;node.kind=kind;return node}function finishUnaryExpression(operator,argument){const node=new ASTNode(SyntaxUnaryExpression);node.operator=operator;node.argument=argument;node.prefix=true;return node}function throwError(token,messageFormat){var error,args=Array.prototype.slice.call(arguments,2),msg=messageFormat.replace(/%(\d)/g,(whole,index)=>{assert(index<args.length,"Message reference must be in range");return args[index]});error=new Error(msg);error.index=index;error.description=msg;throw error}function throwUnexpected(token){if(token.type===TokenEOF){throwError(token,MessageUnexpectedEOS)}if(token.type===TokenNumericLiteral){throwError(token,MessageUnexpectedNumber)}if(token.type===TokenStringLiteral){throwError(token,MessageUnexpectedString)}if(token.type===TokenIdentifier){throwError(token,MessageUnexpectedIdentifier)}if(token.type===TokenKeyword){throwError(token,MessageUnexpectedReserved)}throwError(token,MessageUnexpectedToken,token.value)}function expect(value){const token=lex();if(token.type!==TokenPunctuator||token.value!==value){throwUnexpected(token)}}function match(value){return lookahead.type===TokenPunctuator&&lookahead.value===value}function matchKeyword(keyword){return lookahead.type===TokenKeyword&&lookahead.value===keyword}function parseArrayInitialiser(){const elements=[];index=lookahead.start;expect("[");while(!match("]")){if(match(",")){lex();elements.push(null)}else{elements.push(parseConditionalExpression());if(!match("]")){expect(",")}}}lex();return finishArrayExpression(elements)}function parseObjectPropertyKey(){index=lookahead.start;const token=lex();if(token.type===TokenStringLiteral||token.type===TokenNumericLiteral){if(token.octal){throwError(token,MessageStrictOctalLiteral)}return finishLiteral(token)}return finishIdentifier(token.value)}function parseObjectProperty(){var token,key,id,value;index=lookahead.start;token=lookahead;if(token.type===TokenIdentifier){id=parseObjectPropertyKey();expect(":");value=parseConditionalExpression();return finishProperty("init",id,value)}if(token.type===TokenEOF||token.type===TokenPunctuator){throwUnexpected(token)}else{key=parseObjectPropertyKey();expect(":");value=parseConditionalExpression();return finishProperty("init",key,value)}}function parseObjectInitialiser(){var properties=[],property,name,key,map={},toString=String;index=lookahead.start;expect("{");while(!match("}")){property=parseObjectProperty();if(property.key.type===SyntaxIdentifier){name=property.key.name}else{name=toString(property.key.value)}key="$"+name;if(Object.prototype.hasOwnProperty.call(map,key)){throwError({},MessageStrictDuplicateProperty)}else{map[key]=true}properties.push(property);if(!match("}")){expect(",")}}expect("}");return finishObjectExpression(properties)}function parseGroupExpression(){expect("(");const expr=parseExpression();expect(")");return expr}const legalKeywords={if:1};function parsePrimaryExpression(){var type,token,expr;if(match("(")){return parseGroupExpression()}if(match("[")){return parseArrayInitialiser()}if(match("{")){return parseObjectInitialiser()}type=lookahead.type;index=lookahead.start;if(type===TokenIdentifier||legalKeywords[lookahead.value]){expr=finishIdentifier(lex().value)}else if(type===TokenStringLiteral||type===TokenNumericLiteral){if(lookahead.octal){throwError(lookahead,MessageStrictOctalLiteral)}expr=finishLiteral(lex())}else if(type===TokenKeyword){throw new Error(DISABLED)}else if(type===TokenBooleanLiteral){token=lex();token.value=token.value==="true";expr=finishLiteral(token)}else if(type===TokenNullLiteral){token=lex();token.value=null;expr=finishLiteral(token)}else if(match("/")||match("/=")){expr=finishLiteral(scanRegExp());peek()}else{throwUnexpected(lex())}return expr}function parseArguments(){const args=[];expect("(");if(!match(")")){while(index<length){args.push(parseConditionalExpression());if(match(")")){break}expect(",")}}expect(")");return args}function parseNonComputedProperty(){index=lookahead.start;const token=lex();if(!isIdentifierName(token)){throwUnexpected(token)}return finishIdentifier(token.value)}function parseNonComputedMember(){expect(".");return parseNonComputedProperty()}function parseComputedMember(){expect("[");const expr=parseExpression();expect("]");return expr}function parseLeftHandSideExpressionAllowCall(){var expr,args,property;expr=parsePrimaryExpression();for(;;){if(match(".")){property=parseNonComputedMember();expr=finishMemberExpression(".",expr,property)}else if(match("(")){args=parseArguments();expr=finishCallExpression(expr,args)}else if(match("[")){property=parseComputedMember();expr=finishMemberExpression("[",expr,property)}else{break}}return expr}function parsePostfixExpression(){const expr=parseLeftHandSideExpressionAllowCall();if(lookahead.type===TokenPunctuator){if(match("++")||match("--")){throw new Error(DISABLED)}}return expr}function parseUnaryExpression(){var token,expr;if(lookahead.type!==TokenPunctuator&&lookahead.type!==TokenKeyword){expr=parsePostfixExpression()}else if(match("++")||match("--")){throw new Error(DISABLED)}else if(match("+")||match("-")||match("~")||match("!")){token=lex();expr=parseUnaryExpression();expr=finishUnaryExpression(token.value,expr)}else if(matchKeyword("delete")||matchKeyword("void")||matchKeyword("typeof")){throw new Error(DISABLED)}else{expr=parsePostfixExpression()}return expr}function binaryPrecedence(token){let prec=0;if(token.type!==TokenPunctuator&&token.type!==TokenKeyword){return 0}switch(token.value){case"||":prec=1;break;case"&&":prec=2;break;case"|":prec=3;break;case"^":prec=4;break;case"&":prec=5;break;case"==":case"!=":case"===":case"!==":prec=6;break;case"<":case">":case"<=":case">=":case"instanceof":case"in":prec=7;break;case"<<":case">>":case">>>":prec=8;break;case"+":case"-":prec=9;break;case"*":case"/":case"%":prec=11;break}return prec}function parseBinaryExpression(){var marker,markers,expr,token,prec,stack,right,operator,left,i;marker=lookahead;left=parseUnaryExpression();token=lookahead;prec=binaryPrecedence(token);if(prec===0){return left}token.prec=prec;lex();markers=[marker,lookahead];right=parseUnaryExpression();stack=[left,token,right];while((prec=binaryPrecedence(lookahead))>0){while(stack.length>2&&prec<=stack[stack.length-2].prec){right=stack.pop();operator=stack.pop().value;left=stack.pop();markers.pop();expr=finishBinaryExpression(operator,left,right);stack.push(expr)}token=lex();token.prec=prec;stack.push(token);markers.push(lookahead);expr=parseUnaryExpression();stack.push(expr)}i=stack.length-1;expr=stack[i];markers.pop();while(i>1){markers.pop();expr=finishBinaryExpression(stack[i-1].value,stack[i-2],expr);i-=2}return expr}function parseConditionalExpression(){var expr,consequent,alternate;expr=parseBinaryExpression();if(match("?")){lex();consequent=parseConditionalExpression();expect(":");alternate=parseConditionalExpression();expr=finishConditionalExpression(expr,consequent,alternate)}return expr}function parseExpression(){const expr=parseConditionalExpression();if(match(",")){throw new Error(DISABLED)}return expr}function parser(code){source=code;index=0;length=source.length;lookahead=null;peek();const expr=parseExpression();if(lookahead.type!==TokenEOF){throw new Error("Unexpect token after expression.")}return expr}var Constants={NaN:"NaN",E:"Math.E",LN2:"Math.LN2",LN10:"Math.LN10",LOG2E:"Math.LOG2E",LOG10E:"Math.LOG10E",PI:"Math.PI",SQRT1_2:"Math.SQRT1_2",SQRT2:"Math.SQRT2",MIN_VALUE:"Number.MIN_VALUE",MAX_VALUE:"Number.MAX_VALUE"};function Functions(codegen){function fncall(name,args,cast,type){let obj=codegen(args[0]);if(cast){obj=cast+"("+obj+")";if(cast.lastIndexOf("new ",0)===0)obj="("+obj+")"}return obj+"."+name+(type<0?"":type===0?"()":"("+args.slice(1).map(codegen).join(",")+")")}function fn(name,cast,type){return args=>fncall(name,args,cast,type)}const DATE="new Date",STRING="String",REGEXP="RegExp";return{isNaN:"Number.isNaN",isFinite:"Number.isFinite",abs:"Math.abs",acos:"Math.acos",asin:"Math.asin",atan:"Math.atan",atan2:"Math.atan2",ceil:"Math.ceil",cos:"Math.cos",exp:"Math.exp",floor:"Math.floor",hypot:"Math.hypot",log:"Math.log",max:"Math.max",min:"Math.min",pow:"Math.pow",random:"Math.random",round:"Math.round",sin:"Math.sin",sqrt:"Math.sqrt",tan:"Math.tan",clamp:function(args){if(args.length<3)vegaUtil.error("Missing arguments to clamp function.");if(args.length>3)vegaUtil.error("Too many arguments to clamp function.");const a=args.map(codegen);return"Math.max("+a[1]+", Math.min("+a[2]+","+a[0]+"))"},now:"Date.now",utc:"Date.UTC",datetime:DATE,date:fn("getDate",DATE,0),day:fn("getDay",DATE,0),year:fn("getFullYear",DATE,0),month:fn("getMonth",DATE,0),hours:fn("getHours",DATE,0),minutes:fn("getMinutes",DATE,0),seconds:fn("getSeconds",DATE,0),milliseconds:fn("getMilliseconds",DATE,0),time:fn("getTime",DATE,0),timezoneoffset:fn("getTimezoneOffset",DATE,0),utcdate:fn("getUTCDate",DATE,0),utcday:fn("getUTCDay",DATE,0),utcyear:fn("getUTCFullYear",DATE,0),utcmonth:fn("getUTCMonth",DATE,0),utchours:fn("getUTCHours",DATE,0),utcminutes:fn("getUTCMinutes",DATE,0),utcseconds:fn("getUTCSeconds",DATE,0),utcmilliseconds:fn("getUTCMilliseconds",DATE,0),length:fn("length",null,-1),parseFloat:"parseFloat",parseInt:"parseInt",upper:fn("toUpperCase",STRING,0),lower:fn("toLowerCase",STRING,0),substring:fn("substring",STRING),split:fn("split",STRING),trim:fn("trim",STRING,0),btoa:"btoa",atob:"atob",regexp:REGEXP,test:fn("test",REGEXP),if:function(args){if(args.length<3)vegaUtil.error("Missing arguments to if function.");if(args.length>3)vegaUtil.error("Too many arguments to if function.");const a=args.map(codegen);return"("+a[0]+"?"+a[1]+":"+a[2]+")"}}}function stripQuotes(s){const n=s&&s.length-1;return n&&(s[0]==='"'&&s[n]==='"'||s[0]==="'"&&s[n]==="'")?s.slice(1,-1):s}function codegen(opt){opt=opt||{};const allowed=opt.allowed?vegaUtil.toSet(opt.allowed):{},forbidden=opt.forbidden?vegaUtil.toSet(opt.forbidden):{},constants=opt.constants||Constants,functions=(opt.functions||Functions)(visit),globalvar=opt.globalvar,fieldvar=opt.fieldvar,outputGlobal=vegaUtil.isFunction(globalvar)?globalvar:id=>`${globalvar}["${id}"]`;let globals={},fields={},memberDepth=0;function visit(ast){if(vegaUtil.isString(ast))return ast;const generator=Generators[ast.type];if(generator==null)vegaUtil.error("Unsupported type: "+ast.type);return generator(ast)}const Generators={Literal:n=>n.raw,Identifier:n=>{const id=n.name;if(memberDepth>0){return id}else if(vegaUtil.hasOwnProperty(forbidden,id)){return vegaUtil.error("Illegal identifier: "+id)}else if(vegaUtil.hasOwnProperty(constants,id)){return constants[id]}else if(vegaUtil.hasOwnProperty(allowed,id)){return id}else{globals[id]=1;return outputGlobal(id)}},MemberExpression:n=>{const d=!n.computed,o=visit(n.object);if(d)memberDepth+=1;const p=visit(n.property);if(o===fieldvar){fields[stripQuotes(p)]=1}if(d)memberDepth-=1;return o+(d?"."+p:"["+p+"]")},CallExpression:n=>{if(n.callee.type!=="Identifier"){vegaUtil.error("Illegal callee type: "+n.callee.type)}const callee=n.callee.name,args=n.arguments,fn=vegaUtil.hasOwnProperty(functions,callee)&&functions[callee];if(!fn)vegaUtil.error("Unrecognized function: "+callee);return vegaUtil.isFunction(fn)?fn(args):fn+"("+args.map(visit).join(",")+")"},ArrayExpression:n=>"["+n.elements.map(visit).join(",")+"]",BinaryExpression:n=>"("+visit(n.left)+" "+n.operator+" "+visit(n.right)+")",UnaryExpression:n=>"("+n.operator+visit(n.argument)+")",ConditionalExpression:n=>"("+visit(n.test)+"?"+visit(n.consequent)+":"+visit(n.alternate)+")",LogicalExpression:n=>"("+visit(n.left)+n.operator+visit(n.right)+")",ObjectExpression:n=>"{"+n.properties.map(visit).join(",")+"}",Property:n=>{memberDepth+=1;const k=visit(n.key);memberDepth-=1;return k+":"+visit(n.value)}};function codegen(ast){const result={code:visit(ast),globals:Object.keys(globals),fields:Object.keys(fields)};globals={};fields={};return result}codegen.functions=functions;codegen.constants=constants;return codegen}exports.ASTNode=ASTNode;exports.ArrayExpression=ArrayExpression;exports.BinaryExpression=BinaryExpression;exports.CallExpression=CallExpression;exports.ConditionalExpression=ConditionalExpression;exports.Identifier=Identifier;exports.Literal=Literal;exports.LogicalExpression=LogicalExpression;exports.MemberExpression=MemberExpression;exports.ObjectExpression=ObjectExpression;exports.Property=Property;exports.RawCode=RawCode;exports.UnaryExpression=UnaryExpression;exports.codegenExpression=codegen;exports.constants=Constants;exports.functions=Functions;exports.parseExpression=parser}))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=void 0;var _moment=_interopRequireDefault(__webpack_require__(58));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread()}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(n);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen)}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&Symbol.iterator in Object(iter))return Array.from(iter)}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr)}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++){arr2[i]=arr[i]}return arr2}var unitsMap={ms:{weight:1,type:"fixed",base:1},s:{weight:2,type:"fixed",base:1e3},m:{weight:3,type:"mixed",base:1e3*60},h:{weight:4,type:"mixed",base:1e3*60*60},d:{weight:5,type:"mixed",base:1e3*60*60*24},w:{weight:6,type:"calendar",base:NaN},M:{weight:7,type:"calendar",base:NaN},y:{weight:9,type:"calendar",base:NaN}};var units=Object.keys(unitsMap).sort((function(a,b){return unitsMap[b].weight-unitsMap[a].weight}));var unitsDesc=_toConsumableArray(units);var unitsAsc=_toConsumableArray(units).reverse();var isDate=function isDate(d){return Object.prototype.toString.call(d)==="[object Date]"};var isValidDate=function isValidDate(d){return isDate(d)&&!isNaN(d.valueOf())};function parse(text){var _ref=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{},_ref$roundUp=_ref.roundUp,roundUp=_ref$roundUp===void 0?false:_ref$roundUp,_ref$momentInstance=_ref.momentInstance,momentInstance=_ref$momentInstance===void 0?_moment.default:_ref$momentInstance,forceNow=_ref.forceNow;if(!text)return undefined;if(momentInstance.isMoment(text))return text;if(isDate(text))return momentInstance(text);if(forceNow!==undefined&&!isValidDate(forceNow)){throw new Error("forceNow must be a valid Date")}var time;var mathString="";var index;var parseString;if(text.substring(0,3)==="now"){time=momentInstance(forceNow);mathString=text.substring("now".length)}else{index=text.indexOf("||");if(index===-1){parseString=text;mathString=""}else{parseString=text.substring(0,index);mathString=text.substring(index+2)}time=momentInstance(parseString)}if(!mathString.length){return time}return parseDateMath(mathString,time,roundUp)}function parseDateMath(mathString,time,roundUp){var dateTime=time;var len=mathString.length;var i=0;while(i<len){var c=mathString.charAt(i++);var type=void 0;var num=void 0;var unit=void 0;if(c==="/"){type=0}else if(c==="+"){type=1}else if(c==="-"){type=2}else{return}if(isNaN(mathString.charAt(i))){num=1}else if(mathString.length===2){num=mathString.charAt(i)}else{var numFrom=i;while(!isNaN(mathString.charAt(i))){i++;if(i>=len)return}num=parseInt(mathString.substring(numFrom,i),10)}if(type===0){if(num!==1){return}}unit=mathString.charAt(i++);for(var j=i;j<len;j++){var unitChar=mathString.charAt(i);if(/[a-z]/i.test(unitChar)){unit+=unitChar;i++}else{break}}if(units.indexOf(unit)===-1){return}else{if(type===0){if(roundUp)dateTime.endOf(unit);else dateTime.startOf(unit)}else if(type===1){dateTime.add(num,unit)}else if(type===2){dateTime.subtract(num,unit)}}}return dateTime}var _default={parse:parse,unitsMap:Object.freeze(unitsMap),units:Object.freeze(units),unitsAsc:Object.freeze(unitsAsc),unitsDesc:Object.freeze(unitsDesc)};exports.default=_default;module.exports=exports.default},function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(112)):undefined})(this,(function(exports,vegaUtil){"use strict";var name="vega-tooltip";var version$1="0.30.0";var description="A tooltip plugin for Vega-Lite and Vega visualizations.";var keywords=["vega-lite","vega","tooltip"];var repository={type:"git",url:"https://github.com/vega/vega-tooltip.git"};var author={name:"UW Interactive Data Lab",url:"https://idl.cs.washington.edu"};var collaborators=["Dominik Moritz","Sira Horradarn","Zening Qu","Kanit Wongsuphasawat","Yuri Astrakhan","Jeffrey Heer"];var license="BSD-3-Clause";var bugs={url:"https://github.com/vega/vega-tooltip/issues"};var homepage="https://github.com/vega/vega-tooltip#readme";var main="build/vega-tooltip.js";var module="build/vega-tooltip.module.js";var unpkg="build/vega-tooltip.min.js";var jsdelivr="build/vega-tooltip.min.js";var types="build/vega-tooltip.module.d.ts";var files=["src","build","types"];var scripts={prebuild:"yarn clean && yarn build:style",build:"rollup -c","build:style":"./build-style.sh",clean:"rimraf build && rimraf src/style.ts","copy:data":"rsync -r node_modules/vega-datasets/data/* examples/data","copy:build":"rsync -r build/* examples/build","deploy:gh":"yarn build && yarn copy:build && gh-pages -d examples && yarn clean",prepublishOnly:"yarn clean && yarn build",preversion:"yarn lint && yarn test",serve:"browser-sync start -s -f build examples --serveStatic examples",start:"yarn build && concurrently --kill-others -n Server,Rollup 'yarn serve' 'rollup -c -w'",pretest:"yarn build:style",test:"beemo jest","test:inspect":"node --inspect-brk ./node_modules/.bin/jest --runInBand",prepare:"beemo create-config && yarn copy:data",prettierbase:"beemo prettier '*.{css,scss,html}'",eslintbase:"beemo eslint .",format:"yarn eslintbase --fix && yarn prettierbase --write",lint:"yarn eslintbase && yarn prettierbase --check",release:"yarn run prebuild && yarn build && auto shipit"};var devDependencies={"@auto-it/conventional-commits":"^10.37.6","@auto-it/first-time-contributor":"^10.37.6","@rollup/plugin-json":"^5.0.1","@rollup/plugin-node-resolve":"^15.0.1",auto:"^10.37.6","browser-sync":"^2.27.10",concurrently:"^7.5.0","gh-pages":"^4.0.0","jest-environment-jsdom":"^29.3.1",path:"^0.12.7",rollup:"^3.3.0","rollup-plugin-bundle-size":"^1.0.3","rollup-plugin-terser":"^7.0.2","rollup-plugin-ts":"^3.0.2",sass:"^1.56.1",typescript:"~4.9.3","vega-datasets":"^2.5.3","vega-lite-dev-config":"^0.21.0","vega-typings":"^0.22.3"};var dependencies={"vega-util":"^1.17.0"};var pkg={name:name,version:version$1,description:description,keywords:keywords,repository:repository,author:author,collaborators:collaborators,license:license,bugs:bugs,homepage:homepage,main:main,module:module,unpkg:unpkg,jsdelivr:jsdelivr,types:types,files:files,scripts:scripts,devDependencies:devDependencies,dependencies:dependencies};
/*! *****************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */var __assign=function(){__assign=Object.assign||function __assign(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p]}return t};return __assign.apply(this,arguments)};function __rest(s,e){var t={};for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p)&&e.indexOf(p)<0)t[p]=s[p];if(s!=null&&typeof Object.getOwnPropertySymbols==="function")for(var i=0,p=Object.getOwnPropertySymbols(s);i<p.length;i++){if(e.indexOf(p[i])<0&&Object.prototype.propertyIsEnumerable.call(s,p[i]))t[p[i]]=s[p[i]]}return t}function formatValue(value,valueToHtml,maxDepth){if(vegaUtil.isArray(value)){return"[".concat(value.map((function(v){return valueToHtml(vegaUtil.isString(v)?v:stringify(v,maxDepth))})).join(", "),"]")}if(vegaUtil.isObject(value)){var content="";var _a=value,title=_a.title,image=_a.image,rest=__rest(_a,["title","image"]);if(title){content+="<h2>".concat(valueToHtml(title),"</h2>")}if(image){content+='<img src="'.concat(valueToHtml(image),'">')}var keys=Object.keys(rest);if(keys.length>0){content+="<table>";for(var _i=0,keys_1=keys;_i<keys_1.length;_i++){var key=keys_1[_i];var val=rest[key];if(val===undefined){continue}if(vegaUtil.isObject(val)){val=stringify(val,maxDepth)}content+='<tr><td class="key">'.concat(valueToHtml(key),':</td><td class="value">').concat(valueToHtml(val),"</td></tr>")}content+="</table>"}return content||"{}"}return valueToHtml(value)}function replacer(maxDepth){var stack=[];return function(key,value){if(typeof value!=="object"||value===null){return value}var pos=stack.indexOf(this)+1;stack.length=pos;if(stack.length>maxDepth){return"[Object]"}if(stack.indexOf(value)>=0){return"[Circular]"}stack.push(value);return value}}function stringify(obj,maxDepth){return JSON.stringify(obj,replacer(maxDepth))}var defaultStyle="#vg-tooltip-element {\n  visibility: hidden;\n  padding: 8px;\n  position: fixed;\n  z-index: 1000;\n  font-family: sans-serif;\n  font-size: 11px;\n  border-radius: 3px;\n  box-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);\n  /* The default theme is the light theme. */\n  background-color: rgba(255, 255, 255, 0.95);\n  border: 1px solid #d9d9d9;\n  color: black;\n}\n#vg-tooltip-element.visible {\n  visibility: visible;\n}\n#vg-tooltip-element h2 {\n  margin-top: 0;\n  margin-bottom: 10px;\n  font-size: 13px;\n}\n#vg-tooltip-element img {\n  max-width: 200px;\n  max-height: 200px;\n}\n#vg-tooltip-element table {\n  border-spacing: 0;\n}\n#vg-tooltip-element table tr {\n  border: none;\n}\n#vg-tooltip-element table tr td {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  padding-top: 2px;\n  padding-bottom: 2px;\n}\n#vg-tooltip-element table tr td.key {\n  color: #808080;\n  max-width: 150px;\n  text-align: right;\n  padding-right: 4px;\n}\n#vg-tooltip-element table tr td.value {\n  display: block;\n  max-width: 300px;\n  max-height: 7em;\n  text-align: left;\n}\n#vg-tooltip-element.dark-theme {\n  background-color: rgba(32, 32, 32, 0.9);\n  border: 1px solid #f5f5f5;\n  color: white;\n}\n#vg-tooltip-element.dark-theme td.key {\n  color: #bfbfbf;\n}\n";var EL_ID="vg-tooltip-element";var DEFAULT_OPTIONS={offsetX:10,offsetY:10,id:EL_ID,styleId:"vega-tooltip-style",theme:"light",disableDefaultStyle:false,sanitize:escapeHTML,maxDepth:2,formatTooltip:formatValue};function escapeHTML(value){return String(value).replace(/&/g,"&amp;").replace(/</g,"&lt;")}function createDefaultStyle(id){if(!/^[A-Za-z]+[-:.\w]*$/.test(id)){throw new Error("Invalid HTML ID")}return defaultStyle.toString().replace(EL_ID,id)}function calculatePosition(event,tooltipBox,offsetX,offsetY){var x=event.clientX+offsetX;if(x+tooltipBox.width>window.innerWidth){x=+event.clientX-offsetX-tooltipBox.width}var y=event.clientY+offsetY;if(y+tooltipBox.height>window.innerHeight){y=+event.clientY-offsetY-tooltipBox.height}return{x:x,y:y}}var Handler=function(){function Handler(options){this.options=__assign(__assign({},DEFAULT_OPTIONS),options);var elementId=this.options.id;this.el=null;this.call=this.tooltipHandler.bind(this);if(!this.options.disableDefaultStyle&&!document.getElementById(this.options.styleId)){var style=document.createElement("style");style.setAttribute("id",this.options.styleId);style.innerHTML=createDefaultStyle(elementId);var head=document.head;if(head.childNodes.length>0){head.insertBefore(style,head.childNodes[0])}else{head.appendChild(style)}}}Handler.prototype.tooltipHandler=function(handler,event,item,value){var _a;this.el=document.getElementById(this.options.id);if(!this.el){this.el=document.createElement("div");this.el.setAttribute("id",this.options.id);this.el.classList.add("vg-tooltip");var tooltipContainer=(_a=document.fullscreenElement)!==null&&_a!==void 0?_a:document.body;tooltipContainer.appendChild(this.el)}if(value==null||value===""){this.el.classList.remove("visible","".concat(this.options.theme,"-theme"));return}this.el.innerHTML=this.options.formatTooltip(value,this.options.sanitize,this.options.maxDepth);this.el.classList.add("visible","".concat(this.options.theme,"-theme"));var _b=calculatePosition(event,this.el.getBoundingClientRect(),this.options.offsetX,this.options.offsetY),x=_b.x,y=_b.y;this.el.style.top="".concat(y,"px");this.el.style.left="".concat(x,"px")};return Handler}();var version=pkg.version;function index(view,opt){var handler=new Handler(opt);view.tooltip(handler.call).run();return handler}exports.DEFAULT_OPTIONS=DEFAULT_OPTIONS;exports.Handler=Handler;exports.calculatePosition=calculatePosition;exports.createDefaultStyle=createDefaultStyle;exports.default=index;exports.escapeHTML=escapeHTML;exports.formatValue=formatValue;exports.replacer=replacer;exports.stringify=stringify;exports.version=version;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return version}));__webpack_require__.d(__webpack_exports__,"a",(function(){return compile}));var message_namespaceObject={};__webpack_require__.r(message_namespaceObject);__webpack_require__.d(message_namespaceObject,"invalidSpec",(function(){return invalidSpec}));__webpack_require__.d(message_namespaceObject,"FIT_NON_SINGLE",(function(){return FIT_NON_SINGLE}));__webpack_require__.d(message_namespaceObject,"containerSizeNonSingle",(function(){return containerSizeNonSingle}));__webpack_require__.d(message_namespaceObject,"containerSizeNotCompatibleWithAutosize",(function(){return containerSizeNotCompatibleWithAutosize}));__webpack_require__.d(message_namespaceObject,"droppingFit",(function(){return droppingFit}));__webpack_require__.d(message_namespaceObject,"unknownField",(function(){return unknownField}));__webpack_require__.d(message_namespaceObject,"cannotProjectOnChannelWithoutField",(function(){return cannotProjectOnChannelWithoutField}));__webpack_require__.d(message_namespaceObject,"cannotProjectAggregate",(function(){return cannotProjectAggregate}));__webpack_require__.d(message_namespaceObject,"nearestNotSupportForContinuous",(function(){return nearestNotSupportForContinuous}));__webpack_require__.d(message_namespaceObject,"selectionNotSupported",(function(){return selectionNotSupported}));__webpack_require__.d(message_namespaceObject,"selectionNotFound",(function(){return selectionNotFound}));__webpack_require__.d(message_namespaceObject,"SCALE_BINDINGS_CONTINUOUS",(function(){return SCALE_BINDINGS_CONTINUOUS}));__webpack_require__.d(message_namespaceObject,"SEQUENTIAL_SCALE_DEPRECATED",(function(){return SEQUENTIAL_SCALE_DEPRECATED}));__webpack_require__.d(message_namespaceObject,"LEGEND_BINDINGS_MUST_HAVE_PROJECTION",(function(){return LEGEND_BINDINGS_MUST_HAVE_PROJECTION}));__webpack_require__.d(message_namespaceObject,"cannotLookupVariableParameter",(function(){return cannotLookupVariableParameter}));__webpack_require__.d(message_namespaceObject,"noSameUnitLookup",(function(){return noSameUnitLookup}));__webpack_require__.d(message_namespaceObject,"NEEDS_SAME_SELECTION",(function(){return NEEDS_SAME_SELECTION}));__webpack_require__.d(message_namespaceObject,"INTERVAL_INITIALIZED_WITH_POS",(function(){return INTERVAL_INITIALIZED_WITH_POS}));__webpack_require__.d(message_namespaceObject,"noSuchRepeatedValue",(function(){return noSuchRepeatedValue}));__webpack_require__.d(message_namespaceObject,"columnsNotSupportByRowCol",(function(){return columnsNotSupportByRowCol}));__webpack_require__.d(message_namespaceObject,"MULTIPLE_TIMER_ANIMATION_SELECTION",(function(){return MULTIPLE_TIMER_ANIMATION_SELECTION}));__webpack_require__.d(message_namespaceObject,"MULTI_VIEW_ANIMATION_UNSUPPORTED",(function(){return MULTI_VIEW_ANIMATION_UNSUPPORTED}));__webpack_require__.d(message_namespaceObject,"selectionAsScaleDomainWithoutField",(function(){return selectionAsScaleDomainWithoutField}));__webpack_require__.d(message_namespaceObject,"selectionAsScaleDomainWrongEncodings",(function(){return selectionAsScaleDomainWrongEncodings}));__webpack_require__.d(message_namespaceObject,"CONCAT_CANNOT_SHARE_AXIS",(function(){return CONCAT_CANNOT_SHARE_AXIS}));__webpack_require__.d(message_namespaceObject,"unrecognizedParse",(function(){return unrecognizedParse}));__webpack_require__.d(message_namespaceObject,"differentParse",(function(){return differentParse}));__webpack_require__.d(message_namespaceObject,"ADD_SAME_CHILD_TWICE",(function(){return ADD_SAME_CHILD_TWICE}));__webpack_require__.d(message_namespaceObject,"invalidTransformIgnored",(function(){return invalidTransformIgnored}));__webpack_require__.d(message_namespaceObject,"NO_FIELDS_NEEDS_AS",(function(){return NO_FIELDS_NEEDS_AS}));__webpack_require__.d(message_namespaceObject,"customFormatTypeNotAllowed",(function(){return customFormatTypeNotAllowed}));__webpack_require__.d(message_namespaceObject,"projectionOverridden",(function(){return projectionOverridden}));__webpack_require__.d(message_namespaceObject,"REPLACE_ANGLE_WITH_THETA",(function(){return REPLACE_ANGLE_WITH_THETA}));__webpack_require__.d(message_namespaceObject,"offsetNestedInsideContinuousPositionScaleDropped",(function(){return offsetNestedInsideContinuousPositionScaleDropped}));__webpack_require__.d(message_namespaceObject,"primitiveChannelDef",(function(){return primitiveChannelDef}));__webpack_require__.d(message_namespaceObject,"invalidFieldType",(function(){return invalidFieldType}));__webpack_require__.d(message_namespaceObject,"invalidFieldTypeForCountAggregate",(function(){return invalidFieldTypeForCountAggregate}));__webpack_require__.d(message_namespaceObject,"invalidAggregate",(function(){return invalidAggregate}));__webpack_require__.d(message_namespaceObject,"missingFieldType",(function(){return missingFieldType}));__webpack_require__.d(message_namespaceObject,"droppingColor",(function(){return droppingColor}));__webpack_require__.d(message_namespaceObject,"relativeBandSizeNotSupported",(function(){return relativeBandSizeNotSupported}));__webpack_require__.d(message_namespaceObject,"emptyFieldDef",(function(){return emptyFieldDef}));__webpack_require__.d(message_namespaceObject,"LINE_WITH_VARYING_SIZE",(function(){return LINE_WITH_VARYING_SIZE}));__webpack_require__.d(message_namespaceObject,"incompatibleChannel",(function(){return incompatibleChannel}));__webpack_require__.d(message_namespaceObject,"offsetEncodingScaleIgnored",(function(){return offsetEncodingScaleIgnored}));__webpack_require__.d(message_namespaceObject,"invalidEncodingChannel",(function(){return invalidEncodingChannel}));__webpack_require__.d(message_namespaceObject,"channelShouldBeDiscrete",(function(){return channelShouldBeDiscrete}));__webpack_require__.d(message_namespaceObject,"channelShouldBeDiscreteOrDiscretizing",(function(){return channelShouldBeDiscreteOrDiscretizing}));__webpack_require__.d(message_namespaceObject,"facetChannelDropped",(function(){return facetChannelDropped}));__webpack_require__.d(message_namespaceObject,"discreteChannelCannotEncode",(function(){return discreteChannelCannotEncode}));__webpack_require__.d(message_namespaceObject,"rangeMarkAlignmentCannotBeExpression",(function(){return rangeMarkAlignmentCannotBeExpression}));__webpack_require__.d(message_namespaceObject,"lineWithRange",(function(){return lineWithRange}));__webpack_require__.d(message_namespaceObject,"orientOverridden",(function(){return orientOverridden}));__webpack_require__.d(message_namespaceObject,"CANNOT_UNION_CUSTOM_DOMAIN_WITH_FIELD_DOMAIN",(function(){return CANNOT_UNION_CUSTOM_DOMAIN_WITH_FIELD_DOMAIN}));__webpack_require__.d(message_namespaceObject,"cannotUseScalePropertyWithNonColor",(function(){return cannotUseScalePropertyWithNonColor}));__webpack_require__.d(message_namespaceObject,"cannotUseRelativeBandSizeWithNonBandScale",(function(){return cannotUseRelativeBandSizeWithNonBandScale}));__webpack_require__.d(message_namespaceObject,"unaggregateDomainHasNoEffectForRawField",(function(){return unaggregateDomainHasNoEffectForRawField}));__webpack_require__.d(message_namespaceObject,"unaggregateDomainWithNonSharedDomainOp",(function(){return unaggregateDomainWithNonSharedDomainOp}));__webpack_require__.d(message_namespaceObject,"unaggregatedDomainWithLogScale",(function(){return unaggregatedDomainWithLogScale}));__webpack_require__.d(message_namespaceObject,"cannotApplySizeToNonOrientedMark",(function(){return cannotApplySizeToNonOrientedMark}));__webpack_require__.d(message_namespaceObject,"scaleTypeNotWorkWithChannel",(function(){return scaleTypeNotWorkWithChannel}));__webpack_require__.d(message_namespaceObject,"scaleTypeNotWorkWithFieldDef",(function(){return scaleTypeNotWorkWithFieldDef}));__webpack_require__.d(message_namespaceObject,"scalePropertyNotWorkWithScaleType",(function(){return scalePropertyNotWorkWithScaleType}));__webpack_require__.d(message_namespaceObject,"scaleTypeNotWorkWithMark",(function(){return scaleTypeNotWorkWithMark}));__webpack_require__.d(message_namespaceObject,"stepDropped",(function(){return stepDropped}));__webpack_require__.d(message_namespaceObject,"mergeConflictingProperty",(function(){return mergeConflictingProperty}));__webpack_require__.d(message_namespaceObject,"mergeConflictingDomainProperty",(function(){return mergeConflictingDomainProperty}));__webpack_require__.d(message_namespaceObject,"independentScaleMeansIndependentGuide",(function(){return independentScaleMeansIndependentGuide}));__webpack_require__.d(message_namespaceObject,"domainSortDropped",(function(){return domainSortDropped}));__webpack_require__.d(message_namespaceObject,"MORE_THAN_ONE_SORT",(function(){return MORE_THAN_ONE_SORT}));__webpack_require__.d(message_namespaceObject,"FACETED_INDEPENDENT_DIFFERENT_SOURCES",(function(){return FACETED_INDEPENDENT_DIFFERENT_SOURCES}));__webpack_require__.d(message_namespaceObject,"FACETED_INDEPENDENT_SAME_FIELDS_DIFFERENT_SOURCES",(function(){return FACETED_INDEPENDENT_SAME_FIELDS_DIFFERENT_SOURCES}));__webpack_require__.d(message_namespaceObject,"FACETED_INDEPENDENT_SAME_SOURCE",(function(){return FACETED_INDEPENDENT_SAME_SOURCE}));__webpack_require__.d(message_namespaceObject,"INVALID_CHANNEL_FOR_AXIS",(function(){return INVALID_CHANNEL_FOR_AXIS}));__webpack_require__.d(message_namespaceObject,"cannotStackRangedMark",(function(){return cannotStackRangedMark}));__webpack_require__.d(message_namespaceObject,"stackNonLinearScale",(function(){return stackNonLinearScale}));__webpack_require__.d(message_namespaceObject,"stackNonSummativeAggregate",(function(){return stackNonSummativeAggregate}));__webpack_require__.d(message_namespaceObject,"invalidTimeUnit",(function(){return invalidTimeUnit}));__webpack_require__.d(message_namespaceObject,"droppedDay",(function(){return droppedDay}));__webpack_require__.d(message_namespaceObject,"errorBarCenterAndExtentAreNotNeeded",(function(){return errorBarCenterAndExtentAreNotNeeded}));__webpack_require__.d(message_namespaceObject,"errorBarCenterIsUsedWithWrongExtent",(function(){return errorBarCenterIsUsedWithWrongExtent}));__webpack_require__.d(message_namespaceObject,"errorBarContinuousAxisHasCustomizedAggregate",(function(){return errorBarContinuousAxisHasCustomizedAggregate}));__webpack_require__.d(message_namespaceObject,"errorBand1DNotSupport",(function(){return errorBand1DNotSupport}));__webpack_require__.d(message_namespaceObject,"channelRequiredForBinned",(function(){return channelRequiredForBinned}));__webpack_require__.d(message_namespaceObject,"channelShouldNotBeUsedForBinned",(function(){return channelShouldNotBeUsedForBinned}));__webpack_require__.d(message_namespaceObject,"domainRequiredForThresholdScale",(function(){return domainRequiredForThresholdScale}));var vega_lite_package=__webpack_require__(88);var vega_util=__webpack_require__(62);function isLogicalOr(op){return hasProperty(op,"or")}function isLogicalAnd(op){return hasProperty(op,"and")}function isLogicalNot(op){return hasProperty(op,"not")}function forEachLeaf(op,fn){if(isLogicalNot(op)){forEachLeaf(op.not,fn)}else if(isLogicalAnd(op)){for(const subop of op.and){forEachLeaf(subop,fn)}}else if(isLogicalOr(op)){for(const subop of op.or){forEachLeaf(subop,fn)}}else{fn(op)}}function normalizeLogicalComposition(op,normalizer){if(isLogicalNot(op)){return{not:normalizeLogicalComposition(op.not,normalizer)}}else if(isLogicalAnd(op)){return{and:op.and.map(o=>normalizeLogicalComposition(o,normalizer))}}else if(isLogicalOr(op)){return{or:op.or.map(o=>normalizeLogicalComposition(o,normalizer))}}else{return normalizer(op)}}const duplicate=structuredClone;function never(message){throw new Error(message)}function pick(obj,props){const copy={};for(const prop of props){if(Object(vega_util["hasOwnProperty"])(obj,prop)){copy[prop]=obj[prop]}}return copy}function omit(obj,props){const copy={...obj};for(const prop of props){delete copy[prop]}return copy}Set.prototype["toJSON"]=function(){return`Set(${[...this].map(x=>stringify(x)).join(",")})`};function hash(a){if(Object(vega_util["isNumber"])(a)){return a}const str=Object(vega_util["isString"])(a)?a:stringify(a);if(str.length<250){return str}let h=0;for(let i=0;i<str.length;i++){const char=str.charCodeAt(i);h=(h<<5)-h+char;h=h&h}return h}function isNullOrFalse(x){return x===false||x===null}function util_contains(array,item){return array.includes(item)}function some(arr,f){let i=0;for(const[k,a]of arr.entries()){if(f(a,k,i++)){return true}}return false}function every(arr,f){let i=0;for(const[k,a]of arr.entries()){if(!f(a,k,i++)){return false}}return true}function mergeDeep(dest){for(var _len=arguments.length,src=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){src[_key-1]=arguments[_key]}for(const s of src){deepMerge_(dest,s!==null&&s!==void 0?s:{})}return dest}function deepMerge_(dest,src){for(const property of keys(src)){Object(vega_util["writeConfig"])(dest,property,src[property],true)}}function unique(values,f){const results=[];const u={};let v;for(const val of values){v=f(val);if(v in u){continue}u[v]=1;results.push(val)}return results}function isEqual(dict,other){const dictKeys=keys(dict);const otherKeys=keys(other);if(dictKeys.length!==otherKeys.length){return false}for(const key of dictKeys){if(dict[key]!==other[key]){return false}}return true}function setEqual(a,b){if(a.size!==b.size){return false}for(const e of a){if(!b.has(e)){return false}}return true}function hasIntersection(a,b){for(const key of a){if(b.has(key)){return true}}return false}function prefixGenerator(a){const prefixes=new Set;for(const x of a){const splitField=Object(vega_util["splitAccessPath"])(x);const wrappedWithAccessors=splitField.map((y,i)=>i===0?y:`[${y}]`);const computedPrefixes=wrappedWithAccessors.map((_,i)=>wrappedWithAccessors.slice(0,i+1).join(""));for(const y of computedPrefixes){prefixes.add(y)}}return prefixes}function fieldIntersection(a,b){if(a===undefined||b===undefined){return true}return hasIntersection(prefixGenerator(a),prefixGenerator(b))}function isEmpty(obj){return keys(obj).length===0}const keys=Object.keys;const util_vals=Object.values;const entries=Object.entries;function isBoolean(b){return b===true||b===false}function varName(s){const alphanumericS=s.replace(/\W/g,"_");return(s.match(/^\d+/)?"_":"")+alphanumericS}function logicalExpr(op,cb){if(isLogicalNot(op)){return`!(${logicalExpr(op.not,cb)})`}else if(isLogicalAnd(op)){return`(${op.and.map(and=>logicalExpr(and,cb)).join(") && (")})`}else if(isLogicalOr(op)){return`(${op.or.map(or=>logicalExpr(or,cb)).join(") || (")})`}else{return cb(op)}}function deleteNestedProperty(obj,orderedProps){if(orderedProps.length===0){return true}const prop=orderedProps.shift();if(prop in obj&&deleteNestedProperty(obj[prop],orderedProps)){delete obj[prop]}return isEmpty(obj)}function titleCase(s){return s.charAt(0).toUpperCase()+s.substr(1)}function accessPathWithDatum(path){let datum=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"datum";const pieces=Object(vega_util["splitAccessPath"])(path);const prefixes=[];for(let i=1;i<=pieces.length;i++){const prefix=`[${pieces.slice(0,i).map(vega_util["stringValue"]).join("][")}]`;prefixes.push(`${datum}${prefix}`)}return prefixes.join(" && ")}function flatAccessWithDatum(path){let datum=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"datum";return`${datum}[${Object(vega_util["stringValue"])(Object(vega_util["splitAccessPath"])(path).join("."))}]`}function accessWithDatumToUnescapedPath(unescapedPath){const singleQuoteEscapedPath=unescapedPath.replaceAll("'","\\'");return`datum['${singleQuoteEscapedPath}']`}function escapePathAccess(string){return string.replace(/(\[|\]|\.|'|")/g,"\\$1")}function replacePathInField(path){return`${Object(vega_util["splitAccessPath"])(path).map(escapePathAccess).join("\\.")}`}function replaceAll(string,find,replacement){return string.replace(new RegExp(find.replace(/[-/\\^$*+?.()|[\]{}]/g,"\\$&"),"g"),replacement)}function removePathFromField(path){return`${Object(vega_util["splitAccessPath"])(path).join(".")}`}function accessPathDepth(path){if(!path){return 0}return Object(vega_util["splitAccessPath"])(path).length}function getFirstDefined(){for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}return args.find(a=>a!==undefined)}let idCounter=42;function uniqueId(prefix){const id=++idCounter;return prefix?String(prefix)+id:id}function resetIdCounter(){idCounter=42}function internalField(name){return isInternalField(name)?name:`__${name}`}function isInternalField(name){return name.startsWith("__")}function normalizeAngle(angle){if(angle===undefined){return undefined}return(angle%360+360)%360}function isNumeric(value){if(Object(vega_util["isNumber"])(value)){return true}return!isNaN(value)&&!isNaN(parseFloat(value))}const clonedProto=Object.getPrototypeOf(structuredClone({}));function deepEqual(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor.name!==b.constructor.name)return false;let length;let i;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!deepEqual(a[i],b[i]))return false;return true}if(a instanceof Map&&b instanceof Map){if(a.size!==b.size)return false;for(const e of a.entries())if(!b.has(e[0]))return false;for(const e of a.entries())if(!deepEqual(e[1],b.get(e[0])))return false;return true}if(a instanceof Set&&b instanceof Set){if(a.size!==b.size)return false;for(const e of a.entries())if(!b.has(e[0]))return false;return true}if(ArrayBuffer.isView(a)&&ArrayBuffer.isView(b)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(a[i]!==b[i])return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf&&a.valueOf!==clonedProto.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString&&a.toString!==clonedProto.toString)return a.toString()===b.toString();const ks=Object.keys(a);length=ks.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,ks[i]))return false;for(i=length;i--!==0;){const key=ks[i];if(!deepEqual(a[key],b[key]))return false}return true}return a!==a&&b!==b}function stringify(data){const seen=[];return function _stringify(node){if(node&&node.toJSON&&typeof node.toJSON==="function"){node=node.toJSON()}if(node===undefined)return undefined;if(typeof node=="number")return isFinite(node)?""+node:"null";if(typeof node!=="object")return JSON.stringify(node);let i,out;if(Array.isArray(node)){out="[";for(i=0;i<node.length;i++){if(i)out+=",";out+=_stringify(node[i])||"null"}return out+"]"}if(node===null)return"null";if(seen.includes(node)){throw new TypeError("Converting circular structure to JSON")}const seenIndex=seen.push(node)-1;const ks=Object.keys(node).sort();out="";for(i=0;i<ks.length;i++){const key=ks[i];const value=_stringify(node[key]);if(!value)continue;if(out)out+=",";out+=JSON.stringify(key)+":"+value}seen.splice(seenIndex,1);return`{${out}}`}(data)}function hasProperty(obj,key){return Object(vega_util["isObject"])(obj)&&Object(vega_util["hasOwnProperty"])(obj,key)&&obj[key]!==undefined}const ROW="row";const COLUMN="column";const FACET="facet";const X="x";const Y="y";const X2="x2";const Y2="y2";const XOFFSET="xOffset";const YOFFSET="yOffset";const RADIUS="radius";const RADIUS2="radius2";const THETA="theta";const THETA2="theta2";const LATITUDE="latitude";const LONGITUDE="longitude";const LATITUDE2="latitude2";const LONGITUDE2="longitude2";const TIME="time";const COLOR="color";const FILL="fill";const STROKE="stroke";const SHAPE="shape";const SIZE="size";const ANGLE="angle";const OPACITY="opacity";const FILLOPACITY="fillOpacity";const STROKEOPACITY="strokeOpacity";const STROKEWIDTH="strokeWidth";const STROKEDASH="strokeDash";const TEXT="text";const ORDER="order";const DETAIL="detail";const KEY="key";const TOOLTIP="tooltip";const HREF="href";const URL="url";const DESCRIPTION="description";const POSITION_CHANNEL_INDEX={x:1,y:1,x2:1,y2:1};const POLAR_POSITION_CHANNEL_INDEX={theta:1,theta2:1,radius:1,radius2:1};function isPolarPositionChannel(c){return Object(vega_util["hasOwnProperty"])(POLAR_POSITION_CHANNEL_INDEX,c)}const GEO_POSIITON_CHANNEL_INDEX={longitude:1,longitude2:1,latitude:1,latitude2:1};function getPositionChannelFromLatLong(channel){switch(channel){case LATITUDE:return"y";case LATITUDE2:return"y2";case LONGITUDE:return"x";case LONGITUDE2:return"x2"}}function isGeoPositionChannel(c){return Object(vega_util["hasOwnProperty"])(GEO_POSIITON_CHANNEL_INDEX,c)}const GEOPOSITION_CHANNELS=keys(GEO_POSIITON_CHANNEL_INDEX);const UNIT_CHANNEL_INDEX={...POSITION_CHANNEL_INDEX,...POLAR_POSITION_CHANNEL_INDEX,...GEO_POSIITON_CHANNEL_INDEX,xOffset:1,yOffset:1,color:1,fill:1,stroke:1,time:1,opacity:1,fillOpacity:1,strokeOpacity:1,strokeWidth:1,strokeDash:1,size:1,angle:1,shape:1,order:1,text:1,detail:1,key:1,tooltip:1,href:1,url:1,description:1};function isColorChannel(channel){return channel===COLOR||channel===FILL||channel===STROKE}const FACET_CHANNEL_INDEX={row:1,column:1,facet:1};const FACET_CHANNELS=keys(FACET_CHANNEL_INDEX);const CHANNEL_INDEX={...UNIT_CHANNEL_INDEX,...FACET_CHANNEL_INDEX};const CHANNELS=keys(CHANNEL_INDEX);const{order:_o,detail:channel_d,tooltip:_tt1,...SINGLE_DEF_CHANNEL_INDEX}=CHANNEL_INDEX;const{row:channel_r,column:_c,facet:_f,...SINGLE_DEF_UNIT_CHANNEL_INDEX}=SINGLE_DEF_CHANNEL_INDEX;const SINGLE_DEF_CHANNELS=keys(SINGLE_DEF_CHANNEL_INDEX);const SINGLE_DEF_UNIT_CHANNELS=keys(SINGLE_DEF_UNIT_CHANNEL_INDEX);function isSingleDefUnitChannel(str){return Object(vega_util["hasOwnProperty"])(SINGLE_DEF_UNIT_CHANNEL_INDEX,str)}function isChannel(str){return Object(vega_util["hasOwnProperty"])(CHANNEL_INDEX,str)}const SECONDARY_RANGE_CHANNEL=[X2,Y2,LATITUDE2,LONGITUDE2,THETA2,RADIUS2];function isSecondaryRangeChannel(c){const main=getMainRangeChannel(c);return main!==c}function getMainRangeChannel(channel){switch(channel){case X2:return X;case Y2:return Y;case LATITUDE2:return LATITUDE;case LONGITUDE2:return LONGITUDE;case THETA2:return THETA;case RADIUS2:return RADIUS}return channel}function getVgPositionChannel(channel){if(isPolarPositionChannel(channel)){switch(channel){case THETA:return"startAngle";case THETA2:return"endAngle";case RADIUS:return"outerRadius";case RADIUS2:return"innerRadius"}}return channel}function getSecondaryRangeChannel(channel){switch(channel){case X:return X2;case Y:return Y2;case LATITUDE:return LATITUDE2;case LONGITUDE:return LONGITUDE2;case THETA:return THETA2;case RADIUS:return RADIUS2}return undefined}function getSizeChannel(channel){switch(channel){case X:case X2:return"width";case Y:case Y2:return"height"}return undefined}function getOffsetChannel(channel){switch(channel){case X:return"xOffset";case Y:return"yOffset";case X2:return"x2Offset";case Y2:return"y2Offset";case THETA:return"thetaOffset";case RADIUS:return"radiusOffset";case THETA2:return"theta2Offset";case RADIUS2:return"radius2Offset"}return undefined}function getOffsetScaleChannel(channel){switch(channel){case X:return"xOffset";case Y:return"yOffset"}return undefined}function getMainChannelFromOffsetChannel(channel){switch(channel){case"xOffset":return"x";case"yOffset":return"y"}}const UNIT_CHANNELS=keys(UNIT_CHANNEL_INDEX);const{x:_x,y:_y,x2:_x2,y2:_y2,xOffset:_xo,yOffset:_yo,latitude:_latitude,longitude:_longitude,latitude2:_latitude2,longitude2:_longitude2,theta:_theta,theta2:_theta2,radius:_radius,radius2:_radius2,...NONPOSITION_CHANNEL_INDEX}=UNIT_CHANNEL_INDEX;const NONPOSITION_CHANNELS=keys(NONPOSITION_CHANNEL_INDEX);const POSITION_SCALE_CHANNEL_INDEX={x:1,y:1};const POSITION_SCALE_CHANNELS=keys(POSITION_SCALE_CHANNEL_INDEX);function isXorY(channel){return Object(vega_util["hasOwnProperty"])(POSITION_SCALE_CHANNEL_INDEX,channel)}const POLAR_POSITION_SCALE_CHANNEL_INDEX={theta:1,radius:1};const POLAR_POSITION_SCALE_CHANNELS=keys(POLAR_POSITION_SCALE_CHANNEL_INDEX);function getPositionScaleChannel(sizeType){return sizeType==="width"?X:Y}const OFFSET_SCALE_CHANNEL_INDEX={xOffset:1,yOffset:1};const OFFSET_SCALE_CHANNELS=keys(OFFSET_SCALE_CHANNEL_INDEX);function isXorYOffset(channel){return Object(vega_util["hasOwnProperty"])(OFFSET_SCALE_CHANNEL_INDEX,channel)}const TIME_SCALE_CHANNEL_INDEX={time:1};const TIME_SCALE_CHANNELS=keys(TIME_SCALE_CHANNEL_INDEX);function channel_isTime(channel){return channel in TIME_SCALE_CHANNEL_INDEX}const{text:_t,tooltip:_tt,href:_hr,url:_u,description:_al,detail:_dd,key:_k,order:_oo,...NONPOSITION_SCALE_CHANNEL_INDEX}=NONPOSITION_CHANNEL_INDEX;const NONPOSITION_SCALE_CHANNELS=keys(NONPOSITION_SCALE_CHANNEL_INDEX);function isNonPositionScaleChannel(channel){return Object(vega_util["hasOwnProperty"])(NONPOSITION_CHANNEL_INDEX,channel)}function supportLegend(channel){switch(channel){case COLOR:case FILL:case STROKE:case SIZE:case SHAPE:case OPACITY:case STROKEWIDTH:case STROKEDASH:return true;case FILLOPACITY:case STROKEOPACITY:case ANGLE:case TIME:return false}}const SCALE_CHANNEL_INDEX={...POSITION_SCALE_CHANNEL_INDEX,...POLAR_POSITION_SCALE_CHANNEL_INDEX,...OFFSET_SCALE_CHANNEL_INDEX,...NONPOSITION_SCALE_CHANNEL_INDEX};const SCALE_CHANNELS=keys(SCALE_CHANNEL_INDEX);function isScaleChannel(channel){return Object(vega_util["hasOwnProperty"])(SCALE_CHANNEL_INDEX,channel)}function supportMark(channel,mark){return getSupportedMark(channel)[mark]}const ALL_MARKS={arc:"always",area:"always",bar:"always",circle:"always",geoshape:"always",image:"always",line:"always",rule:"always",point:"always",rect:"always",square:"always",trail:"always",text:"always",tick:"always"};const{geoshape:_g,...ALL_MARKS_EXCEPT_GEOSHAPE}=ALL_MARKS;function getSupportedMark(channel){switch(channel){case COLOR:case FILL:case STROKE:case DESCRIPTION:case DETAIL:case KEY:case TOOLTIP:case HREF:case ORDER:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case STROKEWIDTH:case FACET:case ROW:case COLUMN:return ALL_MARKS;case X:case Y:case XOFFSET:case YOFFSET:case LATITUDE:case LONGITUDE:case TIME:return ALL_MARKS_EXCEPT_GEOSHAPE;case X2:case Y2:case LATITUDE2:case LONGITUDE2:return{area:"always",bar:"always",image:"always",rect:"always",rule:"always",circle:"binned",point:"binned",square:"binned",tick:"binned",line:"binned",trail:"binned"};case SIZE:return{point:"always",tick:"always",rule:"always",circle:"always",square:"always",bar:"always",text:"always",line:"always",trail:"always"};case STROKEDASH:return{line:"always",point:"always",tick:"always",rule:"always",circle:"always",square:"always",bar:"always",geoshape:"always"};case SHAPE:return{point:"always",geoshape:"always"};case TEXT:return{text:"always"};case ANGLE:return{point:"always",square:"always",text:"always"};case URL:return{image:"always"};case THETA:return{text:"always",arc:"always"};case RADIUS:return{text:"always",arc:"always"};case THETA2:case RADIUS2:return{arc:"always"}}}function rangeType(channel){switch(channel){case X:case Y:case THETA:case RADIUS:case XOFFSET:case YOFFSET:case SIZE:case ANGLE:case STROKEWIDTH:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case TIME:case X2:case Y2:case THETA2:case RADIUS2:return undefined;case FACET:case ROW:case COLUMN:case SHAPE:case STROKEDASH:case TEXT:case TOOLTIP:case HREF:case URL:case DESCRIPTION:return"discrete";case COLOR:case FILL:case STROKE:return"flexible";case LATITUDE:case LONGITUDE:case LATITUDE2:case LONGITUDE2:case DETAIL:case KEY:case ORDER:return undefined}}const AGGREGATE_OP_INDEX={argmax:1,argmin:1,average:1,count:1,distinct:1,exponential:1,exponentialb:1,product:1,max:1,mean:1,median:1,min:1,missing:1,q1:1,q3:1,ci0:1,ci1:1,stderr:1,stdev:1,stdevp:1,sum:1,valid:1,values:1,variance:1,variancep:1};const MULTIDOMAIN_SORT_OP_INDEX={count:1,min:1,max:1};function isArgminDef(a){return hasProperty(a,"argmin")}function isArgmaxDef(a){return hasProperty(a,"argmax")}function isAggregateOp(a){return Object(vega_util["isString"])(a)&&Object(vega_util["hasOwnProperty"])(AGGREGATE_OP_INDEX,a)}const COUNTING_OPS=new Set(["count","valid","missing","distinct"]);function isCountingAggregateOp(aggregate){return Object(vega_util["isString"])(aggregate)&&COUNTING_OPS.has(aggregate)}function isMinMaxOp(aggregate){return Object(vega_util["isString"])(aggregate)&&util_contains(["min","max"],aggregate)}const SUM_OPS=new Set(["count","sum","distinct","valid","missing"]);const SHARED_DOMAIN_OPS=new Set(["mean","average","median","q1","q3","min","max"]);function binToString(bin){if(Object(vega_util["isBoolean"])(bin)){bin=normalizeBin(bin,undefined)}return"bin"+keys(bin).map(p=>isParameterExtent(bin[p])?varName(`_${p}_${entries(bin[p])}`):varName(`_${p}_${bin[p]}`)).join("")}function isBinning(bin){return bin===true||isBinParams(bin)&&!bin.binned}function isBinned(bin){return bin==="binned"||isBinParams(bin)&&bin.binned===true}function isBinParams(bin){return Object(vega_util["isObject"])(bin)}function isParameterExtent(extent){return hasProperty(extent,"param")}function autoMaxBins(channel){switch(channel){case ROW:case COLUMN:case SIZE:case COLOR:case FILL:case STROKE:case STROKEWIDTH:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case SHAPE:return 6;case STROKEDASH:return 4;default:return 10}}function isExprRef(o){return hasProperty(o,"expr")}function replaceExprRef(index){let{level:level}=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{level:0};const props=keys(index||{});const newIndex={};for(const prop of props){newIndex[prop]=level===0?signalRefOrValue(index[prop]):replaceExprRef(index[prop],{level:level-1})}return newIndex}function extractTitleConfig(titleConfig){const{anchor:anchor,frame:frame,offset:offset,orient:orient,angle:angle,limit:limit,color:color,subtitleColor:subtitleColor,subtitleFont:subtitleFont,subtitleFontSize:subtitleFontSize,subtitleFontStyle:subtitleFontStyle,subtitleFontWeight:subtitleFontWeight,subtitleLineHeight:subtitleLineHeight,subtitlePadding:subtitlePadding,...rest}=titleConfig;const titleMarkConfig={...rest,...color?{fill:color}:{}};const nonMarkTitleProperties={...anchor?{anchor:anchor}:{},...frame?{frame:frame}:{},...offset?{offset:offset}:{},...orient?{orient:orient}:{},...angle!==undefined?{angle:angle}:{},...limit!==undefined?{limit:limit}:{}};const subtitle={...subtitleColor?{subtitleColor:subtitleColor}:{},...subtitleFont?{subtitleFont:subtitleFont}:{},...subtitleFontSize?{subtitleFontSize:subtitleFontSize}:{},...subtitleFontStyle?{subtitleFontStyle:subtitleFontStyle}:{},...subtitleFontWeight?{subtitleFontWeight:subtitleFontWeight}:{},...subtitleLineHeight?{subtitleLineHeight:subtitleLineHeight}:{},...subtitlePadding?{subtitlePadding:subtitlePadding}:{}};const subtitleMarkConfig=pick(titleConfig,["align","baseline","dx","dy","limit"]);return{titleMarkConfig:titleMarkConfig,subtitleMarkConfig:subtitleMarkConfig,nonMarkTitleProperties:nonMarkTitleProperties,subtitle:subtitle}}function isText(v){return Object(vega_util["isString"])(v)||Object(vega_util["isArray"])(v)&&Object(vega_util["isString"])(v[0])}function isSignalRef(o){return hasProperty(o,"signal")}function isVgRangeStep(range){return hasProperty(range,"step")}function isDataRefUnionedDomain(domain){if(!Object(vega_util["isArray"])(domain)){return hasProperty(domain,"fields")&&!hasProperty(domain,"data")}return false}function isFieldRefUnionDomain(domain){if(!Object(vega_util["isArray"])(domain)){return hasProperty(domain,"fields")&&hasProperty(domain,"data")}return false}function isDataRefDomain(domain){if(!Object(vega_util["isArray"])(domain)){return hasProperty(domain,"field")&&hasProperty(domain,"data")}return false}const VG_MARK_CONFIG_INDEX={aria:1,description:1,ariaRole:1,ariaRoleDescription:1,blend:1,opacity:1,fill:1,fillOpacity:1,stroke:1,strokeCap:1,strokeWidth:1,strokeOpacity:1,strokeDash:1,strokeDashOffset:1,strokeJoin:1,strokeOffset:1,strokeMiterLimit:1,startAngle:1,endAngle:1,padAngle:1,innerRadius:1,outerRadius:1,size:1,shape:1,interpolate:1,tension:1,orient:1,align:1,baseline:1,text:1,dir:1,dx:1,dy:1,ellipsis:1,limit:1,radius:1,theta:1,angle:1,font:1,fontSize:1,fontWeight:1,fontStyle:1,lineBreak:1,lineHeight:1,cursor:1,href:1,tooltip:1,cornerRadius:1,cornerRadiusTopLeft:1,cornerRadiusTopRight:1,cornerRadiusBottomLeft:1,cornerRadiusBottomRight:1,aspect:1,width:1,height:1,url:1,smooth:1};const VG_MARK_CONFIGS=keys(VG_MARK_CONFIG_INDEX);const VG_MARK_INDEX={arc:1,area:1,group:1,image:1,line:1,path:1,rect:1,rule:1,shape:1,symbol:1,text:1,trail:1};const VG_CORNERRADIUS_CHANNELS=["cornerRadius","cornerRadiusTopLeft","cornerRadiusTopRight","cornerRadiusBottomLeft","cornerRadiusBottomRight"];const BIN_RANGE_DELIMITER=" – ";function signalOrValueRefWithCondition(val){const condition=Object(vega_util["isArray"])(val.condition)?val.condition.map(conditionalSignalRefOrValue):conditionalSignalRefOrValue(val.condition);return{...signalRefOrValue(val),condition:condition}}function signalRefOrValue(value){if(isExprRef(value)){const{expr:expr,...rest}=value;return{signal:expr,...rest}}return value}function conditionalSignalRefOrValue(value){if(isExprRef(value)){const{expr:expr,...rest}=value;return{signal:expr,...rest}}return value}function signalOrValueRef(value){if(isExprRef(value)){const{expr:expr,...rest}=value;return{signal:expr,...rest}}if(isSignalRef(value)){return value}return value!==undefined?{value:value}:undefined}function exprFromSignalRefOrValue(ref){if(isSignalRef(ref)){return ref.signal}return Object(vega_util["stringValue"])(ref)}function exprFromValueRefOrSignalRef(ref){if(isSignalRef(ref)){return ref.signal}return Object(vega_util["stringValue"])(ref.value)}function signalOrStringValue(v){if(isSignalRef(v)){return v.signal}return v==null?null:Object(vega_util["stringValue"])(v)}function applyMarkConfig(e,model,propsList){for(const property of propsList){const value=getMarkConfig(property,model.markDef,model.config);if(value!==undefined){e[property]=signalOrValueRef(value)}}return e}function getStyles(mark){var _mark$style;return[].concat(mark.type,(_mark$style=mark.style)!==null&&_mark$style!==void 0?_mark$style:[])}function getMarkPropOrConfig(channel,mark,config){let opt=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};const{vgChannel:vgChannel,ignoreVgConfig:ignoreVgConfig}=opt;if(vgChannel&&hasProperty(mark,vgChannel)){return mark[vgChannel]}else if(mark[channel]!==undefined){return mark[channel]}else if(ignoreVgConfig&&(!vgChannel||vgChannel===channel)){return undefined}return getMarkConfig(channel,mark,config,opt)}function getMarkConfig(channel,mark,config){let{vgChannel:vgChannel}=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};const cfg=getMarkStyleConfig(channel,mark,config.style);return getFirstDefined(vgChannel?cfg:undefined,cfg,vgChannel?config[mark.type][vgChannel]:undefined,config[mark.type][channel],vgChannel?config.mark[vgChannel]:config.mark[channel])}function getMarkStyleConfig(prop,mark,styleConfigIndex){return getStyleConfig(prop,getStyles(mark),styleConfigIndex)}function getStyleConfig(p,styles,styleConfigIndex){styles=Object(vega_util["array"])(styles);let value;for(const style of styles){const styleConfig=styleConfigIndex[style];if(hasProperty(styleConfig,p)){value=styleConfig[p]}}return value}function sortParams(orderDef,fieldRefOption){return Object(vega_util["array"])(orderDef).reduce((s,orderChannelDef)=>{var _orderChannelDef$sort;s.field.push(vgField(orderChannelDef,fieldRefOption));s.order.push((_orderChannelDef$sort=orderChannelDef.sort)!==null&&_orderChannelDef$sort!==void 0?_orderChannelDef$sort:"ascending");return s},{field:[],order:[]})}function mergeTitleFieldDefs(f1,f2){const merged=[...f1];f2.forEach(fdToMerge=>{for(const fieldDef1 of merged){if(deepEqual(fieldDef1,fdToMerge)){return}}merged.push(fdToMerge)});return merged}function mergeTitle(title1,title2){if(deepEqual(title1,title2)||!title2){return title1}else if(!title1){return title2}else{return[...Object(vega_util["array"])(title1),...Object(vega_util["array"])(title2)].join(", ")}}function mergeTitleComponent(v1,v2){const v1Val=v1.value;const v2Val=v2.value;if(v1Val==null||v2Val===null){return{explicit:v1.explicit,value:null}}else if((isText(v1Val)||isSignalRef(v1Val))&&(isText(v2Val)||isSignalRef(v2Val))){return{explicit:v1.explicit,value:mergeTitle(v1Val,v2Val)}}else if(isText(v1Val)||isSignalRef(v1Val)){return{explicit:v1.explicit,value:v1Val}}else if(isText(v2Val)||isSignalRef(v2Val)){return{explicit:v1.explicit,value:v2Val}}else if(!isText(v1Val)&&!isSignalRef(v1Val)&&!isText(v2Val)&&!isSignalRef(v2Val)){return{explicit:v1.explicit,value:mergeTitleFieldDefs(v1Val,v2Val)}}throw new Error("It should never reach here")}var vega_node=__webpack_require__(64);function invalidSpec(spec){return`Invalid specification ${stringify(spec)}. Make sure the specification includes at least one of the following properties: "mark", "layer", "facet", "hconcat", "vconcat", "concat", or "repeat".`}const FIT_NON_SINGLE='Autosize "fit" only works for single views and layered views.';function containerSizeNonSingle(name){const uName=name=="width"?"Width":"Height";return`${uName} "container" only works for single views and layered views.`}function containerSizeNotCompatibleWithAutosize(name){const uName=name=="width"?"Width":"Height";const fitDirection=name=="width"?"x":"y";return`${uName} "container" only works well with autosize "fit" or "fit-${fitDirection}".`}function droppingFit(channel){return channel?`Dropping "fit-${channel}" because spec has discrete ${getSizeChannel(channel)}.`:`Dropping "fit" because spec has discrete size.`}function unknownField(channel){return`Unknown field for ${channel}. Cannot calculate view size.`}function cannotProjectOnChannelWithoutField(channel){return`Cannot project a selection on encoding channel "${channel}", which has no field.`}function cannotProjectAggregate(channel,aggregate){return`Cannot project a selection on encoding channel "${channel}" as it uses an aggregate function ("${aggregate}").`}function nearestNotSupportForContinuous(mark){return`The "nearest" transform is not supported for ${mark} marks.`}function selectionNotSupported(mark){return`Selection not supported for ${mark} yet.`}function selectionNotFound(name){return`Cannot find a selection named "${name}".`}const SCALE_BINDINGS_CONTINUOUS="Scale bindings are currently only supported for scales with unbinned, continuous domains.";const SEQUENTIAL_SCALE_DEPRECATED="Sequntial scales are deprecated. The available quantitative scale type values are linear, log, pow, sqrt, symlog, time and utc";const LEGEND_BINDINGS_MUST_HAVE_PROJECTION="Legend bindings are only supported for selections over an individual field or encoding channel.";function cannotLookupVariableParameter(name){return`Lookups can only be performed on selection parameters. "${name}" is a variable parameter.`}function noSameUnitLookup(name){return`Cannot define and lookup the "${name}" selection in the same view. `+`Try moving the lookup into a second, layered view?`}const NEEDS_SAME_SELECTION="The same selection must be used to override scale domains in a layered view.";const INTERVAL_INITIALIZED_WITH_POS='Interval selections should be initialized using "x", "y", "longitude", or "latitude" keys.';function noSuchRepeatedValue(field){return`Unknown repeated value "${field}".`}function columnsNotSupportByRowCol(type){return`The "columns" property cannot be used when "${type}" has nested row/column.`}const MULTIPLE_TIMER_ANIMATION_SELECTION="Multiple timer selections in one unit spec are not supported. Ignoring all but the first.";const MULTI_VIEW_ANIMATION_UNSUPPORTED="Animation involving facet, layer, or concat is currently unsupported.";function selectionAsScaleDomainWithoutField(field){return'A "field" or "encoding" must be specified when using a selection as a scale domain. '+`Using "field": ${Object(vega_node["stringValue"])(field)}.`}function selectionAsScaleDomainWrongEncodings(encodings,encoding,extent,field){return(!encodings.length?"No ":"Multiple ")+`matching ${Object(vega_node["stringValue"])(encoding)} encoding found for selection ${Object(vega_node["stringValue"])(extent.param)}. `+`Using "field": ${Object(vega_node["stringValue"])(field)}.`}const CONCAT_CANNOT_SHARE_AXIS="Axes cannot be shared in concatenated or repeated views yet (https://github.com/vega/vega-lite/issues/2415).";function unrecognizedParse(p){return`Unrecognized parse "${p}".`}function differentParse(field,local,ancestor){return`An ancestor parsed field "${field}" as ${ancestor} but a child wants to parse the field as ${local}.`}const ADD_SAME_CHILD_TWICE="Attempt to add the same child twice.";function invalidTransformIgnored(transform){return`Ignoring an invalid transform: ${stringify(transform)}.`}const NO_FIELDS_NEEDS_AS='If "from.fields" is not specified, "as" has to be a string that specifies the key to be used for the data from the secondary source.';function customFormatTypeNotAllowed(channel){return`Config.customFormatTypes is not true, thus custom format type and format for channel ${channel} are dropped.`}function projectionOverridden(opt){const{parentProjection:parentProjection,projection:projection}=opt;return`Layer's shared projection ${stringify(parentProjection)} is overridden by a child projection ${stringify(projection)}.`}const REPLACE_ANGLE_WITH_THETA="Arc marks uses theta channel rather than angle, replacing angle with theta.";function offsetNestedInsideContinuousPositionScaleDropped(mainChannel){return`${mainChannel}Offset dropped because ${mainChannel} is continuous`}function primitiveChannelDef(channel,type,value){return`Channel ${channel} is a ${type}. Converted to {value: ${stringify(value)}}.`}function invalidFieldType(type){return`Invalid field type "${type}".`}function invalidFieldTypeForCountAggregate(type,aggregate){return`Invalid field type "${type}" for aggregate: "${aggregate}", using "quantitative" instead.`}function invalidAggregate(aggregate){return`Invalid aggregation operator "${aggregate}".`}function missingFieldType(channel,newType){return`Missing type for channel "${channel}", using "${newType}" instead.`}function droppingColor(type,opt){const{fill:fill,stroke:stroke}=opt;return`Dropping color ${type} as the plot also has ${fill&&stroke?"fill and stroke":fill?"fill":"stroke"}.`}function relativeBandSizeNotSupported(sizeChannel){return`Position range does not support relative band size for ${sizeChannel}.`}function emptyFieldDef(fieldDef,channel){return`Dropping ${stringify(fieldDef)} from channel "${channel}" since it does not contain any data field, datum, value, or signal.`}const LINE_WITH_VARYING_SIZE="Line marks cannot encode size with a non-groupby field. You may want to use trail marks instead.";function incompatibleChannel(channel,markOrFacet,when){return`${channel} dropped as it is incompatible with "${markOrFacet}"${when?` when ${when}`:""}.`}function offsetEncodingScaleIgnored(channel){return`${channel} encoding has no scale, so specified scale is ignored.`}function invalidEncodingChannel(channel){return`${channel}-encoding is dropped as ${channel} is not a valid encoding channel.`}function channelShouldBeDiscrete(channel){return`${channel} encoding should be discrete (ordinal / nominal / binned).`}function channelShouldBeDiscreteOrDiscretizing(channel){return`${channel} encoding should be discrete (ordinal / nominal / binned) or use a discretizing scale (e.g. threshold).`}function facetChannelDropped(channels){return`Facet encoding dropped as ${channels.join(" and ")} ${channels.length>1?"are":"is"} also specified.`}function discreteChannelCannotEncode(channel,type){return`Using discrete channel "${channel}" to encode "${type}" field can be misleading as it does not encode ${type==="ordinal"?"order":"magnitude"}.`}function rangeMarkAlignmentCannotBeExpression(align){return`The ${align} for range marks cannot be an expression`}function lineWithRange(hasX2,hasY2){const channels=hasX2&&hasY2?"x2 and y2":hasX2?"x2":"y2";return`Line mark is for continuous lines and thus cannot be used with ${channels}. We will use the rule mark (line segments) instead.`}function orientOverridden(original,actual){return`Specified orient "${original}" overridden with "${actual}".`}const CANNOT_UNION_CUSTOM_DOMAIN_WITH_FIELD_DOMAIN="Custom domain scale cannot be unioned with default field-based domain.";function cannotUseScalePropertyWithNonColor(prop){return`Cannot use the scale property "${prop}" with non-color channel.`}function cannotUseRelativeBandSizeWithNonBandScale(scaleType){return`Cannot use the relative band size with ${scaleType} scale.`}function unaggregateDomainHasNoEffectForRawField(fieldDef){return`Using unaggregated domain with raw field has no effect (${stringify(fieldDef)}).`}function unaggregateDomainWithNonSharedDomainOp(aggregate){return`Unaggregated domain not applicable for "${aggregate}" since it produces values outside the origin domain of the source data.`}function unaggregatedDomainWithLogScale(fieldDef){return`Unaggregated domain is currently unsupported for log scale (${stringify(fieldDef)}).`}function cannotApplySizeToNonOrientedMark(mark){return`Cannot apply size to non-oriented mark "${mark}".`}function scaleTypeNotWorkWithChannel(channel,scaleType,defaultScaleType){return`Channel "${channel}" does not work with "${scaleType}" scale. We are using "${defaultScaleType}" scale instead.`}function scaleTypeNotWorkWithFieldDef(scaleType,defaultScaleType){return`FieldDef does not work with "${scaleType}" scale. We are using "${defaultScaleType}" scale instead.`}function scalePropertyNotWorkWithScaleType(scaleType,propName,channel){return`${channel}-scale's "${propName}" is dropped as it does not work with ${scaleType} scale.`}function scaleTypeNotWorkWithMark(mark,scaleType){return`Scale type "${scaleType}" does not work with mark "${mark}".`}function stepDropped(channel){return`The step for "${channel}" is dropped because the ${channel==="width"?"x":"y"} is continuous.`}function mergeConflictingProperty(property,propertyOf,v1,v2){return`Conflicting ${propertyOf.toString()} property "${property.toString()}" (${stringify(v1)} and ${stringify(v2)}). Using ${stringify(v1)}.`}function mergeConflictingDomainProperty(property,propertyOf,v1,v2){return`Conflicting ${propertyOf.toString()} property "${property.toString()}" (${stringify(v1)} and ${stringify(v2)}). Using the union of the two domains.`}function independentScaleMeansIndependentGuide(channel){return`Setting the scale to be independent for "${channel}" means we also have to set the guide (axis or legend) to be independent.`}function domainSortDropped(sort){return`Dropping sort property ${stringify(sort)} as unioned domains only support boolean or op "count", "min", and "max".`}const MORE_THAN_ONE_SORT="Domains that should be unioned has conflicting sort properties. Sort will be set to true.";const FACETED_INDEPENDENT_DIFFERENT_SOURCES="Detected faceted independent scales that union domain of multiple fields from different data sources. We will use the first field. The result view size may be incorrect.";const FACETED_INDEPENDENT_SAME_FIELDS_DIFFERENT_SOURCES="Detected faceted independent scales that union domain of the same fields from different source. We will assume that this is the same field from a different fork of the same data source. However, if this is not the case, the result view size may be incorrect.";const FACETED_INDEPENDENT_SAME_SOURCE="Detected faceted independent scales that union domain of multiple fields from the same data source. We will use the first field. The result view size may be incorrect.";const INVALID_CHANNEL_FOR_AXIS="Invalid channel for axis.";function cannotStackRangedMark(channel){return`Cannot stack "${channel}" if there is already "${channel}2".`}function stackNonLinearScale(scaleType){return`Stack is applied to a non-linear scale (${scaleType}).`}function stackNonSummativeAggregate(aggregate){return`Stacking is applied even though the aggregate function is non-summative ("${aggregate}").`}function invalidTimeUnit(unitName,value){return`Invalid ${unitName}: ${stringify(value)}.`}function droppedDay(d){return`Dropping day from datetime ${stringify(d)} as day cannot be combined with other units.`}function errorBarCenterAndExtentAreNotNeeded(center,extent){return`${extent?"extent ":""}${extent&&center?"and ":""}${center?"center ":""}${extent&&center?"are ":"is "}not needed when data are aggregated.`}function errorBarCenterIsUsedWithWrongExtent(center,extent,mark){return`${center} is not usually used with ${extent} for ${mark}.`}function errorBarContinuousAxisHasCustomizedAggregate(aggregate,compositeMark){return`Continuous axis should not have customized aggregation function ${aggregate}; ${compositeMark} already agregates the axis.`}function errorBand1DNotSupport(property){return`1D error band does not support ${property}.`}function channelRequiredForBinned(channel){return`Channel ${channel} is required for "binned" bin.`}function channelShouldNotBeUsedForBinned(channel){return`Channel ${channel} should not be used with "binned" bin.`}function domainRequiredForThresholdScale(channel){return`Domain for ${channel} is required for threshold scale.`}function _classPrivateFieldInitSpec(e,t,a){_checkPrivateRedeclaration(e,t),t.set(e,a)}function _checkPrivateRedeclaration(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}function _classPrivateFieldGet2(e,t){var r=_classPrivateFieldGet(t,e);return _classApplyDescriptorGet(e,r)}function _classApplyDescriptorGet(e,t){return t.get?t.get.call(e):t.value}function _classPrivateFieldSet(e,t,r){var s=_classPrivateFieldGet(t,e);return _classApplyDescriptorSet(e,s,r),r}function _classPrivateFieldGet(s,a){return s.get(_assertClassBrand(s,a))}function _assertClassBrand(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}function _classApplyDescriptorSet(e,t,l){if(t.set)t.set.call(e,l);else{if(!t.writable)throw new TypeError("attempted to set read only private field");t.value=l}}const log_main=Object(vega_util["logger"])(vega_util["Warn"]);let current=log_main;var _level=new WeakMap;class log_LocalLogger{constructor(){_defineProperty(this,"warns",[]);_defineProperty(this,"infos",[]);_defineProperty(this,"debugs",[]);_classPrivateFieldInitSpec(this,_level,{writable:true,value:vega_util["Warn"]})}level(_){if(_){_classPrivateFieldSet(this,_level,_);return this}return _classPrivateFieldGet2(this,_level)}warn(){if(_classPrivateFieldGet2(this,_level)>=vega_util["Warn"])this.warns.push(...arguments);return this}info(){if(_classPrivateFieldGet2(this,_level)>=vega_util["Info"])this.infos.push(...arguments);return this}debug(){if(_classPrivateFieldGet2(this,_level)>=vega_util["Debug"])this.debugs.push(...arguments);return this}error(){if(_classPrivateFieldGet2(this,_level)>=vega_util["Error"])throw Error(...arguments);return this}}function log_wrap(f){return()=>{current=new log_LocalLogger;f(current);log_reset()}}function set(newLogger){current=newLogger;return current}function log_reset(){current=log_main;return current}function error(){current.error(...arguments)}function warn(){current.warn(...arguments)}function info(){current.info(...arguments)}function debug(){current.debug(...arguments)}function isDateTime(o){if(o&&Object(vega_util["isObject"])(o)){for(const part of TIMEUNIT_PARTS){if(hasProperty(o,part)){return true}}}return false}const MONTHS=["january","february","march","april","may","june","july","august","september","october","november","december"];const SHORT_MONTHS=MONTHS.map(m=>m.substr(0,3));const DAYS=["sunday","monday","tuesday","wednesday","thursday","friday","saturday"];const SHORT_DAYS=DAYS.map(d=>d.substr(0,3));function normalizeQuarter(q){if(isNumeric(q)){q=+q}if(Object(vega_util["isNumber"])(q)){if(q>4){warn(message_namespaceObject.invalidTimeUnit("quarter",q))}return q-1}else{throw new Error(message_namespaceObject.invalidTimeUnit("quarter",q))}}function normalizeMonth(m){if(isNumeric(m)){m=+m}if(Object(vega_util["isNumber"])(m)){return m-1}else{const lowerM=m.toLowerCase();const monthIndex=MONTHS.indexOf(lowerM);if(monthIndex!==-1){return monthIndex}const shortM=lowerM.substr(0,3);const shortMonthIndex=SHORT_MONTHS.indexOf(shortM);if(shortMonthIndex!==-1){return shortMonthIndex}throw new Error(message_namespaceObject.invalidTimeUnit("month",m))}}function normalizeDay(d){if(isNumeric(d)){d=+d}if(Object(vega_util["isNumber"])(d)){return d%7}else{const lowerD=d.toLowerCase();const dayIndex=DAYS.indexOf(lowerD);if(dayIndex!==-1){return dayIndex}const shortD=lowerD.substr(0,3);const shortDayIndex=SHORT_DAYS.indexOf(shortD);if(shortDayIndex!==-1){return shortDayIndex}throw new Error(message_namespaceObject.invalidTimeUnit("day",d))}}function dateTimeParts(d,normalize){const parts=[];if(normalize&&d.day!==undefined){if(keys(d).length>1){warn(message_namespaceObject.droppedDay(d));d=duplicate(d);delete d.day}}if(d.year!==undefined){parts.push(d.year)}else{parts.push(2012)}if(d.month!==undefined){const month=normalize?normalizeMonth(d.month):d.month;parts.push(month)}else if(d.quarter!==undefined){const quarter=normalize?normalizeQuarter(d.quarter):d.quarter;parts.push(Object(vega_util["isNumber"])(quarter)?quarter*3:`${quarter}*3`)}else{parts.push(0)}if(d.date!==undefined){parts.push(d.date)}else if(d.day!==undefined){const day=normalize?normalizeDay(d.day):d.day;parts.push(Object(vega_util["isNumber"])(day)?day+1:`${day}+1`)}else{parts.push(1)}for(const timeUnit of["hours","minutes","seconds","milliseconds"]){const unit=d[timeUnit];parts.push(typeof unit==="undefined"?0:unit)}return parts}function dateTimeToExpr(d){const parts=dateTimeParts(d,true);const string=parts.join(", ");if(d.utc){return`utc(${string})`}else{return`datetime(${string})`}}function dateTimeExprToExpr(d){const parts=dateTimeParts(d,false);const string=parts.join(", ");if(d.utc){return`utc(${string})`}else{return`datetime(${string})`}}function dateTimeToTimestamp(d){const parts=dateTimeParts(d,true);if(d.utc){return+new Date(Date.UTC(...parts))}else{return+new Date(...parts)}}const LOCAL_SINGLE_TIMEUNIT_INDEX={year:1,quarter:1,month:1,week:1,day:1,dayofyear:1,date:1,hours:1,minutes:1,seconds:1,milliseconds:1};const TIMEUNIT_PARTS=keys(LOCAL_SINGLE_TIMEUNIT_INDEX);function isLocalSingleTimeUnit(timeUnit){return Object(vega_node["hasOwnProperty"])(LOCAL_SINGLE_TIMEUNIT_INDEX,timeUnit)}const UTC_SINGLE_TIMEUNIT_INDEX={utcyear:1,utcquarter:1,utcmonth:1,utcweek:1,utcday:1,utcdayofyear:1,utcdate:1,utchours:1,utcminutes:1,utcseconds:1,utcmilliseconds:1};const LOCAL_MULTI_TIMEUNIT_INDEX={yearquarter:1,yearquartermonth:1,yearmonth:1,yearmonthdate:1,yearmonthdatehours:1,yearmonthdatehoursminutes:1,yearmonthdatehoursminutesseconds:1,yearweek:1,yearweekday:1,yearweekdayhours:1,yearweekdayhoursminutes:1,yearweekdayhoursminutesseconds:1,yeardayofyear:1,quartermonth:1,monthdate:1,monthdatehours:1,monthdatehoursminutes:1,monthdatehoursminutesseconds:1,weekday:1,weekdayhours:1,weekdayhoursminutes:1,weekdayhoursminutesseconds:1,dayhours:1,dayhoursminutes:1,dayhoursminutesseconds:1,hoursminutes:1,hoursminutesseconds:1,minutesseconds:1,secondsmilliseconds:1};const BINNED_LOCAL_TIMEUNIT_INDEX={binnedyear:1,binnedyearquarter:1,binnedyearquartermonth:1,binnedyearmonth:1,binnedyearmonthdate:1,binnedyearmonthdatehours:1,binnedyearmonthdatehoursminutes:1,binnedyearmonthdatehoursminutesseconds:1,binnedyearweek:1,binnedyearweekday:1,binnedyearweekdayhours:1,binnedyearweekdayhoursminutes:1,binnedyearweekdayhoursminutesseconds:1,binnedyeardayofyear:1};const BINNED_UTC_TIMEUNIT_INDEX={binnedutcyear:1,binnedutcyearquarter:1,binnedutcyearquartermonth:1,binnedutcyearmonth:1,binnedutcyearmonthdate:1,binnedutcyearmonthdatehours:1,binnedutcyearmonthdatehoursminutes:1,binnedutcyearmonthdatehoursminutesseconds:1,binnedutcyearweek:1,binnedutcyearweekday:1,binnedutcyearweekdayhours:1,binnedutcyearweekdayhoursminutes:1,binnedutcyearweekdayhoursminutesseconds:1,binnedutcyeardayofyear:1};const BINNED_TIMEUNIT_INDEX={...BINNED_LOCAL_TIMEUNIT_INDEX,...BINNED_UTC_TIMEUNIT_INDEX};function isBinnedTimeUnit(timeUnit){if(Object(vega_util["isObject"])(timeUnit)){return timeUnit.binned}return isBinnedTimeUnitString(timeUnit)}function isBinnedTimeUnitString(timeUnit){return timeUnit&&timeUnit.startsWith("binned")}const UTC_MULTI_TIMEUNIT_INDEX={utcyearquarter:1,utcyearquartermonth:1,utcyearmonth:1,utcyearmonthdate:1,utcyearmonthdatehours:1,utcyearmonthdatehoursminutes:1,utcyearmonthdatehoursminutesseconds:1,utcyearweek:1,utcyearweekday:1,utcyearweekdayhours:1,utcyearweekdayhoursminutes:1,utcyearweekdayhoursminutesseconds:1,utcyeardayofyear:1,utcquartermonth:1,utcmonthdate:1,utcmonthdatehours:1,utcmonthdatehoursminutes:1,utcmonthdatehoursminutesseconds:1,utcweekday:1,utcweekdayhours:1,utcweekdayhoursminutes:1,utcweekdayhoursminutesseconds:1,utcdayhours:1,utcdayhoursminutes:1,utcdayhoursminutesseconds:1,utchoursminutes:1,utchoursminutesseconds:1,utcminutesseconds:1,utcsecondsmilliseconds:1};function isUTCTimeUnit(t){return t.startsWith("utc")}function getLocalTimeUnitFromUTCTimeUnit(t){return t.substring(3)}const VEGALITE_TIMEFORMAT={"year-month":"%b %Y ","year-month-date":"%b %d, %Y "};function getTimeUnitParts(timeUnit){return TIMEUNIT_PARTS.filter(part=>containsTimeUnit(timeUnit,part))}function getSmallestTimeUnitPart(timeUnit){const parts=getTimeUnitParts(timeUnit);return parts[parts.length-1]}function containsTimeUnit(fullTimeUnit,timeUnit){const index=fullTimeUnit.indexOf(timeUnit);if(index<0){return false}if(index>0&&timeUnit==="seconds"&&fullTimeUnit.charAt(index-1)==="i"){return false}if(fullTimeUnit.length>index+3&&timeUnit==="day"&&fullTimeUnit.charAt(index+3)==="o"){return false}if(index>0&&timeUnit==="year"&&fullTimeUnit.charAt(index-1)==="f"){return false}return true}function timeunit_fieldExpr(fullTimeUnit,field){let{end:end}=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{end:false};const fieldRef=accessPathWithDatum(field);const utc=isUTCTimeUnit(fullTimeUnit)?"utc":"";function func(timeUnit){if(timeUnit==="quarter"){return`(${utc}quarter(${fieldRef})-1)`}else{return`${utc}${timeUnit}(${fieldRef})`}}let lastTimeUnit;const dateExpr={};for(const part of TIMEUNIT_PARTS){if(containsTimeUnit(fullTimeUnit,part)){dateExpr[part]=func(part);lastTimeUnit=part}}if(end){dateExpr[lastTimeUnit]+="+1"}return dateTimeExprToExpr(dateExpr)}function timeUnitSpecifierExpression(timeUnit){if(!timeUnit){return undefined}const timeUnitParts=getTimeUnitParts(timeUnit);return`timeUnitSpecifier(${stringify(timeUnitParts)}, ${stringify(VEGALITE_TIMEFORMAT)})`}function formatExpression(timeUnit,field,isUTCScale){if(!timeUnit){return undefined}const expr=timeUnitSpecifierExpression(timeUnit);const utc=isUTCScale||isUTCTimeUnit(timeUnit);return`${utc?"utc":"time"}Format(${field}, ${expr})`}function normalizeTimeUnit(timeUnit){if(!timeUnit){return undefined}let params;if(Object(vega_util["isString"])(timeUnit)){if(isBinnedTimeUnitString(timeUnit)){params={unit:timeUnit.substring(6),binned:true}}else{params={unit:timeUnit}}}else if(Object(vega_util["isObject"])(timeUnit)){params={...timeUnit,...timeUnit.unit?{unit:timeUnit.unit}:{}}}if(isUTCTimeUnit(params.unit)){params.utc=true;params.unit=getLocalTimeUnitFromUTCTimeUnit(params.unit)}return params}function timeUnitToString(tu){const{utc:utc,...rest}=normalizeTimeUnit(tu);if(rest.unit){return(utc?"utc":"")+keys(rest).map(p=>varName(`${p==="unit"?"":`_${p}_`}${rest[p]}`)).join("")}else{return(utc?"utc":"")+"timeunit"+keys(rest).map(p=>varName(`_${p}_${rest[p]}`)).join("")}}function durationExpr(timeUnit){let wrap=arguments.length>1&&arguments[1]!==undefined?arguments[1]:x=>x;const normalizedTimeUnit=normalizeTimeUnit(timeUnit);const smallestUnitPart=getSmallestTimeUnitPart(normalizedTimeUnit.unit);if(smallestUnitPart&&smallestUnitPart!=="day"){const startDate={year:2001,month:1,date:1,hours:0,minutes:0,seconds:0,milliseconds:0};const{step:step,part:part}=getDateTimePartAndStep(smallestUnitPart,normalizedTimeUnit.step);const endDate={...startDate,[part]:+startDate[part]+step};return`${wrap(dateTimeToExpr(endDate))} - ${wrap(dateTimeToExpr(startDate))}`}return undefined}const DATE_PARTS={year:1,month:1,date:1,hours:1,minutes:1,seconds:1,milliseconds:1};function isDatePart(timeUnit){return Object(vega_node["hasOwnProperty"])(DATE_PARTS,timeUnit)}function getDateTimePartAndStep(timeUnit){let step=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;if(isDatePart(timeUnit)){return{part:timeUnit,step:step}}switch(timeUnit){case"day":case"dayofyear":return{part:"date",step:step};case"quarter":return{part:"month",step:step*3};case"week":return{part:"date",step:step*7}}}function isSelectionPredicate(predicate){return hasProperty(predicate,"param")}function isFieldEqualPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&predicate.equal!==undefined}function isFieldLTPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&predicate.lt!==undefined}function isFieldLTEPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&predicate.lte!==undefined}function isFieldGTPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&predicate.gt!==undefined}function isFieldGTEPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&predicate.gte!==undefined}function isFieldRangePredicate(predicate){if(predicate!==null&&predicate!==void 0&&predicate.field){if(Object(vega_util["isArray"])(predicate.range)&&predicate.range.length===2){return true}else if(isSignalRef(predicate.range)){return true}}return false}function isFieldOneOfPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&(Object(vega_util["isArray"])(predicate.oneOf)||Object(vega_util["isArray"])(predicate.in))}function isFieldValidPredicate(predicate){return!!(predicate!==null&&predicate!==void 0&&predicate.field)&&predicate.valid!==undefined}function isFieldPredicate(predicate){return isFieldOneOfPredicate(predicate)||isFieldEqualPredicate(predicate)||isFieldRangePredicate(predicate)||isFieldLTPredicate(predicate)||isFieldGTPredicate(predicate)||isFieldLTEPredicate(predicate)||isFieldGTEPredicate(predicate)}function predicateValueExpr(v,timeUnit){return valueExpr(v,{timeUnit:timeUnit,wrapTime:true})}function predicateValuesExpr(vals,timeUnit){return vals.map(v=>predicateValueExpr(v,timeUnit))}function fieldFilterExpression(predicate){let useInRange=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;const{field:field}=predicate;const normalizedTimeUnit=normalizeTimeUnit(predicate.timeUnit);const{unit:unit,binned:binned}=normalizedTimeUnit||{};const rawFieldExpr=vgField(predicate,{expr:"datum"});const fieldExpr=unit?`time(${!binned?timeunit_fieldExpr(unit,field):rawFieldExpr})`:rawFieldExpr;if(isFieldEqualPredicate(predicate)){return`${fieldExpr}===${predicateValueExpr(predicate.equal,unit)}`}else if(isFieldLTPredicate(predicate)){const upper=predicate.lt;return`${fieldExpr}<${predicateValueExpr(upper,unit)}`}else if(isFieldGTPredicate(predicate)){const lower=predicate.gt;return`${fieldExpr}>${predicateValueExpr(lower,unit)}`}else if(isFieldLTEPredicate(predicate)){const upper=predicate.lte;return`${fieldExpr}<=${predicateValueExpr(upper,unit)}`}else if(isFieldGTEPredicate(predicate)){const lower=predicate.gte;return`${fieldExpr}>=${predicateValueExpr(lower,unit)}`}else if(isFieldOneOfPredicate(predicate)){return`indexof([${predicateValuesExpr(predicate.oneOf,unit).join(",")}], ${fieldExpr}) !== -1`}else if(isFieldValidPredicate(predicate)){return fieldValidPredicate(fieldExpr,predicate.valid)}else if(isFieldRangePredicate(predicate)){const{range:range}=replaceExprRef(predicate);const lower=isSignalRef(range)?{signal:`${range.signal}[0]`}:range[0];const upper=isSignalRef(range)?{signal:`${range.signal}[1]`}:range[1];if(lower!==null&&upper!==null&&useInRange){return"inrange("+fieldExpr+", ["+predicateValueExpr(lower,unit)+", "+predicateValueExpr(upper,unit)+"])"}const exprs=[];if(lower!==null){exprs.push(`${fieldExpr} >= ${predicateValueExpr(lower,unit)}`)}if(upper!==null){exprs.push(`${fieldExpr} <= ${predicateValueExpr(upper,unit)}`)}return exprs.length>0?exprs.join(" && "):"true"}throw new Error(`Invalid field predicate: ${stringify(predicate)}`)}function fieldValidPredicate(fieldExpr){let valid=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;if(valid){return`isValid(${fieldExpr}) && isFinite(+${fieldExpr})`}else{return`!isValid(${fieldExpr}) || !isFinite(+${fieldExpr})`}}function normalizePredicate(f){if(isFieldPredicate(f)&&f.timeUnit){return{...f,timeUnit:normalizeTimeUnit(f.timeUnit)}}return f}const Type={quantitative:"quantitative",ordinal:"ordinal",temporal:"temporal",nominal:"nominal",geojson:"geojson"};function isType(t){return Object(vega_util["hasOwnProperty"])(Type,t)}function isContinuous(type){return type==="quantitative"||type==="temporal"}function isDiscrete(type){return type==="ordinal"||type==="nominal"}const QUANTITATIVE=Type.quantitative;const ORDINAL=Type.ordinal;const TEMPORAL=Type.temporal;const NOMINAL=Type.nominal;const GEOJSON=Type.geojson;const TYPES=keys(Type);function getFullName(type){if(type){type=type.toLowerCase();switch(type){case"q":case QUANTITATIVE:return"quantitative";case"t":case TEMPORAL:return"temporal";case"o":case ORDINAL:return"ordinal";case"n":case NOMINAL:return"nominal";case GEOJSON:return"geojson"}}return undefined}const ScaleType={LINEAR:"linear",LOG:"log",POW:"pow",SQRT:"sqrt",SYMLOG:"symlog",IDENTITY:"identity",SEQUENTIAL:"sequential",TIME:"time",UTC:"utc",QUANTILE:"quantile",QUANTIZE:"quantize",THRESHOLD:"threshold",BIN_ORDINAL:"bin-ordinal",ORDINAL:"ordinal",POINT:"point",BAND:"band"};const SCALE_CATEGORY_INDEX={linear:"numeric",log:"numeric",pow:"numeric",sqrt:"numeric",symlog:"numeric",identity:"numeric",sequential:"numeric",time:"time",utc:"time",ordinal:"ordinal","bin-ordinal":"bin-ordinal",point:"ordinal-position",band:"ordinal-position",quantile:"discretizing",quantize:"discretizing",threshold:"discretizing"};const SCALE_TYPES=keys(SCALE_CATEGORY_INDEX);function scaleCompatible(scaleType1,scaleType2){const scaleCategory1=SCALE_CATEGORY_INDEX[scaleType1];const scaleCategory2=SCALE_CATEGORY_INDEX[scaleType2];return scaleCategory1===scaleCategory2||scaleCategory1==="ordinal-position"&&scaleCategory2==="time"||scaleCategory2==="ordinal-position"&&scaleCategory1==="time"}const SCALE_PRECEDENCE_INDEX={linear:0,log:1,pow:1,sqrt:1,symlog:1,identity:1,sequential:1,time:0,utc:0,point:10,band:11,ordinal:0,"bin-ordinal":0,quantile:0,quantize:0,threshold:0};function scaleTypePrecedence(scaleType){return SCALE_PRECEDENCE_INDEX[scaleType]}const QUANTITATIVE_SCALES=new Set(["linear","log","pow","sqrt","symlog"]);const CONTINUOUS_TO_CONTINUOUS_SCALES=new Set([...QUANTITATIVE_SCALES,"time","utc"]);function isQuantitative(type){return QUANTITATIVE_SCALES.has(type)}const CONTINUOUS_TO_DISCRETE_SCALES=new Set(["quantile","quantize","threshold"]);const CONTINUOUS_DOMAIN_SCALES=new Set([...CONTINUOUS_TO_CONTINUOUS_SCALES,...CONTINUOUS_TO_DISCRETE_SCALES,"sequential","identity"]);const DISCRETE_DOMAIN_SCALES=new Set(["ordinal","bin-ordinal","point","band"]);const TIME_SCALE_TYPES=new Set(["time","utc"]);function hasDiscreteDomain(type){return DISCRETE_DOMAIN_SCALES.has(type)}function hasContinuousDomain(type){return CONTINUOUS_DOMAIN_SCALES.has(type)}function isContinuousToContinuous(type){return CONTINUOUS_TO_CONTINUOUS_SCALES.has(type)}function isContinuousToDiscrete(type){return CONTINUOUS_TO_DISCRETE_SCALES.has(type)}const defaultScaleConfig={pointPadding:.5,barBandPaddingInner:.1,rectBandPaddingInner:0,tickBandPaddingInner:.25,bandWithNestedOffsetPaddingInner:.2,bandWithNestedOffsetPaddingOuter:.2,minBandSize:2,minFontSize:8,maxFontSize:40,minOpacity:.3,maxOpacity:.8,minSize:4,minStrokeWidth:1,maxStrokeWidth:4,quantileCount:4,quantizeCount:4,zero:true,framesPerSecond:2,animationDuration:5};function isExtendedScheme(scheme){return!Object(vega_util["isString"])(scheme)&&hasProperty(scheme,"name")}function isParameterDomain(domain){return hasProperty(domain,"param")}function isDomainUnionWith(domain){return hasProperty(domain,"unionWith")}function isFieldRange(range){return Object(vega_util["isObject"])(range)&&"field"in range}const SCALE_PROPERTY_INDEX={type:1,domain:1,domainMax:1,domainMin:1,domainMid:1,domainRaw:1,align:1,range:1,rangeMax:1,rangeMin:1,scheme:1,bins:1,reverse:1,round:1,clamp:1,nice:1,base:1,exponent:1,constant:1,interpolate:1,zero:1,padding:1,paddingInner:1,paddingOuter:1};const SCALE_PROPERTIES=keys(SCALE_PROPERTY_INDEX);const{type:scale_type,domain:scale_domain,range:scale_range,rangeMax:scale_rangeMax,rangeMin:scale_rangeMin,scheme:scale_scheme,...NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTY_INDEX}=SCALE_PROPERTY_INDEX;const NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTIES=keys(NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTY_INDEX);function scaleTypeSupportProperty(scaleType,propName){switch(propName){case"type":case"domain":case"reverse":case"range":return true;case"scheme":case"interpolate":return!["point","band","identity"].includes(scaleType);case"bins":return!["point","band","identity","ordinal"].includes(scaleType);case"round":return isContinuousToContinuous(scaleType)||scaleType==="band"||scaleType==="point";case"padding":case"rangeMin":case"rangeMax":return isContinuousToContinuous(scaleType)||["point","band"].includes(scaleType);case"paddingOuter":case"align":return["point","band"].includes(scaleType);case"paddingInner":return scaleType==="band";case"domainMax":case"domainMid":case"domainMin":case"domainRaw":case"clamp":return isContinuousToContinuous(scaleType);case"nice":return isContinuousToContinuous(scaleType)||scaleType==="quantize"||scaleType==="threshold";case"exponent":return scaleType==="pow";case"base":return scaleType==="log";case"constant":return scaleType==="symlog";case"zero":return hasContinuousDomain(scaleType)&&!util_contains(["log","time","utc","threshold","quantile"],scaleType)}}function channelScalePropertyIncompatability(channel,propName){switch(propName){case"interpolate":case"scheme":case"domainMid":if(!isColorChannel(channel)){return message_namespaceObject.cannotUseScalePropertyWithNonColor(propName)}return undefined;case"align":case"type":case"bins":case"domain":case"domainMax":case"domainMin":case"domainRaw":case"range":case"base":case"exponent":case"constant":case"nice":case"padding":case"paddingInner":case"paddingOuter":case"rangeMax":case"rangeMin":case"reverse":case"round":case"clamp":case"zero":return undefined}}function scaleTypeSupportDataType(specifiedType,fieldDefType){if(util_contains([ORDINAL,NOMINAL],fieldDefType)){return specifiedType===undefined||hasDiscreteDomain(specifiedType)}else if(fieldDefType===TEMPORAL){return util_contains([ScaleType.TIME,ScaleType.UTC,undefined],specifiedType)}else if(fieldDefType===QUANTITATIVE){return isQuantitative(specifiedType)||isContinuousToDiscrete(specifiedType)||specifiedType===undefined}return true}function channelSupportScaleType(channel,scaleType){let hasNestedOffsetScale=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;if(!isScaleChannel(channel)){return false}switch(channel){case X:case Y:case XOFFSET:case YOFFSET:case THETA:case RADIUS:if(isContinuousToContinuous(scaleType)){return true}else if(scaleType==="band"){return true}else if(scaleType==="point"){return!hasNestedOffsetScale}return false;case TIME:return util_contains(["linear","band"],scaleType);case SIZE:case STROKEWIDTH:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case ANGLE:return isContinuousToContinuous(scaleType)||isContinuousToDiscrete(scaleType)||util_contains(["band","point","ordinal"],scaleType);case COLOR:case FILL:case STROKE:return scaleType!=="band";case STROKEDASH:case SHAPE:return scaleType==="ordinal"||isContinuousToDiscrete(scaleType)}}function isScaleInvalidDataIncludeAsValue(invalidDataMode){return Object(vega_util["isObject"])(invalidDataMode)&&"value"in invalidDataMode}const Mark={arc:"arc",area:"area",bar:"bar",image:"image",line:"line",point:"point",rect:"rect",rule:"rule",text:"text",tick:"tick",trail:"trail",circle:"circle",square:"square",geoshape:"geoshape"};const ARC=Mark.arc;const AREA=Mark.area;const BAR=Mark.bar;const IMAGE=Mark.image;const LINE=Mark.line;const POINT=Mark.point;const RECT=Mark.rect;const RULE=Mark.rule;const mark_TEXT=Mark.text;const TICK=Mark.tick;const TRAIL=Mark.trail;const CIRCLE=Mark.circle;const SQUARE=Mark.square;const GEOSHAPE=Mark.geoshape;function isMark(m){return Object(vega_util["hasOwnProperty"])(Mark,m)}const PATH_MARKS=["line","area","trail"];function isPathMark(m){return["line","area","trail"].includes(m)}function isRectBasedMark(m){return["rect","bar","image","arc","tick"].includes(m)}const PRIMITIVE_MARKS=new Set(keys(Mark));function isMarkDef(mark){return hasProperty(mark,"type")}function isPrimitiveMark(mark){const markType=isMarkDef(mark)?mark.type:mark;return PRIMITIVE_MARKS.has(markType)}const STROKE_CONFIG=["stroke","strokeWidth","strokeDash","strokeDashOffset","strokeOpacity","strokeJoin","strokeMiterLimit"];const FILL_CONFIG=["fill","fillOpacity"];const FILL_STROKE_CONFIG=[...STROKE_CONFIG,...FILL_CONFIG];const VL_ONLY_MARK_CONFIG_INDEX={color:1,filled:1,invalid:1,order:1,radius2:1,theta2:1,timeUnitBandSize:1,timeUnitBandPosition:1};const VL_ONLY_MARK_CONFIG_PROPERTIES=keys(VL_ONLY_MARK_CONFIG_INDEX);const VL_ONLY_RECT_CONFIG=["binSpacing","continuousBandSize","discreteBandSize","minBandSize"];const VL_ONLY_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX={area:["line","point"],bar:VL_ONLY_RECT_CONFIG,rect:VL_ONLY_RECT_CONFIG,line:["point"],tick:["bandSize","thickness",...VL_ONLY_RECT_CONFIG]};const defaultMarkConfig={color:"#4c78a8",invalid:"break-paths-show-path-domains",timeUnitBandSize:1};const MARK_CONFIG_INDEX={mark:1,arc:1,area:1,bar:1,circle:1,image:1,line:1,point:1,rect:1,rule:1,square:1,text:1,tick:1,trail:1,geoshape:1};const MARK_CONFIGS=keys(MARK_CONFIG_INDEX);function isRelativeBandSize(o){return hasProperty(o,"band")}const BAR_CORNER_RADIUS_INDEX={horizontal:["cornerRadiusTopRight","cornerRadiusBottomRight"],vertical:["cornerRadiusTopLeft","cornerRadiusTopRight"]};const DEFAULT_RECT_BAND_SIZE=5;const defaultRectConfig={binSpacing:0,continuousBandSize:DEFAULT_RECT_BAND_SIZE,minBandSize:.25,timeUnitBandPosition:.5};const defaultBarConfig={...defaultRectConfig,binSpacing:1};const defaultTickConfig={...defaultRectConfig,thickness:1};function getMarkType(m){return isMarkDef(m)?m.type:m}function normalizeInvalidDataMode(mode,_ref){let{isPath:isPath}=_ref;if(mode===undefined||mode==="break-paths-show-path-domains"){return isPath?"break-paths-show-domains":"filter"}else if(mode===null){return"show"}return mode}function getScaleInvalidDataMode(_ref){var _config$scale;let{markDef:markDef,config:config,scaleChannel:scaleChannel,scaleType:scaleType,isCountAggregate:isCountAggregate}=_ref;if(!scaleType||!hasContinuousDomain(scaleType)||isCountAggregate){return"always-valid"}const invalidMode=normalizeInvalidDataMode(getMarkPropOrConfig("invalid",markDef,config),{isPath:isPathMark(markDef.type)});const scaleOutputForInvalid=(_config$scale=config.scale)===null||_config$scale===void 0||(_config$scale=_config$scale.invalid)===null||_config$scale===void 0?void 0:_config$scale[scaleChannel];if(scaleOutputForInvalid!==undefined){return"show"}return invalidMode}function shouldBreakPath(mode){return mode==="break-paths-filter-domains"||mode==="break-paths-show-domains"}function scaledZeroOrMinOrMax(_ref){let{scaleName:scaleName,scale:scale,mode:mode}=_ref;const domain=`domain('${scaleName}')`;if(!scale||!scaleName){return undefined}const min=`${domain}[0]`;const max=`peek(${domain})`;const domainHasZero=scale.domainHasZero();if(domainHasZero==="definitely"){return{scale:scaleName,value:0}}else if(domainHasZero==="maybe"){const nonZeroValue=mode==="zeroOrMin"?min:max;return{signal:`scale('${scaleName}', inrange(0, ${domain}) ? 0 : ${nonZeroValue})`}}else{return{signal:`scale('${scaleName}', ${mode==="zeroOrMin"?min:max})`}}}function getConditionalValueRefForIncludingInvalidValue(_ref){let{scaleChannel:scaleChannel,channelDef:channelDef,scale:scale,scaleName:scaleName,markDef:markDef,config:config}=_ref;const scaleType=scale===null||scale===void 0?void 0:scale.get("type");const fieldDef=getFieldDef(channelDef);const isCountAggregate=isCountingAggregateOp(fieldDef===null||fieldDef===void 0?void 0:fieldDef.aggregate);const invalidDataMode=getScaleInvalidDataMode({scaleChannel:scaleChannel,markDef:markDef,config:config,scaleType:scaleType,isCountAggregate:isCountAggregate});if(fieldDef&&invalidDataMode==="show"){var _config$scale$invalid,_config$scale$invalid2;const includeAs=(_config$scale$invalid=(_config$scale$invalid2=config.scale.invalid)===null||_config$scale$invalid2===void 0?void 0:_config$scale$invalid2[scaleChannel])!==null&&_config$scale$invalid!==void 0?_config$scale$invalid:"zero-or-min";return{test:fieldValidPredicate(vgField(fieldDef,{expr:"datum"}),false),...refForInvalidValues(includeAs,scale,scaleName)}}return undefined}function refForInvalidValues(includeAs,scale,scaleName){if(isScaleInvalidDataIncludeAsValue(includeAs)){const{value:value}=includeAs;return isSignalRef(value)?{signal:value.signal}:{value:value}}return scaledZeroOrMinOrMax({scale:scale,scaleName:scaleName,mode:"zeroOrMin"})}function midPointRefWithPositionInvalidTest(params){const{channel:channel,channelDef:channelDef,markDef:markDef,scale:scale,scaleName:scaleName,config:config}=params;const scaleChannel=getMainRangeChannel(channel);const mainRef=midPoint(params);const valueRefForIncludingInvalid=getConditionalValueRefForIncludingInvalidValue({scaleChannel:scaleChannel,channelDef:channelDef,scale:scale,scaleName:scaleName,markDef:markDef,config:config});return valueRefForIncludingInvalid!==undefined?[valueRefForIncludingInvalid,mainRef]:mainRef}function datumDefToExpr(datumDef){const{datum:datum}=datumDef;if(isDateTime(datum)){return dateTimeToExpr(datum)}return`${stringify(datum)}`}function valueRefForFieldOrDatumDef(fieldDef,scaleName,opt,encode){const ref={};if(scaleName){ref.scale=scaleName}if(isDatumDef(fieldDef)){const{datum:datum}=fieldDef;if(isDateTime(datum)){ref.signal=dateTimeToExpr(datum)}else if(isSignalRef(datum)){ref.signal=datum.signal}else if(isExprRef(datum)){ref.signal=datum.expr}else{ref.value=datum}}else{ref.field=vgField(fieldDef,opt)}if(encode){const{offset:offset,band:band}=encode;if(offset){ref.offset=offset}if(band){ref.band=band}}return ref}function interpolatedSignalRef(_ref){let{scaleName:scaleName,fieldOrDatumDef:fieldOrDatumDef,fieldOrDatumDef2:fieldOrDatumDef2,offset:offset,startSuffix:startSuffix,endSuffix:endSuffix="end",bandPosition:bandPosition=.5}=_ref;const expr=!isSignalRef(bandPosition)&&0<bandPosition&&bandPosition<1?"datum":undefined;const start=vgField(fieldOrDatumDef,{expr:expr,suffix:startSuffix});const end=fieldOrDatumDef2!==undefined?vgField(fieldOrDatumDef2,{expr:expr}):vgField(fieldOrDatumDef,{suffix:endSuffix,expr:expr});const ref={};if(bandPosition===0||bandPosition===1){ref.scale=scaleName;const field=bandPosition===0?start:end;ref.field=field}else{const datum=isSignalRef(bandPosition)?`(1-${bandPosition.signal}) * ${start} + ${bandPosition.signal} * ${end}`:`${1-bandPosition} * ${start} + ${bandPosition} * ${end}`;ref.signal=`scale("${scaleName}", ${datum})`}if(offset){ref.offset=offset}return ref}function binSizeExpr(_ref2){let{scaleName:scaleName,fieldDef:fieldDef}=_ref2;const start=vgField(fieldDef,{expr:"datum"});const end=vgField(fieldDef,{expr:"datum",suffix:"end"});return`abs(scale("${scaleName}", ${end}) - scale("${scaleName}", ${start}))`}function midPoint(_ref3){let{channel:channel,channelDef:channelDef,channel2Def:channel2Def,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:defaultRef,bandPosition:bandPosition}=_ref3;if(channelDef){if(isFieldOrDatumDef(channelDef)){var _ref4,_bandPosition2;const scaleType=scale===null||scale===void 0?void 0:scale.get("type");if(isTypedFieldDef(channelDef)){var _bandPosition;(_bandPosition=bandPosition)!==null&&_bandPosition!==void 0?_bandPosition:bandPosition=getBandPosition({fieldDef:channelDef,fieldDef2:channel2Def,markDef:markDef,config:config});const{bin:bin,timeUnit:timeUnit,type:type}=channelDef;if(isBinning(bin)||bandPosition&&timeUnit&&type===TEMPORAL){if(stack!==null&&stack!==void 0&&stack.impute){return valueRefForFieldOrDatumDef(channelDef,scaleName,{binSuffix:"mid"},{offset:offset})}if(bandPosition&&!hasDiscreteDomain(scaleType)){return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:channelDef,bandPosition:bandPosition,offset:offset})}return valueRefForFieldOrDatumDef(channelDef,scaleName,binRequiresRange(channelDef,channel)?{binSuffix:"range"}:{},{offset:offset})}else if(isBinned(bin)){if(isFieldDef(channel2Def)){return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:channelDef,fieldOrDatumDef2:channel2Def,bandPosition:bandPosition,offset:offset})}else{const channel2=channel===X?X2:Y2;warn(message_namespaceObject.channelRequiredForBinned(channel2))}}}return valueRefForFieldOrDatumDef(channelDef,scaleName,hasDiscreteDomain(scaleType)?{binSuffix:"range"}:{},{offset:offset,band:scaleType==="band"?(_ref4=(_bandPosition2=bandPosition)!==null&&_bandPosition2!==void 0?_bandPosition2:channelDef.bandPosition)!==null&&_ref4!==void 0?_ref4:.5:undefined})}else if(isValueDef(channelDef)){const value=channelDef.value;const offsetMixins=offset?{offset:offset}:{};return{...widthHeightValueOrSignalRef(channel,value),...offsetMixins}}}if(Object(vega_util["isFunction"])(defaultRef)){defaultRef=defaultRef()}if(defaultRef){return{...defaultRef,...offset?{offset:offset}:{}}}return defaultRef}function widthHeightValueOrSignalRef(channel,value){if(util_contains(["x","x2"],channel)&&value==="width"){return{field:{group:"width"}}}else if(util_contains(["y","y2"],channel)&&value==="height"){return{field:{group:"height"}}}return signalOrValueRef(value)}function isCustomFormatType(formatType){return formatType&&formatType!=="number"&&formatType!=="time"}function customFormatExpr(formatType,field,format){return`${formatType}(${field}${format?`, ${stringify(format)}`:""})`}const format_BIN_RANGE_DELIMITER=" – ";function formatSignalRef(_ref){let{fieldOrDatumDef:fieldOrDatumDef,format:format,formatType:formatType,expr:expr,normalizeStack:normalizeStack,config:config}=_ref;if(isCustomFormatType(formatType)){return formatCustomType({fieldOrDatumDef:fieldOrDatumDef,format:format,formatType:formatType,expr:expr,config:config})}const field=fieldToFormat(fieldOrDatumDef,expr,normalizeStack);const type=channelDefType(fieldOrDatumDef);if(format===undefined&&formatType===undefined&&config.customFormatTypes){if(type==="quantitative"){if(normalizeStack&&config.normalizedNumberFormatType)return formatCustomType({fieldOrDatumDef:fieldOrDatumDef,format:config.normalizedNumberFormat,formatType:config.normalizedNumberFormatType,expr:expr,config:config});if(config.numberFormatType){return formatCustomType({fieldOrDatumDef:fieldOrDatumDef,format:config.numberFormat,formatType:config.numberFormatType,expr:expr,config:config})}}if(type==="temporal"&&config.timeFormatType&&isFieldDef(fieldOrDatumDef)&&fieldOrDatumDef.timeUnit===undefined){return formatCustomType({fieldOrDatumDef:fieldOrDatumDef,format:config.timeFormat,formatType:config.timeFormatType,expr:expr,config:config})}}if(isFieldOrDatumDefForTimeFormat(fieldOrDatumDef)){var _normalizeTimeUnit,_fieldOrDatumDef$scal;const signal=timeFormatExpression({field:field,timeUnit:isFieldDef(fieldOrDatumDef)?(_normalizeTimeUnit=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit:undefined,format:format,formatType:config.timeFormatType,rawTimeFormat:config.timeFormat,isUTCScale:isScaleFieldDef(fieldOrDatumDef)&&((_fieldOrDatumDef$scal=fieldOrDatumDef.scale)===null||_fieldOrDatumDef$scal===void 0?void 0:_fieldOrDatumDef$scal.type)===ScaleType.UTC});return signal?{signal:signal}:undefined}format=numberFormat({type:type,specifiedFormat:format,config:config,normalizeStack:normalizeStack});if(isFieldDef(fieldOrDatumDef)&&isBinning(fieldOrDatumDef.bin)){const endField=vgField(fieldOrDatumDef,{expr:expr,binSuffix:"end"});return{signal:binFormatExpression(field,endField,format,formatType,config)}}else if(format||channelDefType(fieldOrDatumDef)==="quantitative"){return{signal:`${formatExpr(field,format)}`}}else{return{signal:`isValid(${field}) ? ${field} : ""+${field}`}}}function fieldToFormat(fieldOrDatumDef,expr,normalizeStack){if(isFieldDef(fieldOrDatumDef)){if(normalizeStack){return`${vgField(fieldOrDatumDef,{expr:expr,suffix:"end"})}-${vgField(fieldOrDatumDef,{expr:expr,suffix:"start"})}`}else{return vgField(fieldOrDatumDef,{expr:expr})}}else{return datumDefToExpr(fieldOrDatumDef)}}function formatCustomType(_ref2){var _field;let{fieldOrDatumDef:fieldOrDatumDef,format:format,formatType:formatType,expr:expr,normalizeStack:normalizeStack,config:config,field:field}=_ref2;(_field=field)!==null&&_field!==void 0?_field:field=fieldToFormat(fieldOrDatumDef,expr,normalizeStack);if(field!=="datum.value"&&isFieldDef(fieldOrDatumDef)&&isBinning(fieldOrDatumDef.bin)){const endField=vgField(fieldOrDatumDef,{expr:expr,binSuffix:"end"});return{signal:binFormatExpression(field,endField,format,formatType,config)}}return{signal:customFormatExpr(formatType,field,format)}}function guideFormat(fieldOrDatumDef,type,format,formatType,config,omitTimeFormatConfig){if(Object(vega_util["isString"])(formatType)&&isCustomFormatType(formatType)){return undefined}else if(format===undefined&&formatType===undefined&&config.customFormatTypes){if(channelDefType(fieldOrDatumDef)==="quantitative"){if(config.normalizedNumberFormatType&&isPositionFieldOrDatumDef(fieldOrDatumDef)&&fieldOrDatumDef.stack==="normalize"){return undefined}if(config.numberFormatType){return undefined}}}if(isPositionFieldOrDatumDef(fieldOrDatumDef)&&fieldOrDatumDef.stack==="normalize"&&config.normalizedNumberFormat){return numberFormat({type:"quantitative",config:config,normalizeStack:true})}if(isFieldOrDatumDefForTimeFormat(fieldOrDatumDef)){var _normalizeTimeUnit2;const timeUnit=isFieldDef(fieldOrDatumDef)?(_normalizeTimeUnit2=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit2===void 0?void 0:_normalizeTimeUnit2.unit:undefined;if(timeUnit===undefined&&config.customFormatTypes&&config.timeFormatType){return undefined}return timeFormat({specifiedFormat:format,timeUnit:timeUnit,config:config,omitTimeFormatConfig:omitTimeFormatConfig})}return numberFormat({type:type,specifiedFormat:format,config:config})}function guideFormatType(formatType,fieldOrDatumDef,scaleType){if(formatType&&(isSignalRef(formatType)||formatType==="number"||formatType==="time")){return formatType}if(isFieldOrDatumDefForTimeFormat(fieldOrDatumDef)&&scaleType!=="time"&&scaleType!=="utc"){var _normalizeTimeUnit3;return isFieldDef(fieldOrDatumDef)&&(_normalizeTimeUnit3=normalizeTimeUnit(fieldOrDatumDef===null||fieldOrDatumDef===void 0?void 0:fieldOrDatumDef.timeUnit))!==null&&_normalizeTimeUnit3!==void 0&&_normalizeTimeUnit3.utc?"utc":"time"}return undefined}function numberFormat(_ref3){let{type:type,specifiedFormat:specifiedFormat,config:config,normalizeStack:normalizeStack}=_ref3;if(Object(vega_util["isString"])(specifiedFormat)){return specifiedFormat}if(type===QUANTITATIVE){return normalizeStack?config.normalizedNumberFormat:config.numberFormat}return undefined}function timeFormat(_ref4){let{specifiedFormat:specifiedFormat,timeUnit:timeUnit,config:config,omitTimeFormatConfig:omitTimeFormatConfig}=_ref4;if(specifiedFormat){return specifiedFormat}if(timeUnit){return{signal:timeUnitSpecifierExpression(timeUnit)}}return omitTimeFormatConfig?undefined:config.timeFormat}function formatExpr(field,format){return`format(${field}, "${format||""}")`}function binNumberFormatExpr(field,format,formatType,config){var _ref5;if(isCustomFormatType(formatType)){return customFormatExpr(formatType,field,format)}return formatExpr(field,(_ref5=Object(vega_util["isString"])(format)?format:undefined)!==null&&_ref5!==void 0?_ref5:config.numberFormat)}function binFormatExpression(startField,endField,format,formatType,config){if(format===undefined&&formatType===undefined&&config.customFormatTypes&&config.numberFormatType){return binFormatExpression(startField,endField,config.numberFormat,config.numberFormatType,config)}const start=binNumberFormatExpr(startField,format,formatType,config);const end=binNumberFormatExpr(endField,format,formatType,config);return`${fieldValidPredicate(startField,false)} ? "null" : ${start} + "${format_BIN_RANGE_DELIMITER}" + ${end}`}function timeFormatExpression(_ref6){let{field:field,timeUnit:timeUnit,format:format,formatType:formatType,rawTimeFormat:rawTimeFormat,isUTCScale:isUTCScale}=_ref6;if(!timeUnit||format){if(!timeUnit&&formatType){return`${formatType}(${field}, '${format}')`}format=Object(vega_util["isString"])(format)?format:rawTimeFormat;return`${isUTCScale?"utc":"time"}Format(${field}, '${format}')`}else{return formatExpression(timeUnit,field,isUTCScale)}}const DEFAULT_SORT_OP="min";const SORT_BY_CHANNEL_INDEX={x:1,y:1,color:1,fill:1,stroke:1,strokeWidth:1,size:1,shape:1,fillOpacity:1,strokeOpacity:1,opacity:1,text:1};function isSortByChannel(c){return Object(vega_util["hasOwnProperty"])(SORT_BY_CHANNEL_INDEX,c)}function isSortByEncoding(sort){return hasProperty(sort,"encoding")}function isSortField(sort){return sort&&(sort.op==="count"||hasProperty(sort,"field"))}function isSortArray(sort){return sort&&Object(vega_util["isArray"])(sort)}function isFacetMapping(f){return hasProperty(f,"row")||hasProperty(f,"column")}function isFacetFieldDef(channelDef){return hasProperty(channelDef,"header")}function isFacetSpec(spec){return hasProperty(spec,"facet")}function isConditionalParameter(c){return hasProperty(c,"param")}function isRepeatRef(field){return!Object(vega_util["isString"])(field)&&hasProperty(field,"repeat")}function toFieldDefBase(fieldDef){const{field:field,timeUnit:timeUnit,bin:bin,aggregate:aggregate}=fieldDef;return{...timeUnit?{timeUnit:timeUnit}:{},...bin?{bin:bin}:{},...aggregate?{aggregate:aggregate}:{},field:field}}function isSortableFieldDef(fieldDef){return hasProperty(fieldDef,"sort")}function getBandPosition(_ref){let{fieldDef:fieldDef,fieldDef2:fieldDef2,markDef:mark,config:config}=_ref;if(isFieldOrDatumDef(fieldDef)&&fieldDef.bandPosition!==undefined){return fieldDef.bandPosition}if(isFieldDef(fieldDef)){const{timeUnit:timeUnit,bin:bin}=fieldDef;if(timeUnit&&!fieldDef2){return getMarkConfig("timeUnitBandPosition",mark,config)}else if(isBinning(bin)){return.5}}return undefined}function getBandSize(_ref2){let{channel:channel,fieldDef:fieldDef,fieldDef2:fieldDef2,markDef:mark,config:config,scaleType:scaleType,useVlSizeChannel:useVlSizeChannel}=_ref2;const sizeChannel=getSizeChannel(channel);const size=getMarkPropOrConfig(useVlSizeChannel?"size":sizeChannel,mark,config,{vgChannel:sizeChannel});if(size!==undefined){return size}if(isFieldDef(fieldDef)){const{timeUnit:timeUnit,bin:bin}=fieldDef;if(timeUnit&&!fieldDef2){return{band:getMarkConfig("timeUnitBandSize",mark,config)}}else if(isBinning(bin)&&!hasDiscreteDomain(scaleType)){return{band:1}}}if(isRectBasedMark(mark.type)){var _config$mark$type3;if(scaleType){if(hasDiscreteDomain(scaleType)){var _config$mark$type;return((_config$mark$type=config[mark.type])===null||_config$mark$type===void 0?void 0:_config$mark$type.discreteBandSize)||{band:1}}else{var _config$mark$type2;return(_config$mark$type2=config[mark.type])===null||_config$mark$type2===void 0?void 0:_config$mark$type2.continuousBandSize}}return(_config$mark$type3=config[mark.type])===null||_config$mark$type3===void 0?void 0:_config$mark$type3.discreteBandSize}return undefined}function hasBandEnd(fieldDef,fieldDef2,markDef,config){if(isBinning(fieldDef.bin)||fieldDef.timeUnit&&isTypedFieldDef(fieldDef)&&fieldDef.type==="temporal"){return getBandPosition({fieldDef:fieldDef,fieldDef2:fieldDef2,markDef:markDef,config:config})!==undefined}return false}function isOrderOnlyDef(orderDef){return hasProperty(orderDef,"sort")&&!hasProperty(orderDef,"field")}function isConditionalDef(channelDef){return hasProperty(channelDef,"condition")}function hasConditionalFieldDef(channelDef){const condition=channelDef===null||channelDef===void 0?void 0:channelDef["condition"];return!!condition&&!Object(vega_util["isArray"])(condition)&&isFieldDef(condition)}function hasConditionalFieldOrDatumDef(channelDef){const condition=channelDef===null||channelDef===void 0?void 0:channelDef["condition"];return!!condition&&!Object(vega_util["isArray"])(condition)&&isFieldOrDatumDef(condition)}function hasConditionalValueDef(channelDef){const condition=channelDef===null||channelDef===void 0?void 0:channelDef["condition"];return!!condition&&(Object(vega_util["isArray"])(condition)||isValueDef(condition))}function isFieldDef(channelDef){return hasProperty(channelDef,"field")||(channelDef===null||channelDef===void 0?void 0:channelDef.aggregate)==="count"}function channelDefType(channelDef){return channelDef===null||channelDef===void 0?void 0:channelDef["type"]}function isDatumDef(channelDef){return hasProperty(channelDef,"datum")}function isContinuousFieldOrDatumDef(cd){return isTypedFieldDef(cd)&&!channeldef_isDiscrete(cd)||isNumericDataDef(cd)}function isUnbinnedQuantitativeFieldOrDatumDef(cd){return isTypedFieldDef(cd)&&cd.type==="quantitative"&&!cd.bin||isNumericDataDef(cd)}function isNumericDataDef(cd){return isDatumDef(cd)&&Object(vega_util["isNumber"])(cd.datum)}function isFieldOrDatumDef(channelDef){return isFieldDef(channelDef)||isDatumDef(channelDef)}function isTypedFieldDef(channelDef){return channelDef&&(hasProperty(channelDef,"field")||channelDef["aggregate"]==="count")&&hasProperty(channelDef,"type")}function isValueDef(channelDef){return hasProperty(channelDef,"value")}function isScaleFieldDef(channelDef){return hasProperty(channelDef,"scale")||hasProperty(channelDef,"sort")}function isPositionFieldOrDatumDef(channelDef){return hasProperty(channelDef,"axis")||hasProperty(channelDef,"stack")||hasProperty(channelDef,"impute")}function isMarkPropFieldOrDatumDef(channelDef){return hasProperty(channelDef,"legend")}function isStringFieldOrDatumDef(channelDef){return hasProperty(channelDef,"format")||hasProperty(channelDef,"formatType")}function toStringFieldDef(fieldDef){return omit(fieldDef,["legend","axis","header","scale"])}function isOpFieldDef(fieldDef){return hasProperty(fieldDef,"op")}function vgField(fieldDef){let opt=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let field=fieldDef.field;const prefix=opt.prefix;let suffix=opt.suffix;let argAccessor="";if(isCount(fieldDef)){field=internalField("count")}else{let fn;if(!opt.nofn){if(isOpFieldDef(fieldDef)){fn=fieldDef.op}else{const{bin:bin,aggregate:aggregate,timeUnit:timeUnit}=fieldDef;if(isBinning(bin)){var _opt$binSuffix,_opt$suffix;fn=binToString(bin);suffix=((_opt$binSuffix=opt.binSuffix)!==null&&_opt$binSuffix!==void 0?_opt$binSuffix:"")+((_opt$suffix=opt.suffix)!==null&&_opt$suffix!==void 0?_opt$suffix:"")}else if(aggregate){if(isArgmaxDef(aggregate)){argAccessor=`["${field}"]`;field=`argmax_${aggregate.argmax}`}else if(isArgminDef(aggregate)){argAccessor=`["${field}"]`;field=`argmin_${aggregate.argmin}`}else{fn=String(aggregate)}}else if(timeUnit&&!isBinnedTimeUnit(timeUnit)){var _opt$suffix2;fn=timeUnitToString(timeUnit);suffix=(!["range","mid"].includes(opt.binSuffix)&&opt.binSuffix||"")+((_opt$suffix2=opt.suffix)!==null&&_opt$suffix2!==void 0?_opt$suffix2:"")}}}if(fn){field=field?`${fn}_${field}`:fn}}if(suffix){field=`${field}_${suffix}`}if(prefix){field=`${prefix}_${field}`}if(opt.forAs){return removePathFromField(field)}else if(opt.expr){return flatAccessWithDatum(field,opt.expr)+argAccessor}else{return replacePathInField(field)+argAccessor}}function channeldef_isDiscrete(def){switch(def.type){case"nominal":case"ordinal":case"geojson":return true;case"quantitative":return isFieldDef(def)&&!!def.bin;case"temporal":return false}throw new Error(message_namespaceObject.invalidFieldType(def.type))}function isDiscretizing(def){var _def$scale;return isScaleFieldDef(def)&&isContinuousToDiscrete((_def$scale=def.scale)===null||_def$scale===void 0?void 0:_def$scale.type)}function isCount(fieldDef){return fieldDef.aggregate==="count"}function verbalTitleFormatter(fieldDef,config){const{field:field,bin:bin,timeUnit:timeUnit,aggregate:aggregate}=fieldDef;if(aggregate==="count"){return config.countTitle}else if(isBinning(bin)){return`${field} (binned)`}else if(timeUnit&&!isBinnedTimeUnit(timeUnit)){var _normalizeTimeUnit;const unit=(_normalizeTimeUnit=normalizeTimeUnit(timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit;if(unit){return`${field} (${getTimeUnitParts(unit).join("-")})`}}else if(aggregate){if(isArgmaxDef(aggregate)){return`${field} for max ${aggregate.argmax}`}else if(isArgminDef(aggregate)){return`${field} for min ${aggregate.argmin}`}else{return`${titleCase(aggregate)} of ${field}`}}return field}function functionalTitleFormatter(fieldDef){const{aggregate:aggregate,bin:bin,timeUnit:timeUnit,field:field}=fieldDef;if(isArgmaxDef(aggregate)){return`${field} for argmax(${aggregate.argmax})`}else if(isArgminDef(aggregate)){return`${field} for argmin(${aggregate.argmin})`}const timeUnitParams=timeUnit&&!isBinnedTimeUnit(timeUnit)?normalizeTimeUnit(timeUnit):undefined;const fn=aggregate||(timeUnitParams===null||timeUnitParams===void 0?void 0:timeUnitParams.unit)||(timeUnitParams===null||timeUnitParams===void 0?void 0:timeUnitParams.maxbins)&&"timeunit"||isBinning(bin)&&"bin";return fn?`${fn.toUpperCase()}(${field})`:field}const defaultTitleFormatter=(fieldDef,config)=>{switch(config.fieldTitle){case"plain":return fieldDef.field;case"functional":return functionalTitleFormatter(fieldDef);default:return verbalTitleFormatter(fieldDef,config)}};let titleFormatter=defaultTitleFormatter;function setTitleFormatter(formatter){titleFormatter=formatter}function resetTitleFormatter(){setTitleFormatter(defaultTitleFormatter)}function channeldef_title(fieldOrDatumDef,config,_ref3){var _getGuide;let{allowDisabling:allowDisabling,includeDefault:includeDefault=true}=_ref3;const guideTitle=(_getGuide=getGuide(fieldOrDatumDef))===null||_getGuide===void 0?void 0:_getGuide.title;if(!isFieldDef(fieldOrDatumDef)){return guideTitle!==null&&guideTitle!==void 0?guideTitle:fieldOrDatumDef.title}const fieldDef=fieldOrDatumDef;const def=includeDefault?defaultTitle(fieldDef,config):undefined;if(allowDisabling){return getFirstDefined(guideTitle,fieldDef.title,def)}else{var _ref4;return(_ref4=guideTitle!==null&&guideTitle!==void 0?guideTitle:fieldDef.title)!==null&&_ref4!==void 0?_ref4:def}}function getGuide(fieldDef){if(isPositionFieldOrDatumDef(fieldDef)&&fieldDef.axis){return fieldDef.axis}else if(isMarkPropFieldOrDatumDef(fieldDef)&&fieldDef.legend){return fieldDef.legend}else if(isFacetFieldDef(fieldDef)&&fieldDef.header){return fieldDef.header}return undefined}function defaultTitle(fieldDef,config){return titleFormatter(fieldDef,config)}function getFormatMixins(fieldDef){if(isStringFieldOrDatumDef(fieldDef)){const{format:format,formatType:formatType}=fieldDef;return{format:format,formatType:formatType}}else{var _getGuide2;const guide=(_getGuide2=getGuide(fieldDef))!==null&&_getGuide2!==void 0?_getGuide2:{};const{format:format,formatType:formatType}=guide;return{format:format,formatType:formatType}}}function defaultType(fieldDef,channel){var _fieldDef$scale;switch(channel){case"latitude":case"longitude":return"quantitative";case"row":case"column":case"facet":case"shape":case"strokeDash":return"nominal";case"order":return"ordinal"}if(isSortableFieldDef(fieldDef)&&Object(vega_util["isArray"])(fieldDef.sort)){return"ordinal"}const{aggregate:aggregate,bin:bin,timeUnit:timeUnit}=fieldDef;if(timeUnit){return"temporal"}if(bin||aggregate&&!isArgmaxDef(aggregate)&&!isArgminDef(aggregate)){return"quantitative"}if(isScaleFieldDef(fieldDef)&&(_fieldDef$scale=fieldDef.scale)!==null&&_fieldDef$scale!==void 0&&_fieldDef$scale.type){switch(SCALE_CATEGORY_INDEX[fieldDef.scale.type]){case"numeric":case"discretizing":return"quantitative";case"time":return"temporal"}}return"nominal"}function getFieldDef(channelDef){if(isFieldDef(channelDef)){return channelDef}else if(hasConditionalFieldDef(channelDef)){return channelDef.condition}return undefined}function getFieldOrDatumDef(channelDef){if(isFieldOrDatumDef(channelDef)){return channelDef}else if(hasConditionalFieldOrDatumDef(channelDef)){return channelDef.condition}return undefined}function initChannelDef(channelDef,channel,config){let opt=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};if(Object(vega_util["isString"])(channelDef)||Object(vega_util["isNumber"])(channelDef)||Object(vega_util["isBoolean"])(channelDef)){const primitiveType=Object(vega_util["isString"])(channelDef)?"string":Object(vega_util["isNumber"])(channelDef)?"number":"boolean";warn(message_namespaceObject.primitiveChannelDef(channel,primitiveType,channelDef));return{value:channelDef}}if(isFieldOrDatumDef(channelDef)){return initFieldOrDatumDef(channelDef,channel,config,opt)}else if(hasConditionalFieldOrDatumDef(channelDef)){return{...channelDef,condition:initFieldOrDatumDef(channelDef.condition,channel,config,opt)}}return channelDef}function initFieldOrDatumDef(fd,channel,config,opt){if(isStringFieldOrDatumDef(fd)){const{format:format,formatType:formatType,...rest}=fd;if(isCustomFormatType(formatType)&&!config.customFormatTypes){warn(message_namespaceObject.customFormatTypeNotAllowed(channel));return initFieldOrDatumDef(rest,channel,config,opt)}}else{const guideType=isPositionFieldOrDatumDef(fd)?"axis":isMarkPropFieldOrDatumDef(fd)?"legend":isFacetFieldDef(fd)?"header":null;if(guideType&&fd[guideType]){const{format:format,formatType:formatType,...newGuide}=fd[guideType];if(isCustomFormatType(formatType)&&!config.customFormatTypes){warn(message_namespaceObject.customFormatTypeNotAllowed(channel));return initFieldOrDatumDef({...fd,[guideType]:newGuide},channel,config,opt)}}}if(isFieldDef(fd)){return initFieldDef(fd,channel,opt)}return initDatumDef(fd)}function initDatumDef(datumDef){let type=datumDef["type"];if(type){return datumDef}const{datum:datum}=datumDef;type=Object(vega_util["isNumber"])(datum)?"quantitative":Object(vega_util["isString"])(datum)?"nominal":isDateTime(datum)?"temporal":undefined;return{...datumDef,type:type}}function initFieldDef(fd,channel){let{compositeMark:compositeMark=false}=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};const{aggregate:aggregate,timeUnit:timeUnit,bin:bin,field:field}=fd;const fieldDef={...fd};if(!compositeMark&&aggregate&&!isAggregateOp(aggregate)&&!isArgmaxDef(aggregate)&&!isArgminDef(aggregate)){warn(message_namespaceObject.invalidAggregate(aggregate));delete fieldDef.aggregate}if(timeUnit){fieldDef.timeUnit=normalizeTimeUnit(timeUnit)}if(field){fieldDef.field=`${field}`}if(isBinning(bin)){fieldDef.bin=normalizeBin(bin,channel)}if(isBinned(bin)&&!isXorY(channel)){warn(message_namespaceObject.channelShouldNotBeUsedForBinned(channel))}if(isTypedFieldDef(fieldDef)){const{type:type}=fieldDef;const fullType=getFullName(type);if(type!==fullType){fieldDef.type=fullType}if(type!=="quantitative"){if(isCountingAggregateOp(aggregate)){warn(message_namespaceObject.invalidFieldTypeForCountAggregate(type,aggregate));fieldDef.type="quantitative"}}}else if(!isSecondaryRangeChannel(channel)){const newType=defaultType(fieldDef,channel);fieldDef["type"]=newType}if(isTypedFieldDef(fieldDef)){const{compatible:compatible,warning:warning}=channelCompatibility(fieldDef,channel)||{};if(compatible===false){warn(warning)}}if(isSortableFieldDef(fieldDef)&&Object(vega_util["isString"])(fieldDef.sort)){const{sort:sort}=fieldDef;if(isSortByChannel(sort)){return{...fieldDef,sort:{encoding:sort}}}const sub=sort.substring(1);if(sort.charAt(0)==="-"&&isSortByChannel(sub)){return{...fieldDef,sort:{encoding:sub,order:"descending"}}}}if(isFacetFieldDef(fieldDef)){const{header:header}=fieldDef;if(header){const{orient:orient,...rest}=header;if(orient){return{...fieldDef,header:{...rest,labelOrient:header.labelOrient||orient,titleOrient:header.titleOrient||orient}}}}}return fieldDef}function normalizeBin(bin,channel){if(Object(vega_util["isBoolean"])(bin)){return{maxbins:autoMaxBins(channel)}}else if(bin==="binned"){return{binned:true}}else if(!bin.maxbins&&!bin.step){return{...bin,maxbins:autoMaxBins(channel)}}else{return bin}}const COMPATIBLE={compatible:true};function channelCompatibility(fieldDef,channel){const type=fieldDef.type;if(type==="geojson"&&channel!=="shape"){return{compatible:false,warning:`Channel ${channel} should not be used with a geojson data.`}}switch(channel){case ROW:case COLUMN:case FACET:if(!channeldef_isDiscrete(fieldDef)){return{compatible:false,warning:message_namespaceObject.channelShouldBeDiscrete(channel)}}return COMPATIBLE;case X:case Y:case XOFFSET:case YOFFSET:case COLOR:case FILL:case STROKE:case TEXT:case DETAIL:case KEY:case TOOLTIP:case HREF:case URL:case ANGLE:case THETA:case RADIUS:case DESCRIPTION:return COMPATIBLE;case LONGITUDE:case LONGITUDE2:case LATITUDE:case LATITUDE2:if(type!==QUANTITATIVE){return{compatible:false,warning:`Channel ${channel} should be used with a quantitative field only, not ${fieldDef.type} field.`}}return COMPATIBLE;case OPACITY:case FILLOPACITY:case STROKEOPACITY:case STROKEWIDTH:case SIZE:case THETA2:case RADIUS2:case X2:case Y2:case TIME:if(type==="nominal"&&!fieldDef["sort"]){return{compatible:false,warning:`Channel ${channel} should not be used with an unsorted discrete field.`}}return COMPATIBLE;case SHAPE:case STROKEDASH:if(!channeldef_isDiscrete(fieldDef)&&!isDiscretizing(fieldDef)){return{compatible:false,warning:message_namespaceObject.channelShouldBeDiscreteOrDiscretizing(channel)}}return COMPATIBLE;case ORDER:if(fieldDef.type==="nominal"&&!("sort"in fieldDef)){return{compatible:false,warning:`Channel order is inappropriate for nominal field, which has no inherent order.`}}return COMPATIBLE}}function isFieldOrDatumDefForTimeFormat(fieldOrDatumDef){const{formatType:formatType}=getFormatMixins(fieldOrDatumDef);return formatType==="time"||!formatType&&isTemporalFieldDef(fieldOrDatumDef)}function isTemporalFieldDef(def){return def&&(def["type"]==="temporal"||isFieldDef(def)&&!!def.timeUnit)}function valueExpr(v,_ref5){var _normalizeTimeUnit2;let{timeUnit:timeUnit,type:type,wrapTime:wrapTime,undefinedIfExprNotRequired:undefinedIfExprNotRequired}=_ref5;const unit=timeUnit&&((_normalizeTimeUnit2=normalizeTimeUnit(timeUnit))===null||_normalizeTimeUnit2===void 0?void 0:_normalizeTimeUnit2.unit);let isTime=unit||type==="temporal";let expr;if(isExprRef(v)){expr=v.expr}else if(isSignalRef(v)){expr=v.signal}else if(isDateTime(v)){isTime=true;expr=dateTimeToExpr(v)}else if(Object(vega_util["isString"])(v)||Object(vega_util["isNumber"])(v)){if(isTime){expr=`datetime(${stringify(v)})`;if(isLocalSingleTimeUnit(unit)){if(Object(vega_util["isNumber"])(v)&&v<1e4||Object(vega_util["isString"])(v)&&isNaN(Date.parse(v))){expr=dateTimeToExpr({[unit]:v})}}}}if(expr){return wrapTime&&isTime?`time(${expr})`:expr}return undefinedIfExprNotRequired?undefined:stringify(v)}function valueArray(fieldOrDatumDef,values){const{type:type}=fieldOrDatumDef;return values.map(v=>{const timeUnit=isFieldDef(fieldOrDatumDef)&&!isBinnedTimeUnit(fieldOrDatumDef.timeUnit)?fieldOrDatumDef.timeUnit:undefined;const expr=valueExpr(v,{timeUnit:timeUnit,type:type,undefinedIfExprNotRequired:true});if(expr!==undefined){return{signal:expr}}return v})}function binRequiresRange(fieldDef,channel){if(!isBinning(fieldDef.bin)){console.warn("Only call this method for binned field defs.");return false}return isScaleChannel(channel)&&["ordinal","nominal"].includes(fieldDef.type)}const CONDITIONAL_AXIS_PROP_INDEX={labelAlign:{part:"labels",vgProp:"align"},labelBaseline:{part:"labels",vgProp:"baseline"},labelColor:{part:"labels",vgProp:"fill"},labelFont:{part:"labels",vgProp:"font"},labelFontSize:{part:"labels",vgProp:"fontSize"},labelFontStyle:{part:"labels",vgProp:"fontStyle"},labelFontWeight:{part:"labels",vgProp:"fontWeight"},labelOpacity:{part:"labels",vgProp:"opacity"},labelOffset:null,labelPadding:null,gridColor:{part:"grid",vgProp:"stroke"},gridDash:{part:"grid",vgProp:"strokeDash"},gridDashOffset:{part:"grid",vgProp:"strokeDashOffset"},gridOpacity:{part:"grid",vgProp:"opacity"},gridWidth:{part:"grid",vgProp:"strokeWidth"},tickColor:{part:"ticks",vgProp:"stroke"},tickDash:{part:"ticks",vgProp:"strokeDash"},tickDashOffset:{part:"ticks",vgProp:"strokeDashOffset"},tickOpacity:{part:"ticks",vgProp:"opacity"},tickSize:null,tickWidth:{part:"ticks",vgProp:"strokeWidth"}};function isConditionalAxisValue(v){return v===null||v===void 0?void 0:v.condition}const AXIS_PARTS=["domain","grid","labels","ticks","title"];const AXIS_PROPERTY_TYPE={grid:"grid",gridCap:"grid",gridColor:"grid",gridDash:"grid",gridDashOffset:"grid",gridOpacity:"grid",gridScale:"grid",gridWidth:"grid",orient:"main",bandPosition:"both",aria:"main",description:"main",domain:"main",domainCap:"main",domainColor:"main",domainDash:"main",domainDashOffset:"main",domainOpacity:"main",domainWidth:"main",format:"main",formatType:"main",labelAlign:"main",labelAngle:"main",labelBaseline:"main",labelBound:"main",labelColor:"main",labelFlush:"main",labelFlushOffset:"main",labelFont:"main",labelFontSize:"main",labelFontStyle:"main",labelFontWeight:"main",labelLimit:"main",labelLineHeight:"main",labelOffset:"main",labelOpacity:"main",labelOverlap:"main",labelPadding:"main",labels:"main",labelSeparation:"main",maxExtent:"main",minExtent:"main",offset:"both",position:"main",tickCap:"main",tickColor:"main",tickDash:"main",tickDashOffset:"main",tickMinStep:"both",tickOffset:"both",tickOpacity:"main",tickRound:"both",ticks:"main",tickSize:"main",tickWidth:"both",title:"main",titleAlign:"main",titleAnchor:"main",titleAngle:"main",titleBaseline:"main",titleColor:"main",titleFont:"main",titleFontSize:"main",titleFontStyle:"main",titleFontWeight:"main",titleLimit:"main",titleLineHeight:"main",titleOpacity:"main",titlePadding:"main",titleX:"main",titleY:"main",encode:"both",scale:"both",tickBand:"both",tickCount:"both",tickExtra:"both",translate:"both",values:"both",zindex:"both"};const COMMON_AXIS_PROPERTIES_INDEX={orient:1,aria:1,bandPosition:1,description:1,domain:1,domainCap:1,domainColor:1,domainDash:1,domainDashOffset:1,domainOpacity:1,domainWidth:1,format:1,formatType:1,grid:1,gridCap:1,gridColor:1,gridDash:1,gridDashOffset:1,gridOpacity:1,gridWidth:1,labelAlign:1,labelAngle:1,labelBaseline:1,labelBound:1,labelColor:1,labelFlush:1,labelFlushOffset:1,labelFont:1,labelFontSize:1,labelFontStyle:1,labelFontWeight:1,labelLimit:1,labelLineHeight:1,labelOffset:1,labelOpacity:1,labelOverlap:1,labelPadding:1,labels:1,labelSeparation:1,maxExtent:1,minExtent:1,offset:1,position:1,tickBand:1,tickCap:1,tickColor:1,tickCount:1,tickDash:1,tickDashOffset:1,tickExtra:1,tickMinStep:1,tickOffset:1,tickOpacity:1,tickRound:1,ticks:1,tickSize:1,tickWidth:1,title:1,titleAlign:1,titleAnchor:1,titleAngle:1,titleBaseline:1,titleColor:1,titleFont:1,titleFontSize:1,titleFontStyle:1,titleFontWeight:1,titleLimit:1,titleLineHeight:1,titleOpacity:1,titlePadding:1,titleX:1,titleY:1,translate:1,values:1,zindex:1};const AXIS_PROPERTIES_INDEX={...COMMON_AXIS_PROPERTIES_INDEX,style:1,labelExpr:1,encoding:1};function isAxisProperty(prop){return Object(vega_util["hasOwnProperty"])(AXIS_PROPERTIES_INDEX,prop)}const AXIS_PROPERTIES=keys(AXIS_PROPERTIES_INDEX);const AXIS_CONFIGS_INDEX={axis:1,axisBand:1,axisBottom:1,axisDiscrete:1,axisLeft:1,axisPoint:1,axisQuantitative:1,axisRight:1,axisTemporal:1,axisTop:1,axisX:1,axisXBand:1,axisXDiscrete:1,axisXPoint:1,axisXQuantitative:1,axisXTemporal:1,axisY:1,axisYBand:1,axisYDiscrete:1,axisYPoint:1,axisYQuantitative:1,axisYTemporal:1};const AXIS_CONFIGS=keys(AXIS_CONFIGS_INDEX);function isUnitSpec(spec){return hasProperty(spec,"mark")}class base_CompositeMarkNormalizer{constructor(name,run){this.name=name;this.run=run}hasMatchingType(spec){if(isUnitSpec(spec)){return getMarkType(spec.mark)===this.name}return false}}function channelHasField(encoding,channel){const channelDef=encoding&&encoding[channel];if(channelDef){if(Object(vega_util["isArray"])(channelDef)){return some(channelDef,fieldDef=>!!fieldDef.field)}else{return isFieldDef(channelDef)||hasConditionalFieldDef(channelDef)}}return false}function channelHasFieldOrDatum(encoding,channel){const channelDef=encoding&&encoding[channel];if(channelDef){if(Object(vega_util["isArray"])(channelDef)){return some(channelDef,fieldDef=>!!fieldDef.field)}else{return isFieldDef(channelDef)||isDatumDef(channelDef)||hasConditionalFieldOrDatumDef(channelDef)}}return false}function channelHasNestedOffsetScale(encoding,channel){if(isXorY(channel)){const fieldDef=encoding[channel];if((isFieldDef(fieldDef)||isDatumDef(fieldDef))&&(isDiscrete(fieldDef.type)||isFieldDef(fieldDef)&&fieldDef.timeUnit)){const offsetChannel=getOffsetScaleChannel(channel);return channelHasFieldOrDatum(encoding,offsetChannel)}}return false}function encoding_isAggregate(encoding){return some(CHANNELS,channel=>{if(channelHasField(encoding,channel)){const channelDef=encoding[channel];if(Object(vega_util["isArray"])(channelDef)){return some(channelDef,fieldDef=>!!fieldDef.aggregate)}else{const fieldDef=getFieldDef(channelDef);return fieldDef&&!!fieldDef.aggregate}}return false})}function extractTransformsFromEncoding(oldEncoding,config){const groupby=[];const bins=[];const timeUnits=[];const aggregate=[];const encoding={};forEach(oldEncoding,(channelDef,channel)=>{if(isFieldDef(channelDef)){const{field:field,aggregate:aggOp,bin:bin,timeUnit:timeUnit,...remaining}=channelDef;if(aggOp||timeUnit||bin){const guide=getGuide(channelDef);const isTitleDefined=guide===null||guide===void 0?void 0:guide.title;let newField=vgField(channelDef,{forAs:true});const newFieldDef={...isTitleDefined?[]:{title:channeldef_title(channelDef,config,{allowDisabling:true})},...remaining,field:newField};if(aggOp){let op;if(isArgmaxDef(aggOp)){op="argmax";newField=vgField({op:"argmax",field:aggOp.argmax},{forAs:true});newFieldDef.field=`${newField}.${field}`}else if(isArgminDef(aggOp)){op="argmin";newField=vgField({op:"argmin",field:aggOp.argmin},{forAs:true});newFieldDef.field=`${newField}.${field}`}else if(aggOp!=="boxplot"&&aggOp!=="errorbar"&&aggOp!=="errorband"){op=aggOp}if(op){const aggregateEntry={op:op,as:newField};if(field){aggregateEntry.field=field}aggregate.push(aggregateEntry)}}else{groupby.push(newField);if(isTypedFieldDef(channelDef)&&isBinning(bin)){bins.push({bin:bin,field:field,as:newField});groupby.push(vgField(channelDef,{binSuffix:"end"}));if(binRequiresRange(channelDef,channel)){groupby.push(vgField(channelDef,{binSuffix:"range"}))}if(isXorY(channel)){const secondaryChannel={field:`${newField}_end`};encoding[`${channel}2`]=secondaryChannel}newFieldDef.bin="binned";if(!isSecondaryRangeChannel(channel)){newFieldDef["type"]=QUANTITATIVE}}else if(timeUnit&&!isBinnedTimeUnit(timeUnit)){timeUnits.push({timeUnit:timeUnit,field:field,as:newField});const formatType=isTypedFieldDef(channelDef)&&channelDef.type!==TEMPORAL&&"time";if(formatType){if(channel===TEXT||channel===TOOLTIP){newFieldDef["formatType"]=formatType}else if(isNonPositionScaleChannel(channel)){newFieldDef["legend"]={formatType:formatType,...newFieldDef["legend"]}}else if(isXorY(channel)){newFieldDef["axis"]={formatType:formatType,...newFieldDef["axis"]}}}}}encoding[channel]=newFieldDef}else{groupby.push(field);encoding[channel]=oldEncoding[channel]}}else{encoding[channel]=oldEncoding[channel]}});return{bins:bins,timeUnits:timeUnits,aggregate:aggregate,groupby:groupby,encoding:encoding}}function markChannelCompatible(encoding,channel,mark){const markSupported=supportMark(channel,mark);if(!markSupported){return false}else if(markSupported==="binned"){const primaryFieldDef=encoding[channel===X2?X:Y];if(isFieldDef(primaryFieldDef)&&isFieldDef(encoding[channel])&&isBinned(primaryFieldDef.bin)){return true}else{return false}}return true}function initEncoding(encoding,mark,filled,config){const normalizedEncoding={};for(const key of keys(encoding)){if(!isChannel(key)){warn(message_namespaceObject.invalidEncodingChannel(key))}}for(let channel of UNIT_CHANNELS){if(!encoding[channel]){continue}const channelDef=encoding[channel];if(isXorYOffset(channel)){const mainChannel=getMainChannelFromOffsetChannel(channel);const positionDef=normalizedEncoding[mainChannel];if(isFieldDef(positionDef)){if(isContinuous(positionDef.type)){if(isFieldDef(channelDef)&&!positionDef.timeUnit){warn(message_namespaceObject.offsetNestedInsideContinuousPositionScaleDropped(mainChannel));continue}}}}if(channel==="angle"&&mark==="arc"&&!encoding.theta){warn(message_namespaceObject.REPLACE_ANGLE_WITH_THETA);channel=THETA}if(!markChannelCompatible(encoding,channel,mark)){warn(message_namespaceObject.incompatibleChannel(channel,mark));continue}if(channel===SIZE&&mark==="line"){const fieldDef=getFieldDef(encoding[channel]);if(fieldDef!==null&&fieldDef!==void 0&&fieldDef.aggregate){warn(message_namespaceObject.LINE_WITH_VARYING_SIZE);continue}}if(channel===COLOR&&(filled?"fill"in encoding:"stroke"in encoding)){warn(message_namespaceObject.droppingColor("encoding",{fill:"fill"in encoding,stroke:"stroke"in encoding}));continue}if(channel===DETAIL||channel===ORDER&&!Object(vega_util["isArray"])(channelDef)&&!isValueDef(channelDef)||channel===TOOLTIP&&Object(vega_util["isArray"])(channelDef)){if(channelDef){if(channel===ORDER){const def=encoding[channel];if(isOrderOnlyDef(def)){normalizedEncoding[channel]=def;continue}}normalizedEncoding[channel]=Object(vega_util["array"])(channelDef).reduce((defs,fieldDef)=>{if(!isFieldDef(fieldDef)){warn(message_namespaceObject.emptyFieldDef(fieldDef,channel))}else{defs.push(initFieldDef(fieldDef,channel))}return defs},[])}}else{if(channel===TOOLTIP&&channelDef===null){normalizedEncoding[channel]=null}else if(!isFieldDef(channelDef)&&!isDatumDef(channelDef)&&!isValueDef(channelDef)&&!isConditionalDef(channelDef)&&!isSignalRef(channelDef)){warn(message_namespaceObject.emptyFieldDef(channelDef,channel));continue}normalizedEncoding[channel]=initChannelDef(channelDef,channel,config)}}return normalizedEncoding}function normalizeEncoding(encoding,config){const normalizedEncoding={};for(const channel of keys(encoding)){const newChannelDef=initChannelDef(encoding[channel],channel,config,{compositeMark:true});normalizedEncoding[channel]=newChannelDef}return normalizedEncoding}function fieldDefs(encoding){const arr=[];for(const channel of keys(encoding)){if(channelHasField(encoding,channel)){const channelDef=encoding[channel];const channelDefArray=Object(vega_util["array"])(channelDef);for(const def of channelDefArray){if(isFieldDef(def)){arr.push(def)}else if(hasConditionalFieldDef(def)){arr.push(def.condition)}}}}return arr}function forEach(mapping,f,thisArg){if(!mapping){return}for(const channel of keys(mapping)){const el=mapping[channel];if(Object(vega_util["isArray"])(el)){for(const channelDef of el){f.call(thisArg,channelDef,channel)}}else{f.call(thisArg,el,channel)}}}function reduce(mapping,f,init,thisArg){if(!mapping){return init}return keys(mapping).reduce((r,channel)=>{const map=mapping[channel];if(Object(vega_util["isArray"])(map)){return map.reduce((r1,channelDef)=>f.call(thisArg,r1,channelDef,channel),r)}else{return f.call(thisArg,r,map,channel)}},init)}function pathGroupingFields(mark,encoding){return keys(encoding).reduce((details,channel)=>{switch(channel){case X:case Y:case HREF:case DESCRIPTION:case URL:case X2:case Y2:case XOFFSET:case YOFFSET:case THETA:case THETA2:case RADIUS:case RADIUS2:case TIME:case LATITUDE:case LONGITUDE:case LATITUDE2:case LONGITUDE2:case TEXT:case SHAPE:case ANGLE:case TOOLTIP:return details;case ORDER:if(mark==="line"||mark==="trail"){return details}case DETAIL:case KEY:{const channelDef=encoding[channel];if(Object(vega_util["isArray"])(channelDef)||isFieldDef(channelDef)){for(const fieldDef of Object(vega_util["array"])(channelDef)){if(!fieldDef.aggregate){details.push(vgField(fieldDef,{}))}}}return details}case SIZE:if(mark==="trail"){return details}case COLOR:case FILL:case STROKE:case OPACITY:case FILLOPACITY:case STROKEOPACITY:case STROKEDASH:case STROKEWIDTH:{const fieldDef=getFieldDef(encoding[channel]);if(fieldDef&&!fieldDef.aggregate){details.push(vgField(fieldDef,{}))}return details}}},[])}function filterTooltipWithAggregatedField(oldEncoding){const{tooltip:tooltip,...filteredEncoding}=oldEncoding;if(!tooltip){return{filteredEncoding:filteredEncoding}}let customTooltipWithAggregatedField;let customTooltipWithoutAggregatedField;if(Object(vega_util["isArray"])(tooltip)){for(const t of tooltip){if(t.aggregate){if(!customTooltipWithAggregatedField){customTooltipWithAggregatedField=[]}customTooltipWithAggregatedField.push(t)}else{if(!customTooltipWithoutAggregatedField){customTooltipWithoutAggregatedField=[]}customTooltipWithoutAggregatedField.push(t)}}if(customTooltipWithAggregatedField){filteredEncoding.tooltip=customTooltipWithAggregatedField}}else{if(tooltip.aggregate){filteredEncoding.tooltip=tooltip}else{customTooltipWithoutAggregatedField=tooltip}}if(Object(vega_util["isArray"])(customTooltipWithoutAggregatedField)&&customTooltipWithoutAggregatedField.length===1){customTooltipWithoutAggregatedField=customTooltipWithoutAggregatedField[0]}return{customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField,filteredEncoding:filteredEncoding}}function getCompositeMarkTooltip(tooltipSummary,continuousAxisChannelDef,encodingWithoutContinuousAxis){let withFieldName=arguments.length>3&&arguments[3]!==undefined?arguments[3]:true;if("tooltip"in encodingWithoutContinuousAxis){return{tooltip:encodingWithoutContinuousAxis.tooltip}}const fiveSummaryTooltip=tooltipSummary.map(_ref=>{let{fieldPrefix:fieldPrefix,titlePrefix:titlePrefix}=_ref;const mainTitle=withFieldName?` of ${getTitle(continuousAxisChannelDef)}`:"";return{field:fieldPrefix+continuousAxisChannelDef.field,type:continuousAxisChannelDef.type,title:isSignalRef(titlePrefix)?{signal:`${titlePrefix}"${escape(mainTitle)}"`}:titlePrefix+mainTitle}});const tooltipFieldDefs=fieldDefs(encodingWithoutContinuousAxis).map(toStringFieldDef);return{tooltip:[...fiveSummaryTooltip,...unique(tooltipFieldDefs,hash)]}}function getTitle(continuousAxisChannelDef){const{title:title,field:field}=continuousAxisChannelDef;return getFirstDefined(title,field)}function makeCompositeAggregatePartFactory(compositeMarkDef,continuousAxis,continuousAxisChannelDef,sharedEncoding,compositeMarkConfig){const{scale:scale,axis:axis}=continuousAxisChannelDef;return _ref2=>{let{partName:partName,mark:mark,positionPrefix:positionPrefix,endPositionPrefix:endPositionPrefix=undefined,extraEncoding:extraEncoding={}}=_ref2;const title=getTitle(continuousAxisChannelDef);return partLayerMixins(compositeMarkDef,partName,compositeMarkConfig,{mark:mark,encoding:{[continuousAxis]:{field:`${positionPrefix}_${continuousAxisChannelDef.field}`,type:continuousAxisChannelDef.type,...title!==undefined?{title:title}:{},...scale!==undefined?{scale:scale}:{},...axis!==undefined?{axis:axis}:{}},...Object(vega_util["isString"])(endPositionPrefix)?{[`${continuousAxis}2`]:{field:`${endPositionPrefix}_${continuousAxisChannelDef.field}`}}:{},...sharedEncoding,...extraEncoding}})}}function partLayerMixins(markDef,part,compositeMarkConfig,partBaseSpec){const{clip:clip,color:color,opacity:opacity}=markDef;const mark=markDef.type;if(markDef[part]||markDef[part]===undefined&&compositeMarkConfig[part]){return[{...partBaseSpec,mark:{...compositeMarkConfig[part],...clip?{clip:clip}:{},...color?{color:color}:{},...opacity?{opacity:opacity}:{},...isMarkDef(partBaseSpec.mark)?partBaseSpec.mark:{type:partBaseSpec.mark},style:`${mark}-${String(part)}`,...Object(vega_util["isBoolean"])(markDef[part])?{}:markDef[part]}}]}return[]}function compositeMarkContinuousAxis(spec,orient,compositeMark){const{encoding:encoding}=spec;const continuousAxis=orient==="vertical"?"y":"x";const continuousAxisChannelDef=encoding[continuousAxis];const continuousAxisChannelDef2=encoding[`${continuousAxis}2`];const continuousAxisChannelDefError=encoding[`${continuousAxis}Error`];const continuousAxisChannelDefError2=encoding[`${continuousAxis}Error2`];return{continuousAxisChannelDef:filterAggregateFromChannelDef(continuousAxisChannelDef,compositeMark),continuousAxisChannelDef2:filterAggregateFromChannelDef(continuousAxisChannelDef2,compositeMark),continuousAxisChannelDefError:filterAggregateFromChannelDef(continuousAxisChannelDefError,compositeMark),continuousAxisChannelDefError2:filterAggregateFromChannelDef(continuousAxisChannelDefError2,compositeMark),continuousAxis:continuousAxis}}function filterAggregateFromChannelDef(continuousAxisChannelDef,compositeMark){if(continuousAxisChannelDef!==null&&continuousAxisChannelDef!==void 0&&continuousAxisChannelDef.aggregate){const{aggregate:aggregate,...continuousAxisWithoutAggregate}=continuousAxisChannelDef;if(aggregate!==compositeMark){warn(message_namespaceObject.errorBarContinuousAxisHasCustomizedAggregate(aggregate,compositeMark))}return continuousAxisWithoutAggregate}else{return continuousAxisChannelDef}}function compositeMarkOrient(spec,compositeMark){const{mark:mark,encoding:encoding}=spec;const{x:x,y:y}=encoding;if(isMarkDef(mark)&&mark.orient){return mark.orient}if(isContinuousFieldOrDatumDef(x)){if(isContinuousFieldOrDatumDef(y)){const xAggregate=isFieldDef(x)&&x.aggregate;const yAggregate=isFieldDef(y)&&y.aggregate;if(!xAggregate&&yAggregate===compositeMark){return"vertical"}else if(!yAggregate&&xAggregate===compositeMark){return"horizontal"}else if(xAggregate===compositeMark&&yAggregate===compositeMark){throw new Error("Both x and y cannot have aggregate")}else{if(isFieldOrDatumDefForTimeFormat(y)&&!isFieldOrDatumDefForTimeFormat(x)){return"horizontal"}return"vertical"}}return"horizontal"}else if(isContinuousFieldOrDatumDef(y)){return"vertical"}else{throw new Error(`Need a valid continuous axis for ${compositeMark}s`)}}const BOXPLOT="boxplot";const BOXPLOT_PARTS=["box","median","outliers","rule","ticks"];const boxPlotNormalizer=new base_CompositeMarkNormalizer(BOXPLOT,normalizeBoxPlot);function getBoxPlotType(extent){if(Object(vega_util["isNumber"])(extent)){return"tukey"}return extent}function normalizeBoxPlot(spec,_ref){var _markDef$extent;let{config:config}=_ref;spec={...spec,encoding:normalizeEncoding(spec.encoding,config)};const{mark:mark,encoding:_encoding,params:params,projection:_p,...outerSpec}=spec;const markDef=isMarkDef(mark)?mark:{type:mark};if(params){warn(message_namespaceObject.selectionNotSupported("boxplot"))}const extent=(_markDef$extent=markDef.extent)!==null&&_markDef$extent!==void 0?_markDef$extent:config.boxplot.extent;const sizeValue=getMarkPropOrConfig("size",markDef,config);const invalid=markDef.invalid;const boxPlotType=getBoxPlotType(extent);const{bins:bins,timeUnits:timeUnits,transform:transform,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,groupby:groupby,aggregate:aggregate,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:ticksOrient,boxOrient:boxOrient,customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField}=boxParams(spec,extent,config);const aliasedFieldName=removePathFromField(continuousAxisChannelDef.field);const{color:color,size:size,...encodingWithoutSizeColorAndContinuousAxis}=encodingWithoutContinuousAxis;const makeBoxPlotPart=sharedEncoding=>makeCompositeAggregatePartFactory(markDef,continuousAxis,continuousAxisChannelDef,sharedEncoding,config.boxplot);const makeBoxPlotExtent=makeBoxPlotPart(encodingWithoutSizeColorAndContinuousAxis);const makeBoxPlotBox=makeBoxPlotPart(encodingWithoutContinuousAxis);const defaultBoxColor=(Object(vega_util["isObject"])(config.boxplot.box)?config.boxplot.box.color:config.mark.color)||"#4c78a8";const makeBoxPlotMidTick=makeBoxPlotPart({...encodingWithoutSizeColorAndContinuousAxis,...size?{size:size}:{},color:{condition:{test:`${accessWithDatumToUnescapedPath(`lower_box_${continuousAxisChannelDef.field}`)} >= ${accessWithDatumToUnescapedPath(`upper_box_${continuousAxisChannelDef.field}`)}`,...color||{value:defaultBoxColor}}}});const fiveSummaryTooltipEncoding=getCompositeMarkTooltip([{fieldPrefix:boxPlotType==="min-max"?"upper_whisker_":"max_",titlePrefix:"Max"},{fieldPrefix:"upper_box_",titlePrefix:"Q3"},{fieldPrefix:"mid_box_",titlePrefix:"Median"},{fieldPrefix:"lower_box_",titlePrefix:"Q1"},{fieldPrefix:boxPlotType==="min-max"?"lower_whisker_":"min_",titlePrefix:"Min"}],continuousAxisChannelDef,encodingWithoutContinuousAxis);const endTick={type:"tick",color:"black",opacity:1,orient:ticksOrient,invalid:invalid,aria:false};const whiskerTooltipEncoding=boxPlotType==="min-max"?fiveSummaryTooltipEncoding:getCompositeMarkTooltip([{fieldPrefix:"upper_whisker_",titlePrefix:"Upper Whisker"},{fieldPrefix:"lower_whisker_",titlePrefix:"Lower Whisker"}],continuousAxisChannelDef,encodingWithoutContinuousAxis);const whiskerLayers=[...makeBoxPlotExtent({partName:"rule",mark:{type:"rule",invalid:invalid,aria:false},positionPrefix:"lower_whisker",endPositionPrefix:"lower_box",extraEncoding:whiskerTooltipEncoding}),...makeBoxPlotExtent({partName:"rule",mark:{type:"rule",invalid:invalid,aria:false},positionPrefix:"upper_box",endPositionPrefix:"upper_whisker",extraEncoding:whiskerTooltipEncoding}),...makeBoxPlotExtent({partName:"ticks",mark:endTick,positionPrefix:"lower_whisker",extraEncoding:whiskerTooltipEncoding}),...makeBoxPlotExtent({partName:"ticks",mark:endTick,positionPrefix:"upper_whisker",extraEncoding:whiskerTooltipEncoding})];const boxLayers=[...boxPlotType!=="tukey"?whiskerLayers:[],...makeBoxPlotBox({partName:"box",mark:{type:"bar",...sizeValue?{size:sizeValue}:{},orient:boxOrient,invalid:invalid,ariaRoleDescription:"box"},positionPrefix:"lower_box",endPositionPrefix:"upper_box",extraEncoding:fiveSummaryTooltipEncoding}),...makeBoxPlotMidTick({partName:"median",mark:{type:"tick",invalid:invalid,...Object(vega_util["isObject"])(config.boxplot.median)&&config.boxplot.median.color?{color:config.boxplot.median.color}:{},...sizeValue?{size:sizeValue}:{},orient:ticksOrient,aria:false},positionPrefix:"mid_box",extraEncoding:fiveSummaryTooltipEncoding})];if(boxPlotType==="min-max"){var _outerSpec$transform;return{...outerSpec,transform:((_outerSpec$transform=outerSpec.transform)!==null&&_outerSpec$transform!==void 0?_outerSpec$transform:[]).concat(transform),layer:boxLayers}}const lowerBoxExpr=accessWithDatumToUnescapedPath(`lower_box_${continuousAxisChannelDef.field}`);const upperBoxExpr=accessWithDatumToUnescapedPath(`upper_box_${continuousAxisChannelDef.field}`);const iqrExpr=`(${upperBoxExpr} - ${lowerBoxExpr})`;const lowerWhiskerExpr=`${lowerBoxExpr} - ${extent} * ${iqrExpr}`;const upperWhiskerExpr=`${upperBoxExpr} + ${extent} * ${iqrExpr}`;const fieldExpr=accessWithDatumToUnescapedPath(continuousAxisChannelDef.field);const joinaggregateTransform={joinaggregate:boxParamsQuartiles(continuousAxisChannelDef.field),groupby:groupby};const filteredWhiskerSpec={transform:[{filter:`(${lowerWhiskerExpr} <= ${fieldExpr}) && (${fieldExpr} <= ${upperWhiskerExpr})`},{aggregate:[{op:"min",field:continuousAxisChannelDef.field,as:`lower_whisker_${aliasedFieldName}`},{op:"max",field:continuousAxisChannelDef.field,as:`upper_whisker_${aliasedFieldName}`},{op:"min",field:`lower_box_${continuousAxisChannelDef.field}`,as:`lower_box_${aliasedFieldName}`},{op:"max",field:`upper_box_${continuousAxisChannelDef.field}`,as:`upper_box_${aliasedFieldName}`},...aggregate],groupby:groupby}],layer:whiskerLayers};const{tooltip:tooltip,...encodingWithoutSizeColorContinuousAxisAndTooltip}=encodingWithoutSizeColorAndContinuousAxis;const{scale:scale,axis:axis}=continuousAxisChannelDef;const title=getTitle(continuousAxisChannelDef);const axisWithoutTitle=omit(axis,["title"]);const outlierLayersMixins=partLayerMixins(markDef,"outliers",config.boxplot,{transform:[{filter:`(${fieldExpr} < ${lowerWhiskerExpr}) || (${fieldExpr} > ${upperWhiskerExpr})`}],mark:"point",encoding:{[continuousAxis]:{field:continuousAxisChannelDef.field,type:continuousAxisChannelDef.type,...title!==undefined?{title:title}:{},...scale!==undefined?{scale:scale}:{},...isEmpty(axisWithoutTitle)?{}:{axis:axisWithoutTitle}},...encodingWithoutSizeColorContinuousAxisAndTooltip,...color?{color:color}:{},...customTooltipWithoutAggregatedField?{tooltip:customTooltipWithoutAggregatedField}:{}}})[0];let filteredLayersMixins;const filteredLayersMixinsTransforms=[...bins,...timeUnits,joinaggregateTransform];if(outlierLayersMixins){filteredLayersMixins={transform:filteredLayersMixinsTransforms,layer:[outlierLayersMixins,filteredWhiskerSpec]}}else{filteredLayersMixins=filteredWhiskerSpec;filteredLayersMixins.transform.unshift(...filteredLayersMixinsTransforms)}return{...outerSpec,layer:[filteredLayersMixins,{transform:transform,layer:boxLayers}]}}function boxParamsQuartiles(continousAxisField){const aliasedFieldName=removePathFromField(continousAxisField);return[{op:"q1",field:continousAxisField,as:`lower_box_${aliasedFieldName}`},{op:"q3",field:continousAxisField,as:`upper_box_${aliasedFieldName}`}]}function boxParams(spec,extent,config){const orient=compositeMarkOrient(spec,BOXPLOT);const{continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis}=compositeMarkContinuousAxis(spec,orient,BOXPLOT);const continuousFieldName=continuousAxisChannelDef.field;const aliasedFieldName=removePathFromField(continuousFieldName);const boxPlotType=getBoxPlotType(extent);const boxplotSpecificAggregate=[...boxParamsQuartiles(continuousFieldName),{op:"median",field:continuousFieldName,as:`mid_box_${aliasedFieldName}`},{op:"min",field:continuousFieldName,as:(boxPlotType==="min-max"?"lower_whisker_":"min_")+aliasedFieldName},{op:"max",field:continuousFieldName,as:(boxPlotType==="min-max"?"upper_whisker_":"max_")+aliasedFieldName}];const postAggregateCalculates=boxPlotType==="min-max"||boxPlotType==="tukey"?[]:[{calculate:`${accessWithDatumToUnescapedPath(`upper_box_${aliasedFieldName}`)} - ${accessWithDatumToUnescapedPath(`lower_box_${aliasedFieldName}`)}`,as:`iqr_${aliasedFieldName}`},{calculate:`min(${accessWithDatumToUnescapedPath(`upper_box_${aliasedFieldName}`)} + ${accessWithDatumToUnescapedPath(`iqr_${aliasedFieldName}`)} * ${extent}, ${accessWithDatumToUnescapedPath(`max_${aliasedFieldName}`)})`,as:`upper_whisker_${aliasedFieldName}`},{calculate:`max(${accessWithDatumToUnescapedPath(`lower_box_${aliasedFieldName}`)} - ${accessWithDatumToUnescapedPath(`iqr_${aliasedFieldName}`)} * ${extent}, ${accessWithDatumToUnescapedPath(`min_${aliasedFieldName}`)})`,as:`lower_whisker_${aliasedFieldName}`}];const{[continuousAxis]:oldContinuousAxisChannelDef,...oldEncodingWithoutContinuousAxis}=spec.encoding;const{customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField,filteredEncoding:filteredEncoding}=filterTooltipWithAggregatedField(oldEncodingWithoutContinuousAxis);const{bins:bins,timeUnits:timeUnits,aggregate:aggregate,groupby:groupby,encoding:encodingWithoutContinuousAxis}=extractTransformsFromEncoding(filteredEncoding,config);const ticksOrient=orient==="vertical"?"horizontal":"vertical";const boxOrient=orient;const transform=[...bins,...timeUnits,{aggregate:[...aggregate,...boxplotSpecificAggregate],groupby:groupby},...postAggregateCalculates];return{bins:bins,timeUnits:timeUnits,transform:transform,groupby:groupby,aggregate:aggregate,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:ticksOrient,boxOrient:boxOrient,customTooltipWithoutAggregatedField:customTooltipWithoutAggregatedField}}const ERRORBAR="errorbar";const ERRORBAR_PARTS=["ticks","rule"];const errorBarNormalizer=new base_CompositeMarkNormalizer(ERRORBAR,normalizeErrorBar);function normalizeErrorBar(spec,_ref){let{config:config}=_ref;spec={...spec,encoding:normalizeEncoding(spec.encoding,config)};const{transform:transform,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:ticksOrient,markDef:markDef,outerSpec:outerSpec,tooltipEncoding:tooltipEncoding}=errorBarParams(spec,ERRORBAR,config);delete encodingWithoutContinuousAxis.size;const makeErrorBarPart=makeCompositeAggregatePartFactory(markDef,continuousAxis,continuousAxisChannelDef,encodingWithoutContinuousAxis,config.errorbar);const thickness=markDef.thickness;const size=markDef.size;const tick={type:"tick",orient:ticksOrient,aria:false,...thickness!==undefined?{thickness:thickness}:{},...size!==undefined?{size:size}:{}};const layer=[...makeErrorBarPart({partName:"ticks",mark:tick,positionPrefix:"lower",extraEncoding:tooltipEncoding}),...makeErrorBarPart({partName:"ticks",mark:tick,positionPrefix:"upper",extraEncoding:tooltipEncoding}),...makeErrorBarPart({partName:"rule",mark:{type:"rule",ariaRoleDescription:"errorbar",...thickness!==undefined?{size:thickness}:{}},positionPrefix:"lower",endPositionPrefix:"upper",extraEncoding:tooltipEncoding})];return{...outerSpec,transform:transform,...layer.length>1?{layer:layer}:{...layer[0]}}}function errorBarOrientAndInputType(spec,compositeMark){const{encoding:encoding}=spec;if(errorBarIsInputTypeRaw(encoding)){return{orient:compositeMarkOrient(spec,compositeMark),inputType:"raw"}}const isTypeAggregatedUpperLower=errorBarIsInputTypeAggregatedUpperLower(encoding);const isTypeAggregatedError=errorBarIsInputTypeAggregatedError(encoding);const x=encoding.x;const y=encoding.y;if(isTypeAggregatedUpperLower){if(isTypeAggregatedError){throw new Error(`${compositeMark} cannot be both type aggregated-upper-lower and aggregated-error`)}const x2=encoding.x2;const y2=encoding.y2;if(isFieldOrDatumDef(x2)&&isFieldOrDatumDef(y2)){throw new Error(`${compositeMark} cannot have both x2 and y2`)}else if(isFieldOrDatumDef(x2)){if(isContinuousFieldOrDatumDef(x)){return{orient:"horizontal",inputType:"aggregated-upper-lower"}}else{throw new Error(`Both x and x2 have to be quantitative in ${compositeMark}`)}}else if(isFieldOrDatumDef(y2)){if(isContinuousFieldOrDatumDef(y)){return{orient:"vertical",inputType:"aggregated-upper-lower"}}else{throw new Error(`Both y and y2 have to be quantitative in ${compositeMark}`)}}throw new Error("No ranged axis")}else{const xError=encoding.xError;const xError2=encoding.xError2;const yError=encoding.yError;const yError2=encoding.yError2;if(isFieldOrDatumDef(xError2)&&!isFieldOrDatumDef(xError)){throw new Error(`${compositeMark} cannot have xError2 without xError`)}if(isFieldOrDatumDef(yError2)&&!isFieldOrDatumDef(yError)){throw new Error(`${compositeMark} cannot have yError2 without yError`)}if(isFieldOrDatumDef(xError)&&isFieldOrDatumDef(yError)){throw new Error(`${compositeMark} cannot have both xError and yError with both are quantiative`)}else if(isFieldOrDatumDef(xError)){if(isContinuousFieldOrDatumDef(x)){return{orient:"horizontal",inputType:"aggregated-error"}}else{throw new Error("All x, xError, and xError2 (if exist) have to be quantitative")}}else if(isFieldOrDatumDef(yError)){if(isContinuousFieldOrDatumDef(y)){return{orient:"vertical",inputType:"aggregated-error"}}else{throw new Error("All y, yError, and yError2 (if exist) have to be quantitative")}}throw new Error("No ranged axis")}}function errorBarIsInputTypeRaw(encoding){return(isFieldOrDatumDef(encoding.x)||isFieldOrDatumDef(encoding.y))&&!isFieldOrDatumDef(encoding.x2)&&!isFieldOrDatumDef(encoding.y2)&&!isFieldOrDatumDef(encoding.xError)&&!isFieldOrDatumDef(encoding.xError2)&&!isFieldOrDatumDef(encoding.yError)&&!isFieldOrDatumDef(encoding.yError2)}function errorBarIsInputTypeAggregatedUpperLower(encoding){return isFieldOrDatumDef(encoding.x2)||isFieldOrDatumDef(encoding.y2)}function errorBarIsInputTypeAggregatedError(encoding){return isFieldOrDatumDef(encoding.xError)||isFieldOrDatumDef(encoding.xError2)||isFieldOrDatumDef(encoding.yError)||isFieldOrDatumDef(encoding.yError2)}function errorBarParams(spec,compositeMark,config){var _outerSpec$transform;const{mark:mark,encoding:encoding,params:params,projection:_p,...outerSpec}=spec;const markDef=isMarkDef(mark)?mark:{type:mark};if(params){warn(message_namespaceObject.selectionNotSupported(compositeMark))}const{orient:orient,inputType:inputType}=errorBarOrientAndInputType(spec,compositeMark);const{continuousAxisChannelDef:continuousAxisChannelDef,continuousAxisChannelDef2:continuousAxisChannelDef2,continuousAxisChannelDefError:continuousAxisChannelDefError,continuousAxisChannelDefError2:continuousAxisChannelDefError2,continuousAxis:continuousAxis}=compositeMarkContinuousAxis(spec,orient,compositeMark);const{errorBarSpecificAggregate:errorBarSpecificAggregate,postAggregateCalculates:postAggregateCalculates,tooltipSummary:tooltipSummary,tooltipTitleWithFieldName:tooltipTitleWithFieldName}=errorBarAggregationAndCalculation(markDef,continuousAxisChannelDef,continuousAxisChannelDef2,continuousAxisChannelDefError,continuousAxisChannelDefError2,inputType,compositeMark,config);const{[continuousAxis]:oldContinuousAxisChannelDef,[continuousAxis==="x"?"x2":"y2"]:oldContinuousAxisChannelDef2,[continuousAxis==="x"?"xError":"yError"]:oldContinuousAxisChannelDefError,[continuousAxis==="x"?"xError2":"yError2"]:oldContinuousAxisChannelDefError2,...oldEncodingWithoutContinuousAxis}=encoding;const{bins:bins,timeUnits:timeUnits,aggregate:oldAggregate,groupby:oldGroupBy,encoding:encodingWithoutContinuousAxis}=extractTransformsFromEncoding(oldEncodingWithoutContinuousAxis,config);const aggregate=[...oldAggregate,...errorBarSpecificAggregate];const groupby=inputType!=="raw"?[]:oldGroupBy;const tooltipEncoding=getCompositeMarkTooltip(tooltipSummary,continuousAxisChannelDef,encodingWithoutContinuousAxis,tooltipTitleWithFieldName);return{transform:[...(_outerSpec$transform=outerSpec.transform)!==null&&_outerSpec$transform!==void 0?_outerSpec$transform:[],...bins,...timeUnits,...aggregate.length===0?[]:[{aggregate:aggregate,groupby:groupby}],...postAggregateCalculates],groupby:groupby,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,ticksOrient:orient==="vertical"?"horizontal":"vertical",markDef:markDef,outerSpec:outerSpec,tooltipEncoding:tooltipEncoding}}function errorBarAggregationAndCalculation(markDef,continuousAxisChannelDef,continuousAxisChannelDef2,continuousAxisChannelDefError,continuousAxisChannelDefError2,inputType,compositeMark,config){let errorBarSpecificAggregate=[];let postAggregateCalculates=[];const continuousFieldName=continuousAxisChannelDef.field;let tooltipSummary;let tooltipTitleWithFieldName=false;if(inputType==="raw"){const center=markDef.center?markDef.center:markDef.extent?markDef.extent==="iqr"?"median":"mean":config.errorbar.center;const extent=markDef.extent?markDef.extent:center==="mean"?"stderr":"iqr";if(center==="median"!==(extent==="iqr")){warn(message_namespaceObject.errorBarCenterIsUsedWithWrongExtent(center,extent,compositeMark))}if(extent==="stderr"||extent==="stdev"){errorBarSpecificAggregate=[{op:extent,field:continuousFieldName,as:`extent_${continuousFieldName}`},{op:center,field:continuousFieldName,as:`center_${continuousFieldName}`}];postAggregateCalculates=[{calculate:`${accessWithDatumToUnescapedPath(`center_${continuousFieldName}`)} + ${accessWithDatumToUnescapedPath(`extent_${continuousFieldName}`)}`,as:`upper_${continuousFieldName}`},{calculate:`${accessWithDatumToUnescapedPath(`center_${continuousFieldName}`)} - ${accessWithDatumToUnescapedPath(`extent_${continuousFieldName}`)}`,as:`lower_${continuousFieldName}`}];tooltipSummary=[{fieldPrefix:"center_",titlePrefix:titleCase(center)},{fieldPrefix:"upper_",titlePrefix:getTitlePrefix(center,extent,"+")},{fieldPrefix:"lower_",titlePrefix:getTitlePrefix(center,extent,"-")}];tooltipTitleWithFieldName=true}else{let centerOp;let lowerExtentOp;let upperExtentOp;if(extent==="ci"){centerOp="mean";lowerExtentOp="ci0";upperExtentOp="ci1"}else{centerOp="median";lowerExtentOp="q1";upperExtentOp="q3"}errorBarSpecificAggregate=[{op:lowerExtentOp,field:continuousFieldName,as:`lower_${continuousFieldName}`},{op:upperExtentOp,field:continuousFieldName,as:`upper_${continuousFieldName}`},{op:centerOp,field:continuousFieldName,as:`center_${continuousFieldName}`}];tooltipSummary=[{fieldPrefix:"upper_",titlePrefix:channeldef_title({field:continuousFieldName,aggregate:upperExtentOp,type:"quantitative"},config,{allowDisabling:false})},{fieldPrefix:"lower_",titlePrefix:channeldef_title({field:continuousFieldName,aggregate:lowerExtentOp,type:"quantitative"},config,{allowDisabling:false})},{fieldPrefix:"center_",titlePrefix:channeldef_title({field:continuousFieldName,aggregate:centerOp,type:"quantitative"},config,{allowDisabling:false})}]}}else{if(markDef.center||markDef.extent){warn(message_namespaceObject.errorBarCenterAndExtentAreNotNeeded(markDef.center,markDef.extent))}if(inputType==="aggregated-upper-lower"){tooltipSummary=[];postAggregateCalculates=[{calculate:accessWithDatumToUnescapedPath(continuousAxisChannelDef2.field),as:`upper_${continuousFieldName}`},{calculate:accessWithDatumToUnescapedPath(continuousFieldName),as:`lower_${continuousFieldName}`}]}else if(inputType==="aggregated-error"){tooltipSummary=[{fieldPrefix:"",titlePrefix:continuousFieldName}];postAggregateCalculates=[{calculate:`${accessWithDatumToUnescapedPath(continuousFieldName)} + ${accessWithDatumToUnescapedPath(continuousAxisChannelDefError.field)}`,as:`upper_${continuousFieldName}`}];if(continuousAxisChannelDefError2){postAggregateCalculates.push({calculate:`${accessWithDatumToUnescapedPath(continuousFieldName)} + ${accessWithDatumToUnescapedPath(continuousAxisChannelDefError2.field)}`,as:`lower_${continuousFieldName}`})}else{postAggregateCalculates.push({calculate:`${accessWithDatumToUnescapedPath(continuousFieldName)} - ${accessWithDatumToUnescapedPath(continuousAxisChannelDefError.field)}`,as:`lower_${continuousFieldName}`})}}for(const postAggregateCalculate of postAggregateCalculates){tooltipSummary.push({fieldPrefix:postAggregateCalculate.as.substring(0,6),titlePrefix:replaceAll(replaceAll(postAggregateCalculate.calculate,"datum['",""),"']","")})}}return{postAggregateCalculates:postAggregateCalculates,errorBarSpecificAggregate:errorBarSpecificAggregate,tooltipSummary:tooltipSummary,tooltipTitleWithFieldName:tooltipTitleWithFieldName}}function getTitlePrefix(center,extent,operation){return`${titleCase(center)} ${operation} ${extent}`}const ERRORBAND="errorband";const ERRORBAND_PARTS=["band","borders"];const errorBandNormalizer=new base_CompositeMarkNormalizer(ERRORBAND,normalizeErrorBand);function normalizeErrorBand(spec,_ref){let{config:config}=_ref;spec={...spec,encoding:normalizeEncoding(spec.encoding,config)};const{transform:transform,continuousAxisChannelDef:continuousAxisChannelDef,continuousAxis:continuousAxis,encodingWithoutContinuousAxis:encodingWithoutContinuousAxis,markDef:markDef,outerSpec:outerSpec,tooltipEncoding:tooltipEncoding}=errorBarParams(spec,ERRORBAND,config);const errorBandDef=markDef;const makeErrorBandPart=makeCompositeAggregatePartFactory(errorBandDef,continuousAxis,continuousAxisChannelDef,encodingWithoutContinuousAxis,config.errorband);const is2D=spec.encoding.x!==undefined&&spec.encoding.y!==undefined;let bandMark={type:is2D?"area":"rect"};let bordersMark={type:is2D?"line":"rule"};const interpolate={...errorBandDef.interpolate?{interpolate:errorBandDef.interpolate}:{},...errorBandDef.tension&&errorBandDef.interpolate?{tension:errorBandDef.tension}:{}};if(is2D){bandMark={...bandMark,...interpolate,ariaRoleDescription:"errorband"};bordersMark={...bordersMark,...interpolate,aria:false}}else if(errorBandDef.interpolate){warn(message_namespaceObject.errorBand1DNotSupport("interpolate"))}else if(errorBandDef.tension){warn(message_namespaceObject.errorBand1DNotSupport("tension"))}return{...outerSpec,transform:transform,layer:[...makeErrorBandPart({partName:"band",mark:bandMark,positionPrefix:"lower",endPositionPrefix:"upper",extraEncoding:tooltipEncoding}),...makeErrorBandPart({partName:"borders",mark:bordersMark,positionPrefix:"lower",extraEncoding:tooltipEncoding}),...makeErrorBandPart({partName:"borders",mark:bordersMark,positionPrefix:"upper",extraEncoding:tooltipEncoding})]}}const compositeMarkRegistry={};function compositemark_add(mark,run,parts){const normalizer=new base_CompositeMarkNormalizer(mark,run);compositeMarkRegistry[mark]={normalizer:normalizer,parts:parts}}function remove(mark){delete compositeMarkRegistry[mark]}function getAllCompositeMarks(){return keys(compositeMarkRegistry)}compositemark_add(BOXPLOT,normalizeBoxPlot,BOXPLOT_PARTS);compositemark_add(ERRORBAR,normalizeErrorBar,ERRORBAR_PARTS);compositemark_add(ERRORBAND,normalizeErrorBand,ERRORBAND_PARTS);const VL_ONLY_LEGEND_CONFIG=["gradientHorizontalMaxLength","gradientHorizontalMinLength","gradientVerticalMaxLength","gradientVerticalMinLength","unselectedOpacity"];const HEADER_TITLE_PROPERTIES_MAP={titleAlign:"align",titleAnchor:"anchor",titleAngle:"angle",titleBaseline:"baseline",titleColor:"color",titleFont:"font",titleFontSize:"fontSize",titleFontStyle:"fontStyle",titleFontWeight:"fontWeight",titleLimit:"limit",titleLineHeight:"lineHeight",titleOrient:"orient",titlePadding:"offset"};const HEADER_LABEL_PROPERTIES_MAP={labelAlign:"align",labelAnchor:"anchor",labelAngle:"angle",labelBaseline:"baseline",labelColor:"color",labelFont:"font",labelFontSize:"fontSize",labelFontStyle:"fontStyle",labelFontWeight:"fontWeight",labelLimit:"limit",labelLineHeight:"lineHeight",labelOrient:"orient",labelPadding:"offset"};const HEADER_TITLE_PROPERTIES=keys(HEADER_TITLE_PROPERTIES_MAP);const HEADER_LABEL_PROPERTIES=keys(HEADER_LABEL_PROPERTIES_MAP);const HEADER_CONFIGS_INDEX={header:1,headerRow:1,headerColumn:1,headerFacet:1};const HEADER_CONFIGS=keys(HEADER_CONFIGS_INDEX);const LEGEND_SCALE_CHANNELS=["size","shape","fill","stroke","strokeDash","strokeWidth","opacity"];const defaultLegendConfig={gradientHorizontalMaxLength:200,gradientHorizontalMinLength:100,gradientVerticalMaxLength:200,gradientVerticalMinLength:64,unselectedOpacity:.35};const COMMON_LEGEND_PROPERTY_INDEX={aria:1,clipHeight:1,columnPadding:1,columns:1,cornerRadius:1,description:1,direction:1,fillColor:1,format:1,formatType:1,gradientLength:1,gradientOpacity:1,gradientStrokeColor:1,gradientStrokeWidth:1,gradientThickness:1,gridAlign:1,labelAlign:1,labelBaseline:1,labelColor:1,labelFont:1,labelFontSize:1,labelFontStyle:1,labelFontWeight:1,labelLimit:1,labelOffset:1,labelOpacity:1,labelOverlap:1,labelPadding:1,labelSeparation:1,legendX:1,legendY:1,offset:1,orient:1,padding:1,rowPadding:1,strokeColor:1,symbolDash:1,symbolDashOffset:1,symbolFillColor:1,symbolLimit:1,symbolOffset:1,symbolOpacity:1,symbolSize:1,symbolStrokeColor:1,symbolStrokeWidth:1,symbolType:1,tickCount:1,tickMinStep:1,title:1,titleAlign:1,titleAnchor:1,titleBaseline:1,titleColor:1,titleFont:1,titleFontSize:1,titleFontStyle:1,titleFontWeight:1,titleLimit:1,titleLineHeight:1,titleOpacity:1,titleOrient:1,titlePadding:1,type:1,values:1,zindex:1};const LEGEND_PROPERTIES=keys(COMMON_LEGEND_PROPERTY_INDEX);const SELECTION_ID="_vgsid_";const defaultConfig={point:{on:"click",fields:[SELECTION_ID],toggle:"event.shiftKey",resolve:"global",clear:"dblclick"},interval:{on:"[pointerdown, window:pointerup] > window:pointermove!",encodings:["x","y"],translate:"[pointerdown, window:pointerup] > window:pointermove!",zoom:"wheel!",mark:{fill:"#333",fillOpacity:.125,stroke:"white"},resolve:"global",clear:"dblclick"}};function isLegendBinding(bind){return bind==="legend"||!!(bind!==null&&bind!==void 0&&bind.legend)}function isLegendStreamBinding(bind){return isLegendBinding(bind)&&Object(vega_util["isObject"])(bind)}function isSelectionParameter(param){return!!(param!==null&&param!==void 0&&param["select"])}function assembleParameterSignals(params){const signals=[];for(const param of params||[]){if(isSelectionParameter(param))continue;const{expr:expr,bind:bind,...rest}=param;if(bind&&expr){const signal={...rest,bind:bind,init:expr};signals.push(signal)}else{const signal={...rest,...expr?{update:expr}:{},...bind?{bind:bind}:{}};signals.push(signal)}}return signals}function isAnyConcatSpec(spec){return isVConcatSpec(spec)||isHConcatSpec(spec)||isConcatSpec(spec)}function isConcatSpec(spec){return hasProperty(spec,"concat")}function isVConcatSpec(spec){return hasProperty(spec,"vconcat")}function isHConcatSpec(spec){return hasProperty(spec,"hconcat")}function getStepFor(_ref){let{step:step,offsetIsDiscrete:offsetIsDiscrete}=_ref;if(offsetIsDiscrete){var _step$for;return(_step$for=step.for)!==null&&_step$for!==void 0?_step$for:"offset"}else{return"position"}}function isStep(size){return hasProperty(size,"step")}function isFrameMixins(o){return hasProperty(o,"view")||hasProperty(o,"width")||hasProperty(o,"height")}const DEFAULT_SPACING=20;const COMPOSITION_LAYOUT_INDEX={align:1,bounds:1,center:1,columns:1,spacing:1};const COMPOSITION_LAYOUT_PROPERTIES=keys(COMPOSITION_LAYOUT_INDEX);function extractCompositionLayout(spec,specType,config){const compositionConfig=config[specType];const layout={};const{spacing:spacingConfig,columns:columns}=compositionConfig;if(spacingConfig!==undefined){layout.spacing=spacingConfig}if(columns!==undefined){if(isFacetSpec(spec)&&!isFacetMapping(spec.facet)||isConcatSpec(spec)){layout.columns=columns}}if(isVConcatSpec(spec)){layout.columns=1}for(const prop of COMPOSITION_LAYOUT_PROPERTIES){if(spec[prop]!==undefined){if(prop==="spacing"){var _spacing$row,_spacing$column;const spacing=spec[prop];layout[prop]=Object(vega_util["isNumber"])(spacing)?spacing:{row:(_spacing$row=spacing.row)!==null&&_spacing$row!==void 0?_spacing$row:spacingConfig,column:(_spacing$column=spacing.column)!==null&&_spacing$column!==void 0?_spacing$column:spacingConfig}}else{layout[prop]=spec[prop]}}}return layout}function getViewConfigContinuousSize(viewConfig,channel){var _channel;return(_channel=viewConfig[channel])!==null&&_channel!==void 0?_channel:viewConfig[channel==="width"?"continuousWidth":"continuousHeight"]}function getViewConfigDiscreteStep(viewConfig,channel){const size=getViewConfigDiscreteSize(viewConfig,channel);return isStep(size)?size.step:DEFAULT_STEP}function getViewConfigDiscreteSize(viewConfig,channel){var _channel2;const size=(_channel2=viewConfig[channel])!==null&&_channel2!==void 0?_channel2:viewConfig[channel==="width"?"discreteWidth":"discreteHeight"];return getFirstDefined(size,{step:viewConfig.step})}const DEFAULT_STEP=20;const defaultViewConfig={continuousWidth:200,continuousHeight:200,step:DEFAULT_STEP};function isVgScheme(rangeScheme){return hasProperty(rangeScheme,"scheme")}const config_defaultConfig={background:"white",padding:5,timeFormat:"%b %d, %Y",countTitle:"Count of Records",view:defaultViewConfig,mark:defaultMarkConfig,arc:{},area:{},bar:defaultBarConfig,circle:{},geoshape:{},image:{},line:{},point:{},rect:defaultRectConfig,rule:{color:"black"},square:{},text:{color:"black"},tick:defaultTickConfig,trail:{},boxplot:{size:14,extent:1.5,box:{},median:{color:"white"},outliers:{},rule:{},ticks:null},errorbar:{center:"mean",rule:true,ticks:false},errorband:{band:{opacity:.3},borders:false},scale:defaultScaleConfig,projection:{},legend:defaultLegendConfig,header:{titlePadding:10,labelPadding:10},headerColumn:{},headerRow:{},headerFacet:{},selection:defaultConfig,style:{},title:{},facet:{spacing:DEFAULT_SPACING},concat:{spacing:DEFAULT_SPACING},normalizedNumberFormat:".0%"};const tab10=["#4c78a8","#f58518","#e45756","#72b7b2","#54a24b","#eeca3b","#b279a2","#ff9da6","#9d755d","#bab0ac"];const DEFAULT_FONT_SIZE={text:11,guideLabel:10,guideTitle:11,groupTitle:13,groupSubtitle:12};const DEFAULT_COLOR={blue:tab10[0],orange:tab10[1],red:tab10[2],teal:tab10[3],green:tab10[4],yellow:tab10[5],purple:tab10[6],pink:tab10[7],brown:tab10[8],gray0:"#000",gray1:"#111",gray2:"#222",gray3:"#333",gray4:"#444",gray5:"#555",gray6:"#666",gray7:"#777",gray8:"#888",gray9:"#999",gray10:"#aaa",gray11:"#bbb",gray12:"#ccc",gray13:"#ddd",gray14:"#eee",gray15:"#fff"};function colorSignalConfig(){let color=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};return{signals:[{name:"color",value:Object(vega_util["isObject"])(color)?{...DEFAULT_COLOR,...color}:DEFAULT_COLOR}],mark:{color:{signal:"color.blue"}},rule:{color:{signal:"color.gray0"}},text:{color:{signal:"color.gray0"}},style:{"guide-label":{fill:{signal:"color.gray0"}},"guide-title":{fill:{signal:"color.gray0"}},"group-title":{fill:{signal:"color.gray0"}},"group-subtitle":{fill:{signal:"color.gray0"}},cell:{stroke:{signal:"color.gray8"}}},axis:{domainColor:{signal:"color.gray13"},gridColor:{signal:"color.gray8"},tickColor:{signal:"color.gray13"}},range:{category:[{signal:"color.blue"},{signal:"color.orange"},{signal:"color.red"},{signal:"color.teal"},{signal:"color.green"},{signal:"color.yellow"},{signal:"color.purple"},{signal:"color.pink"},{signal:"color.brown"},{signal:"color.grey8"}]}}}function fontSizeSignalConfig(fontSize){return{signals:[{name:"fontSize",value:Object(vega_util["isObject"])(fontSize)?{...DEFAULT_FONT_SIZE,...fontSize}:DEFAULT_FONT_SIZE}],text:{fontSize:{signal:"fontSize.text"}},style:{"guide-label":{fontSize:{signal:"fontSize.guideLabel"}},"guide-title":{fontSize:{signal:"fontSize.guideTitle"}},"group-title":{fontSize:{signal:"fontSize.groupTitle"}},"group-subtitle":{fontSize:{signal:"fontSize.groupSubtitle"}}}}}function fontConfig(font){return{text:{font:font},style:{"guide-label":{font:font},"guide-title":{font:font},"group-title":{font:font},"group-subtitle":{font:font}}}}function getAxisConfigInternal(axisConfig){const props=keys(axisConfig||{});const axisConfigInternal={};for(const prop of props){const val=axisConfig[prop];axisConfigInternal[prop]=isConditionalAxisValue(val)?signalOrValueRefWithCondition(val):signalRefOrValue(val)}return axisConfigInternal}function getStyleConfigInternal(styleConfig){const props=keys(styleConfig);const styleConfigInternal={};for(const prop of props){styleConfigInternal[prop]=getAxisConfigInternal(styleConfig[prop])}return styleConfigInternal}const configPropsWithExpr=[...MARK_CONFIGS,...AXIS_CONFIGS,...HEADER_CONFIGS,"background","padding","legend","lineBreak","scale","style","title","view"];function initConfig(){let specifiedConfig=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const{color:color,font:font,fontSize:fontSize,selection:selection,...restConfig}=specifiedConfig;const mergedConfig=Object(vega_util["mergeConfig"])({},duplicate(config_defaultConfig),font?fontConfig(font):{},color?colorSignalConfig(color):{},fontSize?fontSizeSignalConfig(fontSize):{},restConfig||{});if(selection){Object(vega_util["writeConfig"])(mergedConfig,"selection",selection,true)}const outputConfig=omit(mergedConfig,configPropsWithExpr);for(const prop of["background","lineBreak","padding"]){if(mergedConfig[prop]){outputConfig[prop]=signalRefOrValue(mergedConfig[prop])}}for(const markConfigType of MARK_CONFIGS){if(mergedConfig[markConfigType]){outputConfig[markConfigType]=replaceExprRef(mergedConfig[markConfigType])}}for(const axisConfigType of AXIS_CONFIGS){if(mergedConfig[axisConfigType]){outputConfig[axisConfigType]=getAxisConfigInternal(mergedConfig[axisConfigType])}}for(const headerConfigType of HEADER_CONFIGS){if(mergedConfig[headerConfigType]){outputConfig[headerConfigType]=replaceExprRef(mergedConfig[headerConfigType])}}if(mergedConfig.legend){outputConfig.legend=replaceExprRef(mergedConfig.legend)}if(mergedConfig.scale){const{invalid:invalid,...otherScaleConfig}=mergedConfig.scale;const newScaleInvalid=replaceExprRef(invalid,{level:1});outputConfig.scale={...replaceExprRef(otherScaleConfig),...keys(newScaleInvalid).length>0?{invalid:newScaleInvalid}:{}}}if(mergedConfig.style){outputConfig.style=getStyleConfigInternal(mergedConfig.style)}if(mergedConfig.title){outputConfig.title=replaceExprRef(mergedConfig.title)}if(mergedConfig.view){outputConfig.view=replaceExprRef(mergedConfig.view)}return outputConfig}const MARK_STYLES=new Set(["view",...PRIMITIVE_MARKS]);const VL_ONLY_CONFIG_PROPERTIES=["color","fontSize","background","padding","facet","concat","numberFormat","numberFormatType","normalizedNumberFormat","normalizedNumberFormatType","timeFormat","countTitle","header","axisQuantitative","axisTemporal","axisDiscrete","axisPoint","axisXBand","axisXPoint","axisXDiscrete","axisXQuantitative","axisXTemporal","axisYBand","axisYPoint","axisYDiscrete","axisYQuantitative","axisYTemporal","scale","selection","overlay"];const VL_ONLY_ALL_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX={view:["continuousWidth","continuousHeight","discreteWidth","discreteHeight","step"],...VL_ONLY_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX};function stripAndRedirectConfig(config){config=duplicate(config);for(const prop of VL_ONLY_CONFIG_PROPERTIES){delete config[prop]}if(config.axis){for(const prop in config.axis){if(isConditionalAxisValue(config.axis[prop])){delete config.axis[prop]}}}if(config.legend){for(const prop of VL_ONLY_LEGEND_CONFIG){delete config.legend[prop]}}if(config.mark){for(const prop of VL_ONLY_MARK_CONFIG_PROPERTIES){delete config.mark[prop]}if(config.mark.tooltip&&Object(vega_util["isObject"])(config.mark.tooltip)){delete config.mark.tooltip}}if(config.params){config.signals=(config.signals||[]).concat(assembleParameterSignals(config.params));delete config.params}for(const markType of MARK_STYLES){for(const prop of VL_ONLY_MARK_CONFIG_PROPERTIES){delete config[markType][prop]}const vlOnlyMarkSpecificConfigs=VL_ONLY_ALL_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX[markType];if(vlOnlyMarkSpecificConfigs){for(const prop of vlOnlyMarkSpecificConfigs){delete config[markType][prop]}}redirectConfigToStyleConfig(config,markType)}for(const m of getAllCompositeMarks()){delete config[m]}redirectTitleConfig(config);for(const prop in config){if(Object(vega_util["isObject"])(config[prop])&&isEmpty(config[prop])){delete config[prop]}}return isEmpty(config)?undefined:config}function redirectTitleConfig(config){const{titleMarkConfig:titleMarkConfig,subtitleMarkConfig:subtitleMarkConfig,subtitle:subtitle}=extractTitleConfig(config.title);if(!isEmpty(titleMarkConfig)){config.style["group-title"]={...config.style["group-title"],...titleMarkConfig}}if(!isEmpty(subtitleMarkConfig)){config.style["group-subtitle"]={...config.style["group-subtitle"],...subtitleMarkConfig}}if(!isEmpty(subtitle)){config.title=subtitle}else{delete config.title}}function redirectConfigToStyleConfig(config,prop,toProp,compositeMarkPart){var _toProp;const propConfig=compositeMarkPart?config[prop][compositeMarkPart]:config[prop];if(prop==="view"){toProp="cell"}const style={...propConfig,...config.style[(_toProp=toProp)!==null&&_toProp!==void 0?_toProp:prop]};if(!isEmpty(style)){var _toProp2;config.style[(_toProp2=toProp)!==null&&_toProp2!==void 0?_toProp2:prop]=style}if(!compositeMarkPart){delete config[prop]}}function isLayerSpec(spec){return hasProperty(spec,"layer")}function isRepeatSpec(spec){return hasProperty(spec,"repeat")}function isLayerRepeatSpec(spec){return!Object(vega_util["isArray"])(spec.repeat)&&hasProperty(spec.repeat,"layer")}class map_SpecMapper{map(spec,params){if(isFacetSpec(spec)){return this.mapFacet(spec,params)}else if(isRepeatSpec(spec)){return this.mapRepeat(spec,params)}else if(isHConcatSpec(spec)){return this.mapHConcat(spec,params)}else if(isVConcatSpec(spec)){return this.mapVConcat(spec,params)}else if(isConcatSpec(spec)){return this.mapConcat(spec,params)}else{return this.mapLayerOrUnit(spec,params)}}mapLayerOrUnit(spec,params){if(isLayerSpec(spec)){return this.mapLayer(spec,params)}else if(isUnitSpec(spec)){return this.mapUnit(spec,params)}throw new Error(message_namespaceObject.invalidSpec(spec))}mapLayer(spec,params){return{...spec,layer:spec.layer.map(subspec=>this.mapLayerOrUnit(subspec,params))}}mapHConcat(spec,params){return{...spec,hconcat:spec.hconcat.map(subspec=>this.map(subspec,params))}}mapVConcat(spec,params){return{...spec,vconcat:spec.vconcat.map(subspec=>this.map(subspec,params))}}mapConcat(spec,params){const{concat:concat,...rest}=spec;return{...rest,concat:concat.map(subspec=>this.map(subspec,params))}}mapFacet(spec,params){return{...spec,spec:this.map(spec.spec,params)}}mapRepeat(spec,params){return{...spec,spec:this.map(spec.spec,params)}}}const STACK_OFFSET_INDEX={zero:1,center:1,normalize:1};function isStackOffset(s){return Object(vega_util["hasOwnProperty"])(STACK_OFFSET_INDEX,s)}const STACKABLE_MARKS=new Set([ARC,BAR,AREA,RULE,POINT,CIRCLE,SQUARE,LINE,mark_TEXT,TICK]);const STACK_BY_DEFAULT_MARKS=new Set([BAR,AREA,ARC]);function isUnbinnedQuantitative(channelDef){return isFieldDef(channelDef)&&channelDefType(channelDef)==="quantitative"&&!channelDef.bin}function potentialStackedChannel(encoding,x,_ref){let{orient:orient,type:mark}=_ref;const y=x==="x"?"y":"radius";const isCartesianBarOrArea=x==="x"&&["bar","area"].includes(mark);const xDef=encoding[x];const yDef=encoding[y];if(isFieldDef(xDef)&&isFieldDef(yDef)){if(isUnbinnedQuantitative(xDef)&&isUnbinnedQuantitative(yDef)){if(xDef.stack){return x}else if(yDef.stack){return y}const xAggregate=isFieldDef(xDef)&&!!xDef.aggregate;const yAggregate=isFieldDef(yDef)&&!!yDef.aggregate;if(xAggregate!==yAggregate){return xAggregate?x:y}if(isCartesianBarOrArea){if(orient==="vertical"){return y}else if(orient==="horizontal"){return x}}}else if(isUnbinnedQuantitative(xDef)){return x}else if(isUnbinnedQuantitative(yDef)){return y}}else if(isUnbinnedQuantitative(xDef)){if(isCartesianBarOrArea&&orient==="vertical"){return undefined}return x}else if(isUnbinnedQuantitative(yDef)){if(isCartesianBarOrArea&&orient==="horizontal"){return undefined}return y}return undefined}function getDimensionChannel(channel){switch(channel){case"x":return"y";case"y":return"x";case"theta":return"radius";case"radius":return"theta"}}function stack_stack(m,encoding){var _stackedFieldDef$scal,_stackedFieldDef$scal2;const markDef=isMarkDef(m)?m:{type:m};const mark=markDef.type;if(!STACKABLE_MARKS.has(mark)){return null}const fieldChannel=potentialStackedChannel(encoding,"x",markDef)||potentialStackedChannel(encoding,"theta",markDef);if(!fieldChannel){return null}const stackedFieldDef=encoding[fieldChannel];const stackedField=isFieldDef(stackedFieldDef)?vgField(stackedFieldDef,{}):undefined;const dimensionChannel=getDimensionChannel(fieldChannel);const groupbyChannels=[];const groupbyFields=new Set;if(encoding[dimensionChannel]){const dimensionDef=encoding[dimensionChannel];const dimensionField=isFieldDef(dimensionDef)?vgField(dimensionDef,{}):undefined;if(dimensionField&&dimensionField!==stackedField){groupbyChannels.push(dimensionChannel);groupbyFields.add(dimensionField)}}const dimensionOffsetChannel=dimensionChannel==="x"?"xOffset":"yOffset";const dimensionOffsetDef=encoding[dimensionOffsetChannel];const dimensionOffsetField=isFieldDef(dimensionOffsetDef)?vgField(dimensionOffsetDef,{}):undefined;if(dimensionOffsetField&&dimensionOffsetField!==stackedField){groupbyChannels.push(dimensionOffsetChannel);groupbyFields.add(dimensionOffsetField)}const stackBy=NONPOSITION_CHANNELS.reduce((sc,channel)=>{if(channel!=="tooltip"&&channelHasField(encoding,channel)){const channelDef=encoding[channel];for(const cDef of Object(vega_util["array"])(channelDef)){const fieldDef=getFieldDef(cDef);if(fieldDef.aggregate){continue}const f=vgField(fieldDef,{});if(!f||!groupbyFields.has(f)){sc.push({channel:channel,fieldDef:fieldDef})}}}return sc},[]);let offset;if(stackedFieldDef.stack!==undefined){if(Object(vega_util["isBoolean"])(stackedFieldDef.stack)){offset=stackedFieldDef.stack?"zero":null}else{offset=stackedFieldDef.stack}}else if(STACK_BY_DEFAULT_MARKS.has(mark)){offset="zero"}if(!offset||!isStackOffset(offset)){return null}if(encoding_isAggregate(encoding)&&stackBy.length===0){return null}if(stackedFieldDef!==null&&stackedFieldDef!==void 0&&(_stackedFieldDef$scal=stackedFieldDef.scale)!==null&&_stackedFieldDef$scal!==void 0&&_stackedFieldDef$scal.type&&(stackedFieldDef===null||stackedFieldDef===void 0||(_stackedFieldDef$scal2=stackedFieldDef.scale)===null||_stackedFieldDef$scal2===void 0?void 0:_stackedFieldDef$scal2.type)!==ScaleType.LINEAR){if(stackedFieldDef!==null&&stackedFieldDef!==void 0&&stackedFieldDef.stack){warn(message_namespaceObject.stackNonLinearScale(stackedFieldDef.scale.type))}}if(isFieldOrDatumDef(encoding[getSecondaryRangeChannel(fieldChannel)])){if(stackedFieldDef.stack!==undefined){warn(message_namespaceObject.cannotStackRangedMark(fieldChannel))}return null}if(isFieldDef(stackedFieldDef)&&stackedFieldDef.aggregate&&!SUM_OPS.has(stackedFieldDef.aggregate)){warn(message_namespaceObject.stackNonSummativeAggregate(stackedFieldDef.aggregate))}return{groupbyChannels:groupbyChannels,groupbyFields:groupbyFields,fieldChannel:fieldChannel,impute:stackedFieldDef.impute===null?false:isPathMark(mark),stackBy:stackBy,offset:offset}}function initMarkdef(originalMarkDef,encoding,config){const markDef=replaceExprRef(originalMarkDef);const specifiedOrient=getMarkPropOrConfig("orient",markDef,config);markDef.orient=init_orient(markDef.type,encoding,specifiedOrient);if(specifiedOrient!==undefined&&specifiedOrient!==markDef.orient){warn(message_namespaceObject.orientOverridden(markDef.orient,specifiedOrient))}if(markDef.type==="bar"&&markDef.orient){const cornerRadiusEnd=getMarkPropOrConfig("cornerRadiusEnd",markDef,config);if(cornerRadiusEnd!==undefined){const newProps=markDef.orient==="horizontal"&&encoding.x2||markDef.orient==="vertical"&&encoding.y2?["cornerRadius"]:BAR_CORNER_RADIUS_INDEX[markDef.orient];for(const newProp of newProps){markDef[newProp]=cornerRadiusEnd}if(markDef.cornerRadiusEnd!==undefined){delete markDef.cornerRadiusEnd}}}const specifiedOpacity=getMarkPropOrConfig("opacity",markDef,config);const specifiedfillOpacity=getMarkPropOrConfig("fillOpacity",markDef,config);if(specifiedOpacity===undefined&&specifiedfillOpacity===undefined){markDef.opacity=init_opacity(markDef.type,encoding)}const specifiedCursor=getMarkPropOrConfig("cursor",markDef,config);if(specifiedCursor===undefined){markDef.cursor=init_cursor(markDef,encoding,config)}return markDef}function init_cursor(markDef,encoding,config){if(encoding.href||markDef.href||getMarkPropOrConfig("href",markDef,config)){return"pointer"}return markDef.cursor}function init_opacity(mark,encoding){if(util_contains([POINT,TICK,CIRCLE,SQUARE],mark)){if(!encoding_isAggregate(encoding)){return.7}}return undefined}function defaultFilled(markDef,config,_ref){let{graticule:graticule}=_ref;if(graticule){return false}const filledConfig=getMarkConfig("filled",markDef,config);const mark=markDef.type;return getFirstDefined(filledConfig,mark!==POINT&&mark!==LINE&&mark!==RULE)}function init_orient(mark,encoding,specifiedOrient){switch(mark){case POINT:case CIRCLE:case SQUARE:case mark_TEXT:case RECT:case IMAGE:return undefined}const{x:x,y:y,x2:x2,y2:y2}=encoding;switch(mark){case BAR:if(isFieldDef(x)&&(isBinned(x.bin)||isFieldDef(y)&&y.aggregate&&!x.aggregate)){return"vertical"}if(isFieldDef(y)&&(isBinned(y.bin)||isFieldDef(x)&&x.aggregate&&!y.aggregate)){return"horizontal"}if(y2||x2){if(specifiedOrient){return specifiedOrient}if(!x2){if(isFieldDef(x)&&x.type===QUANTITATIVE&&!isBinning(x.bin)||isNumericDataDef(x)){if(isFieldDef(y)&&isBinned(y.bin)){return"horizontal"}}return"vertical"}if(!y2){if(isFieldDef(y)&&y.type===QUANTITATIVE&&!isBinning(y.bin)||isNumericDataDef(y)){if(isFieldDef(x)&&isBinned(x.bin)){return"vertical"}}return"horizontal"}}case RULE:if(x2&&!(isFieldDef(x)&&isBinned(x.bin))&&y2&&!(isFieldDef(y)&&isBinned(y.bin))){return undefined}case AREA:if(y2){if(isFieldDef(y)&&isBinned(y.bin)){return"horizontal"}else{return"vertical"}}else if(x2){if(isFieldDef(x)&&isBinned(x.bin)){return"vertical"}else{return"horizontal"}}else if(mark===RULE){if(x&&!y){return"vertical"}else if(y&&!x){return"horizontal"}}case LINE:case TICK:{const xIsMeasure=isUnbinnedQuantitativeFieldOrDatumDef(x);const yIsMeasure=isUnbinnedQuantitativeFieldOrDatumDef(y);if(specifiedOrient){return specifiedOrient}else if(xIsMeasure&&!yIsMeasure){return mark!=="tick"?"horizontal":"vertical"}else if(!xIsMeasure&&yIsMeasure){return mark!=="tick"?"vertical":"horizontal"}else if(xIsMeasure&&yIsMeasure){return"vertical"}else{const xIsTemporal=isTypedFieldDef(x)&&x.type===TEMPORAL;const yIsTemporal=isTypedFieldDef(y)&&y.type===TEMPORAL;if(xIsTemporal&&!yIsTemporal){return"vertical"}else if(!xIsTemporal&&yIsTemporal){return"horizontal"}}return undefined}}return"vertical"}function pathoverlay_defineProperty(e,r,t){return(r=pathoverlay_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function pathoverlay_toPropertyKey(t){var i=pathoverlay_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function pathoverlay_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}function dropLineAndPoint(markDef){const{point:_point,line:_line,...mark}=markDef;return keys(mark).length>1?mark:mark.type}function dropLineAndPointFromConfig(config){for(const mark of["line","area","rule","trail"]){if(config[mark]){config={...config,[mark]:omit(config[mark],["point","line"])}}}return config}function getPointOverlay(markDef){let markConfig=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let encoding=arguments.length>2?arguments[2]:undefined;if(markDef.point==="transparent"){return{opacity:0}}else if(markDef.point){return Object(vega_util["isObject"])(markDef.point)?markDef.point:{}}else if(markDef.point!==undefined){return null}else{if(markConfig.point||encoding.shape){return Object(vega_util["isObject"])(markConfig.point)?markConfig.point:{}}return undefined}}function getLineOverlay(markDef){let markConfig=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(markDef.line){return markDef.line===true?{}:markDef.line}else if(markDef.line!==undefined){return null}else{if(markConfig.line){return markConfig.line===true?{}:markConfig.line}return undefined}}class pathoverlay_PathOverlayNormalizer{constructor(){pathoverlay_defineProperty(this,"name","path-overlay")}hasMatchingType(spec,config){if(isUnitSpec(spec)){const{mark:mark,encoding:encoding}=spec;const markDef=isMarkDef(mark)?mark:{type:mark};switch(markDef.type){case"line":case"rule":case"trail":return!!getPointOverlay(markDef,config[markDef.type],encoding);case"area":return!!getPointOverlay(markDef,config[markDef.type],encoding)||!!getLineOverlay(markDef,config[markDef.type])}}return false}run(spec,normParams,normalize){const{config:config}=normParams;const{params:params,projection:projection,mark:mark,name:name,encoding:e,...outerSpec}=spec;const encoding=normalizeEncoding(e,config);const markDef=isMarkDef(mark)?mark:{type:mark};const pointOverlay=getPointOverlay(markDef,config[markDef.type],encoding);const lineOverlay=markDef.type==="area"&&getLineOverlay(markDef,config[markDef.type]);const layer=[{name:name,...params?{params:params}:{},mark:dropLineAndPoint({...markDef.type==="area"&&markDef.opacity===undefined&&markDef.fillOpacity===undefined?{opacity:.7}:{},...markDef}),encoding:omit(encoding,["shape"])}];const stackProps=stack_stack(initMarkdef(markDef,encoding,config),encoding);let overlayEncoding=encoding;if(stackProps){const{fieldChannel:stackFieldChannel,offset:offset}=stackProps;overlayEncoding={...encoding,[stackFieldChannel]:{...encoding[stackFieldChannel],...offset?{stack:offset}:{}}}}overlayEncoding=omit(overlayEncoding,["y2","x2"]);if(lineOverlay){layer.push({...projection?{projection:projection}:{},mark:{type:"line",...pick(markDef,["clip","interpolate","tension","tooltip"]),...lineOverlay},encoding:overlayEncoding})}if(pointOverlay){layer.push({...projection?{projection:projection}:{},mark:{type:"point",opacity:1,filled:true,...pick(markDef,["clip","tooltip"]),...pointOverlay},encoding:overlayEncoding})}return normalize({...outerSpec,layer:layer},{...normParams,config:dropLineAndPointFromConfig(config)})}}function replaceRepeaterInFacet(facet,repeater){if(!repeater){return facet}if(isFacetMapping(facet)){return replaceRepeaterInMapping(facet,repeater)}return replaceRepeaterInFieldDef(facet,repeater)}function replaceRepeaterInEncoding(encoding,repeater){if(!repeater){return encoding}return replaceRepeaterInMapping(encoding,repeater)}function replaceRepeatInProp(prop,o,repeater){const val=o[prop];if(isRepeatRef(val)){if(val.repeat in repeater){return{...o,[prop]:repeater[val.repeat]}}else{warn(message_namespaceObject.noSuchRepeatedValue(val.repeat));return undefined}}return o}function replaceRepeaterInFieldDef(fieldDef,repeater){fieldDef=replaceRepeatInProp("field",fieldDef,repeater);if(fieldDef===undefined){return undefined}else if(fieldDef===null){return null}if(isSortableFieldDef(fieldDef)&&isSortField(fieldDef.sort)){const sort=replaceRepeatInProp("field",fieldDef.sort,repeater);fieldDef={...fieldDef,...sort?{sort:sort}:{}}}return fieldDef}function replaceRepeaterInFieldOrDatumDef(def,repeater){if(isFieldDef(def)){return replaceRepeaterInFieldDef(def,repeater)}else{const datumDef=replaceRepeatInProp("datum",def,repeater);if(datumDef!==def&&!datumDef.type){datumDef.type="nominal"}return datumDef}}function replaceRepeaterInChannelDef(channelDef,repeater){if(isFieldOrDatumDef(channelDef)){const fd=replaceRepeaterInFieldOrDatumDef(channelDef,repeater);if(fd){return fd}else if(isConditionalDef(channelDef)){return{condition:channelDef.condition}}}else{if(hasConditionalFieldOrDatumDef(channelDef)){const fd=replaceRepeaterInFieldOrDatumDef(channelDef.condition,repeater);if(fd){return{...channelDef,condition:fd}}else{const{condition:condition,...channelDefWithoutCondition}=channelDef;return channelDefWithoutCondition}}return channelDef}return undefined}function replaceRepeaterInMapping(mapping,repeater){const out={};for(const channel in mapping){if(hasProperty(mapping,channel)){const channelDef=mapping[channel];if(Object(vega_util["isArray"])(channelDef)){out[channel]=channelDef.map(cd=>replaceRepeaterInChannelDef(cd,repeater)).filter(cd=>cd)}else{const cd=replaceRepeaterInChannelDef(channelDef,repeater);if(cd!==undefined){out[channel]=cd}}}}return out}function ruleforrangedline_defineProperty(e,r,t){return(r=ruleforrangedline_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function ruleforrangedline_toPropertyKey(t){var i=ruleforrangedline_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function ruleforrangedline_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class ruleforrangedline_RuleForRangedLineNormalizer{constructor(){ruleforrangedline_defineProperty(this,"name","RuleForRangedLine")}hasMatchingType(spec){if(isUnitSpec(spec)){const{encoding:encoding,mark:mark}=spec;if(mark==="line"||isMarkDef(mark)&&mark.type==="line"){for(const channel of SECONDARY_RANGE_CHANNEL){const mainChannel=getMainRangeChannel(channel);const mainChannelDef=encoding[mainChannel];if(encoding[channel]){if(isFieldDef(mainChannelDef)&&!isBinned(mainChannelDef.bin)||isDatumDef(mainChannelDef)){return true}}}}}return false}run(spec,params,normalize){const{encoding:encoding,mark:mark}=spec;warn(message_namespaceObject.lineWithRange(!!encoding.x2,!!encoding.y2));return normalize({...spec,mark:Object(vega_util["isObject"])(mark)?{...mark,type:"rule"}:"rule"},params)}}function core_defineProperty(e,r,t){return(r=core_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function core_toPropertyKey(t){var i=core_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function core_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class core_CoreNormalizer extends map_SpecMapper{constructor(){super(...arguments);core_defineProperty(this,"nonFacetUnitNormalizers",[boxPlotNormalizer,errorBarNormalizer,errorBandNormalizer,new pathoverlay_PathOverlayNormalizer,new ruleforrangedline_RuleForRangedLineNormalizer])}map(spec,params){if(isUnitSpec(spec)){const hasRow=channelHasField(spec.encoding,ROW);const hasColumn=channelHasField(spec.encoding,COLUMN);const hasFacet=channelHasField(spec.encoding,FACET);if(hasRow||hasColumn||hasFacet){return this.mapFacetedUnit(spec,params)}}return super.map(spec,params)}mapUnit(spec,params){const{parentEncoding:parentEncoding,parentProjection:parentProjection}=params;const encoding=replaceRepeaterInEncoding(spec.encoding,params.repeater);const specWithReplacedEncoding={...spec,...spec.name?{name:[params.repeaterPrefix,spec.name].filter(n=>n).join("_")}:{},...encoding?{encoding:encoding}:{}};if(parentEncoding||parentProjection){return this.mapUnitWithParentEncodingOrProjection(specWithReplacedEncoding,params)}const normalizeLayerOrUnit=this.mapLayerOrUnit.bind(this);for(const unitNormalizer of this.nonFacetUnitNormalizers){if(unitNormalizer.hasMatchingType(specWithReplacedEncoding,params.config)){return unitNormalizer.run(specWithReplacedEncoding,params,normalizeLayerOrUnit)}}return specWithReplacedEncoding}mapRepeat(spec,params){if(isLayerRepeatSpec(spec)){return this.mapLayerRepeat(spec,params)}else{return this.mapNonLayerRepeat(spec,params)}}mapLayerRepeat(spec,params){const{repeat:repeat,spec:childSpec,...rest}=spec;const{row:row,column:column,layer:layer}=repeat;const{repeater:repeater={},repeaterPrefix:repeaterPrefix=""}=params;if(row||column){return this.mapRepeat({...spec,repeat:{...row?{row:row}:{},...column?{column:column}:{}},spec:{repeat:{layer:layer},spec:childSpec}},params)}else{return{...rest,layer:layer.map(layerValue=>{const childRepeater={...repeater,layer:layerValue};const childName=`${(childSpec.name?`${childSpec.name}_`:"")+repeaterPrefix}child__layer_${varName(layerValue)}`;const child=this.mapLayerOrUnit(childSpec,{...params,repeater:childRepeater,repeaterPrefix:childName});child.name=childName;return child})}}}mapNonLayerRepeat(spec,params){var _childSpec$data;const{repeat:repeat,spec:childSpec,data:data,...remainingProperties}=spec;if(!Object(vega_util["isArray"])(repeat)&&spec.columns){spec=omit(spec,["columns"]);warn(message_namespaceObject.columnsNotSupportByRowCol("repeat"))}const concat=[];const{repeater:repeater={},repeaterPrefix:repeaterPrefix=""}=params;const row=!Object(vega_util["isArray"])(repeat)&&repeat.row||[repeater?repeater.row:null];const column=!Object(vega_util["isArray"])(repeat)&&repeat.column||[repeater?repeater.column:null];const repeatValues=Object(vega_util["isArray"])(repeat)&&repeat||[repeater?repeater.repeat:null];for(const repeatValue of repeatValues){for(const rowValue of row){for(const columnValue of column){const childRepeater={repeat:repeatValue,row:rowValue,column:columnValue,layer:repeater.layer};const childName=(childSpec.name?`${childSpec.name}_`:"")+repeaterPrefix+"child__"+(Object(vega_util["isArray"])(repeat)?`${varName(repeatValue)}`:(repeat.row?`row_${varName(rowValue)}`:"")+(repeat.column?`column_${varName(columnValue)}`:""));const child=this.map(childSpec,{...params,repeater:childRepeater,repeaterPrefix:childName});child.name=childName;concat.push(omit(child,["data"]))}}}const columns=Object(vega_util["isArray"])(repeat)?spec.columns:repeat.column?repeat.column.length:1;return{data:(_childSpec$data=childSpec.data)!==null&&_childSpec$data!==void 0?_childSpec$data:data,align:"all",...remainingProperties,columns:columns,concat:concat}}mapFacet(spec,params){const{facet:facet}=spec;if(isFacetMapping(facet)&&spec.columns){spec=omit(spec,["columns"]);warn(message_namespaceObject.columnsNotSupportByRowCol("facet"))}return super.mapFacet(spec,params)}mapUnitWithParentEncodingOrProjection(spec,params){const{encoding:encoding,projection:projection}=spec;const{parentEncoding:parentEncoding,parentProjection:parentProjection,config:config}=params;const mergedProjection=mergeProjection({parentProjection:parentProjection,projection:projection});const mergedEncoding=mergeEncoding({parentEncoding:parentEncoding,encoding:replaceRepeaterInEncoding(encoding,params.repeater)});return this.mapUnit({...spec,...mergedProjection?{projection:mergedProjection}:{},...mergedEncoding?{encoding:mergedEncoding}:{}},{config:config})}mapFacetedUnit(spec,normParams){const{row:row,column:column,facet:facet,...encoding}=spec.encoding;const{mark:mark,width:width,projection:projection,height:height,view:view,params:params,encoding:_,...outerSpec}=spec;const{facetMapping:facetMapping,layout:layout}=this.getFacetMappingAndLayout({row:row,column:column,facet:facet},normParams);const newEncoding=replaceRepeaterInEncoding(encoding,normParams.repeater);return this.mapFacet({...outerSpec,...layout,facet:facetMapping,spec:{...width?{width:width}:{},...height?{height:height}:{},...view?{view:view}:{},...projection?{projection:projection}:{},mark:mark,encoding:newEncoding,...params?{params:params}:{}}},normParams)}getFacetMappingAndLayout(facets,params){const{row:row,column:column,facet:facet}=facets;if(row||column){if(facet){warn(message_namespaceObject.facetChannelDropped([...row?[ROW]:[],...column?[COLUMN]:[]]))}const facetMapping={};const layout={};for(const channel of[ROW,COLUMN]){const def=facets[channel];if(def){const{align:align,center:center,spacing:spacing,columns:columns,...defWithoutLayout}=def;facetMapping[channel]=defWithoutLayout;for(const prop of["align","center","spacing"]){if(def[prop]!==undefined){var _layout$prop;(_layout$prop=layout[prop])!==null&&_layout$prop!==void 0?_layout$prop:layout[prop]={};layout[prop][channel]=def[prop]}}}}return{facetMapping:facetMapping,layout:layout}}else{const{align:align,center:center,spacing:spacing,columns:columns,...facetMapping}=facet;return{facetMapping:replaceRepeaterInFacet(facetMapping,params.repeater),layout:{...align?{align:align}:{},...center?{center:center}:{},...spacing?{spacing:spacing}:{},...columns?{columns:columns}:{}}}}}mapLayer(spec,_ref){let{parentEncoding:parentEncoding,parentProjection:parentProjection,...otherParams}=_ref;const{encoding:encoding,projection:projection,...rest}=spec;const params={...otherParams,parentEncoding:mergeEncoding({parentEncoding:parentEncoding,encoding:encoding,layer:true}),parentProjection:mergeProjection({parentProjection:parentProjection,projection:projection})};return super.mapLayer({...rest,...spec.name?{name:[params.repeaterPrefix,spec.name].filter(n=>n).join("_")}:{}},params)}}function mergeEncoding(_ref2){let{parentEncoding:parentEncoding,encoding:encoding={},layer:layer}=_ref2;let merged={};if(parentEncoding){const channels=new Set([...keys(parentEncoding),...keys(encoding)]);for(const channel of channels){const channelDef=encoding[channel];const parentChannelDef=parentEncoding[channel];if(isFieldOrDatumDef(channelDef)){const mergedChannelDef={...parentChannelDef,...channelDef};merged[channel]=mergedChannelDef}else if(hasConditionalFieldOrDatumDef(channelDef)){merged[channel]={...channelDef,condition:{...parentChannelDef,...channelDef.condition}}}else if(channelDef||channelDef===null){merged[channel]=channelDef}else if(layer||isValueDef(parentChannelDef)||isSignalRef(parentChannelDef)||isFieldOrDatumDef(parentChannelDef)||Object(vega_util["isArray"])(parentChannelDef)){merged[channel]=parentChannelDef}}}else{merged=encoding}return!merged||isEmpty(merged)?undefined:merged}function mergeProjection(opt){const{parentProjection:parentProjection,projection:projection}=opt;if(parentProjection&&projection){warn(message_namespaceObject.projectionOverridden({parentProjection:parentProjection,projection:projection}))}return projection!==null&&projection!==void 0?projection:parentProjection}function isFilter(t){return hasProperty(t,"filter")}function isImputeSequence(t){return hasProperty(t,"stop")}function isLookup(t){return hasProperty(t,"lookup")}function isLookupData(from){return hasProperty(from,"data")}function isLookupSelection(from){return hasProperty(from,"param")}function isPivot(t){return hasProperty(t,"pivot")}function isDensity(t){return hasProperty(t,"density")}function isQuantile(t){return hasProperty(t,"quantile")}function isRegression(t){return hasProperty(t,"regression")}function isLoess(t){return hasProperty(t,"loess")}function isSample(t){return hasProperty(t,"sample")}function isWindow(t){return hasProperty(t,"window")}function isJoinAggregate(t){return hasProperty(t,"joinaggregate")}function isFlatten(t){return hasProperty(t,"flatten")}function isCalculate(t){return hasProperty(t,"calculate")}function isBin(t){return hasProperty(t,"bin")}function isImpute(t){return hasProperty(t,"impute")}function isTimeUnit(t){return hasProperty(t,"timeUnit")}function transform_isAggregate(t){return hasProperty(t,"aggregate")}function isStack(t){return hasProperty(t,"stack")}function isFold(t){return hasProperty(t,"fold")}function isExtent(t){return hasProperty(t,"extent")&&!hasProperty(t,"density")&&!hasProperty(t,"regression")}function normalizeTransform(transform){return transform.map(t=>{if(isFilter(t)){return{filter:normalizeLogicalComposition(t.filter,normalizePredicate)}}return t})}class selectioncompat_SelectionCompatibilityNormalizer extends map_SpecMapper{map(spec,normParams){var _normParams$emptySele,_normParams$selection;(_normParams$emptySele=normParams.emptySelections)!==null&&_normParams$emptySele!==void 0?_normParams$emptySele:normParams.emptySelections={};(_normParams$selection=normParams.selectionPredicates)!==null&&_normParams$selection!==void 0?_normParams$selection:normParams.selectionPredicates={};spec=normalizeTransforms(spec,normParams);return super.map(spec,normParams)}mapLayerOrUnit(spec,normParams){spec=normalizeTransforms(spec,normParams);if(spec.encoding){const encoding={};for(const[channel,enc]of entries(spec.encoding)){encoding[channel]=normalizeChannelDef(enc,normParams)}spec={...spec,encoding:encoding}}return super.mapLayerOrUnit(spec,normParams)}mapUnit(spec,normParams){const{selection:selection,...rest}=spec;if(selection){return{...rest,params:entries(selection).map(_ref=>{let[name,selDef]=_ref;const{init:value,bind:bind,empty:empty,...select}=selDef;if(select.type==="single"){select.type="point";select.toggle=false}else if(select.type==="multi"){select.type="point"}normParams.emptySelections[name]=empty!=="none";for(const pred of util_vals((_name=normParams.selectionPredicates[name])!==null&&_name!==void 0?_name:{})){var _name;pred.empty=empty!=="none"}return{name:name,value:value,select:select,bind:bind}})}}return spec}}function normalizeTransforms(spec,normParams){const{transform:tx,...rest}=spec;if(tx){const transform=tx.map(t=>{if(isFilter(t)){return{filter:selectioncompat_normalizePredicate(t,normParams)}}else if(isBin(t)&&isBinParams(t.bin)){return{...t,bin:normalizeBinExtent(t.bin)}}else if(isLookup(t)){const{selection:param,...from}=t.from;return param?{...t,from:{param:param,...from}}:t}return t});return{...rest,transform:transform}}return spec}function normalizeChannelDef(obj,normParams){var _enc$scale;const enc=duplicate(obj);if(isFieldDef(enc)&&isBinParams(enc.bin)){enc.bin=normalizeBinExtent(enc.bin)}if(isScaleFieldDef(enc)&&(_enc$scale=enc.scale)!==null&&_enc$scale!==void 0&&(_enc$scale=_enc$scale.domain)!==null&&_enc$scale!==void 0&&_enc$scale.selection){const{selection:param,...domain}=enc.scale.domain;enc.scale.domain={...domain,...param?{param:param}:{}}}if(isConditionalDef(enc)){if(Object(vega_util["isArray"])(enc.condition)){enc.condition=enc.condition.map(c=>{const{selection:selection,param:param,test:test,...cond}=c;return param?c:{...cond,test:selectioncompat_normalizePredicate(c,normParams)}})}else{const{selection:selection,param:param,test:test,...cond}=normalizeChannelDef(enc.condition,normParams);enc.condition=param?enc.condition:{...cond,test:selectioncompat_normalizePredicate(enc.condition,normParams)}}}return enc}function normalizeBinExtent(bin){const ext=bin.extent;if(ext!==null&&ext!==void 0&&ext.selection){const{selection:param,...rest}=ext;return{...bin,extent:{...rest,param:param}}}return bin}function selectioncompat_normalizePredicate(op,normParams){const normalizeSelectionComposition=o=>normalizeLogicalComposition(o,param=>{var _normParams$emptySele2,_normParams$selection2,_normParams$selection3;const empty=(_normParams$emptySele2=normParams.emptySelections[param])!==null&&_normParams$emptySele2!==void 0?_normParams$emptySele2:true;const pred={param:param,empty:empty};(_normParams$selection3=(_normParams$selection2=normParams.selectionPredicates)[param])!==null&&_normParams$selection3!==void 0?_normParams$selection3:_normParams$selection2[param]=[];normParams.selectionPredicates[param].push(pred);return pred});return op.selection?normalizeSelectionComposition(op.selection):normalizeLogicalComposition(op.test||op.filter,o=>o.selection?normalizeSelectionComposition(o.selection):o)}class toplevelselection_TopLevelSelectionsNormalizer extends map_SpecMapper{map(spec,normParams){var _normParams$selection;const selections=(_normParams$selection=normParams.selections)!==null&&_normParams$selection!==void 0?_normParams$selection:[];if(spec.params&&!isUnitSpec(spec)){const params=[];for(const param of spec.params){if(isSelectionParameter(param)){selections.push(param)}else{params.push(param)}}spec.params=params}normParams.selections=selections;return super.map(spec,normParams)}mapUnit(spec,normParams){var _normParams$path;const selections=normParams.selections;if(!selections||!selections.length)return spec;const path=((_normParams$path=normParams.path)!==null&&_normParams$path!==void 0?_normParams$path:[]).concat(spec.name);const params=[];for(const selection of selections){if(!selection.views||!selection.views.length){params.push(selection)}else{for(const view of selection.views){if(Object(vega_util["isString"])(view)&&(view===spec.name||path.includes(view))||Object(vega_util["isArray"])(view)&&view.map(v=>path.indexOf(v)).every((v,i,arr)=>v!==-1&&(i===0||v>arr[i-1]))){params.push(selection)}}}}if(params.length)spec.params=params;return spec}}for(const method of["mapFacet","mapRepeat","mapHConcat","mapVConcat","mapLayer"]){const proto=toplevelselection_TopLevelSelectionsNormalizer.prototype[method];toplevelselection_TopLevelSelectionsNormalizer.prototype[method]=function(spec,params){return proto.call(this,spec,addSpecNameToParams(spec,params))}}function addSpecNameToParams(spec,params){var _params$path;return spec.name?{...params,path:((_params$path=params.path)!==null&&_params$path!==void 0?_params$path:[]).concat(spec.name)}:params}function normalize_normalize(spec,config){if(config===undefined){config=initConfig(spec.config)}const normalizedSpec=normalizeGenericSpec(spec,config);const{width:width,height:height}=spec;const autosize=normalizeAutoSize(normalizedSpec,{width:width,height:height,autosize:spec.autosize},config);return{...normalizedSpec,...autosize?{autosize:autosize}:{}}}const coreNormalizer=new core_CoreNormalizer;const selectionCompatNormalizer=new selectioncompat_SelectionCompatibilityNormalizer;const topLevelSelectionNormalizer=new toplevelselection_TopLevelSelectionsNormalizer;function normalizeGenericSpec(spec){let config=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const normParams={config:config};return topLevelSelectionNormalizer.map(coreNormalizer.map(selectionCompatNormalizer.map(spec,normParams),normParams),normParams)}function _normalizeAutoSize(autosize){return Object(vega_util["isString"])(autosize)?{type:autosize}:autosize!==null&&autosize!==void 0?autosize:{}}function normalizeAutoSize(spec,sizeInfo,config){let{width:width,height:height}=sizeInfo;const isFitCompatible=isUnitSpec(spec)||isLayerSpec(spec);const autosizeDefault={};if(!isFitCompatible){if(width=="container"){warn(message_namespaceObject.containerSizeNonSingle("width"));width=undefined}if(height=="container"){warn(message_namespaceObject.containerSizeNonSingle("height"));height=undefined}}else{if(width=="container"&&height=="container"){autosizeDefault.type="fit";autosizeDefault.contains="padding"}else if(width=="container"){autosizeDefault.type="fit-x";autosizeDefault.contains="padding"}else if(height=="container"){autosizeDefault.type="fit-y";autosizeDefault.contains="padding"}}const autosize={type:"pad",...autosizeDefault,...config?_normalizeAutoSize(config.autosize):{},..._normalizeAutoSize(spec.autosize)};if(autosize.type==="fit"&&!isFitCompatible){warn(message_namespaceObject.FIT_NON_SINGLE);autosize.type="pad"}if(width=="container"&&!(autosize.type=="fit"||autosize.type=="fit-x")){warn(message_namespaceObject.containerSizeNotCompatibleWithAutosize("width"))}if(height=="container"&&!(autosize.type=="fit"||autosize.type=="fit-y")){warn(message_namespaceObject.containerSizeNotCompatibleWithAutosize("height"))}if(deepEqual(autosize,{type:"pad"})){return undefined}return autosize}function isFitType(autoSizeType){return["fit","fit-x","fit-y"].includes(autoSizeType)}function getFitType(sizeType){return sizeType?`fit-${getPositionScaleChannel(sizeType)}`:"fit"}const TOP_LEVEL_PROPERTIES=["background","padding"];function extractTopLevelProperties(t,includeParams){const o={};for(const p of TOP_LEVEL_PROPERTIES){if(t&&t[p]!==undefined){o[p]=signalRefOrValue(t[p])}}if(includeParams){o.params=t.params}return o}class split_Split{constructor(){let explicit=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let implicit=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};this.explicit=explicit;this.implicit=implicit}clone(){return new split_Split(duplicate(this.explicit),duplicate(this.implicit))}combine(){return{...this.explicit,...this.implicit}}get(key){return getFirstDefined(this.explicit[key],this.implicit[key])}getWithExplicit(key){if(this.explicit[key]!==undefined){return{explicit:true,value:this.explicit[key]}}else if(this.implicit[key]!==undefined){return{explicit:false,value:this.implicit[key]}}return{explicit:false,value:undefined}}setWithExplicit(key,_ref){let{value:value,explicit:explicit}=_ref;if(value!==undefined){this.set(key,value,explicit)}}set(key,value,explicit){delete this[explicit?"implicit":"explicit"][key];this[explicit?"explicit":"implicit"][key]=value;return this}copyKeyFromSplit(key,_ref2){let{explicit:explicit,implicit:implicit}=_ref2;if(explicit[key]!==undefined){this.set(key,explicit[key],true)}else if(implicit[key]!==undefined){this.set(key,implicit[key],false)}}copyKeyFromObject(key,s){if(s[key]!==undefined){this.set(key,s[key],true)}}copyAll(other){for(const key of keys(other.combine())){const val=other.getWithExplicit(key);this.setWithExplicit(key,val)}}}function makeExplicit(value){return{explicit:true,value:value}}function makeImplicit(value){return{explicit:false,value:value}}function tieBreakByComparing(compare){return(v1,v2,property,propertyOf)=>{const diff=compare(v1.value,v2.value);if(diff>0){return v1}else if(diff<0){return v2}return defaultTieBreaker(v1,v2,property,propertyOf)}}function defaultTieBreaker(v1,v2,property,propertyOf){if(v1.explicit&&v2.explicit){warn(message_namespaceObject.mergeConflictingProperty(property,propertyOf,v1.value,v2.value))}return v1}function mergeValuesWithExplicit(v1,v2,property,propertyOf){let tieBreaker=arguments.length>4&&arguments[4]!==undefined?arguments[4]:defaultTieBreaker;if(v1===undefined||v1.value===undefined){return v2}if(v1.explicit&&!v2.explicit){return v1}else if(v2.explicit&&!v1.explicit){return v2}else if(deepEqual(v1.value,v2.value)){return v1}else{return tieBreaker(v1,v2,property,propertyOf)}}class data_AncestorParse extends split_Split{constructor(){let explicit=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let implicit=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let parseNothing=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;super(explicit,implicit);this.explicit=explicit;this.implicit=implicit;this.parseNothing=parseNothing}clone(){const clone=super.clone();clone.parseNothing=this.parseNothing;return clone}}function isUrlData(data){return hasProperty(data,"url")}function isInlineData(data){return hasProperty(data,"values")}function isNamedData(data){return hasProperty(data,"name")&&!isUrlData(data)&&!isInlineData(data)&&!isGenerator(data)}function isGenerator(data){return data&&(isSequenceGenerator(data)||isSphereGenerator(data)||isGraticuleGenerator(data))}function isSequenceGenerator(data){return hasProperty(data,"sequence")}function isSphereGenerator(data){return hasProperty(data,"sphere")}function isGraticuleGenerator(data){return hasProperty(data,"graticule")}let DataSourceType=function(DataSourceType){DataSourceType[DataSourceType["Raw"]=0]="Raw";DataSourceType[DataSourceType["Main"]=1]="Main";DataSourceType[DataSourceType["Row"]=2]="Row";DataSourceType[DataSourceType["Column"]=3]="Column";DataSourceType[DataSourceType["Lookup"]=4]="Lookup";DataSourceType[DataSourceType["PreFilterInvalid"]=5]="PreFilterInvalid";DataSourceType[DataSourceType["PostFilterInvalid"]=6]="PostFilterInvalid";return DataSourceType}({});function getDataSourcesForHandlingInvalidValues(_ref){let{invalid:invalid,isPath:isPath}=_ref;const normalizedInvalid=normalizeInvalidDataMode(invalid,{isPath:isPath});switch(normalizedInvalid){case"filter":return{marks:"exclude-invalid-values",scales:"exclude-invalid-values"};case"break-paths-show-domains":return{marks:isPath?"include-invalid-values":"exclude-invalid-values",scales:"include-invalid-values"};case"break-paths-filter-domains":return{marks:isPath?"include-invalid-values":"exclude-invalid-values",scales:"exclude-invalid-values"};case"show":return{marks:"include-invalid-values",scales:"include-invalid-values"}}}function getScaleDataSourceForHandlingInvalidValues(props){const{marks:marks,scales:scales}=getDataSourcesForHandlingInvalidValues(props);if(marks===scales){return DataSourceType.Main}return scales==="include-invalid-values"?DataSourceType.PreFilterInvalid:DataSourceType.PostFilterInvalid}var vega_event_selector=__webpack_require__(66);function dataflow_defineProperty(e,r,t){return(r=dataflow_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function dataflow_toPropertyKey(t){var i=dataflow_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function dataflow_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class dataflow_DataFlowNode{constructor(parent,debugName){this.debugName=debugName;dataflow_defineProperty(this,"_children",[]);dataflow_defineProperty(this,"_parent",null);dataflow_defineProperty(this,"_hash",void 0);if(parent){this.parent=parent}}clone(){throw new Error("Cannot clone node")}get parent(){return this._parent}set parent(parent){this._parent=parent;if(parent){parent.addChild(this)}}get children(){return this._children}numChildren(){return this._children.length}addChild(child,loc){if(this._children.includes(child)){warn(message_namespaceObject.ADD_SAME_CHILD_TWICE);return}if(loc!==undefined){this._children.splice(loc,0,child)}else{this._children.push(child)}}removeChild(oldChild){const loc=this._children.indexOf(oldChild);this._children.splice(loc,1);return loc}remove(){let loc=this._parent.removeChild(this);for(const child of this._children){child._parent=this._parent;this._parent.addChild(child,loc++)}}insertAsParentOf(other){const parent=other.parent;parent.removeChild(this);this.parent=parent;other.parent=this}swapWithParent(){const parent=this._parent;const newParent=parent.parent;for(const child of this._children){child.parent=parent}this._children=[];parent.removeChild(this);const loc=parent.parent.removeChild(parent);this._parent=newParent;newParent.addChild(this,loc);parent.parent=this}}class dataflow_OutputNode extends dataflow_DataFlowNode{clone(){const cloneObj=new this.constructor;cloneObj.debugName=`clone_${this.debugName}`;cloneObj._source=this._source;cloneObj._name=`clone_${this._name}`;cloneObj.type=this.type;cloneObj.refCounts=this.refCounts;cloneObj.refCounts[cloneObj._name]=0;return cloneObj}constructor(parent,source,type,refCounts){super(parent,source);this.type=type;this.refCounts=refCounts;dataflow_defineProperty(this,"_source",void 0);dataflow_defineProperty(this,"_name",void 0);this._source=this._name=source;if(this.refCounts&&!(this._name in this.refCounts)){this.refCounts[this._name]=0}}dependentFields(){return new Set}producedFields(){return new Set}hash(){if(this._hash===undefined){this._hash=`Output ${uniqueId()}`}return this._hash}getSource(){this.refCounts[this._name]++;return this._source}isRequired(){return!!this.refCounts[this._name]}setSource(source){this._source=source}}function isTimeUnitTransformComponent(timeUnitComponent){return timeUnitComponent.as!==undefined}function offsetAs(field){return`${field}_end`}class timeunit_TimeUnitNode extends dataflow_DataFlowNode{clone(){return new timeunit_TimeUnitNode(null,duplicate(this.timeUnits))}constructor(parent,timeUnits){super(parent);this.timeUnits=timeUnits}static makeFromEncoding(parent,model){const formula=model.reduceFieldDef((timeUnitComponent,fieldDef,channel)=>{const{field:field,timeUnit:timeUnit}=fieldDef;if(timeUnit){let component;if(isBinnedTimeUnit(timeUnit)){if(isUnitModel(model)){const{mark:mark,markDef:markDef,config:config}=model;const bandPosition=getBandPosition({fieldDef:fieldDef,markDef:markDef,config:config});if(isRectBasedMark(mark)||!!bandPosition){component={timeUnit:normalizeTimeUnit(timeUnit),field:field}}}}else{component={as:vgField(fieldDef,{forAs:true}),field:field,timeUnit:timeUnit}}if(isUnitModel(model)){const{mark:mark,markDef:markDef,config:config}=model;const bandPosition=getBandPosition({fieldDef:fieldDef,markDef:markDef,config:config});if(isRectBasedMark(mark)&&isXorY(channel)&&bandPosition!==.5){component.rectBandPosition=bandPosition}}if(component){timeUnitComponent[hash(component)]=component}}return timeUnitComponent},{});if(isEmpty(formula)){return null}return new timeunit_TimeUnitNode(parent,formula)}static makeFromTransform(parent,t){const{timeUnit:timeUnit,...other}={...t};const normalizedTimeUnit=normalizeTimeUnit(timeUnit);const component={...other,timeUnit:normalizedTimeUnit};return new timeunit_TimeUnitNode(parent,{[hash(component)]:component})}merge(other){this.timeUnits={...this.timeUnits};for(const key in other.timeUnits){if(!this.timeUnits[key]){this.timeUnits[key]=other.timeUnits[key]}}for(const child of other.children){other.removeChild(child);child.parent=this}other.remove()}removeFormulas(fields){const newFormula={};for(const[key,timeUnitComponent]of entries(this.timeUnits)){const fieldAs=isTimeUnitTransformComponent(timeUnitComponent)?timeUnitComponent.as:`${timeUnitComponent.field}_end`;if(!fields.has(fieldAs)){newFormula[key]=timeUnitComponent}}this.timeUnits=newFormula}producedFields(){return new Set(util_vals(this.timeUnits).map(f=>isTimeUnitTransformComponent(f)?f.as:offsetAs(f.field)))}dependentFields(){return new Set(util_vals(this.timeUnits).map(f=>f.field))}hash(){return`TimeUnit ${hash(this.timeUnits)}`}assemble(){const transforms=[];for(const f of util_vals(this.timeUnits)){const{rectBandPosition:rectBandPosition}=f;const normalizedTimeUnit=normalizeTimeUnit(f.timeUnit);if(isTimeUnitTransformComponent(f)){const{field:field,as:as}=f;const{unit:unit,utc:utc,...params}=normalizedTimeUnit;const startEnd=[as,`${as}_end`];transforms.push({field:replacePathInField(field),type:"timeunit",...unit?{units:getTimeUnitParts(unit)}:{},...utc?{timezone:"utc"}:{},...params,as:startEnd});transforms.push(...offsetedRectFormulas(startEnd,rectBandPosition,normalizedTimeUnit))}else if(f){const{field:escapedField}=f;const field=escapedField.replaceAll("\\.",".");const expr=timeunit_offsetExpr({timeUnit:normalizedTimeUnit,field:field});const endAs=offsetAs(field);transforms.push({type:"formula",expr:expr,as:endAs});transforms.push(...offsetedRectFormulas([field,endAs],rectBandPosition,normalizedTimeUnit))}}return transforms}}const OFFSETTED_RECT_START_SUFFIX="offsetted_rect_start";const OFFSETTED_RECT_END_SUFFIX="offsetted_rect_end";function timeunit_offsetExpr(_ref){let{timeUnit:timeUnit,field:field,reverse:reverse}=_ref;const{unit:unit,utc:utc}=timeUnit;const smallestUnit=getSmallestTimeUnitPart(unit);const{part:part,step:step}=getDateTimePartAndStep(smallestUnit,timeUnit.step);const offsetFn=utc?"utcOffset":"timeOffset";const expr=`${offsetFn}('${part}', ${accessWithDatumToUnescapedPath(field)}, ${reverse?-step:step})`;return expr}function offsetedRectFormulas(_ref2,rectBandPosition,timeUnit){let[startField,endField]=_ref2;if(rectBandPosition!==undefined&&rectBandPosition!==.5){const startExpr=accessWithDatumToUnescapedPath(startField);const endExpr=accessWithDatumToUnescapedPath(endField);return[{type:"formula",expr:interpolateExpr([timeunit_offsetExpr({timeUnit:timeUnit,field:startField,reverse:true}),startExpr],rectBandPosition+.5),as:`${startField}_${OFFSETTED_RECT_START_SUFFIX}`},{type:"formula",expr:interpolateExpr([startExpr,endExpr],rectBandPosition+.5),as:`${startField}_${OFFSETTED_RECT_END_SUFFIX}`}]}return[]}function interpolateExpr(_ref3,fraction){let[start,end]=_ref3;return`${1-fraction} * ${start} + ${fraction} * ${end}`}function project_defineProperty(e,r,t){return(r=project_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function project_toPropertyKey(t){var i=project_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function project_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}const TUPLE_FIELDS="_tuple_fields";class SelectionProjectionComponent{constructor(){project_defineProperty(this,"hasChannel",void 0);project_defineProperty(this,"hasField",void 0);project_defineProperty(this,"hasSelectionId",void 0);project_defineProperty(this,"timeUnit",void 0);project_defineProperty(this,"items",void 0);for(var _len=arguments.length,items=new Array(_len),_key=0;_key<_len;_key++){items[_key]=arguments[_key]}this.items=items;this.hasChannel={};this.hasField={};this.hasSelectionId=false}}const project_project={defined:()=>true,parse:(model,selCmpt,selDef)=>{var _selCmpt$project;const name=selCmpt.name;const proj=(_selCmpt$project=selCmpt.project)!==null&&_selCmpt$project!==void 0?_selCmpt$project:selCmpt.project=new SelectionProjectionComponent;const parsed={};const timeUnits={};const signals=new Set;const signalName=(p,range)=>{const suffix=range==="visual"?p.channel:p.field;let sg=varName(`${name}_${suffix}`);for(let counter=1;signals.has(sg);counter++){sg=varName(`${name}_${suffix}_${counter}`)}signals.add(sg);return{[range]:sg}};const type=selCmpt.type;const cfg=model.config.selection[type];const init=selDef.value!==undefined?Object(vega_util["array"])(selDef.value):null;let{fields:fields,encodings:encodings}=Object(vega_util["isObject"])(selDef.select)?selDef.select:{};if(!fields&&!encodings&&init){for(const initVal of init){if(!Object(vega_util["isObject"])(initVal)){continue}for(const key of keys(initVal)){if(isSingleDefUnitChannel(key)){(encodings||(encodings=[])).push(key)}else{if(type==="interval"){warn(message_namespaceObject.INTERVAL_INITIALIZED_WITH_POS);encodings=cfg.encodings}else{var _fields;((_fields=fields)!==null&&_fields!==void 0?_fields:fields=[]).push(key)}}}}}if(!fields&&!encodings){encodings=cfg.encodings;if("fields"in cfg){fields=cfg.fields}}for(const channel of(_encodings=encodings)!==null&&_encodings!==void 0?_encodings:[]){var _encodings;const fieldDef=model.fieldDef(channel);if(fieldDef){let field=fieldDef.field;if(fieldDef.aggregate){warn(message_namespaceObject.cannotProjectAggregate(channel,fieldDef.aggregate));continue}else if(!field){warn(message_namespaceObject.cannotProjectOnChannelWithoutField(channel));continue}if(fieldDef.timeUnit&&!isBinnedTimeUnit(fieldDef.timeUnit)){field=model.vgField(channel);const component={timeUnit:fieldDef.timeUnit,as:field,field:fieldDef.field};timeUnits[hash(component)]=component}if(!parsed[field]){const tplType=type==="interval"&&isScaleChannel(channel)&&hasContinuousDomain(model.getScaleComponent(channel).get("type"))?"R":fieldDef.bin?"R-RE":"E";const p={field:field,channel:channel,type:tplType,index:proj.items.length};p.signals={...signalName(p,"data"),...signalName(p,"visual")};proj.items.push(parsed[field]=p);proj.hasField[field]=parsed[field];proj.hasSelectionId=proj.hasSelectionId||field===SELECTION_ID;if(isGeoPositionChannel(channel)){p.geoChannel=channel;p.channel=getPositionChannelFromLatLong(channel);proj.hasChannel[p.channel]=parsed[field]}else{proj.hasChannel[channel]=parsed[field]}}}else{warn(message_namespaceObject.cannotProjectOnChannelWithoutField(channel))}}for(const field of(_fields2=fields)!==null&&_fields2!==void 0?_fields2:[]){var _fields2;if(proj.hasField[field])continue;const p={type:"E",field:field,index:proj.items.length};p.signals={...signalName(p,"data")};proj.items.push(p);proj.hasField[field]=p;proj.hasSelectionId=proj.hasSelectionId||field===SELECTION_ID}if(init){selCmpt.init=init.map(v=>proj.items.map(p=>Object(vega_util["isObject"])(v)?v[p.geoChannel||p.channel]!==undefined?v[p.geoChannel||p.channel]:v[p.field]:v))}if(!isEmpty(timeUnits)){proj.timeUnit=new timeunit_TimeUnitNode(null,timeUnits)}},signals:(model,selCmpt,allSignals)=>{const name=selCmpt.name+TUPLE_FIELDS;const hasSignal=allSignals.filter(s=>s.name===name);return hasSignal.length>0||selCmpt.project.hasSelectionId?allSignals:allSignals.concat({name:name,value:selCmpt.project.items.map(assembleProjection)})}};var selection_project=project_project;const CURR="_curr";const ANIM_VALUE="anim_value";const ANIM_CLOCK="anim_clock";const EASED_ANIM_CLOCK="eased_anim_clock";const MIN_EXTENT="min_extent";const MAX_RANGE_EXTENT="max_range_extent";const LAST_TICK="last_tick_at";const IS_PLAYING="is_playing";const THROTTLE=1/60*1e3;const animationSignals=(selectionName,scaleName)=>[{name:EASED_ANIM_CLOCK,update:ANIM_CLOCK},{name:`${selectionName}_domain`,init:`domain('${scaleName}')`},{name:MIN_EXTENT,init:`extent(${selectionName}_domain)[0]`},{name:MAX_RANGE_EXTENT,init:`extent(range('${scaleName}'))[1]`},{name:ANIM_VALUE,update:`invert('${scaleName}', ${EASED_ANIM_CLOCK})`}];const point={defined:selCmpt=>selCmpt.type==="point",topLevelSignals:(model,selCmpt,signals)=>{if(isTimerSelection(selCmpt)){signals=signals.concat([{name:ANIM_CLOCK,init:"0",on:[{events:{type:"timer",throttle:THROTTLE},update:`${IS_PLAYING} ? (${ANIM_CLOCK} + (now() - ${LAST_TICK}) > ${MAX_RANGE_EXTENT} ? 0 : ${ANIM_CLOCK} + (now() - ${LAST_TICK})) : ${ANIM_CLOCK}`}]},{name:LAST_TICK,init:"now()",on:[{events:[{signal:ANIM_CLOCK},{signal:IS_PLAYING}],update:"now()"}]},{name:IS_PLAYING,init:"true"}])}return signals},signals:(model,selCmpt,signals)=>{var _model$component$sele;const name=selCmpt.name;const fieldsSg=name+TUPLE_FIELDS;const project=selCmpt.project;const datum="(item().isVoronoi ? datum.datum : datum)";const brushes=util_vals((_model$component$sele=model.component.selection)!==null&&_model$component$sele!==void 0?_model$component$sele:{}).reduce((acc,cmpt)=>cmpt.type==="interval"?acc.concat(cmpt.name+BRUSH):acc,[]).map(b=>`indexof(item().mark.name, '${b}') < 0`).join(" && ");const test=`datum && item().mark.marktype !== 'group' && indexof(item().mark.role, 'legend') < 0${brushes?` && ${brushes}`:""}`;let update=`unit: ${selection_unitName(model)}, `;if(selCmpt.project.hasSelectionId){update+=`${SELECTION_ID}: ${datum}[${Object(vega_util["stringValue"])(SELECTION_ID)}]`}else if(isTimerSelection(selCmpt)){update+=`fields: ${fieldsSg}, values: [${ANIM_VALUE} ? ${ANIM_VALUE} : ${MIN_EXTENT}]`}else{const values=project.items.map(p=>{const fieldDef=model.fieldDef(p.channel);return fieldDef!==null&&fieldDef!==void 0&&fieldDef.bin?`[${datum}[${Object(vega_util["stringValue"])(model.vgField(p.channel,{}))}], `+`${datum}[${Object(vega_util["stringValue"])(model.vgField(p.channel,{binSuffix:"end"}))}]]`:`${datum}[${Object(vega_util["stringValue"])(p.field)}]`}).join(", ");update+=`fields: ${fieldsSg}, values: [${values}]`}if(isTimerSelection(selCmpt)){return signals.concat(animationSignals(selCmpt.name,model.scaleName(TIME)),[{name:name+TUPLE,on:[{events:[{signal:EASED_ANIM_CLOCK},{signal:ANIM_VALUE}],update:`{${update}}`,force:true}]}])}else{const events=selCmpt.events;return signals.concat([{name:name+TUPLE,on:events?[{events:events,update:`${test} ? {${update}} : null`,force:true}]:[]}])}}};var selection_point=point;function assembleProjection(proj){const{signals:signals,hasLegend:hasLegend,index:index,...rest}=proj;rest.field=replacePathInField(rest.field);return rest}function assembleInit(init){let isExpr=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;let wrap=arguments.length>2&&arguments[2]!==undefined?arguments[2]:vega_util["identity"];if(Object(vega_util["isArray"])(init)){const assembled=init.map(v=>assembleInit(v,isExpr,wrap));return isExpr?`[${assembled.join(", ")}]`:assembled}else if(isDateTime(init)){if(isExpr){return wrap(dateTimeToExpr(init))}else{return wrap(dateTimeToTimestamp(init))}}return isExpr?wrap(stringify(init)):init}function assembleUnitSelectionSignals(model,signals){for(const selCmpt of util_vals((_model$component$sele=model.component.selection)!==null&&_model$component$sele!==void 0?_model$component$sele:{})){var _model$component$sele;const name=selCmpt.name;let modifyExpr=`${name}${TUPLE}, ${selCmpt.resolve==="global"?"true":`{unit: ${selection_unitName(model)}}`}`;for(const c of selectionCompilers){if(!c.defined(selCmpt))continue;if(c.signals)signals=c.signals(model,selCmpt,signals);if(c.modifyExpr)modifyExpr=c.modifyExpr(model,selCmpt,modifyExpr)}signals.push({name:name+MODIFY,on:[{events:{signal:selCmpt.name+TUPLE},update:`modify(${Object(vega_util["stringValue"])(selCmpt.name+STORE)}, ${modifyExpr})`}]})}return cleanupEmptyOnArray(signals)}function assembleFacetSignals(model,signals){if(model.component.selection&&keys(model.component.selection).length){const name=Object(vega_util["stringValue"])(model.getName("cell"));signals.unshift({name:"facet",value:{},on:[{events:Object(vega_event_selector["parseSelector"])("pointermove","scope"),update:`isTuple(facet) ? facet : group(${name}).datum`}]})}return cleanupEmptyOnArray(signals)}function assembleTopLevelSignals(model,signals){let hasSelections=false;for(const selCmpt of util_vals((_model$component$sele2=model.component.selection)!==null&&_model$component$sele2!==void 0?_model$component$sele2:{})){var _model$component$sele2;const name=selCmpt.name;const store=Object(vega_util["stringValue"])(name+STORE);const hasSg=signals.filter(s=>s.name===name);if(hasSg.length===0){const resolve=selCmpt.resolve==="global"?"union":selCmpt.resolve;const isPoint=selCmpt.type==="point"?", true, true)":")";signals.push({name:selCmpt.name,update:`${VL_SELECTION_RESOLVE}(${store}, ${Object(vega_util["stringValue"])(resolve)}${isPoint}`})}hasSelections=true;for(const c of selectionCompilers){if(c.defined(selCmpt)&&c.topLevelSignals){signals=c.topLevelSignals(model,selCmpt,signals)}}}if(hasSelections){const hasUnit=signals.filter(s=>s.name==="unit");if(hasUnit.length===0){signals.unshift({name:"unit",value:{},on:[{events:"pointermove",update:"isTuple(group()) ? group() : unit"}]})}}return cleanupEmptyOnArray(signals)}function assembleUnitSelectionData(model,data){const selectionData=[];const animationData=[];const unit=selection_unitName(model,{escape:false});for(const selCmpt of util_vals((_model$component$sele3=model.component.selection)!==null&&_model$component$sele3!==void 0?_model$component$sele3:{})){var _model$component$sele3;const store={name:selCmpt.name+STORE};if(selCmpt.project.hasSelectionId){store.transform=[{type:"collect",sort:{field:SELECTION_ID}}]}if(selCmpt.init){const fields=selCmpt.project.items.map(assembleProjection);store.values=selCmpt.project.hasSelectionId?selCmpt.init.map(i=>({unit:unit,[SELECTION_ID]:assembleInit(i,false)[0]})):selCmpt.init.map(i=>({unit:unit,fields:fields,values:assembleInit(i,false)}))}const contains=[...selectionData,...data].filter(d=>d.name===selCmpt.name+STORE);if(!contains.length){selectionData.push(store)}if(isTimerSelection(selCmpt)&&data.length){const sourceName=model.lookupDataSource(model.getDataName(DataSourceType.Main));const sourceData=data.find(d=>d.name===sourceName);const sourceDataFilter=sourceData.transform.find(t=>t.type==="filter"&&t.expr.includes("vlSelectionTest"));if(sourceDataFilter){sourceData.transform=sourceData.transform.filter(t=>t!==sourceDataFilter);const currentFrame={name:sourceData.name+CURR,source:sourceData.name,transform:[sourceDataFilter]};animationData.push(currentFrame)}}}return selectionData.concat(data,animationData)}function assembleUnitSelectionMarks(model,marks){for(const selCmpt of util_vals((_model$component$sele4=model.component.selection)!==null&&_model$component$sele4!==void 0?_model$component$sele4:{})){var _model$component$sele4;for(const c of selectionCompilers){if(c.defined(selCmpt)&&c.marks){marks=c.marks(model,selCmpt,marks)}}}return marks}function assembleLayerSelectionMarks(model,marks){for(const child of model.children){if(isUnitModel(child)){marks=assembleUnitSelectionMarks(child,marks)}}return marks}function assembleSelectionScaleDomain(model,extent,scaleCmpt,domain){const parsedExtent=parseSelectionExtent(model,extent.param,extent);return{signal:hasContinuousDomain(scaleCmpt.get("type"))&&Object(vega_util["isArray"])(domain)&&domain[0]>domain[1]?`isValid(${parsedExtent}) && reverse(${parsedExtent})`:parsedExtent}}function cleanupEmptyOnArray(signals){return signals.map(s=>{if(s.on&&!s.on.length)delete s.on;return s})}const scaleBindings={defined:selCmpt=>selCmpt.type==="interval"&&selCmpt.resolve==="global"&&selCmpt.bind&&selCmpt.bind==="scales",parse:(model,selCmpt)=>{const bound=selCmpt.scales=[];for(const proj of selCmpt.project.items){const channel=proj.channel;if(!isScaleChannel(channel)){continue}const scale=model.getScaleComponent(channel);const scaleType=scale?scale.get("type"):undefined;if(scaleType=="sequential"){warn(message_namespaceObject.SEQUENTIAL_SCALE_DEPRECATED)}if(!scale||!hasContinuousDomain(scaleType)){warn(message_namespaceObject.SCALE_BINDINGS_CONTINUOUS);continue}scale.set("selectionExtent",{param:selCmpt.name,field:proj.field},true);bound.push(proj)}},topLevelSignals:(model,selCmpt,signals)=>{const bound=selCmpt.scales.filter(proj=>signals.filter(s=>s.name===proj.signals.data).length===0);if(!model.parent||isTopLevelLayer(model)||bound.length===0){return signals}const namedSg=signals.find(s=>s.name===selCmpt.name);let update=namedSg.update;if(update.includes(VL_SELECTION_RESOLVE)){namedSg.update=`{${bound.map(proj=>`${Object(vega_util["stringValue"])(replacePathInField(proj.field))}: ${proj.signals.data}`).join(", ")}}`}else{for(const proj of bound){const mapping=`${Object(vega_util["stringValue"])(replacePathInField(proj.field))}: ${proj.signals.data}`;if(!update.includes(mapping)){update=`${update.substring(0,update.length-1)}, ${mapping}}`}}namedSg.update=update}return signals.concat(bound.map(proj=>({name:proj.signals.data})))},signals:(model,selCmpt,signals)=>{if(model.parent&&!isTopLevelLayer(model)){for(const proj of selCmpt.scales){const signal=signals.find(s=>s.name===proj.signals.data);signal.push="outer";delete signal.value;delete signal.update}}return signals}};var selection_scales=scaleBindings;function scales_domain(model,channel){const scale=Object(vega_util["stringValue"])(model.scaleName(channel));return`domain(${scale})`}function isTopLevelLayer(model){return model.parent&&isLayerModel(model.parent)&&(!model.parent.parent||isTopLevelLayer(model.parent.parent))}const BRUSH="_brush";const SCALE_TRIGGER="_scale_trigger";const GEO_INIT_TICK="geo_interval_init_tick";const INIT="_init";const CENTER="_center";const interval={defined:selCmpt=>selCmpt.type==="interval",parse:(model,selCmpt,selDef)=>{if(model.hasProjection){const def={...Object(vega_node["isObject"])(selDef.select)?selDef.select:{}};def.fields=[SELECTION_ID];if(!def.encodings){def.encodings=selDef.value?keys(selDef.value):[LONGITUDE,LATITUDE]}selDef.select={type:"interval",...def}}if(selCmpt.translate&&!selection_scales.defined(selCmpt)){const filterExpr=`!event.item || event.item.mark.name !== ${Object(vega_util["stringValue"])(selCmpt.name+BRUSH)}`;for(const evt of selCmpt.events){var _evt$between$,_evt$between$$filter;if(!evt.between){warn(`${evt} is not an ordered event stream for interval selections.`);continue}const filters=Object(vega_util["array"])((_evt$between$$filter=(_evt$between$=evt.between[0]).filter)!==null&&_evt$between$$filter!==void 0?_evt$between$$filter:_evt$between$.filter=[]);if(!filters.includes(filterExpr)){filters.push(filterExpr)}}}},signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const tupleSg=name+TUPLE;const channels=util_vals(selCmpt.project.hasChannel).filter(p=>p.channel===X||p.channel===Y);const init=selCmpt.init?selCmpt.init[0]:null;signals.push(...channels.reduce((arr,proj)=>arr.concat(channelSignals(model,selCmpt,proj,init&&init[proj.index])),[]));if(!model.hasProjection){if(!selection_scales.defined(selCmpt)){const triggerSg=name+SCALE_TRIGGER;const scaleTriggers=channels.map(proj=>{const channel=proj.channel;const{data:dname,visual:vname}=proj.signals;const scaleName=Object(vega_util["stringValue"])(model.scaleName(channel));const scaleType=model.getScaleComponent(channel).get("type");const toNum=hasContinuousDomain(scaleType)?"+":"";return`(!isArray(${dname}) || `+`(${toNum}invert(${scaleName}, ${vname})[0] === ${toNum}${dname}[0] && `+`${toNum}invert(${scaleName}, ${vname})[1] === ${toNum}${dname}[1]))`});if(scaleTriggers.length){signals.push({name:triggerSg,value:{},on:[{events:channels.map(proj=>({scale:model.scaleName(proj.channel)})),update:scaleTriggers.join(" && ")+` ? ${triggerSg} : {}`}]})}}const dataSignals=channels.map(proj=>proj.signals.data);const update=`unit: ${selection_unitName(model)}, fields: ${name+TUPLE_FIELDS}, values`;return signals.concat({name:tupleSg,...init?{init:`{${update}: ${assembleInit(init)}}`}:{},...dataSignals.length?{on:[{events:[{signal:dataSignals.join(" || ")}],update:`${dataSignals.join(" && ")} ? {${update}: [${dataSignals}]} : null`}]}:{}})}else{const projection=Object(vega_util["stringValue"])(model.projectionName());const centerSg=model.projectionName()+CENTER;const{x:x,y:y}=selCmpt.project.hasChannel;const xvname=x&&x.signals.visual;const yvname=y&&y.signals.visual;const xinit=x?init&&init[x.index]:`${centerSg}[0]`;const yinit=y?init&&init[y.index]:`${centerSg}[1]`;const sizeSg=layout=>model.getSizeSignalRef(layout).signal;const bbox=`[`+`[${xvname?xvname+"[0]":"0"}, ${yvname?yvname+"[0]":"0"}],`+`[${xvname?xvname+"[1]":sizeSg("width")}, `+`${yvname?yvname+"[1]":sizeSg("height")}]`+`]`;if(init){signals.unshift({name:name+INIT,init:`[scale(${projection}, [${x?xinit[0]:xinit}, ${y?yinit[0]:yinit}]), `+`scale(${projection}, [${x?xinit[1]:xinit}, ${y?yinit[1]:yinit}])]`});if(!x||!y){const hasCenterSg=signals.find(s=>s.name===centerSg);if(!hasCenterSg){signals.unshift({name:centerSg,update:`invert(${projection}, [${sizeSg("width")}/2, ${sizeSg("height")}/2])`})}}}const intersect=`intersect(${bbox}, {markname: ${Object(vega_util["stringValue"])(model.getName("marks"))}}, unit.mark)`;const base=`{unit: ${selection_unitName(model)}}`;const update=`vlSelectionTuples(${intersect}, ${base})`;const visualSignals=channels.map(proj=>proj.signals.visual);return signals.concat({name:tupleSg,on:[{events:[...visualSignals.length?[{signal:visualSignals.join(" || ")}]:[],...init?[{signal:GEO_INIT_TICK}]:[]],update:update}]})}},topLevelSignals:(model,selCmpt,signals)=>{if(isUnitModel(model)&&model.hasProjection&&selCmpt.init){const hasTick=signals.filter(s=>s.name===GEO_INIT_TICK);if(!hasTick.length){signals.unshift({name:GEO_INIT_TICK,value:null,on:[{events:"timer{1}",update:`${GEO_INIT_TICK} === null ? {} : ${GEO_INIT_TICK}`}]})}}return signals},marks:(model,selCmpt,marks)=>{const name=selCmpt.name;const{x:x,y:y}=selCmpt.project.hasChannel;const xvname=x===null||x===void 0?void 0:x.signals.visual;const yvname=y===null||y===void 0?void 0:y.signals.visual;const store=`data(${Object(vega_util["stringValue"])(selCmpt.name+STORE)})`;if(selection_scales.defined(selCmpt)||!x&&!y){return marks}const update={x:x!==undefined?{signal:`${xvname}[0]`}:{value:0},y:y!==undefined?{signal:`${yvname}[0]`}:{value:0},x2:x!==undefined?{signal:`${xvname}[1]`}:{field:{group:"width"}},y2:y!==undefined?{signal:`${yvname}[1]`}:{field:{group:"height"}}};if(selCmpt.resolve==="global"){for(const key of keys(update)){update[key]=[{test:`${store}.length && ${store}[0].unit === ${selection_unitName(model)}`,...update[key]},{value:0}]}}const{fill:fill,fillOpacity:fillOpacity,cursor:cursor,...stroke}=selCmpt.mark;const vgStroke=keys(stroke).reduce((def,k)=>{def[k]=[{test:[x!==undefined&&`${xvname}[0] !== ${xvname}[1]`,y!==undefined&&`${yvname}[0] !== ${yvname}[1]`].filter(t=>t).join(" && "),value:stroke[k]},{value:null}];return def},{});const vgCursor=cursor!==null&&cursor!==void 0?cursor:selCmpt.translate?"move":null;return[{name:`${name+BRUSH}_bg`,type:"rect",clip:true,encode:{enter:{fill:{value:fill},fillOpacity:{value:fillOpacity}},update:update}},...marks,{name:name+BRUSH,type:"rect",clip:true,encode:{enter:{...vgCursor?{cursor:{value:vgCursor}}:{},fill:{value:"transparent"}},update:{...update,...vgStroke}}}]}};var selection_interval=interval;function channelSignals(model,selCmpt,proj,init){const scaledInterval=!model.hasProjection;const channel=proj.channel;const vname=proj.signals.visual;const scaleName=Object(vega_util["stringValue"])(scaledInterval?model.scaleName(channel):model.projectionName());const scaled=str=>`scale(${scaleName}, ${str})`;const size=model.getSizeSignalRef(channel===X?"width":"height").signal;const coord=`${channel}(unit)`;const von=selCmpt.events.reduce((def,evt)=>[...def,{events:evt.between[0],update:`[${coord}, ${coord}]`},{events:evt,update:`[${vname}[0], clamp(${coord}, 0, ${size})]`}],[]);if(scaledInterval){const dname=proj.signals.data;const hasScales=selection_scales.defined(selCmpt);const scale=model.getScaleComponent(channel);const scaleType=scale?scale.get("type"):undefined;const vinit=init?{init:assembleInit(init,true,scaled)}:{value:[]};von.push({events:{signal:selCmpt.name+SCALE_TRIGGER},update:hasContinuousDomain(scaleType)?`[${scaled(`${dname}[0]`)}, ${scaled(`${dname}[1]`)}]`:`[0, 0]`});return hasScales?[{name:dname,on:[]}]:[{name:vname,...vinit,on:von},{name:dname,...init?{init:assembleInit(init)}:{},on:[{events:{signal:vname},update:`${vname}[0] === ${vname}[1] ? null : invert(${scaleName}, ${vname})`}]}]}else{const initIdx=channel===X?0:1;const initSg=selCmpt.name+INIT;const vinit=init?{init:`[${initSg}[0][${initIdx}], ${initSg}[1][${initIdx}]]`}:{value:[]};return[{name:vname,...vinit,on:von}]}}function wrapCondition(_ref){let{model:model,channelDef:channelDef,vgChannel:vgChannel,invalidValueRef:invalidValueRef,mainRefFn:mainRefFn}=_ref;const condition=isConditionalDef(channelDef)&&channelDef.condition;let valueRefs=[];if(condition){const conditions=Object(vega_util["array"])(condition);valueRefs=conditions.map(c=>{const conditionValueRef=mainRefFn(c);if(isConditionalParameter(c)){const{param:param,empty:empty}=c;const test=parseSelectionPredicate(model,{param:param,empty:empty});return{test:test,...conditionValueRef}}else{const test=predicate_expression(model,c.test);return{test:test,...conditionValueRef}}})}if(invalidValueRef!==undefined){valueRefs.push(invalidValueRef)}const mainValueRef=mainRefFn(channelDef);if(mainValueRef!==undefined){valueRefs.push(mainValueRef)}if(valueRefs.length>1||valueRefs.length===1&&Boolean(valueRefs[0].test)){return{[vgChannel]:valueRefs}}else if(valueRefs.length===1){return{[vgChannel]:valueRefs[0]}}return{}}function text_text(model){let channel=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"text";const channelDef=model.encoding[channel];return wrapCondition({model:model,channelDef:channelDef,vgChannel:channel,mainRefFn:cDef=>textRef(cDef,model.config),invalidValueRef:undefined})}function textRef(channelDef,config){let expr=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"datum";if(channelDef){if(isValueDef(channelDef)){return signalOrValueRef(channelDef.value)}if(isFieldOrDatumDef(channelDef)){const{format:format,formatType:formatType}=getFormatMixins(channelDef);return formatSignalRef({fieldOrDatumDef:channelDef,format:format,formatType:formatType,expr:expr,config:config})}}return undefined}function tooltip_tooltip(model){let opt=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const{encoding:encoding,markDef:markDef,config:config,stack:stack}=model;const channelDef=encoding.tooltip;if(Object(vega_util["isArray"])(channelDef)){return{tooltip:tooltipRefForEncoding({tooltip:channelDef},stack,config,opt)}}else{const datum=opt.reactiveGeom?"datum.datum":"datum";const mainRefFn=cDef=>{const tooltipRefFromChannelDef=textRef(cDef,config,datum);if(tooltipRefFromChannelDef){return tooltipRefFromChannelDef}if(cDef===null){return undefined}let markTooltip=getMarkPropOrConfig("tooltip",markDef,config);if(markTooltip===true){markTooltip={content:"encoding"}}if(Object(vega_util["isString"])(markTooltip)){return{value:markTooltip}}else if(Object(vega_util["isObject"])(markTooltip)){if(isSignalRef(markTooltip)){return markTooltip}else if(markTooltip.content==="encoding"){return tooltipRefForEncoding(encoding,stack,config,opt)}else{return{signal:datum}}}return undefined};return wrapCondition({model:model,channelDef:channelDef,vgChannel:"tooltip",mainRefFn:mainRefFn,invalidValueRef:undefined})}}function tooltipData(encoding,stack,config){let{reactiveGeom:reactiveGeom}=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};const formatConfig={...config,...config.tooltipFormat};const toSkip=new Set;const expr=reactiveGeom?"datum.datum":"datum";const tuples=[];function add(fDef,channel){var _value;const mainChannel=getMainRangeChannel(channel);const fieldDef=isTypedFieldDef(fDef)?fDef:{...fDef,type:encoding[mainChannel].type};const title=fieldDef.title||defaultTitle(fieldDef,formatConfig);const key=Object(vega_util["array"])(title).join(", ").replaceAll(/"/g,'\\"');let value;if(isXorY(channel)){const channel2=channel==="x"?"x2":"y2";const fieldDef2=getFieldDef(encoding[channel2]);if(isBinned(fieldDef.bin)&&fieldDef2){const startField=vgField(fieldDef,{expr:expr});const endField=vgField(fieldDef2,{expr:expr});const{format:format,formatType:formatType}=getFormatMixins(fieldDef);value=binFormatExpression(startField,endField,format,formatType,formatConfig);toSkip.add(channel2)}}if((isXorY(channel)||channel===THETA||channel===RADIUS)&&stack&&stack.fieldChannel===channel&&stack.offset==="normalize"){const{format:format,formatType:formatType}=getFormatMixins(fieldDef);value=formatSignalRef({fieldOrDatumDef:fieldDef,format:format,formatType:formatType,expr:expr,config:formatConfig,normalizeStack:true}).signal}(_value=value)!==null&&_value!==void 0?_value:value=textRef(fieldDef,formatConfig,expr).signal;tuples.push({channel:channel,key:key,value:value})}forEach(encoding,(channelDef,channel)=>{if(isFieldDef(channelDef)){add(channelDef,channel)}else if(hasConditionalFieldDef(channelDef)){add(channelDef.condition,channel)}});const out={};for(const{channel:channel,key:key,value:value}of tuples){if(!toSkip.has(channel)&&!out[key]){out[key]=value}}return out}function tooltipRefForEncoding(encoding,stack,config){let{reactiveGeom:reactiveGeom}=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};const data=tooltipData(encoding,stack,config,{reactiveGeom:reactiveGeom});const keyValues=entries(data).map(_ref=>{let[key,value]=_ref;return`"${key}": ${value}`});return keyValues.length>0?{signal:`{${keyValues.join(", ")}}`}:undefined}function aria_aria(model){const{markDef:markDef,config:config}=model;const enableAria=getMarkPropOrConfig("aria",markDef,config);if(enableAria===false){return{}}return{...enableAria?{aria:enableAria}:{},...ariaRoleDescription(model),...description(model)}}function ariaRoleDescription(model){const{mark:mark,markDef:markDef,config:config}=model;if(config.aria===false){return{}}const ariaRoleDesc=getMarkPropOrConfig("ariaRoleDescription",markDef,config);if(ariaRoleDesc!=null){return{ariaRoleDescription:{value:ariaRoleDesc}}}return Object(vega_util["hasOwnProperty"])(VG_MARK_INDEX,mark)?{}:{ariaRoleDescription:{value:mark}}}function description(model){const{encoding:encoding,markDef:markDef,config:config,stack:stack}=model;const channelDef=encoding.description;if(channelDef){return wrapCondition({model:model,channelDef:channelDef,vgChannel:"description",mainRefFn:cDef=>textRef(cDef,model.config),invalidValueRef:undefined})}const descriptionValue=getMarkPropOrConfig("description",markDef,config);if(descriptionValue!=null){return{description:signalOrValueRef(descriptionValue)}}if(config.aria===false){return{}}const data=tooltipData(encoding,stack,config);if(isEmpty(data)){return undefined}return{description:{signal:entries(data).map((_ref,index)=>{let[key,value]=_ref;return`"${index>0?"; ":""}${key}: " + (${value})`}).join(" + ")}}}function nonPosition(channel,model){let opt=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};const{markDef:markDef,encoding:encoding,config:config}=model;const{vgChannel:vgChannel}=opt;let{defaultRef:defaultRef,defaultValue:defaultValue}=opt;const channelDef=encoding[channel];if(defaultRef===undefined){var _defaultValue;(_defaultValue=defaultValue)!==null&&_defaultValue!==void 0?_defaultValue:defaultValue=getMarkPropOrConfig(channel,markDef,config,{vgChannel:vgChannel,ignoreVgConfig:!isConditionalDef(channelDef)});if(defaultValue!==undefined){defaultRef=signalOrValueRef(defaultValue)}}const commonProps={markDef:markDef,config:config,scaleName:model.scaleName(channel),scale:model.getScaleComponent(channel)};const invalidValueRef=getConditionalValueRefForIncludingInvalidValue({...commonProps,scaleChannel:channel,channelDef:channelDef});const mainRefFn=cDef=>midPoint({...commonProps,channel:channel,channelDef:cDef,stack:null,defaultRef:defaultRef});return wrapCondition({model:model,channelDef:channelDef,vgChannel:vgChannel!==null&&vgChannel!==void 0?vgChannel:channel,invalidValueRef:invalidValueRef,mainRefFn:mainRefFn})}function color_color(model){var _opt$filled,_ref,_getMarkPropOrConfig,_getMarkPropOrConfig2;let opt=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{filled:undefined};const{markDef:markDef,encoding:encoding,config:config}=model;const{type:markType}=markDef;const filled=(_opt$filled=opt.filled)!==null&&_opt$filled!==void 0?_opt$filled:getMarkPropOrConfig("filled",markDef,config);const transparentIfNeeded=util_contains(["bar","point","circle","square","geoshape"],markType)?"transparent":undefined;const defaultFill=(_ref=(_getMarkPropOrConfig=getMarkPropOrConfig(filled===true?"color":undefined,markDef,config,{vgChannel:"fill"}))!==null&&_getMarkPropOrConfig!==void 0?_getMarkPropOrConfig:config.mark[filled===true&&"color"])!==null&&_ref!==void 0?_ref:transparentIfNeeded;const defaultStroke=(_getMarkPropOrConfig2=getMarkPropOrConfig(filled===false?"color":undefined,markDef,config,{vgChannel:"stroke"}))!==null&&_getMarkPropOrConfig2!==void 0?_getMarkPropOrConfig2:config.mark[filled===false&&"color"];const colorVgChannel=filled?"fill":"stroke";const fillStrokeMarkDefAndConfig={...defaultFill?{fill:signalOrValueRef(defaultFill)}:{},...defaultStroke?{stroke:signalOrValueRef(defaultStroke)}:{}};if(markDef.color&&(filled?markDef.fill:markDef.stroke)){warn(message_namespaceObject.droppingColor("property",{fill:"fill"in markDef,stroke:"stroke"in markDef}))}return{...fillStrokeMarkDefAndConfig,...nonPosition("color",model,{vgChannel:colorVgChannel,defaultValue:filled?defaultFill:defaultStroke}),...nonPosition("fill",model,{defaultValue:encoding.fill?defaultFill:undefined}),...nonPosition("stroke",model,{defaultValue:encoding.stroke?defaultStroke:undefined})}}function zindex_zindex(model){const{encoding:encoding,mark:mark}=model;const order=encoding.order;if(!isPathMark(mark)&&isValueDef(order)){return wrapCondition({model:model,channelDef:order,vgChannel:"zindex",mainRefFn:cd=>signalOrValueRef(cd.value),invalidValueRef:undefined})}return{}}function positionOffset(_ref){let{channel:baseChannel,markDef:markDef,encoding:encoding={},model:model,bandPosition:bandPosition}=_ref;const channel=`${baseChannel}Offset`;const defaultValue=markDef[channel];const channelDef=encoding[channel];if((channel==="xOffset"||channel==="yOffset")&&channelDef){const ref=midPoint({channel:channel,channelDef:channelDef,markDef:markDef,config:model===null||model===void 0?void 0:model.config,scaleName:model.scaleName(channel),scale:model.getScaleComponent(channel),stack:null,defaultRef:signalOrValueRef(defaultValue),bandPosition:bandPosition});return{offsetType:"encoding",offset:ref}}const markDefOffsetValue=markDef[channel];if(markDefOffsetValue){return{offsetType:"visual",offset:markDefOffsetValue}}return{}}function pointPosition(channel,model,_ref){let{defaultPos:defaultPos,vgChannel:vgChannel}=_ref;const{encoding:encoding,markDef:markDef,config:config,stack:stack}=model;const channelDef=encoding[channel];const channel2Def=encoding[getSecondaryRangeChannel(channel)];const scaleName=model.scaleName(channel);const scale=model.getScaleComponent(channel);const{offset:offset,offsetType:offsetType}=positionOffset({channel:channel,markDef:markDef,encoding:encoding,model:model,bandPosition:.5});const defaultRef=pointPositionDefaultRef({model:model,defaultPos:defaultPos,channel:channel,scaleName:scaleName,scale:scale});const valueRef=!channelDef&&isXorY(channel)&&(encoding.latitude||encoding.longitude)?{field:model.getName(channel)}:positionRef({channel:channel,channelDef:channelDef,channel2Def:channel2Def,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:defaultRef,bandPosition:offsetType==="encoding"?0:undefined});return valueRef?{[vgChannel||channel]:valueRef}:undefined}function positionRef(params){const{channel:channel,channelDef:channelDef,scaleName:scaleName,stack:stack,offset:offset,markDef:markDef}=params;if(isFieldOrDatumDef(channelDef)&&stack&&channel===stack.fieldChannel){if(isFieldDef(channelDef)){let bandPosition=channelDef.bandPosition;if(bandPosition===undefined&&markDef.type==="text"&&(channel==="radius"||channel==="theta")){bandPosition=.5}if(bandPosition!==undefined){return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:channelDef,startSuffix:"start",bandPosition:bandPosition,offset:offset})}}return valueRefForFieldOrDatumDef(channelDef,scaleName,{suffix:"end"},{offset:offset})}return midPointRefWithPositionInvalidTest(params)}function pointPositionDefaultRef(_ref2){let{model:model,defaultPos:defaultPos,channel:channel,scaleName:scaleName,scale:scale}=_ref2;const{markDef:markDef,config:config}=model;return()=>{const mainChannel=getMainRangeChannel(channel);const vgChannel=getVgPositionChannel(channel);const definedValueOrConfig=getMarkPropOrConfig(channel,markDef,config,{vgChannel:vgChannel});if(definedValueOrConfig!==undefined){return widthHeightValueOrSignalRef(channel,definedValueOrConfig)}switch(defaultPos){case"zeroOrMin":return zeroOrMinOrMaxPosition({scaleName:scaleName,scale:scale,mode:"zeroOrMin",mainChannel:mainChannel,config:config});case"zeroOrMax":return zeroOrMinOrMaxPosition({scaleName:scaleName,scale:scale,mode:{zeroOrMax:{widthSignal:model.width.signal,heightSignal:model.height.signal}},mainChannel:mainChannel,config:config});case"mid":{const sizeRef=model[getSizeChannel(channel)];return{...sizeRef,mult:.5}}}return undefined}}function zeroOrMinOrMaxPosition(_ref3){let{mainChannel:mainChannel,config:config,...otherProps}=_ref3;const scaledValueRef=scaledZeroOrMinOrMax(otherProps);const{mode:mode}=otherProps;if(scaledValueRef){return scaledValueRef}switch(mainChannel){case"radius":{if(mode==="zeroOrMin"){return{value:0}}const{widthSignal:widthSignal,heightSignal:heightSignal}=mode.zeroOrMax;return{signal:`min(${widthSignal},${heightSignal})/2`}}case"theta":return mode==="zeroOrMin"?{value:0}:{signal:"2*PI"};case"x":return mode==="zeroOrMin"?{value:0}:{field:{group:"width"}};case"y":return mode==="zeroOrMin"?{field:{group:"height"}}:{value:0}}}const ALIGNED_X_CHANNEL={left:"x",center:"xc",right:"x2"};const BASELINED_Y_CHANNEL={top:"y",middle:"yc",bottom:"y2"};function vgAlignedPositionChannel(channel,markDef,config){let defaultAlign=arguments.length>3&&arguments[3]!==undefined?arguments[3]:"middle";if(channel==="radius"||channel==="theta"){return getVgPositionChannel(channel)}const alignChannel=channel==="x"?"align":"baseline";const align=getMarkPropOrConfig(alignChannel,markDef,config);let alignExcludingSignal;if(isSignalRef(align)){warn(message_namespaceObject.rangeMarkAlignmentCannotBeExpression(alignChannel));alignExcludingSignal=undefined}else{alignExcludingSignal=align}if(channel==="x"){return ALIGNED_X_CHANNEL[alignExcludingSignal||(defaultAlign==="top"?"left":"center")]}else{return BASELINED_Y_CHANNEL[alignExcludingSignal||defaultAlign]}}function pointOrRangePosition(channel,model,_ref){let{defaultPos:defaultPos,defaultPos2:defaultPos2,range:range}=_ref;if(range){return rangePosition(channel,model,{defaultPos:defaultPos,defaultPos2:defaultPos2})}return pointPosition(channel,model,{defaultPos:defaultPos})}function rangePosition(channel,model,_ref2){let{defaultPos:defaultPos,defaultPos2:defaultPos2}=_ref2;const{markDef:markDef,config:config}=model;const channel2=getSecondaryRangeChannel(channel);const sizeChannel=getSizeChannel(channel);const pos2Mixins=pointPosition2OrSize(model,defaultPos2,channel2);const vgChannel=pos2Mixins[sizeChannel]?vgAlignedPositionChannel(channel,markDef,config):getVgPositionChannel(channel);return{...pointPosition(channel,model,{defaultPos:defaultPos,vgChannel:vgChannel}),...pos2Mixins}}function pointPosition2OrSize(model,defaultPos,channel){const{encoding:encoding,mark:mark,markDef:markDef,stack:stack,config:config}=model;const baseChannel=getMainRangeChannel(channel);const sizeChannel=getSizeChannel(channel);const vgChannel=getVgPositionChannel(channel);const channelDef=encoding[baseChannel];const scaleName=model.scaleName(baseChannel);const scale=model.getScaleComponent(baseChannel);const{offset:offset}=channel in encoding||channel in markDef?positionOffset({channel:channel,markDef:markDef,encoding:encoding,model:model}):positionOffset({channel:baseChannel,markDef:markDef,encoding:encoding,model:model});if(!channelDef&&(channel==="x2"||channel==="y2")&&(encoding.latitude||encoding.longitude)){const vgSizeChannel=getSizeChannel(channel);const size=model.markDef[vgSizeChannel];if(size!=null){return{[vgSizeChannel]:{value:size}}}else{return{[vgChannel]:{field:model.getName(channel)}}}}const valueRef=position2Ref({channel:channel,channelDef:channelDef,channel2Def:encoding[channel],markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:undefined});if(valueRef!==undefined){return{[vgChannel]:valueRef}}return position2orSize(channel,markDef)||position2orSize(channel,{[channel]:getMarkStyleConfig(channel,markDef,config.style),[sizeChannel]:getMarkStyleConfig(sizeChannel,markDef,config.style)})||position2orSize(channel,config[mark])||position2orSize(channel,config.mark)||{[vgChannel]:pointPositionDefaultRef({model:model,defaultPos:defaultPos,channel:channel,scaleName:scaleName,scale:scale})()}}function position2Ref(_ref3){let{channel:channel,channelDef:channelDef,channel2Def:channel2Def,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:defaultRef}=_ref3;if(isFieldOrDatumDef(channelDef)&&stack&&channel.charAt(0)===stack.fieldChannel.charAt(0)){return valueRefForFieldOrDatumDef(channelDef,scaleName,{suffix:"start"},{offset:offset})}return midPointRefWithPositionInvalidTest({channel:channel,channelDef:channel2Def,scaleName:scaleName,scale:scale,stack:stack,markDef:markDef,config:config,offset:offset,defaultRef:defaultRef})}function position2orSize(channel,markDef){const sizeChannel=getSizeChannel(channel);const vgChannel=getVgPositionChannel(channel);if(markDef[vgChannel]!==undefined){return{[vgChannel]:widthHeightValueOrSignalRef(channel,markDef[vgChannel])}}else if(markDef[channel]!==undefined){return{[vgChannel]:widthHeightValueOrSignalRef(channel,markDef[channel])}}else if(markDef[sizeChannel]){const dimensionSize=markDef[sizeChannel];if(isRelativeBandSize(dimensionSize)){warn(message_namespaceObject.relativeBandSizeNotSupported(sizeChannel))}else{return{[sizeChannel]:widthHeightValueOrSignalRef(channel,dimensionSize)}}}return undefined}function rectPosition(model,channel){var _ref,_sizeChannel;const{config:config,encoding:encoding,markDef:markDef}=model;const mark=markDef.type;const channel2=getSecondaryRangeChannel(channel);const sizeChannel=getSizeChannel(channel);const channelDef=encoding[channel];const channelDef2=encoding[channel2];const scale=model.getScaleComponent(channel);const scaleType=scale?scale.get("type"):undefined;const orient=markDef.orient;const hasSizeDef=(_ref=(_sizeChannel=encoding[sizeChannel])!==null&&_sizeChannel!==void 0?_sizeChannel:encoding.size)!==null&&_ref!==void 0?_ref:getMarkPropOrConfig("size",markDef,config,{vgChannel:sizeChannel});const offsetScaleChannel=getOffsetChannel(channel);const isBarOrTickBand=mark==="bar"&&(channel==="x"?orient==="vertical":orient==="horizontal")||mark==="tick"&&(channel==="y"?orient==="vertical":orient==="horizontal");if(isFieldDef(channelDef)&&(isBinning(channelDef.bin)||isBinned(channelDef.bin)||channelDef.timeUnit&&!channelDef2)&&!(hasSizeDef&&!isRelativeBandSize(hasSizeDef))&&!encoding[offsetScaleChannel]&&!hasDiscreteDomain(scaleType)){return rectBinPosition({fieldDef:channelDef,fieldDef2:channelDef2,channel:channel,model:model})}else if((isFieldOrDatumDef(channelDef)&&hasDiscreteDomain(scaleType)||isBarOrTickBand)&&!channelDef2){return positionAndSize(channelDef,channel,model)}else{return rangePosition(channel,model,{defaultPos:"zeroOrMax",defaultPos2:"zeroOrMin"})}}function defaultSizeRef(sizeChannel,scaleName,scale,config,bandSize,hasFieldDef,mark){if(isRelativeBandSize(bandSize)){if(scale){const scaleType=scale.get("type");if(scaleType==="band"){let bandWidth=`bandwidth('${scaleName}')`;if(bandSize.band!==1){bandWidth=`${bandSize.band} * ${bandWidth}`}const minBandSize=getMarkConfig("minBandSize",{type:mark},config);return{signal:minBandSize?`max(${signalOrStringValue(minBandSize)}, ${bandWidth})`:bandWidth}}else if(bandSize.band!==1){warn(message_namespaceObject.cannotUseRelativeBandSizeWithNonBandScale(scaleType));bandSize=undefined}}else{return{mult:bandSize.band,field:{group:sizeChannel}}}}else if(isSignalRef(bandSize)){return bandSize}else if(bandSize){return{value:bandSize}}if(scale){const scaleRange=scale.get("range");if(isVgRangeStep(scaleRange)&&Object(vega_util["isNumber"])(scaleRange.step)){return{value:scaleRange.step-2}}}if(!hasFieldDef){const{bandPaddingInner:bandPaddingInner,barBandPaddingInner:barBandPaddingInner,rectBandPaddingInner:rectBandPaddingInner,tickBandPaddingInner:tickBandPaddingInner}=config.scale;const padding=getFirstDefined(bandPaddingInner,mark==="tick"?tickBandPaddingInner:mark==="bar"?barBandPaddingInner:rectBandPaddingInner);if(isSignalRef(padding)){return{signal:`(1 - (${padding.signal})) * ${sizeChannel}`}}else if(Object(vega_util["isNumber"])(padding)){return{signal:`${1-padding} * ${sizeChannel}`}}}const defaultStep=getViewConfigDiscreteStep(config.view,sizeChannel);return{value:defaultStep-2}}function positionAndSize(fieldDef,channel,model){var _ref2,_ref3;const{markDef:markDef,encoding:encoding,config:config,stack:stack}=model;const orient=markDef.orient;const scaleName=model.scaleName(channel);const scale=model.getScaleComponent(channel);const vgSizeChannel=getSizeChannel(channel);const channel2=getSecondaryRangeChannel(channel);const offsetScaleChannel=getOffsetChannel(channel);const offsetScaleName=model.scaleName(offsetScaleChannel);const offsetScale=model.getScaleComponent(getOffsetScaleChannel(channel));const useVlSizeChannel=markDef.type==="tick"||orient==="horizontal"&&channel==="y"||orient==="vertical"&&channel==="x";let sizeMixins;if(encoding.size||markDef.size){if(useVlSizeChannel){sizeMixins=nonPosition("size",model,{vgChannel:vgSizeChannel,defaultRef:signalOrValueRef(markDef.size)})}else{warn(message_namespaceObject.cannotApplySizeToNonOrientedMark(markDef.type))}}const hasSizeFromMarkOrEncoding=!!sizeMixins;const bandSize=getBandSize({channel:channel,fieldDef:fieldDef,markDef:markDef,config:config,scaleType:(_ref2=scale||offsetScale)===null||_ref2===void 0?void 0:_ref2.get("type"),useVlSizeChannel:useVlSizeChannel});sizeMixins=sizeMixins||{[vgSizeChannel]:defaultSizeRef(vgSizeChannel,offsetScaleName||scaleName,offsetScale||scale,config,bandSize,!!fieldDef,markDef.type)};const defaultBandAlign=((_ref3=scale||offsetScale)===null||_ref3===void 0?void 0:_ref3.get("type"))==="band"&&isRelativeBandSize(bandSize)&&!hasSizeFromMarkOrEncoding?"top":"middle";const vgChannel=vgAlignedPositionChannel(channel,markDef,config,defaultBandAlign);const center=vgChannel==="xc"||vgChannel==="yc";const{offset:offset,offsetType:offsetType}=positionOffset({channel:channel,markDef:markDef,encoding:encoding,model:model,bandPosition:center?.5:0});const posRef=midPointRefWithPositionInvalidTest({channel:channel,channelDef:fieldDef,markDef:markDef,config:config,scaleName:scaleName,scale:scale,stack:stack,offset:offset,defaultRef:pointPositionDefaultRef({model:model,defaultPos:"mid",channel:channel,scaleName:scaleName,scale:scale}),bandPosition:center?offsetType==="encoding"?0:.5:isSignalRef(bandSize)?{signal:`(1-${bandSize})/2`}:isRelativeBandSize(bandSize)?(1-bandSize.band)/2:0});if(vgSizeChannel){return{[vgChannel]:posRef,...sizeMixins}}else{const vgChannel2=getVgPositionChannel(channel2);const sizeRef=sizeMixins[vgSizeChannel];const sizeOffset=offset?{...sizeRef,offset:offset}:sizeRef;return{[vgChannel]:posRef,[vgChannel2]:Object(vega_util["isArray"])(posRef)?[posRef[0],{...posRef[1],offset:sizeOffset}]:{...posRef,offset:sizeOffset}}}}function getBinSpacing(channel,spacing,reverse,axisTranslate,offset,minBandSize,bandSizeExpr){if(isPolarPositionChannel(channel)){return 0}const isEnd=channel==="x"||channel==="y2";const spacingOffset=isEnd?-spacing/2:spacing/2;if(isSignalRef(reverse)||isSignalRef(offset)||isSignalRef(axisTranslate)||minBandSize){const reverseExpr=signalOrStringValue(reverse);const offsetExpr=signalOrStringValue(offset);const axisTranslateExpr=signalOrStringValue(axisTranslate);const minBandSizeExpr=signalOrStringValue(minBandSize);const sign=isEnd?"":"-";const spacingAndSizeOffset=minBandSize?`(${bandSizeExpr} < ${minBandSizeExpr} ? ${sign}0.5 * (${minBandSizeExpr} - (${bandSizeExpr})) : ${spacingOffset})`:spacingOffset;const t=axisTranslateExpr?`${axisTranslateExpr} + `:"";const r=reverseExpr?`(${reverseExpr} ? -1 : 1) * `:"";const o=offsetExpr?`(${offsetExpr} + ${spacingAndSizeOffset})`:spacingAndSizeOffset;return{signal:t+r+o}}else{offset=offset||0;return axisTranslate+(reverse?-offset-spacingOffset:+offset+spacingOffset)}}function rectBinPosition(_ref4){var _channel,_axis$get,_getMarkPropOrConfig;let{fieldDef:fieldDef,fieldDef2:fieldDef2,channel:channel,model:model}=_ref4;const{config:config,markDef:markDef,encoding:encoding}=model;const scale=model.getScaleComponent(channel);const scaleName=model.scaleName(channel);const scaleType=scale?scale.get("type"):undefined;const reverse=scale.get("reverse");const bandSize=getBandSize({channel:channel,fieldDef:fieldDef,markDef:markDef,config:config,scaleType:scaleType});const axis=(_channel=model.component.axes[channel])===null||_channel===void 0?void 0:_channel[0];const axisTranslate=(_axis$get=axis===null||axis===void 0?void 0:axis.get("translate"))!==null&&_axis$get!==void 0?_axis$get:.5;const spacing=isXorY(channel)?(_getMarkPropOrConfig=getMarkPropOrConfig("binSpacing",markDef,config))!==null&&_getMarkPropOrConfig!==void 0?_getMarkPropOrConfig:0:0;const channel2=getSecondaryRangeChannel(channel);const vgChannel=getVgPositionChannel(channel);const vgChannel2=getVgPositionChannel(channel2);const minBandSize=getMarkConfig("minBandSize",markDef,config);const{offset:offset}=positionOffset({channel:channel,markDef:markDef,encoding:encoding,model:model,bandPosition:0});const{offset:offset2}=positionOffset({channel:channel2,markDef:markDef,encoding:encoding,model:model,bandPosition:0});const bandSizeExpr=binSizeExpr({fieldDef:fieldDef,scaleName:scaleName});const binSpacingOffset=getBinSpacing(channel,spacing,reverse,axisTranslate,offset,minBandSize,bandSizeExpr);const binSpacingOffset2=getBinSpacing(channel2,spacing,reverse,axisTranslate,offset2!==null&&offset2!==void 0?offset2:offset,minBandSize,bandSizeExpr);const bandPositionForBandSize=isSignalRef(bandSize)?{signal:`(1-${bandSize.signal})/2`}:isRelativeBandSize(bandSize)?(1-bandSize.band)/2:.5;const bandPosition=getBandPosition({fieldDef:fieldDef,fieldDef2:fieldDef2,markDef:markDef,config:config});if(isBinning(fieldDef.bin)||fieldDef.timeUnit){const useRectOffsetField=fieldDef.timeUnit&&bandPosition!==.5;return{[vgChannel2]:rectBinRef({fieldDef:fieldDef,scaleName:scaleName,bandPosition:bandPositionForBandSize,offset:binSpacingOffset2,useRectOffsetField:useRectOffsetField}),[vgChannel]:rectBinRef({fieldDef:fieldDef,scaleName:scaleName,bandPosition:isSignalRef(bandPositionForBandSize)?{signal:`1-${bandPositionForBandSize.signal}`}:1-bandPositionForBandSize,offset:binSpacingOffset,useRectOffsetField:useRectOffsetField})}}else if(isBinned(fieldDef.bin)){const startRef=valueRefForFieldOrDatumDef(fieldDef,scaleName,{},{offset:binSpacingOffset2});if(isFieldDef(fieldDef2)){return{[vgChannel2]:startRef,[vgChannel]:valueRefForFieldOrDatumDef(fieldDef2,scaleName,{},{offset:binSpacingOffset})}}else if(isBinParams(fieldDef.bin)&&fieldDef.bin.step){return{[vgChannel2]:startRef,[vgChannel]:{signal:`scale("${scaleName}", ${vgField(fieldDef,{expr:"datum"})} + ${fieldDef.bin.step})`,offset:binSpacingOffset}}}}warn(message_namespaceObject.channelRequiredForBinned(channel2));return undefined}function rectBinRef(_ref5){let{fieldDef:fieldDef,scaleName:scaleName,bandPosition:bandPosition,offset:offset,useRectOffsetField:useRectOffsetField}=_ref5;return interpolatedSignalRef({scaleName:scaleName,fieldOrDatumDef:fieldDef,bandPosition:bandPosition,offset:offset,...useRectOffsetField?{startSuffix:OFFSETTED_RECT_START_SUFFIX,endSuffix:OFFSETTED_RECT_END_SUFFIX}:{}})}const ALWAYS_IGNORE=new Set(["aria","width","height"]);function baseEncodeEntry(model,ignore){const{fill:fill=undefined,stroke:stroke=undefined}=ignore.color==="include"?color_color(model):{};return{...markDefProperties(model.markDef,ignore),...colorRef("fill",fill),...colorRef("stroke",stroke),...nonPosition("opacity",model),...nonPosition("fillOpacity",model),...nonPosition("strokeOpacity",model),...nonPosition("strokeWidth",model),...nonPosition("strokeDash",model),...zindex_zindex(model),...tooltip_tooltip(model),...text_text(model,"href"),...aria_aria(model)}}function colorRef(channel,valueRef){return valueRef?{[channel]:valueRef}:{}}function markDefProperties(mark,ignore){return VG_MARK_CONFIGS.reduce((m,prop)=>{if(!ALWAYS_IGNORE.has(prop)&&hasProperty(mark,prop)&&ignore[prop]!=="ignore"){m[prop]=signalOrValueRef(mark[prop])}return m},{})}function defined(model){const{config:config,markDef:markDef}=model;const fieldsToBreakPath=new Set;model.forEachFieldDef((fieldDef,channel)=>{let scaleType;if(!isScaleChannel(channel)||!(scaleType=model.getScaleType(channel))){return}const isCountAggregate=isCountingAggregateOp(fieldDef.aggregate);const invalidDataMode=getScaleInvalidDataMode({scaleChannel:channel,markDef:markDef,config:config,scaleType:scaleType,isCountAggregate:isCountAggregate});if(shouldBreakPath(invalidDataMode)){var _model$stack;const field=model.vgField(channel,{expr:"datum",binSuffix:(_model$stack=model.stack)!==null&&_model$stack!==void 0&&_model$stack.impute?"mid":undefined});if(field){fieldsToBreakPath.add(field)}}});if(fieldsToBreakPath.size>0){const signal=[...fieldsToBreakPath].map(field=>fieldValidPredicate(field,true)).join(" && ");return{defined:{signal:signal}}}return undefined}function valueIfDefined(prop,value){if(value!==undefined){return{[prop]:signalOrValueRef(value)}}return undefined}const VORONOI="voronoi";const nearest={defined:selCmpt=>selCmpt.type==="point"&&selCmpt.nearest,parse:(model,selCmpt)=>{if(selCmpt.events){for(const s of selCmpt.events){s.markname=model.getName(VORONOI)}}},marks:(model,selCmpt,marks)=>{const{x:x,y:y}=selCmpt.project.hasChannel;const markType=model.mark;if(isPathMark(markType)){warn(message_namespaceObject.nearestNotSupportForContinuous(markType));return marks}const cellDef={name:model.getName(VORONOI),type:"path",interactive:true,from:{data:model.getName("marks")},encode:{update:{fill:{value:"transparent"},strokeWidth:{value:.35},stroke:{value:"transparent"},isVoronoi:{value:true},...tooltip_tooltip(model,{reactiveGeom:true})}},transform:[{type:"voronoi",x:{expr:x||!y?"datum.datum.x || 0":"0"},y:{expr:y||!x?"datum.datum.y || 0":"0"},size:[model.getSizeSignalRef("width"),model.getSizeSignalRef("height")]}]};let index=0;let exists=false;marks.forEach((mark,i)=>{var _mark$name;const name=(_mark$name=mark.name)!==null&&_mark$name!==void 0?_mark$name:"";if(name===model.component.mark[0].name){index=i}else if(name.includes(VORONOI)){exists=true}});if(!exists){marks.splice(index+1,0,cellDef)}return marks}};var selection_nearest=nearest;const inputBindings={defined:selCmpt=>selCmpt.type==="point"&&selCmpt.resolve==="global"&&selCmpt.bind&&selCmpt.bind!=="scales"&&!isLegendBinding(selCmpt.bind),parse:(model,selCmpt,selDef)=>disableDirectManipulation(selCmpt,selDef),topLevelSignals:(model,selCmpt,signals)=>{const name=selCmpt.name;const proj=selCmpt.project;const bind=selCmpt.bind;const init=selCmpt.init&&selCmpt.init[0];const datum=selection_nearest.defined(selCmpt)?"(item().isVoronoi ? datum.datum : datum)":"datum";proj.items.forEach((p,i)=>{const sgname=varName(`${name}_${p.field}`);const hasSignal=signals.filter(s=>s.name===sgname);if(!hasSignal.length){var _ref,_p$field;signals.unshift({name:sgname,...init?{init:assembleInit(init[i])}:{value:null},on:selCmpt.events?[{events:selCmpt.events,update:`datum && item().mark.marktype !== 'group' ? ${datum}[${Object(vega_util["stringValue"])(p.field)}] : null`}]:[],bind:(_ref=(_p$field=bind[p.field])!==null&&_p$field!==void 0?_p$field:bind[p.channel])!==null&&_ref!==void 0?_ref:bind})}});return signals},signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const proj=selCmpt.project;const signal=signals.find(s=>s.name===name+TUPLE);const fields=name+TUPLE_FIELDS;const values=proj.items.map(p=>varName(`${name}_${p.field}`));const valid=values.map(v=>`${v} !== null`).join(" && ");if(values.length){signal.update=`${valid} ? {fields: ${fields}, values: [${values.join(", ")}]} : null`}delete signal.value;delete signal.on;return signals}};var inputs=inputBindings;const TOGGLE="_toggle";const toggle_toggle={defined:selCmpt=>selCmpt.type==="point"&&!isTimerSelection(selCmpt)&&!!selCmpt.toggle,signals:(model,selCmpt,signals)=>signals.concat({name:selCmpt.name+TOGGLE,value:false,on:[{events:selCmpt.events,update:selCmpt.toggle}]}),modifyExpr:(model,selCmpt)=>{const tpl=selCmpt.name+TUPLE;const signal=selCmpt.name+TOGGLE;return`${signal} ? null : ${tpl}, `+(selCmpt.resolve==="global"?`${signal} ? null : true, `:`${signal} ? null : {unit: ${selection_unitName(model)}}, `)+`${signal} ? ${tpl} : null`}};var selection_toggle=toggle_toggle;const clear={defined:selCmpt=>selCmpt.clear!==undefined&&selCmpt.clear!==false&&!isTimerSelection(selCmpt),parse:(model,selCmpt)=>{if(selCmpt.clear){selCmpt.clear=Object(vega_util["isString"])(selCmpt.clear)?Object(vega_event_selector["parseSelector"])(selCmpt.clear,"view"):selCmpt.clear}},topLevelSignals:(model,selCmpt,signals)=>{if(inputs.defined(selCmpt)){for(const proj of selCmpt.project.items){const idx=signals.findIndex(n=>n.name===varName(`${selCmpt.name}_${proj.field}`));if(idx!==-1){signals[idx].on.push({events:selCmpt.clear,update:"null"})}}}return signals},signals:(model,selCmpt,signals)=>{function addClear(idx,update){if(idx!==-1&&signals[idx].on){signals[idx].on.push({events:selCmpt.clear,update:update})}}if(selCmpt.type==="interval"){for(const proj of selCmpt.project.items){const vIdx=signals.findIndex(n=>n.name===proj.signals.visual);addClear(vIdx,"[0, 0]");if(vIdx===-1){const dIdx=signals.findIndex(n=>n.name===proj.signals.data);addClear(dIdx,"null")}}}else{let tIdx=signals.findIndex(n=>n.name===selCmpt.name+TUPLE);addClear(tIdx,"null");if(selection_toggle.defined(selCmpt)){tIdx=signals.findIndex(n=>n.name===selCmpt.name+TOGGLE);addClear(tIdx,"false")}}return signals}};var selection_clear=clear;const legendBindings={defined:selCmpt=>{const spec=selCmpt.resolve==="global"&&selCmpt.bind&&isLegendBinding(selCmpt.bind);const projLen=selCmpt.project.items.length===1&&selCmpt.project.items[0].field!==SELECTION_ID;if(spec&&!projLen){warn(message_namespaceObject.LEGEND_BINDINGS_MUST_HAVE_PROJECTION)}return spec&&projLen},parse:(model,selCmpt,selDef)=>{const selDef_=duplicate(selDef);selDef_.select=Object(vega_util["isString"])(selDef_.select)?{type:selDef_.select,toggle:selCmpt.toggle}:{...selDef_.select,toggle:selCmpt.toggle};disableDirectManipulation(selCmpt,selDef_);if(Object(vega_node["isObject"])(selDef.select)&&(selDef.select.on||selDef.select.clear)){const legendFilter='event.item && indexof(event.item.mark.role, "legend") < 0';for(const evt of selCmpt.events){var _evt$filter;evt.filter=Object(vega_util["array"])((_evt$filter=evt.filter)!==null&&_evt$filter!==void 0?_evt$filter:[]);if(!evt.filter.includes(legendFilter)){evt.filter.push(legendFilter)}}}const evt=isLegendStreamBinding(selCmpt.bind)?selCmpt.bind.legend:"click";const stream=Object(vega_util["isString"])(evt)?Object(vega_event_selector["parseSelector"])(evt,"view"):Object(vega_util["array"])(evt);selCmpt.bind={legend:{merge:stream}}},topLevelSignals:(model,selCmpt,signals)=>{const selName=selCmpt.name;const stream=isLegendStreamBinding(selCmpt.bind)&&selCmpt.bind.legend;const markName=name=>s=>{const ds=duplicate(s);ds.markname=name;return ds};for(const proj of selCmpt.project.items){if(!proj.hasLegend)continue;const prefix=`${varName(proj.field)}_legend`;const sgName=`${selName}_${prefix}`;const hasSignal=signals.filter(s=>s.name===sgName);if(hasSignal.length===0){const events=stream.merge.map(markName(`${prefix}_symbols`)).concat(stream.merge.map(markName(`${prefix}_labels`))).concat(stream.merge.map(markName(`${prefix}_entries`)));signals.unshift({name:sgName,...!selCmpt.init?{value:null}:{},on:[{events:events,update:"isDefined(datum.value) ? datum.value : item().items[0].items[0].datum.value",force:true},{events:stream.merge,update:`!event.item || !datum ? null : ${sgName}`,force:true}]})}}return signals},signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const proj=selCmpt.project;const tuple=signals.find(s=>s.name===name+TUPLE);const fields=name+TUPLE_FIELDS;const values=proj.items.filter(p=>p.hasLegend).map(p=>varName(`${name}_${varName(p.field)}_legend`));const valid=values.map(v=>`${v} !== null`).join(" && ");const update=`${valid} ? {fields: ${fields}, values: [${values.join(", ")}]} : null`;if(selCmpt.events&&values.length>0){tuple.on.push({events:values.map(signal=>({signal:signal})),update:update})}else if(values.length>0){tuple.update=update;delete tuple.value;delete tuple.on}const toggle=signals.find(s=>s.name===name+TOGGLE);const events=isLegendStreamBinding(selCmpt.bind)&&selCmpt.bind.legend;if(toggle){if(!selCmpt.events)toggle.on[0].events=events;else toggle.on.push({...toggle.on[0],events:events})}return signals}};var selection_legends=legendBindings;function parseInteractiveLegend(model,channel,legendCmpt){var _model$fieldDef;const field=(_model$fieldDef=model.fieldDef(channel))===null||_model$fieldDef===void 0?void 0:_model$fieldDef.field;for(const selCmpt of util_vals((_model$component$sele=model.component.selection)!==null&&_model$component$sele!==void 0?_model$component$sele:{})){var _model$component$sele,_selCmpt$project$hasF;const proj=(_selCmpt$project$hasF=selCmpt.project.hasField[field])!==null&&_selCmpt$project$hasF!==void 0?_selCmpt$project$hasF:selCmpt.project.hasChannel[channel];if(proj&&legendBindings.defined(selCmpt)){var _legendCmpt$get;const legendSelections=(_legendCmpt$get=legendCmpt.get("selections"))!==null&&_legendCmpt$get!==void 0?_legendCmpt$get:[];legendSelections.push(selCmpt.name);legendCmpt.set("selections",legendSelections,false);proj.hasLegend=true}}}const ANCHOR="_translate_anchor";const DELTA="_translate_delta";const translate={defined:selCmpt=>selCmpt.type==="interval"&&selCmpt.translate,signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const boundScales=selection_scales.defined(selCmpt);const anchor=name+ANCHOR;const{x:x,y:y}=selCmpt.project.hasChannel;let events=Object(vega_event_selector["parseSelector"])(selCmpt.translate,"scope");if(!boundScales){events=events.map(e=>(e.between[0].markname=name+BRUSH,e))}signals.push({name:anchor,value:{},on:[{events:events.map(e=>e.between[0]),update:"{x: x(unit), y: y(unit)"+(x!==undefined?`, extent_x: ${boundScales?scales_domain(model,X):`slice(${x.signals.visual})`}`:"")+(y!==undefined?`, extent_y: ${boundScales?scales_domain(model,Y):`slice(${y.signals.visual})`}`:"")+"}"}]},{name:name+DELTA,value:{},on:[{events:events,update:`{x: ${anchor}.x - x(unit), y: ${anchor}.y - y(unit)}`}]});if(x!==undefined){onDelta(model,selCmpt,x,"width",signals)}if(y!==undefined){onDelta(model,selCmpt,y,"height",signals)}return signals}};var selection_translate=translate;function onDelta(model,selCmpt,proj,size,signals){var _scaleCmpt$get,_scaleCmpt$get2;const name=selCmpt.name;const anchor=name+ANCHOR;const delta=name+DELTA;const channel=proj.channel;const boundScales=selection_scales.defined(selCmpt);const signal=signals.find(s=>s.name===proj.signals[boundScales?"data":"visual"]);const sizeSg=model.getSizeSignalRef(size).signal;const scaleCmpt=model.getScaleComponent(channel);const scaleType=scaleCmpt&&scaleCmpt.get("type");const reversed=scaleCmpt&&scaleCmpt.get("reverse");const sign=!boundScales?"":channel===X?reversed?"":"-":reversed?"-":"";const extent=`${anchor}.extent_${channel}`;const offset=`${sign}${delta}.${channel} / ${boundScales?`${sizeSg}`:`span(${extent})`}`;const panFn=!boundScales||!scaleCmpt?"panLinear":scaleType==="log"?"panLog":scaleType==="symlog"?"panSymlog":scaleType==="pow"?"panPow":"panLinear";const arg=!boundScales?"":scaleType==="pow"?`, ${(_scaleCmpt$get=scaleCmpt.get("exponent"))!==null&&_scaleCmpt$get!==void 0?_scaleCmpt$get:1}`:scaleType==="symlog"?`, ${(_scaleCmpt$get2=scaleCmpt.get("constant"))!==null&&_scaleCmpt$get2!==void 0?_scaleCmpt$get2:1}`:"";const update=`${panFn}(${extent}, ${offset}${arg})`;signal.on.push({events:{signal:delta},update:boundScales?update:`clampRange(${update}, 0, ${sizeSg})`})}const zoom_ANCHOR="_zoom_anchor";const zoom_DELTA="_zoom_delta";const zoom={defined:selCmpt=>selCmpt.type==="interval"&&selCmpt.zoom,signals:(model,selCmpt,signals)=>{const name=selCmpt.name;const boundScales=selection_scales.defined(selCmpt);const delta=name+zoom_DELTA;const{x:x,y:y}=selCmpt.project.hasChannel;const sx=Object(vega_util["stringValue"])(model.scaleName(X));const sy=Object(vega_util["stringValue"])(model.scaleName(Y));let events=Object(vega_event_selector["parseSelector"])(selCmpt.zoom,"scope");if(!boundScales){events=events.map(e=>(e.markname=name+BRUSH,e))}signals.push({name:name+zoom_ANCHOR,on:[{events:events,update:!boundScales?`{x: x(unit), y: y(unit)}`:"{"+[sx?`x: invert(${sx}, x(unit))`:"",sy?`y: invert(${sy}, y(unit))`:""].filter(expr=>expr).join(", ")+"}"}]},{name:delta,on:[{events:events,force:true,update:"pow(1.001, event.deltaY * pow(16, event.deltaMode))"}]});if(x!==undefined){zoom_onDelta(model,selCmpt,x,"width",signals)}if(y!==undefined){zoom_onDelta(model,selCmpt,y,"height",signals)}return signals}};var selection_zoom=zoom;function zoom_onDelta(model,selCmpt,proj,size,signals){var _scaleCmpt$get,_scaleCmpt$get2;const name=selCmpt.name;const channel=proj.channel;const boundScales=selection_scales.defined(selCmpt);const signal=signals.find(s=>s.name===proj.signals[boundScales?"data":"visual"]);const sizeSg=model.getSizeSignalRef(size).signal;const scaleCmpt=model.getScaleComponent(channel);const scaleType=scaleCmpt&&scaleCmpt.get("type");const base=boundScales?scales_domain(model,channel):signal.name;const delta=name+zoom_DELTA;const anchor=`${name}${zoom_ANCHOR}.${channel}`;const zoomFn=!boundScales||!scaleCmpt?"zoomLinear":scaleType==="log"?"zoomLog":scaleType==="symlog"?"zoomSymlog":scaleType==="pow"?"zoomPow":"zoomLinear";const arg=!boundScales?"":scaleType==="pow"?`, ${(_scaleCmpt$get=scaleCmpt.get("exponent"))!==null&&_scaleCmpt$get!==void 0?_scaleCmpt$get:1}`:scaleType==="symlog"?`, ${(_scaleCmpt$get2=scaleCmpt.get("constant"))!==null&&_scaleCmpt$get2!==void 0?_scaleCmpt$get2:1}`:"";const update=`${zoomFn}(${base}, ${anchor}, ${delta}${arg})`;signal.on.push({events:{signal:delta},update:boundScales?update:`clampRange(${update}, 0, ${sizeSg})`})}const STORE="_store";const TUPLE="_tuple";const MODIFY="_modify";const SELECTION_DOMAIN="_selection_domain_";const VL_SELECTION_RESOLVE="vlSelectionResolve";const selectionCompilers=[selection_point,selection_interval,selection_project,selection_toggle,inputs,selection_scales,selection_legends,selection_clear,selection_translate,selection_zoom,selection_nearest];function getFacetModel(model){let parent=model.parent;while(parent){if(isFacetModel(parent))break;parent=parent.parent}return parent}function selection_unitName(model){let{escape:escape}=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{escape:true};let name=escape?Object(vega_util["stringValue"])(model.name):model.name;const facetModel=getFacetModel(model);if(facetModel){const{facet:facet}=facetModel;for(const channel of FACET_CHANNELS){if(facet[channel]){name+=` + '__facet_${channel}_' + (facet[${Object(vega_util["stringValue"])(facetModel.vgField(channel))}])`}}}return name}function requiresSelectionId(model){var _model$component$sele;return util_vals((_model$component$sele=model.component.selection)!==null&&_model$component$sele!==void 0?_model$component$sele:{}).reduce((identifier,selCmpt)=>identifier||selCmpt.project.hasSelectionId,false)}function disableDirectManipulation(selCmpt,selDef){if(Object(vega_node["isString"])(selDef.select)||!selDef.select.on)delete selCmpt.events;if(Object(vega_node["isString"])(selDef.select)||!selDef.select.clear)delete selCmpt.clear;if(Object(vega_node["isString"])(selDef.select)||!selDef.select.toggle)delete selCmpt.toggle}function isTimerSelection(selCmpt){var _selCmpt$events;return(_selCmpt$events=selCmpt.events)===null||_selCmpt$events===void 0?void 0:_selCmpt$events.find(e=>"type"in e&&e.type==="timer")}var vega_expression=__webpack_require__(108);function getName(node){const name=[];if(node.type==="Identifier"){return[node.name]}if(node.type==="Literal"){return[node.value]}if(node.type==="MemberExpression"){name.push(...getName(node.object));name.push(...getName(node.property))}return name}function startsWithDatum(node){if(node.object.type==="MemberExpression"){return startsWithDatum(node.object)}return node.object.name==="datum"}function getDependentFields(expression){const ast=Object(vega_expression["parseExpression"])(expression);const dependents=new Set;ast.visit(node=>{if(node.type==="MemberExpression"&&startsWithDatum(node)){dependents.add(getName(node).slice(1).join("."))}});return dependents}function filter_defineProperty(e,r,t){return(r=filter_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function filter_toPropertyKey(t){var i=filter_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function filter_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class filter_FilterNode extends dataflow_DataFlowNode{clone(){return new filter_FilterNode(null,this.model,duplicate(this.filter))}constructor(parent,model,filter){super(parent);this.model=model;this.filter=filter;filter_defineProperty(this,"expr",void 0);filter_defineProperty(this,"_dependentFields",void 0);this.expr=predicate_expression(this.model,this.filter,this);this._dependentFields=getDependentFields(this.expr)}dependentFields(){return this._dependentFields}producedFields(){return new Set}assemble(){return{type:"filter",expr:this.expr}}hash(){return`Filter ${this.expr}`}}function parseUnitSelection(model,selDefs){const selCmpts={};const selectionConfig=model.config.selection;if(!selDefs||!selDefs.length)return selCmpts;let nTimerSelections=0;for(const def of selDefs){const name=varName(def.name);const selDef=def.select;const type=Object(vega_util["isString"])(selDef)?selDef:selDef.type;const defaults=Object(vega_util["isObject"])(selDef)?duplicate(selDef):{type:type};const cfg=selectionConfig[type];for(const key in cfg){if(key==="fields"||key==="encodings"){continue}if(key==="mark"){defaults.mark={...cfg.mark,...defaults.mark}}if(defaults[key]===undefined||defaults[key]===true){var _key;defaults[key]=duplicate((_key=cfg[key])!==null&&_key!==void 0?_key:defaults[key])}}const selCmpt=selCmpts[name]={...defaults,name:name,type:type,init:def.value,bind:def.bind,events:Object(vega_util["isString"])(defaults.on)?Object(vega_event_selector["parseSelector"])(defaults.on,"scope"):Object(vega_util["array"])(duplicate(defaults.on))};if(isTimerSelection(selCmpt)){nTimerSelections++;if(nTimerSelections>1){delete selCmpts[name];continue}}const def_=duplicate(def);for(const c of selectionCompilers){if(c.defined(selCmpt)&&c.parse){c.parse(model,selCmpt,def_)}}}if(nTimerSelections>1){warn(MULTIPLE_TIMER_ANIMATION_SELECTION)}return selCmpts}function parseSelectionPredicate(model,pred,dfnode){let datum=arguments.length>3&&arguments[3]!==undefined?arguments[3]:"datum";const name=Object(vega_util["isString"])(pred)?pred:pred.param;const vname=varName(name);const store=Object(vega_util["stringValue"])(vname+STORE);let selCmpt;try{selCmpt=model.getSelectionComponent(vname,name)}catch(e){return`!!${vname}`}if(selCmpt.project.timeUnit){const child=dfnode!==null&&dfnode!==void 0?dfnode:model.component.data.raw;const tunode=selCmpt.project.timeUnit.clone();if(child.parent){tunode.insertAsParentOf(child)}else{child.parent=tunode}}const fn=selCmpt.project.hasSelectionId?"vlSelectionIdTest(":"vlSelectionTest(";const resolve=selCmpt.resolve==="global"?")":`, ${Object(vega_util["stringValue"])(selCmpt.resolve)})`;const test=`${fn}${store}, ${datum}${resolve}`;const length=`length(data(${store}))`;return pred.empty===false?`${length} && ${test}`:`!${length} || ${test}`}function parseSelectionExtent(model,name,extent){const vname=varName(name);const encoding=extent.encoding;let field=extent.field;let selCmpt;try{selCmpt=model.getSelectionComponent(vname,name)}catch(e){return vname}if(!encoding&&!field){field=selCmpt.project.items[0].field;if(selCmpt.project.items.length>1){warn(selectionAsScaleDomainWithoutField(field))}}else if(encoding&&!field){const encodings=selCmpt.project.items.filter(p=>p.channel===encoding);if(!encodings.length||encodings.length>1){field=selCmpt.project.items[0].field;warn(selectionAsScaleDomainWrongEncodings(encodings,encoding,extent,field))}else{field=encodings[0].field}}return`${selCmpt.name}[${Object(vega_util["stringValue"])(replacePathInField(field))}]`}function materializeSelections(model,main){for(const[selection,selCmpt]of entries((_model$component$sele=model.component.selection)!==null&&_model$component$sele!==void 0?_model$component$sele:{})){var _model$component$sele;const lookupName=model.getName(`lookup_${selection}`);model.component.data.outputNodes[lookupName]=selCmpt.materialized=new dataflow_OutputNode(new filter_FilterNode(main,model,{param:selection}),lookupName,DataSourceType.Lookup,model.component.data.outputNodeRefCounts)}}function predicate_expression(model,filterOp,node){return logicalExpr(filterOp,predicate=>{if(Object(vega_util["isString"])(predicate)){return predicate}else if(isSelectionPredicate(predicate)){return parseSelectionPredicate(model,predicate,node)}else{return fieldFilterExpression(predicate)}})}function assembleTitle(title,config){if(!title){return undefined}if(Object(vega_util["isArray"])(title)&&!isText(title)){return title.map(fieldDef=>defaultTitle(fieldDef,config)).join(", ")}return title}function setAxisEncode(axis,part,vgProp,vgRef){var _axis$encode,_axis$encode2,_axis$encode2$part,_axis$encode$part,_axis$encode$part$upd;(_axis$encode=axis.encode)!==null&&_axis$encode!==void 0?_axis$encode:axis.encode={};(_axis$encode2$part=(_axis$encode2=axis.encode)[part])!==null&&_axis$encode2$part!==void 0?_axis$encode2$part:_axis$encode2[part]={};(_axis$encode$part$upd=(_axis$encode$part=axis.encode[part]).update)!==null&&_axis$encode$part$upd!==void 0?_axis$encode$part$upd:_axis$encode$part.update={};axis.encode[part].update[vgProp]=vgRef}function assembleAxis(axisCmpt,kind,config){let opt=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{header:false};const{disable:disable,orient:orient,scale:scale,labelExpr:labelExpr,title:title,zindex:zindex,...axis}=axisCmpt.combine();if(disable){return undefined}for(const p in axis){const prop=p;const propType=AXIS_PROPERTY_TYPE[prop];const propValue=axis[prop];if(propType&&propType!==kind&&propType!=="both"){delete axis[prop]}else if(isConditionalAxisValue(propValue)){const{condition:condition,...valueOrSignalRef}=propValue;const conditions=Object(vega_util["array"])(condition);const propIndex=CONDITIONAL_AXIS_PROP_INDEX[prop];if(propIndex){const{vgProp:vgProp,part:part}=propIndex;const vgRef=[...conditions.map(c=>{const{test:test,...valueOrSignalCRef}=c;return{test:predicate_expression(null,test),...valueOrSignalCRef}}),valueOrSignalRef];setAxisEncode(axis,part,vgProp,vgRef);delete axis[prop]}else if(propIndex===null){const signalRef={signal:conditions.map(c=>{const{test:test,...valueOrSignalCRef}=c;return`${predicate_expression(null,test)} ? ${exprFromValueRefOrSignalRef(valueOrSignalCRef)} : `}).join("")+exprFromValueRefOrSignalRef(valueOrSignalRef)};axis[prop]=signalRef}}else if(isSignalRef(propValue)){const propIndex=CONDITIONAL_AXIS_PROP_INDEX[prop];if(propIndex){const{vgProp:vgProp,part:part}=propIndex;setAxisEncode(axis,part,vgProp,propValue);delete axis[prop]}}if(util_contains(["labelAlign","labelBaseline"],prop)&&axis[prop]===null){delete axis[prop]}}if(kind==="grid"){if(!axis.grid){return undefined}if(axis.encode){const{grid:grid}=axis.encode;axis.encode={...grid?{grid:grid}:{}};if(isEmpty(axis.encode)){delete axis.encode}}return{scale:scale,orient:orient,...axis,domain:false,labels:false,aria:false,maxExtent:0,minExtent:0,ticks:false,zindex:getFirstDefined(zindex,0)}}else{if(!opt.header&&axisCmpt.mainExtracted){return undefined}if(labelExpr!==undefined){var _axis$encode3;let expr=labelExpr;if((_axis$encode3=axis.encode)!==null&&_axis$encode3!==void 0&&(_axis$encode3=_axis$encode3.labels)!==null&&_axis$encode3!==void 0&&_axis$encode3.update&&isSignalRef(axis.encode.labels.update.text)){expr=replaceAll(labelExpr,"datum.label",axis.encode.labels.update.text.signal)}setAxisEncode(axis,"labels","text",{signal:expr})}if(axis.labelAlign===null){delete axis.labelAlign}if(axis.encode){for(const part of AXIS_PARTS){if(!axisCmpt.hasAxisPart(part)){delete axis.encode[part]}}if(isEmpty(axis.encode)){delete axis.encode}}const titleString=assembleTitle(title,config);return{scale:scale,orient:orient,grid:false,...titleString?{title:titleString}:{},...axis,...config.aria===false?{aria:false}:{},zindex:getFirstDefined(zindex,0)}}}function assembleAxisSignals(model){const{axes:axes}=model.component;const signals=[];for(const channel of POSITION_SCALE_CHANNELS){if(axes[channel]){for(const axis of axes[channel]){if(!axis.get("disable")&&!axis.get("gridScale")){const sizeType=channel==="x"?"height":"width";const update=model.getSizeSignalRef(sizeType).signal;if(sizeType!==update){signals.push({name:sizeType,update:update})}}}}}return signals}function assembleAxes(axisComponents,config){const{x:x=[],y:y=[]}=axisComponents;return[...x.map(a=>assembleAxis(a,"grid",config)),...y.map(a=>assembleAxis(a,"grid",config)),...x.map(a=>assembleAxis(a,"main",config)),...y.map(a=>assembleAxis(a,"main",config))].filter(a=>a)}function getAxisConfigFromConfigTypes(configTypes,config,channel,orient){return Object.assign.apply(null,[{},...configTypes.map(configType=>{if(configType==="axisOrient"){const orient1=channel==="x"?"bottom":"left";const orientConfig1=config[channel==="x"?"axisBottom":"axisLeft"]||{};const orientConfig2=config[channel==="x"?"axisTop":"axisRight"]||{};const props=new Set([...keys(orientConfig1),...keys(orientConfig2)]);const conditionalOrientAxisConfig={};for(const prop of props.values()){conditionalOrientAxisConfig[prop]={signal:`${orient["signal"]} === "${orient1}" ? ${signalOrStringValue(orientConfig1[prop])} : ${signalOrStringValue(orientConfig2[prop])}`}}return conditionalOrientAxisConfig}return config[configType]})])}function getAxisConfigs(channel,scaleType,orient,config){const typeBasedConfigTypes=scaleType==="band"?["axisDiscrete","axisBand"]:scaleType==="point"?["axisDiscrete","axisPoint"]:isQuantitative(scaleType)?["axisQuantitative"]:scaleType==="time"||scaleType==="utc"?["axisTemporal"]:[];const axisChannel=channel==="x"?"axisX":"axisY";const axisOrient=isSignalRef(orient)?"axisOrient":`axis${titleCase(orient)}`;const vlOnlyConfigTypes=[...typeBasedConfigTypes,...typeBasedConfigTypes.map(c=>axisChannel+c.substr(4))];const vgConfigTypes=["axis",axisOrient,axisChannel];return{vlOnlyAxisConfig:getAxisConfigFromConfigTypes(vlOnlyConfigTypes,config,channel,orient),vgAxisConfig:getAxisConfigFromConfigTypes(vgConfigTypes,config,channel,orient),axisConfigStyle:getAxisConfigStyle([...vgConfigTypes,...vlOnlyConfigTypes],config)}}function getAxisConfigStyle(axisConfigTypes,config){const toMerge=[{}];for(const configType of axisConfigTypes){var _configType;let style=(_configType=config[configType])===null||_configType===void 0?void 0:_configType.style;if(style){style=Object(vega_util["array"])(style);for(const s of style){toMerge.push(config.style[s])}}}return Object.assign.apply(null,toMerge)}function getAxisConfig(property,styleConfigIndex,style){let axisConfigs=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};const styleConfig=getStyleConfig(property,style,styleConfigIndex);if(styleConfig!==undefined){return{configFrom:"style",configValue:styleConfig}}for(const configFrom of["vlOnlyAxisConfig","vgAxisConfig","axisConfigStyle"]){var _axisConfigs$configFr;if(((_axisConfigs$configFr=axisConfigs[configFrom])===null||_axisConfigs$configFr===void 0?void 0:_axisConfigs$configFr[property])!==undefined){return{configFrom:configFrom,configValue:axisConfigs[configFrom][property]}}}return{}}const axisRules={scale:_ref=>{let{model:model,channel:channel}=_ref;return model.scaleName(channel)},format:_ref2=>{let{format:format}=_ref2;return format},formatType:_ref3=>{let{formatType:formatType}=_ref3;return formatType},grid:_ref4=>{var _axis$grid;let{fieldOrDatumDef:fieldOrDatumDef,axis:axis,scaleType:scaleType}=_ref4;return(_axis$grid=axis.grid)!==null&&_axis$grid!==void 0?_axis$grid:defaultGrid(scaleType,fieldOrDatumDef)},gridScale:_ref5=>{let{model:model,channel:channel}=_ref5;return gridScale(model,channel)},labelAlign:_ref6=>{let{axis:axis,labelAngle:labelAngle,orient:orient,channel:channel}=_ref6;return axis.labelAlign||defaultLabelAlign(labelAngle,orient,channel)},labelAngle:_ref7=>{let{labelAngle:labelAngle}=_ref7;return labelAngle},labelBaseline:_ref8=>{let{axis:axis,labelAngle:labelAngle,orient:orient,channel:channel}=_ref8;return axis.labelBaseline||defaultLabelBaseline(labelAngle,orient,channel)},labelFlush:_ref9=>{var _axis$labelFlush;let{axis:axis,fieldOrDatumDef:fieldOrDatumDef,channel:channel}=_ref9;return(_axis$labelFlush=axis.labelFlush)!==null&&_axis$labelFlush!==void 0?_axis$labelFlush:defaultLabelFlush(fieldOrDatumDef.type,channel)},labelOverlap:_ref10=>{var _axis$labelOverlap;let{axis:axis,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType}=_ref10;return(_axis$labelOverlap=axis.labelOverlap)!==null&&_axis$labelOverlap!==void 0?_axis$labelOverlap:defaultLabelOverlap(fieldOrDatumDef.type,scaleType,isFieldDef(fieldOrDatumDef)&&!!fieldOrDatumDef.timeUnit,isFieldDef(fieldOrDatumDef)?fieldOrDatumDef.sort:undefined)},orient:_ref11=>{let{orient:orient}=_ref11;return orient},tickCount:_ref12=>{var _axis$tickCount;let{channel:channel,model:model,axis:axis,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType}=_ref12;const sizeType=channel==="x"?"width":channel==="y"?"height":undefined;const size=sizeType?model.getSizeSignalRef(sizeType):undefined;return(_axis$tickCount=axis.tickCount)!==null&&_axis$tickCount!==void 0?_axis$tickCount:defaultTickCount({fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,size:size,values:axis.values})},tickMinStep:defaultTickMinStep,title:_ref13=>{let{axis:axis,model:model,channel:channel}=_ref13;if(axis.title!==undefined){return axis.title}const fieldDefTitle=getFieldDefTitle(model,channel);if(fieldDefTitle!==undefined){return fieldDefTitle}const fieldDef=model.typedFieldDef(channel);const channel2=channel==="x"?"x2":"y2";const fieldDef2=model.fieldDef(channel2);return mergeTitleFieldDefs(fieldDef?[toFieldDefBase(fieldDef)]:[],isFieldDef(fieldDef2)?[toFieldDefBase(fieldDef2)]:[])},values:_ref14=>{let{axis:axis,fieldOrDatumDef:fieldOrDatumDef}=_ref14;return properties_values(axis,fieldOrDatumDef)},zindex:_ref15=>{var _axis$zindex;let{axis:axis,fieldOrDatumDef:fieldOrDatumDef,mark:mark}=_ref15;return(_axis$zindex=axis.zindex)!==null&&_axis$zindex!==void 0?_axis$zindex:defaultZindex(mark,fieldOrDatumDef)}};function defaultGrid(scaleType,fieldDef){return!hasDiscreteDomain(scaleType)&&isFieldDef(fieldDef)&&!isBinning(fieldDef===null||fieldDef===void 0?void 0:fieldDef.bin)&&!isBinned(fieldDef===null||fieldDef===void 0?void 0:fieldDef.bin)}function gridScale(model,channel){const gridChannel=channel==="x"?"y":"x";if(model.getScaleComponent(gridChannel)){return model.scaleName(gridChannel)}return undefined}function getLabelAngle(fieldOrDatumDef,axis,channel,styleConfig,axisConfigs){const labelAngle=axis===null||axis===void 0?void 0:axis.labelAngle;if(labelAngle!==undefined){return isSignalRef(labelAngle)?labelAngle:normalizeAngle(labelAngle)}else{const{configValue:angle}=getAxisConfig("labelAngle",styleConfig,axis===null||axis===void 0?void 0:axis.style,axisConfigs);if(angle!==undefined){return normalizeAngle(angle)}else{if(channel===X&&util_contains([NOMINAL,ORDINAL],fieldOrDatumDef.type)&&!(isFieldDef(fieldOrDatumDef)&&fieldOrDatumDef.timeUnit)){return 270}return undefined}}}function normalizeAngleExpr(angle){return`(((${angle.signal} % 360) + 360) % 360)`}function defaultLabelBaseline(angle,orient,channel,alwaysIncludeMiddle){if(angle!==undefined){if(channel==="x"){if(isSignalRef(angle)){const a=normalizeAngleExpr(angle);const orientIsTop=isSignalRef(orient)?`(${orient.signal} === "top")`:orient==="top";return{signal:`(45 < ${a} && ${a} < 135) || (225 < ${a} && ${a} < 315) ? "middle" :`+`(${a} <= 45 || 315 <= ${a}) === ${orientIsTop} ? "bottom" : "top"`}}if(45<angle&&angle<135||225<angle&&angle<315){return"middle"}if(isSignalRef(orient)){const op=angle<=45||315<=angle?"===":"!==";return{signal:`${orient.signal} ${op} "top" ? "bottom" : "top"`}}return(angle<=45||315<=angle)===(orient==="top")?"bottom":"top"}else{if(isSignalRef(angle)){const a=normalizeAngleExpr(angle);const orientIsLeft=isSignalRef(orient)?`(${orient.signal} === "left")`:orient==="left";const middle=alwaysIncludeMiddle?'"middle"':"null";return{signal:`${a} <= 45 || 315 <= ${a} || (135 <= ${a} && ${a} <= 225) ? ${middle} : (45 <= ${a} && ${a} <= 135) === ${orientIsLeft} ? "top" : "bottom"`}}if(angle<=45||315<=angle||135<=angle&&angle<=225){return alwaysIncludeMiddle?"middle":null}if(isSignalRef(orient)){const op=45<=angle&&angle<=135?"===":"!==";return{signal:`${orient.signal} ${op} "left" ? "top" : "bottom"`}}return(45<=angle&&angle<=135)===(orient==="left")?"top":"bottom"}}return undefined}function defaultLabelAlign(angle,orient,channel){if(angle===undefined){return undefined}const isX=channel==="x";const startAngle=isX?0:90;const mainOrient=isX?"bottom":"left";if(isSignalRef(angle)){const a=normalizeAngleExpr(angle);const orientIsMain=isSignalRef(orient)?`(${orient.signal} === "${mainOrient}")`:orient===mainOrient;return{signal:`(${startAngle?`(${a} + 90)`:a} % 180 === 0) ? ${isX?null:'"center"'} :`+`(${startAngle} < ${a} && ${a} < ${180+startAngle}) === ${orientIsMain} ? "left" : "right"`}}if((angle+startAngle)%180===0){return isX?null:"center"}if(isSignalRef(orient)){const op=startAngle<angle&&angle<180+startAngle?"===":"!==";const orientIsMain=`${orient.signal} ${op} "${mainOrient}"`;return{signal:`${orientIsMain} ? "left" : "right"`}}if((startAngle<angle&&angle<180+startAngle)===(orient===mainOrient)){return"left"}return"right"}function defaultLabelFlush(type,channel){if(channel==="x"&&util_contains(["quantitative","temporal"],type)){return true}return undefined}function defaultLabelOverlap(type,scaleType,hasTimeUnit,sort){if(hasTimeUnit&&!Object(vega_util["isObject"])(sort)||type!=="nominal"&&type!=="ordinal"){if(scaleType==="log"||scaleType==="symlog"){return"greedy"}return true}return undefined}function defaultOrient(channel){return channel==="x"?"bottom":"left"}function defaultTickCount(_ref16){let{fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,size:size,values:vals}=_ref16;if(!vals&&!hasDiscreteDomain(scaleType)&&scaleType!=="log"){if(isFieldDef(fieldOrDatumDef)){var _normalizeTimeUnit;if(isBinning(fieldOrDatumDef.bin)){return{signal:`ceil(${size.signal}/10)`}}if(fieldOrDatumDef.timeUnit&&util_contains(["month","hours","day","quarter"],(_normalizeTimeUnit=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit)){return undefined}}return{signal:`ceil(${size.signal}/40)`}}return undefined}function defaultTickMinStep(_ref17){let{format:format,fieldOrDatumDef:fieldOrDatumDef}=_ref17;if(format==="d"){return 1}if(isFieldDef(fieldOrDatumDef)){const{timeUnit:timeUnit}=fieldOrDatumDef;if(timeUnit){const signal=durationExpr(timeUnit);if(signal){return{signal:signal}}}}return undefined}function getFieldDefTitle(model,channel){const channel2=channel==="x"?"x2":"y2";const fieldDef=model.fieldDef(channel);const fieldDef2=model.fieldDef(channel2);const title1=fieldDef?fieldDef.title:undefined;const title2=fieldDef2?fieldDef2.title:undefined;if(title1&&title2){return mergeTitle(title1,title2)}else if(title1){return title1}else if(title2){return title2}else if(title1!==undefined){return title1}else if(title2!==undefined){return title2}return undefined}function properties_values(axis,fieldOrDatumDef){const vals=axis.values;if(Object(vega_util["isArray"])(vals)){return valueArray(fieldOrDatumDef,vals)}else if(isSignalRef(vals)){return vals}return undefined}function defaultZindex(mark,fieldDef){if(mark==="rect"&&channeldef_isDiscrete(fieldDef)){return 1}return 0}function calculate_defineProperty(e,r,t){return(r=calculate_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function calculate_toPropertyKey(t){var i=calculate_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function calculate_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class calculate_CalculateNode extends dataflow_DataFlowNode{clone(){return new calculate_CalculateNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform;calculate_defineProperty(this,"_dependentFields",void 0);this._dependentFields=getDependentFields(this.transform.calculate)}static parseAllForSortIndex(parent,model){model.forEachFieldDef((fieldDef,channel)=>{if(!isScaleFieldDef(fieldDef)){return}if(isSortArray(fieldDef.sort)){const{field:field,timeUnit:timeUnit}=fieldDef;const sort=fieldDef.sort;const calculate=sort.map((sortValue,i)=>`${fieldFilterExpression({field:field,timeUnit:timeUnit,equal:sortValue})} ? ${i} : `).join("")+sort.length;parent=new calculate_CalculateNode(parent,{calculate:calculate,as:sortArrayIndexField(fieldDef,channel,{forAs:true})})}});return parent}producedFields(){return new Set([this.transform.as])}dependentFields(){return this._dependentFields}assemble(){return{type:"formula",expr:this.transform.calculate,as:this.transform.as}}hash(){return`Calculate ${hash(this.transform)}`}}function sortArrayIndexField(fieldDef,channel,opt){return vgField(fieldDef,{prefix:channel,suffix:"sort_index",...opt})}function getHeaderChannel(channel,orient){if(util_contains(["top","bottom"],orient)){return"column"}else if(util_contains(["left","right"],orient)){return"row"}return channel==="row"?"row":"column"}function getHeaderProperty(prop,header,config,channel){const headerSpecificConfig=channel==="row"?config.headerRow:channel==="column"?config.headerColumn:config.headerFacet;return getFirstDefined((header||{})[prop],headerSpecificConfig[prop],config.header[prop])}function getHeaderProperties(properties,header,config,channel){const props={};for(const prop of properties){const value=getHeaderProperty(prop,header||{},config,channel);if(value!==undefined){props[prop]=value}}return props}const HEADER_CHANNELS=["row","column"];const HEADER_TYPES=["header","footer"];function assembleTitleGroup(model,channel){const title=model.component.layoutHeaders[channel].title;const config=model.config?model.config:undefined;const facetFieldDef=model.component.layoutHeaders[channel].facetFieldDef?model.component.layoutHeaders[channel].facetFieldDef:undefined;const{titleAnchor:titleAnchor,titleAngle:ta,titleOrient:titleOrient}=getHeaderProperties(["titleAnchor","titleAngle","titleOrient"],facetFieldDef.header,config,channel);const headerChannel=getHeaderChannel(channel,titleOrient);const titleAngle=normalizeAngle(ta);return{name:`${channel}-title`,type:"group",role:`${headerChannel}-title`,title:{text:title,...channel==="row"?{orient:"left"}:{},style:"guide-title",...defaultHeaderGuideBaseline(titleAngle,headerChannel),...defaultHeaderGuideAlign(headerChannel,titleAngle,titleAnchor),...assembleHeaderProperties(config,facetFieldDef,channel,HEADER_TITLE_PROPERTIES,HEADER_TITLE_PROPERTIES_MAP)}}}function defaultHeaderGuideAlign(headerChannel,angle){let anchor=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"middle";switch(anchor){case"start":return{align:"left"};case"end":return{align:"right"}}const align=defaultLabelAlign(angle,headerChannel==="row"?"left":"top",headerChannel==="row"?"y":"x");return align?{align:align}:{}}function defaultHeaderGuideBaseline(angle,channel){const baseline=defaultLabelBaseline(angle,channel==="row"?"left":"top",channel==="row"?"y":"x",true);return baseline?{baseline:baseline}:{}}function assembleHeaderGroups(model,channel){const layoutHeader=model.component.layoutHeaders[channel];const groups=[];for(const headerType of HEADER_TYPES){if(layoutHeader[headerType]){for(const headerComponent of layoutHeader[headerType]){const group=assembleHeaderGroup(model,channel,headerType,layoutHeader,headerComponent);if(group!=null){groups.push(group)}}}}return groups}function getSort(facetFieldDef,channel){const{sort:sort}=facetFieldDef;if(isSortField(sort)){var _sort$order;return{field:vgField(sort,{expr:"datum"}),order:(_sort$order=sort.order)!==null&&_sort$order!==void 0?_sort$order:"ascending"}}else if(Object(vega_util["isArray"])(sort)){return{field:sortArrayIndexField(facetFieldDef,channel,{expr:"datum"}),order:"ascending"}}else{return{field:vgField(facetFieldDef,{expr:"datum"}),order:sort!==null&&sort!==void 0?sort:"ascending"}}}function assembleLabelTitle(facetFieldDef,channel,config){const{format:format,formatType:formatType,labelAngle:labelAngle,labelAnchor:labelAnchor,labelOrient:labelOrient,labelExpr:labelExpr}=getHeaderProperties(["format","formatType","labelAngle","labelAnchor","labelOrient","labelExpr"],facetFieldDef.header,config,channel);const titleTextExpr=formatSignalRef({fieldOrDatumDef:facetFieldDef,format:format,formatType:formatType,expr:"parent",config:config}).signal;const headerChannel=getHeaderChannel(channel,labelOrient);return{text:{signal:labelExpr?replaceAll(replaceAll(labelExpr,"datum.label",titleTextExpr),"datum.value",vgField(facetFieldDef,{expr:"parent"})):titleTextExpr},...channel==="row"?{orient:"left"}:{},style:"guide-label",frame:"group",...defaultHeaderGuideBaseline(labelAngle,headerChannel),...defaultHeaderGuideAlign(headerChannel,labelAngle,labelAnchor),...assembleHeaderProperties(config,facetFieldDef,channel,HEADER_LABEL_PROPERTIES,HEADER_LABEL_PROPERTIES_MAP)}}function assembleHeaderGroup(model,channel,headerType,layoutHeader,headerComponent){if(headerComponent){let title=null;const{facetFieldDef:facetFieldDef}=layoutHeader;const config=model.config?model.config:undefined;if(facetFieldDef&&headerComponent.labels){const{labelOrient:labelOrient}=getHeaderProperties(["labelOrient"],facetFieldDef.header,config,channel);if(channel==="row"&&!util_contains(["top","bottom"],labelOrient)||channel==="column"&&!util_contains(["left","right"],labelOrient)){title=assembleLabelTitle(facetFieldDef,channel,config)}}const isFacetWithoutRowCol=isFacetModel(model)&&!isFacetMapping(model.facet);const axes=headerComponent.axes;const hasAxes=(axes===null||axes===void 0?void 0:axes.length)>0;if(title||hasAxes){const sizeChannel=channel==="row"?"height":"width";return{name:model.getName(`${channel}_${headerType}`),type:"group",role:`${channel}-${headerType}`,...layoutHeader.facetFieldDef?{from:{data:model.getName(`${channel}_domain`)},sort:getSort(facetFieldDef,channel)}:{},...hasAxes&&isFacetWithoutRowCol?{from:{data:model.getName(`facet_domain_${channel}`)}}:{},...title?{title:title}:{},...headerComponent.sizeSignal?{encode:{update:{[sizeChannel]:headerComponent.sizeSignal}}}:{},...hasAxes?{axes:axes}:{}}}}return null}const LAYOUT_TITLE_BAND={column:{start:0,end:1},row:{start:1,end:0}};function getLayoutTitleBand(titleAnchor,headerChannel){return LAYOUT_TITLE_BAND[headerChannel][titleAnchor]}function assembleLayoutTitleBand(headerComponentIndex,config){const titleBand={};for(const channel of FACET_CHANNELS){const headerComponent=headerComponentIndex[channel];if(headerComponent!==null&&headerComponent!==void 0&&headerComponent.facetFieldDef){const{titleAnchor:titleAnchor,titleOrient:titleOrient}=getHeaderProperties(["titleAnchor","titleOrient"],headerComponent.facetFieldDef.header,config,channel);const headerChannel=getHeaderChannel(channel,titleOrient);const band=getLayoutTitleBand(titleAnchor,headerChannel);if(band!==undefined){titleBand[headerChannel]=band}}}return isEmpty(titleBand)?undefined:titleBand}function assembleHeaderProperties(config,facetFieldDef,channel,properties,propertiesMap){const props={};for(const prop of properties){if(!propertiesMap[prop]){continue}const value=getHeaderProperty(prop,facetFieldDef===null||facetFieldDef===void 0?void 0:facetFieldDef.header,config,channel);if(value!==undefined){props[propertiesMap[prop]]=value}}return props}function assembleLayoutSignals(model){return[...sizeSignals(model,"width"),...sizeSignals(model,"height"),...sizeSignals(model,"childWidth"),...sizeSignals(model,"childHeight")]}function sizeSignals(model,sizeType){const channel=sizeType==="width"?"x":"y";const size=model.component.layoutSize.get(sizeType);if(!size||size==="merged"){return[]}const name=model.getSizeSignalRef(sizeType).signal;if(size==="step"){const scaleComponent=model.getScaleComponent(channel);if(scaleComponent){const type=scaleComponent.get("type");const range=scaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const scaleName=model.scaleName(channel);if(isFacetModel(model.parent)){const parentResolve=model.parent.component.resolve;if(parentResolve.scale[channel]==="independent"){return[stepSignal(scaleName,range)]}}return[stepSignal(scaleName,range),{name:name,update:sizeExpr(scaleName,scaleComponent,`domain('${scaleName}').length`)}]}}throw new Error("layout size is step although width/height is not step.")}else if(size=="container"){const isWidth=name.endsWith("width");const expr=isWidth?"containerSize()[0]":"containerSize()[1]";const defaultValue=getViewConfigContinuousSize(model.config.view,isWidth?"width":"height");const safeExpr=`isFinite(${expr}) ? ${expr} : ${defaultValue}`;return[{name:name,init:safeExpr,on:[{update:safeExpr,events:"window:resize"}]}]}else{return[{name:name,value:size}]}}function stepSignal(scaleName,range){const name=`${scaleName}_step`;if(isSignalRef(range.step)){return{name:name,update:range.step.signal}}else{return{name:name,value:range.step}}}function sizeExpr(scaleName,scaleComponent,cardinality){const type=scaleComponent.get("type");const padding=scaleComponent.get("padding");const paddingOuter=getFirstDefined(scaleComponent.get("paddingOuter"),padding);let paddingInner=scaleComponent.get("paddingInner");paddingInner=type==="band"?paddingInner!==undefined?paddingInner:padding:1;return`bandspace(${cardinality}, ${signalOrStringValue(paddingInner)}, ${signalOrStringValue(paddingOuter)}) * ${scaleName}_step`}function getSizeTypeFromLayoutSizeType(layoutSizeType){return layoutSizeType==="childWidth"?"width":layoutSizeType==="childHeight"?"height":layoutSizeType}function guideEncodeEntry(encoding,model){return keys(encoding).reduce((encode,channel)=>({...encode,...wrapCondition({model:model,channelDef:encoding[channel],vgChannel:channel,mainRefFn:def=>signalOrValueRef(def.value),invalidValueRef:undefined})}),{})}function defaultScaleResolve(channel,model){if(isFacetModel(model)){return channel==="theta"?"independent":"shared"}else if(isLayerModel(model)){return"shared"}else if(isConcatModel(model)){return isXorY(channel)||channel==="theta"||channel==="radius"?"independent":"shared"}throw new Error("invalid model type for resolve")}function parseGuideResolve(resolve,channel){const channelScaleResolve=resolve.scale[channel];const guide=isXorY(channel)?"axis":"legend";if(channelScaleResolve==="independent"){if(resolve[guide][channel]==="shared"){warn(message_namespaceObject.independentScaleMeansIndependentGuide(channel))}return"independent"}return resolve[guide][channel]||"shared"}const LEGEND_COMPONENT_PROPERTY_INDEX={...COMMON_LEGEND_PROPERTY_INDEX,disable:1,labelExpr:1,selections:1,opacity:1,shape:1,stroke:1,fill:1,size:1,strokeWidth:1,strokeDash:1,encode:1};const LEGEND_COMPONENT_PROPERTIES=keys(LEGEND_COMPONENT_PROPERTY_INDEX);class component_LegendComponent extends split_Split{}const legendEncodeRules={symbols:symbols,gradient:gradient,labels:encode_labels,entries:encode_entries};function symbols(symbolsSpec,_ref){var _legendCmpt$get,_legendCmpt$get2,_legendCmpt$get3,_getMaxValue;let{fieldOrDatumDef:fieldOrDatumDef,model:model,channel:channel,legendCmpt:legendCmpt,legendType:legendType}=_ref;if(legendType!=="symbol"){return undefined}const{markDef:markDef,encoding:encoding,config:config,mark:mark}=model;const filled=markDef.filled&&mark!=="trail";let out={...applyMarkConfig({},model,FILL_STROKE_CONFIG),...color_color(model,{filled:filled})};const symbolOpacity=(_legendCmpt$get=legendCmpt.get("symbolOpacity"))!==null&&_legendCmpt$get!==void 0?_legendCmpt$get:config.legend.symbolOpacity;const symbolFillColor=(_legendCmpt$get2=legendCmpt.get("symbolFillColor"))!==null&&_legendCmpt$get2!==void 0?_legendCmpt$get2:config.legend.symbolFillColor;const symbolStrokeColor=(_legendCmpt$get3=legendCmpt.get("symbolStrokeColor"))!==null&&_legendCmpt$get3!==void 0?_legendCmpt$get3:config.legend.symbolStrokeColor;const opacity=symbolOpacity===undefined?(_getMaxValue=getMaxValue(encoding.opacity))!==null&&_getMaxValue!==void 0?_getMaxValue:markDef.opacity:undefined;if(out.fill){if(channel==="fill"||filled&&channel===COLOR){delete out.fill}else if(hasProperty(out.fill,"field")){if(symbolFillColor){delete out.fill}else{var _config$legend$symbol;out.fill=signalOrValueRef((_config$legend$symbol=config.legend.symbolBaseFillColor)!==null&&_config$legend$symbol!==void 0?_config$legend$symbol:"black");out.fillOpacity=signalOrValueRef(opacity!==null&&opacity!==void 0?opacity:1)}}else if(Object(vega_util["isArray"])(out.fill)){var _ref2,_getFirstConditionVal,_encoding$fill;const fill=(_ref2=(_getFirstConditionVal=getFirstConditionValue((_encoding$fill=encoding.fill)!==null&&_encoding$fill!==void 0?_encoding$fill:encoding.color))!==null&&_getFirstConditionVal!==void 0?_getFirstConditionVal:markDef.fill)!==null&&_ref2!==void 0?_ref2:filled&&markDef.color;if(fill){out.fill=signalOrValueRef(fill)}}}if(out.stroke){if(channel==="stroke"||!filled&&channel===COLOR){delete out.stroke}else if(hasProperty(out.stroke,"field")||symbolStrokeColor){delete out.stroke}else if(Object(vega_util["isArray"])(out.stroke)){const stroke=getFirstDefined(getFirstConditionValue(encoding.stroke||encoding.color),markDef.stroke,filled?markDef.color:undefined);if(stroke){out.stroke={value:stroke}}}}if(channel!==OPACITY){const condition=isFieldDef(fieldOrDatumDef)&&selectedCondition(model,legendCmpt,fieldOrDatumDef);if(condition){out.opacity=[{test:condition,...signalOrValueRef(opacity!==null&&opacity!==void 0?opacity:1)},signalOrValueRef(config.legend.unselectedOpacity)]}else if(opacity){out.opacity=signalOrValueRef(opacity)}}out={...out,...symbolsSpec};return isEmpty(out)?undefined:out}function gradient(gradientSpec,_ref3){var _legendCmpt$get4;let{model:model,legendType:legendType,legendCmpt:legendCmpt}=_ref3;if(legendType!=="gradient"){return undefined}const{config:config,markDef:markDef,encoding:encoding}=model;let out={};const gradientOpacity=(_legendCmpt$get4=legendCmpt.get("gradientOpacity"))!==null&&_legendCmpt$get4!==void 0?_legendCmpt$get4:config.legend.gradientOpacity;const opacity=gradientOpacity===undefined?getMaxValue(encoding.opacity)||markDef.opacity:undefined;if(opacity){out.opacity=signalOrValueRef(opacity)}out={...out,...gradientSpec};return isEmpty(out)?undefined:out}function encode_labels(specifiedlabelsSpec,_ref4){let{fieldOrDatumDef:fieldOrDatumDef,model:model,channel:channel,legendCmpt:legendCmpt}=_ref4;const legend=model.legend(channel)||{};const config=model.config;const condition=isFieldDef(fieldOrDatumDef)?selectedCondition(model,legendCmpt,fieldOrDatumDef):undefined;const opacity=condition?[{test:condition,value:1},{value:config.legend.unselectedOpacity}]:undefined;const{format:format,formatType:formatType}=legend;let text=undefined;if(isCustomFormatType(formatType)){text=formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:format,formatType:formatType,config:config})}else if(format===undefined&&formatType===undefined&&config.customFormatTypes){if(fieldOrDatumDef.type==="quantitative"&&config.numberFormatType){text=formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:config.numberFormat,formatType:config.numberFormatType,config:config})}else if(fieldOrDatumDef.type==="temporal"&&config.timeFormatType&&isFieldDef(fieldOrDatumDef)&&fieldOrDatumDef.timeUnit===undefined){text=formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:config.timeFormat,formatType:config.timeFormatType,config:config})}}const labelsSpec={...opacity?{opacity:opacity}:{},...text?{text:text}:{},...specifiedlabelsSpec};return isEmpty(labelsSpec)?undefined:labelsSpec}function encode_entries(entriesSpec,_ref5){let{legendCmpt:legendCmpt}=_ref5;const selections=legendCmpt.get("selections");return selections!==null&&selections!==void 0&&selections.length?{...entriesSpec,fill:{value:"transparent"}}:entriesSpec}function getMaxValue(channelDef){return getConditionValue(channelDef,(v,conditionalDef)=>Math.max(v,conditionalDef.value))}function getFirstConditionValue(channelDef){return getConditionValue(channelDef,(v,conditionalDef)=>getFirstDefined(v,conditionalDef.value))}function getConditionValue(channelDef,reducer){if(hasConditionalValueDef(channelDef)){return Object(vega_util["array"])(channelDef.condition).reduce(reducer,channelDef.value)}else if(isValueDef(channelDef)){return channelDef.value}return undefined}function selectedCondition(model,legendCmpt,fieldDef){const selections=legendCmpt.get("selections");if(!(selections!==null&&selections!==void 0&&selections.length))return undefined;const field=Object(vega_util["stringValue"])(fieldDef.field);return selections.map(name=>{const store=Object(vega_util["stringValue"])(varName(name)+STORE);return`(!length(data(${store})) || (${name}[${field}] && indexof(${name}[${field}], datum.value) >= 0))`}).join(" || ")}const legendRules={direction:_ref=>{let{direction:direction}=_ref;return direction},format:_ref2=>{let{fieldOrDatumDef:fieldOrDatumDef,legend:legend,config:config}=_ref2;const{format:format,formatType:formatType}=legend;return guideFormat(fieldOrDatumDef,fieldOrDatumDef.type,format,formatType,config,false)},formatType:_ref3=>{let{legend:legend,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType}=_ref3;const{formatType:formatType}=legend;return guideFormatType(formatType,fieldOrDatumDef,scaleType)},gradientLength:params=>{var _ref4,_legend$gradientLengt;const{legend:legend,legendConfig:legendConfig}=params;return(_ref4=(_legend$gradientLengt=legend.gradientLength)!==null&&_legend$gradientLengt!==void 0?_legend$gradientLengt:legendConfig.gradientLength)!==null&&_ref4!==void 0?_ref4:defaultGradientLength(params)},labelOverlap:_ref5=>{var _ref6,_legend$labelOverlap;let{legend:legend,legendConfig:legendConfig,scaleType:scaleType}=_ref5;return(_ref6=(_legend$labelOverlap=legend.labelOverlap)!==null&&_legend$labelOverlap!==void 0?_legend$labelOverlap:legendConfig.labelOverlap)!==null&&_ref6!==void 0?_ref6:properties_defaultLabelOverlap(scaleType)},symbolType:_ref7=>{var _legend$symbolType;let{legend:legend,markDef:markDef,channel:channel,encoding:encoding}=_ref7;return(_legend$symbolType=legend.symbolType)!==null&&_legend$symbolType!==void 0?_legend$symbolType:defaultSymbolType(markDef.type,channel,encoding.shape,markDef.shape)},title:_ref8=>{let{fieldOrDatumDef:fieldOrDatumDef,config:config}=_ref8;return channeldef_title(fieldOrDatumDef,config,{allowDisabling:true})},type:_ref9=>{let{legendType:legendType,scaleType:scaleType,channel:channel}=_ref9;if(isColorChannel(channel)&&isContinuousToContinuous(scaleType)){if(legendType==="gradient"){return undefined}}else if(legendType==="symbol"){return undefined}return legendType},values:_ref10=>{let{fieldOrDatumDef:fieldOrDatumDef,legend:legend}=_ref10;return legend_properties_values(legend,fieldOrDatumDef)}};function legend_properties_values(legend,fieldOrDatumDef){const vals=legend.values;if(Object(vega_util["isArray"])(vals)){return valueArray(fieldOrDatumDef,vals)}else if(isSignalRef(vals)){return vals}return undefined}function defaultSymbolType(mark,channel,shapeChannelDef,markShape){if(channel!=="shape"){var _getFirstConditionVal;const shape=(_getFirstConditionVal=getFirstConditionValue(shapeChannelDef))!==null&&_getFirstConditionVal!==void 0?_getFirstConditionVal:markShape;if(shape){return shape}}switch(mark){case"bar":case"rect":case"image":case"square":return"square";case"line":case"trail":case"rule":return"stroke";case"arc":case"point":case"circle":case"tick":case"geoshape":case"area":case"text":return"circle"}}function clipHeight(legendType){if(legendType==="gradient"){return 20}return undefined}function getLegendType(params){const{legend:legend}=params;return getFirstDefined(legend.type,properties_defaultType(params))}function properties_defaultType(_ref11){let{channel:channel,timeUnit:timeUnit,scaleType:scaleType}=_ref11;if(isColorChannel(channel)){if(util_contains(["quarter","month","day"],timeUnit)){return"symbol"}if(isContinuousToContinuous(scaleType)){return"gradient"}}return"symbol"}function getDirection(_ref12){var _ref13,_legend$direction;let{legendConfig:legendConfig,legendType:legendType,orient:orient,legend:legend}=_ref12;return(_ref13=(_legend$direction=legend.direction)!==null&&_legend$direction!==void 0?_legend$direction:legendConfig[legendType?"gradientDirection":"symbolDirection"])!==null&&_ref13!==void 0?_ref13:defaultDirection(orient,legendType)}function defaultDirection(orient,legendType){switch(orient){case"top":case"bottom":return"horizontal";case"left":case"right":case"none":case undefined:return undefined;default:return legendType==="gradient"?"horizontal":undefined}}function defaultGradientLength(_ref14){let{legendConfig:legendConfig,model:model,direction:direction,orient:orient,scaleType:scaleType}=_ref14;const{gradientHorizontalMaxLength:gradientHorizontalMaxLength,gradientHorizontalMinLength:gradientHorizontalMinLength,gradientVerticalMaxLength:gradientVerticalMaxLength,gradientVerticalMinLength:gradientVerticalMinLength}=legendConfig;if(isContinuousToContinuous(scaleType)){if(direction==="horizontal"){if(orient==="top"||orient==="bottom"){return gradientLengthSignal(model,"width",gradientHorizontalMinLength,gradientHorizontalMaxLength)}else{return gradientHorizontalMinLength}}else{return gradientLengthSignal(model,"height",gradientVerticalMinLength,gradientVerticalMaxLength)}}return undefined}function gradientLengthSignal(model,sizeType,min,max){const sizeSignal=model.getSizeSignalRef(sizeType).signal;return{signal:`clamp(${sizeSignal}, ${min}, ${max})`}}function properties_defaultLabelOverlap(scaleType){if(util_contains(["quantile","threshold","log","symlog"],scaleType)){return"greedy"}return undefined}function parseLegend(model){const legendComponent=isUnitModel(model)?parseUnitLegend(model):parseNonUnitLegend(model);model.component.legends=legendComponent;return legendComponent}function parseUnitLegend(model){const{encoding:encoding}=model;const legendComponent={};for(const channel of[COLOR,...LEGEND_SCALE_CHANNELS]){const def=getFieldOrDatumDef(encoding[channel]);if(!def||!model.getScaleComponent(channel)){continue}if(channel===SHAPE&&isFieldDef(def)&&def.type===GEOJSON){continue}legendComponent[channel]=parseLegendForChannel(model,channel)}return legendComponent}function getLegendDefWithScale(model,channel){const scale=model.scaleName(channel);if(model.mark==="trail"){if(channel==="color"){return{stroke:scale}}else if(channel==="size"){return{strokeWidth:scale}}}if(channel==="color"){return model.markDef.filled?{fill:scale}:{stroke:scale}}return{[channel]:scale}}function isExplicit(value,property,legend,fieldDef){switch(property){case"disable":return legend!==undefined;case"values":return!!(legend!==null&&legend!==void 0&&legend.values);case"title":if(property==="title"&&value===(fieldDef===null||fieldDef===void 0?void 0:fieldDef.title)){return true}}return value===(legend||{})[property]}function parseLegendForChannel(model,channel){var _normalizeTimeUnit,_legend$encoding,_legend;let legend=model.legend(channel);const{markDef:markDef,encoding:encoding,config:config}=model;const legendConfig=config.legend;const legendCmpt=new component_LegendComponent({},getLegendDefWithScale(model,channel));parseInteractiveLegend(model,channel,legendCmpt);const disable=legend!==undefined?!legend:legendConfig.disable;legendCmpt.set("disable",disable,legend!==undefined);if(disable){return legendCmpt}legend=legend||{};const scaleType=model.getScaleComponent(channel).get("type");const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);const timeUnit=isFieldDef(fieldOrDatumDef)?(_normalizeTimeUnit=normalizeTimeUnit(fieldOrDatumDef.timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit:undefined;const orient=legend.orient||config.legend.orient||"right";const legendType=getLegendType({legend:legend,channel:channel,timeUnit:timeUnit,scaleType:scaleType});const direction=getDirection({legend:legend,legendType:legendType,orient:orient,legendConfig:legendConfig});const ruleParams={legend:legend,channel:channel,model:model,markDef:markDef,encoding:encoding,fieldOrDatumDef:fieldOrDatumDef,legendConfig:legendConfig,config:config,scaleType:scaleType,orient:orient,legendType:legendType,direction:direction};for(const property of LEGEND_COMPONENT_PROPERTIES){if(legendType==="gradient"&&property.startsWith("symbol")||legendType==="symbol"&&property.startsWith("gradient")){continue}const value=property in legendRules?legendRules[property](ruleParams):legend[property];if(value!==undefined){const explicit=isExplicit(value,property,legend,model.fieldDef(channel));if(explicit||config.legend[property]===undefined){legendCmpt.set(property,value,explicit)}}}const legendEncoding=(_legend$encoding=(_legend=legend)===null||_legend===void 0?void 0:_legend.encoding)!==null&&_legend$encoding!==void 0?_legend$encoding:{};const selections=legendCmpt.get("selections");const legendEncode={};const legendEncodeParams={fieldOrDatumDef:fieldOrDatumDef,model:model,channel:channel,legendCmpt:legendCmpt,legendType:legendType};for(const part of["labels","legend","title","symbols","gradient","entries"]){var _part;const legendEncodingPart=guideEncodeEntry((_part=legendEncoding[part])!==null&&_part!==void 0?_part:{},model);const value=part in legendEncodeRules?legendEncodeRules[part](legendEncodingPart,legendEncodeParams):legendEncodingPart;if(value!==undefined&&!isEmpty(value)){legendEncode[part]={...selections!==null&&selections!==void 0&&selections.length&&isFieldDef(fieldOrDatumDef)?{name:`${varName(fieldOrDatumDef.field)}_legend_${part}`}:{},...selections!==null&&selections!==void 0&&selections.length?{interactive:!!selections}:{},update:value}}}if(!isEmpty(legendEncode)){var _legend2;legendCmpt.set("encode",legendEncode,!!((_legend2=legend)!==null&&_legend2!==void 0&&_legend2.encoding))}return legendCmpt}function parseNonUnitLegend(model){const{legends:legends,resolve:resolve}=model.component;for(const child of model.children){parseLegend(child);for(const channel of keys(child.component.legends)){resolve.legend[channel]=parseGuideResolve(model.component.resolve,channel);if(resolve.legend[channel]==="shared"){legends[channel]=mergeLegendComponent(legends[channel],child.component.legends[channel]);if(!legends[channel]){resolve.legend[channel]="independent";delete legends[channel]}}}}for(const channel of keys(legends)){for(const child of model.children){if(!child.component.legends[channel]){continue}if(resolve.legend[channel]==="shared"){delete child.component.legends[channel]}}}return legends}function mergeLegendComponent(mergedLegend,childLegend){if(!mergedLegend){return childLegend.clone()}const mergedOrient=mergedLegend.getWithExplicit("orient");const childOrient=childLegend.getWithExplicit("orient");if(mergedOrient.explicit&&childOrient.explicit&&mergedOrient.value!==childOrient.value){return undefined}let typeMerged=false;for(const prop of LEGEND_COMPONENT_PROPERTIES){const mergedValueWithExplicit=mergeValuesWithExplicit(mergedLegend.getWithExplicit(prop),childLegend.getWithExplicit(prop),prop,"legend",(v1,v2)=>{switch(prop){case"symbolType":return mergeSymbolType(v1,v2);case"title":return mergeTitleComponent(v1,v2);case"type":typeMerged=true;return makeImplicit("symbol")}return defaultTieBreaker(v1,v2,prop,"legend")});mergedLegend.setWithExplicit(prop,mergedValueWithExplicit)}if(typeMerged){var _mergedLegend$implici,_mergedLegend$explici;if((_mergedLegend$implici=mergedLegend.implicit)!==null&&_mergedLegend$implici!==void 0&&(_mergedLegend$implici=_mergedLegend$implici.encode)!==null&&_mergedLegend$implici!==void 0&&_mergedLegend$implici.gradient){deleteNestedProperty(mergedLegend.implicit,["encode","gradient"])}if((_mergedLegend$explici=mergedLegend.explicit)!==null&&_mergedLegend$explici!==void 0&&(_mergedLegend$explici=_mergedLegend$explici.encode)!==null&&_mergedLegend$explici!==void 0&&_mergedLegend$explici.gradient){deleteNestedProperty(mergedLegend.explicit,["encode","gradient"])}}return mergedLegend}function mergeSymbolType(st1,st2){if(st2.value==="circle"){return st2}return st1}function setLegendEncode(legend,part,vgProp,vgRef){var _legend$encode,_legend$encode2,_legend$encode2$part,_legend$encode$part,_legend$encode$part$u;(_legend$encode=legend.encode)!==null&&_legend$encode!==void 0?_legend$encode:legend.encode={};(_legend$encode2$part=(_legend$encode2=legend.encode)[part])!==null&&_legend$encode2$part!==void 0?_legend$encode2$part:_legend$encode2[part]={};(_legend$encode$part$u=(_legend$encode$part=legend.encode[part]).update)!==null&&_legend$encode$part$u!==void 0?_legend$encode$part$u:_legend$encode$part.update={};legend.encode[part].update[vgProp]=vgRef}function assembleLegends(model){const legendComponentIndex=model.component.legends;const legendByDomain={};for(const channel of keys(legendComponentIndex)){const scaleComponent=model.getScaleComponent(channel);const domainHash=stringify(scaleComponent.get("domains"));if(legendByDomain[domainHash]){for(const mergedLegendComponent of legendByDomain[domainHash]){const merged=mergeLegendComponent(mergedLegendComponent,legendComponentIndex[channel]);if(!merged){legendByDomain[domainHash].push(legendComponentIndex[channel])}}}else{legendByDomain[domainHash]=[legendComponentIndex[channel].clone()]}}const legends=util_vals(legendByDomain).flat().map(l=>assembleLegend(l,model.config)).filter(l=>l!==undefined);return legends}function assembleLegend(legendCmpt,config){var _legend$encode3;const{disable:disable,labelExpr:labelExpr,selections:selections,...legend}=legendCmpt.combine();if(disable){return undefined}if(config.aria===false&&legend.aria==undefined){legend.aria=false}if((_legend$encode3=legend.encode)!==null&&_legend$encode3!==void 0&&_legend$encode3.symbols){const out=legend.encode.symbols.update;if(out.fill&&out.fill["value"]!=="transparent"&&!out.stroke&&!legend.stroke){out.stroke={value:"transparent"}}for(const property of LEGEND_SCALE_CHANNELS){if(legend[property]){delete out[property]}}}if(!legend.title){delete legend.title}if(labelExpr!==undefined){var _legend$encode4;let expr=labelExpr;if((_legend$encode4=legend.encode)!==null&&_legend$encode4!==void 0&&(_legend$encode4=_legend$encode4.labels)!==null&&_legend$encode4!==void 0&&_legend$encode4.update&&isSignalRef(legend.encode.labels.update.text)){expr=replaceAll(labelExpr,"datum.label",legend.encode.labels.update.text.signal)}setLegendEncode(legend,"labels","text",{signal:expr})}return legend}function assembleProjections(model){if(isLayerModel(model)||isConcatModel(model)){return assembleProjectionsForModelAndChildren(model)}else{return assembleProjectionForModel(model)}}function assembleProjectionsForModelAndChildren(model){return model.children.reduce((projections,child)=>projections.concat(child.assembleProjections()),assembleProjectionForModel(model))}function assembleProjectionForModel(model){const component=model.component.projection;if(!component||component.merged){return[]}const projection=component.combine();const{name:name}=projection;if(!component.data){return[{name:name,translate:{signal:"[width / 2, height / 2]"},...projection}]}else{const size={signal:`[${component.size.map(ref=>ref.signal).join(", ")}]`};const fits=component.data.reduce((sources,data)=>{const source=isSignalRef(data)?data.signal:`data('${model.lookupDataSource(data)}')`;if(!util_contains(sources,source)){sources.push(source)}return sources},[]);if(fits.length<=0){throw new Error("Projection's fit didn't find any data sources")}return[{name:name,size:size,fit:{signal:fits.length>1?`[${fits.join(", ")}]`:fits[0]},...projection}]}}const PROJECTION_PROPERTIES=["type","clipAngle","clipExtent","center","rotate","precision","reflectX","reflectY","coefficient","distance","fraction","lobes","parallel","radius","ratio","spacing","tilt"];function component_defineProperty(e,r,t){return(r=component_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function component_toPropertyKey(t){var i=component_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function component_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class component_ProjectionComponent extends split_Split{constructor(name,specifiedProjection,size,data){super({...specifiedProjection},{name:name});this.specifiedProjection=specifiedProjection;this.size=size;this.data=data;component_defineProperty(this,"merged",false)}get isFit(){return!!this.data}}function parseProjection(model){model.component.projection=isUnitModel(model)?parseUnitProjection(model):parseNonUnitProjections(model)}function parseUnitProjection(model){if(model.hasProjection){const proj=replaceExprRef(model.specifiedProjection);const fit=!(proj&&(proj.scale!=null||proj.translate!=null));const size=fit?[model.getSizeSignalRef("width"),model.getSizeSignalRef("height")]:undefined;const data=fit?gatherFitData(model):undefined;const projComp=new component_ProjectionComponent(model.projectionName(true),{...replaceExprRef(model.config.projection),...proj},size,data);if(!projComp.get("type")){projComp.set("type","equalEarth",false)}return projComp}return undefined}function gatherFitData(model){const data=[];const{encoding:encoding}=model;for(const posssiblePair of[[LONGITUDE,LATITUDE],[LONGITUDE2,LATITUDE2]]){if(getFieldOrDatumDef(encoding[posssiblePair[0]])||getFieldOrDatumDef(encoding[posssiblePair[1]])){data.push({signal:model.getName(`geojson_${data.length}`)})}}if(model.channelHasField(SHAPE)&&model.typedFieldDef(SHAPE).type===GEOJSON){data.push({signal:model.getName(`geojson_${data.length}`)})}if(data.length===0){data.push(model.requestDataName(DataSourceType.Main))}return data}function mergeIfNoConflict(first,second){const allPropertiesShared=every(PROJECTION_PROPERTIES,prop=>{if(!Object(vega_util["hasOwnProperty"])(first.explicit,prop)&&!Object(vega_util["hasOwnProperty"])(second.explicit,prop)){return true}if(Object(vega_util["hasOwnProperty"])(first.explicit,prop)&&Object(vega_util["hasOwnProperty"])(second.explicit,prop)&&deepEqual(first.get(prop),second.get(prop))){return true}return false});const size=deepEqual(first.size,second.size);if(size){if(allPropertiesShared){return first}else if(deepEqual(first.explicit,{})){return second}else if(deepEqual(second.explicit,{})){return first}}return null}function parseNonUnitProjections(model){if(model.children.length===0){return undefined}let nonUnitProjection;for(const child of model.children){parseProjection(child)}const mergable=every(model.children,child=>{const projection=child.component.projection;if(!projection){return true}else if(!nonUnitProjection){nonUnitProjection=projection;return true}else{const merge=mergeIfNoConflict(nonUnitProjection,projection);if(merge){nonUnitProjection=merge}return!!merge}});if(nonUnitProjection&&mergable){const name=model.projectionName(true);const modelProjection=new component_ProjectionComponent(name,nonUnitProjection.specifiedProjection,nonUnitProjection.size,duplicate(nonUnitProjection.data));for(const child of model.children){const projection=child.component.projection;if(projection){if(projection.isFit){modelProjection.data.push(...child.component.projection.data)}child.renameProjection(projection.get("name"),name);projection.merged=true}}return modelProjection}return undefined}function rangeFormula(model,fieldDef,channel,config){if(binRequiresRange(fieldDef,channel)){var _ref,_model$axis;const guide=isUnitModel(model)?(_ref=(_model$axis=model.axis(channel))!==null&&_model$axis!==void 0?_model$axis:model.legend(channel))!==null&&_ref!==void 0?_ref:{}:{};const startField=vgField(fieldDef,{expr:"datum"});const endField=vgField(fieldDef,{expr:"datum",binSuffix:"end"});return{formulaAs:vgField(fieldDef,{binSuffix:"range",forAs:true}),formula:binFormatExpression(startField,endField,guide.format,guide.formatType,config)}}return{}}function binKey(bin,field){return`${binToString(bin)}_${field}`}function getSignalsFromModel(model,key){return{signal:model.getName(`${key}_bins`),extentSignal:model.getName(`${key}_extent`)}}function getBinSignalName(model,field,bin){var _normalizeBin;const normalizedBin=(_normalizeBin=normalizeBin(bin,undefined))!==null&&_normalizeBin!==void 0?_normalizeBin:{};const key=binKey(normalizedBin,field);return model.getName(`${key}_bins`)}function isBinTransform(t){return"as"in t}function createBinComponent(t,bin,model){let as;let span;if(isBinTransform(t)){as=Object(vega_util["isString"])(t.as)?[t.as,`${t.as}_end`]:[t.as[0],t.as[1]]}else{as=[vgField(t,{forAs:true}),vgField(t,{binSuffix:"end",forAs:true})]}const normalizedBin={...normalizeBin(bin,undefined)};const key=binKey(normalizedBin,t.field);const{signal:signal,extentSignal:extentSignal}=getSignalsFromModel(model,key);if(isParameterExtent(normalizedBin.extent)){const ext=normalizedBin.extent;span=parseSelectionExtent(model,ext.param,ext);delete normalizedBin.extent}const binComponent={bin:normalizedBin,field:t.field,as:[as],...signal?{signal:signal}:{},...extentSignal?{extentSignal:extentSignal}:{},...span?{span:span}:{}};return{key:key,binComponent:binComponent}}class bin_BinNode extends dataflow_DataFlowNode{clone(){return new bin_BinNode(null,duplicate(this.bins))}constructor(parent,bins){super(parent);this.bins=bins}static makeFromEncoding(parent,model){const bins=model.reduceFieldDef((binComponentIndex,fieldDef,channel)=>{if(isTypedFieldDef(fieldDef)&&isBinning(fieldDef.bin)){const{key:key,binComponent:binComponent}=createBinComponent(fieldDef,fieldDef.bin,model);binComponentIndex[key]={...binComponent,...binComponentIndex[key],...rangeFormula(model,fieldDef,channel,model.config)}}return binComponentIndex},{});if(isEmpty(bins)){return null}return new bin_BinNode(parent,bins)}static makeFromTransform(parent,t,model){const{key:key,binComponent:binComponent}=createBinComponent(t,t.bin,model);return new bin_BinNode(parent,{[key]:binComponent})}merge(other,renameSignal){for(const key of keys(other.bins)){if(key in this.bins){renameSignal(other.bins[key].signal,this.bins[key].signal);this.bins[key].as=unique([...this.bins[key].as,...other.bins[key].as],hash)}else{this.bins[key]=other.bins[key]}}for(const child of other.children){other.removeChild(child);child.parent=this}other.remove()}producedFields(){return new Set(util_vals(this.bins).map(c=>c.as).flat(2))}dependentFields(){return new Set(util_vals(this.bins).map(c=>c.field))}hash(){return`Bin ${hash(this.bins)}`}assemble(){return util_vals(this.bins).flatMap(bin=>{const transform=[];const[binAs,...remainingAs]=bin.as;const{extent:extent,...params}=bin.bin;const binTrans={type:"bin",field:replacePathInField(bin.field),as:binAs,signal:bin.signal,...!isParameterExtent(extent)?{extent:extent}:{extent:null},...bin.span?{span:{signal:`span(${bin.span})`}}:{},...params};if(!extent&&bin.extentSignal){transform.push({type:"extent",field:replacePathInField(bin.field),signal:bin.extentSignal});binTrans.extent={signal:bin.extentSignal}}transform.push(binTrans);for(const as of remainingAs){for(let i=0;i<2;i++){transform.push({type:"formula",expr:vgField({field:binAs[i]},{expr:"datum"}),as:as[i]})}}if(bin.formula){transform.push({type:"formula",expr:bin.formula,as:bin.formulaAs})}return transform})}}function addDimension(dims,channel,fieldDef,model){var _fieldDef$scale;const channelDef2=isUnitModel(model)?model.encoding[getSecondaryRangeChannel(channel)]:undefined;if(isTypedFieldDef(fieldDef)&&isUnitModel(model)&&hasBandEnd(fieldDef,channelDef2,model.markDef,model.config)){dims.add(vgField(fieldDef,{}));dims.add(vgField(fieldDef,{suffix:"end"}));const{mark:mark,markDef:markDef,config:config}=model;const bandPosition=getBandPosition({fieldDef:fieldDef,markDef:markDef,config:config});if(isRectBasedMark(mark)&&bandPosition!==.5&&isXorY(channel)){dims.add(vgField(fieldDef,{suffix:OFFSETTED_RECT_START_SUFFIX}));dims.add(vgField(fieldDef,{suffix:OFFSETTED_RECT_END_SUFFIX}))}if(fieldDef.bin&&binRequiresRange(fieldDef,channel)){dims.add(vgField(fieldDef,{binSuffix:"range"}))}}else if(isGeoPositionChannel(channel)){const posChannel=getPositionChannelFromLatLong(channel);dims.add(model.getName(posChannel))}else{dims.add(vgField(fieldDef))}if(isScaleFieldDef(fieldDef)&&isFieldRange((_fieldDef$scale=fieldDef.scale)===null||_fieldDef$scale===void 0?void 0:_fieldDef$scale.range)){dims.add(fieldDef.scale.range.field)}return dims}function mergeMeasures(parentMeasures,childMeasures){for(const field of keys(childMeasures)){const ops=childMeasures[field];for(const op of keys(ops)){if(field in parentMeasures){var _parentMeasures$field;parentMeasures[field][op]=new Set([...(_parentMeasures$field=parentMeasures[field][op])!==null&&_parentMeasures$field!==void 0?_parentMeasures$field:[],...ops[op]])}else{parentMeasures[field]={[op]:ops[op]}}}}}class aggregate_AggregateNode extends dataflow_DataFlowNode{clone(){return new aggregate_AggregateNode(null,new Set(this.dimensions),duplicate(this.measures))}constructor(parent,dimensions,measures){super(parent);this.dimensions=dimensions;this.measures=measures}get groupBy(){return this.dimensions}static makeFromEncoding(parent,model){let isAggregate=false;model.forEachFieldDef(fd=>{if(fd.aggregate){isAggregate=true}});const meas={};const dims=new Set;if(!isAggregate){return null}model.forEachFieldDef((fieldDef,channel)=>{const{aggregate:aggregate,field:field}=fieldDef;if(aggregate){if(aggregate==="count"){var _,_meas$_;(_meas$_=meas[_="*"])!==null&&_meas$_!==void 0?_meas$_:meas[_]={};meas["*"]["count"]=new Set([vgField(fieldDef,{forAs:true})])}else{if(isArgminDef(aggregate)||isArgmaxDef(aggregate)){var _meas$argField;const op=isArgminDef(aggregate)?"argmin":"argmax";const argField=aggregate[op];(_meas$argField=meas[argField])!==null&&_meas$argField!==void 0?_meas$argField:meas[argField]={};meas[argField][op]=new Set([vgField({op:op,field:argField},{forAs:true})])}else{var _meas$field;(_meas$field=meas[field])!==null&&_meas$field!==void 0?_meas$field:meas[field]={};meas[field][aggregate]=new Set([vgField(fieldDef,{forAs:true})])}if(isScaleChannel(channel)&&model.scaleDomain(channel)==="unaggregated"){var _meas$field2;(_meas$field2=meas[field])!==null&&_meas$field2!==void 0?_meas$field2:meas[field]={};meas[field]["min"]=new Set([vgField({field:field,aggregate:"min"},{forAs:true})]);meas[field]["max"]=new Set([vgField({field:field,aggregate:"max"},{forAs:true})])}}}else{addDimension(dims,channel,fieldDef,model)}});if(dims.size+keys(meas).length===0){return null}return new aggregate_AggregateNode(parent,dims,meas)}static makeFromTransform(parent,t){const dims=new Set;const meas={};for(const s of t.aggregate){const{op:op,field:field,as:as}=s;if(op){if(op==="count"){var _2,_meas$_2;(_meas$_2=meas[_2="*"])!==null&&_meas$_2!==void 0?_meas$_2:meas[_2]={};meas["*"]["count"]=new Set([as?as:vgField(s,{forAs:true})])}else{var _meas$field3,_meas$field4,_meas$field4$op;(_meas$field3=meas[field])!==null&&_meas$field3!==void 0?_meas$field3:meas[field]={};(_meas$field4$op=(_meas$field4=meas[field])[op])!==null&&_meas$field4$op!==void 0?_meas$field4$op:_meas$field4[op]=new Set;meas[field][op].add(as?as:vgField(s,{forAs:true}))}}}for(const s of(_t$groupby=t.groupby)!==null&&_t$groupby!==void 0?_t$groupby:[]){var _t$groupby;dims.add(s)}if(dims.size+keys(meas).length===0){return null}return new aggregate_AggregateNode(parent,dims,meas)}merge(other){if(setEqual(this.dimensions,other.dimensions)){mergeMeasures(this.measures,other.measures);return true}debug("different dimensions, cannot merge");return false}addDimensions(fields){fields.forEach(this.dimensions.add,this.dimensions)}dependentFields(){return new Set([...this.dimensions,...keys(this.measures)])}producedFields(){const out=new Set;for(const field of keys(this.measures)){for(const op of keys(this.measures[field])){const m=this.measures[field][op];if(m.size===0){out.add(`${op}_${field}`)}else{m.forEach(out.add,out)}}}return out}hash(){return`Aggregate ${hash({dimensions:this.dimensions,measures:this.measures})}`}assemble(){const ops=[];const fields=[];const as=[];for(const field of keys(this.measures)){for(const op of keys(this.measures[field])){for(const alias of this.measures[field][op]){as.push(alias);ops.push(op);fields.push(field==="*"?null:replacePathInField(field))}}}const result={type:"aggregate",groupby:[...this.dimensions].map(replacePathInField),ops:ops,fields:fields,as:as};return result}}function facet_defineProperty(e,r,t){return(r=facet_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function facet_toPropertyKey(t){var i=facet_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function facet_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class facet_FacetNode extends dataflow_DataFlowNode{constructor(parent,model,name,data){super(parent);this.model=model;this.name=name;this.data=data;facet_defineProperty(this,"column",void 0);facet_defineProperty(this,"row",void 0);facet_defineProperty(this,"facet",void 0);facet_defineProperty(this,"childModel",void 0);for(const channel of FACET_CHANNELS){const fieldDef=model.facet[channel];if(fieldDef){const{bin:bin,sort:sort}=fieldDef;this[channel]={name:model.getName(`${channel}_domain`),fields:[vgField(fieldDef),...isBinning(bin)?[vgField(fieldDef,{binSuffix:"end"})]:[]],...isSortField(sort)?{sortField:sort}:Object(vega_util["isArray"])(sort)?{sortIndexField:sortArrayIndexField(fieldDef,channel)}:{}}}}this.childModel=model.child}hash(){let out=`Facet`;for(const channel of FACET_CHANNELS){if(this[channel]){out+=` ${channel.charAt(0)}:${hash(this[channel])}`}}return out}get fields(){const f=[];for(const channel of FACET_CHANNELS){var _this$channel;if((_this$channel=this[channel])!==null&&_this$channel!==void 0&&_this$channel.fields){f.push(...this[channel].fields)}}return f}dependentFields(){const depFields=new Set(this.fields);for(const channel of FACET_CHANNELS){if(this[channel]){if(this[channel].sortField){depFields.add(this[channel].sortField.field)}if(this[channel].sortIndexField){depFields.add(this[channel].sortIndexField)}}}return depFields}producedFields(){return new Set}getSource(){return this.name}getChildIndependentFieldsWithStep(){const childIndependentFieldsWithStep={};for(const channel of POSITION_SCALE_CHANNELS){const childScaleComponent=this.childModel.component.scales[channel];if(childScaleComponent&&!childScaleComponent.merged){const type=childScaleComponent.get("type");const range=childScaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const domain=assembleDomain(this.childModel,channel);const field=getFieldFromDomain(domain);if(field){childIndependentFieldsWithStep[channel]=field}else{warn(message_namespaceObject.unknownField(channel))}}}}return childIndependentFieldsWithStep}assembleRowColumnHeaderData(channel,crossedDataName,childIndependentFieldsWithStep){const childChannel={row:"y",column:"x",facet:undefined}[channel];const fields=[];const ops=[];const as=[];if(childChannel&&childIndependentFieldsWithStep&&childIndependentFieldsWithStep[childChannel]){if(crossedDataName){fields.push(`distinct_${childIndependentFieldsWithStep[childChannel]}`);ops.push("max")}else{fields.push(childIndependentFieldsWithStep[childChannel]);ops.push("distinct")}as.push(`distinct_${childIndependentFieldsWithStep[childChannel]}`)}const{sortField:sortField,sortIndexField:sortIndexField}=this[channel];if(sortField){const{op:op=DEFAULT_SORT_OP,field:field}=sortField;fields.push(field);ops.push(op);as.push(vgField(sortField,{forAs:true}))}else if(sortIndexField){fields.push(sortIndexField);ops.push("max");as.push(sortIndexField)}return{name:this[channel].name,source:crossedDataName!==null&&crossedDataName!==void 0?crossedDataName:this.data,transform:[{type:"aggregate",groupby:this[channel].fields,...fields.length?{fields:fields,ops:ops,as:as}:{}}]}}assembleFacetHeaderData(childIndependentFieldsWithStep){const{columns:columns}=this.model.layout;const{layoutHeaders:layoutHeaders}=this.model.component;const data=[];const hasSharedAxis={};for(const headerChannel of HEADER_CHANNELS){for(const headerType of HEADER_TYPES){var _ref;const headers=(_ref=layoutHeaders[headerChannel]&&layoutHeaders[headerChannel][headerType])!==null&&_ref!==void 0?_ref:[];for(const header of headers){var _header$axes;if(((_header$axes=header.axes)===null||_header$axes===void 0?void 0:_header$axes.length)>0){hasSharedAxis[headerChannel]=true;break}}}if(hasSharedAxis[headerChannel]){const cardinality=`length(data("${this.facet.name}"))`;const stop=headerChannel==="row"?columns?{signal:`ceil(${cardinality} / ${columns})`}:1:columns?{signal:`min(${cardinality}, ${columns})`}:{signal:cardinality};data.push({name:`${this.facet.name}_${headerChannel}`,transform:[{type:"sequence",start:0,stop:stop}]})}}const{row:row,column:column}=hasSharedAxis;if(row||column){data.unshift(this.assembleRowColumnHeaderData("facet",null,childIndependentFieldsWithStep))}return data}assemble(){const data=[];let crossedDataName=null;const childIndependentFieldsWithStep=this.getChildIndependentFieldsWithStep();const{column:column,row:row,facet:facet}=this;if(column&&row&&(childIndependentFieldsWithStep.x||childIndependentFieldsWithStep.y)){var _childIndependentFiel,_childIndependentFiel2;crossedDataName=`cross_${this.column.name}_${this.row.name}`;const fields=[].concat((_childIndependentFiel=childIndependentFieldsWithStep.x)!==null&&_childIndependentFiel!==void 0?_childIndependentFiel:[],(_childIndependentFiel2=childIndependentFieldsWithStep.y)!==null&&_childIndependentFiel2!==void 0?_childIndependentFiel2:[]);const ops=fields.map(()=>"distinct");data.push({name:crossedDataName,source:this.data,transform:[{type:"aggregate",groupby:this.fields,fields:fields,ops:ops}]})}for(const channel of[COLUMN,ROW]){if(this[channel]){data.push(this.assembleRowColumnHeaderData(channel,crossedDataName,childIndependentFieldsWithStep))}}if(facet){const facetData=this.assembleFacetHeaderData(childIndependentFieldsWithStep);if(facetData){data.push(...facetData)}}return data}}function formatparse_defineProperty(e,r,t){return(r=formatparse_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function formatparse_toPropertyKey(t){var i=formatparse_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function formatparse_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}function unquote(pattern){if(pattern.startsWith("'")&&pattern.endsWith("'")||pattern.startsWith('"')&&pattern.endsWith('"')){return pattern.slice(1,-1)}return pattern}function parseExpression(field,parse){const f=accessPathWithDatum(field);if(parse==="number"){return`toNumber(${f})`}else if(parse==="boolean"){return`toBoolean(${f})`}else if(parse==="string"){return`toString(${f})`}else if(parse==="date"){return`toDate(${f})`}else if(parse==="flatten"){return f}else if(parse.startsWith("date:")){const specifier=unquote(parse.slice(5,parse.length));return`timeParse(${f},'${specifier}')`}else if(parse.startsWith("utc:")){const specifier=unquote(parse.slice(4,parse.length));return`utcParse(${f},'${specifier}')`}else{warn(message_namespaceObject.unrecognizedParse(parse));return null}}function getImplicitFromFilterTransform(transform){const implicit={};forEachLeaf(transform.filter,filter=>{if(isFieldPredicate(filter)){let val=null;if(isFieldEqualPredicate(filter)){val=signalRefOrValue(filter.equal)}else if(isFieldLTEPredicate(filter)){val=signalRefOrValue(filter.lte)}else if(isFieldLTPredicate(filter)){val=signalRefOrValue(filter.lt)}else if(isFieldGTPredicate(filter)){val=signalRefOrValue(filter.gt)}else if(isFieldGTEPredicate(filter)){val=signalRefOrValue(filter.gte)}else if(isFieldRangePredicate(filter)){val=filter.range[0]}else if(isFieldOneOfPredicate(filter)){var _filter$oneOf;val=((_filter$oneOf=filter.oneOf)!==null&&_filter$oneOf!==void 0?_filter$oneOf:filter.in)[0]}if(val){if(isDateTime(val)){implicit[filter.field]="date"}else if(Object(vega_util["isNumber"])(val)){implicit[filter.field]="number"}else if(Object(vega_util["isString"])(val)){implicit[filter.field]="string"}}if(filter.timeUnit){implicit[filter.field]="date"}}});return implicit}function getImplicitFromEncoding(model){const implicit={};function add(fieldDef){if(isFieldOrDatumDefForTimeFormat(fieldDef)){implicit[fieldDef.field]="date"}else if(fieldDef.type==="quantitative"&&isMinMaxOp(fieldDef.aggregate)){implicit[fieldDef.field]="number"}else if(accessPathDepth(fieldDef.field)>1){if(!(fieldDef.field in implicit)){implicit[fieldDef.field]="flatten"}}else if(isScaleFieldDef(fieldDef)&&isSortField(fieldDef.sort)&&accessPathDepth(fieldDef.sort.field)>1){if(!(fieldDef.sort.field in implicit)){implicit[fieldDef.sort.field]="flatten"}}}if(isUnitModel(model)||isFacetModel(model)){model.forEachFieldDef((fieldDef,channel)=>{if(isTypedFieldDef(fieldDef)){add(fieldDef)}else{const mainChannel=getMainRangeChannel(channel);const mainFieldDef=model.fieldDef(mainChannel);add({...fieldDef,type:mainFieldDef.type})}})}if(isUnitModel(model)){const{mark:mark,markDef:markDef,encoding:encoding}=model;if(isPathMark(mark)&&!model.encoding.order){const dimensionChannel=markDef.orient==="horizontal"?"y":"x";const dimensionChannelDef=encoding[dimensionChannel];if(isFieldDef(dimensionChannelDef)&&dimensionChannelDef.type==="quantitative"&&!(dimensionChannelDef.field in implicit)){implicit[dimensionChannelDef.field]="number"}}}return implicit}function getImplicitFromSelection(model){const implicit={};if(isUnitModel(model)&&model.component.selection){for(const name of keys(model.component.selection)){const selCmpt=model.component.selection[name];for(const proj of selCmpt.project.items){if(!proj.channel&&accessPathDepth(proj.field)>1){implicit[proj.field]="flatten"}}}}return implicit}class formatparse_ParseNode extends dataflow_DataFlowNode{clone(){return new formatparse_ParseNode(null,duplicate(this._parse))}constructor(parent,parse){super(parent);formatparse_defineProperty(this,"_parse",void 0);this._parse=parse}hash(){return`Parse ${hash(this._parse)}`}static makeExplicit(parent,model,ancestorParse){var _data$format;let explicit={};const data=model.data;if(!isGenerator(data)&&data!==null&&data!==void 0&&(_data$format=data.format)!==null&&_data$format!==void 0&&_data$format.parse){explicit=data.format.parse}return this.makeWithAncestors(parent,explicit,{},ancestorParse)}static makeWithAncestors(parent,explicit,implicit,ancestorParse){for(const field of keys(implicit)){const parsedAs=ancestorParse.getWithExplicit(field);if(parsedAs.value!==undefined){if(parsedAs.explicit||parsedAs.value===implicit[field]||parsedAs.value==="derived"||implicit[field]==="flatten"){delete implicit[field]}else{warn(message_namespaceObject.differentParse(field,implicit[field],parsedAs.value))}}}for(const field of keys(explicit)){const parsedAs=ancestorParse.get(field);if(parsedAs!==undefined){if(parsedAs===explicit[field]){delete explicit[field]}else{warn(message_namespaceObject.differentParse(field,explicit[field],parsedAs))}}}const parse=new split_Split(explicit,implicit);ancestorParse.copyAll(parse);const p={};for(const key of keys(parse.combine())){const val=parse.get(key);if(val!==null){p[key]=val}}if(keys(p).length===0||ancestorParse.parseNothing){return null}return new formatparse_ParseNode(parent,p)}get parse(){return this._parse}merge(other){this._parse={...this._parse,...other.parse};other.remove()}assembleFormatParse(){const formatParse={};for(const field of keys(this._parse)){const p=this._parse[field];if(accessPathDepth(field)===1){formatParse[field]=p}}return formatParse}producedFields(){return new Set(keys(this._parse))}dependentFields(){return new Set(keys(this._parse))}assembleTransforms(){let onlyNested=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;return keys(this._parse).filter(field=>onlyNested?accessPathDepth(field)>1:true).map(field=>{const expr=parseExpression(field,this._parse[field]);if(!expr){return null}const formula={type:"formula",expr:expr,as:removePathFromField(field)};return formula}).filter(t=>t!==null)}}class identifier_IdentifierNode extends dataflow_DataFlowNode{clone(){return new identifier_IdentifierNode(null)}constructor(parent){super(parent)}dependentFields(){return new Set}producedFields(){return new Set([SELECTION_ID])}hash(){return"Identifier"}assemble(){return{type:"identifier",as:SELECTION_ID}}}class graticule_GraticuleNode extends dataflow_DataFlowNode{clone(){return new graticule_GraticuleNode(null,this.params)}constructor(parent,params){super(parent);this.params=params}dependentFields(){return new Set}producedFields(){return undefined}hash(){return`Graticule ${hash(this.params)}`}assemble(){return{type:"graticule",...this.params===true?{}:this.params}}}class sequence_SequenceNode extends dataflow_DataFlowNode{clone(){return new sequence_SequenceNode(null,this.params)}constructor(parent,params){super(parent);this.params=params}dependentFields(){return new Set}producedFields(){var _this$params$as;return new Set([(_this$params$as=this.params.as)!==null&&_this$params$as!==void 0?_this$params$as:"data"])}hash(){return`Hash ${hash(this.params)}`}assemble(){return{type:"sequence",...this.params}}}function source_defineProperty(e,r,t){return(r=source_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function source_toPropertyKey(t){var i=source_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function source_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class source_SourceNode extends dataflow_DataFlowNode{constructor(data){var _data;super(null);source_defineProperty(this,"_data",void 0);source_defineProperty(this,"_name",void 0);source_defineProperty(this,"_generator",void 0);(_data=data)!==null&&_data!==void 0?_data:data={name:"source"};let format;if(!isGenerator(data)){format=data.format?{...omit(data.format,["parse"])}:{}}if(isInlineData(data)){this._data={values:data.values}}else if(isUrlData(data)){this._data={url:data.url};if(!format.type){let defaultExtension=/(?:\.([^.]+))?$/.exec(data.url)[1];if(!util_contains(["json","csv","tsv","dsv","topojson"],defaultExtension)){defaultExtension="json"}format.type=defaultExtension}}else if(isSphereGenerator(data)){this._data={values:[{type:"Sphere"}]}}else if(isNamedData(data)||isGenerator(data)){this._data={}}this._generator=isGenerator(data);if(data.name){this._name=data.name}if(format&&!isEmpty(format)){this._data.format=format}}dependentFields(){return new Set}producedFields(){return undefined}get data(){return this._data}hasName(){return!!this._name}get isGenerator(){return this._generator}get dataName(){return this._name}set dataName(name){this._name=name}set parent(parent){throw new Error("Source nodes have to be roots.")}remove(){throw new Error("Source nodes are roots and cannot be removed.")}hash(){throw new Error("Cannot hash sources")}assemble(){return{name:this._name,...this._data,transform:[]}}}function optimizer_classPrivateFieldInitSpec(e,t,a){optimizer_checkPrivateRedeclaration(e,t),t.set(e,a)}function optimizer_checkPrivateRedeclaration(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function optimizer_classPrivateFieldGet2(e,t){var r=optimizer_classPrivateFieldGet(t,e);return optimizer_classApplyDescriptorGet(e,r)}function optimizer_classApplyDescriptorGet(e,t){return t.get?t.get.call(e):t.value}function optimizer_classPrivateFieldSet(e,t,r){var s=optimizer_classPrivateFieldGet(t,e);return optimizer_classApplyDescriptorSet(e,s,r),r}function optimizer_classPrivateFieldGet(s,a){return s.get(optimizer_assertClassBrand(s,a))}function optimizer_assertClassBrand(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}function optimizer_classApplyDescriptorSet(e,t,l){if(t.set)t.set.call(e,l);else{if(!t.writable)throw new TypeError("attempted to set read only private field");t.value=l}}function isDataSourceNode(node){return node instanceof source_SourceNode||node instanceof graticule_GraticuleNode||node instanceof sequence_SequenceNode}var _modified=new WeakMap;class Optimizer{constructor(){optimizer_classPrivateFieldInitSpec(this,_modified,{writable:true,value:void 0});optimizer_classPrivateFieldSet(this,_modified,false)}setModified(){optimizer_classPrivateFieldSet(this,_modified,true)}get modifiedFlag(){return optimizer_classPrivateFieldGet2(this,_modified)}}class BottomUpOptimizer extends Optimizer{getNodeDepths(node,depth,depths){depths.set(node,depth);for(const child of node.children){this.getNodeDepths(child,depth+1,depths)}return depths}optimize(node){const depths=this.getNodeDepths(node,0,new Map);const topologicalSort=[...depths.entries()].sort((a,b)=>b[1]-a[1]);for(const tuple of topologicalSort){this.run(tuple[0])}return this.modifiedFlag}}class TopDownOptimizer extends Optimizer{optimize(node){this.run(node);for(const child of node.children){this.optimize(child)}return this.modifiedFlag}}function optimizers_defineProperty(e,r,t){return(r=optimizers_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function optimizers_toPropertyKey(t){var i=optimizers_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function optimizers_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class optimizers_MergeIdenticalNodes extends TopDownOptimizer{mergeNodes(parent,nodes){const mergedNode=nodes.shift();for(const node of nodes){parent.removeChild(node);node.parent=mergedNode;node.remove()}}run(node){const hashes=node.children.map(x=>x.hash());const buckets={};for(let i=0;i<hashes.length;i++){if(buckets[hashes[i]]===undefined){buckets[hashes[i]]=[node.children[i]]}else{buckets[hashes[i]].push(node.children[i])}}for(const k of keys(buckets)){if(buckets[k].length>1){this.setModified();this.mergeNodes(node,buckets[k])}}}}class optimizers_RemoveUnnecessaryIdentifierNodes extends TopDownOptimizer{constructor(model){super();optimizers_defineProperty(this,"requiresSelectionId",void 0);this.requiresSelectionId=model&&requiresSelectionId(model)}run(node){if(node instanceof identifier_IdentifierNode){if(!(this.requiresSelectionId&&(isDataSourceNode(node.parent)||node.parent instanceof aggregate_AggregateNode||node.parent instanceof formatparse_ParseNode))){this.setModified();node.remove()}}}}class optimizers_RemoveDuplicateTimeUnits extends Optimizer{optimize(node){this.run(node,new Set);return this.modifiedFlag}run(node,timeUnitFields){let producedFields=new Set;if(node instanceof timeunit_TimeUnitNode){producedFields=node.producedFields();if(hasIntersection(producedFields,timeUnitFields)){this.setModified();node.removeFormulas(timeUnitFields);if(node.producedFields.length===0){node.remove()}}}for(const child of node.children){this.run(child,new Set([...timeUnitFields,...producedFields]))}}}class optimizers_RemoveUnnecessaryOutputNodes extends TopDownOptimizer{constructor(){super()}run(node){if(node instanceof dataflow_OutputNode&&!node.isRequired()){this.setModified();node.remove()}}}class optimizers_MoveParseUp extends BottomUpOptimizer{run(node){if(isDataSourceNode(node)){return}if(node.numChildren()>1){return}for(const child of node.children){if(child instanceof formatparse_ParseNode){if(node instanceof formatparse_ParseNode){this.setModified();node.merge(child)}else{if(fieldIntersection(node.producedFields(),child.dependentFields())){continue}this.setModified();child.swapWithParent()}}}return}}class optimizers_MergeParse extends BottomUpOptimizer{run(node){const originalChildren=[...node.children];const parseChildren=node.children.filter(child=>child instanceof formatparse_ParseNode);if(node.numChildren()>1&&parseChildren.length>=1){const commonParse={};const conflictingParse=new Set;for(const parseNode of parseChildren){const parse=parseNode.parse;for(const k of keys(parse)){if(!(k in commonParse)){commonParse[k]=parse[k]}else if(commonParse[k]!==parse[k]){conflictingParse.add(k)}}}for(const field of conflictingParse){delete commonParse[field]}if(!isEmpty(commonParse)){this.setModified();const mergedParseNode=new formatparse_ParseNode(node,commonParse);for(const childNode of originalChildren){if(childNode instanceof formatparse_ParseNode){for(const key of keys(commonParse)){delete childNode.parse[key]}}node.removeChild(childNode);childNode.parent=mergedParseNode;if(childNode instanceof formatparse_ParseNode&&keys(childNode.parse).length===0){childNode.remove()}}}}}}class optimizers_RemoveUnusedSubtrees extends BottomUpOptimizer{run(node){if(node instanceof dataflow_OutputNode||node.numChildren()>0||node instanceof facet_FacetNode){}else if(node instanceof source_SourceNode){}else{this.setModified();node.remove()}}}class optimizers_MergeTimeUnits extends BottomUpOptimizer{run(node){const timeUnitChildren=node.children.filter(x=>x instanceof timeunit_TimeUnitNode);const combination=timeUnitChildren.pop();for(const timeUnit of timeUnitChildren){this.setModified();combination.merge(timeUnit)}}}class optimizers_MergeAggregates extends BottomUpOptimizer{run(node){const aggChildren=node.children.filter(child=>child instanceof aggregate_AggregateNode);const groupedAggregates={};for(const agg of aggChildren){const groupBys=hash(agg.groupBy);if(!(groupBys in groupedAggregates)){groupedAggregates[groupBys]=[]}groupedAggregates[groupBys].push(agg)}for(const group of keys(groupedAggregates)){const mergeableAggs=groupedAggregates[group];if(mergeableAggs.length>1){const mergedAggs=mergeableAggs.pop();for(const agg of mergeableAggs){if(mergedAggs.merge(agg)){node.removeChild(agg);agg.parent=mergedAggs;agg.remove();this.setModified()}}}}}}class optimizers_MergeBins extends BottomUpOptimizer{constructor(model){super();this.model=model}run(node){const moveBinsUp=!(isDataSourceNode(node)||node instanceof filter_FilterNode||node instanceof formatparse_ParseNode||node instanceof identifier_IdentifierNode);const promotableBins=[];const remainingBins=[];for(const child of node.children){if(child instanceof bin_BinNode){if(moveBinsUp&&!fieldIntersection(node.producedFields(),child.dependentFields())){promotableBins.push(child)}else{remainingBins.push(child)}}}if(promotableBins.length>0){const promotedBin=promotableBins.pop();for(const bin of promotableBins){promotedBin.merge(bin,this.model.renameSignal.bind(this.model))}this.setModified();if(node instanceof bin_BinNode){node.merge(promotedBin,this.model.renameSignal.bind(this.model))}else{promotedBin.swapWithParent()}}if(remainingBins.length>1){const remainingBin=remainingBins.pop();for(const bin of remainingBins){remainingBin.merge(bin,this.model.renameSignal.bind(this.model))}this.setModified()}}}class optimizers_MergeOutputs extends BottomUpOptimizer{run(node){const children=[...node.children];const hasOutputChild=some(children,child=>child instanceof dataflow_OutputNode);if(!hasOutputChild||node.numChildren()<=1){return}const otherChildren=[];let mainOutput;for(const child of children){if(child instanceof dataflow_OutputNode){let lastOutput=child;while(lastOutput.numChildren()===1){const[theChild]=lastOutput.children;if(theChild instanceof dataflow_OutputNode){lastOutput=theChild}else{break}}otherChildren.push(...lastOutput.children);if(mainOutput){node.removeChild(child);child.parent=mainOutput.parent;mainOutput.parent.removeChild(mainOutput);mainOutput.parent=lastOutput;this.setModified()}else{mainOutput=lastOutput}}else{otherChildren.push(child)}}if(otherChildren.length){this.setModified();for(const child of otherChildren){child.parent.removeChild(child);child.parent=mainOutput}}}}class joinaggregate_JoinAggregateTransformNode extends dataflow_DataFlowNode{clone(){return new joinaggregate_JoinAggregateTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}addDimensions(fields){this.transform.groupby=unique(this.transform.groupby.concat(fields),d=>d)}dependentFields(){const out=new Set;if(this.transform.groupby){this.transform.groupby.forEach(out.add,out)}this.transform.joinaggregate.map(w=>w.field).filter(f=>f!==undefined).forEach(out.add,out);return out}producedFields(){return new Set(this.transform.joinaggregate.map(this.getDefaultName))}getDefaultName(joinAggregateFieldDef){var _joinAggregateFieldDe;return(_joinAggregateFieldDe=joinAggregateFieldDef.as)!==null&&_joinAggregateFieldDe!==void 0?_joinAggregateFieldDe:vgField(joinAggregateFieldDef)}hash(){return`JoinAggregateTransform ${hash(this.transform)}`}assemble(){const fields=[];const ops=[];const as=[];for(const joinaggregate of this.transform.joinaggregate){ops.push(joinaggregate.op);as.push(this.getDefaultName(joinaggregate));fields.push(joinaggregate.field===undefined?null:joinaggregate.field)}const groupby=this.transform.groupby;return{type:"joinaggregate",as:as,ops:ops,fields:fields,...groupby!==undefined?{groupby:groupby}:{}}}}class filterinvalid_FilterInvalidNode extends dataflow_DataFlowNode{clone(){return new filterinvalid_FilterInvalidNode(null,{...this.filter})}constructor(parent,filter){super(parent);this.filter=filter}static make(parent,model,dataSourcesForHandlingInvalidValues){const{config:config,markDef:markDef}=model;const{marks:marks,scales:scales}=dataSourcesForHandlingInvalidValues;if(marks==="include-invalid-values"&&scales==="include-invalid-values"){return null}const filter=model.reduceFieldDef((aggregator,fieldDef,channel)=>{const scaleComponent=isScaleChannel(channel)&&model.getScaleComponent(channel);if(scaleComponent){const scaleType=scaleComponent.get("type");const{aggregate:aggregate}=fieldDef;const invalidDataMode=getScaleInvalidDataMode({scaleChannel:channel,markDef:markDef,config:config,scaleType:scaleType,isCountAggregate:isCountingAggregateOp(aggregate)});if(invalidDataMode!=="show"&&invalidDataMode!=="always-valid"){aggregator[fieldDef.field]=fieldDef}}return aggregator},{});if(!keys(filter).length){return null}return new filterinvalid_FilterInvalidNode(parent,filter)}dependentFields(){return new Set(keys(this.filter))}producedFields(){return new Set}hash(){return`FilterInvalid ${hash(this.filter)}`}assemble(){const filters=keys(this.filter).reduce((vegaFilters,field)=>{const fieldDef=this.filter[field];const ref=vgField(fieldDef,{expr:"datum"});if(fieldDef!==null){if(fieldDef.type==="temporal"){vegaFilters.push(`(isDate(${ref}) || (${isValidFiniteNumberExpr(ref)}))`)}else if(fieldDef.type==="quantitative"){vegaFilters.push(isValidFiniteNumberExpr(ref))}else{}}return vegaFilters},[]);return filters.length>0?{type:"filter",expr:filters.join(" && ")}:null}}function isValidFiniteNumberExpr(ref){return`isValid(${ref}) && isFinite(+${ref})`}function stack_defineProperty(e,r,t){return(r=stack_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function stack_toPropertyKey(t){var i=stack_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function stack_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}function getStackByFields(model){return model.stack.stackBy.reduce((fields,by)=>{const fieldDef=by.fieldDef;const _field=vgField(fieldDef);if(_field){fields.push(_field)}return fields},[])}function isValidAsArray(as){return Object(vega_util["isArray"])(as)&&as.every(s=>Object(vega_util["isString"])(s))&&as.length>1}class stack_StackNode extends dataflow_DataFlowNode{clone(){return new stack_StackNode(null,duplicate(this._stack))}constructor(parent,stack){super(parent);stack_defineProperty(this,"_stack",void 0);this._stack=stack}static makeFromTransform(parent,stackTransform){const{stack:stack,groupby:groupby,as:as,offset:offset="zero"}=stackTransform;const sortFields=[];const sortOrder=[];if(stackTransform.sort!==undefined){for(const sortField of stackTransform.sort){sortFields.push(sortField.field);sortOrder.push(getFirstDefined(sortField.order,"ascending"))}}const sort={field:sortFields,order:sortOrder};let normalizedAs;if(isValidAsArray(as)){normalizedAs=as}else if(Object(vega_util["isString"])(as)){normalizedAs=[as,`${as}_end`]}else{normalizedAs=[`${stackTransform.stack}_start`,`${stackTransform.stack}_end`]}return new stack_StackNode(parent,{dimensionFieldDefs:[],stackField:stack,groupby:groupby,offset:offset,sort:sort,facetby:[],as:normalizedAs})}static makeFromEncoding(parent,model){const stackProperties=model.stack;const{encoding:encoding}=model;if(!stackProperties){return null}const{groupbyChannels:groupbyChannels,fieldChannel:fieldChannel,offset:offset,impute:impute}=stackProperties;const dimensionFieldDefs=groupbyChannels.map(groupbyChannel=>{const cDef=encoding[groupbyChannel];return getFieldDef(cDef)}).filter(def=>!!def);const stackby=getStackByFields(model);const orderDef=model.encoding.order;let sort;if(Object(vega_util["isArray"])(orderDef)||isFieldDef(orderDef)){sort=sortParams(orderDef)}else{const sortOrder=isOrderOnlyDef(orderDef)?orderDef.sort:fieldChannel==="y"?"descending":"ascending";sort=stackby.reduce((s,field)=>{if(!s.field.includes(field)){s.field.push(field);s.order.push(sortOrder)}return s},{field:[],order:[]})}return new stack_StackNode(parent,{dimensionFieldDefs:dimensionFieldDefs,stackField:model.vgField(fieldChannel),facetby:[],stackby:stackby,sort:sort,offset:offset,impute:impute,as:[model.vgField(fieldChannel,{suffix:"start",forAs:true}),model.vgField(fieldChannel,{suffix:"end",forAs:true})]})}get stack(){return this._stack}addDimensions(fields){this._stack.facetby.push(...fields)}dependentFields(){const out=new Set;out.add(this._stack.stackField);this.getGroupbyFields().forEach(out.add,out);this._stack.facetby.forEach(out.add,out);this._stack.sort.field.forEach(out.add,out);return out}producedFields(){return new Set(this._stack.as)}hash(){return`Stack ${hash(this._stack)}`}getGroupbyFields(){const{dimensionFieldDefs:dimensionFieldDefs,impute:impute,groupby:groupby}=this._stack;if(dimensionFieldDefs.length>0){return dimensionFieldDefs.map(dimensionFieldDef=>{if(dimensionFieldDef.bin){if(impute){return[vgField(dimensionFieldDef,{binSuffix:"mid"})]}return[vgField(dimensionFieldDef,{}),vgField(dimensionFieldDef,{binSuffix:"end"})]}return[vgField(dimensionFieldDef)]}).flat()}return groupby!==null&&groupby!==void 0?groupby:[]}assemble(){const transform=[];const{facetby:facetby,dimensionFieldDefs:dimensionFieldDefs,stackField:field,stackby:stackby,sort:sort,offset:offset,impute:impute,as:as}=this._stack;if(impute){for(const dimensionFieldDef of dimensionFieldDefs){const{bandPosition:bandPosition=.5,bin:bin}=dimensionFieldDef;if(bin){const binStart=vgField(dimensionFieldDef,{expr:"datum"});const binEnd=vgField(dimensionFieldDef,{expr:"datum",binSuffix:"end"});transform.push({type:"formula",expr:`${isValidFiniteNumberExpr(binStart)} ? ${bandPosition}*${binStart}+${1-bandPosition}*${binEnd} : ${binStart}`,as:vgField(dimensionFieldDef,{binSuffix:"mid",forAs:true})})}transform.push({type:"impute",field:field,groupby:[...stackby,...facetby],key:vgField(dimensionFieldDef,{binSuffix:"mid"}),method:"value",value:0})}}transform.push({type:"stack",groupby:[...this.getGroupbyFields(),...facetby],field:field,sort:sort,as:as,offset:offset});return transform}}class window_WindowTransformNode extends dataflow_DataFlowNode{clone(){return new window_WindowTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}addDimensions(fields){this.transform.groupby=unique(this.transform.groupby.concat(fields),d=>d)}dependentFields(){var _this$transform$group,_this$transform$sort;const out=new Set;((_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]).forEach(out.add,out);((_this$transform$sort=this.transform.sort)!==null&&_this$transform$sort!==void 0?_this$transform$sort:[]).forEach(m=>out.add(m.field));this.transform.window.map(w=>w.field).filter(f=>f!==undefined).forEach(out.add,out);return out}producedFields(){return new Set(this.transform.window.map(this.getDefaultName))}getDefaultName(windowFieldDef){var _windowFieldDef$as;return(_windowFieldDef$as=windowFieldDef.as)!==null&&_windowFieldDef$as!==void 0?_windowFieldDef$as:vgField(windowFieldDef)}hash(){return`WindowTransform ${hash(this.transform)}`}assemble(){const fields=[];const ops=[];const as=[];const params=[];for(const window of this.transform.window){ops.push(window.op);as.push(this.getDefaultName(window));params.push(window.param===undefined?null:window.param);fields.push(window.field===undefined?null:window.field)}const frame=this.transform.frame;const groupby=this.transform.groupby;if(frame&&frame[0]===null&&frame[1]===null&&ops.every(o=>isAggregateOp(o))){return{type:"joinaggregate",as:as,ops:ops,fields:fields,...groupby!==undefined?{groupby:groupby}:{}}}const sortFields=[];const sortOrder=[];if(this.transform.sort!==undefined){for(const sortField of this.transform.sort){var _sortField$order;sortFields.push(sortField.field);sortOrder.push((_sortField$order=sortField.order)!==null&&_sortField$order!==void 0?_sortField$order:"ascending")}}const sort={field:sortFields,order:sortOrder};const ignorePeers=this.transform.ignorePeers;return{type:"window",params:params,as:as,ops:ops,fields:fields,sort:sort,...ignorePeers!==undefined?{ignorePeers:ignorePeers}:{},...groupby!==undefined?{groupby:groupby}:{},...frame!==undefined?{frame:frame}:{}}}}function cloneSubtree(facet){function clone(node){if(!(node instanceof facet_FacetNode)){const copy=node.clone();if(copy instanceof dataflow_OutputNode){const newName=FACET_SCALE_PREFIX+copy.getSource();copy.setSource(newName);facet.model.component.data.outputNodes[newName]=copy}else if(copy instanceof aggregate_AggregateNode||copy instanceof stack_StackNode||copy instanceof window_WindowTransformNode||copy instanceof joinaggregate_JoinAggregateTransformNode){copy.addDimensions(facet.fields)}for(const n of node.children.flatMap(clone)){n.parent=copy}return[copy]}return node.children.flatMap(clone)}return clone}function moveFacetDown(node){if(node instanceof facet_FacetNode){if(node.numChildren()===1&&!(node.children[0]instanceof dataflow_OutputNode)){const child=node.children[0];if(child instanceof aggregate_AggregateNode||child instanceof stack_StackNode||child instanceof window_WindowTransformNode||child instanceof joinaggregate_JoinAggregateTransformNode){child.addDimensions(node.fields)}child.swapWithParent();moveFacetDown(node)}else{const facetMain=node.model.component.data.main;moveMainDownToFacet(facetMain);const cloner=cloneSubtree(node);const copy=node.children.map(cloner).flat();for(const c of copy){c.parent=facetMain}}}else{node.children.map(moveFacetDown)}}function moveMainDownToFacet(node){if(node instanceof dataflow_OutputNode&&node.type===DataSourceType.Main){if(node.numChildren()===1){const child=node.children[0];if(!(child instanceof facet_FacetNode)){child.swapWithParent();moveMainDownToFacet(node)}}}}const FACET_SCALE_PREFIX="scale_";const MAX_OPTIMIZATION_RUNS=5;function checkLinks(nodes){for(const node of nodes){for(const child of node.children){if(child.parent!==node){return false}}if(!checkLinks(node.children)){return false}}return true}function runOptimizer(optimizer,nodes){let modified=false;for(const node of nodes){modified=optimizer.optimize(node)||modified}return modified}function optimizationDataflowHelper(dataComponent,model,firstPass){let roots=dataComponent.sources;let modified=false;modified=runOptimizer(new optimizers_RemoveUnnecessaryOutputNodes,roots)||modified;modified=runOptimizer(new optimizers_RemoveUnnecessaryIdentifierNodes(model),roots)||modified;roots=roots.filter(r=>r.numChildren()>0);modified=runOptimizer(new optimizers_RemoveUnusedSubtrees,roots)||modified;roots=roots.filter(r=>r.numChildren()>0);if(!firstPass){modified=runOptimizer(new optimizers_MoveParseUp,roots)||modified;modified=runOptimizer(new optimizers_MergeBins(model),roots)||modified;modified=runOptimizer(new optimizers_RemoveDuplicateTimeUnits,roots)||modified;modified=runOptimizer(new optimizers_MergeParse,roots)||modified;modified=runOptimizer(new optimizers_MergeAggregates,roots)||modified;modified=runOptimizer(new optimizers_MergeTimeUnits,roots)||modified;modified=runOptimizer(new optimizers_MergeIdenticalNodes,roots)||modified;modified=runOptimizer(new optimizers_MergeOutputs,roots)||modified}dataComponent.sources=roots;return modified}function optimizeDataflow(data,model){checkLinks(data.sources);let firstPassCounter=0;let secondPassCounter=0;for(let i=0;i<MAX_OPTIMIZATION_RUNS;i++){if(!optimizationDataflowHelper(data,model,true)){break}firstPassCounter++}data.sources.map(moveFacetDown);for(let i=0;i<MAX_OPTIMIZATION_RUNS;i++){if(!optimizationDataflowHelper(data,model,false)){break}secondPassCounter++}checkLinks(data.sources);if(Math.max(firstPassCounter,secondPassCounter)===MAX_OPTIMIZATION_RUNS){warn(`Maximum optimization runs(${MAX_OPTIMIZATION_RUNS}) reached.`)}}function signal_defineProperty(e,r,t){return(r=signal_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function signal_toPropertyKey(t){var i=signal_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function signal_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class SignalRefWrapper{constructor(exprGenerator){signal_defineProperty(this,"signal",void 0);Object.defineProperty(this,"signal",{enumerable:true,get:exprGenerator})}static fromName(rename,signalName){return new SignalRefWrapper(()=>rename(signalName))}}function parseScaleDomain(model){if(isUnitModel(model)){parseUnitScaleDomain(model)}else{parseNonUnitScaleDomain(model)}}function parseUnitScaleDomain(model){const localScaleComponents=model.component.scales;for(const channel of keys(localScaleComponents)){const domains=parseDomainForChannel(model,channel);const localScaleCmpt=localScaleComponents[channel];localScaleCmpt.setWithExplicit("domains",domains);parseSelectionDomain(model,channel);if(model.component.data.isFaceted){let facetParent=model;while(!isFacetModel(facetParent)&&facetParent.parent){facetParent=facetParent.parent}const resolve=facetParent.component.resolve.scale[channel];if(resolve==="shared"){for(const domain of domains.value){if(isDataRefDomain(domain)){domain.data=FACET_SCALE_PREFIX+domain.data.replace(FACET_SCALE_PREFIX,"")}}}}}}function parseNonUnitScaleDomain(model){for(const child of model.children){parseScaleDomain(child)}const localScaleComponents=model.component.scales;for(const channel of keys(localScaleComponents)){let domains;let selectionExtent=null;for(const child of model.children){const childComponent=child.component.scales[channel];if(childComponent){if(domains===undefined){domains=childComponent.getWithExplicit("domains")}else{domains=mergeValuesWithExplicit(domains,childComponent.getWithExplicit("domains"),"domains","scale",domainsTieBreaker)}const se=childComponent.get("selectionExtent");if(selectionExtent&&se&&selectionExtent.param!==se.param){warn(message_namespaceObject.NEEDS_SAME_SELECTION)}selectionExtent=se}}localScaleComponents[channel].setWithExplicit("domains",domains);if(selectionExtent){localScaleComponents[channel].set("selectionExtent",selectionExtent,true)}}}function normalizeUnaggregatedDomain(domain,fieldDef,scaleType,scaleConfig){if(domain==="unaggregated"){const{valid:valid,reason:reason}=canUseUnaggregatedDomain(fieldDef,scaleType);if(!valid){warn(reason);return undefined}}else if(domain===undefined&&scaleConfig.useUnaggregatedDomain){const{valid:valid}=canUseUnaggregatedDomain(fieldDef,scaleType);if(valid){return"unaggregated"}}return domain}function parseDomainForChannel(model,channel){const scaleType=model.getScaleComponent(channel).get("type");const{encoding:encoding}=model;const domain=normalizeUnaggregatedDomain(model.scaleDomain(channel),model.typedFieldDef(channel),scaleType,model.config.scale);if(domain!==model.scaleDomain(channel)){model.specifiedScales[channel]={...model.specifiedScales[channel],domain:domain}}if(channel==="x"&&getFieldOrDatumDef(encoding.x2)){if(getFieldOrDatumDef(encoding.x)){return mergeValuesWithExplicit(parseSingleChannelDomain(scaleType,domain,model,"x"),parseSingleChannelDomain(scaleType,domain,model,"x2"),"domain","scale",domainsTieBreaker)}else{return parseSingleChannelDomain(scaleType,domain,model,"x2")}}else if(channel==="y"&&getFieldOrDatumDef(encoding.y2)){if(getFieldOrDatumDef(encoding.y)){return mergeValuesWithExplicit(parseSingleChannelDomain(scaleType,domain,model,"y"),parseSingleChannelDomain(scaleType,domain,model,"y2"),"domain","scale",domainsTieBreaker)}else{return parseSingleChannelDomain(scaleType,domain,model,"y2")}}return parseSingleChannelDomain(scaleType,domain,model,channel)}function mapDomainToDataSignal(domain,type,timeUnit){return domain.map(v=>{const data=valueExpr(v,{timeUnit:timeUnit,type:type});return{signal:`{data: ${data}}`}})}function convertDomainIfItIsDateTime(domain,type,timeUnit){var _normalizeTimeUnit;const normalizedTimeUnit=(_normalizeTimeUnit=normalizeTimeUnit(timeUnit))===null||_normalizeTimeUnit===void 0?void 0:_normalizeTimeUnit.unit;if(type==="temporal"||normalizedTimeUnit){return mapDomainToDataSignal(domain,type,normalizedTimeUnit)}return[domain]}function parseSingleChannelDomain(scaleType,domain,model,channel){const{encoding:encoding,markDef:markDef,mark:mark,config:config,stack:stack}=model;const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);const{type:type}=fieldOrDatumDef;const timeUnit=fieldOrDatumDef["timeUnit"];const dataSourceTypeForScaleDomain=getScaleDataSourceForHandlingInvalidValues({invalid:getMarkConfig("invalid",markDef,config),isPath:isPathMark(mark)});if(isDomainUnionWith(domain)){const defaultDomain=parseSingleChannelDomain(scaleType,undefined,model,channel);const unionWith=convertDomainIfItIsDateTime(domain.unionWith,type,timeUnit);return makeExplicit([...unionWith,...defaultDomain.value])}else if(isSignalRef(domain)){return makeExplicit([domain])}else if(domain&&domain!=="unaggregated"&&!isParameterDomain(domain)){return makeExplicit(convertDomainIfItIsDateTime(domain,type,timeUnit))}if(stack&&channel===stack.fieldChannel){if(stack.offset==="normalize"){return makeImplicit([[0,1]])}const data=model.requestDataName(dataSourceTypeForScaleDomain);return makeImplicit([{data:data,field:model.vgField(channel,{suffix:"start"})},{data:data,field:model.vgField(channel,{suffix:"end"})}])}const sort=isScaleChannel(channel)&&isFieldDef(fieldOrDatumDef)?domainSort(model,channel,scaleType):undefined;if(isDatumDef(fieldOrDatumDef)){const d=convertDomainIfItIsDateTime([fieldOrDatumDef.datum],type,timeUnit);return makeImplicit(d)}const fieldDef=fieldOrDatumDef;if(domain==="unaggregated"){const{field:field}=fieldOrDatumDef;return makeImplicit([{data:model.requestDataName(dataSourceTypeForScaleDomain),field:vgField({field:field,aggregate:"min"})},{data:model.requestDataName(dataSourceTypeForScaleDomain),field:vgField({field:field,aggregate:"max"})}])}else if(isBinning(fieldDef.bin)){if(hasDiscreteDomain(scaleType)){if(scaleType==="bin-ordinal"){return makeImplicit([])}return makeImplicit([{data:isBoolean(sort)?model.requestDataName(dataSourceTypeForScaleDomain):model.requestDataName(DataSourceType.Raw),field:model.vgField(channel,binRequiresRange(fieldDef,channel)?{binSuffix:"range"}:{}),sort:sort===true||!Object(vega_util["isObject"])(sort)?{field:model.vgField(channel,{}),op:"min"}:sort}])}else{const{bin:bin}=fieldDef;if(isBinning(bin)){const binSignal=getBinSignalName(model,fieldDef.field,bin);return makeImplicit([new SignalRefWrapper(()=>{const signal=model.getSignalName(binSignal);return`[${signal}.start, ${signal}.stop]`})])}else{return makeImplicit([{data:model.requestDataName(dataSourceTypeForScaleDomain),field:model.vgField(channel,{})}])}}}else if(fieldDef.timeUnit&&util_contains(["time","utc"],scaleType)){const fieldDef2=encoding[getSecondaryRangeChannel(channel)];if(hasBandEnd(fieldDef,fieldDef2,markDef,config)){const data=model.requestDataName(dataSourceTypeForScaleDomain);const bandPosition=getBandPosition({fieldDef:fieldDef,fieldDef2:fieldDef2,markDef:markDef,config:config});const isRectWithOffset=isRectBasedMark(mark)&&bandPosition!==.5&&isXorY(channel);return makeImplicit([{data:data,field:model.vgField(channel,isRectWithOffset?{suffix:OFFSETTED_RECT_START_SUFFIX}:{})},{data:data,field:model.vgField(channel,{suffix:isRectWithOffset?OFFSETTED_RECT_END_SUFFIX:"end"})}])}}if(sort){return makeImplicit([{data:isBoolean(sort)?model.requestDataName(dataSourceTypeForScaleDomain):model.requestDataName(DataSourceType.Raw),field:model.vgField(channel),sort:sort}])}else{return makeImplicit([{data:model.requestDataName(dataSourceTypeForScaleDomain),field:model.vgField(channel)}])}}function normalizeSortField(sort,isStackedMeasure){const{op:op,field:field,order:order}=sort;return{op:op!==null&&op!==void 0?op:isStackedMeasure?"sum":DEFAULT_SORT_OP,...field?{field:replacePathInField(field)}:{},...order?{order:order}:{}}}function parseSelectionDomain(model,channel){var _model$fieldDef;const scale=model.component.scales[channel];const spec=model.specifiedScales[channel].domain;const bin=(_model$fieldDef=model.fieldDef(channel))===null||_model$fieldDef===void 0?void 0:_model$fieldDef.bin;const domain=isParameterDomain(spec)?spec:undefined;const extent=isBinParams(bin)&&isParameterExtent(bin.extent)?bin.extent:undefined;if(domain||extent){scale.set("selectionExtent",domain!==null&&domain!==void 0?domain:extent,true)}}function domainSort(model,channel,scaleType){if(!hasDiscreteDomain(scaleType)){return undefined}const fieldDef=model.fieldDef(channel);const sort=fieldDef.sort;if(isSortArray(sort)){return{op:"min",field:sortArrayIndexField(fieldDef,channel),order:"ascending"}}const{stack:stack}=model;const stackDimensions=stack?new Set([...stack.groupbyFields,...stack.stackBy.map(s=>s.fieldDef.field)]):undefined;if(isSortField(sort)){const isStackedMeasure=stack&&!stackDimensions.has(sort.field);return normalizeSortField(sort,isStackedMeasure)}else if(isSortByEncoding(sort)){const{encoding:encoding,order:order}=sort;const fieldDefToSortBy=model.fieldDef(encoding);const{aggregate:aggregate,field:field}=fieldDefToSortBy;const isStackedMeasure=stack&&!stackDimensions.has(field);if(isArgminDef(aggregate)||isArgmaxDef(aggregate)){return normalizeSortField({field:vgField(fieldDefToSortBy),order:order},isStackedMeasure)}else if(isAggregateOp(aggregate)||!aggregate){return normalizeSortField({op:aggregate,field:field,order:order},isStackedMeasure)}}else if(sort==="descending"){return{op:"min",field:model.vgField(channel),order:"descending"}}else if(util_contains(["ascending",undefined],sort)){return true}return undefined}function canUseUnaggregatedDomain(fieldDef,scaleType){const{aggregate:aggregate,type:type}=fieldDef;if(!aggregate){return{valid:false,reason:message_namespaceObject.unaggregateDomainHasNoEffectForRawField(fieldDef)}}if(Object(vega_util["isString"])(aggregate)&&!SHARED_DOMAIN_OPS.has(aggregate)){return{valid:false,reason:message_namespaceObject.unaggregateDomainWithNonSharedDomainOp(aggregate)}}if(type==="quantitative"){if(scaleType==="log"){return{valid:false,reason:message_namespaceObject.unaggregatedDomainWithLogScale(fieldDef)}}}return{valid:true}}function domainsTieBreaker(v1,v2,property,propertyOf){if(v1.explicit&&v2.explicit){warn(message_namespaceObject.mergeConflictingDomainProperty(property,propertyOf,v1.value,v2.value))}return{explicit:v1.explicit,value:[...v1.value,...v2.value]}}function mergeDomains(domains){const uniqueDomains=unique(domains.map(domain=>{if(isDataRefDomain(domain)){const{sort:_s,...domainWithoutSort}=domain;return domainWithoutSort}return domain}),hash);const sorts=unique(domains.map(d=>{if(isDataRefDomain(d)){const s=d.sort;if(s!==undefined&&!isBoolean(s)){if("op"in s&&s.op==="count"){delete s.field}if(s.order==="ascending"){delete s.order}}return s}return undefined}).filter(s=>s!==undefined),hash);if(uniqueDomains.length===0){return undefined}else if(uniqueDomains.length===1){const domain=domains[0];if(isDataRefDomain(domain)&&sorts.length>0){let sort=sorts[0];if(sorts.length>1){warn(message_namespaceObject.MORE_THAN_ONE_SORT);const filteredSorts=sorts.filter(s=>Object(vega_util["isObject"])(s)&&"op"in s&&s.op!=="min");if(sorts.every(s=>Object(vega_util["isObject"])(s)&&"op"in s)&&filteredSorts.length===1){sort=filteredSorts[0]}else{sort=true}}else{if(Object(vega_util["isObject"])(sort)&&"field"in sort){const sortField=sort.field;if(domain.field===sortField){sort=sort.order?{order:sort.order}:true}}}return{...domain,sort:sort}}return domain}const unionDomainSorts=unique(sorts.map(s=>{if(isBoolean(s)||!("op"in s)||Object(vega_util["isString"])(s.op)&&Object(vega_util["hasOwnProperty"])(MULTIDOMAIN_SORT_OP_INDEX,s.op)){return s}warn(message_namespaceObject.domainSortDropped(s));return true}),hash);let sort;if(unionDomainSorts.length===1){sort=unionDomainSorts[0]}else if(unionDomainSorts.length>1){warn(message_namespaceObject.MORE_THAN_ONE_SORT);sort=true}const allData=unique(domains.map(d=>{if(isDataRefDomain(d)){return d.data}return null}),x=>x);if(allData.length===1&&allData[0]!==null){const domain={data:allData[0],fields:uniqueDomains.map(d=>d.field),...sort?{sort:sort}:{}};return domain}return{fields:uniqueDomains,...sort?{sort:sort}:{}}}function getFieldFromDomain(domain){if(isDataRefDomain(domain)&&Object(vega_util["isString"])(domain.field)){return domain.field}else if(isDataRefUnionedDomain(domain)){let field;for(const nonUnionDomain of domain.fields){if(isDataRefDomain(nonUnionDomain)&&Object(vega_util["isString"])(nonUnionDomain.field)){if(!field){field=nonUnionDomain.field}else if(field!==nonUnionDomain.field){warn(message_namespaceObject.FACETED_INDEPENDENT_DIFFERENT_SOURCES);return field}}}warn(message_namespaceObject.FACETED_INDEPENDENT_SAME_FIELDS_DIFFERENT_SOURCES);return field}else if(isFieldRefUnionDomain(domain)){warn(message_namespaceObject.FACETED_INDEPENDENT_SAME_SOURCE);const field=domain.fields[0];return Object(vega_util["isString"])(field)?field:undefined}return undefined}function assembleDomain(model,channel){const scaleComponent=model.component.scales[channel];const domains=scaleComponent.get("domains").map(domain=>{if(isDataRefDomain(domain)){domain.data=model.lookupDataSource(domain.data)}return domain});return mergeDomains(domains)}function assembleScales(model){if(isLayerModel(model)||isConcatModel(model)){return model.children.reduce((scales,child)=>scales.concat(assembleScales(child)),assembleScalesForModel(model))}else{return assembleScalesForModel(model)}}function assembleScalesForModel(model){return keys(model.component.scales).reduce((scales,channel)=>{const scaleComponent=model.component.scales[channel];if(scaleComponent.merged){return scales}const scale=scaleComponent.combine();const{name:name,type:type,selectionExtent:selectionExtent,domains:_d,range:_r,reverse:reverse,...otherScaleProps}=scale;const range=assembleScaleRange(scale.range,name,channel,model);const domain=assembleDomain(model,channel);const domainRaw=selectionExtent?assembleSelectionScaleDomain(model,selectionExtent,scaleComponent,domain):null;scales.push({name:name,type:type,...domain?{domain:domain}:{},...domainRaw?{domainRaw:domainRaw}:{},range:range,...reverse!==undefined?{reverse:reverse}:{},...otherScaleProps});return scales},[])}function assembleScaleRange(scaleRange,scaleName,channel,model){if(isXorY(channel)){if(isVgRangeStep(scaleRange)){return{step:{signal:`${scaleName}_step`}}}}else if(Object(vega_util["isObject"])(scaleRange)&&isDataRefDomain(scaleRange)){return{...scaleRange,data:model.lookupDataSource(scaleRange.data)}}return scaleRange}function scale_component_defineProperty(e,r,t){return(r=scale_component_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function scale_component_toPropertyKey(t){var i=scale_component_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function scale_component_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class component_ScaleComponent extends split_Split{constructor(name,typeWithExplicit){super({},{name:name});scale_component_defineProperty(this,"merged",false);this.setWithExplicit("type",typeWithExplicit)}domainHasZero(){const scaleType=this.get("type");if(util_contains([ScaleType.LOG,ScaleType.TIME,ScaleType.UTC],scaleType)){return"definitely-not"}const scaleZero=this.get("zero");if(scaleZero===true||scaleZero===undefined&&util_contains([ScaleType.LINEAR,ScaleType.SQRT,ScaleType.POW],scaleType)){return"definitely"}const domains=this.get("domains");if(domains.length>0){let hasExplicitDomainWithZero=false;let hasExplicitDomainWithoutZero=false;let hasDomainBasedOnField=false;for(const d of domains){if(Object(vega_util["isArray"])(d)){const first=d[0];const last=d[d.length-1];if(Object(vega_util["isNumber"])(first)&&Object(vega_util["isNumber"])(last)){if(first<=0&&last>=0){hasExplicitDomainWithZero=true;continue}else{hasExplicitDomainWithoutZero=true;continue}}}hasDomainBasedOnField=true}if(hasExplicitDomainWithZero){return"definitely"}else if(hasExplicitDomainWithoutZero&&!hasDomainBasedOnField){return"definitely-not"}}return"maybe"}}const RANGE_PROPERTIES=["range","scheme"];function parseUnitScaleRange(model){const localScaleComponents=model.component.scales;for(const channel of SCALE_CHANNELS){const localScaleCmpt=localScaleComponents[channel];if(!localScaleCmpt){continue}const rangeWithExplicit=parseRangeForChannel(channel,model);localScaleCmpt.setWithExplicit("range",rangeWithExplicit)}}function getBinStepSignal(model,channel){const fieldDef=model.fieldDef(channel);if(fieldDef!==null&&fieldDef!==void 0&&fieldDef.bin){const{bin:bin,field:field}=fieldDef;const sizeType=getSizeChannel(channel);const sizeSignal=model.getName(sizeType);if(Object(vega_util["isObject"])(bin)&&bin.binned&&bin.step!==undefined){return new SignalRefWrapper(()=>{const scaleName=model.scaleName(channel);const binCount=`(domain("${scaleName}")[1] - domain("${scaleName}")[0]) / ${bin.step}`;return`${model.getSignalName(sizeSignal)} / (${binCount})`})}else if(isBinning(bin)){const binSignal=getBinSignalName(model,field,bin);return new SignalRefWrapper(()=>{const updatedName=model.getSignalName(binSignal);const binCount=`(${updatedName}.stop - ${updatedName}.start) / ${updatedName}.step`;return`${model.getSignalName(sizeSignal)} / (${binCount})`})}}return undefined}function parseRangeForChannel(channel,model){const specifiedScale=model.specifiedScales[channel];const{size:size}=model;const mergedScaleCmpt=model.getScaleComponent(channel);const scaleType=mergedScaleCmpt.get("type");for(const property of RANGE_PROPERTIES){if(specifiedScale[property]!==undefined){const supportedByScaleType=scaleTypeSupportProperty(scaleType,property);const channelIncompatability=channelScalePropertyIncompatability(channel,property);if(!supportedByScaleType){warn(message_namespaceObject.scalePropertyNotWorkWithScaleType(scaleType,property,channel))}else if(channelIncompatability){warn(channelIncompatability)}else{switch(property){case"range":{const range=specifiedScale.range;if(Object(vega_util["isArray"])(range)){if(isXorY(channel)){return makeExplicit(range.map(v=>{if(v==="width"||v==="height"){const sizeSignal=model.getName(v);const getSignalName=model.getSignalName.bind(model);return SignalRefWrapper.fromName(getSignalName,sizeSignal)}return v}))}}else if(Object(vega_util["isObject"])(range)){return makeExplicit({data:model.requestDataName(DataSourceType.Main),field:range.field,sort:{op:"min",field:model.vgField(channel)}})}return makeExplicit(range)}case"scheme":return makeExplicit(parseScheme(specifiedScale[property]))}}}}const sizeChannel=channel===X||channel==="xOffset"?"width":"height";const sizeValue=size[sizeChannel];if(isStep(sizeValue)){if(isXorY(channel)){if(hasDiscreteDomain(scaleType)){const step=getPositionStep(sizeValue,model,channel);if(step){return makeExplicit({step:step})}}else{warn(message_namespaceObject.stepDropped(sizeChannel))}}else if(isXorYOffset(channel)){const positionChannel=channel===XOFFSET?"x":"y";const positionScaleCmpt=model.getScaleComponent(positionChannel);const positionScaleType=positionScaleCmpt.get("type");if(positionScaleType==="band"){const step=getOffsetStep(sizeValue,scaleType);if(step){return makeExplicit(step)}}}}const{rangeMin:rangeMin,rangeMax:rangeMax}=specifiedScale;const d=defaultRange(channel,model);if((rangeMin!==undefined||rangeMax!==undefined)&&scaleTypeSupportProperty(scaleType,"rangeMin")&&Object(vega_util["isArray"])(d)&&d.length===2){return makeExplicit([rangeMin!==null&&rangeMin!==void 0?rangeMin:d[0],rangeMax!==null&&rangeMax!==void 0?rangeMax:d[1]])}return makeImplicit(d)}function parseScheme(scheme){if(isExtendedScheme(scheme)){return{scheme:scheme.name,...omit(scheme,["name"])}}return{scheme:scheme}}function fullWidthOrHeightRange(channel,model,scaleType){let{center:center}=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};const sizeType=getSizeChannel(channel);const sizeSignal=model.getName(sizeType);const getSignalName=model.getSignalName.bind(model);if(channel===Y&&hasContinuousDomain(scaleType)){return center?[SignalRefWrapper.fromName(name=>`${getSignalName(name)}/2`,sizeSignal),SignalRefWrapper.fromName(name=>`-${getSignalName(name)}/2`,sizeSignal)]:[SignalRefWrapper.fromName(getSignalName,sizeSignal),0]}else{return center?[SignalRefWrapper.fromName(name=>`-${getSignalName(name)}/2`,sizeSignal),SignalRefWrapper.fromName(name=>`${getSignalName(name)}/2`,sizeSignal)]:[0,SignalRefWrapper.fromName(getSignalName,sizeSignal)]}}function defaultRange(channel,model){const{size:size,config:config,mark:mark,encoding:encoding}=model;const{type:type}=getFieldOrDatumDef(encoding[channel]);const mergedScaleCmpt=model.getScaleComponent(channel);const scaleType=mergedScaleCmpt.get("type");const{domain:domain,domainMid:domainMid}=model.specifiedScales[channel];switch(channel){case X:case Y:{if(util_contains(["point","band"],scaleType)){const positionSize=getDiscretePositionSize(channel,size,config.view);if(isStep(positionSize)){const step=getPositionStep(positionSize,model,channel);return{step:step}}}return fullWidthOrHeightRange(channel,model,scaleType)}case XOFFSET:case YOFFSET:return getOffsetRange(channel,model,scaleType);case SIZE:{const rangeMin=sizeRangeMin(mark,config);const rangeMax=sizeRangeMax(mark,size,model,config);if(isContinuousToDiscrete(scaleType)){return interpolateRange(rangeMin,rangeMax,defaultContinuousToDiscreteCount(scaleType,config,domain,channel))}else{return[rangeMin,rangeMax]}}case THETA:return[0,Math.PI*2];case ANGLE:return[0,360];case RADIUS:{return[0,new SignalRefWrapper(()=>{const w=model.getSignalName(isFacetModel(model.parent)?"child_width":"width");const h=model.getSignalName(isFacetModel(model.parent)?"child_height":"height");return`min(${w},${h})/2`})]}case TIME:{return{step:1e3/config.scale.framesPerSecond}}case STROKEWIDTH:return[config.scale.minStrokeWidth,config.scale.maxStrokeWidth];case STROKEDASH:return[[1,0],[4,2],[2,1],[1,1],[1,2,4,2]];case SHAPE:return"symbol";case COLOR:case FILL:case STROKE:if(scaleType==="ordinal"){return type==="nominal"?"category":"ordinal"}else{if(domainMid!==undefined){return"diverging"}else{return mark==="rect"||mark==="geoshape"?"heatmap":"ramp"}}case OPACITY:case FILLOPACITY:case STROKEOPACITY:return[config.scale.minOpacity,config.scale.maxOpacity]}}function getPositionStep(step,model,channel){const{encoding:encoding}=model;const mergedScaleCmpt=model.getScaleComponent(channel);const offsetChannel=getOffsetScaleChannel(channel);const offsetDef=encoding[offsetChannel];const stepFor=getStepFor({step:step,offsetIsDiscrete:isFieldOrDatumDef(offsetDef)&&isDiscrete(offsetDef.type)});if(stepFor==="offset"&&channelHasFieldOrDatum(encoding,offsetChannel)){var _mergedScaleCmpt$get;const offsetScaleCmpt=model.getScaleComponent(offsetChannel);const offsetScaleName=model.scaleName(offsetChannel);let stepCount=`domain('${offsetScaleName}').length`;if(offsetScaleCmpt.get("type")==="band"){var _ref,_offsetScaleCmpt$get,_ref2,_offsetScaleCmpt$get2;const offsetPaddingInner=(_ref=(_offsetScaleCmpt$get=offsetScaleCmpt.get("paddingInner"))!==null&&_offsetScaleCmpt$get!==void 0?_offsetScaleCmpt$get:offsetScaleCmpt.get("padding"))!==null&&_ref!==void 0?_ref:0;const offsetPaddingOuter=(_ref2=(_offsetScaleCmpt$get2=offsetScaleCmpt.get("paddingOuter"))!==null&&_offsetScaleCmpt$get2!==void 0?_offsetScaleCmpt$get2:offsetScaleCmpt.get("padding"))!==null&&_ref2!==void 0?_ref2:0;stepCount=`bandspace(${stepCount}, ${offsetPaddingInner}, ${offsetPaddingOuter})`}const paddingInner=(_mergedScaleCmpt$get=mergedScaleCmpt.get("paddingInner"))!==null&&_mergedScaleCmpt$get!==void 0?_mergedScaleCmpt$get:mergedScaleCmpt.get("padding");return{signal:`${step.step} * ${stepCount} / (1-${exprFromSignalRefOrValue(paddingInner)})`}}else{return step.step}}function getOffsetStep(step,offsetScaleType){const stepFor=getStepFor({step:step,offsetIsDiscrete:hasDiscreteDomain(offsetScaleType)});if(stepFor==="offset"){return{step:step.step}}return undefined}function getOffsetRange(channel,model,offsetScaleType){const positionChannel=channel===XOFFSET?"x":"y";const positionScaleCmpt=model.getScaleComponent(positionChannel);if(!positionScaleCmpt){return fullWidthOrHeightRange(positionChannel,model,offsetScaleType,{center:true})}const positionScaleType=positionScaleCmpt.get("type");const positionScaleName=model.scaleName(positionChannel);const{markDef:markDef,config:config}=model;if(positionScaleType==="band"){const size=getDiscretePositionSize(positionChannel,model.size,model.config.view);if(isStep(size)){const step=getOffsetStep(size,offsetScaleType);if(step){return step}}return[0,{signal:`bandwidth('${positionScaleName}')`}]}else{const positionDef=model.encoding[positionChannel];if(isFieldDef(positionDef)&&positionDef.timeUnit){const duration=durationExpr(positionDef.timeUnit,expr=>`scale('${positionScaleName}', ${expr})`);const padding=model.config.scale.bandWithNestedOffsetPaddingInner;const bandPositionOffset=getBandPosition({fieldDef:positionDef,markDef:markDef,config:config})-.5;const bandPositionOffsetExpr=bandPositionOffset!==0?` + ${bandPositionOffset}`:"";if(padding){const startRatio=isSignalRef(padding)?`${padding.signal}/2`+bandPositionOffsetExpr:`${padding/2+bandPositionOffset}`;const endRatio=isSignalRef(padding)?`(1 - ${padding.signal}/2)`+bandPositionOffsetExpr:`${1-padding/2+bandPositionOffset}`;return[{signal:`${startRatio} * (${duration})`},{signal:`${endRatio} * (${duration})`}]}return[0,{signal:duration}]}return never(`Cannot use ${channel} scale if ${positionChannel} scale is not discrete.`)}}function getDiscretePositionSize(channel,size,viewConfig){const sizeChannel=channel===X?"width":"height";const sizeValue=size[sizeChannel];if(sizeValue){return sizeValue}return getViewConfigDiscreteSize(viewConfig,sizeChannel)}function defaultContinuousToDiscreteCount(scaleType,config,domain,channel){switch(scaleType){case"quantile":return config.scale.quantileCount;case"quantize":return config.scale.quantizeCount;case"threshold":if(domain!==undefined&&Object(vega_util["isArray"])(domain)){return domain.length+1}else{warn(message_namespaceObject.domainRequiredForThresholdScale(channel));return 3}}}function interpolateRange(rangeMin,rangeMax,cardinality){const f=()=>{const rMax=signalOrStringValue(rangeMax);const rMin=signalOrStringValue(rangeMin);const step=`(${rMax} - ${rMin}) / (${cardinality} - 1)`;return`sequence(${rMin}, ${rMax} + ${step}, ${step})`};if(isSignalRef(rangeMax)){return new SignalRefWrapper(f)}else{return{signal:f()}}}function sizeRangeMin(mark,config){switch(mark){case"bar":case"tick":return config.scale.minBandSize;case"line":case"trail":case"rule":return config.scale.minStrokeWidth;case"text":return config.scale.minFontSize;case"point":case"square":case"circle":return config.scale.minSize}throw new Error(message_namespaceObject.incompatibleChannel("size",mark))}const MAX_SIZE_RANGE_STEP_RATIO=.95;function sizeRangeMax(mark,size,model,config){const xyStepSignals={x:getBinStepSignal(model,"x"),y:getBinStepSignal(model,"y")};switch(mark){case"bar":case"tick":{if(config.scale.maxBandSize!==undefined){return config.scale.maxBandSize}const min=minXYStep(size,xyStepSignals,config.view);if(Object(vega_util["isNumber"])(min)){return min-1}else{return new SignalRefWrapper(()=>`${min.signal} - 1`)}}case"line":case"trail":case"rule":return config.scale.maxStrokeWidth;case"text":return config.scale.maxFontSize;case"point":case"square":case"circle":{if(config.scale.maxSize){return config.scale.maxSize}const pointStep=minXYStep(size,xyStepSignals,config.view);if(Object(vega_util["isNumber"])(pointStep)){return Math.pow(MAX_SIZE_RANGE_STEP_RATIO*pointStep,2)}else{return new SignalRefWrapper(()=>`pow(${MAX_SIZE_RANGE_STEP_RATIO} * ${pointStep.signal}, 2)`)}}}throw new Error(message_namespaceObject.incompatibleChannel("size",mark))}function minXYStep(size,xyStepSignals,viewConfig){const widthStep=isStep(size.width)?size.width.step:getViewConfigDiscreteStep(viewConfig,"width");const heightStep=isStep(size.height)?size.height.step:getViewConfigDiscreteStep(viewConfig,"height");if(xyStepSignals.x||xyStepSignals.y){return new SignalRefWrapper(()=>{const exprs=[xyStepSignals.x?xyStepSignals.x.signal:widthStep,xyStepSignals.y?xyStepSignals.y.signal:heightStep];return`min(${exprs.join(", ")})`})}return Math.min(widthStep,heightStep)}function parseScaleProperty(model,property){if(isUnitModel(model)){parseUnitScaleProperty(model,property)}else{parseNonUnitScaleProperty(model,property)}}function parseUnitScaleProperty(model,property){const localScaleComponents=model.component.scales;const{config:config,encoding:encoding,markDef:markDef,specifiedScales:specifiedScales}=model;for(const channel of keys(localScaleComponents)){const specifiedScale=specifiedScales[channel];const localScaleCmpt=localScaleComponents[channel];const mergedScaleCmpt=model.getScaleComponent(channel);const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);const specifiedValue=specifiedScale[property];const scaleType=mergedScaleCmpt.get("type");const scalePadding=mergedScaleCmpt.get("padding");const scalePaddingInner=mergedScaleCmpt.get("paddingInner");const supportedByScaleType=scaleTypeSupportProperty(scaleType,property);const channelIncompatability=channelScalePropertyIncompatability(channel,property);if(specifiedValue!==undefined){if(!supportedByScaleType){warn(message_namespaceObject.scalePropertyNotWorkWithScaleType(scaleType,property,channel))}else if(channelIncompatability){warn(channelIncompatability)}}if(supportedByScaleType&&channelIncompatability===undefined){if(specifiedValue!==undefined){const timeUnit=fieldOrDatumDef.timeUnit;const type=fieldOrDatumDef.type;switch(property){case"domainMax":case"domainMin":if(isDateTime(specifiedScale[property])||type==="temporal"||timeUnit){localScaleCmpt.set(property,{signal:valueExpr(specifiedScale[property],{type:type,timeUnit:timeUnit})},true)}else{localScaleCmpt.set(property,specifiedScale[property],true)}break;default:localScaleCmpt.copyKeyFromObject(property,specifiedScale)}}else{const value=hasProperty(scaleRules,property)?scaleRules[property]({model:model,channel:channel,fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,scalePadding:scalePadding,scalePaddingInner:scalePaddingInner,domain:specifiedScale.domain,domainMin:specifiedScale.domainMin,domainMax:specifiedScale.domainMax,markDef:markDef,config:config,hasNestedOffsetScale:channelHasNestedOffsetScale(encoding,channel),hasSecondaryRangeChannel:!!encoding[getSecondaryRangeChannel(channel)]}):config.scale[property];if(value!==undefined){localScaleCmpt.set(property,value,false)}}}}}const scaleRules={bins:_ref=>{let{model:model,fieldOrDatumDef:fieldOrDatumDef}=_ref;return isFieldDef(fieldOrDatumDef)?properties_bins(model,fieldOrDatumDef):undefined},interpolate:_ref2=>{let{channel:channel,fieldOrDatumDef:fieldOrDatumDef}=_ref2;return properties_interpolate(channel,fieldOrDatumDef.type)},nice:_ref3=>{let{scaleType:scaleType,channel:channel,domain:domain,domainMin:domainMin,domainMax:domainMax,fieldOrDatumDef:fieldOrDatumDef}=_ref3;return nice(scaleType,channel,domain,domainMin,domainMax,fieldOrDatumDef)},padding:_ref4=>{let{channel:channel,scaleType:scaleType,fieldOrDatumDef:fieldOrDatumDef,markDef:markDef,config:config}=_ref4;return properties_padding(channel,scaleType,config.scale,fieldOrDatumDef,markDef,config.bar)},paddingInner:_ref5=>{let{scalePadding:scalePadding,channel:channel,markDef:markDef,scaleType:scaleType,config:config,hasNestedOffsetScale:hasNestedOffsetScale}=_ref5;return properties_paddingInner(scalePadding,channel,markDef.type,scaleType,config.scale,hasNestedOffsetScale)},paddingOuter:_ref6=>{let{scalePadding:scalePadding,channel:channel,scaleType:scaleType,scalePaddingInner:scalePaddingInner,config:config,hasNestedOffsetScale:hasNestedOffsetScale}=_ref6;return properties_paddingOuter(scalePadding,channel,scaleType,scalePaddingInner,config.scale,hasNestedOffsetScale)},reverse:_ref7=>{let{fieldOrDatumDef:fieldOrDatumDef,scaleType:scaleType,channel:channel,config:config}=_ref7;const sort=isFieldDef(fieldOrDatumDef)?fieldOrDatumDef.sort:undefined;return properties_reverse(scaleType,sort,channel,config.scale)},zero:_ref8=>{let{channel:channel,fieldOrDatumDef:fieldOrDatumDef,domain:domain,markDef:markDef,scaleType:scaleType,config:config,hasSecondaryRangeChannel:hasSecondaryRangeChannel}=_ref8;return zero(channel,fieldOrDatumDef,domain,markDef,scaleType,config.scale,hasSecondaryRangeChannel)}};function parseScaleRange(model){if(isUnitModel(model)){parseUnitScaleRange(model)}else{parseNonUnitScaleProperty(model,"range")}}function parseNonUnitScaleProperty(model,property){const localScaleComponents=model.component.scales;for(const child of model.children){if(property==="range"){parseScaleRange(child)}else{parseScaleProperty(child,property)}}for(const channel of keys(localScaleComponents)){let valueWithExplicit;for(const child of model.children){const childComponent=child.component.scales[channel];if(childComponent){const childValueWithExplicit=childComponent.getWithExplicit(property);valueWithExplicit=mergeValuesWithExplicit(valueWithExplicit,childValueWithExplicit,property,"scale",tieBreakByComparing((v1,v2)=>{switch(property){case"range":if(v1.step&&v2.step){return v1.step-v2.step}return 0}return 0}))}}localScaleComponents[channel].setWithExplicit(property,valueWithExplicit)}}function properties_bins(model,fieldDef){const bin=fieldDef.bin;if(isBinning(bin)){const binSignal=getBinSignalName(model,fieldDef.field,bin);return new SignalRefWrapper(()=>model.getSignalName(binSignal))}else if(isBinned(bin)&&isBinParams(bin)&&bin.step!==undefined){return{step:bin.step}}return undefined}function properties_interpolate(channel,type){if(util_contains([COLOR,FILL,STROKE],channel)&&type!=="nominal"){return"hcl"}return undefined}function nice(scaleType,channel,specifiedDomain,domainMin,domainMax,fieldOrDatumDef){var _getFieldDef;if((_getFieldDef=getFieldDef(fieldOrDatumDef))!==null&&_getFieldDef!==void 0&&_getFieldDef.bin||Object(vega_util["isArray"])(specifiedDomain)||domainMax!=null||domainMin!=null||util_contains([ScaleType.TIME,ScaleType.UTC],scaleType)){return undefined}return isXorY(channel)?true:undefined}function properties_padding(channel,scaleType,scaleConfig,fieldOrDatumDef,markDef,barConfig){if(isXorY(channel)){if(isContinuousToContinuous(scaleType)){if(scaleConfig.continuousPadding!==undefined){return scaleConfig.continuousPadding}const{type:type,orient:orient}=markDef;if(type==="bar"&&!(isFieldDef(fieldOrDatumDef)&&(fieldOrDatumDef.bin||fieldOrDatumDef.timeUnit))){if(orient==="vertical"&&channel==="x"||orient==="horizontal"&&channel==="y"){return barConfig.continuousBandSize}}}if(scaleType===ScaleType.POINT){return scaleConfig.pointPadding}}return undefined}function properties_paddingInner(paddingValue,channel,mark,scaleType,scaleConfig){let hasNestedOffsetScale=arguments.length>5&&arguments[5]!==undefined?arguments[5]:false;if(paddingValue!==undefined){return undefined}if(isXorY(channel)){const{bandPaddingInner:bandPaddingInner,barBandPaddingInner:barBandPaddingInner,rectBandPaddingInner:rectBandPaddingInner,tickBandPaddingInner:tickBandPaddingInner,bandWithNestedOffsetPaddingInner:bandWithNestedOffsetPaddingInner}=scaleConfig;if(hasNestedOffsetScale){return bandWithNestedOffsetPaddingInner}return getFirstDefined(bandPaddingInner,mark==="bar"?barBandPaddingInner:mark==="tick"?tickBandPaddingInner:rectBandPaddingInner)}else if(isXorYOffset(channel)){if(scaleType===ScaleType.BAND){return scaleConfig.offsetBandPaddingInner}}return undefined}function properties_paddingOuter(paddingValue,channel,scaleType,paddingInnerValue,scaleConfig){let hasNestedOffsetScale=arguments.length>5&&arguments[5]!==undefined?arguments[5]:false;if(paddingValue!==undefined){return undefined}if(isXorY(channel)){const{bandPaddingOuter:bandPaddingOuter,bandWithNestedOffsetPaddingOuter:bandWithNestedOffsetPaddingOuter}=scaleConfig;if(hasNestedOffsetScale){return bandWithNestedOffsetPaddingOuter}if(scaleType===ScaleType.BAND){return getFirstDefined(bandPaddingOuter,isSignalRef(paddingInnerValue)?{signal:`${paddingInnerValue.signal}/2`}:paddingInnerValue/2)}}else if(isXorYOffset(channel)){if(scaleType===ScaleType.POINT){return.5}else if(scaleType===ScaleType.BAND){return scaleConfig.offsetBandPaddingOuter}}return undefined}function properties_reverse(scaleType,sort,channel,scaleConfig){if(channel==="x"&&scaleConfig.xReverse!==undefined){if(hasContinuousDomain(scaleType)&&sort==="descending"){if(isSignalRef(scaleConfig.xReverse)){return{signal:`!${scaleConfig.xReverse.signal}`}}else{return!scaleConfig.xReverse}}return scaleConfig.xReverse}if(hasContinuousDomain(scaleType)&&sort==="descending"){return true}return undefined}function zero(channel,fieldDef,specifiedDomain,markDef,scaleType,scaleConfig,hasSecondaryRangeChannel){const hasCustomDomain=!!specifiedDomain&&specifiedDomain!=="unaggregated";if(hasCustomDomain){if(hasContinuousDomain(scaleType)){if(Object(vega_util["isArray"])(specifiedDomain)){const first=specifiedDomain[0];const last=specifiedDomain[specifiedDomain.length-1];if(Object(vega_util["isNumber"])(first)&&first<=0&&Object(vega_util["isNumber"])(last)&&last>=0){return true}}return false}}if(channel==="size"&&fieldDef.type==="quantitative"&&!isContinuousToDiscrete(scaleType)){return true}if(!(isFieldDef(fieldDef)&&fieldDef.bin)&&util_contains([...POSITION_SCALE_CHANNELS,...POLAR_POSITION_SCALE_CHANNELS],channel)){const{orient:orient,type:type}=markDef;if(util_contains(["bar","area","line","trail"],type)){if(orient==="horizontal"&&channel==="y"||orient==="vertical"&&channel==="x"){return false}}if(util_contains(["bar","area"],type)&&!hasSecondaryRangeChannel){return true}return scaleConfig===null||scaleConfig===void 0?void 0:scaleConfig.zero}return false}function type_scaleType(specifiedScale,channel,fieldDef,mark){let hasNestedOffsetScale=arguments.length>4&&arguments[4]!==undefined?arguments[4]:false;const defaultScaleType=type_defaultType(channel,fieldDef,mark,hasNestedOffsetScale);const{type:type}=specifiedScale;if(!isScaleChannel(channel)){return null}if(type!==undefined){if(!channelSupportScaleType(channel,type)){warn(message_namespaceObject.scaleTypeNotWorkWithChannel(channel,type,defaultScaleType));return defaultScaleType}if(isFieldDef(fieldDef)&&!scaleTypeSupportDataType(type,fieldDef.type)){warn(message_namespaceObject.scaleTypeNotWorkWithFieldDef(type,defaultScaleType));return defaultScaleType}return type}return defaultScaleType}function type_defaultType(channel,fieldDef,mark,hasNestedOffsetScale){switch(fieldDef.type){case"nominal":case"ordinal":{var _fieldDef$axis;if(isColorChannel(channel)||rangeType(channel)==="discrete"){if(channel==="shape"&&fieldDef.type==="ordinal"){warn(message_namespaceObject.discreteChannelCannotEncode(channel,"ordinal"))}return"ordinal"}if(channel_isTime(channel)){return"band"}if(isXorY(channel)||isXorYOffset(channel)){if(util_contains(["rect","bar","image","rule","tick"],mark.type)){return"band"}if(hasNestedOffsetScale){return"band"}}else if(mark.type==="arc"&&channel in POLAR_POSITION_SCALE_CHANNEL_INDEX){return"band"}const dimensionSize=mark[getSizeChannel(channel)];if(isRelativeBandSize(dimensionSize)){return"band"}if(isPositionFieldOrDatumDef(fieldDef)&&(_fieldDef$axis=fieldDef.axis)!==null&&_fieldDef$axis!==void 0&&_fieldDef$axis.tickBand){return"band"}return"point"}case"temporal":if(isColorChannel(channel)){return"time"}else if(rangeType(channel)==="discrete"){warn(message_namespaceObject.discreteChannelCannotEncode(channel,"temporal"));return"ordinal"}else if(isFieldDef(fieldDef)&&fieldDef.timeUnit&&normalizeTimeUnit(fieldDef.timeUnit).utc){return"utc"}else if(channel_isTime(channel)){return"band"}return"time";case"quantitative":if(isColorChannel(channel)){if(isFieldDef(fieldDef)&&isBinning(fieldDef.bin)){return"bin-ordinal"}return"linear"}else if(rangeType(channel)==="discrete"){warn(message_namespaceObject.discreteChannelCannotEncode(channel,"quantitative"));return"ordinal"}else if(channel_isTime(channel)){return"band"}return"linear";case"geojson":return undefined}throw new Error(message_namespaceObject.invalidFieldType(fieldDef.type))}function parseScales(model){let{ignoreRange:ignoreRange}=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};parseScaleCore(model);parseScaleDomain(model);for(const prop of NON_TYPE_DOMAIN_RANGE_VEGA_SCALE_PROPERTIES){parseScaleProperty(model,prop)}if(!ignoreRange){parseScaleRange(model)}}function parseScaleCore(model){if(isUnitModel(model)){model.component.scales=parseUnitScaleCore(model)}else{model.component.scales=parseNonUnitScaleCore(model)}}function parseUnitScaleCore(model){const{encoding:encoding,mark:mark,markDef:markDef}=model;const scaleComponents={};for(const channel of SCALE_CHANNELS){const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);if(fieldOrDatumDef&&mark===GEOSHAPE&&channel===SHAPE&&fieldOrDatumDef.type===GEOJSON){continue}let specifiedScale=fieldOrDatumDef&&fieldOrDatumDef.scale;if(fieldOrDatumDef&&specifiedScale!==null&&specifiedScale!==false){var _specifiedScale;(_specifiedScale=specifiedScale)!==null&&_specifiedScale!==void 0?_specifiedScale:specifiedScale={};const hasNestedOffsetScale=channelHasNestedOffsetScale(encoding,channel);const sType=type_scaleType(specifiedScale,channel,fieldOrDatumDef,markDef,hasNestedOffsetScale);scaleComponents[channel]=new component_ScaleComponent(model.scaleName(`${channel}`,true),{value:sType,explicit:specifiedScale.type===sType})}}return scaleComponents}const scaleTypeTieBreaker=tieBreakByComparing((st1,st2)=>scaleTypePrecedence(st1)-scaleTypePrecedence(st2));function parseNonUnitScaleCore(model){const scaleComponents=model.component.scales={};const scaleTypeWithExplicitIndex={};const resolve=model.component.resolve;for(const child of model.children){parseScaleCore(child);for(const channel of keys(child.component.scales)){var _resolve$scale,_resolve$scale$channe;(_resolve$scale$channe=(_resolve$scale=resolve.scale)[channel])!==null&&_resolve$scale$channe!==void 0?_resolve$scale$channe:_resolve$scale[channel]=defaultScaleResolve(channel,model);if(resolve.scale[channel]==="shared"){const explicitScaleType=scaleTypeWithExplicitIndex[channel];const childScaleType=child.component.scales[channel].getWithExplicit("type");if(explicitScaleType){if(scaleCompatible(explicitScaleType.value,childScaleType.value)){scaleTypeWithExplicitIndex[channel]=mergeValuesWithExplicit(explicitScaleType,childScaleType,"type","scale",scaleTypeTieBreaker)}else{resolve.scale[channel]="independent";delete scaleTypeWithExplicitIndex[channel]}}else{scaleTypeWithExplicitIndex[channel]=childScaleType}}}}for(const channel of keys(scaleTypeWithExplicitIndex)){const name=model.scaleName(channel,true);const typeWithExplicit=scaleTypeWithExplicitIndex[channel];scaleComponents[channel]=new component_ScaleComponent(name,typeWithExplicit);for(const child of model.children){const childScale=child.component.scales[channel];if(childScale){child.renameScale(childScale.get("name"),name);childScale.merged=true}}}return scaleComponents}function model_defineProperty(e,r,t){return(r=model_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function model_toPropertyKey(t){var i=model_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function model_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class NameMap{constructor(){model_defineProperty(this,"nameMap",void 0);this.nameMap={}}rename(oldName,newName){this.nameMap[oldName]=newName}has(name){return this.nameMap[name]!==undefined}get(name){while(this.nameMap[name]&&name!==this.nameMap[name]){name=this.nameMap[name]}return name}}function isUnitModel(model){return(model===null||model===void 0?void 0:model.type)==="unit"}function isFacetModel(model){return(model===null||model===void 0?void 0:model.type)==="facet"}function isConcatModel(model){return(model===null||model===void 0?void 0:model.type)==="concat"}function isLayerModel(model){return(model===null||model===void 0?void 0:model.type)==="layer"}class model_Model{constructor(spec,type,parent,parentGivenName,config,resolve,view){var _spec$name,_spec$transform;this.type=type;this.parent=parent;this.config=config;model_defineProperty(this,"name",void 0);model_defineProperty(this,"size",void 0);model_defineProperty(this,"title",void 0);model_defineProperty(this,"description",void 0);model_defineProperty(this,"data",void 0);model_defineProperty(this,"transforms",void 0);model_defineProperty(this,"layout",void 0);model_defineProperty(this,"scaleNameMap",void 0);model_defineProperty(this,"projectionNameMap",void 0);model_defineProperty(this,"signalNameMap",void 0);model_defineProperty(this,"component",void 0);model_defineProperty(this,"view",void 0);model_defineProperty(this,"children",void 0);this.parent=parent;this.config=config;this.view=replaceExprRef(view);this.name=(_spec$name=spec.name)!==null&&_spec$name!==void 0?_spec$name:parentGivenName;this.title=isText(spec.title)?{text:spec.title}:spec.title?replaceExprRef(spec.title):undefined;this.scaleNameMap=parent?parent.scaleNameMap:new NameMap;this.projectionNameMap=parent?parent.projectionNameMap:new NameMap;this.signalNameMap=parent?parent.signalNameMap:new NameMap;this.data=spec.data;this.description=spec.description;this.transforms=normalizeTransform((_spec$transform=spec.transform)!==null&&_spec$transform!==void 0?_spec$transform:[]);this.layout=type==="layer"||type==="unit"?{}:extractCompositionLayout(spec,type,config);this.component={data:{sources:parent?parent.component.data.sources:[],outputNodes:parent?parent.component.data.outputNodes:{},outputNodeRefCounts:parent?parent.component.data.outputNodeRefCounts:{},isFaceted:isFacetSpec(spec)||(parent===null||parent===void 0?void 0:parent.component.data.isFaceted)&&spec.data===undefined},layoutSize:new split_Split,layoutHeaders:{row:{},column:{},facet:{}},mark:null,resolve:{scale:{},axis:{},legend:{},...resolve?duplicate(resolve):{}},selection:null,scales:null,projection:null,axes:{},legends:{}}}get width(){return this.getSizeSignalRef("width")}get height(){return this.getSizeSignalRef("height")}parse(){this.parseScale();this.parseLayoutSize();this.renameTopLevelLayoutSizeSignal();this.parseSelections();this.parseProjection();this.parseData();this.parseAxesAndHeaders();this.parseLegends();this.parseMarkGroup()}parseScale(){parseScales(this)}parseProjection(){parseProjection(this)}renameTopLevelLayoutSizeSignal(){if(this.getName("width")!=="width"){this.renameSignal(this.getName("width"),"width")}if(this.getName("height")!=="height"){this.renameSignal(this.getName("height"),"height")}}parseLegends(){parseLegend(this)}assembleEncodeFromView(view){const{style:_,...baseView}=view;const e={};for(const property of keys(baseView)){const value=baseView[property];if(value!==undefined){e[property]=signalOrValueRef(value)}}return e}assembleGroupEncodeEntry(isTopLevel){let encodeEntry={};if(this.view){encodeEntry=this.assembleEncodeFromView(this.view)}if(!isTopLevel){if(this.description){encodeEntry["description"]=signalOrValueRef(this.description)}if(this.type==="unit"||this.type==="layer"){return{width:this.getSizeSignalRef("width"),height:this.getSizeSignalRef("height"),...encodeEntry}}}return isEmpty(encodeEntry)?undefined:encodeEntry}assembleLayout(){if(!this.layout){return undefined}const{spacing:spacing,...layout}=this.layout;const{component:component,config:config}=this;const titleBand=assembleLayoutTitleBand(component.layoutHeaders,config);return{padding:spacing,...this.assembleDefaultLayout(),...layout,...titleBand?{titleBand:titleBand}:{}}}assembleDefaultLayout(){return{}}assembleHeaderMarks(){const{layoutHeaders:layoutHeaders}=this.component;let headerMarks=[];for(const channel of FACET_CHANNELS){if(layoutHeaders[channel].title){headerMarks.push(assembleTitleGroup(this,channel))}}for(const channel of HEADER_CHANNELS){headerMarks=headerMarks.concat(assembleHeaderGroups(this,channel))}return headerMarks}assembleAxes(){return assembleAxes(this.component.axes,this.config)}assembleLegends(){return assembleLegends(this)}assembleProjections(){return assembleProjections(this)}assembleTitle(){var _this$title;const{encoding:encoding,...titleNoEncoding}=(_this$title=this.title)!==null&&_this$title!==void 0?_this$title:{};const title={...extractTitleConfig(this.config.title).nonMarkTitleProperties,...titleNoEncoding,...encoding?{encode:{update:encoding}}:{}};if(title.text){if(util_contains(["unit","layer"],this.type)){if(util_contains(["middle",undefined],title.anchor)){var _title$frame;(_title$frame=title.frame)!==null&&_title$frame!==void 0?_title$frame:title.frame="group"}}else{var _title$anchor;(_title$anchor=title.anchor)!==null&&_title$anchor!==void 0?_title$anchor:title.anchor="start"}return isEmpty(title)?undefined:title}return undefined}assembleGroup(){let signals=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];const group={};signals=signals.concat(this.assembleSignals());if(signals.length>0){group.signals=signals}const layout=this.assembleLayout();if(layout){group.layout=layout}group.marks=[].concat(this.assembleHeaderMarks(),this.assembleMarks());const scales=!this.parent||isFacetModel(this.parent)?assembleScales(this):[];if(scales.length>0){group.scales=scales}const axes=this.assembleAxes();if(axes.length>0){group.axes=axes}const legends=this.assembleLegends();if(legends.length>0){group.legends=legends}return group}getName(text){return varName((this.name?`${this.name}_`:"")+text)}getDataName(type){return this.getName(DataSourceType[type].toLowerCase())}requestDataName(name){const fullName=this.getDataName(name);const refCounts=this.component.data.outputNodeRefCounts;refCounts[fullName]=(refCounts[fullName]||0)+1;return fullName}getSizeSignalRef(layoutSizeType){if(isFacetModel(this.parent)){const sizeType=getSizeTypeFromLayoutSizeType(layoutSizeType);const channel=getPositionScaleChannel(sizeType);const scaleComponent=this.component.scales[channel];if(scaleComponent&&!scaleComponent.merged){const type=scaleComponent.get("type");const range=scaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const scaleName=scaleComponent.get("name");const domain=assembleDomain(this,channel);const field=getFieldFromDomain(domain);if(field){const fieldRef=vgField({aggregate:"distinct",field:field},{expr:"datum"});return{signal:sizeExpr(scaleName,scaleComponent,fieldRef)}}else{warn(message_namespaceObject.unknownField(channel));return null}}}}return{signal:this.signalNameMap.get(this.getName(layoutSizeType))}}lookupDataSource(name){const node=this.component.data.outputNodes[name];if(!node){return name}return node.getSource()}getSignalName(oldSignalName){return this.signalNameMap.get(oldSignalName)}renameSignal(oldName,newName){this.signalNameMap.rename(oldName,newName)}renameScale(oldName,newName){this.scaleNameMap.rename(oldName,newName)}renameProjection(oldName,newName){this.projectionNameMap.rename(oldName,newName)}scaleName(originalScaleName,parse){if(parse){return this.getName(originalScaleName)}if(isChannel(originalScaleName)&&isScaleChannel(originalScaleName)&&this.component.scales[originalScaleName]||this.scaleNameMap.has(this.getName(originalScaleName))){return this.scaleNameMap.get(this.getName(originalScaleName))}return undefined}projectionName(parse){if(parse){return this.getName("projection")}if(this.component.projection&&!this.component.projection.merged||this.projectionNameMap.has(this.getName("projection"))){return this.projectionNameMap.get(this.getName("projection"))}return undefined}getScaleComponent(channel){if(!this.component.scales){throw new Error("getScaleComponent cannot be called before parseScale(). Make sure you have called parseScale or use parseUnitModelWithScale().")}const localScaleComponent=this.component.scales[channel];if(localScaleComponent&&!localScaleComponent.merged){return localScaleComponent}return this.parent?this.parent.getScaleComponent(channel):undefined}getScaleType(channel){const scaleComponent=this.getScaleComponent(channel);return scaleComponent?scaleComponent.get("type"):undefined}getSelectionComponent(variableName,origName){let sel=this.component.selection[variableName];if(!sel&&this.parent){sel=this.parent.getSelectionComponent(variableName,origName)}if(!sel){throw new Error(message_namespaceObject.selectionNotFound(origName))}return sel}hasAxisOrientSignalRef(){var _this$component$axes$,_this$component$axes$2;return((_this$component$axes$=this.component.axes.x)===null||_this$component$axes$===void 0?void 0:_this$component$axes$.some(a=>a.hasOrientSignalRef()))||((_this$component$axes$2=this.component.axes.y)===null||_this$component$axes$2===void 0?void 0:_this$component$axes$2.some(a=>a.hasOrientSignalRef()))}}class model_ModelWithField extends model_Model{vgField(channel){let opt=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const fieldDef=this.fieldDef(channel);if(!fieldDef){return undefined}return vgField(fieldDef,opt)}reduceFieldDef(f,init){return reduce(this.getMapping(),(acc,cd,c)=>{const fieldDef=getFieldDef(cd);if(fieldDef){return f(acc,fieldDef,c)}return acc},init)}forEachFieldDef(f,t){forEach(this.getMapping(),(cd,c)=>{const fieldDef=getFieldDef(cd);if(fieldDef){f(fieldDef,c)}},t)}}class density_DensityTransformNode extends dataflow_DataFlowNode{clone(){return new density_DensityTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2,_this$transform$resol;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:"value",(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:"density"];const resolve=(_this$transform$resol=this.transform.resolve)!==null&&_this$transform$resol!==void 0?_this$transform$resol:"shared";this.transform.resolve=resolve}dependentFields(){var _this$transform$group;return new Set([this.transform.density,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return`DensityTransform ${hash(this.transform)}`}assemble(){const{density:density,...rest}=this.transform;const result={type:"kde",field:density,...rest};result.resolve=this.transform.resolve;return result}}class extent_ExtentTransformNode extends dataflow_DataFlowNode{clone(){return new extent_ExtentTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform;this.transform=duplicate(transform)}dependentFields(){return new Set([this.transform.extent])}producedFields(){return new Set([])}hash(){return`ExtentTransform ${hash(this.transform)}`}assemble(){const{extent:extent,param:param}=this.transform;const result={type:"extent",field:extent,signal:param};return result}}class flatten_FlattenTransformNode extends dataflow_DataFlowNode{clone(){return new flatten_FlattenTransformNode(this.parent,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform;this.transform=duplicate(transform);const{flatten:flatten,as:as=[]}=this.transform;this.transform.as=flatten.map((f,i)=>{var _as$i;return(_as$i=as[i])!==null&&_as$i!==void 0?_as$i:f})}dependentFields(){return new Set(this.transform.flatten)}producedFields(){return new Set(this.transform.as)}hash(){return`FlattenTransform ${hash(this.transform)}`}assemble(){const{flatten:fields,as:as}=this.transform;const result={type:"flatten",fields:fields,as:as};return result}}class fold_FoldTransformNode extends dataflow_DataFlowNode{clone(){return new fold_FoldTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:"key",(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:"value"]}dependentFields(){return new Set(this.transform.fold)}producedFields(){return new Set(this.transform.as)}hash(){return`FoldTransform ${hash(this.transform)}`}assemble(){const{fold:fold,as:as}=this.transform;const result={type:"fold",fields:fold,as:as};return result}}class geojson_GeoJSONNode extends dataflow_DataFlowNode{clone(){return new geojson_GeoJSONNode(null,duplicate(this.fields),this.geojson,this.signal)}static parseAll(parent,model){if(model.component.projection&&!model.component.projection.isFit){return parent}let geoJsonCounter=0;for(const coordinates of[[LONGITUDE,LATITUDE],[LONGITUDE2,LATITUDE2]]){const pair=coordinates.map(channel=>{const def=getFieldOrDatumDef(model.encoding[channel]);return isFieldDef(def)?def.field:isDatumDef(def)?{expr:`${def.datum}`}:isValueDef(def)?{expr:`${def["value"]}`}:undefined});if(pair[0]||pair[1]){parent=new geojson_GeoJSONNode(parent,pair,null,model.getName(`geojson_${geoJsonCounter++}`))}}if(model.channelHasField(SHAPE)){const fieldDef=model.typedFieldDef(SHAPE);if(fieldDef.type===GEOJSON){parent=new geojson_GeoJSONNode(parent,null,fieldDef.field,model.getName(`geojson_${geoJsonCounter++}`))}}return parent}constructor(parent,fields,geojson,signal){super(parent);this.fields=fields;this.geojson=geojson;this.signal=signal}dependentFields(){var _this$fields;const fields=((_this$fields=this.fields)!==null&&_this$fields!==void 0?_this$fields:[]).filter(vega_util["isString"]);return new Set([...this.geojson?[this.geojson]:[],...fields])}producedFields(){return new Set}hash(){return`GeoJSON ${this.geojson} ${this.signal} ${hash(this.fields)}`}assemble(){return[...this.geojson?[{type:"filter",expr:`isValid(datum["${this.geojson}"])`}]:[],{type:"geojson",...this.fields?{fields:this.fields}:{},...this.geojson?{geojson:this.geojson}:{},signal:this.signal}]}}class geopoint_GeoPointNode extends dataflow_DataFlowNode{clone(){return new geopoint_GeoPointNode(null,this.projection,duplicate(this.fields),duplicate(this.as))}constructor(parent,projection,fields,as){super(parent);this.projection=projection;this.fields=fields;this.as=as}static parseAll(parent,model){if(!model.projectionName()){return parent}for(const coordinates of[[LONGITUDE,LATITUDE],[LONGITUDE2,LATITUDE2]]){const pair=coordinates.map(channel=>{const def=getFieldOrDatumDef(model.encoding[channel]);return isFieldDef(def)?def.field:isDatumDef(def)?{expr:`${def.datum}`}:isValueDef(def)?{expr:`${def["value"]}`}:undefined});const suffix=coordinates[0]===LONGITUDE2?"2":"";if(pair[0]||pair[1]){parent=new geopoint_GeoPointNode(parent,model.projectionName(),pair,[model.getName(`x${suffix}`),model.getName(`y${suffix}`)])}}return parent}dependentFields(){return new Set(this.fields.filter(vega_util["isString"]))}producedFields(){return new Set(this.as)}hash(){return`Geopoint ${this.projection} ${hash(this.fields)} ${hash(this.as)}`}assemble(){return{type:"geopoint",projection:this.projection,fields:this.fields,as:this.as}}}class impute_ImputeNode extends dataflow_DataFlowNode{clone(){return new impute_ImputeNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}dependentFields(){var _this$transform$group;return new Set([this.transform.impute,this.transform.key,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set([this.transform.impute])}processSequence(keyvals){const{start:start=0,stop:stop,step:step}=keyvals;const result=[start,stop,...step?[step]:[]].join(",");return{signal:`sequence(${result})`}}static makeFromTransform(parent,imputeTransform){return new impute_ImputeNode(parent,imputeTransform)}static makeFromEncoding(parent,model){const encoding=model.encoding;const xDef=encoding.x;const yDef=encoding.y;if(isFieldDef(xDef)&&isFieldDef(yDef)){const imputedChannel=xDef.impute?xDef:yDef.impute?yDef:undefined;if(imputedChannel===undefined){return undefined}const keyChannel=xDef.impute?yDef:yDef.impute?xDef:undefined;const{method:method,value:value,frame:frame,keyvals:keyvals}=imputedChannel.impute;const groupbyFields=pathGroupingFields(model.mark,encoding);return new impute_ImputeNode(parent,{impute:imputedChannel.field,key:keyChannel.field,...method?{method:method}:{},...value!==undefined?{value:value}:{},...frame?{frame:frame}:{},...keyvals!==undefined?{keyvals:keyvals}:{},...groupbyFields.length?{groupby:groupbyFields}:{}})}return null}hash(){return`Impute ${hash(this.transform)}`}assemble(){const{impute:impute,key:key,keyvals:keyvals,method:method,groupby:groupby,value:value,frame:frame=[null,null]}=this.transform;const imputeTransform={type:"impute",field:impute,key:key,...keyvals?{keyvals:isImputeSequence(keyvals)?this.processSequence(keyvals):keyvals}:{},method:"value",...groupby?{groupby:groupby}:{},value:!method||method==="value"?value:null};if(method&&method!=="value"){const deriveNewField={type:"window",as:[`imputed_${impute}_value`],ops:[method],fields:[impute],frame:frame,ignorePeers:false,...groupby?{groupby:groupby}:{}};const replaceOriginal={type:"formula",expr:`datum.${impute} === null ? datum.imputed_${impute}_value : datum.${impute}`,as:impute};return[imputeTransform,deriveNewField,replaceOriginal]}else{return[imputeTransform]}}}class loess_LoessTransformNode extends dataflow_DataFlowNode{clone(){return new loess_LoessTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:transform.on,(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:transform.loess]}dependentFields(){var _this$transform$group;return new Set([this.transform.loess,this.transform.on,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return`LoessTransform ${hash(this.transform)}`}assemble(){const{loess:loess,on:on,...rest}=this.transform;const result={type:"loess",x:on,y:loess,...rest};return result}}class lookup_LookupNode extends dataflow_DataFlowNode{clone(){return new lookup_LookupNode(null,duplicate(this.transform),this.secondary)}constructor(parent,transform,secondary){super(parent);this.transform=transform;this.secondary=secondary}static make(parent,model,transform,counter){const sources=model.component.data.sources;const{from:from}=transform;let fromOutputNode=null;if(isLookupData(from)){let fromSource=findSource(from.data,sources);if(!fromSource){fromSource=new source_SourceNode(from.data);sources.push(fromSource)}const fromOutputName=model.getName(`lookup_${counter}`);fromOutputNode=new dataflow_OutputNode(fromSource,fromOutputName,DataSourceType.Lookup,model.component.data.outputNodeRefCounts);model.component.data.outputNodes[fromOutputName]=fromOutputNode}else if(isLookupSelection(from)){const selName=from.param;transform={as:selName,...transform};let selCmpt;try{selCmpt=model.getSelectionComponent(varName(selName),selName)}catch(e){throw new Error(message_namespaceObject.cannotLookupVariableParameter(selName))}fromOutputNode=selCmpt.materialized;if(!fromOutputNode){throw new Error(message_namespaceObject.noSameUnitLookup(selName))}}return new lookup_LookupNode(parent,transform,fromOutputNode.getSource())}dependentFields(){return new Set([this.transform.lookup])}producedFields(){return new Set(this.transform.as?Object(vega_util["array"])(this.transform.as):this.transform.from.fields)}hash(){return`Lookup ${hash({transform:this.transform,secondary:this.secondary})}`}assemble(){let foreign;if(this.transform.from.fields){foreign={values:this.transform.from.fields,...this.transform.as?{as:Object(vega_util["array"])(this.transform.as)}:{}}}else{let asName=this.transform.as;if(!Object(vega_util["isString"])(asName)){warn(message_namespaceObject.NO_FIELDS_NEEDS_AS);asName="_lookup"}foreign={as:[asName]}}return{type:"lookup",from:this.secondary,key:this.transform.from.key,fields:[this.transform.lookup],...foreign,...this.transform.default?{default:this.transform.default}:{}}}}class quantile_QuantileTransformNode extends dataflow_DataFlowNode{clone(){return new quantile_QuantileTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:"prob",(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:"value"]}dependentFields(){var _this$transform$group;return new Set([this.transform.quantile,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return`QuantileTransform ${hash(this.transform)}`}assemble(){const{quantile:quantile,...rest}=this.transform;const result={type:"quantile",field:quantile,...rest};return result}}class regression_RegressionTransformNode extends dataflow_DataFlowNode{clone(){return new regression_RegressionTransformNode(null,duplicate(this.transform))}constructor(parent,transform){var _this$transform$as,_specifiedAs$,_specifiedAs$2;super(parent);this.transform=transform;this.transform=duplicate(transform);const specifiedAs=(_this$transform$as=this.transform.as)!==null&&_this$transform$as!==void 0?_this$transform$as:[undefined,undefined];this.transform.as=[(_specifiedAs$=specifiedAs[0])!==null&&_specifiedAs$!==void 0?_specifiedAs$:transform.on,(_specifiedAs$2=specifiedAs[1])!==null&&_specifiedAs$2!==void 0?_specifiedAs$2:transform.regression]}dependentFields(){var _this$transform$group;return new Set([this.transform.regression,this.transform.on,...(_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]])}producedFields(){return new Set(this.transform.as)}hash(){return`RegressionTransform ${hash(this.transform)}`}assemble(){const{regression:regression,on:on,...rest}=this.transform;const result={type:"regression",x:on,y:regression,...rest};return result}}class pivot_PivotTransformNode extends dataflow_DataFlowNode{clone(){return new pivot_PivotTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}addDimensions(fields){var _this$transform$group;this.transform.groupby=unique(((_this$transform$group=this.transform.groupby)!==null&&_this$transform$group!==void 0?_this$transform$group:[]).concat(fields),d=>d)}producedFields(){return undefined}dependentFields(){var _this$transform$group2;return new Set([this.transform.pivot,this.transform.value,...(_this$transform$group2=this.transform.groupby)!==null&&_this$transform$group2!==void 0?_this$transform$group2:[]])}hash(){return`PivotTransform ${hash(this.transform)}`}assemble(){const{pivot:pivot,value:value,groupby:groupby,limit:limit,op:op}=this.transform;return{type:"pivot",field:pivot,value:value,...limit!==undefined?{limit:limit}:{},...op!==undefined?{op:op}:{},...groupby!==undefined?{groupby:groupby}:{}}}}class sample_SampleTransformNode extends dataflow_DataFlowNode{clone(){return new sample_SampleTransformNode(null,duplicate(this.transform))}constructor(parent,transform){super(parent);this.transform=transform}dependentFields(){return new Set}producedFields(){return new Set}hash(){return`SampleTransform ${hash(this.transform)}`}assemble(){return{type:"sample",size:this.transform.sample}}}function makeWalkTree(data){let datasetIndex=0;function walkTree(node,dataSource){if(node instanceof source_SourceNode){if(!node.isGenerator&&!isUrlData(node.data)){data.push(dataSource);const newData={name:null,source:dataSource.name,transform:[]};dataSource=newData}}if(node instanceof formatparse_ParseNode){if(node.parent instanceof source_SourceNode&&!dataSource.source){dataSource.format={...dataSource.format,parse:node.assembleFormatParse()};dataSource.transform.push(...node.assembleTransforms(true))}else{dataSource.transform.push(...node.assembleTransforms())}}if(node instanceof facet_FacetNode){if(!dataSource.name){dataSource.name=`data_${datasetIndex++}`}if(!dataSource.source||dataSource.transform.length>0){data.push(dataSource);node.data=dataSource.name}else{node.data=dataSource.source}data.push(...node.assemble());return}if(node instanceof graticule_GraticuleNode||node instanceof sequence_SequenceNode||node instanceof filterinvalid_FilterInvalidNode||node instanceof filter_FilterNode||node instanceof calculate_CalculateNode||node instanceof geopoint_GeoPointNode||node instanceof aggregate_AggregateNode||node instanceof lookup_LookupNode||node instanceof window_WindowTransformNode||node instanceof joinaggregate_JoinAggregateTransformNode||node instanceof fold_FoldTransformNode||node instanceof flatten_FlattenTransformNode||node instanceof density_DensityTransformNode||node instanceof loess_LoessTransformNode||node instanceof quantile_QuantileTransformNode||node instanceof regression_RegressionTransformNode||node instanceof identifier_IdentifierNode||node instanceof sample_SampleTransformNode||node instanceof pivot_PivotTransformNode||node instanceof extent_ExtentTransformNode){dataSource.transform.push(node.assemble())}if(node instanceof bin_BinNode||node instanceof timeunit_TimeUnitNode||node instanceof impute_ImputeNode||node instanceof stack_StackNode||node instanceof geojson_GeoJSONNode){dataSource.transform.push(...node.assemble())}if(node instanceof dataflow_OutputNode){if(dataSource.source&&dataSource.transform.length===0){node.setSource(dataSource.source)}else if(node.parent instanceof dataflow_OutputNode){node.setSource(dataSource.name)}else{if(!dataSource.name){dataSource.name=`data_${datasetIndex++}`}node.setSource(dataSource.name);if(node.numChildren()===1){data.push(dataSource);const newData={name:null,source:dataSource.name,transform:[]};dataSource=newData}}}switch(node.numChildren()){case 0:if(node instanceof dataflow_OutputNode&&(!dataSource.source||dataSource.transform.length>0)){data.push(dataSource)}break;case 1:walkTree(node.children[0],dataSource);break;default:{if(!dataSource.name){dataSource.name=`data_${datasetIndex++}`}let source=dataSource.name;if(!dataSource.source||dataSource.transform.length>0){data.push(dataSource)}else{source=dataSource.source}for(const child of node.children){const newData={name:null,source:source,transform:[]};walkTree(child,newData)}break}}}return walkTree}function assembleFacetData(root){const data=[];const walkTree=makeWalkTree(data);for(const child of root.children){walkTree(child,{source:root.name,name:null,transform:[]})}return data}function assembleRootData(dataComponent,datasets){const data=[];const walkTree=makeWalkTree(data);let sourceIndex=0;for(const root of dataComponent.sources){if(!root.hasName()){root.dataName=`source_${sourceIndex++}`}const newData=root.assemble();walkTree(root,newData)}for(const d of data){if(d.transform.length===0){delete d.transform}}let whereTo=0;for(const[i,d]of data.entries()){var _d$transform;if(((_d$transform=d.transform)!==null&&_d$transform!==void 0?_d$transform:[]).length===0&&!d.source){data.splice(whereTo++,0,data.splice(i,1)[0])}}for(const d of data){for(const t of(_d$transform2=d.transform)!==null&&_d$transform2!==void 0?_d$transform2:[]){var _d$transform2;if(t.type==="lookup"){t.from=dataComponent.outputNodes[t.from].getSource()}}}for(const d of data){if(d.name in datasets){d.values=datasets[d.name]}}return data}function getHeaderType(orient){if(orient==="top"||orient==="left"||isSignalRef(orient)){return"header"}return"footer"}function parseFacetHeaders(model){for(const channel of FACET_CHANNELS){parseFacetHeader(model,channel)}mergeChildAxis(model,"x");mergeChildAxis(model,"y")}function parseFacetHeader(model,channel){const{facet:facet,config:config,child:child,component:component}=model;if(model.channelHasField(channel)){var _fieldDef$header;const fieldDef=facet[channel];const titleConfig=getHeaderProperty("title",null,config,channel);let title=channeldef_title(fieldDef,config,{allowDisabling:true,includeDefault:titleConfig===undefined||!!titleConfig});if(child.component.layoutHeaders[channel].title){title=Object(vega_util["isArray"])(title)?title.join(", "):title;title+=` / ${child.component.layoutHeaders[channel].title}`;child.component.layoutHeaders[channel].title=null}const labelOrient=getHeaderProperty("labelOrient",fieldDef.header,config,channel);const labels=fieldDef.header!==null?getFirstDefined((_fieldDef$header=fieldDef.header)===null||_fieldDef$header===void 0?void 0:_fieldDef$header.labels,config.header.labels,true):false;const headerType=util_contains(["bottom","right"],labelOrient)?"footer":"header";component.layoutHeaders[channel]={title:fieldDef.header!==null?title:null,facetFieldDef:fieldDef,[headerType]:channel==="facet"?[]:[makeHeaderComponent(model,channel,labels)]}}}function makeHeaderComponent(model,channel,labels){const sizeType=channel==="row"?"height":"width";return{labels:labels,sizeSignal:model.child.component.layoutSize.get(sizeType)?model.child.getSizeSignalRef(sizeType):undefined,axes:[]}}function mergeChildAxis(model,channel){const{child:child}=model;if(child.component.axes[channel]){const{layoutHeaders:layoutHeaders,resolve:resolve}=model.component;resolve.axis[channel]=parseGuideResolve(resolve,channel);if(resolve.axis[channel]==="shared"){const headerChannel=channel==="x"?"column":"row";const layoutHeader=layoutHeaders[headerChannel];for(const axisComponent of child.component.axes[channel]){var _layoutHeader$headerT;const headerType=getHeaderType(axisComponent.get("orient"));(_layoutHeader$headerT=layoutHeader[headerType])!==null&&_layoutHeader$headerT!==void 0?_layoutHeader$headerT:layoutHeader[headerType]=[makeHeaderComponent(model,headerChannel,false)];const mainAxis=assembleAxis(axisComponent,"main",model.config,{header:true});if(mainAxis){layoutHeader[headerType][0].axes.push(mainAxis)}axisComponent.mainExtracted=true}}else{}}}function parseLayerLayoutSize(model){parseChildrenLayoutSize(model);parseNonUnitLayoutSizeForChannel(model,"width");parseNonUnitLayoutSizeForChannel(model,"height")}function parseConcatLayoutSize(model){parseChildrenLayoutSize(model);const widthType=model.layout.columns===1?"width":"childWidth";const heightType=model.layout.columns===undefined?"height":"childHeight";parseNonUnitLayoutSizeForChannel(model,widthType);parseNonUnitLayoutSizeForChannel(model,heightType)}function parseChildrenLayoutSize(model){for(const child of model.children){child.parseLayoutSize()}}function parseNonUnitLayoutSizeForChannel(model,layoutSizeType){const sizeType=getSizeTypeFromLayoutSizeType(layoutSizeType);const channel=getPositionScaleChannel(sizeType);const resolve=model.component.resolve;const layoutSizeCmpt=model.component.layoutSize;let mergedSize;for(const child of model.children){var _resolve$scale$channe;const childSize=child.component.layoutSize.getWithExplicit(sizeType);const scaleResolve=(_resolve$scale$channe=resolve.scale[channel])!==null&&_resolve$scale$channe!==void 0?_resolve$scale$channe:defaultScaleResolve(channel,model);if(scaleResolve==="independent"&&childSize.value==="step"){mergedSize=undefined;break}if(mergedSize){if(scaleResolve==="independent"&&mergedSize.value!==childSize.value){mergedSize=undefined;break}mergedSize=mergeValuesWithExplicit(mergedSize,childSize,sizeType,"")}else{mergedSize=childSize}}if(mergedSize){for(const child of model.children){model.renameSignal(child.getName(sizeType),model.getName(layoutSizeType));child.component.layoutSize.set(sizeType,"merged",false)}layoutSizeCmpt.setWithExplicit(layoutSizeType,mergedSize)}else{layoutSizeCmpt.setWithExplicit(layoutSizeType,{explicit:false,value:undefined})}}function parseUnitLayoutSize(model){const{size:size,component:component}=model;for(const channel of POSITION_SCALE_CHANNELS){const sizeType=getSizeChannel(channel);if(size[sizeType]){const specifiedSize=size[sizeType];component.layoutSize.set(sizeType,isStep(specifiedSize)?"step":specifiedSize,true)}else{const defaultSize=defaultUnitSize(model,sizeType);component.layoutSize.set(sizeType,defaultSize,false)}}}function defaultUnitSize(model,sizeType){const channel=sizeType==="width"?"x":"y";const config=model.config;const scaleComponent=model.getScaleComponent(channel);if(scaleComponent){const scaleType=scaleComponent.get("type");const range=scaleComponent.get("range");if(hasDiscreteDomain(scaleType)){const size=getViewConfigDiscreteSize(config.view,sizeType);if(isVgRangeStep(range)||isStep(size)){return"step"}else{return size}}else{return getViewConfigContinuousSize(config.view,sizeType)}}else if(model.hasProjection||model.mark==="arc"){return getViewConfigContinuousSize(config.view,sizeType)}else{const size=getViewConfigDiscreteSize(config.view,sizeType);return isStep(size)?size.step:size}}function compile_facet_defineProperty(e,r,t){return(r=compile_facet_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function compile_facet_toPropertyKey(t){var i=compile_facet_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function compile_facet_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}function facetSortFieldName(fieldDef,sort,opt){return vgField(sort,{suffix:`by_${vgField(fieldDef)}`,...opt})}class facet_FacetModel extends model_ModelWithField{constructor(spec,parent,parentGivenName,config){super(spec,"facet",parent,parentGivenName,config,spec.resolve);compile_facet_defineProperty(this,"facet",void 0);compile_facet_defineProperty(this,"child",void 0);compile_facet_defineProperty(this,"children",void 0);this.child=buildModel(spec.spec,this,this.getName("child"),undefined,config);this.children=[this.child];this.facet=this.initFacet(spec.facet)}initFacet(facet){if(!isFacetMapping(facet)){return{facet:this.initFacetFieldDef(facet,"facet")}}const channels=keys(facet);const normalizedFacet={};for(const channel of channels){if(![ROW,COLUMN].includes(channel)){warn(message_namespaceObject.incompatibleChannel(channel,"facet"));break}const fieldDef=facet[channel];if(fieldDef.field===undefined){warn(message_namespaceObject.emptyFieldDef(fieldDef,channel));break}normalizedFacet[channel]=this.initFacetFieldDef(fieldDef,channel)}return normalizedFacet}initFacetFieldDef(fieldDef,channel){const facetFieldDef=initFieldDef(fieldDef,channel);if(facetFieldDef.header){facetFieldDef.header=replaceExprRef(facetFieldDef.header)}else if(facetFieldDef.header===null){facetFieldDef.header=null}return facetFieldDef}channelHasField(channel){return hasProperty(this.facet,channel)}fieldDef(channel){return this.facet[channel]}parseData(){this.component.data=parseData(this);this.child.parseData()}parseLayoutSize(){parseChildrenLayoutSize(this)}parseSelections(){this.child.parseSelections();this.component.selection=this.child.component.selection;if(Object.values(this.component.selection).some(selCmpt=>isTimerSelection(selCmpt))){error(MULTI_VIEW_ANIMATION_UNSUPPORTED)}}parseMarkGroup(){this.child.parseMarkGroup()}parseAxesAndHeaders(){this.child.parseAxesAndHeaders();parseFacetHeaders(this)}assembleSelectionTopLevelSignals(signals){return this.child.assembleSelectionTopLevelSignals(signals)}assembleSignals(){this.child.assembleSignals();return[]}assembleSelectionData(data){return this.child.assembleSelectionData(data)}getHeaderLayoutMixins(){const layoutMixins={};for(const channel of FACET_CHANNELS){for(const headerType of HEADER_TYPES){const layoutHeaderComponent=this.component.layoutHeaders[channel];const headerComponent=layoutHeaderComponent[headerType];const{facetFieldDef:facetFieldDef}=layoutHeaderComponent;if(facetFieldDef){const titleOrient=getHeaderProperty("titleOrient",facetFieldDef.header,this.config,channel);if(["right","bottom"].includes(titleOrient)){var _layoutMixins$titleAn;const headerChannel=getHeaderChannel(channel,titleOrient);(_layoutMixins$titleAn=layoutMixins.titleAnchor)!==null&&_layoutMixins$titleAn!==void 0?_layoutMixins$titleAn:layoutMixins.titleAnchor={};layoutMixins.titleAnchor[headerChannel]="end"}}if(headerComponent!==null&&headerComponent!==void 0&&headerComponent[0]){const sizeType=channel==="row"?"height":"width";const bandType=headerType==="header"?"headerBand":"footerBand";if(channel!=="facet"&&!this.child.component.layoutSize.get(sizeType)){var _layoutMixins$bandTyp;(_layoutMixins$bandTyp=layoutMixins[bandType])!==null&&_layoutMixins$bandTyp!==void 0?_layoutMixins$bandTyp:layoutMixins[bandType]={};layoutMixins[bandType][channel]=.5}if(layoutHeaderComponent.title){var _layoutMixins$offset;(_layoutMixins$offset=layoutMixins.offset)!==null&&_layoutMixins$offset!==void 0?_layoutMixins$offset:layoutMixins.offset={};layoutMixins.offset[channel==="row"?"rowTitle":"columnTitle"]=10}}}}return layoutMixins}assembleDefaultLayout(){const{column:column,row:row}=this.facet;const columns=column?this.columnDistinctSignal():row?1:undefined;let align="all";if(!row&&this.component.resolve.scale.x==="independent"){align="none"}else if(!column&&this.component.resolve.scale.y==="independent"){align="none"}return{...this.getHeaderLayoutMixins(),...columns?{columns:columns}:{},bounds:"full",align:align}}assembleLayoutSignals(){return this.child.assembleLayoutSignals()}columnDistinctSignal(){if(this.parent&&this.parent instanceof facet_FacetModel){return undefined}else{const facetLayoutDataName=this.getName("column_domain");return{signal:`length(data('${facetLayoutDataName}'))`}}}assembleGroupStyle(){return undefined}assembleGroup(signals){if(this.parent&&this.parent instanceof facet_FacetModel){return{...this.channelHasField("column")?{encode:{update:{columns:{field:vgField(this.facet.column,{prefix:"distinct"})}}}}:{},...super.assembleGroup(signals)}}return super.assembleGroup(signals)}getCardinalityAggregateForChild(){const fields=[];const ops=[];const as=[];if(this.child instanceof facet_FacetModel){if(this.child.channelHasField("column")){const field=vgField(this.child.facet.column);fields.push(field);ops.push("distinct");as.push(`distinct_${field}`)}}else{for(const channel of POSITION_SCALE_CHANNELS){const childScaleComponent=this.child.component.scales[channel];if(childScaleComponent&&!childScaleComponent.merged){const type=childScaleComponent.get("type");const range=childScaleComponent.get("range");if(hasDiscreteDomain(type)&&isVgRangeStep(range)){const domain=assembleDomain(this.child,channel);const field=getFieldFromDomain(domain);if(field){fields.push(field);ops.push("distinct");as.push(`distinct_${field}`)}else{warn(message_namespaceObject.unknownField(channel))}}}}}return{fields:fields,ops:ops,as:as}}assembleFacet(){const{name:name,data:data}=this.component.data.facetRoot;const{row:row,column:column}=this.facet;const{fields:fields,ops:ops,as:as}=this.getCardinalityAggregateForChild();const groupby=[];for(const channel of FACET_CHANNELS){const fieldDef=this.facet[channel];if(fieldDef){groupby.push(vgField(fieldDef));const{bin:bin,sort:sort}=fieldDef;if(isBinning(bin)){groupby.push(vgField(fieldDef,{binSuffix:"end"}))}if(isSortField(sort)){const{field:field,op:op=DEFAULT_SORT_OP}=sort;const outputName=facetSortFieldName(fieldDef,sort);if(row&&column){fields.push(outputName);ops.push("max");as.push(outputName)}else{fields.push(field);ops.push(op);as.push(outputName)}}else if(Object(vega_util["isArray"])(sort)){const outputName=sortArrayIndexField(fieldDef,channel);fields.push(outputName);ops.push("max");as.push(outputName)}}}const cross=!!row&&!!column;return{name:name,data:data,groupby:groupby,...cross||fields.length>0?{aggregate:{...cross?{cross:cross}:{},...fields.length?{fields:fields,ops:ops,as:as}:{}}}:{}}}facetSortFields(channel){const{facet:facet}=this;const fieldDef=facet[channel];if(fieldDef){if(isSortField(fieldDef.sort)){return[facetSortFieldName(fieldDef,fieldDef.sort,{expr:"datum"})]}else if(Object(vega_util["isArray"])(fieldDef.sort)){return[sortArrayIndexField(fieldDef,channel,{expr:"datum"})]}return[vgField(fieldDef,{expr:"datum"})]}return[]}facetSortOrder(channel){const{facet:facet}=this;const fieldDef=facet[channel];if(fieldDef){const{sort:sort}=fieldDef;const order=(isSortField(sort)?sort.order:!Object(vega_util["isArray"])(sort)&&sort)||"ascending";return[order]}return[]}assembleLabelTitle(){const{facet:facet,config:config}=this;if(facet.facet){return assembleLabelTitle(facet.facet,"facet",config)}const ORTHOGONAL_ORIENT={row:["top","bottom"],column:["left","right"]};for(const channel of HEADER_CHANNELS){if(facet[channel]){var _facet$channel;const labelOrient=getHeaderProperty("labelOrient",(_facet$channel=facet[channel])===null||_facet$channel===void 0?void 0:_facet$channel.header,config,channel);if(ORTHOGONAL_ORIENT[channel].includes(labelOrient)){return assembleLabelTitle(facet[channel],channel,config)}}}return undefined}assembleMarks(){const{child:child}=this;const facetRoot=this.component.data.facetRoot;const data=assembleFacetData(facetRoot);const encodeEntry=child.assembleGroupEncodeEntry(false);const title=this.assembleLabelTitle()||child.assembleTitle();const style=child.assembleGroupStyle();const markGroup={name:this.getName("cell"),type:"group",...title?{title:title}:{},...style?{style:style}:{},from:{facet:this.assembleFacet()},sort:{field:FACET_CHANNELS.map(c=>this.facetSortFields(c)).flat(),order:FACET_CHANNELS.map(c=>this.facetSortOrder(c)).flat()},...data.length>0?{data:data}:{},...encodeEntry?{encode:{update:encodeEntry}}:{},...child.assembleGroup(assembleFacetSignals(this,[]))};return[markGroup]}getMapping(){return this.facet}}function makeJoinAggregateFromFacet(parent,facet){const{row:row,column:column}=facet;if(row&&column){let newParent=null;for(const fieldDef of[row,column]){if(isSortField(fieldDef.sort)){const{field:field,op:op=DEFAULT_SORT_OP}=fieldDef.sort;parent=newParent=new joinaggregate_JoinAggregateTransformNode(parent,{joinaggregate:[{op:op,field:field,as:facetSortFieldName(fieldDef,fieldDef.sort,{forAs:true})}],groupby:[vgField(fieldDef)]})}}return newParent}return null}function findSource(data,sources){for(const other of sources){var _format,_otherData$format,_format2,_otherData$format2;const otherData=other.data;if(data.name&&other.hasName()&&data.name!==other.dataName){continue}const formatMesh=(_format=data.format)===null||_format===void 0?void 0:_format.mesh;const otherFeature=(_otherData$format=otherData.format)===null||_otherData$format===void 0?void 0:_otherData$format.feature;if(formatMesh&&otherFeature){continue}const formatFeature=(_format2=data.format)===null||_format2===void 0?void 0:_format2.feature;if((formatFeature||otherFeature)&&formatFeature!==otherFeature){continue}const otherMesh=(_otherData$format2=otherData.format)===null||_otherData$format2===void 0?void 0:_otherData$format2.mesh;if((formatMesh||otherMesh)&&formatMesh!==otherMesh){continue}if(isInlineData(data)&&isInlineData(otherData)){if(deepEqual(data.values,otherData.values)){return other}}else if(isUrlData(data)&&isUrlData(otherData)){if(data.url===otherData.url){return other}}else if(isNamedData(data)){if(data.name===other.dataName){return other}}}return null}function parseRoot(model,sources){if(model.data||!model.parent){if(model.data===null){const source=new source_SourceNode({values:[]});sources.push(source);return source}const existingSource=findSource(model.data,sources);if(existingSource){if(!isGenerator(model.data)){existingSource.data.format=mergeDeep({},model.data.format,existingSource.data.format)}if(!existingSource.hasName()&&model.data.name){existingSource.dataName=model.data.name}return existingSource}else{const source=new source_SourceNode(model.data);sources.push(source);return source}}else{return model.parent.component.data.facetRoot?model.parent.component.data.facetRoot:model.parent.component.data.main}}function parseTransformArray(head,model,ancestorParse){let lookupCounter=0;for(const t of model.transforms){let derivedType=undefined;let transformNode;if(isCalculate(t)){transformNode=head=new calculate_CalculateNode(head,t);derivedType="derived"}else if(isFilter(t)){var _ParseNode$makeWithAn;const implicit=getImplicitFromFilterTransform(t);transformNode=head=(_ParseNode$makeWithAn=formatparse_ParseNode.makeWithAncestors(head,{},implicit,ancestorParse))!==null&&_ParseNode$makeWithAn!==void 0?_ParseNode$makeWithAn:head;head=new filter_FilterNode(head,model,t.filter)}else if(isBin(t)){transformNode=head=bin_BinNode.makeFromTransform(head,t,model);derivedType="number"}else if(isTimeUnit(t)){derivedType="date";const parsedAs=ancestorParse.getWithExplicit(t.field);if(parsedAs.value===undefined){head=new formatparse_ParseNode(head,{[t.field]:derivedType});ancestorParse.set(t.field,derivedType,false)}transformNode=head=timeunit_TimeUnitNode.makeFromTransform(head,t)}else if(transform_isAggregate(t)){transformNode=head=aggregate_AggregateNode.makeFromTransform(head,t);derivedType="number";if(requiresSelectionId(model)){head=new identifier_IdentifierNode(head)}}else if(isLookup(t)){transformNode=head=lookup_LookupNode.make(head,model,t,lookupCounter++);derivedType="derived"}else if(isWindow(t)){transformNode=head=new window_WindowTransformNode(head,t);derivedType="number"}else if(isJoinAggregate(t)){transformNode=head=new joinaggregate_JoinAggregateTransformNode(head,t);derivedType="number"}else if(isStack(t)){transformNode=head=stack_StackNode.makeFromTransform(head,t);derivedType="derived"}else if(isFold(t)){transformNode=head=new fold_FoldTransformNode(head,t);derivedType="derived"}else if(isExtent(t)){transformNode=head=new extent_ExtentTransformNode(head,t);derivedType="derived"}else if(isFlatten(t)){transformNode=head=new flatten_FlattenTransformNode(head,t);derivedType="derived"}else if(isPivot(t)){transformNode=head=new pivot_PivotTransformNode(head,t);derivedType="derived"}else if(isSample(t)){head=new sample_SampleTransformNode(head,t)}else if(isImpute(t)){transformNode=head=impute_ImputeNode.makeFromTransform(head,t);derivedType="derived"}else if(isDensity(t)){transformNode=head=new density_DensityTransformNode(head,t);derivedType="derived"}else if(isQuantile(t)){transformNode=head=new quantile_QuantileTransformNode(head,t);derivedType="derived"}else if(isRegression(t)){transformNode=head=new regression_RegressionTransformNode(head,t);derivedType="derived"}else if(isLoess(t)){transformNode=head=new loess_LoessTransformNode(head,t);derivedType="derived"}else{warn(message_namespaceObject.invalidTransformIgnored(t));continue}if(transformNode&&derivedType!==undefined){for(const field of(_transformNode$produc=transformNode.producedFields())!==null&&_transformNode$produc!==void 0?_transformNode$produc:[]){var _transformNode$produc;ancestorParse.set(field,derivedType,false)}}}return head}function parseData(model){var _data$format,_ParseNode$makeExplic,_ParseNode$makeWithAn2;let head=parseRoot(model,model.component.data.sources);const{outputNodes:outputNodes,outputNodeRefCounts:outputNodeRefCounts}=model.component.data;const data=model.data;const newData=data&&(isGenerator(data)||isUrlData(data)||isInlineData(data));const ancestorParse=!newData&&model.parent?model.parent.component.data.ancestorParse.clone():new data_AncestorParse;if(isGenerator(data)){if(isSequenceGenerator(data)){head=new sequence_SequenceNode(head,data.sequence)}else if(isGraticuleGenerator(data)){head=new graticule_GraticuleNode(head,data.graticule)}ancestorParse.parseNothing=true}else if((data===null||data===void 0||(_data$format=data.format)===null||_data$format===void 0?void 0:_data$format.parse)===null){ancestorParse.parseNothing=true}head=(_ParseNode$makeExplic=formatparse_ParseNode.makeExplicit(head,model,ancestorParse))!==null&&_ParseNode$makeExplic!==void 0?_ParseNode$makeExplic:head;head=new identifier_IdentifierNode(head);const parentIsLayer=model.parent&&isLayerModel(model.parent);if(isUnitModel(model)||isFacetModel(model)){if(parentIsLayer){var _BinNode$makeFromEnco;head=(_BinNode$makeFromEnco=bin_BinNode.makeFromEncoding(head,model))!==null&&_BinNode$makeFromEnco!==void 0?_BinNode$makeFromEnco:head}}if(model.transforms.length>0){head=parseTransformArray(head,model,ancestorParse)}const implicitSelection=getImplicitFromSelection(model);const implicitEncoding=getImplicitFromEncoding(model);head=(_ParseNode$makeWithAn2=formatparse_ParseNode.makeWithAncestors(head,{},{...implicitSelection,...implicitEncoding},ancestorParse))!==null&&_ParseNode$makeWithAn2!==void 0?_ParseNode$makeWithAn2:head;if(isUnitModel(model)){head=geojson_GeoJSONNode.parseAll(head,model);head=geopoint_GeoPointNode.parseAll(head,model)}if(isUnitModel(model)||isFacetModel(model)){var _TimeUnitNode$makeFro;if(!parentIsLayer){var _BinNode$makeFromEnco2;head=(_BinNode$makeFromEnco2=bin_BinNode.makeFromEncoding(head,model))!==null&&_BinNode$makeFromEnco2!==void 0?_BinNode$makeFromEnco2:head}head=(_TimeUnitNode$makeFro=timeunit_TimeUnitNode.makeFromEncoding(head,model))!==null&&_TimeUnitNode$makeFro!==void 0?_TimeUnitNode$makeFro:head;head=calculate_CalculateNode.parseAllForSortIndex(head,model)}const raw=head=makeOutputNode(DataSourceType.Raw,model,head);if(isUnitModel(model)){var _ImputeNode$makeFromE,_StackNode$makeFromEn;const agg=aggregate_AggregateNode.makeFromEncoding(head,model);if(agg){head=agg;if(requiresSelectionId(model)){head=new identifier_IdentifierNode(head)}}head=(_ImputeNode$makeFromE=impute_ImputeNode.makeFromEncoding(head,model))!==null&&_ImputeNode$makeFromE!==void 0?_ImputeNode$makeFromE:head;head=(_StackNode$makeFromEn=stack_StackNode.makeFromEncoding(head,model))!==null&&_StackNode$makeFromEn!==void 0?_StackNode$makeFromEn:head}let preFilterInvalid;let dataSourcesForHandlingInvalidValues;if(isUnitModel(model)){const{markDef:markDef,mark:mark,config:config}=model;const invalid=getMarkPropOrConfig("invalid",markDef,config);const{marks:marks,scales:scales}=dataSourcesForHandlingInvalidValues=getDataSourcesForHandlingInvalidValues({invalid:invalid,isPath:isPathMark(mark)});if(marks!==scales&&scales==="include-invalid-values"){preFilterInvalid=head=makeOutputNode(DataSourceType.PreFilterInvalid,model,head)}if(marks==="exclude-invalid-values"){var _FilterInvalidNode$ma;head=(_FilterInvalidNode$ma=filterinvalid_FilterInvalidNode.make(head,model,dataSourcesForHandlingInvalidValues))!==null&&_FilterInvalidNode$ma!==void 0?_FilterInvalidNode$ma:head}}const main=head=makeOutputNode(DataSourceType.Main,model,head);let postFilterInvalid;if(isUnitModel(model)&&dataSourcesForHandlingInvalidValues){const{marks:marks,scales:scales}=dataSourcesForHandlingInvalidValues;if(marks==="include-invalid-values"&&scales==="exclude-invalid-values"){var _FilterInvalidNode$ma2;head=(_FilterInvalidNode$ma2=filterinvalid_FilterInvalidNode.make(head,model,dataSourcesForHandlingInvalidValues))!==null&&_FilterInvalidNode$ma2!==void 0?_FilterInvalidNode$ma2:head;postFilterInvalid=head=makeOutputNode(DataSourceType.PostFilterInvalid,model,head)}}if(isUnitModel(model)){materializeSelections(model,main)}let facetRoot=null;if(isFacetModel(model)){var _makeJoinAggregateFro;const facetName=model.getName("facet");head=(_makeJoinAggregateFro=makeJoinAggregateFromFacet(head,model.facet))!==null&&_makeJoinAggregateFro!==void 0?_makeJoinAggregateFro:head;facetRoot=new facet_FacetNode(head,model,facetName,main.getSource());outputNodes[facetName]=facetRoot}return{...model.component.data,outputNodes:outputNodes,outputNodeRefCounts:outputNodeRefCounts,raw:raw,main:main,facetRoot:facetRoot,ancestorParse:ancestorParse,preFilterInvalid:preFilterInvalid,postFilterInvalid:postFilterInvalid}}function makeOutputNode(dataSourceType,model,head){const{outputNodes:outputNodes,outputNodeRefCounts:outputNodeRefCounts}=model.component.data;const name=model.getDataName(dataSourceType);const node=new dataflow_OutputNode(head,name,dataSourceType,outputNodeRefCounts);outputNodes[name]=node;return node}function concat_defineProperty(e,r,t){return(r=concat_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function concat_toPropertyKey(t){var i=concat_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function concat_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class concat_ConcatModel extends model_Model{constructor(spec,parent,parentGivenName,config){var _spec$resolve,_spec$resolve2;super(spec,"concat",parent,parentGivenName,config,spec.resolve);concat_defineProperty(this,"children",void 0);if(((_spec$resolve=spec.resolve)===null||_spec$resolve===void 0||(_spec$resolve=_spec$resolve.axis)===null||_spec$resolve===void 0?void 0:_spec$resolve.x)==="shared"||((_spec$resolve2=spec.resolve)===null||_spec$resolve2===void 0||(_spec$resolve2=_spec$resolve2.axis)===null||_spec$resolve2===void 0?void 0:_spec$resolve2.y)==="shared"){warn(message_namespaceObject.CONCAT_CANNOT_SHARE_AXIS)}this.children=this.getChildren(spec).map((child,i)=>buildModel(child,this,this.getName(`concat_${i}`),undefined,config))}parseData(){this.component.data=parseData(this);for(const child of this.children){child.parseData()}}parseSelections(){this.component.selection={};for(const child of this.children){child.parseSelections();for(const key of keys(child.component.selection)){this.component.selection[key]=child.component.selection[key]}}if(Object.values(this.component.selection).some(selCmpt=>isTimerSelection(selCmpt))){error(MULTI_VIEW_ANIMATION_UNSUPPORTED)}}parseMarkGroup(){for(const child of this.children){child.parseMarkGroup()}}parseAxesAndHeaders(){for(const child of this.children){child.parseAxesAndHeaders()}}getChildren(spec){if(isVConcatSpec(spec)){return spec.vconcat}else if(isHConcatSpec(spec)){return spec.hconcat}return spec.concat}parseLayoutSize(){parseConcatLayoutSize(this)}parseAxisGroup(){return null}assembleSelectionTopLevelSignals(signals){return this.children.reduce((sg,child)=>child.assembleSelectionTopLevelSignals(sg),signals)}assembleSignals(){this.children.forEach(child=>child.assembleSignals());return[]}assembleLayoutSignals(){const layoutSignals=assembleLayoutSignals(this);for(const child of this.children){layoutSignals.push(...child.assembleLayoutSignals())}return layoutSignals}assembleSelectionData(data){return this.children.reduce((db,child)=>child.assembleSelectionData(db),data)}assembleMarks(){return this.children.map(child=>{const title=child.assembleTitle();const style=child.assembleGroupStyle();const encodeEntry=child.assembleGroupEncodeEntry(false);return{type:"group",name:child.getName("group"),...title?{title:title}:{},...style?{style:style}:{},...encodeEntry?{encode:{update:encodeEntry}}:{},...child.assembleGroup()}})}assembleGroupStyle(){return undefined}assembleDefaultLayout(){const columns=this.layout.columns;return{...columns!=null?{columns:columns}:{},bounds:"full",align:"each"}}}function isFalseOrNull(v){return v===false||v===null}const AXIS_COMPONENT_PROPERTIES_INDEX={disable:1,gridScale:1,scale:1,...COMMON_AXIS_PROPERTIES_INDEX,labelExpr:1,encode:1};const AXIS_COMPONENT_PROPERTIES=keys(AXIS_COMPONENT_PROPERTIES_INDEX);class component_AxisComponent extends split_Split{constructor(){let explicit=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let implicit=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let mainExtracted=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;super();this.explicit=explicit;this.implicit=implicit;this.mainExtracted=mainExtracted}clone(){return new component_AxisComponent(duplicate(this.explicit),duplicate(this.implicit),this.mainExtracted)}hasAxisPart(part){if(part==="axis"){return true}if(part==="grid"||part==="title"){return!!this.get(part)}return!isFalseOrNull(this.get(part))}hasOrientSignalRef(){return isSignalRef(this.explicit.orient)}}function axis_encode_labels(model,channel,specifiedLabelsSpec){var _getFieldOrDatumDef;const{encoding:encoding,config:config}=model;const fieldOrDatumDef=(_getFieldOrDatumDef=getFieldOrDatumDef(encoding[channel]))!==null&&_getFieldOrDatumDef!==void 0?_getFieldOrDatumDef:getFieldOrDatumDef(encoding[getSecondaryRangeChannel(channel)]);const axis=model.axis(channel)||{};const{format:format,formatType:formatType}=axis;if(isCustomFormatType(formatType)){return{text:formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:format,formatType:formatType,config:config}),...specifiedLabelsSpec}}else if(format===undefined&&formatType===undefined&&config.customFormatTypes){if(channelDefType(fieldOrDatumDef)==="quantitative"){if(isPositionFieldOrDatumDef(fieldOrDatumDef)&&fieldOrDatumDef.stack==="normalize"&&config.normalizedNumberFormatType){return{text:formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:config.normalizedNumberFormat,formatType:config.normalizedNumberFormatType,config:config}),...specifiedLabelsSpec}}else if(config.numberFormatType){return{text:formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:config.numberFormat,formatType:config.numberFormatType,config:config}),...specifiedLabelsSpec}}}if(channelDefType(fieldOrDatumDef)==="temporal"&&config.timeFormatType&&isFieldDef(fieldOrDatumDef)&&!fieldOrDatumDef.timeUnit){return{text:formatCustomType({fieldOrDatumDef:fieldOrDatumDef,field:"datum.value",format:config.timeFormat,formatType:config.timeFormatType,config:config}),...specifiedLabelsSpec}}}return specifiedLabelsSpec}function parseUnitAxes(model){return POSITION_SCALE_CHANNELS.reduce((axis,channel)=>{if(model.component.scales[channel]){axis[channel]=[parseAxis(channel,model)]}return axis},{})}const OPPOSITE_ORIENT={bottom:"top",top:"bottom",left:"right",right:"left"};function parseLayerAxes(model){const{axes:axes,resolve:resolve}=model.component;const axisCount={top:0,bottom:0,right:0,left:0};for(const child of model.children){child.parseAxesAndHeaders();for(const channel of keys(child.component.axes)){resolve.axis[channel]=parseGuideResolve(model.component.resolve,channel);if(resolve.axis[channel]==="shared"){axes[channel]=mergeAxisComponents(axes[channel],child.component.axes[channel]);if(!axes[channel]){resolve.axis[channel]="independent";delete axes[channel]}}}}for(const channel of POSITION_SCALE_CHANNELS){for(const child of model.children){if(!child.component.axes[channel]){continue}if(resolve.axis[channel]==="independent"){var _axes$channel;axes[channel]=((_axes$channel=axes[channel])!==null&&_axes$channel!==void 0?_axes$channel:[]).concat(child.component.axes[channel]);for(const axisComponent of child.component.axes[channel]){const{value:orient,explicit:explicit}=axisComponent.getWithExplicit("orient");if(isSignalRef(orient)){continue}if(axisCount[orient]>0&&!explicit){const oppositeOrient=OPPOSITE_ORIENT[orient];if(axisCount[orient]>axisCount[oppositeOrient]){axisComponent.set("orient",oppositeOrient,false)}}axisCount[orient]++}}delete child.component.axes[channel]}if(resolve.axis[channel]==="independent"&&axes[channel]&&axes[channel].length>1){for(const[index,axisCmpt]of(axes[channel]||[]).entries()){if(index>0&&!!axisCmpt.get("grid")&&!axisCmpt.explicit.grid){axisCmpt.implicit.grid=false}}}}}function mergeAxisComponents(mergedAxisCmpts,childAxisCmpts){if(mergedAxisCmpts){if(mergedAxisCmpts.length!==childAxisCmpts.length){return undefined}const length=mergedAxisCmpts.length;for(let i=0;i<length;i++){const merged=mergedAxisCmpts[i];const child=childAxisCmpts[i];if(!!merged!==!!child){return undefined}else if(merged&&child){const mergedOrient=merged.getWithExplicit("orient");const childOrient=child.getWithExplicit("orient");if(mergedOrient.explicit&&childOrient.explicit&&mergedOrient.value!==childOrient.value){return undefined}else{mergedAxisCmpts[i]=mergeAxisComponent(merged,child)}}}}else{return childAxisCmpts.map(axisComponent=>axisComponent.clone())}return mergedAxisCmpts}function mergeAxisComponent(merged,child){for(const prop of AXIS_COMPONENT_PROPERTIES){const mergedValueWithExplicit=mergeValuesWithExplicit(merged.getWithExplicit(prop),child.getWithExplicit(prop),prop,"axis",(v1,v2)=>{switch(prop){case"title":return mergeTitleComponent(v1,v2);case"gridScale":return{explicit:v1.explicit,value:getFirstDefined(v1.value,v2.value)}}return defaultTieBreaker(v1,v2,prop,"axis")});merged.setWithExplicit(prop,mergedValueWithExplicit)}return merged}function parse_isExplicit(value,property,axis,model,channel){if(property==="disable"){return axis!==undefined}axis=axis||{};switch(property){case"titleAngle":case"labelAngle":return value===(isSignalRef(axis.labelAngle)?axis.labelAngle:normalizeAngle(axis.labelAngle));case"values":return!!axis.values;case"encode":return!!axis.encoding||!!axis.labelAngle;case"title":if(value===getFieldDefTitle(model,channel)){return true}}return value===axis[property]}const propsToAlwaysIncludeConfig=new Set(["grid","translate","format","formatType","orient","labelExpr","tickCount","position","tickMinStep"]);function parseAxis(channel,model){var _axis,_config,_config$axis,_axis2,_axis$encoding;let axis=model.axis(channel);const axisComponent=new component_AxisComponent;const fieldOrDatumDef=getFieldOrDatumDef(model.encoding[channel]);const{mark:mark,config:config}=model;const orient=((_axis=axis)===null||_axis===void 0?void 0:_axis.orient)||((_config=config[channel==="x"?"axisX":"axisY"])===null||_config===void 0?void 0:_config.orient)||((_config$axis=config.axis)===null||_config$axis===void 0?void 0:_config$axis.orient)||defaultOrient(channel);const scaleType=model.getScaleComponent(channel).get("type");const axisConfigs=getAxisConfigs(channel,scaleType,orient,model.config);const disable=axis!==undefined?!axis:getAxisConfig("disable",config.style,(_axis2=axis)===null||_axis2===void 0?void 0:_axis2.style,axisConfigs).configValue;axisComponent.set("disable",disable,axis!==undefined);if(disable){return axisComponent}axis=axis||{};const labelAngle=getLabelAngle(fieldOrDatumDef,axis,channel,config.style,axisConfigs);const formatType=guideFormatType(axis.formatType,fieldOrDatumDef,scaleType);const format=guideFormat(fieldOrDatumDef,fieldOrDatumDef.type,axis.format,axis.formatType,config,true);const ruleParams={fieldOrDatumDef:fieldOrDatumDef,axis:axis,channel:channel,model:model,scaleType:scaleType,orient:orient,labelAngle:labelAngle,format:format,formatType:formatType,mark:mark,config:config};for(const property of AXIS_COMPONENT_PROPERTIES){const value=property in axisRules?axisRules[property](ruleParams):isAxisProperty(property)?axis[property]:undefined;const hasValue=value!==undefined;const explicit=parse_isExplicit(value,property,axis,model,channel);if(hasValue&&explicit){axisComponent.set(property,value,explicit)}else{const{configValue:configValue=undefined,configFrom:configFrom=undefined}=isAxisProperty(property)&&property!=="values"?getAxisConfig(property,config.style,axis.style,axisConfigs):{};const hasConfigValue=configValue!==undefined;if(hasValue&&!hasConfigValue){axisComponent.set(property,value,explicit)}else if(!(configFrom==="vgAxisConfig")||propsToAlwaysIncludeConfig.has(property)&&hasConfigValue||isConditionalAxisValue(configValue)||isSignalRef(configValue)){axisComponent.set(property,configValue,false)}}}const axisEncoding=(_axis$encoding=axis.encoding)!==null&&_axis$encoding!==void 0?_axis$encoding:{};const axisEncode=AXIS_PARTS.reduce((e,part)=>{var _axisEncoding$part;if(!axisComponent.hasAxisPart(part)){return e}const axisEncodingPart=guideEncodeEntry((_axisEncoding$part=axisEncoding[part])!==null&&_axisEncoding$part!==void 0?_axisEncoding$part:{},model);const value=part==="labels"?axis_encode_labels(model,channel,axisEncodingPart):axisEncodingPart;if(value!==undefined&&!isEmpty(value)){e[part]={update:value}}return e},{});if(!isEmpty(axisEncode)){axisComponent.set("encode",axisEncode,!!axis.encoding||axis.labelAngle!==undefined)}return axisComponent}function initLayoutSize(_ref){let{encoding:encoding,size:size}=_ref;for(const channel of POSITION_SCALE_CHANNELS){const sizeType=getSizeChannel(channel);if(isStep(size[sizeType])){if(isContinuousFieldOrDatumDef(encoding[channel])){delete size[sizeType];warn(message_namespaceObject.stepDropped(sizeType))}}}return size}const arc={vgMark:"arc",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"ignore",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...rectPosition(model,"radius"),...rectPosition(model,"theta")})};const area_area={vgMark:"area",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"include",size:"ignore",theta:"ignore"}),...pointOrRangePosition("x",model,{defaultPos:"zeroOrMin",defaultPos2:"zeroOrMin",range:model.markDef.orient==="horizontal"}),...pointOrRangePosition("y",model,{defaultPos:"zeroOrMin",defaultPos2:"zeroOrMin",range:model.markDef.orient==="vertical"}),...defined(model)})};const bar={vgMark:"rect",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,"x"),...rectPosition(model,"y")})};const geoshape={vgMark:"shape",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"ignore",orient:"ignore",theta:"ignore"})}),postEncodingTransform:model=>{const{encoding:encoding}=model;const shapeDef=encoding.shape;const transform={type:"geoshape",projection:model.projectionName(),...shapeDef&&isFieldDef(shapeDef)&&shapeDef.type===GEOJSON?{field:vgField(shapeDef,{expr:"datum"})}:{}};return[transform]}};const image_image={vgMark:"image",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"ignore",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,"x"),...rectPosition(model,"y"),...text_text(model,"url")})};const line={vgMark:"line",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"ignore",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...nonPosition("size",model,{vgChannel:"strokeWidth"}),...defined(model)})};const trail={vgMark:"trail",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"include",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...nonPosition("size",model),...defined(model)})};function point_encodeEntry(model,fixedShape){const{config:config}=model;return{...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",size:"include",orient:"ignore",theta:"ignore"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...nonPosition("size",model),...nonPosition("angle",model),...shapeMixins(model,config,fixedShape)}}function shapeMixins(model,config,fixedShape){if(fixedShape){return{shape:{value:fixedShape}}}return nonPosition("shape",model)}const point_point={vgMark:"symbol",encodeEntry:model=>point_encodeEntry(model)};const circle={vgMark:"symbol",encodeEntry:model=>point_encodeEntry(model,"circle")};const square={vgMark:"symbol",encodeEntry:model=>point_encodeEntry(model,"square")};const rect={vgMark:"rect",encodeEntry:model=>({...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,"x"),...rectPosition(model,"y")})};const rule={vgMark:"rule",encodeEntry:model=>{const{markDef:markDef}=model;const orient=markDef.orient;if(!model.encoding.x&&!model.encoding.y&&!model.encoding.latitude&&!model.encoding.longitude){return{}}return{...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...pointOrRangePosition("x",model,{defaultPos:orient==="horizontal"?"zeroOrMax":"mid",defaultPos2:"zeroOrMin",range:orient!=="vertical"}),...pointOrRangePosition("y",model,{defaultPos:orient==="vertical"?"zeroOrMax":"mid",defaultPos2:"zeroOrMin",range:orient!=="horizontal"}),...nonPosition("size",model,{vgChannel:"strokeWidth"})}}};const mark_text_text={vgMark:"text",encodeEntry:model=>{const{config:config,encoding:encoding}=model;return{...baseEncodeEntry(model,{align:"include",baseline:"include",color:"include",size:"ignore",orient:"ignore",theta:"include"}),...pointPosition("x",model,{defaultPos:"mid"}),...pointPosition("y",model,{defaultPos:"mid"}),...text_text(model),...nonPosition("size",model,{vgChannel:"fontSize"}),...nonPosition("angle",model),...valueIfDefined("align",text_align(model.markDef,encoding,config)),...valueIfDefined("baseline",text_baseline(model.markDef,encoding,config)),...pointPosition("radius",model,{defaultPos:null}),...pointPosition("theta",model,{defaultPos:null})}}};function text_align(markDef,encoding,config){const a=getMarkPropOrConfig("align",markDef,config);if(a===undefined){return"center"}return undefined}function text_baseline(markDef,encoding,config){const b=getMarkPropOrConfig("baseline",markDef,config);if(b===undefined){return"middle"}return undefined}const tick_tick={vgMark:"rect",encodeEntry:model=>{const{config:config,markDef:markDef}=model;const orient=markDef.orient;const vgSizeAxisChannel=orient==="horizontal"?"x":"y";const vgThicknessAxisChannel=orient==="horizontal"?"y":"x";const vgThicknessChannel=orient==="horizontal"?"height":"width";return{...baseEncodeEntry(model,{align:"ignore",baseline:"ignore",color:"include",orient:"ignore",size:"ignore",theta:"ignore"}),...rectPosition(model,vgSizeAxisChannel),...pointPosition(vgThicknessAxisChannel,model,{defaultPos:"mid",vgChannel:vgThicknessAxisChannel==="y"?"yc":"xc"}),[vgThicknessChannel]:signalOrValueRef(getMarkPropOrConfig("thickness",markDef,config))}}};const markCompiler={arc:arc,area:area_area,bar:bar,circle:circle,geoshape:geoshape,image:image_image,line:line,point:point_point,rect:rect,rule:rule,square:square,text:mark_text_text,tick:tick_tick,trail:trail};function parseMarkGroups(model){if(util_contains([LINE,AREA,TRAIL],model.mark)){const details=pathGroupingFields(model.mark,model.encoding);if(details.length>0){return getPathGroups(model,details)}}else if(model.mark===BAR){const hasCornerRadius=VG_CORNERRADIUS_CHANNELS.some(prop=>getMarkPropOrConfig(prop,model.markDef,model.config));if(model.stack&&!model.fieldDef("size")&&hasCornerRadius){return getGroupsForStackedBarWithCornerRadius(model)}}return getMarkGroup(model)}const FACETED_PATH_PREFIX="faceted_path_";function getPathGroups(model,details){return[{name:model.getName("pathgroup"),type:"group",from:{facet:{name:FACETED_PATH_PREFIX+model.requestDataName(DataSourceType.Main),data:model.requestDataName(DataSourceType.Main),groupby:details}},encode:{update:{width:{field:{group:"width"}},height:{field:{group:"height"}}}},marks:getMarkGroup(model,{fromPrefix:FACETED_PATH_PREFIX})}]}const STACK_GROUP_PREFIX="stack_group_";function getGroupsForStackedBarWithCornerRadius(model){var _model$stack$groupbyC;const[mark]=getMarkGroup(model,{fromPrefix:STACK_GROUP_PREFIX});const fieldScale=model.scaleName(model.stack.fieldChannel);const stackField=function(){let opt=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};return model.vgField(model.stack.fieldChannel,opt)};const stackFieldGroup=(func,expr)=>{const vgFieldMinMax=[stackField({prefix:"min",suffix:"start",expr:expr}),stackField({prefix:"max",suffix:"start",expr:expr}),stackField({prefix:"min",suffix:"end",expr:expr}),stackField({prefix:"max",suffix:"end",expr:expr})];return`${func}(${vgFieldMinMax.map(field=>`scale('${fieldScale}',${field})`).join(",")})`};let groupUpdate;let innerGroupUpdate;if(model.stack.fieldChannel==="x"){groupUpdate={...pick(mark.encode.update,["y","yc","y2","height",...VG_CORNERRADIUS_CHANNELS]),x:{signal:stackFieldGroup("min","datum")},x2:{signal:stackFieldGroup("max","datum")},clip:{value:true}};innerGroupUpdate={x:{field:{group:"x"},mult:-1},height:{field:{group:"height"}}};mark.encode.update={...omit(mark.encode.update,["y","yc","y2"]),height:{field:{group:"height"}}}}else{groupUpdate={...pick(mark.encode.update,["x","xc","x2","width"]),y:{signal:stackFieldGroup("min","datum")},y2:{signal:stackFieldGroup("max","datum")},clip:{value:true}};innerGroupUpdate={y:{field:{group:"y"},mult:-1},width:{field:{group:"width"}}};mark.encode.update={...omit(mark.encode.update,["x","xc","x2"]),width:{field:{group:"width"}}}}for(const key of VG_CORNERRADIUS_CHANNELS){const configValue=getMarkConfig(key,model.markDef,model.config);if(mark.encode.update[key]){groupUpdate[key]=mark.encode.update[key];delete mark.encode.update[key]}else if(configValue){groupUpdate[key]=signalOrValueRef(configValue)}if(configValue){mark.encode.update[key]={value:0}}}const groupby=[];if(((_model$stack$groupbyC=model.stack.groupbyChannels)===null||_model$stack$groupbyC===void 0?void 0:_model$stack$groupbyC.length)>0){for(const groupbyChannel of model.stack.groupbyChannels){const groupByField=model.fieldDef(groupbyChannel);const field=vgField(groupByField);if(field){groupby.push(field)}if(groupByField!==null&&groupByField!==void 0&&groupByField.bin||groupByField!==null&&groupByField!==void 0&&groupByField.timeUnit){groupby.push(vgField(groupByField,{binSuffix:"end"}))}}}const strokeProperties=["stroke","strokeWidth","strokeJoin","strokeCap","strokeDash","strokeDashOffset","strokeMiterLimit","strokeOpacity"];groupUpdate=strokeProperties.reduce((encode,prop)=>{if(mark.encode.update[prop]){return{...encode,[prop]:mark.encode.update[prop]}}else{const configValue=getMarkConfig(prop,model.markDef,model.config);if(configValue!==undefined){return{...encode,[prop]:signalOrValueRef(configValue)}}else{return encode}}},groupUpdate);if(groupUpdate.stroke){groupUpdate.strokeForeground={value:true};groupUpdate.strokeOffset={value:0}}return[{type:"group",from:{facet:{data:model.requestDataName(DataSourceType.Main),name:STACK_GROUP_PREFIX+model.requestDataName(DataSourceType.Main),groupby:groupby,aggregate:{fields:[stackField({suffix:"start"}),stackField({suffix:"start"}),stackField({suffix:"end"}),stackField({suffix:"end"})],ops:["min","max","min","max"]}}},encode:{update:groupUpdate},marks:[{type:"group",encode:{update:innerGroupUpdate},marks:[mark]}]}]}function mark_getSort(model){const{encoding:encoding,stack:stack,mark:mark,markDef:markDef,config:config}=model;const order=encoding.order;if(!Object(vega_util["isArray"])(order)&&isValueDef(order)&&isNullOrFalse(order.value)||!order&&isNullOrFalse(getMarkPropOrConfig("order",markDef,config))){return undefined}else if((Object(vega_util["isArray"])(order)||isFieldDef(order))&&!stack){return sortParams(order,{expr:"datum"})}else if(isPathMark(mark)){const dimensionChannel=markDef.orient==="horizontal"?"y":"x";const dimensionChannelDef=encoding[dimensionChannel];if(isFieldDef(dimensionChannelDef)){return{field:dimensionChannel}}}return undefined}function getMarkGroup(model){let opt=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{fromPrefix:""};const{mark:mark,markDef:markDef,encoding:encoding,config:config}=model;const clip=getFirstDefined(markDef.clip,scaleClip(model),projectionClip(model));const style=getStyles(markDef);const key=encoding.key;const sort=mark_getSort(model);const interactive=interactiveFlag(model);const aria=getMarkPropOrConfig("aria",markDef,config);const postEncodingTransform=markCompiler[mark].postEncodingTransform?markCompiler[mark].postEncodingTransform(model):null;return[{name:model.getName("marks"),type:markCompiler[mark].vgMark,...clip?{clip:clip}:{},...style?{style:style}:{},...key?{key:key.field}:{},...sort?{sort:sort}:{},...interactive?interactive:{},...aria===false?{aria:aria}:{},from:{data:opt.fromPrefix+model.requestDataName(DataSourceType.Main)},encode:{update:markCompiler[mark].encodeEntry(model)},...postEncodingTransform?{transform:postEncodingTransform}:{}}]}function scaleClip(model){const xScale=model.getScaleComponent("x");const yScale=model.getScaleComponent("y");return xScale!==null&&xScale!==void 0&&xScale.get("selectionExtent")||yScale!==null&&yScale!==void 0&&yScale.get("selectionExtent")?true:undefined}function projectionClip(model){const projection=model.component.projection;return projection&&!projection.isFit?true:undefined}function interactiveFlag(model){if(!model.component.selection)return null;const unitCount=keys(model.component.selection).length;let parentCount=unitCount;let parent=model.parent;while(parent&&parentCount===0){parentCount=keys(parent.component.selection).length;parent=parent.parent}return parentCount?{interactive:unitCount>0||model.mark==="geoshape"||!!model.encoding.tooltip||!!model.markDef.tooltip}:null}function unit_defineProperty(e,r,t){return(r=unit_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function unit_toPropertyKey(t){var i=unit_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function unit_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class unit_UnitModel extends model_ModelWithField{constructor(spec,parent,parentGivenName){var _spec$params;let parentGivenSize=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};let config=arguments.length>4?arguments[4]:undefined;super(spec,"unit",parent,parentGivenName,config,undefined,isFrameMixins(spec)?spec.view:undefined);unit_defineProperty(this,"markDef",void 0);unit_defineProperty(this,"encoding",void 0);unit_defineProperty(this,"specifiedScales",{});unit_defineProperty(this,"stack",void 0);unit_defineProperty(this,"specifiedAxes",{});unit_defineProperty(this,"specifiedLegends",{});unit_defineProperty(this,"specifiedProjection",{});unit_defineProperty(this,"selection",[]);unit_defineProperty(this,"children",[]);unit_defineProperty(this,"correctDataNames",mark=>{var _mark$from,_mark$from2;if((_mark$from=mark.from)!==null&&_mark$from!==void 0&&_mark$from.data){mark.from.data=this.lookupDataSource(mark.from.data);if("time"in this.encoding){mark.from.data=mark.from.data+CURR}}if((_mark$from2=mark.from)!==null&&_mark$from2!==void 0&&(_mark$from2=_mark$from2.facet)!==null&&_mark$from2!==void 0&&_mark$from2.data){mark.from.facet.data=this.lookupDataSource(mark.from.facet.data)}return mark});const markDef=isMarkDef(spec.mark)?{...spec.mark}:{type:spec.mark};const _mark=markDef.type;if(markDef.filled===undefined){markDef.filled=defaultFilled(markDef,config,{graticule:spec.data&&isGraticuleGenerator(spec.data)})}const encoding=this.encoding=initEncoding(spec.encoding||{},_mark,markDef.filled,config);this.markDef=initMarkdef(markDef,encoding,config);this.size=initLayoutSize({encoding:encoding,size:isFrameMixins(spec)?{...parentGivenSize,...spec.width?{width:spec.width}:{},...spec.height?{height:spec.height}:{}}:parentGivenSize});this.stack=stack_stack(this.markDef,encoding);this.specifiedScales=this.initScales(_mark,encoding);this.specifiedAxes=this.initAxes(encoding);this.specifiedLegends=this.initLegends(encoding);this.specifiedProjection=spec.projection;this.selection=((_spec$params=spec.params)!==null&&_spec$params!==void 0?_spec$params:[]).filter(p=>isSelectionParameter(p))}get hasProjection(){const{encoding:encoding}=this;const isGeoShapeMark=this.mark===GEOSHAPE;const hasGeoPosition=encoding&&GEOPOSITION_CHANNELS.some(channel=>isFieldOrDatumDef(encoding[channel]));return isGeoShapeMark||hasGeoPosition}scaleDomain(channel){const scale=this.specifiedScales[channel];return scale?scale.domain:undefined}axis(channel){return this.specifiedAxes[channel]}legend(channel){return this.specifiedLegends[channel]}initScales(mark,encoding){return SCALE_CHANNELS.reduce((scales,channel)=>{const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);if(fieldOrDatumDef){var _fieldOrDatumDef$scal;scales[channel]=this.initScale((_fieldOrDatumDef$scal=fieldOrDatumDef.scale)!==null&&_fieldOrDatumDef$scal!==void 0?_fieldOrDatumDef$scal:{})}return scales},{})}initScale(scale){const{domain:domain,range:range}=scale;const scaleInternal=replaceExprRef(scale);if(Object(vega_util["isArray"])(domain)){scaleInternal.domain=domain.map(signalRefOrValue)}if(Object(vega_util["isArray"])(range)){scaleInternal.range=range.map(signalRefOrValue)}return scaleInternal}initAxes(encoding){return POSITION_SCALE_CHANNELS.reduce((_axis,channel)=>{const channelDef=encoding[channel];if(isFieldOrDatumDef(channelDef)||channel===X&&isFieldOrDatumDef(encoding.x2)||channel===Y&&isFieldOrDatumDef(encoding.y2)){const axisSpec=isFieldOrDatumDef(channelDef)?channelDef.axis:undefined;_axis[channel]=axisSpec?this.initAxis({...axisSpec}):axisSpec}return _axis},{})}initAxis(axis){const props=keys(axis);const axisInternal={};for(const prop of props){const val=axis[prop];axisInternal[prop]=isConditionalAxisValue(val)?signalOrValueRefWithCondition(val):signalRefOrValue(val)}return axisInternal}initLegends(encoding){return NONPOSITION_SCALE_CHANNELS.reduce((_legend,channel)=>{const fieldOrDatumDef=getFieldOrDatumDef(encoding[channel]);if(fieldOrDatumDef&&supportLegend(channel)){const legend=fieldOrDatumDef.legend;_legend[channel]=legend?replaceExprRef(legend):legend}return _legend},{})}parseData(){this.component.data=parseData(this)}parseLayoutSize(){parseUnitLayoutSize(this)}parseSelections(){this.component.selection=parseUnitSelection(this,this.selection)}parseMarkGroup(){this.component.mark=parseMarkGroups(this)}parseAxesAndHeaders(){this.component.axes=parseUnitAxes(this)}assembleSelectionTopLevelSignals(signals){return assembleTopLevelSignals(this,signals)}assembleSignals(){return[...assembleAxisSignals(this),...assembleUnitSelectionSignals(this,[])]}assembleSelectionData(data){return assembleUnitSelectionData(this,data)}assembleLayout(){return null}assembleLayoutSignals(){return assembleLayoutSignals(this)}assembleMarks(){var _this$component$mark;let marks=(_this$component$mark=this.component.mark)!==null&&_this$component$mark!==void 0?_this$component$mark:[];if(!this.parent||!isLayerModel(this.parent)){marks=assembleUnitSelectionMarks(this,marks)}return marks.map(this.correctDataNames)}assembleGroupStyle(){const{style:style}=this.view||{};if(style!==undefined){return style}if(this.encoding.x||this.encoding.y){return"cell"}else{return"view"}}getMapping(){return this.encoding}get mark(){return this.markDef.type}channelHasField(channel){return channelHasField(this.encoding,channel)}fieldDef(channel){const channelDef=this.encoding[channel];return getFieldDef(channelDef)}typedFieldDef(channel){const fieldDef=this.fieldDef(channel);if(isTypedFieldDef(fieldDef)){return fieldDef}return null}}function layer_defineProperty(e,r,t){return(r=layer_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function layer_toPropertyKey(t){var i=layer_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function layer_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class layer_LayerModel extends model_Model{constructor(spec,parent,parentGivenName,parentGivenSize,config){super(spec,"layer",parent,parentGivenName,config,spec.resolve,spec.view);layer_defineProperty(this,"children",void 0);const layoutSize={...parentGivenSize,...spec.width?{width:spec.width}:{},...spec.height?{height:spec.height}:{}};this.children=spec.layer.map((layer,i)=>{if(isLayerSpec(layer)){return new layer_LayerModel(layer,this,this.getName(`layer_${i}`),layoutSize,config)}else if(isUnitSpec(layer)){return new unit_UnitModel(layer,this,this.getName(`layer_${i}`),layoutSize,config)}throw new Error(message_namespaceObject.invalidSpec(layer))})}parseData(){this.component.data=parseData(this);for(const child of this.children){child.parseData()}}parseLayoutSize(){parseLayerLayoutSize(this)}parseSelections(){this.component.selection={};for(const child of this.children){child.parseSelections();for(const key of keys(child.component.selection)){this.component.selection[key]=child.component.selection[key]}}if(Object.values(this.component.selection).some(selCmpt=>isTimerSelection(selCmpt))){error(MULTI_VIEW_ANIMATION_UNSUPPORTED)}}parseMarkGroup(){for(const child of this.children){child.parseMarkGroup()}}parseAxesAndHeaders(){parseLayerAxes(this)}assembleSelectionTopLevelSignals(signals){return this.children.reduce((sg,child)=>child.assembleSelectionTopLevelSignals(sg),signals)}assembleSignals(){return this.children.reduce((signals,child)=>signals.concat(child.assembleSignals()),assembleAxisSignals(this))}assembleLayoutSignals(){return this.children.reduce((signals,child)=>signals.concat(child.assembleLayoutSignals()),assembleLayoutSignals(this))}assembleSelectionData(data){return this.children.reduce((db,child)=>child.assembleSelectionData(db),data)}assembleGroupStyle(){const uniqueStyles=new Set;for(const child of this.children){for(const style of Object(vega_util["array"])(child.assembleGroupStyle())){uniqueStyles.add(style)}}const styles=Array.from(uniqueStyles);return styles.length>1?styles:styles.length===1?styles[0]:undefined}assembleTitle(){let title=super.assembleTitle();if(title){return title}for(const child of this.children){title=child.assembleTitle();if(title){return title}}return undefined}assembleLayout(){return null}assembleMarks(){return assembleLayerSelectionMarks(this,this.children.flatMap(child=>child.assembleMarks()))}assembleLegends(){return this.children.reduce((legends,child)=>legends.concat(child.assembleLegends()),assembleLegends(this))}}function buildModel(spec,parent,parentGivenName,unitSize,config){if(isFacetSpec(spec)){return new facet_FacetModel(spec,parent,parentGivenName,config)}else if(isLayerSpec(spec)){return new layer_LayerModel(spec,parent,parentGivenName,unitSize,config)}else if(isUnitSpec(spec)){return new unit_UnitModel(spec,parent,parentGivenName,unitSize,config)}else if(isAnyConcatSpec(spec)){return new concat_ConcatModel(spec,parent,parentGivenName,config)}throw new Error(message_namespaceObject.invalidSpec(spec))}function compile(inputSpec){let opt=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(opt.logger){set(opt.logger)}if(opt.fieldTitle){setTitleFormatter(opt.fieldTitle)}try{const config=initConfig(Object(vega_util["mergeConfig"])(opt.config,inputSpec.config));const spec=normalize_normalize(inputSpec,config);const model=buildModel(spec,null,"",undefined,config);model.parse();optimizeDataflow(model.component.data,model);const vgSpec=assembleTopLevelModel(model,getTopLevelProperties(inputSpec,spec.autosize,config,model),inputSpec.datasets,inputSpec.usermeta);return{spec:vgSpec,normalized:spec}}finally{if(opt.logger){log_reset()}if(opt.fieldTitle){resetTitleFormatter()}}}function getTopLevelProperties(inputSpec,autosize,config,model){const width=model.component.layoutSize.get("width");const height=model.component.layoutSize.get("height");if(autosize===undefined){autosize={type:"pad"};if(model.hasAxisOrientSignalRef()){autosize.resize=true}}else if(Object(vega_util["isString"])(autosize)){autosize={type:autosize}}if(width&&height&&isFitType(autosize.type)){if(width==="step"&&height==="step"){warn(message_namespaceObject.droppingFit());autosize.type="pad"}else if(width==="step"||height==="step"){const sizeType=width==="step"?"width":"height";warn(message_namespaceObject.droppingFit(getPositionScaleChannel(sizeType)));const inverseSizeType=sizeType==="width"?"height":"width";autosize.type=getFitType(inverseSizeType)}}return{...keys(autosize).length===1&&autosize.type?autosize.type==="pad"?{}:{autosize:autosize.type}:{autosize:autosize},...extractTopLevelProperties(config,false),...extractTopLevelProperties(inputSpec,true)}}function assembleTopLevelModel(model,topLevelProperties){let datasets=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};let usermeta=arguments.length>3?arguments[3]:undefined;const vgConfig=model.config?stripAndRedirectConfig(model.config):undefined;const rootData=assembleRootData(model.component.data,datasets);const data=model.assembleSelectionData(rootData);const projections=model.assembleProjections();const title=model.assembleTitle();const style=model.assembleGroupStyle();const encodeEntry=model.assembleGroupEncodeEntry(true);let layoutSignals=model.assembleLayoutSignals();layoutSignals=layoutSignals.filter(signal=>{if((signal.name==="width"||signal.name==="height")&&signal.value!==undefined){topLevelProperties[signal.name]=+signal.value;return false}return true});const{params:params,...otherTopLevelProps}=topLevelProperties;return{$schema:"https://vega.github.io/schema/vega/v5.json",...model.description?{description:model.description}:{},...otherTopLevelProps,...title?{title:title}:{},...style?{style:style}:{},...encodeEntry?{encode:{update:encodeEntry}}:{},data:data,...projections.length>0?{projections:projections}:{},...model.assembleGroup([...layoutSignals,...model.assembleSelectionTopLevelSignals([]),...assembleParameterSignals(params)]),...vgConfig?{config:vgConfig}:{},...usermeta?{usermeta:usermeta}:{}}}const version=vega_lite_package.version},,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(67)):undefined})(this,(function(exports,vegaScale){"use strict";class Adder{constructor(){this._partials=new Float64Array(32);this._n=0}add(x){const p=this._partials;let i=0;for(let j=0;j<this._n&&j<32;j++){const y=p[j],hi=x+y,lo=Math.abs(x)<Math.abs(y)?x-(hi-y):y-(hi-x);if(lo)p[i++]=lo;x=hi}p[i]=x;this._n=i+1;return this}valueOf(){const p=this._partials;let n=this._n,x,y,lo,hi=0;if(n>0){hi=p[--n];while(n>0){x=hi;y=p[--n];hi=x+y;lo=y-(hi-x);if(lo)break}if(n>0&&(lo<0&&p[n-1]<0||lo>0&&p[n-1]>0)){y=lo*2;x=hi+y;if(y==x-hi)hi=x}}return hi}}function*flatten(arrays){for(const array of arrays){yield*array}}function merge(arrays){return Array.from(flatten(arrays))}var epsilon$1=1e-6;var epsilon2=1e-12;var pi$1=Math.PI;var halfPi$1=pi$1/2;var quarterPi=pi$1/4;var tau=pi$1*2;var degrees=180/pi$1;var radians=pi$1/180;var abs$1=Math.abs;var atan=Math.atan;var atan2=Math.atan2;var cos$1=Math.cos;var exp=Math.exp;var log=Math.log;var pow=Math.pow;var sin$1=Math.sin;var sign=Math.sign||function(x){return x>0?1:x<0?-1:0};var sqrt$1=Math.sqrt;var tan=Math.tan;function acos(x){return x>1?0:x<-1?pi$1:Math.acos(x)}function asin$1(x){return x>1?halfPi$1:x<-1?-halfPi$1:Math.asin(x)}function noop(){}function streamGeometry(geometry,stream){if(geometry&&streamGeometryType.hasOwnProperty(geometry.type)){streamGeometryType[geometry.type](geometry,stream)}}var streamObjectType={Feature:function(object,stream){streamGeometry(object.geometry,stream)},FeatureCollection:function(object,stream){var features=object.features,i=-1,n=features.length;while(++i<n)streamGeometry(features[i].geometry,stream)}};var streamGeometryType={Sphere:function(object,stream){stream.sphere()},Point:function(object,stream){object=object.coordinates;stream.point(object[0],object[1],object[2])},MultiPoint:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)object=coordinates[i],stream.point(object[0],object[1],object[2])},LineString:function(object,stream){streamLine(object.coordinates,stream,0)},MultiLineString:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)streamLine(coordinates[i],stream,0)},Polygon:function(object,stream){streamPolygon(object.coordinates,stream)},MultiPolygon:function(object,stream){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)streamPolygon(coordinates[i],stream)},GeometryCollection:function(object,stream){var geometries=object.geometries,i=-1,n=geometries.length;while(++i<n)streamGeometry(geometries[i],stream)}};function streamLine(coordinates,stream,closed){var i=-1,n=coordinates.length-closed,coordinate;stream.lineStart();while(++i<n)coordinate=coordinates[i],stream.point(coordinate[0],coordinate[1],coordinate[2]);stream.lineEnd()}function streamPolygon(coordinates,stream){var i=-1,n=coordinates.length;stream.polygonStart();while(++i<n)streamLine(coordinates[i],stream,1);stream.polygonEnd()}function geoStream(object,stream){if(object&&streamObjectType.hasOwnProperty(object.type)){streamObjectType[object.type](object,stream)}else{streamGeometry(object,stream)}}function spherical(cartesian){return[atan2(cartesian[1],cartesian[0]),asin$1(cartesian[2])]}function cartesian(spherical){var lambda=spherical[0],phi=spherical[1],cosPhi=cos$1(phi);return[cosPhi*cos$1(lambda),cosPhi*sin$1(lambda),sin$1(phi)]}function cartesianDot(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function cartesianCross(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]]}function cartesianAddInPlace(a,b){a[0]+=b[0],a[1]+=b[1],a[2]+=b[2]}function cartesianScale(vector,k){return[vector[0]*k,vector[1]*k,vector[2]*k]}function cartesianNormalizeInPlace(d){var l=sqrt$1(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);d[0]/=l,d[1]/=l,d[2]/=l}function compose(a,b){function compose(x,y){return x=a(x,y),b(x[0],x[1])}if(a.invert&&b.invert)compose.invert=function(x,y){return x=b.invert(x,y),x&&a.invert(x[0],x[1])};return compose}function rotationIdentity(lambda,phi){if(abs$1(lambda)>pi$1)lambda-=Math.round(lambda/tau)*tau;return[lambda,phi]}rotationIdentity.invert=rotationIdentity;function rotateRadians(deltaLambda,deltaPhi,deltaGamma){return(deltaLambda%=tau)?deltaPhi||deltaGamma?compose(rotationLambda(deltaLambda),rotationPhiGamma(deltaPhi,deltaGamma)):rotationLambda(deltaLambda):deltaPhi||deltaGamma?rotationPhiGamma(deltaPhi,deltaGamma):rotationIdentity}function forwardRotationLambda(deltaLambda){return function(lambda,phi){lambda+=deltaLambda;if(abs$1(lambda)>pi$1)lambda-=Math.round(lambda/tau)*tau;return[lambda,phi]}}function rotationLambda(deltaLambda){var rotation=forwardRotationLambda(deltaLambda);rotation.invert=forwardRotationLambda(-deltaLambda);return rotation}function rotationPhiGamma(deltaPhi,deltaGamma){var cosDeltaPhi=cos$1(deltaPhi),sinDeltaPhi=sin$1(deltaPhi),cosDeltaGamma=cos$1(deltaGamma),sinDeltaGamma=sin$1(deltaGamma);function rotation(lambda,phi){var cosPhi=cos$1(phi),x=cos$1(lambda)*cosPhi,y=sin$1(lambda)*cosPhi,z=sin$1(phi),k=z*cosDeltaPhi+x*sinDeltaPhi;return[atan2(y*cosDeltaGamma-k*sinDeltaGamma,x*cosDeltaPhi-z*sinDeltaPhi),asin$1(k*cosDeltaGamma+y*sinDeltaGamma)]}rotation.invert=function(lambda,phi){var cosPhi=cos$1(phi),x=cos$1(lambda)*cosPhi,y=sin$1(lambda)*cosPhi,z=sin$1(phi),k=z*cosDeltaGamma-y*sinDeltaGamma;return[atan2(y*cosDeltaGamma+z*sinDeltaGamma,x*cosDeltaPhi+k*sinDeltaPhi),asin$1(k*cosDeltaPhi-x*sinDeltaPhi)]};return rotation}function rotation(rotate){rotate=rotateRadians(rotate[0]*radians,rotate[1]*radians,rotate.length>2?rotate[2]*radians:0);function forward(coordinates){coordinates=rotate(coordinates[0]*radians,coordinates[1]*radians);return coordinates[0]*=degrees,coordinates[1]*=degrees,coordinates}forward.invert=function(coordinates){coordinates=rotate.invert(coordinates[0]*radians,coordinates[1]*radians);return coordinates[0]*=degrees,coordinates[1]*=degrees,coordinates};return forward}function circleStream(stream,radius,delta,direction,t0,t1){if(!delta)return;var cosRadius=cos$1(radius),sinRadius=sin$1(radius),step=direction*delta;if(t0==null){t0=radius+direction*tau;t1=radius-step/2}else{t0=circleRadius(cosRadius,t0);t1=circleRadius(cosRadius,t1);if(direction>0?t0<t1:t0>t1)t0+=direction*tau}for(var point,t=t0;direction>0?t>t1:t<t1;t-=step){point=spherical([cosRadius,-sinRadius*cos$1(t),-sinRadius*sin$1(t)]);stream.point(point[0],point[1])}}function circleRadius(cosRadius,point){point=cartesian(point),point[0]-=cosRadius;cartesianNormalizeInPlace(point);var radius=acos(-point[1]);return((-point[2]<0?-radius:radius)+tau-epsilon$1)%tau}function clipBuffer(){var lines=[],line;return{point:function(x,y,m){line.push([x,y,m])},lineStart:function(){lines.push(line=[])},lineEnd:noop,rejoin:function(){if(lines.length>1)lines.push(lines.pop().concat(lines.shift()))},result:function(){var result=lines;lines=[];line=null;return result}}}function pointEqual(a,b){return abs$1(a[0]-b[0])<epsilon$1&&abs$1(a[1]-b[1])<epsilon$1}function Intersection(point,points,other,entry){this.x=point;this.z=points;this.o=other;this.e=entry;this.v=false;this.n=this.p=null}function clipRejoin(segments,compareIntersection,startInside,interpolate,stream){var subject=[],clip=[],i,n;segments.forEach((function(segment){if((n=segment.length-1)<=0)return;var n,p0=segment[0],p1=segment[n],x;if(pointEqual(p0,p1)){if(!p0[2]&&!p1[2]){stream.lineStart();for(i=0;i<n;++i)stream.point((p0=segment[i])[0],p0[1]);stream.lineEnd();return}p1[0]+=2*epsilon$1}subject.push(x=new Intersection(p0,segment,null,true));clip.push(x.o=new Intersection(p0,null,x,false));subject.push(x=new Intersection(p1,segment,null,false));clip.push(x.o=new Intersection(p1,null,x,true))}));if(!subject.length)return;clip.sort(compareIntersection);link(subject);link(clip);for(i=0,n=clip.length;i<n;++i){clip[i].e=startInside=!startInside}var start=subject[0],points,point;while(1){var current=start,isSubject=true;while(current.v)if((current=current.n)===start)return;points=current.z;stream.lineStart();do{current.v=current.o.v=true;if(current.e){if(isSubject){for(i=0,n=points.length;i<n;++i)stream.point((point=points[i])[0],point[1])}else{interpolate(current.x,current.n.x,1,stream)}current=current.n}else{if(isSubject){points=current.p.z;for(i=points.length-1;i>=0;--i)stream.point((point=points[i])[0],point[1])}else{interpolate(current.x,current.p.x,-1,stream)}current=current.p}current=current.o;points=current.z;isSubject=!isSubject}while(!current.v);stream.lineEnd()}}function link(array){if(!(n=array.length))return;var n,i=0,a=array[0],b;while(++i<n){a.n=b=array[i];b.p=a;a=b}a.n=b=array[0];b.p=a}function longitude(point){return abs$1(point[0])<=pi$1?point[0]:sign(point[0])*((abs$1(point[0])+pi$1)%tau-pi$1)}function polygonContains(polygon,point){var lambda=longitude(point),phi=point[1],sinPhi=sin$1(phi),normal=[sin$1(lambda),-cos$1(lambda),0],angle=0,winding=0;var sum=new Adder;if(sinPhi===1)phi=halfPi$1+epsilon$1;else if(sinPhi===-1)phi=-halfPi$1-epsilon$1;for(var i=0,n=polygon.length;i<n;++i){if(!(m=(ring=polygon[i]).length))continue;var ring,m,point0=ring[m-1],lambda0=longitude(point0),phi0=point0[1]/2+quarterPi,sinPhi0=sin$1(phi0),cosPhi0=cos$1(phi0);for(var j=0;j<m;++j,lambda0=lambda1,sinPhi0=sinPhi1,cosPhi0=cosPhi1,point0=point1){var point1=ring[j],lambda1=longitude(point1),phi1=point1[1]/2+quarterPi,sinPhi1=sin$1(phi1),cosPhi1=cos$1(phi1),delta=lambda1-lambda0,sign=delta>=0?1:-1,absDelta=sign*delta,antimeridian=absDelta>pi$1,k=sinPhi0*sinPhi1;sum.add(atan2(k*sign*sin$1(absDelta),cosPhi0*cosPhi1+k*cos$1(absDelta)));angle+=antimeridian?delta+sign*tau:delta;if(antimeridian^lambda0>=lambda^lambda1>=lambda){var arc=cartesianCross(cartesian(point0),cartesian(point1));cartesianNormalizeInPlace(arc);var intersection=cartesianCross(normal,arc);cartesianNormalizeInPlace(intersection);var phiArc=(antimeridian^delta>=0?-1:1)*asin$1(intersection[2]);if(phi>phiArc||phi===phiArc&&(arc[0]||arc[1])){winding+=antimeridian^delta>=0?1:-1}}}}return(angle<-1e-6||angle<epsilon$1&&sum<-1e-12)^winding&1}function clip(pointVisible,clipLine,interpolate,start){return function(sink){var line=clipLine(sink),ringBuffer=clipBuffer(),ringSink=clipLine(ringBuffer),polygonStarted=false,polygon,segments,ring;var clip={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){clip.point=pointRing;clip.lineStart=ringStart;clip.lineEnd=ringEnd;segments=[];polygon=[]},polygonEnd:function(){clip.point=point;clip.lineStart=lineStart;clip.lineEnd=lineEnd;segments=merge(segments);var startInside=polygonContains(polygon,start);if(segments.length){if(!polygonStarted)sink.polygonStart(),polygonStarted=true;clipRejoin(segments,compareIntersection,startInside,interpolate,sink)}else if(startInside){if(!polygonStarted)sink.polygonStart(),polygonStarted=true;sink.lineStart();interpolate(null,null,1,sink);sink.lineEnd()}if(polygonStarted)sink.polygonEnd(),polygonStarted=false;segments=polygon=null},sphere:function(){sink.polygonStart();sink.lineStart();interpolate(null,null,1,sink);sink.lineEnd();sink.polygonEnd()}};function point(lambda,phi){if(pointVisible(lambda,phi))sink.point(lambda,phi)}function pointLine(lambda,phi){line.point(lambda,phi)}function lineStart(){clip.point=pointLine;line.lineStart()}function lineEnd(){clip.point=point;line.lineEnd()}function pointRing(lambda,phi){ring.push([lambda,phi]);ringSink.point(lambda,phi)}function ringStart(){ringSink.lineStart();ring=[]}function ringEnd(){pointRing(ring[0][0],ring[0][1]);ringSink.lineEnd();var clean=ringSink.clean(),ringSegments=ringBuffer.result(),i,n=ringSegments.length,m,segment,point;ring.pop();polygon.push(ring);ring=null;if(!n)return;if(clean&1){segment=ringSegments[0];if((m=segment.length-1)>0){if(!polygonStarted)sink.polygonStart(),polygonStarted=true;sink.lineStart();for(i=0;i<m;++i)sink.point((point=segment[i])[0],point[1]);sink.lineEnd()}return}if(n>1&&clean&2)ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));segments.push(ringSegments.filter(validSegment))}return clip}}function validSegment(segment){return segment.length>1}function compareIntersection(a,b){return((a=a.x)[0]<0?a[1]-halfPi$1-epsilon$1:halfPi$1-a[1])-((b=b.x)[0]<0?b[1]-halfPi$1-epsilon$1:halfPi$1-b[1])}var clipAntimeridian=clip((function(){return true}),clipAntimeridianLine,clipAntimeridianInterpolate,[-pi$1,-halfPi$1]);function clipAntimeridianLine(stream){var lambda0=NaN,phi0=NaN,sign0=NaN,clean;return{lineStart:function(){stream.lineStart();clean=1},point:function(lambda1,phi1){var sign1=lambda1>0?pi$1:-pi$1,delta=abs$1(lambda1-lambda0);if(abs$1(delta-pi$1)<epsilon$1){stream.point(lambda0,phi0=(phi0+phi1)/2>0?halfPi$1:-halfPi$1);stream.point(sign0,phi0);stream.lineEnd();stream.lineStart();stream.point(sign1,phi0);stream.point(lambda1,phi0);clean=0}else if(sign0!==sign1&&delta>=pi$1){if(abs$1(lambda0-sign0)<epsilon$1)lambda0-=sign0*epsilon$1;if(abs$1(lambda1-sign1)<epsilon$1)lambda1-=sign1*epsilon$1;phi0=clipAntimeridianIntersect(lambda0,phi0,lambda1,phi1);stream.point(sign0,phi0);stream.lineEnd();stream.lineStart();stream.point(sign1,phi0);clean=0}stream.point(lambda0=lambda1,phi0=phi1);sign0=sign1},lineEnd:function(){stream.lineEnd();lambda0=phi0=NaN},clean:function(){return 2-clean}}}function clipAntimeridianIntersect(lambda0,phi0,lambda1,phi1){var cosPhi0,cosPhi1,sinLambda0Lambda1=sin$1(lambda0-lambda1);return abs$1(sinLambda0Lambda1)>epsilon$1?atan((sin$1(phi0)*(cosPhi1=cos$1(phi1))*sin$1(lambda1)-sin$1(phi1)*(cosPhi0=cos$1(phi0))*sin$1(lambda0))/(cosPhi0*cosPhi1*sinLambda0Lambda1)):(phi0+phi1)/2}function clipAntimeridianInterpolate(from,to,direction,stream){var phi;if(from==null){phi=direction*halfPi$1;stream.point(-pi$1,phi);stream.point(0,phi);stream.point(pi$1,phi);stream.point(pi$1,0);stream.point(pi$1,-phi);stream.point(0,-phi);stream.point(-pi$1,-phi);stream.point(-pi$1,0);stream.point(-pi$1,phi)}else if(abs$1(from[0]-to[0])>epsilon$1){var lambda=from[0]<to[0]?pi$1:-pi$1;phi=direction*lambda/2;stream.point(-lambda,phi);stream.point(0,phi);stream.point(lambda,phi)}else{stream.point(to[0],to[1])}}function clipCircle(radius){var cr=cos$1(radius),delta=6*radians,smallRadius=cr>0,notHemisphere=abs$1(cr)>epsilon$1;function interpolate(from,to,direction,stream){circleStream(stream,radius,delta,direction,from,to)}function visible(lambda,phi){return cos$1(lambda)*cos$1(phi)>cr}function clipLine(stream){var point0,c0,v0,v00,clean;return{lineStart:function(){v00=v0=false;clean=1},point:function(lambda,phi){var point1=[lambda,phi],point2,v=visible(lambda,phi),c=smallRadius?v?0:code(lambda,phi):v?code(lambda+(lambda<0?pi$1:-pi$1),phi):0;if(!point0&&(v00=v0=v))stream.lineStart();if(v!==v0){point2=intersect(point0,point1);if(!point2||pointEqual(point0,point2)||pointEqual(point1,point2))point1[2]=1}if(v!==v0){clean=0;if(v){stream.lineStart();point2=intersect(point1,point0);stream.point(point2[0],point2[1])}else{point2=intersect(point0,point1);stream.point(point2[0],point2[1],2);stream.lineEnd()}point0=point2}else if(notHemisphere&&point0&&smallRadius^v){var t;if(!(c&c0)&&(t=intersect(point1,point0,true))){clean=0;if(smallRadius){stream.lineStart();stream.point(t[0][0],t[0][1]);stream.point(t[1][0],t[1][1]);stream.lineEnd()}else{stream.point(t[1][0],t[1][1]);stream.lineEnd();stream.lineStart();stream.point(t[0][0],t[0][1],3)}}}if(v&&(!point0||!pointEqual(point0,point1))){stream.point(point1[0],point1[1])}point0=point1,v0=v,c0=c},lineEnd:function(){if(v0)stream.lineEnd();point0=null},clean:function(){return clean|(v00&&v0)<<1}}}function intersect(a,b,two){var pa=cartesian(a),pb=cartesian(b);var n1=[1,0,0],n2=cartesianCross(pa,pb),n2n2=cartesianDot(n2,n2),n1n2=n2[0],determinant=n2n2-n1n2*n1n2;if(!determinant)return!two&&a;var c1=cr*n2n2/determinant,c2=-cr*n1n2/determinant,n1xn2=cartesianCross(n1,n2),A=cartesianScale(n1,c1),B=cartesianScale(n2,c2);cartesianAddInPlace(A,B);var u=n1xn2,w=cartesianDot(A,u),uu=cartesianDot(u,u),t2=w*w-uu*(cartesianDot(A,A)-1);if(t2<0)return;var t=sqrt$1(t2),q=cartesianScale(u,(-w-t)/uu);cartesianAddInPlace(q,A);q=spherical(q);if(!two)return q;var lambda0=a[0],lambda1=b[0],phi0=a[1],phi1=b[1],z;if(lambda1<lambda0)z=lambda0,lambda0=lambda1,lambda1=z;var delta=lambda1-lambda0,polar=abs$1(delta-pi$1)<epsilon$1,meridian=polar||delta<epsilon$1;if(!polar&&phi1<phi0)z=phi0,phi0=phi1,phi1=z;if(meridian?polar?phi0+phi1>0^q[1]<(abs$1(q[0]-lambda0)<epsilon$1?phi0:phi1):phi0<=q[1]&&q[1]<=phi1:delta>pi$1^(lambda0<=q[0]&&q[0]<=lambda1)){var q1=cartesianScale(u,(-w+t)/uu);cartesianAddInPlace(q1,A);return[q,spherical(q1)]}}function code(lambda,phi){var r=smallRadius?radius:pi$1-radius,code=0;if(lambda<-r)code|=1;else if(lambda>r)code|=2;if(phi<-r)code|=4;else if(phi>r)code|=8;return code}return clip(visible,clipLine,interpolate,smallRadius?[0,-radius]:[-pi$1,radius-pi$1])}function clipLine(a,b,x0,y0,x1,y1){var ax=a[0],ay=a[1],bx=b[0],by=b[1],t0=0,t1=1,dx=bx-ax,dy=by-ay,r;r=x0-ax;if(!dx&&r>0)return;r/=dx;if(dx<0){if(r<t0)return;if(r<t1)t1=r}else if(dx>0){if(r>t1)return;if(r>t0)t0=r}r=x1-ax;if(!dx&&r<0)return;r/=dx;if(dx<0){if(r>t1)return;if(r>t0)t0=r}else if(dx>0){if(r<t0)return;if(r<t1)t1=r}r=y0-ay;if(!dy&&r>0)return;r/=dy;if(dy<0){if(r<t0)return;if(r<t1)t1=r}else if(dy>0){if(r>t1)return;if(r>t0)t0=r}r=y1-ay;if(!dy&&r<0)return;r/=dy;if(dy<0){if(r>t1)return;if(r>t0)t0=r}else if(dy>0){if(r<t0)return;if(r<t1)t1=r}if(t0>0)a[0]=ax+t0*dx,a[1]=ay+t0*dy;if(t1<1)b[0]=ax+t1*dx,b[1]=ay+t1*dy;return true}var clipMax=1e9,clipMin=-1e9;function clipRectangle(x0,y0,x1,y1){function visible(x,y){return x0<=x&&x<=x1&&y0<=y&&y<=y1}function interpolate(from,to,direction,stream){var a=0,a1=0;if(from==null||(a=corner(from,direction))!==(a1=corner(to,direction))||comparePoint(from,to)<0^direction>0){do{stream.point(a===0||a===3?x0:x1,a>1?y1:y0)}while((a=(a+direction+4)%4)!==a1)}else{stream.point(to[0],to[1])}}function corner(p,direction){return abs$1(p[0]-x0)<epsilon$1?direction>0?0:3:abs$1(p[0]-x1)<epsilon$1?direction>0?2:1:abs$1(p[1]-y0)<epsilon$1?direction>0?1:0:direction>0?3:2}function compareIntersection(a,b){return comparePoint(a.x,b.x)}function comparePoint(a,b){var ca=corner(a,1),cb=corner(b,1);return ca!==cb?ca-cb:ca===0?b[1]-a[1]:ca===1?a[0]-b[0]:ca===2?a[1]-b[1]:b[0]-a[0]}return function(stream){var activeStream=stream,bufferStream=clipBuffer(),segments,polygon,ring,x__,y__,v__,x_,y_,v_,first,clean;var clipStream={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:polygonStart,polygonEnd:polygonEnd};function point(x,y){if(visible(x,y))activeStream.point(x,y)}function polygonInside(){var winding=0;for(var i=0,n=polygon.length;i<n;++i){for(var ring=polygon[i],j=1,m=ring.length,point=ring[0],a0,a1,b0=point[0],b1=point[1];j<m;++j){a0=b0,a1=b1,point=ring[j],b0=point[0],b1=point[1];if(a1<=y1){if(b1>y1&&(b0-a0)*(y1-a1)>(b1-a1)*(x0-a0))++winding}else{if(b1<=y1&&(b0-a0)*(y1-a1)<(b1-a1)*(x0-a0))--winding}}}return winding}function polygonStart(){activeStream=bufferStream,segments=[],polygon=[],clean=true}function polygonEnd(){var startInside=polygonInside(),cleanInside=clean&&startInside,visible=(segments=merge(segments)).length;if(cleanInside||visible){stream.polygonStart();if(cleanInside){stream.lineStart();interpolate(null,null,1,stream);stream.lineEnd()}if(visible){clipRejoin(segments,compareIntersection,startInside,interpolate,stream)}stream.polygonEnd()}activeStream=stream,segments=polygon=ring=null}function lineStart(){clipStream.point=linePoint;if(polygon)polygon.push(ring=[]);first=true;v_=false;x_=y_=NaN}function lineEnd(){if(segments){linePoint(x__,y__);if(v__&&v_)bufferStream.rejoin();segments.push(bufferStream.result())}clipStream.point=point;if(v_)activeStream.lineEnd()}function linePoint(x,y){var v=visible(x,y);if(polygon)ring.push([x,y]);if(first){x__=x,y__=y,v__=v;first=false;if(v){activeStream.lineStart();activeStream.point(x,y)}}else{if(v&&v_)activeStream.point(x,y);else{var a=[x_=Math.max(clipMin,Math.min(clipMax,x_)),y_=Math.max(clipMin,Math.min(clipMax,y_))],b=[x=Math.max(clipMin,Math.min(clipMax,x)),y=Math.max(clipMin,Math.min(clipMax,y))];if(clipLine(a,b,x0,y0,x1,y1)){if(!v_){activeStream.lineStart();activeStream.point(a[0],a[1])}activeStream.point(b[0],b[1]);if(!v)activeStream.lineEnd();clean=false}else if(v){activeStream.lineStart();activeStream.point(x,y);clean=false}}}x_=x,y_=y,v_=v}return clipStream}}var identity=x=>x;var areaSum=new Adder,areaRingSum=new Adder,x00$2,y00$2,x0$3,y0$3;var areaStream={point:noop,lineStart:noop,lineEnd:noop,polygonStart:function(){areaStream.lineStart=areaRingStart;areaStream.lineEnd=areaRingEnd},polygonEnd:function(){areaStream.lineStart=areaStream.lineEnd=areaStream.point=noop;areaSum.add(abs$1(areaRingSum));areaRingSum=new Adder},result:function(){var area=areaSum/2;areaSum=new Adder;return area}};function areaRingStart(){areaStream.point=areaPointFirst}function areaPointFirst(x,y){areaStream.point=areaPoint;x00$2=x0$3=x,y00$2=y0$3=y}function areaPoint(x,y){areaRingSum.add(y0$3*x-x0$3*y);x0$3=x,y0$3=y}function areaRingEnd(){areaPoint(x00$2,y00$2)}var x0$2=Infinity,y0$2=x0$2,x1=-x0$2,y1=x1;var boundsStream={point:boundsPoint,lineStart:noop,lineEnd:noop,polygonStart:noop,polygonEnd:noop,result:function(){var bounds=[[x0$2,y0$2],[x1,y1]];x1=y1=-(y0$2=x0$2=Infinity);return bounds}};function boundsPoint(x,y){if(x<x0$2)x0$2=x;if(x>x1)x1=x;if(y<y0$2)y0$2=y;if(y>y1)y1=y}var X0=0,Y0=0,Z0=0,X1=0,Y1=0,Z1=0,X2=0,Y2=0,Z2=0,x00$1,y00$1,x0$1,y0$1;var centroidStream={point:centroidPoint,lineStart:centroidLineStart,lineEnd:centroidLineEnd,polygonStart:function(){centroidStream.lineStart=centroidRingStart;centroidStream.lineEnd=centroidRingEnd},polygonEnd:function(){centroidStream.point=centroidPoint;centroidStream.lineStart=centroidLineStart;centroidStream.lineEnd=centroidLineEnd},result:function(){var centroid=Z2?[X2/Z2,Y2/Z2]:Z1?[X1/Z1,Y1/Z1]:Z0?[X0/Z0,Y0/Z0]:[NaN,NaN];X0=Y0=Z0=X1=Y1=Z1=X2=Y2=Z2=0;return centroid}};function centroidPoint(x,y){X0+=x;Y0+=y;++Z0}function centroidLineStart(){centroidStream.point=centroidPointFirstLine}function centroidPointFirstLine(x,y){centroidStream.point=centroidPointLine;centroidPoint(x0$1=x,y0$1=y)}function centroidPointLine(x,y){var dx=x-x0$1,dy=y-y0$1,z=sqrt$1(dx*dx+dy*dy);X1+=z*(x0$1+x)/2;Y1+=z*(y0$1+y)/2;Z1+=z;centroidPoint(x0$1=x,y0$1=y)}function centroidLineEnd(){centroidStream.point=centroidPoint}function centroidRingStart(){centroidStream.point=centroidPointFirstRing}function centroidRingEnd(){centroidPointRing(x00$1,y00$1)}function centroidPointFirstRing(x,y){centroidStream.point=centroidPointRing;centroidPoint(x00$1=x0$1=x,y00$1=y0$1=y)}function centroidPointRing(x,y){var dx=x-x0$1,dy=y-y0$1,z=sqrt$1(dx*dx+dy*dy);X1+=z*(x0$1+x)/2;Y1+=z*(y0$1+y)/2;Z1+=z;z=y0$1*x-x0$1*y;X2+=z*(x0$1+x);Y2+=z*(y0$1+y);Z2+=z*3;centroidPoint(x0$1=x,y0$1=y)}function PathContext(context){this._context=context}PathContext.prototype={_radius:4.5,pointRadius:function(_){return this._radius=_,this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){if(this._line===0)this._context.closePath();this._point=NaN},point:function(x,y){switch(this._point){case 0:{this._context.moveTo(x,y);this._point=1;break}case 1:{this._context.lineTo(x,y);break}default:{this._context.moveTo(x+this._radius,y);this._context.arc(x,y,this._radius,0,tau);break}}},result:noop};var lengthSum=new Adder,lengthRing,x00,y00,x0,y0;var lengthStream={point:noop,lineStart:function(){lengthStream.point=lengthPointFirst},lineEnd:function(){if(lengthRing)lengthPoint(x00,y00);lengthStream.point=noop},polygonStart:function(){lengthRing=true},polygonEnd:function(){lengthRing=null},result:function(){var length=+lengthSum;lengthSum=new Adder;return length}};function lengthPointFirst(x,y){lengthStream.point=lengthPoint;x00=x0=x,y00=y0=y}function lengthPoint(x,y){x0-=x,y0-=y;lengthSum.add(sqrt$1(x0*x0+y0*y0));x0=x,y0=y}let cacheDigits,cacheAppend,cacheRadius,cacheCircle;class PathString{constructor(digits){this._append=digits==null?append:appendRound(digits);this._radius=4.5;this._=""}pointRadius(_){this._radius=+_;return this}polygonStart(){this._line=0}polygonEnd(){this._line=NaN}lineStart(){this._point=0}lineEnd(){if(this._line===0)this._+="Z";this._point=NaN}point(x,y){switch(this._point){case 0:{this._append`M${x},${y}`;this._point=1;break}case 1:{this._append`L${x},${y}`;break}default:{this._append`M${x},${y}`;if(this._radius!==cacheRadius||this._append!==cacheAppend){const r=this._radius;const s=this._;this._="";this._append`m0,${r}a${r},${r} 0 1,1 0,${-2*r}a${r},${r} 0 1,1 0,${2*r}z`;cacheRadius=r;cacheAppend=this._append;cacheCircle=this._;this._=s}this._+=cacheCircle;break}}}result(){const result=this._;this._="";return result.length?result:null}}function append(strings){let i=1;this._+=strings[0];for(const j=strings.length;i<j;++i){this._+=arguments[i]+strings[i]}}function appendRound(digits){const d=Math.floor(digits);if(!(d>=0))throw new RangeError(`invalid digits: ${digits}`);if(d>15)return append;if(d!==cacheDigits){const k=10**d;cacheDigits=d;cacheAppend=function append(strings){let i=1;this._+=strings[0];for(const j=strings.length;i<j;++i){this._+=Math.round(arguments[i]*k)/k+strings[i]}}}return cacheAppend}function geoPath(projection,context){let digits=3,pointRadius=4.5,projectionStream,contextStream;function path(object){if(object){if(typeof pointRadius==="function")contextStream.pointRadius(+pointRadius.apply(this,arguments));geoStream(object,projectionStream(contextStream))}return contextStream.result()}path.area=function(object){geoStream(object,projectionStream(areaStream));return areaStream.result()};path.measure=function(object){geoStream(object,projectionStream(lengthStream));return lengthStream.result()};path.bounds=function(object){geoStream(object,projectionStream(boundsStream));return boundsStream.result()};path.centroid=function(object){geoStream(object,projectionStream(centroidStream));return centroidStream.result()};path.projection=function(_){if(!arguments.length)return projection;projectionStream=_==null?(projection=null,identity):(projection=_).stream;return path};path.context=function(_){if(!arguments.length)return context;contextStream=_==null?(context=null,new PathString(digits)):new PathContext(context=_);if(typeof pointRadius!=="function")contextStream.pointRadius(pointRadius);return path};path.pointRadius=function(_){if(!arguments.length)return pointRadius;pointRadius=typeof _==="function"?_:(contextStream.pointRadius(+_),+_);return path};path.digits=function(_){if(!arguments.length)return digits;if(_==null)digits=null;else{const d=Math.floor(_);if(!(d>=0))throw new RangeError(`invalid digits: ${_}`);digits=d}if(context===null)contextStream=new PathString(digits);return path};return path.projection(projection).digits(digits).context(context)}function transformer(methods){return function(stream){var s=new TransformStream;for(var key in methods)s[key]=methods[key];s.stream=stream;return s}}function TransformStream(){}TransformStream.prototype={constructor:TransformStream,point:function(x,y){this.stream.point(x,y)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}};function fit(projection,fitBounds,object){var clip=projection.clipExtent&&projection.clipExtent();projection.scale(150).translate([0,0]);if(clip!=null)projection.clipExtent(null);geoStream(object,projection.stream(boundsStream));fitBounds(boundsStream.result());if(clip!=null)projection.clipExtent(clip);return projection}function fitExtent(projection,extent,object){return fit(projection,(function(b){var w=extent[1][0]-extent[0][0],h=extent[1][1]-extent[0][1],k=Math.min(w/(b[1][0]-b[0][0]),h/(b[1][1]-b[0][1])),x=+extent[0][0]+(w-k*(b[1][0]+b[0][0]))/2,y=+extent[0][1]+(h-k*(b[1][1]+b[0][1]))/2;projection.scale(150*k).translate([x,y])}),object)}function fitSize(projection,size,object){return fitExtent(projection,[[0,0],size],object)}function fitWidth(projection,width,object){return fit(projection,(function(b){var w=+width,k=w/(b[1][0]-b[0][0]),x=(w-k*(b[1][0]+b[0][0]))/2,y=-k*b[0][1];projection.scale(150*k).translate([x,y])}),object)}function fitHeight(projection,height,object){return fit(projection,(function(b){var h=+height,k=h/(b[1][1]-b[0][1]),x=-k*b[0][0],y=(h-k*(b[1][1]+b[0][1]))/2;projection.scale(150*k).translate([x,y])}),object)}var maxDepth=16,cosMinDistance=cos$1(30*radians);function resample(project,delta2){return+delta2?resample$1(project,delta2):resampleNone(project)}function resampleNone(project){return transformer({point:function(x,y){x=project(x,y);this.stream.point(x[0],x[1])}})}function resample$1(project,delta2){function resampleLineTo(x0,y0,lambda0,a0,b0,c0,x1,y1,lambda1,a1,b1,c1,depth,stream){var dx=x1-x0,dy=y1-y0,d2=dx*dx+dy*dy;if(d2>4*delta2&&depth--){var a=a0+a1,b=b0+b1,c=c0+c1,m=sqrt$1(a*a+b*b+c*c),phi2=asin$1(c/=m),lambda2=abs$1(abs$1(c)-1)<epsilon$1||abs$1(lambda0-lambda1)<epsilon$1?(lambda0+lambda1)/2:atan2(b,a),p=project(lambda2,phi2),x2=p[0],y2=p[1],dx2=x2-x0,dy2=y2-y0,dz=dy*dx2-dx*dy2;if(dz*dz/d2>delta2||abs$1((dx*dx2+dy*dy2)/d2-.5)>.3||a0*a1+b0*b1+c0*c1<cosMinDistance){resampleLineTo(x0,y0,lambda0,a0,b0,c0,x2,y2,lambda2,a/=m,b/=m,c,depth,stream);stream.point(x2,y2);resampleLineTo(x2,y2,lambda2,a,b,c,x1,y1,lambda1,a1,b1,c1,depth,stream)}}}return function(stream){var lambda00,x00,y00,a00,b00,c00,lambda0,x0,y0,a0,b0,c0;var resampleStream={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){stream.polygonStart();resampleStream.lineStart=ringStart},polygonEnd:function(){stream.polygonEnd();resampleStream.lineStart=lineStart}};function point(x,y){x=project(x,y);stream.point(x[0],x[1])}function lineStart(){x0=NaN;resampleStream.point=linePoint;stream.lineStart()}function linePoint(lambda,phi){var c=cartesian([lambda,phi]),p=project(lambda,phi);resampleLineTo(x0,y0,lambda0,a0,b0,c0,x0=p[0],y0=p[1],lambda0=lambda,a0=c[0],b0=c[1],c0=c[2],maxDepth,stream);stream.point(x0,y0)}function lineEnd(){resampleStream.point=point;stream.lineEnd()}function ringStart(){lineStart();resampleStream.point=ringPoint;resampleStream.lineEnd=ringEnd}function ringPoint(lambda,phi){linePoint(lambda00=lambda,phi),x00=x0,y00=y0,a00=a0,b00=b0,c00=c0;resampleStream.point=linePoint}function ringEnd(){resampleLineTo(x0,y0,lambda0,a0,b0,c0,x00,y00,lambda00,a00,b00,c00,maxDepth,stream);resampleStream.lineEnd=lineEnd;lineEnd()}return resampleStream}}var transformRadians=transformer({point:function(x,y){this.stream.point(x*radians,y*radians)}});function transformRotate(rotate){return transformer({point:function(x,y){var r=rotate(x,y);return this.stream.point(r[0],r[1])}})}function scaleTranslate(k,dx,dy,sx,sy){function transform(x,y){x*=sx;y*=sy;return[dx+k*x,dy-k*y]}transform.invert=function(x,y){return[(x-dx)/k*sx,(dy-y)/k*sy]};return transform}function scaleTranslateRotate(k,dx,dy,sx,sy,alpha){if(!alpha)return scaleTranslate(k,dx,dy,sx,sy);var cosAlpha=cos$1(alpha),sinAlpha=sin$1(alpha),a=cosAlpha*k,b=sinAlpha*k,ai=cosAlpha/k,bi=sinAlpha/k,ci=(sinAlpha*dy-cosAlpha*dx)/k,fi=(sinAlpha*dx+cosAlpha*dy)/k;function transform(x,y){x*=sx;y*=sy;return[a*x-b*y+dx,dy-b*x-a*y]}transform.invert=function(x,y){return[sx*(ai*x-bi*y+ci),sy*(fi-bi*x-ai*y)]};return transform}function projection$1(project){return projectionMutator((function(){return project}))()}function projectionMutator(projectAt){var project,k=150,x=480,y=250,lambda=0,phi=0,deltaLambda=0,deltaPhi=0,deltaGamma=0,rotate,alpha=0,sx=1,sy=1,theta=null,preclip=clipAntimeridian,x0=null,y0,x1,y1,postclip=identity,delta2=.5,projectResample,projectTransform,projectRotateTransform,cache,cacheStream;function projection(point){return projectRotateTransform(point[0]*radians,point[1]*radians)}function invert(point){point=projectRotateTransform.invert(point[0],point[1]);return point&&[point[0]*degrees,point[1]*degrees]}projection.stream=function(stream){return cache&&cacheStream===stream?cache:cache=transformRadians(transformRotate(rotate)(preclip(projectResample(postclip(cacheStream=stream)))))};projection.preclip=function(_){return arguments.length?(preclip=_,theta=undefined,reset()):preclip};projection.postclip=function(_){return arguments.length?(postclip=_,x0=y0=x1=y1=null,reset()):postclip};projection.clipAngle=function(_){return arguments.length?(preclip=+_?clipCircle(theta=_*radians):(theta=null,clipAntimeridian),reset()):theta*degrees};projection.clipExtent=function(_){return arguments.length?(postclip=_==null?(x0=y0=x1=y1=null,identity):clipRectangle(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reset()):x0==null?null:[[x0,y0],[x1,y1]]};projection.scale=function(_){return arguments.length?(k=+_,recenter()):k};projection.translate=function(_){return arguments.length?(x=+_[0],y=+_[1],recenter()):[x,y]};projection.center=function(_){return arguments.length?(lambda=_[0]%360*radians,phi=_[1]%360*radians,recenter()):[lambda*degrees,phi*degrees]};projection.rotate=function(_){return arguments.length?(deltaLambda=_[0]%360*radians,deltaPhi=_[1]%360*radians,deltaGamma=_.length>2?_[2]%360*radians:0,recenter()):[deltaLambda*degrees,deltaPhi*degrees,deltaGamma*degrees]};projection.angle=function(_){return arguments.length?(alpha=_%360*radians,recenter()):alpha*degrees};projection.reflectX=function(_){return arguments.length?(sx=_?-1:1,recenter()):sx<0};projection.reflectY=function(_){return arguments.length?(sy=_?-1:1,recenter()):sy<0};projection.precision=function(_){return arguments.length?(projectResample=resample(projectTransform,delta2=_*_),reset()):sqrt$1(delta2)};projection.fitExtent=function(extent,object){return fitExtent(projection,extent,object)};projection.fitSize=function(size,object){return fitSize(projection,size,object)};projection.fitWidth=function(width,object){return fitWidth(projection,width,object)};projection.fitHeight=function(height,object){return fitHeight(projection,height,object)};function recenter(){var center=scaleTranslateRotate(k,0,0,sx,sy,alpha).apply(null,project(lambda,phi)),transform=scaleTranslateRotate(k,x-center[0],y-center[1],sx,sy,alpha);rotate=rotateRadians(deltaLambda,deltaPhi,deltaGamma);projectTransform=compose(project,transform);projectRotateTransform=compose(rotate,projectTransform);projectResample=resample(projectTransform,delta2);return reset()}function reset(){cache=cacheStream=null;return projection}return function(){project=projectAt.apply(this,arguments);projection.invert=project.invert&&invert;return recenter()}}function conicProjection(projectAt){var phi0=0,phi1=pi$1/3,m=projectionMutator(projectAt),p=m(phi0,phi1);p.parallels=function(_){return arguments.length?m(phi0=_[0]*radians,phi1=_[1]*radians):[phi0*degrees,phi1*degrees]};return p}function cylindricalEqualAreaRaw(phi0){var cosPhi0=cos$1(phi0);function forward(lambda,phi){return[lambda*cosPhi0,sin$1(phi)/cosPhi0]}forward.invert=function(x,y){return[x/cosPhi0,asin$1(y*cosPhi0)]};return forward}function conicEqualAreaRaw(y0,y1){var sy0=sin$1(y0),n=(sy0+sin$1(y1))/2;if(abs$1(n)<epsilon$1)return cylindricalEqualAreaRaw(y0);var c=1+sy0*(2*n-sy0),r0=sqrt$1(c)/n;function project(x,y){var r=sqrt$1(c-2*n*sin$1(y))/n;return[r*sin$1(x*=n),r0-r*cos$1(x)]}project.invert=function(x,y){var r0y=r0-y,l=atan2(x,abs$1(r0y))*sign(r0y);if(r0y*n<0)l-=pi$1*sign(x)*sign(r0y);return[l/n,asin$1((c-(x*x+r0y*r0y)*n*n)/(2*n))]};return project}function geoConicEqualArea(){return conicProjection(conicEqualAreaRaw).scale(155.424).center([0,33.6442])}function geoAlbers(){return geoConicEqualArea().parallels([29.5,45.5]).scale(1070).translate([480,250]).rotate([96,0]).center([-.6,38.7])}function multiplex(streams){var n=streams.length;return{point:function(x,y){var i=-1;while(++i<n)streams[i].point(x,y)},sphere:function(){var i=-1;while(++i<n)streams[i].sphere()},lineStart:function(){var i=-1;while(++i<n)streams[i].lineStart()},lineEnd:function(){var i=-1;while(++i<n)streams[i].lineEnd()},polygonStart:function(){var i=-1;while(++i<n)streams[i].polygonStart()},polygonEnd:function(){var i=-1;while(++i<n)streams[i].polygonEnd()}}}function geoAlbersUsa(){var cache,cacheStream,lower48=geoAlbers(),lower48Point,alaska=geoConicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),alaskaPoint,hawaii=geoConicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),hawaiiPoint,point,pointStream={point:function(x,y){point=[x,y]}};function albersUsa(coordinates){var x=coordinates[0],y=coordinates[1];return point=null,(lower48Point.point(x,y),point)||(alaskaPoint.point(x,y),point)||(hawaiiPoint.point(x,y),point)}albersUsa.invert=function(coordinates){var k=lower48.scale(),t=lower48.translate(),x=(coordinates[0]-t[0])/k,y=(coordinates[1]-t[1])/k;return(y>=.12&&y<.234&&x>=-.425&&x<-.214?alaska:y>=.166&&y<.234&&x>=-.214&&x<-.115?hawaii:lower48).invert(coordinates)};albersUsa.stream=function(stream){return cache&&cacheStream===stream?cache:cache=multiplex([lower48.stream(cacheStream=stream),alaska.stream(stream),hawaii.stream(stream)])};albersUsa.precision=function(_){if(!arguments.length)return lower48.precision();lower48.precision(_),alaska.precision(_),hawaii.precision(_);return reset()};albersUsa.scale=function(_){if(!arguments.length)return lower48.scale();lower48.scale(_),alaska.scale(_*.35),hawaii.scale(_);return albersUsa.translate(lower48.translate())};albersUsa.translate=function(_){if(!arguments.length)return lower48.translate();var k=lower48.scale(),x=+_[0],y=+_[1];lower48Point=lower48.translate(_).clipExtent([[x-.455*k,y-.238*k],[x+.455*k,y+.238*k]]).stream(pointStream);alaskaPoint=alaska.translate([x-.307*k,y+.201*k]).clipExtent([[x-.425*k+epsilon$1,y+.12*k+epsilon$1],[x-.214*k-epsilon$1,y+.234*k-epsilon$1]]).stream(pointStream);hawaiiPoint=hawaii.translate([x-.205*k,y+.212*k]).clipExtent([[x-.214*k+epsilon$1,y+.166*k+epsilon$1],[x-.115*k-epsilon$1,y+.234*k-epsilon$1]]).stream(pointStream);return reset()};albersUsa.fitExtent=function(extent,object){return fitExtent(albersUsa,extent,object)};albersUsa.fitSize=function(size,object){return fitSize(albersUsa,size,object)};albersUsa.fitWidth=function(width,object){return fitWidth(albersUsa,width,object)};albersUsa.fitHeight=function(height,object){return fitHeight(albersUsa,height,object)};function reset(){cache=cacheStream=null;return albersUsa}return albersUsa.scale(1070)}function azimuthalRaw(scale){return function(x,y){var cx=cos$1(x),cy=cos$1(y),k=scale(cx*cy);if(k===Infinity)return[2,0];return[k*cy*sin$1(x),k*sin$1(y)]}}function azimuthalInvert(angle){return function(x,y){var z=sqrt$1(x*x+y*y),c=angle(z),sc=sin$1(c),cc=cos$1(c);return[atan2(x*sc,z*cc),asin$1(z&&y*sc/z)]}}var azimuthalEqualAreaRaw=azimuthalRaw((function(cxcy){return sqrt$1(2/(1+cxcy))}));azimuthalEqualAreaRaw.invert=azimuthalInvert((function(z){return 2*asin$1(z/2)}));function geoAzimuthalEqualArea(){return projection$1(azimuthalEqualAreaRaw).scale(124.75).clipAngle(180-.001)}var azimuthalEquidistantRaw=azimuthalRaw((function(c){return(c=acos(c))&&c/sin$1(c)}));azimuthalEquidistantRaw.invert=azimuthalInvert((function(z){return z}));function geoAzimuthalEquidistant(){return projection$1(azimuthalEquidistantRaw).scale(79.4188).clipAngle(180-.001)}function mercatorRaw(lambda,phi){return[lambda,log(tan((halfPi$1+phi)/2))]}mercatorRaw.invert=function(x,y){return[x,2*atan(exp(y))-halfPi$1]};function geoMercator(){return mercatorProjection(mercatorRaw).scale(961/tau)}function mercatorProjection(project){var m=projection$1(project),center=m.center,scale=m.scale,translate=m.translate,clipExtent=m.clipExtent,x0=null,y0,x1,y1;m.scale=function(_){return arguments.length?(scale(_),reclip()):scale()};m.translate=function(_){return arguments.length?(translate(_),reclip()):translate()};m.center=function(_){return arguments.length?(center(_),reclip()):center()};m.clipExtent=function(_){return arguments.length?(_==null?x0=y0=x1=y1=null:(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reclip()):x0==null?null:[[x0,y0],[x1,y1]]};function reclip(){var k=pi$1*scale(),t=m(rotation(m.rotate()).invert([0,0]));return clipExtent(x0==null?[[t[0]-k,t[1]-k],[t[0]+k,t[1]+k]]:project===mercatorRaw?[[Math.max(t[0]-k,x0),y0],[Math.min(t[0]+k,x1),y1]]:[[x0,Math.max(t[1]-k,y0)],[x1,Math.min(t[1]+k,y1)]])}return reclip()}function tany(y){return tan((halfPi$1+y)/2)}function conicConformalRaw(y0,y1){var cy0=cos$1(y0),n=y0===y1?sin$1(y0):log(cy0/cos$1(y1))/log(tany(y1)/tany(y0)),f=cy0*pow(tany(y0),n)/n;if(!n)return mercatorRaw;function project(x,y){if(f>0){if(y<-halfPi$1+epsilon$1)y=-halfPi$1+epsilon$1}else{if(y>halfPi$1-epsilon$1)y=halfPi$1-epsilon$1}var r=f/pow(tany(y),n);return[r*sin$1(n*x),f-r*cos$1(n*x)]}project.invert=function(x,y){var fy=f-y,r=sign(n)*sqrt$1(x*x+fy*fy),l=atan2(x,abs$1(fy))*sign(fy);if(fy*n<0)l-=pi$1*sign(x)*sign(fy);return[l/n,2*atan(pow(f/r,1/n))-halfPi$1]};return project}function geoConicConformal(){return conicProjection(conicConformalRaw).scale(109.5).parallels([30,30])}function equirectangularRaw(lambda,phi){return[lambda,phi]}equirectangularRaw.invert=equirectangularRaw;function geoEquirectangular(){return projection$1(equirectangularRaw).scale(152.63)}function conicEquidistantRaw(y0,y1){var cy0=cos$1(y0),n=y0===y1?sin$1(y0):(cy0-cos$1(y1))/(y1-y0),g=cy0/n+y0;if(abs$1(n)<epsilon$1)return equirectangularRaw;function project(x,y){var gy=g-y,nx=n*x;return[gy*sin$1(nx),g-gy*cos$1(nx)]}project.invert=function(x,y){var gy=g-y,l=atan2(x,abs$1(gy))*sign(gy);if(gy*n<0)l-=pi$1*sign(x)*sign(gy);return[l/n,g-sign(n)*sqrt$1(x*x+gy*gy)]};return project}function geoConicEquidistant(){return conicProjection(conicEquidistantRaw).scale(131.154).center([0,13.9389])}var A1=1.340264,A2=-.081106,A3=893e-6,A4=.003796,M=sqrt$1(3)/2,iterations=12;function equalEarthRaw(lambda,phi){var l=asin$1(M*sin$1(phi)),l2=l*l,l6=l2*l2*l2;return[lambda*cos$1(l)/(M*(A1+3*A2*l2+l6*(7*A3+9*A4*l2))),l*(A1+A2*l2+l6*(A3+A4*l2))]}equalEarthRaw.invert=function(x,y){var l=y,l2=l*l,l6=l2*l2*l2;for(var i=0,delta,fy,fpy;i<iterations;++i){fy=l*(A1+A2*l2+l6*(A3+A4*l2))-y;fpy=A1+3*A2*l2+l6*(7*A3+9*A4*l2);l-=delta=fy/fpy,l2=l*l,l6=l2*l2*l2;if(abs$1(delta)<epsilon2)break}return[M*x*(A1+3*A2*l2+l6*(7*A3+9*A4*l2))/cos$1(l),asin$1(sin$1(l)/M)]};function geoEqualEarth(){return projection$1(equalEarthRaw).scale(177.158)}function gnomonicRaw(x,y){var cy=cos$1(y),k=cos$1(x)*cy;return[cy*sin$1(x)/k,sin$1(y)/k]}gnomonicRaw.invert=azimuthalInvert(atan);function geoGnomonic(){return projection$1(gnomonicRaw).scale(144.049).clipAngle(60)}function geoIdentity(){var k=1,tx=0,ty=0,sx=1,sy=1,alpha=0,ca,sa,x0=null,y0,x1,y1,kx=1,ky=1,transform=transformer({point:function(x,y){var p=projection([x,y]);this.stream.point(p[0],p[1])}}),postclip=identity,cache,cacheStream;function reset(){kx=k*sx;ky=k*sy;cache=cacheStream=null;return projection}function projection(p){var x=p[0]*kx,y=p[1]*ky;if(alpha){var t=y*ca-x*sa;x=x*ca+y*sa;y=t}return[x+tx,y+ty]}projection.invert=function(p){var x=p[0]-tx,y=p[1]-ty;if(alpha){var t=y*ca+x*sa;x=x*ca-y*sa;y=t}return[x/kx,y/ky]};projection.stream=function(stream){return cache&&cacheStream===stream?cache:cache=transform(postclip(cacheStream=stream))};projection.postclip=function(_){return arguments.length?(postclip=_,x0=y0=x1=y1=null,reset()):postclip};projection.clipExtent=function(_){return arguments.length?(postclip=_==null?(x0=y0=x1=y1=null,identity):clipRectangle(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reset()):x0==null?null:[[x0,y0],[x1,y1]]};projection.scale=function(_){return arguments.length?(k=+_,reset()):k};projection.translate=function(_){return arguments.length?(tx=+_[0],ty=+_[1],reset()):[tx,ty]};projection.angle=function(_){return arguments.length?(alpha=_%360*radians,sa=sin$1(alpha),ca=cos$1(alpha),reset()):alpha*degrees};projection.reflectX=function(_){return arguments.length?(sx=_?-1:1,reset()):sx<0};projection.reflectY=function(_){return arguments.length?(sy=_?-1:1,reset()):sy<0};projection.fitExtent=function(extent,object){return fitExtent(projection,extent,object)};projection.fitSize=function(size,object){return fitSize(projection,size,object)};projection.fitWidth=function(width,object){return fitWidth(projection,width,object)};projection.fitHeight=function(height,object){return fitHeight(projection,height,object)};return projection}function naturalEarth1Raw(lambda,phi){var phi2=phi*phi,phi4=phi2*phi2;return[lambda*(.8707-.131979*phi2+phi4*(-.013791+phi4*(.003971*phi2-.001529*phi4))),phi*(1.007226+phi2*(.015085+phi4*(-.044475+.028874*phi2-.005916*phi4)))]}naturalEarth1Raw.invert=function(x,y){var phi=y,i=25,delta;do{var phi2=phi*phi,phi4=phi2*phi2;phi-=delta=(phi*(1.007226+phi2*(.015085+phi4*(-.04447