/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.liquibase;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.parsers.SAXParserFactory;
import liquibase.Scope;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.ui.LoggerUIService;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.liquibase.conn.DefaultLiquibaseConnectionProvider;

public class QuarkusLiquibaseConnectionProvider
extends DefaultLiquibaseConnectionProvider {
    private static final Logger logger = Logger.getLogger(QuarkusLiquibaseConnectionProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void baseLiquibaseInitialization() {
        HashMap<String, LoggerUIService> scopeValues = new HashMap<String, LoggerUIService>();
        scopeValues.put(Scope.Attr.ui.name(), new LoggerUIService());
        try {
            Scope.enter(scopeValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Liquibase: " + e.getMessage(), e);
        }
        for (ChangeLogParser parser : ChangeLogParserFactory.getInstance().getParsers()) {
            if (!(parser instanceof XMLChangeLogSAXParser)) continue;
            Method getSaxParserFactory = null;
            try {
                getSaxParserFactory = XMLChangeLogSAXParser.class.getDeclaredMethod("getSaxParserFactory", new Class[0]);
                getSaxParserFactory.setAccessible(true);
                SAXParserFactory saxParserFactory = (SAXParserFactory)getSaxParserFactory.invoke((Object)parser, new Object[0]);
                saxParserFactory.setValidating(false);
                saxParserFactory.setSchema(null);
            }
            catch (Exception e) {
                logger.warnf("Failed to disable liquibase XML validations", new Object[0]);
            }
            finally {
                if (getSaxParserFactory == null) continue;
                getSaxParserFactory.setAccessible(false);
            }
        }
    }

    public String getId() {
        return "quarkus";
    }

    public int order() {
        return 100;
    }
}

