/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5f90_H
#define H5f90_H

#include "hdf5.h"
#include "H5private.h"
#include "H5f90i.h"
#include "H5f90proto.h"

/* Constants used in H5Rff.F90 and H5Rf.c files */
#define REF_REG_BUF_LEN_F 3

/* Constants used in H5Gf.c files */
#define OBJECT_NAMELEN_DEFAULT_F -1

#define H5_MAX(a, b) (((a) > (b)) ? (a) : (b))

#endif /* H5f90_H */
