/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiProvidesStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRequiresStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiUsesStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public final class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile root, @NotNull String name2) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(0);
        }
        if (root == null) {
            LightJavaModule.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(2);
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myExports = NotNullLazyValue.atomicLazy(this::findExports);
        this.myRoot = root;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, name2);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightJavaModule.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModule(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            LightJavaModule.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        Iterable iterable = this.myExports.getValue();
        if (iterable == null) {
            LightJavaModule.$$$reportNull$$$0(6);
        }
        return iterable;
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList<PsiPackageAccessibilityStatement> exports = new ArrayList<PsiPackageAccessibilityStatement>();
        VfsUtilCore.visitChildrenRecursively(this.myRoot, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(arg0);
                this.service = JavaDirectoryService.getInstance();
            }

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                String packageName2;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory() && !LightJavaModule.this.myRoot.equals(file) && (directory = LightJavaModule.this.getManager().findDirectory(file)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName2 = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty(new PsiDirectory[]{directory}, packageName2)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.getManager(), packageName2));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$1", "visitFile"));
            }
        });
        return exports;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        List<PsiPackageAccessibilityStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        List<PsiUsesStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        List<PsiProvidesStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            LightJavaModule.$$$reportNull$$$0(10);
        }
        return lightJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myRefElement.getReferenceText();
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException("Cannot modify an automatic module '" + this.getName() + "'");
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = ObjectUtils.notNull(this.myManager.findDirectory(this.myRoot), super.getNavigationElement());
        if (psiElement == null) {
            LightJavaModule.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myRoot.equals(((LightJavaModule)obj).myRoot) && this.getManager() == ((LightJavaModule)obj).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        String claimed;
        VirtualFile manifest;
        if (jarRoot == null) {
            LightJavaModule.$$$reportNull$$$0(15);
        }
        if ((manifest = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) != null && (claimed = LightJavaModule.claimedModuleName(manifest)) != null) {
            String string = claimed;
            if (string == null) {
                LightJavaModule.$$$reportNull$$$0(16);
            }
            return string;
        }
        return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
    }

    @Nullable
    public static String claimedModuleName(@NotNull VirtualFile manifest) {
        String string;
        block9: {
            if (manifest == null) {
                LightJavaModule.$$$reportNull$$$0(17);
            }
            InputStream stream = manifest.getInputStream();
            try {
                string = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    Logger.getInstance(LightJavaModule.class).warn(manifest.getPath(), e2);
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static LightJavaModule create(@NotNull PsiManager manager, @NotNull VirtualFile root, @NotNull String name2) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(18);
        }
        if (root == null) {
            LightJavaModule.$$$reportNull$$$0(19);
        }
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(20);
        }
        return new LightJavaModule(manager, root, name2);
    }

    @NotNull
    public static String moduleName(@NotNull String name2) {
        Matcher m2;
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(21);
        }
        if ((m2 = Patterns.VERSION.matcher(name2)).find()) {
            name2 = name2.substring(0, m2.start());
        }
        name2 = Patterns.NON_NAME.matcher(name2).replaceAll(".");
        name2 = Patterns.DOT_SEQUENCE.matcher(name2).replaceAll(".");
        String string = name2 = StringUtil.trimLeading(StringUtil.trimTrailing(name2, '.'), '.');
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 22: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootVirtualFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequires";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpens";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 16: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 22: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 15: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moduleName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "claimedModuleName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text) {
            if (manager == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(0);
            }
            if (text == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myText = text;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(2);
            }
            if (visitor2 instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor2).visitModuleReferenceElement(this);
            } else {
                visitor2.visitElement(this);
            }
        }

        @Override
        @NotNull
        public String getReferenceText() {
            String string = this.myText;
            if (string == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public PsiJavaModuleReference getReference() {
            return null;
        }

        @Override
        public String toString() {
            return "PsiJavaModuleReference";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceText";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z\\d]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName2) {
            if (manager == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(0);
            }
            if (packageName2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myPackageName = packageName2;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(2);
            }
            if (visitor2 instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor2).visitPackageAccessibilityStatement(this);
            } else {
                visitor2.visitElement(this);
            }
        }

        @Override
        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(3);
            }
            return role;
        }

        @Override
        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Override
        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @Override
        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            List<PsiJavaModuleReferenceElement> list = Collections.emptyList();
            if (list == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getModuleNames() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(5);
            }
            return list;
        }

        @Override
        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRole";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleReferences";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNames";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

