/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import java.nio.file.Path;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.jspecify.annotations.Nullable;

public class TwoStageByUrlCachedExternalResourceIndex
implements CachedExternalResourceIndex<String> {
    private final Path readOnlyCachePath;
    private final CachedExternalResourceIndex<String> readOnlyCache;
    private final CachedExternalResourceIndex<String> writableCache;

    public TwoStageByUrlCachedExternalResourceIndex(Path readOnlyCachePath, CachedExternalResourceIndex<String> readOnlyCache, CachedExternalResourceIndex<String> writableCache) {
        this.readOnlyCachePath = readOnlyCachePath;
        this.readOnlyCache = readOnlyCache;
        this.writableCache = writableCache;
    }

    @Override
    public void store(String key, File artifactFile, @Nullable ExternalResourceMetaData metaData) {
        if (artifactFile.toPath().startsWith(this.readOnlyCachePath)) {
            return;
        }
        this.writableCache.store(key, artifactFile, metaData);
    }

    @Override
    public void storeMissing(String key) {
        this.writableCache.storeMissing(key);
    }

    @Override
    public @Nullable CachedExternalResource lookup(String key) {
        CachedExternalResource lookup = this.writableCache.lookup(key);
        if (lookup != null) {
            return lookup;
        }
        return this.readOnlyCache.lookup(key);
    }

    @Override
    public void clear(String key) {
        this.writableCache.clear(key);
    }
}

