/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.formatters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class NumberDataFormatter
implements DBDDataFormatter {
    public static final int MAX_DEFAULT_FRACTIONS_DIGITS = 16;
    private static final Log log = Log.getLog(NumberDataFormatter.class);
    private DecimalFormat numberFormat;
    private StringBuffer buffer;
    private FieldPosition position;
    private boolean nativeSpecialValues;

    @Override
    public void init(DBSTypedObject type, Locale locale, Map<String, Object> properties) {
        String roundingMode;
        Object minIntDigits;
        Object maxIntDigits;
        Object groupingSize;
        this.numberFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        Object useGrouping = properties.get("useGrouping");
        if (useGrouping != null) {
            this.numberFormat.setGroupingUsed(CommonUtils.toBoolean((Object)useGrouping));
        }
        if ((groupingSize = properties.get("groupingSize")) != null) {
            this.numberFormat.setGroupingSize(CommonUtils.toInt((Object)groupingSize, (int)this.numberFormat.getGroupingSize()));
        }
        if ((maxIntDigits = properties.get("maxIntegerDigits")) != null) {
            this.numberFormat.setMaximumIntegerDigits(CommonUtils.toInt((Object)maxIntDigits));
        }
        if ((minIntDigits = properties.get("minIntegerDigits")) != null) {
            this.numberFormat.setMinimumIntegerDigits(CommonUtils.toInt((Object)minIntDigits));
        }
        if (type != null) {
            Object minFractDigits;
            int typeScale = type.getScale() != null ? type.getScale() : 0;
            Object maxFractDigits = properties.get("maxFractionDigits");
            if (maxFractDigits != null) {
                int maxFD = CommonUtils.toInt((Object)maxFractDigits);
                if (typeScale > 0 && maxFD > typeScale) {
                    maxFD = typeScale;
                }
                this.numberFormat.setMaximumFractionDigits(maxFD);
            }
            if ((minFractDigits = properties.get("minFractionDigits")) != null) {
                this.numberFormat.setMinimumFractionDigits(CommonUtils.toInt((Object)minFractDigits));
            } else {
                this.numberFormat.setMinimumFractionDigits(0);
            }
        }
        if (!CommonUtils.isEmpty((String)(roundingMode = CommonUtils.toString((Object)properties.get("roundingMode"))))) {
            try {
                this.numberFormat.setRoundingMode(RoundingMode.valueOf(roundingMode));
            }
            catch (Exception exception) {}
        }
        if (type != null && CommonUtils.toBoolean((Object)properties.get("useTypeScale")) && type.getScale() != null && type.getScale() > 0) {
            int fractionDigits = type.getScale();
            if (fractionDigits > 16) {
                fractionDigits = 16;
            }
            this.numberFormat.setMinimumFractionDigits(fractionDigits);
        }
        if (type != null && CommonUtils.isBitSet((long)type.getTypeModifiers(), (long)1024L) && type.getPrecision() != null && type.getPrecision() > 0) {
            if (type.getScale() != null && type.getScale() > 0) {
                this.numberFormat.setMinimumIntegerDigits(type.getPrecision() - type.getScale());
                this.numberFormat.setMinimumFractionDigits(type.getScale());
            } else {
                this.numberFormat.setMinimumIntegerDigits(type.getPrecision());
            }
            this.numberFormat.setGroupingUsed(false);
        }
        this.buffer = new StringBuffer();
        this.position = new FieldPosition(0);
        this.nativeSpecialValues = CommonUtils.toBoolean((Object)properties.get("nativeSpecialValues"));
    }

    @Override
    @Nullable
    public String getPattern() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (CommonUtils.isNaN((Object)value) || CommonUtils.isInfinite((Object)value)) {
            if (this.nativeSpecialValues) {
                return value.toString();
            }
        } else if (value instanceof Float || value instanceof Double) {
            value = new BigDecimal(value.toString());
        } else if (!(value instanceof Number)) {
            return value.toString();
        }
        try {
            NumberDataFormatter numberDataFormatter = this;
            synchronized (numberDataFormatter) {
                this.buffer.setLength(0);
                try {
                    return this.numberFormat.format(value, this.buffer, this.position).toString();
                }
                catch (ArithmeticException e) {
                    if (this.numberFormat.getRoundingMode() == RoundingMode.UNNECESSARY) {
                        log.debug("Disabling UNNECESSARY rounding for numbers (" + e.getMessage() + ")");
                        this.numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
                    }
                    return this.numberFormat.format(value, this.buffer, this.position).toString();
                }
            }
        }
        catch (Exception exception) {
            return value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseValue(String value, @Nullable Class<?> typeHint) throws ParseException {
        NumberDataFormatter numberDataFormatter = this;
        synchronized (numberDataFormatter) {
            this.numberFormat.setParseBigDecimal(typeHint == BigDecimal.class || typeHint == BigInteger.class);
            Number number = this.numberFormat.parse(value);
            if (number != null && typeHint != null) {
                boolean isFloat;
                boolean bl = isFloat = number instanceof Double || number instanceof Float;
                if (typeHint == Byte.class) {
                    if (isFloat) {
                        return number;
                    }
                    return number.byteValue();
                }
                if (typeHint == Short.class) {
                    if (isFloat) {
                        return number;
                    }
                    return number.shortValue();
                }
                if (typeHint == Integer.class) {
                    if (isFloat) {
                        return number;
                    }
                    return number.intValue();
                }
                if (typeHint == Long.class) {
                    if (isFloat) {
                        return number;
                    }
                    return number.longValue();
                }
                if (typeHint == Float.class) {
                    return Float.valueOf(number.floatValue());
                }
                if (typeHint == Double.class) {
                    return number.doubleValue();
                }
            }
            return number;
        }
    }
}

