/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jkiss.code.Nullable;

public class OffsetKeyedTreeMap<T> {
    private Node<T> root = OffsetKeyedTreeMap.sentinel();
    private int size = 0;
    private int tombstonesCount = 0;

    private static <T> Node<T> sentinel() {
        return Node.SENTINEL;
    }

    public void clear() {
        this.root = OffsetKeyedTreeMap.sentinel();
        this.size = 0;
        this.tombstonesCount = 0;
    }

    private NodeAndParentAtOffset<T> findImpl(int pos) {
        int relPos = pos;
        Node<T> parent = this.root;
        boolean isLeft = false;
        Node<T> node = this.root;
        while (node.isNotSentinel()) {
            parent = node;
            if (relPos < node.offset) {
                node = node.left;
                isLeft = true;
                continue;
            }
            if (relPos <= node.offset) break;
            relPos -= node.offset;
            node = node.right;
            isLeft = false;
        }
        return new NodeAndParentAtOffset<T>(parent, node, isLeft, relPos);
    }

    public T find(int position) {
        NodeAndParentAtOffset<T> result = this.findImpl(position);
        return result.node.isNotSentinel() ? (T)result.node.content : null;
    }

    public T put(int pos, T value) {
        return this.put(pos, value, null);
    }

    public T put(int pos, T value, RemappingFunction<T> remappingFunction) {
        T oldValue;
        if (this.root.isSentinel()) {
            this.root = new Node<T>(pos, value, false, null, null);
            this.root.refreshBlackHeight();
            ++this.size;
            oldValue = null;
        } else {
            NodeAndParentAtOffset<T> location = this.findImpl(pos);
            if (location.node.isNotSentinel()) {
                Object newValue;
                oldValue = location.node.content;
                if (oldValue == null) {
                    --this.tombstonesCount;
                    newValue = value;
                } else {
                    newValue = remappingFunction == null ? value : remappingFunction.apply(pos, value, oldValue);
                }
                location.node.content = newValue;
            } else {
                oldValue = null;
                Node<T> newNode = new Node<T>(location.offset, value, true, null, null);
                Node parent = location.parent;
                if (location.isLeft) {
                    parent.left = newNode;
                } else {
                    parent.right = newNode;
                }
                newNode.parent = parent;
                ++this.size;
                this.restoreAfterInsert(newNode);
            }
        }
        return oldValue;
    }

    private void restoreAfterInsert(Node<T> x) {
        Node<T> xx = x;
        while (x != this.root && x.parent.isRed) {
            Node y;
            x.left.refreshBlackHeight();
            x.right.refreshBlackHeight();
            x.refreshBlackHeight();
            if (x.parent == x.parent.parent.left) {
                y = x.parent.parent.right;
                if (y != null && y.isRed) {
                    x.parent.isRed = false;
                    y.isRed = false;
                    x.parent.parent.isRed = true;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    this.rotateLeft(x);
                }
                x.parent.isRed = false;
                x.parent.parent.isRed = true;
                this.rotateRight(x.parent.parent);
                continue;
            }
            y = x.parent.parent.left;
            if (y != null && y.isRed) {
                x.parent.isRed = false;
                y.isRed = false;
                x.parent.parent.isRed = true;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                this.rotateRight(x);
            }
            x.parent.isRed = false;
            x.parent.parent.isRed = true;
            this.rotateLeft(x.parent.parent);
        }
        if (xx != this.root) {
            do {
                xx.left.refreshBlackHeight();
                xx.right.refreshBlackHeight();
                xx.refreshBlackHeight();
            } while ((xx = xx.parent) != this.root);
        }
        this.fixupRoot();
    }

    private void fixupRoot() {
        if (this.root.isNotSentinel()) {
            this.root.parent = null;
            this.root.isRed = false;
            this.root.left.refreshBlackHeight();
            this.root.right.refreshBlackHeight();
            this.root.refreshBlackHeight();
        }
    }

    private Node<T> rotateLeft(Node<T> x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left.isNotSentinel()) {
            y.left.parent = x;
        }
        if (y.isNotSentinel()) {
            y.parent = x.parent;
        }
        if (x.parent != null) {
            if (x == x.parent.left) {
                x.parent.left = y;
            } else {
                x.parent.right = y;
            }
        } else if (this.root == x) {
            this.root.parent = null;
            this.root = y;
        }
        y.left = x;
        if (x.isNotSentinel()) {
            x.parent = y;
        }
        x.refreshBlackHeight();
        y.refreshBlackHeight();
        y.offset += x.offset;
        return y;
    }

    private Node<T> rotateRight(Node<T> x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right.isNotSentinel()) {
            y.right.parent = x;
        }
        if (y.isNotSentinel()) {
            y.parent = x.parent;
        }
        if (x.parent != null) {
            if (x == x.parent.right) {
                x.parent.right = y;
            } else {
                x.parent.left = y;
            }
        } else if (this.root == x) {
            this.root.parent = null;
            this.root = y;
        }
        y.right = x;
        if (x.isNotSentinel()) {
            x.parent = y;
        }
        x.refreshBlackHeight();
        y.refreshBlackHeight();
        x.offset -= y.offset;
        if (x.offset < 0) {
            throw new IllegalStateException("relative offsets invariant being positive violated during balancing rotation procedure");
        }
        return y;
    }

    public int size() {
        return this.size - this.tombstonesCount;
    }

    public NodesIterator<T> nodesIteratorAt(final int position) {
        final NodeAndParentAtOffset<T> initialLocation = this.findImpl(position);
        return switch (this.size) {
            case 0 -> new NodesIterator<T>(){

                @Override
                @Nullable
                public T getCurrValue() {
                    return null;
                }

                @Override
                public int getCurrOffset() {
                    return position;
                }

                @Override
                public boolean prev() {
                    return false;
                }

                @Override
                public boolean next() {
                    return false;
                }
            };
            case 1 -> new NodesIterator<T>(position){
                boolean beforeFirst;
                boolean afterLast;
                final Node<T> theOnlyNode;
                {
                    this.beforeFirst = n < OffsetKeyedTreeMap.this.root.offset;
                    this.afterLast = n > OffsetKeyedTreeMap.this.root.offset;
                    this.theOnlyNode = OffsetKeyedTreeMap.this.root;
                }

                @Override
                @Nullable
                public T getCurrValue() {
                    return !this.beforeFirst && !this.afterLast ? (Object)this.theOnlyNode.content : null;
                }

                @Override
                public int getCurrOffset() {
                    return this.beforeFirst ? Integer.MIN_VALUE : (this.afterLast ? Integer.MAX_VALUE : this.theOnlyNode.offset);
                }

                @Override
                public boolean prev() {
                    if (this.beforeFirst) {
                        return false;
                    }
                    if (this.afterLast) {
                        this.afterLast = false;
                        return true;
                    }
                    this.beforeFirst = true;
                    return false;
                }

                @Override
                public boolean next() {
                    if (this.afterLast) {
                        return false;
                    }
                    if (this.beforeFirst) {
                        this.beforeFirst = false;
                        return true;
                    }
                    this.afterLast = true;
                    return false;
                }
            };
            default -> new NodesIterator<T>(){
                boolean beforeFirst = false;
                boolean afterLast = false;
                boolean initial = true;
                NodeAndOffset<T> currentLocation;
                {
                    this.currentLocation = new NodeAndOffset(nodeAndParentAtOffset.node.isSentinel() ? null : nodeAndParentAtOffset.node, nodeAndParentAtOffset.node.isSentinel() ? n : n - nodeAndParentAtOffset.node.offset);
                }

                @Override
                @Nullable
                public T getCurrValue() {
                    return this.currentLocation.node == null ? null : (Object)this.currentLocation.node.content;
                }

                @Override
                public int getCurrOffset() {
                    return this.currentLocation.offset + (this.currentLocation.node == null ? 0 : this.currentLocation.node.offset);
                }

                @Override
                public boolean prev() {
                    if (this.initial && initialLocation.node.isSentinel()) {
                        NodeAndOffset parentLocation = new NodeAndOffset(initialLocation.parent, position - initialLocation.offset - (initialLocation.isLeft ? 0 : initialLocation.parent.offset));
                        this.currentLocation = initialLocation.isLeft ? OffsetKeyedTreeMap.this.findPrev(parentLocation) : parentLocation;
                    } else {
                        if (this.beforeFirst) {
                            return false;
                        }
                        if (this.afterLast) {
                            this.currentLocation = OffsetKeyedTreeMap.this.findLast(new NodeAndOffset(OffsetKeyedTreeMap.this.root, 0));
                            this.afterLast = false;
                        } else {
                            this.currentLocation = OffsetKeyedTreeMap.this.findPrev(this.currentLocation);
                        }
                    }
                    while (this.currentLocation.node != null && this.currentLocation.node.content == null) {
                        this.currentLocation = OffsetKeyedTreeMap.this.findPrev(this.currentLocation);
                    }
                    this.initial = false;
                    boolean bl = this.beforeFirst = this.currentLocation.node == null;
                    return this.currentLocation.node != null;
                }

                @Override
                public boolean next() {
                    if (this.initial && initialLocation.node.isSentinel()) {
                        NodeAndOffset parentLocation = new NodeAndOffset(initialLocation.parent, position - initialLocation.offset - (initialLocation.isLeft ? 0 : initialLocation.parent.offset));
                        this.currentLocation = initialLocation.isLeft ? parentLocation : OffsetKeyedTreeMap.this.findNext(parentLocation);
                    } else {
                        if (this.afterLast) {
                            return false;
                        }
                        if (this.beforeFirst) {
                            this.currentLocation = OffsetKeyedTreeMap.this.findFirst(new NodeAndOffset(OffsetKeyedTreeMap.this.root, 0));
                            this.beforeFirst = false;
                        } else {
                            this.currentLocation = OffsetKeyedTreeMap.this.findNext(this.currentLocation);
                        }
                    }
                    while (this.currentLocation.node != null && this.currentLocation.node.content == null) {
                        this.currentLocation = OffsetKeyedTreeMap.this.findNext(this.currentLocation);
                    }
                    this.initial = false;
                    boolean bl = this.afterLast = this.currentLocation.node == null;
                    return this.currentLocation.node != null;
                }
            };
        };
    }

    private NodeAndOffset<T> findFirst(NodeAndOffset<T> location) {
        Node node = location.node;
        int offset = location.offset;
        while (node.left.isNotSentinel()) {
            node = node.left;
        }
        return new NodeAndOffset(node, offset);
    }

    private NodeAndOffset<T> findLast(NodeAndOffset<T> location) {
        Node node = location.node;
        int offset = location.offset;
        while (node.right.isNotSentinel()) {
            offset += node.offset;
            node = node.right;
        }
        return new NodeAndOffset(node, offset);
    }

    private NodeAndOffset<T> findPrev(NodeAndOffset<T> location) {
        Node prev;
        Node node = location.node;
        int offset = location.offset;
        if (node.left.isNotSentinel()) {
            prev = node.left;
            while (prev.right.isNotSentinel()) {
                offset += prev.offset;
                prev = prev.right;
            }
        } else {
            prev = node.parent;
            while (prev != null && prev.right != node) {
                node = prev;
                prev = node.parent;
            }
            if (prev != null && prev.right == node) {
                offset -= prev.offset;
            }
        }
        return new NodeAndOffset(prev, prev == null ? Integer.MIN_VALUE : offset);
    }

    private NodeAndOffset<T> findNext(NodeAndOffset<T> location) {
        Node next;
        int offset;
        block4: {
            Node node;
            block3: {
                node = location.node;
                offset = location.offset;
                if (!node.right.isNotSentinel()) break block3;
                next = node.right;
                offset += node.offset;
                while (next.left.isNotSentinel()) {
                    next = next.left;
                }
                break block4;
            }
            next = node.parent;
            if (next == null) break block4;
            if (next.right == node) {
                offset -= next.offset;
            }
            while (next != null && next.left != node) {
                node = next;
                next = node.parent;
                if (next == null || next.right != node) continue;
                offset -= next.offset;
            }
        }
        return new NodeAndOffset(next, next == null ? Integer.MAX_VALUE : offset);
    }

    private static <T> Iterable<T> flatten(final T node, final Function<T, Iterable<T>> childrenSelector) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FlatteningIterator<Object>(node, childrenSelector);
            }
        };
    }

    private static <T> NodeAndOffset<T> evaluateNodeBlackHeight(Node<T> node, int p) {
        return new NodeAndOffset<T>(node, p + (node.isRed ? 0 : 1));
    }

    public int validateBlackHeights() {
        long count;
        Set<Integer> bh;
        Set<Integer> set = bh = this.root.isSentinel() ? Set.of(Integer.valueOf(0)) : StreamSupport.stream(OffsetKeyedTreeMap.flatten(OffsetKeyedTreeMap.evaluateNodeBlackHeight(this.root, 0), n -> Stream.of(n.node.left, n.node.right).filter(Node::isNotSentinel).map(c -> OffsetKeyedTreeMap.evaluateNodeBlackHeight(c, nodeAndOffset.offset)).toList()).spliterator(), false).filter(xn -> xn.node.left.isSentinel() && xn.node.right.isSentinel()).map(xn -> xn.offset).collect(Collectors.toSet());
        if (bh.size() != 1 || !((Integer)bh.stream().findFirst().get()).equals(this.root.blackHeight)) {
            throw new IllegalStateException("Black height constraint violation");
        }
        long l = count = this.root.isSentinel() ? 0L : StreamSupport.stream(OffsetKeyedTreeMap.flatten(this.root, n -> Stream.of(n.left, n.right).filter(Node::isNotSentinel).toList()).spliterator(), false).count();
        if (count != (long)this.size) {
            throw new IllegalStateException("size property is inconsistent");
        }
        if (this.root.isNotSentinel()) {
            StreamSupport.stream(OffsetKeyedTreeMap.flatten(this.root, n -> Stream.of(n.left, n.right).filter(Node::isNotSentinel).toList()).spliterator(), false).forEach((? super T n) -> {
                if (n != this.root && n.parent == null || n.parent == OffsetKeyedTreeMap.sentinel()) {
                    throw new IllegalStateException("Missing parent reference detected");
                }
            });
        }
        return (Integer)bh.stream().findFirst().get();
    }

    /*
     * Unable to fully structure code
     */
    public void applyOffset(int position, int delta) {
        if (delta == 0) {
            return;
        }
        if (delta < 0) {
            throw new UnsupportedOperationException("Negative delta not supported at the moment");
        }
        if (this.size == 0) {
            return;
        }
        location = this.findImpl(position);
        if (location.node.isSentinel() && location.isLeft) {
            location.parent.offset += delta;
        }
        if (location.node.isNotSentinel()) {
            location.node.offset += delta;
        }
        node = location.node.isSentinel() != false ? location.parent : location.node;
        while (node != null && node.parent != null) {
            parent = node.parent;
            while (parent != null) {
                if (node != parent.left) ** GOTO lbl23
                parent.offset += delta;
                node = parent;
                parent = node.parent;
                continue;
lbl-1000:
                // 1 sources

                {
                    node = parent;
                    parent = node.parent;
lbl23:
                    // 2 sources

                    ** while (parent != null && node == parent.right)
                }
lbl24:
                // 1 sources

            }
        }
    }

    public void forEach(BiConsumer<Integer, T> action) {
        if (this.root.isNotSentinel()) {
            int currOffset = 0;
            Node<T> node = this.root;
            Node<T> prev = null;
            Node next = null;
            do {
                if (prev == node.parent || prev == null) {
                    if (node.left.isNotSentinel()) {
                        next = node.left;
                    } else if (node.right.isNotSentinel()) {
                        action.accept(currOffset + node.offset, (Integer)node.content);
                        currOffset += node.offset;
                        next = node.right;
                    } else {
                        action.accept(currOffset + node.offset, (Integer)node.content);
                        currOffset -= node.parent != null && node.parent.right == node ? node.parent.offset : 0;
                        next = node.parent;
                    }
                } else if (prev == node.left) {
                    action.accept(currOffset + node.offset, (Integer)node.content);
                    if (node.right.isNotSentinel()) {
                        currOffset += node.offset;
                        next = node.right;
                    } else {
                        currOffset -= node.parent != null && node.parent.right == node ? node.parent.offset : 0;
                        next = node.parent;
                    }
                } else if (prev == node.right) {
                    currOffset -= node.parent != null && node.parent.right == node ? node.parent.offset : 0;
                    next = node.parent;
                } else {
                    throw new IllegalStateException("RB-tree inconsistency detected");
                }
                prev = node;
            } while ((node = next) != this.root.parent);
        }
    }

    private static <T> void stringifyNode(StringBuilder sb, int depth, int offset, Node<T> node, String prefix) {
        sb.append(String.join((CharSequence)"", "  ".repeat(depth))).append(prefix).append("[").append(offset).append(" as ").append(node.offset).append("] ").append(node.content).append("\n");
    }

    private void collectImpl(StringBuilder sb, int depth, int offCtx, Node<T> node, String prefix) {
        OffsetKeyedTreeMap.stringifyNode(sb, depth, offCtx + node.offset, node, prefix);
        if (node.left.isNotSentinel()) {
            this.collectImpl(sb, depth + 1, offCtx, node.left, "L");
        }
        if (node.right.isNotSentinel()) {
            this.collectImpl(sb, depth + 1, offCtx + node.offset, node.right, "R");
        }
    }

    public String collect() {
        StringBuilder sb = new StringBuilder();
        this.collectImpl(sb, 0, 0, this.root, "");
        return sb.toString();
    }

    public boolean removeAt(int position) {
        NodeAndParentAtOffset<T> location = this.findImpl(position);
        if (location.node.isNotSentinel()) {
            this.deleteNode(location.node);
            return true;
        }
        return false;
    }

    private void deleteNode(Node<T> z) {
        Node t;
        int xDelta;
        Node x;
        Node<T> y;
        if (z.left.isSentinel() || z.right.isSentinel()) {
            y = z;
        } else {
            y = z.right;
            if (y.left.isNotSentinel()) {
                z.content = null;
                ++this.tombstonesCount;
                if (this.tombstonesCount > this.size / 2) {
                    OffsetKeyedTreeMap<T> t2 = new OffsetKeyedTreeMap<T>();
                    NodesIterator<T> it = this.nodesIteratorAt(Integer.MAX_VALUE);
                    while (it.prev()) {
                        t2.put(it.getCurrOffset(), it.getCurrValue());
                    }
                    this.root = t2.root;
                    this.size = t2.size;
                    this.tombstonesCount = 0;
                }
                return;
            }
        }
        if (y.left.isNotSentinel()) {
            x = y.left;
            xDelta = 0;
        } else {
            x = y.right;
            xDelta = y.offset;
        }
        x.parent = y.parent;
        if (y.parent != null) {
            if (y == y.parent.left) {
                y.parent.left = x;
            } else {
                y.parent.right = x;
            }
        } else {
            this.root = x;
        }
        if (xDelta > 0) {
            t = x;
            while (t.isNotSentinel()) {
                t.offset += xDelta;
                t = t.left;
            }
        }
        if (y != z) {
            z.content = y.content;
            z.offset += y.offset;
            t = z.right;
            while (t.isNotSentinel()) {
                t.offset -= y.offset;
                if (t.offset < 0) {
                    throw new IllegalStateException("relative offsets invariant being positive violated during after-delete fixup");
                }
                t = t.left;
            }
        }
        if (!y.isRed) {
            this.restoreAfterDelete(x);
        }
        --this.size;
    }

    private void restoreAfterDelete(Node<T> x) {
        while (x != this.root && !x.isRed) {
            Node y;
            if (x == x.parent.left) {
                y = x.parent.right;
                if (y.isRed) {
                    y.isRed = false;
                    x.parent.isRed = true;
                    this.rotateLeft(x.parent);
                    y = x.parent.right;
                }
                if (!y.left.isRed && !y.right.isRed) {
                    y.isRed = true;
                    x = x.parent;
                    continue;
                }
                if (!y.right.isRed) {
                    y.left.isRed = false;
                    y.isRed = true;
                    this.rotateRight(y);
                    y = x.parent.right;
                }
                y.isRed = x.parent.isRed;
                x.parent.isRed = false;
                y.right.isRed = false;
                this.rotateLeft(x.parent);
                x = this.root;
                continue;
            }
            y = x.parent.left;
            if (y.isRed) {
                y.isRed = false;
                x.parent.isRed = true;
                this.rotateRight(x.parent);
                y = x.parent.left;
            }
            if (!y.right.isRed && !y.left.isRed) {
                y.isRed = true;
                x = x.parent;
                continue;
            }
            if (!y.left.isRed) {
                y.right.isRed = false;
                y.isRed = true;
                this.rotateLeft(y);
                y = x.parent.left;
            }
            y.isRed = x.parent.isRed;
            x.parent.isRed = false;
            y.left.isRed = false;
            this.rotateRight(x.parent);
            x = this.root;
        }
        x.isRed = false;
    }

    private static class FlatteningIterator<T>
    implements Iterator<T> {
        private final T node;
        private final Iterator<T> childrenIterator;
        private final Function<T, Iterable<T>> childrenSelector;
        private T current;
        private Iterator<T> expansionIterator;

        public FlatteningIterator(T node, Function<T, Iterable<T>> childrenSelector) {
            this.node = node;
            this.childrenIterator = childrenSelector.apply(node).iterator();
            this.childrenSelector = childrenSelector;
            this.current = node;
            this.expansionIterator = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            T result = this.current;
            if (this.expansionIterator != null && this.expansionIterator.hasNext()) {
                this.current = this.expansionIterator.next();
            } else if (this.childrenIterator.hasNext()) {
                do {
                    this.expansionIterator = OffsetKeyedTreeMap.flatten(this.childrenIterator.next(), this.childrenSelector).iterator();
                } while (!this.expansionIterator.hasNext() && this.childrenIterator.hasNext());
                this.current = this.expansionIterator.hasNext() ? this.expansionIterator.next() : null;
            } else {
                this.current = null;
            }
            return result;
        }
    }

    private static class Node<T> {
        public static final Node<?> SENTINEL = new Node<Object>(0, null, false, null, null);
        public int blackHeight = 0;
        public boolean isRed = false;
        public Node<T> left = null;
        public Node<T> right = null;
        public Node<T> parent = null;
        public int offset = 0;
        public T content;

        public boolean isSentinel() {
            return this == SENTINEL;
        }

        public boolean isNotSentinel() {
            return this != SENTINEL;
        }

        public Node(int offset, T content, boolean isRed, Node<T> left, Node<T> right) {
            this.left = left != null ? left : OffsetKeyedTreeMap.sentinel();
            this.right = right != null ? right : OffsetKeyedTreeMap.sentinel();
            this.offset = offset;
            this.content = content;
            this.isRed = isRed;
            this.parent = null;
        }

        public void refreshBlackHeight() {
            if (this.isNotSentinel()) {
                this.blackHeight = Math.max(this.left.blackHeight, this.right.blackHeight) + (this.isRed ? 0 : 1);
            }
        }

        public void refreshParentRefs() {
            if (this.left.isNotSentinel()) {
                this.left.parent = this;
            }
            if (this.right.isNotSentinel()) {
                this.right.parent = this;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + (String)(this.isSentinel() ? "[SENTINEL]" : "[" + this.offset + ", '" + String.valueOf(this.content) + "']");
        }
    }

    private static class NodeAndOffset<T> {
        public final Node<T> node;
        public final int offset;

        public NodeAndOffset(Node<T> node, int offset) {
            this.node = node;
            this.offset = offset;
        }
    }

    private static class NodeAndParentAtOffset<T>
    extends NodeAndOffset<T> {
        public final Node<T> parent;
        public final boolean isLeft;

        public NodeAndParentAtOffset(Node<T> parent, Node<T> node, boolean isLeft, int offset) {
            super(node, offset);
            this.parent = parent;
            this.isLeft = isLeft;
        }
    }

    public static interface NodesIterator<T> {
        public int getCurrOffset();

        public T getCurrValue();

        public boolean next();

        public boolean prev();
    }

    @FunctionalInterface
    public static interface RemappingFunction<T> {
        public T apply(int var1, T var2, T var3);
    }

    public static class ValueAndOffset<T> {
        public final T value;
        public final int offset;

        public ValueAndOffset(T value, int offset) {
            this.value = value;
            this.offset = offset;
        }
    }
}

