# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "compute-fleet wait",
)
class Wait(AAZWaitCommand):
    """Place the CLI in a waiting state until a condition is met.
    """

    _aaz_info = {
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.azurefleet/fleets/{}", "2024-11-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.fleet_name = AAZStrArg(
            options=["-n", "--name", "--fleet-name"],
            help="The name of the Compute Fleet",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                pattern="^[^_\\W][\\w\\-._]{0,79}(?<![-.])$",
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.FleetsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=False)
        return result

    class FleetsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureFleet/fleets/{fleetName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "fleetName", self.ctx.args.fleet_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2024-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.identity = AAZIdentityObjectType()
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.plan = AAZObjectType()
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.zones = AAZListType()

            identity = cls._schema_on_200.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType(
                flags={"required": True},
            )
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType(
                nullable=True,
            )

            _element = cls._schema_on_200.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            plan = cls._schema_on_200.plan
            plan.name = AAZStrType(
                flags={"required": True},
            )
            plan.product = AAZStrType(
                flags={"required": True},
            )
            plan.promotion_code = AAZStrType(
                serialized_name="promotionCode",
            )
            plan.publisher = AAZStrType(
                flags={"required": True},
            )
            plan.version = AAZStrType()

            properties = cls._schema_on_200.properties
            properties.additional_locations_profile = AAZObjectType(
                serialized_name="additionalLocationsProfile",
            )
            properties.compute_profile = AAZObjectType(
                serialized_name="computeProfile",
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.regular_priority_profile = AAZObjectType(
                serialized_name="regularPriorityProfile",
            )
            properties.spot_priority_profile = AAZObjectType(
                serialized_name="spotPriorityProfile",
            )
            properties.time_created = AAZStrType(
                serialized_name="timeCreated",
                flags={"read_only": True},
            )
            properties.unique_id = AAZStrType(
                serialized_name="uniqueId",
                flags={"read_only": True},
            )
            properties.vm_attributes = AAZObjectType(
                serialized_name="vmAttributes",
            )
            properties.vm_sizes_profile = AAZListType(
                serialized_name="vmSizesProfile",
                flags={"required": True},
            )

            additional_locations_profile = cls._schema_on_200.properties.additional_locations_profile
            additional_locations_profile.location_profiles = AAZListType(
                serialized_name="locationProfiles",
                flags={"required": True},
            )

            location_profiles = cls._schema_on_200.properties.additional_locations_profile.location_profiles
            location_profiles.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.additional_locations_profile.location_profiles.Element
            _element.location = AAZStrType(
                flags={"required": True},
            )
            _element.virtual_machine_profile_override = AAZObjectType(
                serialized_name="virtualMachineProfileOverride",
            )
            _WaitHelper._build_schema_base_virtual_machine_profile_read(_element.virtual_machine_profile_override)

            compute_profile = cls._schema_on_200.properties.compute_profile
            compute_profile.additional_virtual_machine_capabilities = AAZObjectType(
                serialized_name="additionalVirtualMachineCapabilities",
            )
            compute_profile.base_virtual_machine_profile = AAZObjectType(
                serialized_name="baseVirtualMachineProfile",
                flags={"required": True},
            )
            _WaitHelper._build_schema_base_virtual_machine_profile_read(compute_profile.base_virtual_machine_profile)
            compute_profile.compute_api_version = AAZStrType(
                serialized_name="computeApiVersion",
            )
            compute_profile.platform_fault_domain_count = AAZIntType(
                serialized_name="platformFaultDomainCount",
            )

            additional_virtual_machine_capabilities = cls._schema_on_200.properties.compute_profile.additional_virtual_machine_capabilities
            additional_virtual_machine_capabilities.hibernation_enabled = AAZBoolType(
                serialized_name="hibernationEnabled",
            )
            additional_virtual_machine_capabilities.ultra_ssd_enabled = AAZBoolType(
                serialized_name="ultraSSDEnabled",
            )

            regular_priority_profile = cls._schema_on_200.properties.regular_priority_profile
            regular_priority_profile.allocation_strategy = AAZStrType(
                serialized_name="allocationStrategy",
            )
            regular_priority_profile.capacity = AAZIntType()
            regular_priority_profile.min_capacity = AAZIntType(
                serialized_name="minCapacity",
            )

            spot_priority_profile = cls._schema_on_200.properties.spot_priority_profile
            spot_priority_profile.allocation_strategy = AAZStrType(
                serialized_name="allocationStrategy",
            )
            spot_priority_profile.capacity = AAZIntType()
            spot_priority_profile.eviction_policy = AAZStrType(
                serialized_name="evictionPolicy",
            )
            spot_priority_profile.maintain = AAZBoolType()
            spot_priority_profile.max_price_per_vm = AAZFloatType(
                serialized_name="maxPricePerVM",
            )
            spot_priority_profile.min_capacity = AAZIntType(
                serialized_name="minCapacity",
            )

            vm_attributes = cls._schema_on_200.properties.vm_attributes
            vm_attributes.accelerator_count = AAZObjectType(
                serialized_name="acceleratorCount",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.accelerator_count)
            vm_attributes.accelerator_manufacturers = AAZListType(
                serialized_name="acceleratorManufacturers",
            )
            vm_attributes.accelerator_support = AAZStrType(
                serialized_name="acceleratorSupport",
            )
            vm_attributes.accelerator_types = AAZListType(
                serialized_name="acceleratorTypes",
            )
            vm_attributes.architecture_types = AAZListType(
                serialized_name="architectureTypes",
            )
            vm_attributes.burstable_support = AAZStrType(
                serialized_name="burstableSupport",
            )
            vm_attributes.cpu_manufacturers = AAZListType(
                serialized_name="cpuManufacturers",
            )
            vm_attributes.data_disk_count = AAZObjectType(
                serialized_name="dataDiskCount",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.data_disk_count)
            vm_attributes.excluded_vm_sizes = AAZListType(
                serialized_name="excludedVMSizes",
            )
            vm_attributes.local_storage_disk_types = AAZListType(
                serialized_name="localStorageDiskTypes",
            )
            vm_attributes.local_storage_in_gi_b = AAZObjectType(
                serialized_name="localStorageInGiB",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.local_storage_in_gi_b)
            vm_attributes.local_storage_support = AAZStrType(
                serialized_name="localStorageSupport",
            )
            vm_attributes.memory_in_gi_b = AAZObjectType(
                serialized_name="memoryInGiB",
                flags={"required": True},
            )
            _WaitHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.memory_in_gi_b)
            vm_attributes.memory_in_gi_b_per_v_cpu = AAZObjectType(
                serialized_name="memoryInGiBPerVCpu",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.memory_in_gi_b_per_v_cpu)
            vm_attributes.network_bandwidth_in_mbps = AAZObjectType(
                serialized_name="networkBandwidthInMbps",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.network_bandwidth_in_mbps)
            vm_attributes.network_interface_count = AAZObjectType(
                serialized_name="networkInterfaceCount",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.network_interface_count)
            vm_attributes.rdma_network_interface_count = AAZObjectType(
                serialized_name="rdmaNetworkInterfaceCount",
            )
            _WaitHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.rdma_network_interface_count)
            vm_attributes.rdma_support = AAZStrType(
                serialized_name="rdmaSupport",
            )
            vm_attributes.v_cpu_count = AAZObjectType(
                serialized_name="vCpuCount",
                flags={"required": True},
            )
            _WaitHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.v_cpu_count)
            vm_attributes.vm_categories = AAZListType(
                serialized_name="vmCategories",
            )

            accelerator_manufacturers = cls._schema_on_200.properties.vm_attributes.accelerator_manufacturers
            accelerator_manufacturers.Element = AAZStrType()

            accelerator_types = cls._schema_on_200.properties.vm_attributes.accelerator_types
            accelerator_types.Element = AAZStrType()

            architecture_types = cls._schema_on_200.properties.vm_attributes.architecture_types
            architecture_types.Element = AAZStrType()

            cpu_manufacturers = cls._schema_on_200.properties.vm_attributes.cpu_manufacturers
            cpu_manufacturers.Element = AAZStrType()

            excluded_vm_sizes = cls._schema_on_200.properties.vm_attributes.excluded_vm_sizes
            excluded_vm_sizes.Element = AAZStrType()

            local_storage_disk_types = cls._schema_on_200.properties.vm_attributes.local_storage_disk_types
            local_storage_disk_types.Element = AAZStrType()

            vm_categories = cls._schema_on_200.properties.vm_attributes.vm_categories
            vm_categories.Element = AAZStrType()

            vm_sizes_profile = cls._schema_on_200.properties.vm_sizes_profile
            vm_sizes_profile.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.vm_sizes_profile.Element
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.rank = AAZIntType()

            system_data = cls._schema_on_200.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200


class _WaitHelper:
    """Helper class for Wait"""

    _schema_api_entity_reference_read = None

    @classmethod
    def _build_schema_api_entity_reference_read(cls, _schema):
        if cls._schema_api_entity_reference_read is not None:
            _schema.id = cls._schema_api_entity_reference_read.id
            return

        cls._schema_api_entity_reference_read = _schema_api_entity_reference_read = AAZObjectType()

        api_entity_reference_read = _schema_api_entity_reference_read
        api_entity_reference_read.id = AAZStrType()

        _schema.id = cls._schema_api_entity_reference_read.id

    _schema_base_virtual_machine_profile_read = None

    @classmethod
    def _build_schema_base_virtual_machine_profile_read(cls, _schema):
        if cls._schema_base_virtual_machine_profile_read is not None:
            _schema.application_profile = cls._schema_base_virtual_machine_profile_read.application_profile
            _schema.capacity_reservation = cls._schema_base_virtual_machine_profile_read.capacity_reservation
            _schema.diagnostics_profile = cls._schema_base_virtual_machine_profile_read.diagnostics_profile
            _schema.extension_profile = cls._schema_base_virtual_machine_profile_read.extension_profile
            _schema.hardware_profile = cls._schema_base_virtual_machine_profile_read.hardware_profile
            _schema.license_type = cls._schema_base_virtual_machine_profile_read.license_type
            _schema.network_profile = cls._schema_base_virtual_machine_profile_read.network_profile
            _schema.os_profile = cls._schema_base_virtual_machine_profile_read.os_profile
            _schema.scheduled_events_profile = cls._schema_base_virtual_machine_profile_read.scheduled_events_profile
            _schema.security_posture_reference = cls._schema_base_virtual_machine_profile_read.security_posture_reference
            _schema.security_profile = cls._schema_base_virtual_machine_profile_read.security_profile
            _schema.service_artifact_reference = cls._schema_base_virtual_machine_profile_read.service_artifact_reference
            _schema.storage_profile = cls._schema_base_virtual_machine_profile_read.storage_profile
            _schema.time_created = cls._schema_base_virtual_machine_profile_read.time_created
            _schema.user_data = cls._schema_base_virtual_machine_profile_read.user_data
            return

        cls._schema_base_virtual_machine_profile_read = _schema_base_virtual_machine_profile_read = AAZObjectType()

        base_virtual_machine_profile_read = _schema_base_virtual_machine_profile_read
        base_virtual_machine_profile_read.application_profile = AAZObjectType(
            serialized_name="applicationProfile",
        )
        base_virtual_machine_profile_read.capacity_reservation = AAZObjectType(
            serialized_name="capacityReservation",
        )
        base_virtual_machine_profile_read.diagnostics_profile = AAZObjectType(
            serialized_name="diagnosticsProfile",
        )
        base_virtual_machine_profile_read.extension_profile = AAZObjectType(
            serialized_name="extensionProfile",
        )
        base_virtual_machine_profile_read.hardware_profile = AAZObjectType(
            serialized_name="hardwareProfile",
        )
        base_virtual_machine_profile_read.license_type = AAZStrType(
            serialized_name="licenseType",
        )
        base_virtual_machine_profile_read.network_profile = AAZObjectType(
            serialized_name="networkProfile",
        )
        base_virtual_machine_profile_read.os_profile = AAZObjectType(
            serialized_name="osProfile",
        )
        base_virtual_machine_profile_read.scheduled_events_profile = AAZObjectType(
            serialized_name="scheduledEventsProfile",
        )
        base_virtual_machine_profile_read.security_posture_reference = AAZObjectType(
            serialized_name="securityPostureReference",
        )
        base_virtual_machine_profile_read.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        base_virtual_machine_profile_read.service_artifact_reference = AAZObjectType(
            serialized_name="serviceArtifactReference",
        )
        base_virtual_machine_profile_read.storage_profile = AAZObjectType(
            serialized_name="storageProfile",
        )
        base_virtual_machine_profile_read.time_created = AAZStrType(
            serialized_name="timeCreated",
            flags={"read_only": True},
        )
        base_virtual_machine_profile_read.user_data = AAZStrType(
            serialized_name="userData",
        )

        application_profile = _schema_base_virtual_machine_profile_read.application_profile
        application_profile.gallery_applications = AAZListType(
            serialized_name="galleryApplications",
        )

        gallery_applications = _schema_base_virtual_machine_profile_read.application_profile.gallery_applications
        gallery_applications.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.application_profile.gallery_applications.Element
        _element.configuration_reference = AAZStrType(
            serialized_name="configurationReference",
        )
        _element.enable_automatic_upgrade = AAZBoolType(
            serialized_name="enableAutomaticUpgrade",
        )
        _element.order = AAZIntType()
        _element.package_reference_id = AAZStrType(
            serialized_name="packageReferenceId",
            flags={"required": True},
        )
        _element.tags = AAZStrType()
        _element.treat_failure_as_deployment_failure = AAZBoolType(
            serialized_name="treatFailureAsDeploymentFailure",
        )

        capacity_reservation = _schema_base_virtual_machine_profile_read.capacity_reservation
        capacity_reservation.capacity_reservation_group = AAZObjectType(
            serialized_name="capacityReservationGroup",
        )
        cls._build_schema_sub_resource_read(capacity_reservation.capacity_reservation_group)

        diagnostics_profile = _schema_base_virtual_machine_profile_read.diagnostics_profile
        diagnostics_profile.boot_diagnostics = AAZObjectType(
            serialized_name="bootDiagnostics",
        )

        boot_diagnostics = _schema_base_virtual_machine_profile_read.diagnostics_profile.boot_diagnostics
        boot_diagnostics.enabled = AAZBoolType()
        boot_diagnostics.storage_uri = AAZStrType(
            serialized_name="storageUri",
        )

        extension_profile = _schema_base_virtual_machine_profile_read.extension_profile
        extension_profile.extensions = AAZListType()
        extension_profile.extensions_time_budget = AAZStrType(
            serialized_name="extensionsTimeBudget",
        )

        extensions = _schema_base_virtual_machine_profile_read.extension_profile.extensions
        extensions.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element
        _element.id = AAZStrType(
            flags={"read_only": True},
        )
        _element.name = AAZStrType()
        _element.properties = AAZObjectType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element.properties
        properties.auto_upgrade_minor_version = AAZBoolType(
            serialized_name="autoUpgradeMinorVersion",
        )
        properties.enable_automatic_upgrade = AAZBoolType(
            serialized_name="enableAutomaticUpgrade",
        )
        properties.force_update_tag = AAZStrType(
            serialized_name="forceUpdateTag",
        )
        properties.protected_settings_from_key_vault = AAZObjectType(
            serialized_name="protectedSettingsFromKeyVault",
        )
        properties.provision_after_extensions = AAZListType(
            serialized_name="provisionAfterExtensions",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.publisher = AAZStrType()
        properties.settings = AAZFreeFormDictType()
        properties.suppress_failures = AAZBoolType(
            serialized_name="suppressFailures",
        )
        properties.type = AAZStrType()
        properties.type_handler_version = AAZStrType(
            serialized_name="typeHandlerVersion",
        )

        protected_settings_from_key_vault = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element.properties.protected_settings_from_key_vault
        protected_settings_from_key_vault.secret_url = AAZStrType(
            serialized_name="secretUrl",
            flags={"required": True},
        )
        protected_settings_from_key_vault.source_vault = AAZObjectType(
            serialized_name="sourceVault",
            flags={"required": True},
        )
        cls._build_schema_sub_resource_read(protected_settings_from_key_vault.source_vault)

        provision_after_extensions = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element.properties.provision_after_extensions
        provision_after_extensions.Element = AAZStrType()

        hardware_profile = _schema_base_virtual_machine_profile_read.hardware_profile
        hardware_profile.vm_size_properties = AAZObjectType(
            serialized_name="vmSizeProperties",
        )

        vm_size_properties = _schema_base_virtual_machine_profile_read.hardware_profile.vm_size_properties
        vm_size_properties.v_cp_us_available = AAZIntType(
            serialized_name="vCPUsAvailable",
        )
        vm_size_properties.v_cp_us_per_core = AAZIntType(
            serialized_name="vCPUsPerCore",
        )

        network_profile = _schema_base_virtual_machine_profile_read.network_profile
        network_profile.health_probe = AAZObjectType(
            serialized_name="healthProbe",
        )
        cls._build_schema_api_entity_reference_read(network_profile.health_probe)
        network_profile.network_api_version = AAZStrType(
            serialized_name="networkApiVersion",
        )
        network_profile.network_interface_configurations = AAZListType(
            serialized_name="networkInterfaceConfigurations",
        )

        network_interface_configurations = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations
        network_interface_configurations.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType()

        properties = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties
        properties.auxiliary_mode = AAZStrType(
            serialized_name="auxiliaryMode",
        )
        properties.auxiliary_sku = AAZStrType(
            serialized_name="auxiliarySku",
        )
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.disable_tcp_state_tracking = AAZBoolType(
            serialized_name="disableTcpStateTracking",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_fpga = AAZBoolType(
            serialized_name="enableFpga",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"required": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_sub_resource_read(properties.network_security_group)
        properties.primary = AAZBoolType()

        dns_settings = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.dns_settings
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )

        dns_servers = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        ip_configurations = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType()

        properties = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_pools = AAZListType(
            serialized_name="loadBalancerInboundNatPools",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.public_ip_address_configuration = AAZObjectType(
            serialized_name="publicIPAddressConfiguration",
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_api_entity_reference_read(properties.subnet)

        application_gateway_backend_address_pools = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_gateway_backend_address_pools.Element)

        application_security_groups = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_pools = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_inbound_nat_pools
        load_balancer_inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_inbound_nat_pools.Element)

        public_ip_address_configuration = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrType(
            flags={"required": True},
        )
        public_ip_address_configuration.properties = AAZObjectType()
        public_ip_address_configuration.sku = AAZObjectType()

        properties = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)

        dns_settings = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
            flags={"required": True},
        )
        dns_settings.domain_name_label_scope = AAZStrType(
            serialized_name="domainNameLabelScope",
        )

        ip_tags = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        sku = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.sku
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        os_profile = _schema_base_virtual_machine_profile_read.os_profile
        os_profile.admin_username = AAZStrType(
            serialized_name="adminUsername",
        )
        os_profile.allow_extension_operations = AAZBoolType(
            serialized_name="allowExtensionOperations",
        )
        os_profile.computer_name_prefix = AAZStrType(
            serialized_name="computerNamePrefix",
        )
        os_profile.linux_configuration = AAZObjectType(
            serialized_name="linuxConfiguration",
        )
        os_profile.require_guest_provision_signal = AAZBoolType(
            serialized_name="requireGuestProvisionSignal",
        )
        os_profile.secrets = AAZListType()
        os_profile.windows_configuration = AAZObjectType(
            serialized_name="windowsConfiguration",
        )

        linux_configuration = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration
        linux_configuration.disable_password_authentication = AAZBoolType(
            serialized_name="disablePasswordAuthentication",
        )
        linux_configuration.enable_vm_agent_platform_updates = AAZBoolType(
            serialized_name="enableVMAgentPlatformUpdates",
        )
        linux_configuration.patch_settings = AAZObjectType(
            serialized_name="patchSettings",
        )
        linux_configuration.provision_vm_agent = AAZBoolType(
            serialized_name="provisionVMAgent",
        )
        linux_configuration.ssh = AAZObjectType()

        patch_settings = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrType(
            serialized_name="assessmentMode",
        )
        patch_settings.automatic_by_platform_settings = AAZObjectType(
            serialized_name="automaticByPlatformSettings",
        )
        patch_settings.patch_mode = AAZStrType(
            serialized_name="patchMode",
        )

        automatic_by_platform_settings = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
            serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrType(
            serialized_name="rebootSetting",
        )

        ssh = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.ssh
        ssh.public_keys = AAZListType(
            serialized_name="publicKeys",
        )

        public_keys = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.ssh.public_keys
        public_keys.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.ssh.public_keys.Element
        _element.key_data = AAZStrType(
            serialized_name="keyData",
        )
        _element.path = AAZStrType()

        secrets = _schema_base_virtual_machine_profile_read.os_profile.secrets
        secrets.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.secrets.Element
        _element.source_vault = AAZObjectType(
            serialized_name="sourceVault",
        )
        cls._build_schema_sub_resource_read(_element.source_vault)
        _element.vault_certificates = AAZListType(
            serialized_name="vaultCertificates",
        )

        vault_certificates = _schema_base_virtual_machine_profile_read.os_profile.secrets.Element.vault_certificates
        vault_certificates.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.secrets.Element.vault_certificates.Element
        _element.certificate_store = AAZStrType(
            serialized_name="certificateStore",
        )
        _element.certificate_url = AAZStrType(
            serialized_name="certificateUrl",
        )

        windows_configuration = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration
        windows_configuration.additional_unattend_content = AAZListType(
            serialized_name="additionalUnattendContent",
        )
        windows_configuration.enable_automatic_updates = AAZBoolType(
            serialized_name="enableAutomaticUpdates",
        )
        windows_configuration.enable_vm_agent_platform_updates = AAZBoolType(
            serialized_name="enableVMAgentPlatformUpdates",
        )
        windows_configuration.patch_settings = AAZObjectType(
            serialized_name="patchSettings",
        )
        windows_configuration.provision_vm_agent = AAZBoolType(
            serialized_name="provisionVMAgent",
        )
        windows_configuration.time_zone = AAZStrType(
            serialized_name="timeZone",
        )
        windows_configuration.win_rm = AAZObjectType(
            serialized_name="winRM",
        )

        additional_unattend_content = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.additional_unattend_content
        additional_unattend_content.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.additional_unattend_content.Element
        _element.component_name = AAZStrType(
            serialized_name="componentName",
        )
        _element.pass_name = AAZStrType(
            serialized_name="passName",
        )
        _element.setting_name = AAZStrType(
            serialized_name="settingName",
        )

        patch_settings = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrType(
            serialized_name="assessmentMode",
        )
        patch_settings.automatic_by_platform_settings = AAZObjectType(
            serialized_name="automaticByPlatformSettings",
        )
        patch_settings.enable_hotpatching = AAZBoolType(
            serialized_name="enableHotpatching",
        )
        patch_settings.patch_mode = AAZStrType(
            serialized_name="patchMode",
        )

        automatic_by_platform_settings = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
            serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrType(
            serialized_name="rebootSetting",
        )

        win_rm = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.win_rm
        win_rm.listeners = AAZListType()

        listeners = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.win_rm.listeners
        listeners.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.win_rm.listeners.Element
        _element.certificate_url = AAZStrType(
            serialized_name="certificateUrl",
        )
        _element.protocol = AAZStrType()

        scheduled_events_profile = _schema_base_virtual_machine_profile_read.scheduled_events_profile
        scheduled_events_profile.os_image_notification_profile = AAZObjectType(
            serialized_name="osImageNotificationProfile",
        )
        scheduled_events_profile.terminate_notification_profile = AAZObjectType(
            serialized_name="terminateNotificationProfile",
        )

        os_image_notification_profile = _schema_base_virtual_machine_profile_read.scheduled_events_profile.os_image_notification_profile
        os_image_notification_profile.enable = AAZBoolType()
        os_image_notification_profile.not_before_timeout = AAZStrType(
            serialized_name="notBeforeTimeout",
        )

        terminate_notification_profile = _schema_base_virtual_machine_profile_read.scheduled_events_profile.terminate_notification_profile
        terminate_notification_profile.enable = AAZBoolType()
        terminate_notification_profile.not_before_timeout = AAZStrType(
            serialized_name="notBeforeTimeout",
        )

        security_posture_reference = _schema_base_virtual_machine_profile_read.security_posture_reference
        security_posture_reference.exclude_extensions = AAZListType(
            serialized_name="excludeExtensions",
        )
        security_posture_reference.id = AAZStrType()
        security_posture_reference.is_overridable = AAZBoolType(
            serialized_name="isOverridable",
        )

        exclude_extensions = _schema_base_virtual_machine_profile_read.security_posture_reference.exclude_extensions
        exclude_extensions.Element = AAZStrType()

        security_profile = _schema_base_virtual_machine_profile_read.security_profile
        security_profile.encryption_at_host = AAZBoolType(
            serialized_name="encryptionAtHost",
        )
        security_profile.encryption_identity = AAZObjectType(
            serialized_name="encryptionIdentity",
        )
        security_profile.proxy_agent_settings = AAZObjectType(
            serialized_name="proxyAgentSettings",
        )
        security_profile.security_type = AAZStrType(
            serialized_name="securityType",
        )
        security_profile.uefi_settings = AAZObjectType(
            serialized_name="uefiSettings",
        )

        encryption_identity = _schema_base_virtual_machine_profile_read.security_profile.encryption_identity
        encryption_identity.user_assigned_identity_resource_id = AAZStrType(
            serialized_name="userAssignedIdentityResourceId",
        )

        proxy_agent_settings = _schema_base_virtual_machine_profile_read.security_profile.proxy_agent_settings
        proxy_agent_settings.enabled = AAZBoolType()
        proxy_agent_settings.key_incarnation_id = AAZIntType(
            serialized_name="keyIncarnationId",
        )
        proxy_agent_settings.mode = AAZStrType()

        uefi_settings = _schema_base_virtual_machine_profile_read.security_profile.uefi_settings
        uefi_settings.secure_boot_enabled = AAZBoolType(
            serialized_name="secureBootEnabled",
        )
        uefi_settings.v_tpm_enabled = AAZBoolType(
            serialized_name="vTpmEnabled",
        )

        service_artifact_reference = _schema_base_virtual_machine_profile_read.service_artifact_reference
        service_artifact_reference.id = AAZStrType()

        storage_profile = _schema_base_virtual_machine_profile_read.storage_profile
        storage_profile.data_disks = AAZListType(
            serialized_name="dataDisks",
        )
        storage_profile.disk_controller_type = AAZStrType(
            serialized_name="diskControllerType",
        )
        storage_profile.image_reference = AAZObjectType(
            serialized_name="imageReference",
        )
        storage_profile.os_disk = AAZObjectType(
            serialized_name="osDisk",
        )

        data_disks = _schema_base_virtual_machine_profile_read.storage_profile.data_disks
        data_disks.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.storage_profile.data_disks.Element
        _element.caching = AAZStrType()
        _element.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        _element.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        _element.disk_iops_read_write = AAZIntType(
            serialized_name="diskIOPSReadWrite",
        )
        _element.disk_m_bps_read_write = AAZIntType(
            serialized_name="diskMBpsReadWrite",
        )
        _element.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        _element.lun = AAZIntType(
            flags={"required": True},
        )
        _element.managed_disk = AAZObjectType(
            serialized_name="managedDisk",
        )
        cls._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(_element.managed_disk)
        _element.name = AAZStrType()
        _element.write_accelerator_enabled = AAZBoolType(
            serialized_name="writeAcceleratorEnabled",
        )

        image_reference = _schema_base_virtual_machine_profile_read.storage_profile.image_reference
        image_reference.community_gallery_image_id = AAZStrType(
            serialized_name="communityGalleryImageId",
        )
        image_reference.exact_version = AAZStrType(
            serialized_name="exactVersion",
            flags={"read_only": True},
        )
        image_reference.id = AAZStrType()
        image_reference.offer = AAZStrType()
        image_reference.publisher = AAZStrType()
        image_reference.shared_gallery_image_id = AAZStrType(
            serialized_name="sharedGalleryImageId",
        )
        image_reference.sku = AAZStrType()
        image_reference.version = AAZStrType()

        os_disk = _schema_base_virtual_machine_profile_read.storage_profile.os_disk
        os_disk.caching = AAZStrType()
        os_disk.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        os_disk.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        os_disk.diff_disk_settings = AAZObjectType(
            serialized_name="diffDiskSettings",
        )
        os_disk.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        os_disk.image = AAZObjectType()
        os_disk.managed_disk = AAZObjectType(
            serialized_name="managedDisk",
        )
        cls._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(os_disk.managed_disk)
        os_disk.name = AAZStrType()
        os_disk.os_type = AAZStrType(
            serialized_name="osType",
        )
        os_disk.vhd_containers = AAZListType(
            serialized_name="vhdContainers",
        )
        os_disk.write_accelerator_enabled = AAZBoolType(
            serialized_name="writeAcceleratorEnabled",
        )

        diff_disk_settings = _schema_base_virtual_machine_profile_read.storage_profile.os_disk.diff_disk_settings
        diff_disk_settings.option = AAZStrType()
        diff_disk_settings.placement = AAZStrType()

        image = _schema_base_virtual_machine_profile_read.storage_profile.os_disk.image
        image.uri = AAZStrType()

        vhd_containers = _schema_base_virtual_machine_profile_read.storage_profile.os_disk.vhd_containers
        vhd_containers.Element = AAZStrType()

        _schema.application_profile = cls._schema_base_virtual_machine_profile_read.application_profile
        _schema.capacity_reservation = cls._schema_base_virtual_machine_profile_read.capacity_reservation
        _schema.diagnostics_profile = cls._schema_base_virtual_machine_profile_read.diagnostics_profile
        _schema.extension_profile = cls._schema_base_virtual_machine_profile_read.extension_profile
        _schema.hardware_profile = cls._schema_base_virtual_machine_profile_read.hardware_profile
        _schema.license_type = cls._schema_base_virtual_machine_profile_read.license_type
        _schema.network_profile = cls._schema_base_virtual_machine_profile_read.network_profile
        _schema.os_profile = cls._schema_base_virtual_machine_profile_read.os_profile
        _schema.scheduled_events_profile = cls._schema_base_virtual_machine_profile_read.scheduled_events_profile
        _schema.security_posture_reference = cls._schema_base_virtual_machine_profile_read.security_posture_reference
        _schema.security_profile = cls._schema_base_virtual_machine_profile_read.security_profile
        _schema.service_artifact_reference = cls._schema_base_virtual_machine_profile_read.service_artifact_reference
        _schema.storage_profile = cls._schema_base_virtual_machine_profile_read.storage_profile
        _schema.time_created = cls._schema_base_virtual_machine_profile_read.time_created
        _schema.user_data = cls._schema_base_virtual_machine_profile_read.user_data

    _schema_disk_encryption_set_parameters_read = None

    @classmethod
    def _build_schema_disk_encryption_set_parameters_read(cls, _schema):
        if cls._schema_disk_encryption_set_parameters_read is not None:
            _schema.id = cls._schema_disk_encryption_set_parameters_read.id
            return

        cls._schema_disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read = AAZObjectType()

        disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read
        disk_encryption_set_parameters_read.id = AAZStrType()

        _schema.id = cls._schema_disk_encryption_set_parameters_read.id

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_vm_attribute_min_max_double_read = None

    @classmethod
    def _build_schema_vm_attribute_min_max_double_read(cls, _schema):
        if cls._schema_vm_attribute_min_max_double_read is not None:
            _schema.max = cls._schema_vm_attribute_min_max_double_read.max
            _schema.min = cls._schema_vm_attribute_min_max_double_read.min
            return

        cls._schema_vm_attribute_min_max_double_read = _schema_vm_attribute_min_max_double_read = AAZObjectType()

        vm_attribute_min_max_double_read = _schema_vm_attribute_min_max_double_read
        vm_attribute_min_max_double_read.max = AAZFloatType()
        vm_attribute_min_max_double_read.min = AAZFloatType()

        _schema.max = cls._schema_vm_attribute_min_max_double_read.max
        _schema.min = cls._schema_vm_attribute_min_max_double_read.min

    _schema_vm_attribute_min_max_integer_read = None

    @classmethod
    def _build_schema_vm_attribute_min_max_integer_read(cls, _schema):
        if cls._schema_vm_attribute_min_max_integer_read is not None:
            _schema.max = cls._schema_vm_attribute_min_max_integer_read.max
            _schema.min = cls._schema_vm_attribute_min_max_integer_read.min
            return

        cls._schema_vm_attribute_min_max_integer_read = _schema_vm_attribute_min_max_integer_read = AAZObjectType()

        vm_attribute_min_max_integer_read = _schema_vm_attribute_min_max_integer_read
        vm_attribute_min_max_integer_read.max = AAZIntType()
        vm_attribute_min_max_integer_read.min = AAZIntType()

        _schema.max = cls._schema_vm_attribute_min_max_integer_read.max
        _schema.min = cls._schema_vm_attribute_min_max_integer_read.min

    _schema_virtual_machine_scale_set_managed_disk_parameters_read = None

    @classmethod
    def _build_schema_virtual_machine_scale_set_managed_disk_parameters_read(cls, _schema):
        if cls._schema_virtual_machine_scale_set_managed_disk_parameters_read is not None:
            _schema.disk_encryption_set = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set
            _schema.security_profile = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.security_profile
            _schema.storage_account_type = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type
            return

        cls._schema_virtual_machine_scale_set_managed_disk_parameters_read = _schema_virtual_machine_scale_set_managed_disk_parameters_read = AAZObjectType()

        virtual_machine_scale_set_managed_disk_parameters_read = _schema_virtual_machine_scale_set_managed_disk_parameters_read
        virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set)
        virtual_machine_scale_set_managed_disk_parameters_read.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )

        security_profile = _schema_virtual_machine_scale_set_managed_disk_parameters_read.security_profile
        security_profile.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrType(
            serialized_name="securityEncryptionType",
        )

        _schema.disk_encryption_set = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set
        _schema.security_profile = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.security_profile
        _schema.storage_account_type = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type


__all__ = ["Wait"]
