#!/bin/bash

# SPDX-FileCopyrightText: Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved. 
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction, 
# disclosure or distribution of this material and related documentation 
# without an express license agreement from NVIDIA CORPORATION or 
# its affiliates is strictly prohibited.

script_dir=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")" &>/dev/null && pwd)
ubuntu_verison=$(grep "^VERSION_ID=" /etc/os-release | awk -F= '{print $2}' | tr -d '"')

apt-get update
# shellcheck disable=SC2046
DEBIAN_FRONTEND=noninteractive apt-get install --no-install-recommends -y $(cat "$script_dir/packages.list")
version_packages_file=$script_dir/packages_$ubuntu_verison.list
if [ -e "$version_packages_file" ]; then
    # shellcheck disable=SC2046
    DEBIAN_FRONTEND=noninteractive apt-get install --no-install-recommends -y $(cat "$version_packages_file")
fi
