/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;

public class ReflectionHelper {
    public static Method resolveJavaMember(MethodDetails methodDetails, Class<?> declaringClass, ClassLoading classLoading, ModelsContext modelContext) {
        MethodDetails.MethodKind methodKind = methodDetails.getMethodKind();
        try {
            if (methodKind == MethodDetails.MethodKind.GETTER) {
                methodDetails.getType().determineRawClass().toJavaClass(classLoading, modelContext);
                return declaringClass.getDeclaredMethod(methodDetails.getName(), new Class[0]);
            }
            if (methodKind == MethodDetails.MethodKind.SETTER) {
                Class memberTypeClass = methodDetails.getType().determineRawClass().toJavaClass(classLoading, modelContext);
                return declaringClass.getDeclaredMethod(methodDetails.getName(), memberTypeClass);
            }
            ArrayList<Class> argumentClasses = CollectionHelper.arrayList(methodDetails.getArgumentTypes().size());
            methodDetails.getArgumentTypes().forEach(argumentClassDetails -> argumentClasses.add(argumentClassDetails.toJavaClass(classLoading, modelContext)));
            return declaringClass.getDeclaredMethod(methodDetails.getName(), argumentClasses.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ModelsException(String.format(Locale.ROOT, "Unable to locate method `%s` on %s", methodDetails.getName(), declaringClass.getName()), e);
        }
    }
}

