/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.AttachmentHint;
import com.webauthn4j.data.KeyProtectionType;
import java.io.IOException;

public class KeyProtectionTypeFromIntDeserializer
extends StdDeserializer<KeyProtectionType> {
    public KeyProtectionTypeFromIntDeserializer() {
        super(KeyProtectionType.class);
    }

    public KeyProtectionType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        int value = p.getValueAsInt();
        try {
            return KeyProtectionType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttachmentHint.class);
        }
    }
}

