/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;
import org.apache.kafka.common.utils.Utils;

public class JwtBearerRequestFormatter
implements HttpRequestFormatter {
    public static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private final String scope;
    private final Supplier<String> assertionSupplier;

    public JwtBearerRequestFormatter(String scope, Supplier<String> assertionSupplier) {
        this.scope = scope;
        this.assertionSupplier = assertionSupplier;
    }

    @Override
    public String formatBody() {
        String assertion = this.assertionSupplier.get();
        StringBuilder requestParameters = new StringBuilder();
        requestParameters.append("grant_type=").append(URLEncoder.encode(GRANT_TYPE, StandardCharsets.UTF_8));
        requestParameters.append("&assertion=").append(URLEncoder.encode(assertion, StandardCharsets.UTF_8));
        if (!Utils.isBlank(this.scope)) {
            requestParameters.append("&scope=").append(URLEncoder.encode(this.scope.trim(), StandardCharsets.UTF_8));
        }
        return requestParameters.toString();
    }

    @Override
    public Map<String, String> formatHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Cache-Control", "no-cache");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }
}

