/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.security.AccessControlException;
import javax.swing.AbstractButton;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.substance.utils.SubstanceInternalFrameTitlePane;

public class RolloverButtonListener
extends BasicButtonListener {
    private boolean isMouseInside;
    private AbstractButton button;

    public RolloverButtonListener(AbstractButton b) {
        super(b);
        this.button = b;
        this.isMouseInside = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        boolean isMouseDrag;
        super.mouseEntered(e);
        this.isMouseInside = true;
        boolean bl = isMouseDrag = (e.getModifiersEx() & 0x400) != 0;
        if (!isMouseDrag) {
            this.button.getModel().setRollover(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.isMouseInside = false;
        this.button.getModel().setRollover(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        for (ActionListener al : this.button.getActionListeners()) {
            if (!(al instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
            return;
        }
        this.button.getModel().setRollover(this.isMouseInside);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        for (ActionListener al : this.button.getActionListeners()) {
            if (!(al instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
            return;
        }
        this.button.getModel().setRollover(this.isMouseInside);
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        if (!this.button.isShowing()) {
            return;
        }
        try {
            PointerInfo pi = MouseInfo.getPointerInfo();
            int px = pi.getLocation().x - this.button.getLocationOnScreen().x;
            int py = pi.getLocation().y - this.button.getLocationOnScreen().y;
            this.button.getModel().setRollover(this.button.contains(px, py));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.button.getModel().setRollover(false);
    }
}

