/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javajs.util.SB;
import jme.AtomDisplayLabel;
import jme.JME;
import jme.JMEUtil;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.viewer.PropertyManager;

public class JMEmol {
    JME jme;
    public int natoms = 0;
    public int nbonds = 0;
    int[] an = new int[20];
    int[] q = new int[20];
    double[] x = new double[20];
    double[] y = new double[20];
    int[][] v = new int[20][7];
    int[] abg = new int[20];
    String[] atag = new String[20];
    String[] label = new String[20];
    int[] nh = new int[20];
    int[] nv = new int[20];
    int[] va = new int[20];
    int[] vb = new int[20];
    int[] nasv = new int[20];
    int[] stereob = new int[20];
    int[] xb = new int[20];
    int[] yb = new int[20];
    String[] btag = new String[20];
    int[][] mark = new int[10][2];
    int[] chain = new int[101];
    int nmarked = 0;
    int maxMark = 0;
    int doColoring = 0;
    int[] a;
    int[] btype;
    int touchedAtom = 0;
    int touchedBond = 0;
    int touched_org;
    double xorg;
    double yorg;
    private boolean linearAdding = false;
    int nchain;
    boolean stopChain = false;
    public boolean needRecentering = false;
    double minx;
    double maxx;
    double miny;
    double maxy;
    static final int SINGLE = 1;
    static final int DOUBLE = 2;
    static final int TRIPLE = 3;
    static final int AROMATIC = 5;
    static final int QUERY = 9;
    static final int QB_ANY = 11;
    static final int QB_AROMATIC = 12;
    static final int QB_RING = 13;
    static final int QB_NONRING = 14;
    private static final int UP = 1;
    private static final int DOWN = 2;
    private static final int XUP = 3;
    private static final int XDOWN = 4;
    private static final int EZ = 10;
    public static final int RBOND = 25;
    private static final int TOUCH_LIMIT = 50;
    private static final int MAX_BONDS_ON_ATOM = 6;
    static boolean TESTDRAW = false;

    JMEmol(JME jme) {
        this.jme = jme;
    }

    private void init() {
        this.natoms = 0;
        this.nbonds = 0;
        this.nmarked = 0;
    }

    JMEmol(JMEmol m) {
        this.jme = m.jme;
        this.natoms = m.natoms;
        this.nbonds = m.nbonds;
        this.nmarked = m.nmarked;
        this.an = new int[this.natoms + 1];
        System.arraycopy(m.an, 0, this.an, 0, this.natoms + 1);
        this.q = new int[this.natoms + 1];
        System.arraycopy(m.q, 0, this.q, 0, this.natoms + 1);
        this.nh = new int[this.natoms + 1];
        System.arraycopy(m.nh, 0, this.nh, 0, this.natoms + 1);
        this.abg = new int[this.natoms + 1];
        System.arraycopy(m.abg, 0, this.abg, 0, this.natoms + 1);
        this.atag = new String[this.natoms + 1];
        System.arraycopy(m.atag, 0, this.atag, 0, this.natoms + 1);
        this.x = new double[this.natoms + 1];
        System.arraycopy(m.x, 0, this.x, 0, this.natoms + 1);
        this.y = new double[this.natoms + 1];
        System.arraycopy(m.y, 0, this.y, 0, this.natoms + 1);
        this.label = new String[this.natoms + 1];
        System.arraycopy(m.label, 0, this.label, 0, this.natoms + 1);
        this.va = new int[this.nbonds + 1];
        System.arraycopy(m.va, 0, this.va, 0, this.nbonds + 1);
        this.vb = new int[this.nbonds + 1];
        System.arraycopy(m.vb, 0, this.vb, 0, this.nbonds + 1);
        this.nasv = new int[this.nbonds + 1];
        System.arraycopy(m.nasv, 0, this.nasv, 0, this.nbonds + 1);
        this.btag = new String[this.nbonds + 1];
        System.arraycopy(m.btag, 0, this.btag, 0, this.nbonds + 1);
        this.stereob = new int[this.nbonds + 1];
        System.arraycopy(m.stereob, 0, this.stereob, 0, this.nbonds + 1);
        this.mark = new int[this.nmarked + 1][2];
        for (int i = 1; i <= this.nmarked; ++i) {
            this.mark[i][0] = m.mark[i][0];
            this.mark[i][1] = m.mark[i][1];
        }
        this.doColoring = m.doColoring;
    }

    JMEmol(JME jme, JMEmol[] mols, int nmols) {
        this(jme);
        for (int i = 1; i <= nmols; ++i) {
            this.natoms += mols[i].natoms;
            this.nbonds += mols[i].nbonds;
            this.nmarked += mols[i].nmarked;
        }
        this.an = new int[this.natoms + 1];
        this.q = new int[this.natoms + 1];
        this.nh = new int[this.natoms + 1];
        this.abg = new int[this.natoms + 1];
        this.atag = new String[this.natoms + 1];
        this.x = new double[this.natoms + 1];
        this.y = new double[this.natoms + 1];
        this.label = new String[this.natoms + 1];
        this.va = new int[this.nbonds + 1];
        this.vb = new int[this.nbonds + 1];
        this.nasv = new int[this.nbonds + 1];
        this.btag = new String[this.nbonds + 1];
        this.stereob = new int[this.nbonds + 1];
        this.mark = new int[this.nmarked + 1][2];
        int na = 0;
        int nb = 0;
        int nm = 0;
        int nadd = 0;
        for (int i = 1; i <= nmols; ++i) {
            int j;
            for (j = 1; j <= mols[i].natoms; ++j) {
                this.an[++na] = mols[i].an[j];
                this.x[na] = mols[i].x[j];
                this.y[na] = mols[i].y[j];
                this.q[na] = mols[i].q[j];
                this.nh[na] = mols[i].nh[j];
                this.abg[na] = mols[i].abg[j];
                this.atag[na] = mols[i].atag[j];
                this.label[na] = mols[i].label[j];
            }
            for (j = 1; j <= mols[i].nbonds; ++j) {
                this.nasv[++nb] = mols[i].nasv[j];
                this.stereob[nb] = mols[i].stereob[j];
                this.va[nb] = mols[i].va[j] + nadd;
                this.vb[nb] = mols[i].vb[j] + nadd;
                this.btag[nb] = mols[i].btag[j];
            }
            for (j = 1; j <= mols[i].nmarked; ++j) {
                this.mark[++nm][0] = mols[i].mark[j][0] + nadd;
                this.mark[nm][1] = mols[i].mark[j][1];
            }
            nadd = na;
        }
        this.complete();
        this.center();
    }

    JMEmol(JME jme, JMEmol m, int part) {
        this(jme);
        int i;
        int[] newn = new int[m.natoms + 1];
        for (i = 1; i <= m.natoms; ++i) {
            if (m.a[i] != part) continue;
            this.createAtom();
            this.an[this.natoms] = m.an[i];
            this.x[this.natoms] = m.x[i];
            this.y[this.natoms] = m.y[i];
            this.q[this.natoms] = m.q[i];
            this.nh[this.natoms] = m.nh[i];
            this.abg[this.natoms] = m.abg[i];
            this.atag[this.natoms] = m.atag[i];
            this.label[this.natoms] = m.label[i];
            newn[i] = this.natoms;
        }
        for (i = 1; i <= m.nbonds; ++i) {
            int atom1 = m.va[i];
            int atom2 = m.vb[i];
            if (m.a[atom1] != part && m.a[atom2] != part) continue;
            if (m.a[atom1] != part || m.a[atom2] != part) {
                System.err.println("MOL multipart inconsistency - report bug !");
                continue;
            }
            this.createBond();
            this.nasv[this.nbonds] = m.nasv[i];
            this.stereob[this.nbonds] = m.stereob[i];
            this.va[this.nbonds] = newn[atom1];
            this.vb[this.nbonds] = newn[atom2];
            this.btag[this.nbonds] = m.btag[i];
        }
        for (i = 1; i <= m.nmarked; ++i) {
            int atom = m.mark[i][0];
            if (atom != part) continue;
            ++this.nmarked;
            this.mark[this.nmarked][0] = newn[atom];
            this.mark[this.nmarked][1] = m.mark[i][1];
        }
        this.doColoring = m.doColoring;
        this.complete();
        this.center();
    }

    JMEmol(JME jme, String molecule, boolean hasCoordinates) {
        this(jme);
        if (molecule.startsWith("\"")) {
            molecule = molecule.substring(1, molecule.length());
        }
        if (molecule.endsWith("\"")) {
            molecule = molecule.substring(0, molecule.length() - 1);
        }
        if (molecule.length() < 1) {
            this.natoms = 0;
            return;
        }
        try {
            int i;
            StringTokenizer st = new StringTokenizer(molecule);
            int natomsx = Integer.valueOf(st.nextToken());
            int nbondsx = Integer.valueOf(st.nextToken());
            for (i = 1; i <= natomsx; ++i) {
                String symbol = st.nextToken();
                this.createAtom(symbol);
                if (!hasCoordinates) continue;
                this.x[i] = Double.valueOf(st.nextToken());
                this.y[i] = -Double.valueOf(st.nextToken()).doubleValue();
            }
            for (i = 1; i <= nbondsx; ++i) {
                this.createBond();
                this.va[i] = Integer.valueOf(st.nextToken());
                this.vb[i] = Integer.valueOf(st.nextToken());
                this.nasv[i] = Integer.valueOf(st.nextToken());
                if (this.nasv[i] == -1) {
                    this.nasv[i] = 1;
                    this.stereob[i] = 1;
                    continue;
                }
                if (this.nasv[i] == -2) {
                    this.nasv[i] = 1;
                    this.stereob[i] = 2;
                    continue;
                }
                if (this.nasv[i] == -5) {
                    this.nasv[i] = 2;
                    this.stereob[i] = 10;
                    continue;
                }
                if (this.nasv[i] != 11 && this.nasv[i] != 12 && this.nasv[i] != 13 && this.nasv[i] != 14) continue;
                this.stereob[i] = this.nasv[i];
                this.nasv[i] = 9;
            }
            this.fillFields();
            if (hasCoordinates) {
                this.scaling();
                this.center();
            }
        }
        catch (Exception e) {
            System.err.println("read mol exception - " + e.getMessage());
            this.natoms = 0;
            return;
        }
        this.deleteHydrogens();
        this.complete();
    }

    public JMEmol(JME jme, JmolAdapterAtomIterator atomIterator, JmolAdapterBondIterator bondIterator) {
        this(jme);
        this.init();
        Hashtable<Object, Integer> atomMap = new Hashtable<Object, Integer>();
        while (atomIterator.hasNext()) {
            this.createAtom();
            atomMap.put(atomIterator.getUniqueID(), this.natoms);
            this.x[this.natoms] = atomIterator.getXYZ().x;
            this.y[this.natoms] = -atomIterator.getXYZ().y;
            this.q[this.natoms] = atomIterator.getFormalCharge();
            this.setAtom(this.natoms, JmolAdapter.getElementSymbol(atomIterator.getElement()));
        }
        block8: while (bondIterator.hasNext()) {
            this.createBond();
            int i = this.nbonds;
            this.va[i] = (Integer)atomMap.get(bondIterator.getAtomUniqueID1());
            this.vb[i] = (Integer)atomMap.get(bondIterator.getAtomUniqueID2());
            int bo = bondIterator.getEncodedOrder();
            switch (bo) {
                case 1025: {
                    this.nasv[i] = 1;
                    this.stereob[i] = 1;
                    continue block8;
                }
                case 1041: {
                    this.nasv[i] = 1;
                    this.stereob[i] = 2;
                    continue block8;
                }
                case 1: 
                case 513: {
                    this.nasv[i] = 1;
                    continue block8;
                }
                case 2: 
                case 514: {
                    this.nasv[i] = 2;
                    continue block8;
                }
                case 3: {
                    this.nasv[i] = 3;
                    continue block8;
                }
            }
            if ((bo & 7) == 0) continue;
            this.nasv[i] = bo & 7;
        }
        this.fillFields();
        this.scaling();
        this.center();
        this.complete();
        this.deleteHydrogens();
        this.complete();
    }

    JMEmol(JME jme, String molFile) {
        this(jme);
        int i;
        if (molFile == null) {
            return;
        }
        String line = "";
        String separator = JMEmol.findSeparator(molFile);
        StringTokenizer st = new StringTokenizer(molFile, separator, true);
        for (int i2 = 1; i2 <= 4; ++i2) {
            line = JMEmol.nextData(st, separator);
        }
        int natomsx = Integer.valueOf(line.substring(0, 3).trim());
        int nbondsx = Integer.valueOf(line.substring(3, 6).trim());
        for (i = 1; i <= natomsx; ++i) {
            int mark;
            String s;
            this.createAtom();
            line = JMEmol.nextData(st, separator);
            this.x[i] = Double.valueOf(line.substring(0, 10).trim());
            this.y[i] = -Double.valueOf(line.substring(10, 20).trim()).doubleValue();
            int endsymbol = 34;
            if (line.length() < 34) {
                endsymbol = line.length();
            }
            String symbol = line.substring(31, endsymbol).trim();
            this.setAtom(i, symbol);
            if (line.length() < 62 || (s = line.substring(60, 63).trim()).length() <= 0 || (mark = Integer.valueOf(s).intValue()) <= 0) continue;
            this.touchedAtom = i;
            jme.currentMark = mark;
            this.mark();
            this.touchedAtom = 0;
        }
        for (i = 1; i <= nbondsx; ++i) {
            this.createBond();
            line = JMEmol.nextData(st, separator);
            this.va[i] = Integer.valueOf(line.substring(0, 3).trim());
            this.vb[i] = Integer.valueOf(line.substring(3, 6).trim());
            int nasvx = Integer.valueOf(line.substring(6, 9).trim());
            this.nasv[i] = nasvx == 1 ? 1 : (nasvx == 2 ? 2 : (nasvx == 3 ? 3 : 9));
            int stereo = 0;
            if (line.length() > 11) {
                stereo = Integer.valueOf(line.substring(9, 12).trim());
            }
            if (nasvx == 1 && stereo == 1) {
                this.nasv[i] = 1;
                this.stereob[i] = 1;
            }
            if (nasvx != 1 || stereo != 6) continue;
            this.nasv[i] = 1;
            this.stereob[i] = 2;
        }
        this.fillFields();
        this.scaling();
        this.center();
        this.complete();
        while (st.hasMoreTokens() && (line = st.nextToken()) != null && !line.startsWith("M  END")) {
            int a;
            int i3;
            int ndata;
            if (line.startsWith("M  CHG")) {
                StringTokenizer stq = new StringTokenizer(line);
                stq.nextToken();
                stq.nextToken();
                ndata = Integer.valueOf(stq.nextToken());
                for (i3 = 1; i3 <= ndata; ++i3) {
                    a = Integer.valueOf(stq.nextToken());
                    this.q[a] = Integer.valueOf(stq.nextToken());
                }
            }
            if (!line.startsWith("M  APO")) continue;
            StringTokenizer stq = new StringTokenizer(line);
            stq.nextToken();
            stq.nextToken();
            ndata = Integer.valueOf(stq.nextToken());
            for (i3 = 1; i3 <= ndata; ++i3) {
                a = Integer.valueOf(stq.nextToken());
                int nr = Integer.valueOf(stq.nextToken());
                this.touchedAtom = a;
                this.addBond();
                this.setAtom(this.natoms, "R" + nr);
                this.touchedAtom = 0;
            }
        }
        this.deleteHydrogens();
        this.complete();
    }

    public static String nextData(StringTokenizer st, String separator) {
        if (st.hasMoreTokens()) {
            char c;
            String s = st.nextToken();
            if (s.equals(separator)) {
                return " ";
            }
            if (!st.nextToken().equals(separator)) {
                System.err.println("mol file line separator problem!");
            }
            while ((c = s.charAt(s.length() - 1)) == '|' || c == '\n' || c == '\r') {
                if ((s = s.substring(0, s.length() - 1)).length() != 0) continue;
                return " ";
            }
            return s;
        }
        return null;
    }

    public static String findSeparator(String molFile) {
        StringTokenizer st = new StringTokenizer(molFile, "\n", true);
        if (st.countTokens() > 4) {
            return "\n";
        }
        st = new StringTokenizer(molFile, "|", true);
        if (st.countTokens() > 4) {
            return "|";
        }
        System.err.println("Cannot process mol file, use | as line separator !");
        return null;
    }

    public int getAtomCount() {
        return this.natoms;
    }

    public int getBondCount() {
        return this.nbonds;
    }

    public double getX(int i) {
        return this.x[i] * 1.4 / 25.0;
    }

    public double getY(int i) {
        return this.y[i] * 1.4 / 25.0;
    }

    public void setAtomProperties(double xx, double yy, int ahc, int aq) {
        this.x[this.natoms] = xx;
        this.y[this.natoms] = yy;
        this.setAtomHydrogenCount(this.natoms, ahc);
        this.setAtomFormalCharge(this.natoms, aq);
    }

    public int getHydrogenCount(int i) {
        return this.nh[i];
    }

    public int getCharge(int i) {
        return this.q[i];
    }

    public int[] getBondProperties(int i) {
        int[] bd = new int[]{this.va[i], this.vb[i], this.nasv[i], this.stereob[i]};
        return bd;
    }

    public void setBondProperties(int bp0, int bp1, int bp2, int bp3) {
        this.va[this.nbonds] = bp0;
        this.vb[this.nbonds] = bp1;
        this.nasv[this.nbonds] = bp2;
        this.stereob[this.nbonds] = bp3;
    }

    public void completeMolecule() {
        this.fillFields();
        this.scaling();
        this.center();
        this.complete();
    }

    void complete() {
        this.fillFields();
        int storage = this.nasv.length;
        this.xb = new int[storage];
        this.yb = new int[storage];
        this.findBondCenters();
        this.valenceState();
    }

    void scaling() {
        int i;
        double sumlen = 0.0;
        double scale = 0.0;
        for (i = 1; i <= this.nbonds; ++i) {
            double dx = this.x[this.va[i]] - this.x[this.vb[i]];
            double dy = this.y[this.va[i]] - this.y[this.vb[i]];
            sumlen += Math.sqrt(dx * dx + dy * dy);
        }
        if (this.nbonds > 0) {
            scale = 25.0 / (sumlen /= (double)this.nbonds);
        } else if (this.natoms > 1) {
            scale = 75.0 / Math.sqrt((this.x[1] - this.x[2]) * (this.x[1] - this.x[2]) + (this.y[1] - this.y[2]) * (this.y[1] - this.y[2]));
        }
        i = 1;
        while (i <= this.natoms) {
            int n = i;
            this.x[n] = this.x[n] * scale;
            int n2 = i++;
            this.y[n2] = this.y[n2] * scale;
        }
    }

    public void center() {
        double[] center = new double[4];
        int xpix = 0;
        int ypix = 0;
        if (this.jme != null && this.jme.dimension != null && this.jme.dimension.width > 0) {
            xpix = this.jme.dimension.width - this.jme.sd;
            ypix = this.jme.dimension.height - this.jme.sd * 3;
        }
        if (xpix <= 0 || ypix <= 0) {
            this.needRecentering = true;
            return;
        }
        this.centerPoint(center);
        int shiftx = xpix / 2 - (int)Math.round(center[0]);
        int shifty = ypix / 2 - (int)Math.round(center[1]);
        if (!this.jme.nocenter) {
            int i = 1;
            while (i <= this.natoms) {
                int n = i;
                this.x[n] = this.x[n] + (double)shiftx;
                int n2 = i++;
                this.y[n2] = this.y[n2] + (double)shifty;
            }
        }
        this.findBondCenters();
    }

    int testAtomTouch(int xx, int yy) {
        int atom = 0;
        double min = 51.0;
        for (int i = 1; i <= this.natoms; ++i) {
            double dx = (double)xx - this.x[i];
            double dy = (double)yy - this.y[i];
            double rx = dx * dx + dy * dy;
            if (!(rx < 50.0) || !(rx < min)) continue;
            min = rx;
            atom = i;
        }
        return atom;
    }

    int testBondTouch(int xx, int yy) {
        int bond = 0;
        double min = 51.0;
        for (int i = 1; i <= this.nbonds; ++i) {
            double dx = xx - this.xb[i];
            double dy = yy - this.yb[i];
            double rx = dx * dx + dy * dy;
            if (!(rx < 50.0) || !(rx < min)) continue;
            min = rx;
            bond = i;
        }
        return bond;
    }

    void reset() {
        this.save();
        this.natoms = 0;
        this.nbonds = 0;
        this.nmarked = 0;
    }

    public void draw(Graphics g) {
        int i;
        double sirka2c;
        double sirka2s;
        double dd;
        double dy;
        double dx;
        int atom2;
        int atom1;
        double sina = 1.0;
        double cosa = 1.0;
        double sirka2 = 2.0;
        double sirka3 = 3.0;
        if (this.needRecentering) {
            this.center();
            this.jme.alignMolecules(1, this.jme.nmols, 0);
            this.needRecentering = false;
        }
        if (this.jme.depictScale != 1.0) {
            sirka2 *= this.jme.depictScale;
            sirka3 *= this.jme.depictScale;
            double xs = 1.0;
            if (this.jme.depictScale < 0.7) {
                xs = 1.2;
            }
            int fs = (int)((double)this.jme.fontSize * this.jme.depictScale * xs);
            this.jme.font = new Font("Helvetica", 0, fs);
            this.jme.fontMet = g.getFontMetrics(this.jme.font);
        }
        if (this.jme.depictBorder) {
            g.setColor(Color.black);
            g.drawRect(0, 0, this.jme.dimension.width - 1, this.jme.dimension.height - 1);
        }
        if (this.natoms == 0) {
            return;
        }
        if (this.doColoring == -1) {
            int i2;
            int cs = (int)Math.round(sirka2 * 12.0);
            for (i2 = 1; i2 <= this.natoms; ++i2) {
                if (this.abg[i2] <= 0 || this.abg[i2] >= 7) continue;
                g.setColor(this.jme.psColor[this.abg[i2]]);
                g.fillOval((int)(this.x[i2] - (double)cs / 2.0), (int)(this.y[i2] - (double)cs / 2.0), cs, cs);
            }
            for (i2 = 1; i2 <= this.nbonds; ++i2) {
                atom1 = this.va[i2];
                atom2 = this.vb[i2];
                if (this.abg[atom1] == 0 || this.abg[atom1] != this.abg[atom2]) continue;
                g.setColor(this.jme.psColor[this.abg[atom1]]);
                dx = this.x[atom2] - this.x[atom1];
                dy = this.y[atom2] - this.y[atom1];
                dd = Math.sqrt(dx * dx + dy * dy);
                if (dd < 1.0) {
                    dd = 1.0;
                }
                sina = dy / dd;
                cosa = dx / dd;
                sirka2s = sirka3 * 3.0 * sina;
                sirka2c = sirka3 * 3.0 * cosa;
                int[] xr = new int[4];
                int[] yr = new int[4];
                xr[0] = (int)(this.x[atom1] + sirka2s);
                yr[0] = (int)(this.y[atom1] - sirka2c);
                xr[1] = (int)(this.x[atom2] + sirka2s);
                yr[1] = (int)(this.y[atom2] - sirka2c);
                xr[2] = (int)(this.x[atom2] - sirka2s);
                yr[2] = (int)(this.y[atom2] + sirka2c);
                xr[3] = (int)(this.x[atom1] - sirka2s);
                yr[3] = (int)(this.y[atom1] + sirka2c);
                g.fillPolygon(xr, yr, 4);
            }
        }
        double[] neighborXSum = JMEUtil.createDArray(this.natoms + 1);
        int[] neighborCount = JMEUtil.createArray(this.natoms + 1);
        for (int i3 = 1; i3 <= this.nbonds; ++i3) {
            atom1 = this.va[i3];
            atom2 = this.vb[i3];
            int n = atom1;
            neighborXSum[n] = neighborXSum[n] + this.x[atom2];
            int n2 = atom2;
            neighborXSum[n2] = neighborXSum[n2] + this.x[atom1];
            int n3 = atom1;
            neighborCount[n3] = neighborCount[n3] + 1;
            int n4 = atom2;
            neighborCount[n4] = neighborCount[n4] + 1;
            g.setColor(Color.black);
            if (this.doColoring == 1 && this.abg[atom1] != 0 && this.abg[atom1] == this.abg[atom2]) {
                g.setColor(this.jme.psColor[this.abg[atom1]]);
            }
            if (this.stereob[i3] == 3 || this.stereob[i3] == 4) {
                int d = atom1;
                atom1 = atom2;
                atom2 = d;
            }
            double xa = this.x[atom1];
            double ya = this.y[atom1];
            double xb = this.x[atom2];
            double yb = this.y[atom2];
            if (this.nasv[i3] != 1 || this.stereob[i3] != 0) {
                dx = xb - xa;
                dy = yb - ya;
                dd = Math.sqrt(dx * dx + dy * dy);
                if (dd < 1.0) {
                    dd = 1.0;
                }
                sina = dy / dd;
                cosa = dx / dd;
            }
            switch (this.nasv[i3]) {
                case 2: {
                    if (this.stereob[i3] >= 10) {
                        g.setColor(Color.magenta);
                    }
                    sirka2s = sirka2 * sina;
                    sirka2c = sirka2 * cosa;
                    g.drawLine((int)Math.round(xa + sirka2s), (int)Math.round(ya - sirka2c), (int)Math.round(xb + sirka2s), (int)Math.round(yb - sirka2c));
                    g.drawLine((int)Math.round(xa - sirka2s), (int)Math.round(ya + sirka2c), (int)Math.round(xb - sirka2s), (int)Math.round(yb + sirka2c));
                    g.setColor(Color.black);
                    break;
                }
                case 3: {
                    int ixa = (int)Math.round(xa);
                    int iya = (int)Math.round(ya);
                    int ixb = (int)Math.round(xb);
                    int iyb = (int)Math.round(yb);
                    g.drawLine(ixa, iya, ixb, iyb);
                    int sirka3s = (int)Math.round(sirka3 * sina);
                    int sirka3c = (int)Math.round(sirka3 * cosa);
                    g.drawLine(ixa + sirka3s, iya - sirka3c, ixb + sirka3s, iyb - sirka3c);
                    g.drawLine(ixa - sirka3s, iya + sirka3c, ixb - sirka3s, iyb + sirka3c);
                    break;
                }
                case 0: 
                case 9: {
                    for (int k = 0; k < 10; ++k) {
                        double xax = xa - (xa - xb) / 10.0 * (double)k;
                        double yax = ya - (ya - yb) / 10.0 * (double)k;
                        g.drawLine((int)Math.round(xax), (int)Math.round(yax), (int)Math.round(xax), (int)Math.round(yax));
                    }
                    g.setFont(this.jme.font);
                    double h = JMEUtil.stringHeight(this.jme.fontMet);
                    String o = this.btag[i3];
                    String z = "?";
                    if (o != null) {
                        z = o;
                    }
                    int w = this.jme.fontMet.stringWidth(z);
                    int xstart = (int)Math.round((xa + xb) / 2.0 - (double)w / 2.0);
                    int ystart = (int)Math.round((ya + yb) / 2.0 + h / 2.0 - 1.0);
                    g.setColor(Color.magenta);
                    g.drawString(z, xstart, ystart);
                    g.setColor(Color.black);
                    break;
                }
                default: {
                    if (this.stereob[i3] == 1 || this.stereob[i3] == 3) {
                        sirka2s = sirka3 * sina;
                        sirka2c = sirka3 * cosa;
                        int[] px = new int[3];
                        int[] py = new int[3];
                        px[0] = (int)Math.round(xb + sirka2s);
                        py[0] = (int)Math.round(yb - sirka2c);
                        px[1] = (int)Math.round(xa);
                        py[1] = (int)Math.round(ya);
                        px[2] = (int)Math.round(xb - sirka2s);
                        py[2] = (int)Math.round(yb + sirka2c);
                        g.fillPolygon(px, py, 3);
                        break;
                    }
                    if (this.stereob[i3] == 2 || this.stereob[i3] == 4) {
                        sirka2s = sirka3 * sina;
                        sirka2c = sirka3 * cosa;
                        for (int k = 0; k < 10; ++k) {
                            double xax = xa - (xa - xb) / 10.0 * (double)k;
                            double yax = ya - (ya - yb) / 10.0 * (double)k;
                            double sc = (double)k / 10.0;
                            g.drawLine((int)Math.round(xax + sirka2s * sc), (int)Math.round(yax - sirka2c * sc), (int)Math.round(xax - sirka2s * sc), (int)Math.round(yax + sirka2c * sc));
                        }
                        break;
                    }
                    g.drawLine((int)Math.round(xa), (int)Math.round(ya), (int)Math.round(xb), (int)Math.round(yb));
                }
            }
            if (!this.jme.doTags || this.btag[i3] == null || this.btag[i3].length() <= 0) continue;
            g.setFont(this.jme.font);
            int h = this.jme.fontMet.getAscent();
            int w = this.jme.fontMet.stringWidth(this.btag[i3]);
            int xstart = (int)Math.round((xa + xb) / 2.0 - (double)w / 2.0);
            int ystart = (int)Math.round((ya + yb) / 2.0 + (double)(h / 2) - 1.0);
            g.setColor(Color.red);
            g.drawString(this.btag[i3], xstart, ystart);
            g.setColor(Color.black);
        }
        g.setFont(this.jme.font);
        int h = this.jme.fontMet.getAscent();
        AtomDisplayLabel[] al = new AtomDisplayLabel[this.natoms + 1];
        for (i = 1; i <= this.natoms; ++i) {
            int n = neighborCount[i];
            double diff = neighborXSum[i] / (double)neighborCount[i] - this.x[i];
            int alignment = n > 2 || n == 0 || n == 2 && Math.abs(diff) < 8.0 ? 1 : (n == 1 && Math.abs(diff) < 2.0 ? 0 : (diff < 0.0 ? 0 : 2));
            al[i] = new AtomDisplayLabel(this.x[i], this.y[i], this.getAtomLabel(i), this.an[i], this.nv[i], this.sumBondOrders(i), this.nh[i], this.q[i], 0, -1, alignment, this.jme.fontMet, h, this.jme.showHydrogens);
            if (al[i].noLabelAtom) continue;
            g.setColor(this.jme.canvasBg);
            if (this.doColoring == -1 && this.abg[i] != 0) {
                g.setColor(this.jme.psColor[this.abg[i]]);
            }
            al[i].fillRect(g);
            if (this.doColoring == 1) {
                if (this.abg[i] != 0) {
                    g.setColor(this.jme.psColor[this.abg[i]]);
                } else {
                    g.setColor(Color.black);
                }
            } else {
                g.setColor(JME.color[this.an[i]]);
            }
            if (this.jme.bwMode) {
                g.setColor(Color.black);
            }
            al[i].draw(g);
        }
        for (int k = 1; k <= this.nmarked; ++k) {
            int atom = this.mark[k][0];
            int w = this.jme.fontMet.stringWidth(al[atom].str);
            int xstart = (int)Math.round(this.x[atom] - (double)w / 2.0);
            int ystart = (int)Math.round(this.y[atom] + (double)(h / 2) - 1.0);
            g.setColor(Color.magenta);
            g.drawString(" " + this.mark[k][1], xstart + w, ystart);
        }
        if (this.jme.doTags) {
            for (i = 1; i <= this.natoms; ++i) {
                if (this.atag[i] == null || this.atag[i].equals("")) continue;
                int w = this.jme.fontMet.stringWidth(al[i].str);
                int xstart = (int)Math.round(this.x[i] - (double)w / 2.0);
                int ystart = (int)Math.round(this.y[i] + (double)(h / 2) - 1.0);
                g.setColor(Color.red);
                g.drawString(" " + this.atag[i], xstart + w, ystart);
            }
        }
        if (!(this.touchedAtom <= 0 && this.touchedBond <= 0 || this.jme.webme)) {
            g.setColor(this.jme.action == 104 ? Color.red : Color.blue);
            if (this.touchedAtom > 0 && this.jme.action != 106) {
                al[this.touchedAtom].drawRect(g);
            }
            if (this.touchedBond > 0) {
                atom2 = this.vb[this.touchedBond];
                atom1 = this.va[this.touchedBond];
                dx = this.x[atom2] - this.x[atom1];
                dy = this.y[atom2] - this.y[atom1];
                dd = Math.sqrt(dx * dx + dy * dy);
                if (dd < 1.0) {
                    dd = 1.0;
                }
                sina = dy / dd;
                cosa = dx / dd;
                sirka2s = (sirka3 + 1.0) * sina;
                sirka2c = (sirka3 + 1.0) * cosa;
                int[] px = new int[5];
                int[] py = new int[5];
                px[0] = (int)Math.round(this.x[atom1] + sirka2s);
                px[1] = (int)Math.round(this.x[atom2] + sirka2s);
                py[0] = (int)Math.round(this.y[atom1] - sirka2c);
                py[1] = (int)Math.round(this.y[atom2] - sirka2c);
                px[3] = (int)Math.round(this.x[atom1] - sirka2s);
                px[2] = (int)Math.round(this.x[atom2] - sirka2s);
                py[3] = (int)Math.round(this.y[atom1] + sirka2c);
                py[2] = (int)Math.round(this.y[atom2] + sirka2c);
                px[4] = px[0];
                py[4] = py[0];
                if (this.jme.action != 106) {
                    g.drawPolygon(px, py, 5);
                }
                if (this.jme.action == 106 && this.isRotatableBond(this.va[this.touchedBond], this.vb[this.touchedBond])) {
                    int i4;
                    int nsub = 0;
                    for (i4 = 1; i4 <= this.natoms; ++i4) {
                        if (this.a[i4] <= 0) continue;
                        ++nsub;
                    }
                    if (nsub > this.natoms / 2) {
                        for (i4 = 1; i4 <= this.natoms; ++i4) {
                            this.a[i4] = this.a[i4] > 0 ? 0 : 1;
                        }
                    }
                    g.setColor(Color.red);
                    for (i4 = 1; i4 <= this.natoms; ++i4) {
                        if (this.a[i4] <= 0) continue;
                        int w = this.jme.fontMet.stringWidth(al[i4].str);
                        g.drawRect((int)Math.round(this.x[i4] - (double)w / 2.0 - 1.0), (int)Math.round(this.y[i4] - (double)h / 2.0 - 1.0), w + 2, h + 2);
                    }
                }
            }
        }
        if (this.jme.webme) {
            int i5;
            this.jme.apointx = new int[this.natoms];
            this.jme.apointy = new int[this.natoms];
            this.jme.bpointx = new int[this.nbonds];
            this.jme.bpointy = new int[this.nbonds];
            for (i5 = 1; i5 <= this.natoms; ++i5) {
                this.jme.apointx[i5 - 1] = (int)Math.round(this.x[i5]);
                this.jme.apointy[i5 - 1] = (int)Math.round(this.y[i5]);
            }
            for (i5 = 1; i5 <= this.nbonds; ++i5) {
                this.jme.bpointx[i5 - 1] = (int)Math.round((this.x[this.va[i5]] + this.x[this.vb[i5]]) / 2.0);
                this.jme.bpointy[i5 - 1] = (int)Math.round((this.y[this.va[i5]] + this.y[this.vb[i5]]) / 2.0);
            }
        }
    }

    void move(int movex, int movey) {
        int i = 1;
        while (i <= this.natoms) {
            int n = i;
            this.x[n] = this.x[n] + (double)movex;
            int n2 = i++;
            this.y[n2] = this.y[n2] + (double)movey;
        }
        double[] center = new double[4];
        this.centerPoint(center);
        double centerx = center[0];
        double centery = center[1];
        if (centerx > 0.0 && centerx < (double)(this.jme.dimension.width - this.jme.sd) && centery > 0.0 && centery < (double)(this.jme.dimension.height - this.jme.sd * 3)) {
            return;
        }
        int i2 = 1;
        while (i2 <= this.natoms) {
            int n = i2;
            this.x[n] = this.x[n] - (double)movex;
            int n3 = i2++;
            this.y[n3] = this.y[n3] - (double)movey;
        }
    }

    void rotate(int movex) {
        int i;
        double[] center = new double[4];
        this.centerPoint(center);
        double centerx = center[0];
        double centery = center[1];
        double sinu = Math.sin((double)movex * Math.PI / 180.0);
        double cosu = Math.cos((double)movex * Math.PI / 180.0);
        for (i = 1; i <= this.natoms; ++i) {
            double xx = this.x[i] * cosu + this.y[i] * sinu;
            double yy = -this.x[i] * sinu + this.y[i] * cosu;
            this.x[i] = xx;
            this.y[i] = yy;
        }
        this.centerPoint(center);
        i = 1;
        while (i <= this.natoms) {
            int n = i;
            this.x[n] = this.x[n] + (centerx - center[0]);
            int n2 = i++;
            this.y[n2] = this.y[n2] + (centery - center[1]);
        }
    }

    void centerPoint(double[] center) {
        this.getMinMax();
        center[0] = this.minx + (this.maxx - this.minx) / 2.0;
        center[1] = this.miny + (this.maxy - this.miny) / 2.0;
        center[2] = this.maxx - this.minx;
        center[3] = this.maxy - this.miny;
        if (center[2] < 25.0) {
            center[2] = 25.0;
        }
        if (center[3] < 25.0) {
            center[3] = 25.0;
        }
    }

    protected void getMinMax() {
        this.miny = Double.MAX_VALUE;
        this.minx = Double.MAX_VALUE;
        this.maxy = -1.7976931348623157E308;
        this.maxx = -1.7976931348623157E308;
        for (int i = 1; i <= this.natoms; ++i) {
            if (this.x[i] < this.minx) {
                this.minx = this.x[i];
            }
            if (this.x[i] > this.maxx) {
                this.maxx = this.x[i];
            }
            if (this.y[i] < this.miny) {
                this.miny = this.y[i];
            }
            if (!(this.y[i] > this.maxy)) continue;
            this.maxy = this.y[i];
        }
    }

    public Dimension shiftToXY(double marginPixelsX, double marginPixelsY) {
        if (this.natoms == 0) {
            return new Dimension();
        }
        this.getMinMax();
        marginPixelsX /= this.jme.depictScale;
        marginPixelsY /= this.jme.depictScale;
        this.needRecentering = false;
        for (int i = 1; i <= this.natoms; ++i) {
            this.x[i] = this.x[i] - this.minx + marginPixelsX;
            this.y[i] = this.y[i] - this.miny + marginPixelsY;
        }
        return new Dimension((int)((marginPixelsX * 2.0 + (this.maxx - this.minx)) * this.jme.depictScale), (int)((marginPixelsY * 2.0 + (this.maxy - this.miny)) * this.jme.depictScale));
    }

    void rubberBanding(int xnew, int ynew) {
        this.touchedAtom = 0;
        this.x[0] = xnew;
        this.y[0] = ynew;
        int atom = this.checkTouch(0);
        if (atom > 0 && this.jme.action != 205) {
            this.touchedAtom = atom;
            if (atom != this.touched_org) {
                this.x[this.natoms] = this.x[atom];
                this.y[this.natoms] = this.y[atom];
            } else {
                this.x[this.natoms] = this.xorg;
                this.y[this.natoms] = this.yorg;
            }
        } else if (this.jme.action == 205) {
            this.touchedBond = 0;
            int last = this.chain[this.nchain];
            int parent = this.chain[this.nchain - 1];
            double dx = this.x[last] - this.x[parent];
            double dy = this.y[last] - this.y[parent];
            double rx = Math.sqrt(dx * dx + dy * dy);
            if (rx < 1.0) {
                rx = 1.0;
            }
            double sina = dy / rx;
            double cosa = dx / rx;
            double vv = rx / 2.0 / Math.tan(0.5235987755982988);
            double xx = (double)xnew - this.x[parent];
            double yy = (double)ynew - this.y[parent];
            double xm = -rx / 2.0 + xx * cosa + yy * sina;
            double ym = yy * cosa - xx * sina;
            if (xm < 0.0) {
                if (this.nchain > 1) {
                    this.deleteAtom(this.natoms);
                    --this.nchain;
                    this.stopChain = false;
                } else if (this.natoms == 2) {
                    if (this.y[2] - this.y[1] < 0.0 && (double)ynew - this.y[1] > 0.0) {
                        this.y[2] = this.y[1] + rx / 2.0;
                    } else if (this.y[2] - this.y[1] > 0.0 && (double)ynew - this.y[1] < 0.0) {
                        this.y[2] = this.y[1] - rx / 2.0;
                    }
                    if (this.x[2] - this.x[1] < 0.0 && (double)xnew - this.x[1] > 0.0) {
                        this.x[2] = this.x[1] + rx * 0.866;
                    } else if (this.x[2] - this.x[1] > 0.0 && (double)xnew - this.x[1] < 0.0) {
                        this.x[2] = this.x[1] - rx * 0.866;
                    }
                } else if (this.nv[this.chain[0]] == 2) {
                    int ref = this.v[this.chain[0]][1];
                    if (ref == this.chain[1]) {
                        ref = this.v[this.chain[0]][2];
                    }
                    if ((rx = Math.sqrt((dx = this.x[this.chain[0]] - this.x[ref]) * dx + (dy = this.y[this.chain[0]] - this.y[ref]) * dy)) < 1.0) {
                        rx = 1.0;
                    }
                    sina = dy / rx;
                    cosa = dx / rx;
                    xx = (double)xnew - this.x[ref];
                    yy = (double)ynew - this.y[ref];
                    double ymm = yy * cosa - xx * sina;
                    xx = this.x[this.chain[1]] - this.x[ref];
                    yy = this.y[this.chain[1]] - this.y[ref];
                    double yc1 = yy * cosa - xx * sina;
                    if (ymm > 0.0 && yc1 < 0.0 || ymm < 0.0 && yc1 > 0.0) {
                        int bd = this.nbonds;
                        this.touchedAtom = this.chain[0];
                        this.addBond();
                        this.deleteBond(bd);
                        if (this.checkTouch(this.natoms) > 0) {
                            this.stopChain = true;
                        }
                    }
                }
            } else {
                if (this.stopChain) {
                    return;
                }
                double th = -1.0;
                if (xm < rx * 1.5) {
                    th = (rx * 1.5 - xm) * vv / (rx * 1.5);
                }
                if (Math.abs(ym) > th) {
                    ++this.nchain;
                    if (this.nchain > 100) {
                        this.jme.info("You are too focused on chains, enough of it for now !");
                        --this.nchain;
                        return;
                    }
                    this.touchedAtom = this.natoms;
                    this.addBond((int)Math.round(ym));
                    this.chain[this.nchain] = this.natoms;
                    if (this.checkTouch(this.natoms) > 0) {
                        this.stopChain = true;
                    }
                }
            }
            this.touchedAtom = 0;
            int n = this.nchain;
            this.jme.info(n + "");
        } else {
            double dx = (double)xnew - this.x[this.touched_org];
            double dy = (double)ynew - this.y[this.touched_org];
            double rx = Math.sqrt(dx * dx + dy * dy);
            if (rx < 1.0) {
                rx = 1.0;
            }
            double sina = dy / rx;
            double cosa = dx / rx;
            this.x[this.natoms] = this.x[this.touched_org] + 25.0 * cosa;
            this.y[this.natoms] = this.y[this.touched_org] + 25.0 * sina;
        }
    }

    void checkChain() {
        if (this.stopChain) {
            int n = this.checkTouch(this.natoms);
            if (this.nv[n] < 6) {
                this.createBond();
                int parent = this.chain[this.nchain - 1];
                this.va[this.nbonds] = n;
                this.vb[this.nbonds] = parent;
                int n2 = n;
                int n3 = this.nv[n2] + 1;
                this.nv[n2] = n3;
                this.v[n][n3] = parent;
                int n4 = parent;
                int n5 = this.nv[n4] + 1;
                this.nv[n4] = n5;
                this.v[parent][n5] = n;
            }
            this.deleteAtom(this.natoms);
        }
        this.stopChain = false;
    }

    private int checkTouch(int atom) {
        double min = 51.0;
        int touch = 0;
        for (int i = 1; i < this.natoms; ++i) {
            double dy;
            double dx;
            double rx;
            if (atom == i || !((rx = (dx = this.x[atom] - this.x[i]) * dx + (dy = this.y[atom] - this.y[i]) * dy) < 50.0) || !(rx < min)) continue;
            min = rx;
            touch = i;
        }
        return touch;
    }

    void avoidTouch(int from) {
        if (from == 0) {
            from = this.natoms;
        }
        for (int i = this.natoms; i > this.natoms - from; --i) {
            int n = this.checkTouch(i);
            if (n == 0) continue;
            int n2 = i;
            this.x[n2] = this.x[n2] + 6.0;
            int n3 = i;
            this.y[n3] = this.y[n3] + 6.0;
        }
    }

    void deleteAtom(int delatom) {
        int atom1;
        int i;
        int j = 0;
        for (i = 1; i <= this.nbonds; ++i) {
            atom1 = this.va[i];
            int atom2 = this.vb[i];
            if (atom1 == delatom || atom2 == delatom) continue;
            this.va[++j] = atom1;
            if (atom1 > delatom) {
                int n = j;
                this.va[n] = this.va[n] - 1;
            }
            this.vb[j] = atom2;
            if (atom2 > delatom) {
                int n = j;
                this.vb[n] = this.vb[n] - 1;
            }
            this.nasv[j] = this.nasv[i];
            this.stereob[j] = this.stereob[i];
            this.xb[j] = this.xb[i];
            this.yb[j] = this.yb[i];
            this.btag[j] = this.btag[i];
        }
        this.nbonds = j;
        for (i = delatom; i < this.natoms; ++i) {
            this.an[i] = this.an[i + 1];
            this.q[i] = this.q[i + 1];
            this.x[i] = this.x[i + 1];
            this.y[i] = this.y[i + 1];
            this.nh[i] = this.nh[i + 1];
            this.abg[i] = this.abg[i + 1];
            this.atag[i] = this.atag[i + 1];
            this.nv[i] = this.nv[i + 1];
            this.label[i] = this.label[i + 1];
            for (j = 1; j <= this.nv[i]; ++j) {
                this.v[i][j] = this.v[i + 1][j];
            }
        }
        --this.natoms;
        if (this.natoms == 0) {
            this.jme.clear();
            return;
        }
        for (i = 1; i <= this.natoms; ++i) {
            int k = 0;
            for (j = 1; j <= this.nv[i]; ++j) {
                atom1 = this.v[i][j];
                if (atom1 == delatom) {
                    int n = i;
                    this.nh[n] = this.nh[n] + 1;
                    continue;
                }
                if (atom1 > delatom) {
                    // empty if block
                }
                this.v[i][++k] = --atom1;
            }
            this.nv[i] = k;
        }
        for (i = 1; i <= this.nmarked; ++i) {
            if (this.mark[i][0] != delatom) continue;
            for (j = i; j < this.nmarked; ++j) {
                this.mark[j][0] = this.mark[j + 1][0];
                this.mark[j][1] = this.mark[j + 1][1];
            }
            --this.nmarked;
            break;
        }
        for (i = 1; i <= this.nmarked; ++i) {
            if (this.mark[i][0] <= delatom) continue;
            int[] nArray = this.mark[i];
            nArray[0] = nArray[0] - 1;
        }
    }

    void deleteBond(int delbond) {
        int i;
        int atom1 = this.va[delbond];
        int atom2 = this.vb[delbond];
        for (i = delbond; i < this.nbonds; ++i) {
            this.va[i] = this.va[i + 1];
            this.vb[i] = this.vb[i + 1];
            this.nasv[i] = this.nasv[i + 1];
            this.stereob[i] = this.stereob[i + 1];
            this.xb[i] = this.xb[i + 1];
            this.yb[i] = this.yb[i + 1];
            this.btag[i] = this.btag[i + 1];
        }
        --this.nbonds;
        int k = 0;
        for (i = 1; i <= this.nv[atom1]; ++i) {
            if (this.v[atom1][i] == atom2) continue;
            this.v[atom1][++k] = this.v[atom1][i];
        }
        this.nv[atom1] = k;
        k = 0;
        for (i = 1; i <= this.nv[atom2]; ++i) {
            if (this.v[atom2][i] == atom1) continue;
            this.v[atom2][++k] = this.v[atom2][i];
        }
        this.nv[atom2] = k;
        if (atom1 < atom2) {
            k = atom1;
            atom1 = atom2;
            atom2 = k;
        }
        if (this.nv[atom1] == 0) {
            this.deleteAtom(atom1);
        }
        if (this.nv[atom2] == 0) {
            this.deleteAtom(atom2);
        }
    }

    void deleteGroup(int bond) {
        int i;
        if (this.jme.webme) {
            if (!this.isRotatableBond(this.va[this.touchedBond], this.vb[this.touchedBond])) {
                return;
            }
            int nsub = 0;
            for (i = 1; i <= this.natoms; ++i) {
                if (this.a[i] <= 0) continue;
                ++nsub;
            }
            if (nsub > this.natoms / 2) {
                for (i = 1; i <= this.natoms; ++i) {
                    this.a[i] = this.a[i] > 0 ? 0 : 1;
                }
            }
        }
        if (this.a[this.va[bond]] > 0 && this.a[this.vb[bond]] > 0) {
            this.jme.info("Removal of substituent not possible.");
            return;
        }
        while (true) {
            int atd = 0;
            for (i = this.natoms; i >= 1; --i) {
                if (this.a[i] <= 0 || i <= atd) continue;
                atd = i;
            }
            if (atd == 0) break;
            this.deleteAtom(atd);
            this.a[atd] = 0;
        }
    }

    void backCations(int atom) {
        for (int i = 1; i <= this.nv[atom]; ++i) {
            int j = this.v[atom][i];
            if (this.q[j] <= 0) continue;
            int n = j;
            this.q[n] = this.q[n] - 1;
        }
    }

    void backCations(int atom1, int atom2) {
        if (this.q[atom1] > 0) {
            int n = atom1;
            this.q[n] = this.q[n] - 1;
        }
        if (this.q[atom2] > 0) {
            int n = atom2;
            this.q[n] = this.q[n] - 1;
        }
    }

    void flipGroup(int atom) {
        if (this.nv[atom] < 2) {
            return;
        }
    }

    void stereoBond(int bond) {
        if (this.nasv[bond] == 1) {
            int atom1 = this.va[bond];
            int atom2 = this.vb[bond];
            if (this.nv[atom1] < 2 && this.nv[atom2] < 2) {
                this.stereob[bond] = 0;
                this.jme.info("Stereomarking meaningless on this bond !");
                return;
            }
            if (this.jme.webme) {
                this.stereob[bond] = !this.jme.revertStereo ? (this.stereob[bond] == 1 ? 3 : (this.stereob[bond] == 3 ? 1 : (this.nv[atom2] <= this.nv[atom1] ? 1 : 3))) : (this.stereob[bond] == 2 ? 4 : (this.stereob[bond] == 4 ? 2 : (this.nv[atom2] <= this.nv[atom1] ? 2 : 4)));
            } else {
                switch (this.stereob[bond]) {
                    case 0: {
                        if (this.nv[atom2] <= this.nv[atom1]) {
                            this.stereob[bond] = 1;
                            break;
                        }
                        this.stereob[bond] = 3;
                        break;
                    }
                    case 1: {
                        this.stereob[bond] = 2;
                        break;
                    }
                    case 2: {
                        if (this.nv[atom2] > 2) {
                            this.stereob[bond] = 3;
                            break;
                        }
                        this.stereob[bond] = 1;
                        break;
                    }
                    case 3: {
                        this.stereob[bond] = 4;
                        break;
                    }
                    case 4: {
                        this.stereob[bond] = this.nv[atom1] > 2 ? 1 : 3;
                    }
                }
            }
        } else if (this.nasv[bond] == 2) {
            this.stereob[bond] = this.stereob[bond] == 10 ? 0 : 10;
        } else {
            this.jme.info("Stereomarking allowed only on single and double bonds!");
        }
    }

    int getStereoAtom(int bond) {
        switch (this.stereob[bond]) {
            case 1: 
            case 2: {
                return this.va[bond];
            }
            case 3: 
            case 4: {
                return this.vb[bond];
            }
        }
        return 0;
    }

    void addBond() {
        this.addBond(0);
    }

    void addBond(int up) {
        this.createAtom();
        block0 : switch (this.nv[this.touchedAtom]) {
            case 0: {
                this.x[this.natoms] = this.x[this.touchedAtom] + this.rbond() * 0.866;
                this.y[this.natoms] = this.y[this.touchedAtom] + this.rbond() * 0.5;
                break;
            }
            case 1: {
                double dy;
                double dx;
                double rx;
                int atom1 = this.v[this.touchedAtom][1];
                int atom3 = 0;
                if (this.nv[atom1] == 2) {
                    atom3 = this.v[atom1][1] == this.touchedAtom ? this.v[atom1][2] : this.v[atom1][1];
                }
                if ((rx = Math.sqrt((dx = this.x[this.touchedAtom] - this.x[atom1]) * dx + (dy = this.y[this.touchedAtom] - this.y[atom1]) * dy)) < 0.001) {
                    rx = 0.001;
                }
                double sina = dy / rx;
                double cosa = dx / rx;
                double xx = rx + this.rbond() * Math.cos(1.0471975511965976);
                double yy = this.rbond() * Math.sin(1.0471975511965976);
                int i = this.bondIdentity(this.touchedAtom, atom1);
                if (this.nasv[i] == 3 || this.jme.action == 204 || !this.isSingle(i) && (this.jme.action == 203 || this.jme.action == 204) || this.linearAdding) {
                    xx = rx + this.rbond();
                    yy = 0.0;
                }
                if (atom3 > 0 && (this.y[atom3] - this.y[atom1]) * cosa - (this.x[atom3] - this.x[atom1]) * sina > 0.0) {
                    yy = -yy;
                }
                if (up > 0 && yy < 0.0) {
                    yy = -yy;
                } else if (up < 0 && yy > 0.0) {
                    yy = -yy;
                }
                this.x[this.natoms] = this.x[atom1] + xx * cosa - yy * sina;
                this.y[this.natoms] = this.y[atom1] + yy * cosa + xx * sina;
                break;
            }
            case 2: {
                double[] newPoint = new double[2];
                this.addPoint(this.touchedAtom, this.rbond(), newPoint);
                this.x[this.natoms] = newPoint[0];
                this.y[this.natoms] = newPoint[1];
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                for (int i = 1; i <= this.nv[this.touchedAtom]; ++i) {
                    int atom1 = this.v[this.touchedAtom][i];
                    double dx = this.x[this.touchedAtom] - this.x[atom1];
                    double dy = this.y[this.touchedAtom] - this.y[atom1];
                    double rx = Math.sqrt(dx * dx + dy * dy);
                    if (rx < 0.001) {
                        rx = 0.001;
                    }
                    this.x[this.natoms] = this.x[this.touchedAtom] + this.rbond() * dx / rx;
                    this.y[this.natoms] = this.y[this.touchedAtom] + this.rbond() * dy / rx;
                    if (this.checkTouch(this.natoms) == 0 || i == this.nv[this.touchedAtom]) break block0;
                }
                break;
            }
            default: {
                --this.natoms;
                this.jme.info("Are you trying to draw an hedgehog ?");
                this.jme.lastAction = 9;
                return;
            }
        }
        this.completeBond();
        this.xorg = this.x[this.natoms];
        this.yorg = this.y[this.natoms];
    }

    double rbond() {
        return 25.0 * this.jme.depictScale;
    }

    void completeBond() {
        this.nv[this.natoms] = 1;
        int n = this.touchedAtom;
        this.nv[n] = this.nv[n] + 1;
        this.createBond();
        this.nasv[this.nbonds] = 1;
        if (this.jme.action == 203) {
            this.nasv[this.nbonds] = 2;
        }
        if (this.jme.action == 204) {
            this.nasv[this.nbonds] = 3;
        }
        this.va[this.nbonds] = this.touchedAtom;
        this.vb[this.nbonds] = this.natoms;
        if (this.jme.action == 201) {
            this.stereoBond(this.nbonds);
        }
        this.v[this.natoms][1] = this.touchedAtom;
        this.v[this.touchedAtom][this.nv[this.touchedAtom]] = this.natoms;
        this.xb[this.nbonds] = (int)Math.round((this.x[this.touchedAtom] + this.x[this.natoms]) / 2.0);
        this.yb[this.nbonds] = (int)Math.round((this.y[this.touchedAtom] + this.y[this.natoms]) / 2.0);
    }

    void checkBond() {
        int atom = this.checkTouch(this.natoms);
        if (atom == 0) {
            return;
        }
        --this.natoms;
        for (int i = 1; i < this.nbonds; ++i) {
            int atom1 = this.va[i];
            int atom2 = this.vb[i];
            if ((atom1 != atom || atom2 != this.touched_org) && (atom1 != this.touched_org || atom2 != atom)) continue;
            --this.nbonds;
            int n = this.touched_org;
            this.nv[n] = this.nv[n] - 1;
            if (this.nasv[i] < 3) {
                int n2 = i;
                this.nasv[n2] = this.nasv[n2] + 1;
                this.stereob[i] = 0;
            } else {
                this.jme.info("Maximum allowed bond order is 3 !");
            }
            return;
        }
        if (this.nv[atom] == 6) {
            --this.nbonds;
            int n = this.touched_org;
            this.nv[n] = this.nv[n] - 1;
            this.jme.info("Not possible connection !");
            return;
        }
        this.vb[this.nbonds] = atom;
        int n = atom;
        int n3 = this.nv[n] + 1;
        this.nv[n] = n3;
        this.v[atom][n3] = this.touched_org;
        this.v[this.touched_org][this.nv[this.touched_org]] = atom;
        this.xb[this.nbonds] = (int)Math.round((this.x[this.touched_org] + this.x[atom]) / 2.0);
        this.yb[this.nbonds] = (int)Math.round((this.y[this.touched_org] + this.y[atom]) / 2.0);
    }

    void addGroup(boolean emptyCanvas) {
        this.touched_org = this.touchedAtom;
        int nadded = 0;
        if (this.jme.action == 233 || this.jme.action == 237 || this.jme.action == 236 || this.jme.action == 239 || this.jme.action == 251 || this.jme.action == 252) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.linearAdding = true;
            this.addBond();
            this.linearAdding = false;
            this.touchedAtom = this.natoms - 1;
            this.addBond();
            this.touchedAtom = this.natoms - 2;
            this.addBond();
            if (this.jme.action == 237) {
                this.an[this.natoms] = 10;
                this.an[this.natoms - 1] = 10;
                this.an[this.natoms - 2] = 10;
            }
            if (this.jme.action == 236) {
                this.an[this.natoms] = 9;
                this.an[this.natoms - 1] = 9;
                this.an[this.natoms - 2] = 9;
            }
            if (this.jme.action == 239) {
                this.an[this.natoms] = 5;
                this.an[this.natoms - 1] = 5;
                this.an[this.natoms - 2] = 5;
                this.an[this.natoms - 3] = 8;
                this.nasv[this.nbonds] = 2;
                this.nasv[this.nbonds - 1] = 2;
            }
            if (this.jme.action == 252) {
                this.an[this.natoms] = 5;
                this.an[this.natoms - 1] = 5;
                this.an[this.natoms - 2] = 4;
                this.an[this.natoms - 3] = 8;
                this.nasv[this.nbonds] = 2;
                this.nasv[this.nbonds - 1] = 2;
            }
            if (this.jme.action == 251) {
                this.an[this.natoms] = 5;
                this.an[this.natoms - 1] = 5;
                this.an[this.natoms - 2] = 5;
                this.an[this.natoms - 3] = 7;
                this.nasv[this.nbonds] = 2;
            }
            nadded = 4;
        } else if (this.jme.action == 244) {
            this.addBond();
            this.an[this.natoms] = 4;
            this.touchedAtom = this.natoms;
            this.addBond();
            this.an[this.natoms] = 8;
            this.touchedAtom = this.natoms;
            this.linearAdding = true;
            this.addBond();
            this.linearAdding = false;
            this.touchedAtom = this.natoms - 1;
            this.addBond();
            this.an[this.natoms] = 5;
            this.nasv[this.nbonds] = 2;
            this.touchedAtom = this.natoms - 2;
            this.addBond();
            this.an[this.natoms] = 5;
            this.nasv[this.nbonds] = 2;
            nadded = 5;
        } else if (this.jme.action == 234) {
            this.addBond();
            this.an[this.natoms] = 4;
            this.touchedAtom = this.natoms;
            this.addBond();
            this.an[this.natoms] = 5;
            this.nasv[this.nbonds] = 2;
            this.touchedAtom = this.natoms - 1;
            this.addBond();
            this.an[this.natoms] = 5;
            this.nasv[this.nbonds] = 2;
            nadded = 3;
        } else if (this.jme.action == 235) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.an[this.natoms] = 5;
            this.touchedAtom = this.natoms - 1;
            this.addBond();
            this.an[this.natoms] = 5;
            this.nasv[this.nbonds] = 2;
            nadded = 3;
        } else if (this.jme.action == 240) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.an[this.natoms] = 5;
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms - 2;
            this.addBond();
            this.an[this.natoms] = 5;
            this.nasv[this.nbonds] = 2;
            nadded = 4;
        } else if (this.jme.action == 241) {
            this.addBond();
            this.an[this.natoms] = 5;
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms - 1;
            this.addBond();
            this.nasv[this.nbonds] = 2;
            this.an[this.natoms] = 5;
            nadded = 4;
        } else if (this.jme.action == 243) {
            this.addBond();
            this.an[this.natoms] = 4;
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms - 1;
            this.addBond();
            nadded = 3;
        } else if (this.jme.action == 238) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.linearAdding = true;
            this.addBond();
            this.nasv[this.nbonds] = 3;
            this.linearAdding = false;
            nadded = 2;
        } else if (this.jme.action == 249) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.nasv[this.nbonds] = 2;
            this.an[this.natoms] = 5;
            nadded = 2;
        } else if (this.jme.action == 250) {
            this.addBond();
            this.nasv[this.nbonds] = 2;
            this.an[this.natoms] = 5;
            nadded = 1;
        } else if (this.jme.action == 245) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.linearAdding = true;
            this.addBond();
            this.touchedAtom = this.natoms;
            this.nasv[this.nbonds] = 3;
            this.addBond();
            this.linearAdding = false;
            nadded = 3;
        } else if (this.jme.action == 242) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.linearAdding = true;
            this.addBond();
            this.nasv[this.nbonds] = 3;
            this.an[this.natoms] = 4;
            this.linearAdding = false;
            nadded = 2;
        } else if (this.jme.action == 254) {
            this.addBond();
            this.an[this.natoms] = 9;
            nadded = 1;
        } else if (this.jme.action == 255) {
            this.addBond();
            this.an[this.natoms] = 10;
            nadded = 1;
        } else if (this.jme.action == 256) {
            this.addBond();
            this.an[this.natoms] = 11;
            nadded = 1;
        } else if (this.jme.action == 257) {
            this.addBond();
            this.an[this.natoms] = 12;
            nadded = 1;
        } else if (this.jme.action == 258) {
            this.addBond();
            this.an[this.natoms] = 4;
            nadded = 1;
        } else if (this.jme.action == 259) {
            this.addBond();
            this.an[this.natoms] = 5;
            nadded = 1;
        } else if (this.jme.action == 246) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            nadded = 2;
        } else if (this.jme.action == 247) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            nadded = 3;
        } else if (this.jme.action == 248) {
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            this.touchedAtom = this.natoms;
            this.addBond();
            nadded = 4;
        } else if (this.jme.action == 253) {
            this.addGroupTemplate(emptyCanvas);
            nadded = 4;
        }
        this.avoidTouch(nadded);
        this.touchedAtom = this.touched_org;
        if (emptyCanvas) {
            this.touchedAtom = 0;
        }
    }

    void addRing() {
        int returnTouch = -1;
        int nmembered = 6;
        switch (this.jme.action) {
            case 206: {
                nmembered = 3;
                break;
            }
            case 207: {
                nmembered = 4;
                break;
            }
            case 208: 
            case 221: 
            case 223: {
                nmembered = 5;
                break;
            }
            case 209: 
            case 210: {
                nmembered = 6;
                break;
            }
            case 211: {
                nmembered = 7;
                break;
            }
            case 212: {
                nmembered = 8;
                break;
            }
            case 229: {
                nmembered = 9;
            }
        }
        double diel = Math.PI * 2 / (double)nmembered;
        double rc = Math.sqrt(this.rbond() * this.rbond() / 2.0 / (1.0 - Math.cos(diel)));
        if (this.touchedAtom > 0) {
            if (this.nv[this.touchedAtom] < 2) {
                this.addRingToBond(nmembered, diel, rc);
            } else if (!this.jme.mouseShift) {
                returnTouch = this.touchedAtom;
                this.addBond();
                this.touchedAtom = this.natoms;
                this.addRingToBond(nmembered, diel, rc);
            } else {
                if (this.jme.action == 209 || this.jme.action == 221 || this.jme.action == 223) {
                    this.jme.info("ERROR - cannot add aromatic spiro ring !");
                    this.jme.lastAction = 9;
                    return;
                }
                for (int i = 1; i <= this.nv[this.touchedAtom]; ++i) {
                    int bo = this.nasv[this.bondIdentity(this.touchedAtom, this.v[this.touchedAtom][i])];
                    if (i <= 2 && bo == 1) continue;
                    this.jme.info("ERROR - spiro ring not possible here !");
                    this.jme.lastAction = 9;
                    return;
                }
                double[] newPoint = new double[2];
                this.addPoint(this.touchedAtom, rc, newPoint);
                double dx = this.x[this.touchedAtom] - newPoint[0];
                double dy = this.y[this.touchedAtom] - newPoint[1];
                double rx = Math.sqrt(dx * dx + dy * dy);
                if (rx < 0.001) {
                    rx = 0.001;
                }
                double sina = dy / rx;
                double cosa = dx / rx;
                for (int i = 1; i <= nmembered; ++i) {
                    this.createAtom();
                    double uhol = diel * (double)i + 1.5707963267948966;
                    this.x[this.natoms] = newPoint[0] + rc * (Math.sin(uhol) * cosa - Math.cos(uhol) * sina);
                    this.y[this.natoms] = newPoint[1] + rc * (Math.cos(uhol) * cosa + Math.sin(uhol) * sina);
                }
            }
        } else if (this.touchedBond > 0) {
            double dy;
            double dx;
            double rx;
            int revert;
            int atom1 = this.va[this.touchedBond];
            int atom2 = this.vb[this.touchedBond];
            int atom3 = 0;
            if (this.nv[atom1] == 2) {
                atom3 = this.v[atom1][1] != atom2 ? this.v[atom1][1] : this.v[atom1][2];
            } else if (this.nv[atom2] == 2) {
                atom3 = this.v[atom2][1] != atom1 ? this.v[atom2][1] : this.v[atom2][2];
                revert = atom1;
                atom1 = atom2;
                atom2 = revert;
            }
            if (atom3 == 0) {
                atom3 = this.v[atom1][1] != atom2 ? this.v[atom1][1] : this.v[atom1][2];
            }
            if ((rx = Math.sqrt((dx = this.x[atom2] - this.x[atom1]) * dx + (dy = this.y[atom2] - this.y[atom1]) * dy)) < 0.001) {
                rx = 0.001;
            }
            double sina = dy / rx;
            double cosa = dx / rx;
            double xx = rx / 2.0;
            double yy = rc * Math.sin((Math.PI - diel) * 0.5);
            revert = 1;
            if ((this.y[atom3] - this.y[atom1]) * cosa - (this.x[atom3] - this.x[atom1]) * sina > 0.0) {
                yy = -yy;
                revert = 0;
            }
            double xstart = this.x[atom1] + xx * cosa - yy * sina;
            double ystart = this.y[atom1] + yy * cosa + xx * sina;
            for (int i = 1; i <= nmembered; ++i) {
                this.createAtom();
                double uhol = diel * ((double)i + 0.5) + Math.PI * (double)revert;
                this.x[this.natoms] = xstart + rc * (Math.sin(uhol) * cosa - Math.cos(uhol) * sina);
                this.y[this.natoms] = ystart + rc * (Math.cos(uhol) * cosa + Math.sin(uhol) * sina);
                if (revert == 1) {
                    if (i == nmembered) {
                        this.x[this.natoms] = this.x[atom1];
                        this.y[this.natoms] = this.y[atom1];
                    }
                    if (i != nmembered - 1) continue;
                    this.x[this.natoms] = this.x[atom2];
                    this.y[this.natoms] = this.y[atom2];
                    continue;
                }
                if (i == nmembered - 1) {
                    this.x[this.natoms] = this.x[atom1];
                    this.y[this.natoms] = this.y[atom1];
                }
                if (i != nmembered) continue;
                this.x[this.natoms] = this.x[atom2];
                this.y[this.natoms] = this.y[atom2];
            }
        } else {
            double helpv = 0.5;
            if (nmembered == 6) {
                helpv = 0.0;
            }
            for (int i = 1; i <= nmembered; ++i) {
                this.createAtom();
                double uhol = diel * ((double)i - helpv);
                this.x[this.natoms] = this.xorg + rc * Math.sin(uhol);
                this.y[this.natoms] = this.yorg + rc * Math.cos(uhol);
            }
        }
        this.completeRing(nmembered);
        this.checkRing(nmembered);
        if (returnTouch > -1) {
            this.touchedAtom = returnTouch;
        }
    }

    void addRingToBond(int nmembered, double diel, double rc) {
        double cosa;
        double sina;
        int atom1 = 0;
        if (this.nv[this.touchedAtom] == 0) {
            sina = 0.0;
            cosa = 1.0;
        } else {
            atom1 = this.v[this.touchedAtom][1];
            double dx = this.x[this.touchedAtom] - this.x[atom1];
            double dy = this.y[this.touchedAtom] - this.y[atom1];
            double rx = Math.sqrt(dx * dx + dy * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            sina = dy / rx;
            cosa = dx / rx;
        }
        double xstart = this.x[this.touchedAtom] + rc * cosa;
        double ystart = this.y[this.touchedAtom] + rc * sina;
        for (int i = 1; i <= nmembered; ++i) {
            this.createAtom();
            double uhol = diel * (double)i - 1.5707963267948966;
            this.x[this.natoms] = xstart + rc * (Math.sin(uhol) * cosa - Math.cos(uhol) * sina);
            this.y[this.natoms] = ystart + rc * (Math.cos(uhol) * cosa + Math.sin(uhol) * sina);
        }
    }

    void completeRing(int nmembered) {
        int i;
        int atom = 0;
        for (i = 1; i <= nmembered; ++i) {
            this.createBond();
            this.nasv[this.nbonds] = 1;
            atom = this.natoms - nmembered + i;
            this.nv[atom] = 2;
            this.va[this.nbonds] = atom;
            this.vb[this.nbonds] = atom + 1;
        }
        this.vb[this.nbonds] = this.natoms - nmembered + 1;
        if (this.jme.action == 209) {
            this.nasv[this.nbonds - 4] = 2;
            this.nasv[this.nbonds - 2] = 2;
            this.nasv[this.nbonds - 0] = 2;
            if (this.touchedBond > 0) {
                if (this.isSingle(this.touchedBond)) {
                    int atom3 = 0;
                    if (this.nv[this.va[this.touchedBond]] > 1) {
                        atom3 = this.v[this.va[this.touchedBond]][1];
                        atom = this.va[this.touchedBond];
                        if (atom3 == this.vb[this.touchedBond]) {
                            atom3 = this.v[this.va[this.touchedBond]][2];
                        }
                    }
                    if (atom3 == 0 && this.nv[this.vb[this.touchedBond]] > 1) {
                        atom3 = this.v[this.vb[this.touchedBond]][1];
                        atom = this.vb[this.touchedBond];
                        if (atom3 == this.vb[this.touchedBond]) {
                            atom3 = this.v[this.vb[this.touchedBond]][2];
                        }
                    }
                    if (atom3 > 0) {
                        for (i = 1; i <= this.nbonds; ++i) {
                            if ((this.va[i] != atom3 || this.vb[i] != atom) && (this.va[i] != atom || this.vb[i] != atom3)) continue;
                            if (!this.isSingle(i)) {
                                this.nasv[this.nbonds - 4] = 1;
                                this.nasv[this.nbonds - 2] = 1;
                                this.nasv[this.nbonds - 0] = 1;
                                this.nasv[this.nbonds - 5] = 2;
                                this.nasv[this.nbonds - 3] = 2;
                                this.nasv[this.nbonds - 1] = 3;
                            }
                            break;
                        }
                    }
                } else {
                    this.nasv[this.nbonds - 4] = 1;
                    this.nasv[this.nbonds - 2] = 1;
                    this.nasv[this.nbonds - 0] = 1;
                    this.nasv[this.nbonds - 5] = 2;
                    this.nasv[this.nbonds - 3] = 2;
                    this.nasv[this.nbonds - 1] = 2;
                }
            }
        } else if (this.jme.action == 221 || this.jme.action == 223) {
            if (this.touchedBond > 0) {
                if (this.nasv[this.touchedBond] == 1) {
                    int ax;
                    boolean isConjugated = false;
                    for (i = 1; i <= this.nv[this.va[this.touchedBond]]; ++i) {
                        ax = this.v[this.va[this.touchedBond]][i];
                        if (this.nasv[this.bondIdentity(this.va[this.touchedBond], ax)] <= 1) continue;
                        isConjugated = true;
                        break;
                    }
                    for (i = 1; i <= this.nv[this.vb[this.touchedBond]]; ++i) {
                        ax = this.v[this.vb[this.touchedBond]][i];
                        if (this.nasv[this.bondIdentity(this.vb[this.touchedBond], ax)] <= 1) continue;
                        isConjugated = true;
                        break;
                    }
                    if (!isConjugated) {
                        this.nasv[this.touchedBond] = 2;
                    }
                }
                this.nasv[this.nbonds - 4] = 2;
                this.an[this.natoms - 2] = 5;
            } else if (this.touchedAtom > 0) {
                if (this.jme.action == 221) {
                    this.nasv[this.nbonds - 4] = 1;
                    this.nasv[this.nbonds - 2] = 1;
                    this.nasv[this.nbonds - 1] = 1;
                    this.nasv[this.nbonds - 3] = 2;
                    this.nasv[this.nbonds - 0] = 2;
                    this.an[this.natoms - 1] = 5;
                } else {
                    this.nasv[this.nbonds - 3] = 1;
                    this.nasv[this.nbonds - 2] = 1;
                    this.nasv[this.nbonds - 0] = 1;
                    this.nasv[this.nbonds - 4] = 2;
                    this.nasv[this.nbonds - 1] = 2;
                    this.an[this.natoms - 2] = 5;
                }
            } else {
                this.nasv[this.nbonds - 3] = 1;
                this.nasv[this.nbonds - 2] = 1;
                this.nasv[this.nbonds - 0] = 1;
                this.nasv[this.nbonds - 4] = 2;
                this.nasv[this.nbonds - 1] = 2;
                this.an[this.natoms - 2] = 5;
            }
        }
    }

    void checkRing(int nmembered) {
        int k;
        int j;
        int atom2;
        int atom1;
        int i;
        int[] parent = new int[this.natoms + 1];
        for (i = 1; i <= nmembered; ++i) {
            int ratom = this.natoms - nmembered + i;
            int rbond = this.nbonds - nmembered + i;
            this.v[ratom][1] = ratom - 1;
            this.v[ratom][2] = ratom + 1;
            atom1 = this.va[rbond];
            atom2 = this.vb[rbond];
            this.xb[rbond] = (int)Math.round((this.x[atom1] + this.x[atom2]) / 2.0);
            this.yb[rbond] = (int)Math.round((this.y[atom1] + this.y[atom2]) / 2.0);
        }
        this.v[this.natoms - nmembered + 1][1] = this.natoms;
        this.v[this.natoms][2] = this.natoms - nmembered + 1;
        for (i = this.natoms - nmembered + 1; i <= this.natoms; ++i) {
            parent[i] = 0;
            double min = 51.0;
            int atom = 0;
            for (j = 1; j <= this.natoms - nmembered; ++j) {
                double dx = this.x[i] - this.x[j];
                double dy = this.y[i] - this.y[j];
                double rx = dx * dx + dy * dy;
                if (!(rx < 50.0) || !(rx < min)) continue;
                min = rx;
                atom = j;
            }
            if (atom <= 0 || this.touchedAtom != 0 && atom != this.touchedAtom) continue;
            parent[i] = atom;
        }
        int noldbonds = this.nbonds - nmembered;
        block3: for (i = noldbonds + 1; i <= noldbonds + nmembered; ++i) {
            atom1 = this.va[i];
            atom2 = this.vb[i];
            if (parent[atom1] > 0 && parent[atom2] > 0) {
                for (k = 1; k <= noldbonds; ++k) {
                    if (this.va[k] == parent[atom1] && this.vb[k] == parent[atom2] || this.vb[k] == parent[atom1] && this.va[k] == parent[atom2]) continue block3;
                }
                this.createBond();
                this.nasv[this.nbonds] = this.nasv[i];
                this.va[this.nbonds] = parent[atom1];
                int n = parent[atom1];
                int n2 = this.nv[n] + 1;
                this.nv[n] = n2;
                this.v[parent[atom1]][n2] = parent[atom2];
                this.vb[this.nbonds] = parent[atom2];
                int n3 = parent[atom2];
                int n4 = this.nv[n3] + 1;
                this.nv[n3] = n4;
                this.v[parent[atom2]][n4] = parent[atom1];
                this.xb[this.nbonds] = (int)Math.round((this.x[this.va[this.nbonds]] + this.x[this.vb[this.nbonds]]) / 2.0);
                this.yb[this.nbonds] = (int)Math.round((this.y[this.va[this.nbonds]] + this.y[this.vb[this.nbonds]]) / 2.0);
                continue;
            }
            if (parent[atom1] > 0) {
                this.createBond();
                this.nasv[this.nbonds] = this.nasv[i];
                this.va[this.nbonds] = parent[atom1];
                int n = parent[atom1];
                int n5 = this.nv[n] + 1;
                this.nv[n] = n5;
                this.v[parent[atom1]][n5] = atom2;
                this.vb[this.nbonds] = atom2;
                int n6 = atom2;
                int n7 = this.nv[n6] + 1;
                this.nv[n6] = n7;
                this.v[atom2][n7] = parent[atom1];
                this.xb[this.nbonds] = (int)Math.round((this.x[this.va[this.nbonds]] + this.x[this.vb[this.nbonds]]) / 2.0);
                this.yb[this.nbonds] = (int)Math.round((this.y[this.va[this.nbonds]] + this.y[this.vb[this.nbonds]]) / 2.0);
                continue;
            }
            if (parent[atom2] <= 0) continue;
            this.createBond();
            this.nasv[this.nbonds] = this.nasv[i];
            this.va[this.nbonds] = parent[atom2];
            int n = parent[atom2];
            int n8 = this.nv[n] + 1;
            this.nv[n] = n8;
            this.v[parent[atom2]][n8] = atom1;
            this.vb[this.nbonds] = atom1;
            int n9 = atom1;
            int n10 = this.nv[n9] + 1;
            this.nv[n9] = n10;
            this.v[atom1][n10] = parent[atom2];
            this.xb[this.nbonds] = (int)Math.round((this.x[this.va[this.nbonds]] + this.x[this.vb[this.nbonds]]) / 2.0);
            this.yb[this.nbonds] = (int)Math.round((this.y[this.va[this.nbonds]] + this.y[this.vb[this.nbonds]]) / 2.0);
        }
        int noldatoms = this.natoms - nmembered;
        for (i = this.natoms; i > noldatoms; --i) {
            if (parent[i] <= 0) continue;
            this.deleteAtom(i);
            if (this.an[parent[i]] != 3) continue;
            int sum = 0;
            for (j = 1; j <= this.nv[parent[i]]; ++j) {
                int a2 = this.v[parent[i]][j];
                for (k = 1; k <= this.nbonds; ++k) {
                    if ((this.va[k] != parent[i] || this.vb[k] != a2) && (this.va[k] != a2 || this.vb[k] != parent[i])) continue;
                    sum += this.nasv[k];
                }
            }
            if (sum <= 4) continue;
            for (k = noldbonds + 1; k <= noldbonds + nmembered; ++k) {
                this.nasv[k] = 1;
            }
        }
        if (this.touchedAtom > 0) {
            this.avoidTouch(nmembered);
        }
    }

    private void addPoint(int touchedAtom, double rbond, double[] newPoint) {
        double sina;
        double cosa;
        double vzd;
        int atom2 = this.v[touchedAtom][2];
        int atom1 = this.v[touchedAtom][1];
        double dx = this.x[atom2] - this.x[atom1];
        double dy = -(this.y[atom2] - this.y[atom1]);
        double rx = Math.sqrt(dx * dx + dy * dy);
        if (rx < 0.001) {
            rx = 0.001;
        }
        if ((vzd = Math.abs((this.y[touchedAtom] - this.y[atom1]) * (cosa = dx / rx) + (this.x[touchedAtom] - this.x[atom1]) * (sina = dy / rx))) < 1.0) {
            dx = this.x[touchedAtom] - this.x[atom1];
            dy = this.y[touchedAtom] - this.y[atom1];
            rx = Math.sqrt(dx * dx + dy * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            double xx = rx;
            double yy = rbond;
            sina = dy / rx;
            cosa = dx / rx;
            newPoint[0] = this.x[atom1] + xx * cosa - yy * sina;
            newPoint[1] = this.y[atom1] + yy * cosa + xx * sina;
        } else {
            double xpoint = (this.x[atom1] + this.x[atom2]) / 2.0;
            dx = this.x[touchedAtom] - xpoint;
            double ypoint = (this.y[atom1] + this.y[atom2]) / 2.0;
            dy = this.y[touchedAtom] - ypoint;
            rx = Math.sqrt(dx * dx + dy * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            newPoint[0] = this.x[touchedAtom] + rbond * dx / rx;
            newPoint[1] = this.y[touchedAtom] + rbond * dy / rx;
        }
    }

    void addGroupTemplate(boolean emptyCanvas) {
        int i;
        int mark1 = 0;
        JMEmol tmol = this.jme.tmol;
        for (int k = 1; k <= tmol.nmarked; ++k) {
            int atom = tmol.mark[k][0];
            if (tmol.mark[k][1] != 1) continue;
            mark1 = atom;
        }
        int nn = this.natoms;
        int source = this.touchedAtom;
        this.addBond();
        double x1 = this.x[this.natoms];
        double y1 = this.y[this.natoms];
        this.deleteAtom(this.natoms);
        double dx1 = this.x[source] - x1;
        double dy1 = this.y[source] - y1;
        double r = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double sina = dy1 / r;
        double cosa = dx1 / r;
        for (i = 1; i <= tmol.natoms; ++i) {
            this.createAtom();
            this.an[this.natoms] = tmol.an[i];
            this.q[this.natoms] = tmol.q[i];
            this.nh[this.natoms] = tmol.nh[i];
            this.x[this.natoms] = tmol.x[i];
            this.y[this.natoms] = tmol.y[i];
        }
        for (i = 1; i <= tmol.nbonds; ++i) {
            this.createBond();
            this.va[this.nbonds] = tmol.va[i] + nn;
            this.vb[this.nbonds] = tmol.vb[i] + nn;
            this.nasv[this.nbonds] = tmol.nasv[i];
        }
        this.complete();
        this.touchedAtom = mark1 + nn;
        this.addBond();
        double x2 = this.x[this.natoms];
        double y2 = this.y[this.natoms];
        this.deleteAtom(this.natoms);
        double dx2 = this.x[mark1 + nn] - x2;
        double dy2 = this.y[mark1 + nn] - y2;
        r = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        double sinb = dy2 / r;
        double cosb = dx2 / r;
        int i2 = nn + 1;
        while (i2 <= this.natoms) {
            int n = i2;
            this.x[n] = this.x[n] - x2;
            int n2 = i2;
            this.y[n2] = this.y[n2] - y2;
            double xx = this.x[i2] * cosb + this.y[i2] * sinb;
            double yy = this.y[i2] * cosb - this.x[i2] * sinb;
            this.x[i2] = xx;
            this.y[i2] = yy;
            xx = -this.x[i2] * cosa + this.y[i2] * sina;
            yy = -this.y[i2] * cosa - this.x[i2] * sina;
            this.x[i2] = xx;
            this.y[i2] = yy;
            int n3 = i2;
            this.x[n3] = this.x[n3] + this.x[source];
            int n4 = i2++;
            this.y[n4] = this.y[n4] + this.y[source];
        }
        this.createBond();
        this.va[this.nbonds] = source;
        this.vb[this.nbonds] = mark1 + nn;
        this.complete();
        if (emptyCanvas) {
            this.deleteAtom(source);
            this.center();
        }
    }

    void createAtom() {
        ++this.natoms;
        if (this.natoms > this.an.length - 1) {
            int storage = this.an.length + 10;
            int[] n_an = new int[storage];
            System.arraycopy(this.an, 0, n_an, 0, this.an.length);
            this.an = n_an;
            int[] n_q = new int[storage];
            System.arraycopy(this.q, 0, n_q, 0, this.q.length);
            this.q = n_q;
            int[] n_nh = new int[storage];
            System.arraycopy(this.nh, 0, n_nh, 0, this.nh.length);
            this.nh = n_nh;
            int[] n_abg = new int[storage];
            System.arraycopy(this.abg, 0, n_abg, 0, this.abg.length);
            this.abg = n_abg;
            String[] n_atag = new String[storage];
            System.arraycopy(this.atag, 0, n_atag, 0, this.atag.length);
            this.atag = n_atag;
            String[] n_label = new String[storage];
            System.arraycopy(this.label, 0, n_label, 0, this.label.length);
            this.label = n_label;
            double[] n_x = new double[storage];
            System.arraycopy(this.x, 0, n_x, 0, this.x.length);
            this.x = n_x;
            double[] n_y = new double[storage];
            System.arraycopy(this.y, 0, n_y, 0, this.y.length);
            this.y = n_y;
            int[][] n_v = new int[storage][7];
            System.arraycopy(this.v, 0, n_v, 0, this.v.length);
            this.v = n_v;
            int[] n_nv = new int[storage];
            System.arraycopy(this.nv, 0, n_nv, 0, this.nv.length);
            this.nv = n_nv;
        }
        this.an[this.natoms] = 3;
        this.q[this.natoms] = 0;
        this.abg[this.natoms] = 0;
        this.atag[this.natoms] = null;
        this.nh[this.natoms] = 0;
    }

    void createAtom(String symbol) {
        this.createAtom();
        this.setAtom(this.natoms, symbol);
    }

    void setAtom(int atom, String symbol) {
        if (symbol.startsWith("[") && symbol.endsWith("]")) {
            symbol = symbol.substring(1, symbol.length() - 1);
            this.an[atom] = 18;
            this.label[atom] = symbol;
            this.nh[atom] = 0;
            return;
        }
        if (symbol.length() < 1) {
            System.err.println("Error - null atom !");
        }
        boolean isQuery = false;
        if (symbol.indexOf(",") > -1) {
            isQuery = true;
        }
        if (symbol.indexOf(";") > -1) {
            isQuery = true;
        }
        if (symbol.indexOf("#") > -1) {
            isQuery = true;
        }
        if (symbol.indexOf("!") > -1) {
            isQuery = true;
        }
        int dpos = symbol.indexOf(":");
        int hpos = symbol.indexOf("H");
        int qpos = Math.max(symbol.indexOf("+"), symbol.indexOf("-"));
        if (dpos > -1) {
            String smark = symbol.substring(dpos + 1);
            try {
                this.jme.currentMark = Integer.parseInt(smark);
            }
            catch (Exception e) {
                this.jme.currentMark = 0;
            }
            this.touchedAtom = atom;
            this.mark();
            symbol = symbol.substring(0, dpos);
            this.touchedAtom = 0;
        }
        if (isQuery) {
            this.label[atom] = symbol;
            this.an[atom] = 18;
            this.nh[atom] = 0;
        } else {
            String as = symbol;
            if (hpos > 0) {
                as = symbol.substring(0, hpos);
            } else if (qpos > 0) {
                as = symbol.substring(0, qpos);
            }
            this.an[atom] = JMEmol.checkAtomicSymbol(as);
            if (this.an[atom] == 18) {
                this.label[atom] = as;
            }
            symbol = symbol + " ";
            int nhs = 0;
            if (hpos > 0) {
                char c;
                nhs = 1;
                if ((c = symbol.charAt(++hpos)) >= '0' && c <= '9') {
                    nhs = c - 48;
                }
            }
            if (this.an[atom] == 18) {
                this.nh[atom] = nhs;
            }
            int charge = 0;
            if (qpos > 0) {
                char c;
                if ((c = symbol.charAt(qpos++)) == '+') {
                    charge = 1;
                } else if (c == '-') {
                    charge = -1;
                }
                if (charge != 0) {
                    if ((c = symbol.charAt(qpos++)) >= '0' && c <= '9') {
                        c = (char)(c * (c - 48));
                    } else {
                        while (c == '+') {
                            ++charge;
                            c = symbol.charAt(qpos++);
                        }
                        while (c == '-') {
                            --charge;
                            c = symbol.charAt(qpos++);
                        }
                    }
                }
            }
            this.q[atom] = charge;
        }
    }

    void setAtomHydrogenCount(int atom, int nh) {
        if (this.an[atom] == 18) {
            int n = atom;
            this.label[n] = this.label[n] + "H";
            if (nh > 1) {
                int n2 = atom;
                this.label[n2] = this.label[n2] + nh;
            }
        }
    }

    void setAtomFormalCharge(int atom, int nq) {
        this.q[atom] = nq;
    }

    void setAtomColors(String s, boolean bg) {
        this.doColoring = 1;
        if (bg) {
            this.doColoring = -1;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            while (st.hasMoreTokens()) {
                int atom = Integer.valueOf(st.nextToken());
                int color = Integer.valueOf(st.nextToken());
                this.setAtomColoring(atom, color);
            }
        }
        catch (Exception e) {
            System.err.println("Error in atom coloring");
            e.printStackTrace();
        }
    }

    public void setAtomColoring(int atom, int n) {
        if (n < 0 || n > 6) {
            n = 0;
        }
        this.abg[atom] = n;
    }

    void createBond() {
        ++this.nbonds;
        if (this.nbonds > this.nasv.length - 1) {
            int storage = this.nasv.length + 10;
            int[] n_va = new int[storage];
            System.arraycopy(this.va, 0, n_va, 0, this.va.length);
            this.va = n_va;
            int[] n_vb = new int[storage];
            System.arraycopy(this.vb, 0, n_vb, 0, this.vb.length);
            this.vb = n_vb;
            int[] n_nasv = new int[storage];
            System.arraycopy(this.nasv, 0, n_nasv, 0, this.nasv.length);
            this.nasv = n_nasv;
            int[] n_stereob = new int[storage];
            System.arraycopy(this.stereob, 0, n_stereob, 0, this.stereob.length);
            this.stereob = n_stereob;
            int[] n_xb = new int[storage];
            System.arraycopy(this.xb, 0, n_xb, 0, this.xb.length);
            this.xb = n_xb;
            int[] n_yb = new int[storage];
            System.arraycopy(this.yb, 0, n_yb, 0, this.yb.length);
            this.yb = n_yb;
            String[] n_btag = new String[storage];
            System.arraycopy(this.btag, 0, n_btag, 0, this.btag.length);
            this.btag = n_btag;
        }
        this.nasv[this.nbonds] = 1;
        this.stereob[this.nbonds] = 0;
        this.btag[this.nbonds] = null;
    }

    void findBondCenters() {
        for (int i = 1; i <= this.nbonds; ++i) {
            int atom1 = this.va[i];
            int atom2 = this.vb[i];
            this.xb[i] = (int)Math.round((this.x[atom1] + this.x[atom2]) / 2.0);
            this.yb[i] = (int)Math.round((this.y[atom1] + this.y[atom2]) / 2.0);
        }
    }

    void save() {
        this.jme.smol = new JMEmol(this);
        this.jme.smol.complete();
        this.jme.saved = this.jme.actualMolecule;
    }

    boolean isRotatableBond(int a1, int a2) {
        int i;
        int poradie = 1;
        this.a = new int[this.natoms + 1];
        for (i = 1; i <= this.natoms; ++i) {
            this.a[i] = 0;
        }
        this.a[a1] = poradie;
        for (i = 1; i <= this.nv[a1]; ++i) {
            if (this.v[a1][i] == a2) continue;
            this.a[this.v[a1][i]] = ++poradie;
        }
        boolean ok = false;
        block2: do {
            for (i = 1; i <= this.natoms; ++i) {
                ok = false;
                if (this.a[i] > 0 && i != a1) {
                    for (int j = 1; j <= this.nv[i]; ++j) {
                        if (this.a[this.v[i][j]] != 0) continue;
                        this.a[this.v[i][j]] = ++poradie;
                        ok = true;
                    }
                }
                if (ok) continue block2;
            }
        } while (ok);
        return this.a[a2] == 0;
    }

    void findRingBonds(boolean[] isRingBond) {
        for (int i = 1; i <= this.nbonds; ++i) {
            isRingBond[i] = !this.isRotatableBond(this.va[i], this.vb[i]);
        }
    }

    boolean isInRing(int atom, boolean[] isRingBond) {
        for (int i = 1; i <= this.nv[atom]; ++i) {
            if (!isRingBond[this.bondIdentity(atom, this.v[atom][i])]) continue;
            return true;
        }
        return false;
    }

    void findAromatic(boolean[] isAromatic, boolean[] isRingBond) {
        int b;
        this.btype = new int[this.nbonds + 1];
        boolean[] pa = new boolean[this.natoms + 1];
        block4: for (int i = 1; i <= this.natoms; ++i) {
            pa[i] = false;
            isAromatic[i] = false;
            if (!this.isInRing(i, isRingBond) || this.nv[i] + this.nh[i] > 3) continue;
            switch (this.an[i]) {
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 13: {
                    pa[i] = true;
                    continue block4;
                }
                case 18: {
                    pa[i] = true;
                }
            }
        }
        for (b = 1; b <= this.nbonds; ++b) {
            if (this.isSingle(b)) {
                this.btype[b] = 1;
                continue;
            }
            if (this.isDouble(b)) {
                this.btype[b] = 2;
                continue;
            }
            if (this.nasv[b] == 3) {
                this.btype[b] = 3;
                continue;
            }
            System.err.println("problems in findAromatic " + this.nasv[b]);
        }
        block6: for (b = 1; b <= this.nbonds; ++b) {
            if (!isRingBond[b]) continue;
            int atom1 = this.va[b];
            int atom2 = this.vb[b];
            if (!pa[atom1] || !pa[atom2]) continue;
            boolean[] a = new boolean[this.natoms + 1];
            for (int i = 1; i <= this.nv[atom1]; ++i) {
                int atom = this.v[atom1][i];
                if (atom == atom2 || !pa[atom]) continue;
                a[atom] = true;
            }
            boolean ok = false;
            block8: do {
                for (int i = 1; i <= this.natoms; ++i) {
                    ok = false;
                    if (a[i] && pa[i] && i != atom1) {
                        for (int j = 1; j <= this.nv[i]; ++j) {
                            int atom = this.v[i][j];
                            if (atom == atom2) {
                                isAromatic[atom1] = true;
                                isAromatic[atom2] = true;
                                this.btype[b] = 5;
                                continue block6;
                            }
                            if (a[atom] || !pa[atom]) continue;
                            a[atom] = true;
                            ok = true;
                        }
                    }
                    if (ok) continue block8;
                }
            } while (ok);
        }
    }

    void canonize() {
        int i;
        int j;
        int[] a = new int[this.natoms + 1];
        int[] aold = new int[this.natoms + 1];
        long[] d = new long[this.natoms + 1];
        long[] prime = new long[this.natoms + 2];
        prime = JMEmol.generatePrimes(this.natoms);
        for (int i2 = 1; i2 <= this.natoms; ++i2) {
            int xbo = 1;
            for (j = 1; j <= this.nbonds; ++j) {
                if (this.va[j] != i2 && this.vb[j] != i2) continue;
                xbo *= this.btype[j];
            }
            int xan = this.an[i2];
            if (xan == 18) {
                String zlabel = this.label[i2];
                int c1 = zlabel.charAt(0) - 65 + 1;
                int c2 = 0;
                if (zlabel.length() > 1) {
                    c2 = zlabel.charAt(1) - 97;
                }
                if (c1 < 0) {
                    c1 = 0;
                }
                if (c2 < 0) {
                    c2 = 0;
                }
                xan = c1 * 28 + c2;
            }
            int qq = 0;
            if (this.q[i2] < -2) {
                qq = 1;
            } else if (this.q[i2] == -2) {
                qq = 2;
            } else if (this.q[i2] == -1) {
                qq = 3;
            } else if (this.q[i2] == 1) {
                qq = 4;
            } else if (this.q[i2] == 2) {
                qq = 5;
            } else if (this.q[i2] > 2) {
                qq = 6;
            }
            int xx = 1;
            d[i2] = xbo;
            int n = i2;
            d[n] = d[n] + (long)(this.nh[i2] * (xx *= 126));
            int n2 = i2;
            d[n2] = d[n2] + (long)(qq * (xx *= 7));
            int n3 = i2;
            d[n3] = d[n3] + (long)(xan * (xx *= 7));
            int n4 = i2;
            d[n4] = d[n4] + (long)(this.nv[i2] * (xx *= 783));
        }
        int breaklevel = 0;
        while (!this.canonsort(a, d)) {
            block42: {
                boolean ok = false;
                for (i = 1; i <= this.natoms; ++i) {
                    if (a[i] == aold[i]) continue;
                    aold[i] = a[i];
                    ok = true;
                }
                if (ok) {
                    for (i = 1; i <= this.natoms; ++i) {
                        d[i] = 1L;
                        for (j = 1; j <= this.nv[i]; ++j) {
                            int n = i;
                            d[n] = d[n] * prime[a[this.v[i][j]]];
                        }
                    }
                    breaklevel = 0;
                } else if (breaklevel > 0) {
                    for (i = 1; i <= this.natoms; ++i) {
                        d[i] = 1L;
                    }
                    for (i = 1; i <= this.natoms - 1; ++i) {
                        for (j = i + 1; j <= this.natoms; ++j) {
                            if (a[i] != a[j]) continue;
                            d[i] = 2L;
                            break block42;
                        }
                    }
                } else {
                    for (i = 1; i <= this.natoms; ++i) {
                        d[i] = 1L;
                        for (j = 1; j <= this.nv[i]; ++j) {
                            int atom = this.v[i][j];
                            int n = i;
                            d[n] = d[n] * (long)(this.an[atom] * this.btype[this.bondIdentity(i, atom)]);
                        }
                    }
                    breaklevel = 1;
                }
            }
            this.canonsort(a, d);
            for (i = 1; i <= this.natoms; ++i) {
                d[i] = aold[i] * this.natoms + a[i];
            }
        }
        for (i = 1; i <= this.natoms; ++i) {
            aold[i] = a[i];
        }
        block13: for (int s = 1; s <= this.natoms; ++s) {
            for (int i3 = 1; i3 <= this.natoms; ++i3) {
                if (aold[i3] != s) continue;
                this.an[0] = this.an[i3];
                this.q[0] = this.q[i3];
                this.x[0] = this.x[i3];
                this.y[0] = this.y[i3];
                this.nv[0] = this.nv[i3];
                this.an[i3] = this.an[s];
                this.q[i3] = this.q[s];
                this.x[i3] = this.x[s];
                this.y[i3] = this.y[s];
                this.nv[i3] = this.nv[s];
                this.an[s] = this.an[0];
                this.q[s] = this.q[0];
                this.x[s] = this.x[0];
                this.y[s] = this.y[0];
                this.nv[s] = this.nv[0];
                aold[i3] = aold[s];
                aold[s] = s;
                this.label[0] = this.label[i3];
                this.label[i3] = this.label[s];
                this.label[s] = this.label[0];
                this.abg[0] = this.abg[i3];
                this.abg[i3] = this.abg[s];
                this.abg[s] = this.abg[0];
                this.atag[0] = this.atag[i3];
                this.atag[i3] = this.atag[s];
                this.atag[s] = this.atag[0];
                this.nh[0] = this.nh[i3];
                this.nh[i3] = this.nh[s];
                this.nh[s] = this.nh[0];
                continue block13;
            }
        }
        for (i = 1; i <= this.nmarked; ++i) {
            this.mark[i][0] = a[this.mark[i][0]];
        }
        for (i = 1; i <= this.nbonds; ++i) {
            this.va[i] = a[this.va[i]];
            this.vb[i] = a[this.vb[i]];
            if (this.va[i] <= this.vb[i]) continue;
            int du = this.va[i];
            this.va[i] = this.vb[i];
            this.vb[i] = du;
            if (this.stereob[i] == 1) {
                this.stereob[i] = 3;
                continue;
            }
            if (this.stereob[i] == 2) {
                this.stereob[i] = 4;
                continue;
            }
            if (this.stereob[i] == 3) {
                this.stereob[i] = 1;
                continue;
            }
            if (this.stereob[i] != 4) continue;
            this.stereob[i] = 2;
        }
        for (i = 1; i < this.nbonds; ++i) {
            int minva = this.natoms;
            int minvb = this.natoms;
            int b = 0;
            for (int j2 = i; j2 <= this.nbonds; ++j2) {
                if (this.va[j2] < minva) {
                    minva = this.va[j2];
                    minvb = this.vb[j2];
                    b = j2;
                    continue;
                }
                if (this.va[j2] != minva || this.vb[j2] >= minvb) continue;
                minvb = this.vb[j2];
                b = j2;
            }
            int du = this.va[i];
            this.va[i] = this.va[b];
            this.va[b] = du;
            du = this.vb[i];
            this.vb[i] = this.vb[b];
            this.vb[b] = du;
            du = this.nasv[i];
            this.nasv[i] = this.nasv[b];
            this.nasv[b] = du;
            du = this.stereob[i];
            this.stereob[i] = this.stereob[b];
            this.stereob[b] = du;
            String ds = this.btag[i];
            this.btag[i] = this.btag[b];
            this.btag[b] = ds;
        }
        this.complete();
    }

    boolean canonsort(int[] a, long[] d) {
        long min = 0L;
        int nth = 0;
        int ndone = 0;
        do {
            int i;
            ++nth;
            for (i = 1; i <= this.natoms; ++i) {
                if (d[i] <= 0L) continue;
                min = d[i];
                break;
            }
            for (i = 1; i <= this.natoms; ++i) {
                if (d[i] <= 0L || d[i] >= min) continue;
                min = d[i];
            }
            for (i = 1; i <= this.natoms; ++i) {
                if (d[i] != min) continue;
                a[i] = nth;
                d[i] = 0L;
                ++ndone;
            }
        } while (ndone != this.natoms);
        return nth == this.natoms;
    }

    void cleanPolarBonds() {
        for (int i = 1; i <= this.nbonds; ++i) {
            int atom1 = this.va[i];
            int atom2 = this.vb[i];
            if ((this.q[atom1] == 1 && this.q[atom2] == -1 || this.q[atom1] == -1 && this.q[atom2] == 1) && (this.nasv[i] == 1 || this.nasv[i] == 2)) {
                if (this.an[atom1] != 3 && this.an[atom2] != 3 && this.jme.polarnitro || this.an[atom1] == 1 || this.an[atom2] == 1 || this.an[atom1] == 2 || this.an[atom2] == 2 || this.an[atom1] == 9 || this.an[atom1] == 10 || this.an[atom1] == 11 || this.an[atom1] == 12 || this.an[atom2] == 9 || this.an[atom2] == 10 || this.an[atom2] == 11 || this.an[atom2] == 12) continue;
                this.q[atom1] = 0;
                this.q[atom2] = 0;
                int n = i;
                this.nasv[n] = this.nasv[n] + 1;
                this.valenceState();
            }
            if (this.q[atom1] == 1 && this.q[atom2] == 1) {
                if (this.nasv[i] == 2) {
                    this.nasv[i] = 1;
                } else if (this.nasv[i] == 3) {
                    this.nasv[i] = 2;
                }
                this.valenceState();
            }
            if (this.nasv[i] != 4) continue;
            this.nasv[i] = 1;
        }
    }

    void fillFields() {
        int i;
        int storage = this.an.length;
        this.v = new int[storage][7];
        this.nv = new int[storage];
        for (i = 1; i <= this.natoms; ++i) {
            this.nv[i] = 0;
        }
        for (i = 1; i <= this.nbonds; ++i) {
            if (this.nv[this.va[i]] < 6) {
                int n = this.va[i];
                int n2 = this.nv[n] + 1;
                this.nv[n] = n2;
                this.v[this.va[i]][n2] = this.vb[i];
            }
            if (this.nv[this.vb[i]] >= 6) continue;
            int n = this.vb[i];
            int n3 = this.nv[n] + 1;
            this.nv[n] = n3;
            this.v[this.vb[i]][n3] = this.va[i];
        }
    }

    /*
     * Exception decompiling
     */
    int checkMultipart(boolean removeSmall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 3[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String createSmiles() {
        int i;
        int step;
        int[] con1 = new int[this.natoms + 10];
        int[] con2 = new int[this.natoms + 10];
        int[] branch = new int[this.natoms + 1];
        int[] candidate = new int[7];
        int[] parent = new int[this.natoms + 1];
        boolean[] isAromatic = new boolean[this.natoms + 1];
        boolean[] isRingBond = new boolean[this.nbonds + 1];
        int nconnections = 0;
        if (this.natoms == 0) {
            return "";
        }
        this.checkMultipart(true);
        boolean noQueryBonds = true;
        for (int b = 1; b <= this.nbonds; ++b) {
            if (this.nasv[b] != 9) continue;
            noQueryBonds = false;
            break;
        }
        if (this.jme.canonize && noQueryBonds) {
            this.deleteHydrogens();
            this.cleanPolarBonds();
            this.findRingBonds(isRingBond);
            this.findAromatic(isAromatic, isRingBond);
            this.canonize();
            this.valenceState();
            this.findRingBonds(isRingBond);
            this.findAromatic(isAromatic, isRingBond);
        } else {
            this.findRingBonds(isRingBond);
            this.btype = new int[this.nbonds + 1];
            for (int i2 = 1; i2 <= this.nbonds; ++i2) {
                this.btype[i2] = this.nasv[i2];
            }
        }
        int atom = 1;
        this.a = new int[this.natoms + 1];
        this.a[atom] = step = 1;
        int nbranch = 0;
        while (true) {
            int b;
            int i3;
            int ncandidates = 0;
            for (int i4 = 1; i4 <= this.nv[atom]; ++i4) {
                int atomx = this.v[atom][i4];
                if (this.a[atomx] > 0) {
                    if (this.a[atomx] > this.a[atom] || atomx == parent[atom]) continue;
                    boolean newcon = true;
                    for (int k = 1; k <= nconnections; ++k) {
                        if ((con1[k] != atom || con2[k] != atomx) && (con1[k] != atomx || con2[k] != atom)) continue;
                        newcon = false;
                        break;
                    }
                    if (!newcon) continue;
                    con1[++nconnections] = atom;
                    con2[nconnections] = atomx;
                    continue;
                }
                candidate[++ncandidates] = atomx;
            }
            if (ncandidates == 0) {
                if (step == this.natoms) break;
                atom = branch[nbranch--];
                continue;
            }
            if (ncandidates == 1) {
                parent[candidate[1]] = atom;
                atom = candidate[1];
                this.a[atom] = ++step;
                continue;
            }
            branch[++nbranch] = atom;
            int atomnew = 0;
            for (i3 = 1; i3 <= ncandidates; ++i3) {
                b = this.bondIdentity(candidate[i3], atom);
                if (isRingBond[b]) continue;
                atomnew = candidate[i3];
                break;
            }
            if (atomnew == 0) {
                for (i3 = 1; i3 <= ncandidates; ++i3) {
                    b = this.bondIdentity(candidate[i3], atom);
                    if (this.btype[b] != 2 && this.btype[b] != 3) continue;
                    atomnew = candidate[i3];
                    break;
                }
            }
            if (atomnew == 0) {
                atomnew = candidate[1];
            }
            parent[atomnew] = atom;
            atom = atomnew;
            this.a[atom] = ++step;
        }
        parent = new int[this.natoms + 1];
        int[] aa = new int[this.natoms + 1];
        boolean[] leftBracket = new boolean[this.natoms + 1];
        boolean[] rightBracket = new boolean[this.natoms + 1];
        nbranch = 0;
        step = 0;
        int atomold = 0;
        for (int i5 = 1; i5 <= this.natoms; ++i5) {
            if (this.a[i5] != 1) continue;
            atom = i5;
            break;
        }
        block8: while (true) {
            int ncandidates;
            int atomnew;
            if (atomold > 0) {
                parent[atom] = atomold;
            }
            aa[++step] = atom;
            this.a[atom] = 0;
            while (true) {
                atomnew = 0;
                ncandidates = 0;
                int min = this.natoms + 1;
                block10: for (int i6 = 1; i6 <= this.nv[atom]; ++i6) {
                    int atomx = this.v[atom][i6];
                    for (int j = 1; j <= nconnections; ++j) {
                        if (con1[j] == atomx && con2[j] == atom || con1[j] == atom && con2[j] == atomx) continue block10;
                    }
                    if (this.a[atomx] <= 0) continue;
                    ++ncandidates;
                    if (this.a[atomx] >= min) continue;
                    atomnew = atomx;
                    min = this.a[atomx];
                }
                if (atomnew != 0) break;
                if (nbranch == 0) break block8;
                rightBracket[atom] = true;
                atom = branch[nbranch--];
            }
            atomold = atom;
            atom = atomnew;
            if (ncandidates <= true) continue;
            branch[++nbranch] = atomold;
            leftBracket[atom] = true;
        }
        int[] slashBond = new int[this.nbonds + 1];
        int[] slimak = new int[this.natoms + 1];
        if (this.jme.stereo) {
            this.smilesStereo(aa, parent, slashBond, slimak, isRingBond, con1, con2, nconnections);
        }
        boolean queryMode = false;
        SB smiles = new SB();
        int[] ax = new int[this.natoms + 1];
        for (i = 1; i <= this.natoms; ++i) {
            ax[aa[i]] = i;
        }
        for (i = 1; i <= this.natoms; ++i) {
            atom = aa[i];
            if (leftBracket[atom]) {
                smiles.append("(");
            }
            if (parent[i] > 0) {
                this.smilesAddBond(atom, parent[atom], smiles, slashBond, queryMode);
            }
            this.smilesAddAtom(atom, smiles, isAromatic[atom], slimak);
            for (int j = 1; j <= nconnections; ++j) {
                if (con1[j] != atom && con2[j] != atom) continue;
                int atom2 = con2[j];
                if (atom2 == atom) {
                    atom2 = con1[j];
                }
                if (ax[atom] < ax[atom2]) {
                    this.smilesAddBond(con1[j], con2[j], smiles, slashBond, queryMode);
                }
                if (j > 9) {
                    smiles.append("%");
                }
                smiles.append(new Integer(j).toString());
            }
            if (!rightBracket[atom]) continue;
            smiles.append(")");
        }
        return smiles.toString();
    }

    private void smilesAddAtom(int atom, SB smiles, boolean isAromatic, int[] slimak) {
        String z = "X";
        boolean bracket = false;
        if (this.q[atom] != 0) {
            bracket = true;
        }
        if (slimak[atom] != 0) {
            bracket = true;
        }
        int lmark = -1;
        for (int i = 1; i <= this.nmarked; ++i) {
            if (this.mark[i][0] != atom) continue;
            lmark = this.mark[i][1];
            break;
        }
        if (lmark > -1) {
            bracket = true;
        }
        if (this.jme.allHs) {
            bracket = true;
        }
        if (this.jme.star && this.abg[atom] > 0) {
            bracket = true;
            lmark = 1;
        }
        switch (this.an[atom]) {
            case 2: {
                z = "B";
                break;
            }
            case 3: {
                if (isAromatic) {
                    z = "c";
                    break;
                }
                z = "C";
                break;
            }
            case 4: {
                if (isAromatic) {
                    z = "n";
                    if (this.nh[atom] <= 0) break;
                    bracket = true;
                    break;
                }
                z = "N";
                break;
            }
            case 5: {
                if (isAromatic) {
                    z = "o";
                    break;
                }
                z = "O";
                break;
            }
            case 7: {
                if (isAromatic) {
                    z = "p";
                    if (this.nh[atom] <= 0) break;
                    bracket = true;
                    break;
                }
                z = "P";
                break;
            }
            case 8: {
                if (isAromatic) {
                    z = "s";
                    break;
                }
                z = "S";
                break;
            }
            case 13: {
                z = isAromatic ? "se" : "Se";
                bracket = true;
                break;
            }
            case 6: {
                z = "Si";
                bracket = true;
                break;
            }
            case 9: {
                z = "F";
                break;
            }
            case 10: {
                z = "Cl";
                break;
            }
            case 11: {
                z = "Br";
                break;
            }
            case 12: {
                z = "I";
                break;
            }
            case 1: {
                z = "H";
                bracket = true;
                break;
            }
            case 19: {
                z = "R";
                bracket = true;
                break;
            }
            case 20: {
                z = "R1";
                bracket = true;
                break;
            }
            case 21: {
                z = "R2";
                bracket = true;
                break;
            }
            case 22: {
                z = "R3";
                bracket = true;
                break;
            }
            case 18: {
                bracket = true;
                z = this.label[atom];
                if (!z.equals("*") && !z.equals("a") && !z.equals("A")) break;
                bracket = false;
            }
        }
        if (bracket) {
            z = "[" + z;
            if (slimak[atom] == 1) {
                z = z + "@";
            } else if (slimak[atom] == -1) {
                z = z + "@@";
            }
            if (this.nh[atom] == 1) {
                z = z + "H";
            } else if (this.nh[atom] > 1) {
                z = z + "H" + this.nh[atom];
            }
            if (this.q[atom] != 0) {
                z = this.q[atom] > 0 ? z + "+" : z + "-";
                if (Math.abs(this.q[atom]) > 1) {
                    z = z + Math.abs(this.q[atom]);
                }
            }
            if (lmark > -1) {
                z = z + ":" + lmark;
            }
            z = z + "]";
        }
        smiles.append(z);
    }

    private void smilesAddBond(int atom1, int atom2, SB smiles, int[] slashBond, boolean queryMode) {
        int b = this.bondIdentity(atom1, atom2);
        if (this.btype[b] != 5 && this.isDouble(b)) {
            smiles.append("=");
        } else if (this.nasv[b] == 3) {
            smiles.append("#");
        } else if (this.nasv[b] == 9) {
            String z = "?";
            String o = this.btag[b];
            if (o != null) {
                z = o;
            }
            smiles.append(z);
        } else if (this.btype[b] == 5 && queryMode) {
            smiles.append(":");
        } else if (slashBond[b] == 1) {
            smiles.append("/");
        } else if (slashBond[b] == -1) {
            smiles.append("\\");
        }
    }

    private void smilesStereo(int[] aa, int[] parent, int[] slashBond, int[] slimak, boolean[] isRingBond, int[] con1, int[] con2, int nconnections) {
        int i;
        int[] ax = new int[this.natoms + 1];
        for (int i2 = 1; i2 <= this.natoms; ++i2) {
            ax[aa[i2]] = i2;
        }
        boolean[] doneEZ = new boolean[this.nbonds + 1];
        for (i = 1; i <= this.natoms; ++i) {
            int atom1 = aa[i];
            int atom2 = parent[atom1];
            int bi = this.bondIdentity(atom1, atom2);
            if (bi == 0) continue;
            this.stereoEZ(bi, ax, slashBond, isRingBond);
            doneEZ[bi] = true;
        }
        for (i = 1; i <= this.nbonds; ++i) {
            if (doneEZ[i]) continue;
            this.stereoEZ(i, ax, slashBond, isRingBond);
        }
        doneEZ = null;
        block3: for (i = 1; i <= this.natoms; ++i) {
            if (this.nv[i] < 2 || this.nv[i] > 4) continue;
            int nstereo = 0;
            int doubleBonded = 0;
            for (int j = 1; j <= this.nv[i]; ++j) {
                int bi = this.bondIdentity(i, this.v[i][j]);
                if (this.btype[bi] == 5) continue block3;
                if (this.nasv[bi] == 1 && this.upDownBond(bi, i) != 0) {
                    ++nstereo;
                }
                if (this.nasv[bi] != 2) continue;
                doubleBonded = this.v[i][j];
            }
            if (nstereo == 0) continue;
            if (doubleBonded > 0) {
                this.stereoAllene(i, ax, slimak, parent, con1, con2, nconnections);
                continue;
            }
            this.stereoC4(i, parent, ax, con1, con2, nconnections, slimak);
        }
    }

    private void stereoC4(int atom, int[] parent, int[] ax, int[] con1, int[] con2, int nconnections, int[] slimak) {
        int[] ref = new int[4];
        int[] refx = new int[4];
        this.identifyNeighbors(atom, ax, parent, con1, con2, nconnections, ref);
        int nup = 0;
        int ndown = 0;
        int up = 0;
        int down = 0;
        int marked = 0;
        int nonmarked = 0;
        for (int i = 0; i < 4; ++i) {
            if (ref[i] <= 0) continue;
            int bi = this.bondIdentity(atom, ref[i]);
            refx[i] = this.upDownBond(bi, atom);
            if (refx[i] > 0) {
                ++nup;
                up = ref[i];
                marked = ref[i];
                continue;
            }
            if (refx[i] < 0) {
                ++ndown;
                down = ref[i];
                marked = ref[i];
                continue;
            }
            nonmarked = ref[i];
        }
        int nstereo = nup + ndown;
        int[] t = new int[4];
        int stereoRef = 0;
        if (this.nv[atom] == 3) {
            if (nup == 1 && ndown == 1 || nstereo == 3 && nup > 0 && ndown > 0) {
                this.jme.info("Error in C3H stereospecification !");
                return;
            }
            int refAtom = ref[0];
            if (nstereo == 1) {
                refAtom = marked;
            } else if (nstereo == 2) {
                refAtom = nonmarked;
            }
            int[] ox = this.C4order(atom, refAtom, ref);
            t[0] = marked;
            t[1] = -1;
            t[2] = ox[2];
            t[3] = ox[1];
            stereoRef = nup > 0 ? 1 : -1;
        } else if (this.nv[atom] == 4) {
            if (nstereo == 1) {
                int[] ox = this.C4order(atom, marked, ref);
                t[0] = ox[0];
                t[1] = ox[3];
                t[2] = ox[2];
                t[3] = ox[1];
                stereoRef = nup > 0 ? 1 : -1;
            } else {
                int i;
                int refAtom = ref[0];
                if (nonmarked > 1) {
                    refAtom = nonmarked;
                }
                if (nup == 1) {
                    refAtom = up;
                } else if (ndown == 1) {
                    refAtom = down;
                }
                int[] ox = this.C4order(atom, refAtom, ref);
                int[] box = new int[4];
                for (i = 0; i < 4; ++i) {
                    int bi = this.bondIdentity(atom, ox[i]);
                    box[i] = this.upDownBond(bi, atom);
                }
                if (nstereo == 4) {
                    if (nup == 0 || ndown == 0) {
                        this.jme.info("Error in C4 stereospecification !");
                        return;
                    }
                    if (nup == 1 || ndown == 1) {
                        t[0] = ox[0];
                        t[1] = ox[3];
                        t[2] = ox[2];
                        t[3] = ox[1];
                        stereoRef = box[0];
                    } else {
                        for (i = 0; i < 4; ++i) {
                            if (box[i] != -1) continue;
                            box[i] = 0;
                        }
                        nstereo = 2;
                    }
                } else if (nstereo == 3) {
                    if (nup == 3 || ndown == 3) {
                        t[0] = ox[0];
                        t[1] = ox[3];
                        t[2] = ox[2];
                        t[3] = ox[1];
                        stereoRef = nup > 0 ? -1 : 1;
                    } else {
                        int d = 0;
                        if (nup == 1) {
                            d = 1;
                            nup = 1;
                        } else {
                            d = -1;
                            ndown = -1;
                        }
                        for (int i2 = 0; i2 < 4; ++i2) {
                            if (box[i2] != d) continue;
                            box[i2] = 0;
                        }
                        nstereo = 2;
                    }
                }
                if (nstereo == 2) {
                    if (nup == 1 && ndown == 1) {
                        if (ox[1] == down) {
                            ox[1] = ox[2];
                            ox[2] = ox[3];
                        } else if (ox[2] == down) {
                            ox[2] = ox[3];
                        }
                        t[0] = up;
                        t[1] = down;
                        t[2] = ox[2];
                        t[3] = ox[1];
                        stereoRef = 1;
                    } else {
                        if (box[0] == box[1] || box[1] == box[2]) {
                            this.jme.info("Error in C4 stereospecification ! 2/0r");
                            return;
                        }
                        if (box[0] != 0) {
                            t[0] = ox[0];
                            t[1] = ox[2];
                            t[2] = ox[1];
                            t[3] = ox[3];
                        } else {
                            t[0] = ox[1];
                            t[1] = ox[3];
                            t[2] = ox[2];
                            t[3] = ox[0];
                        }
                        stereoRef = nup > 1 ? 1 : -1;
                    }
                }
            }
        }
        this.stereoTransformation(t, ref);
        if (t[2] == ref[2]) {
            slimak[atom] = 1;
        } else if (t[2] == ref[3]) {
            slimak[atom] = -1;
        } else {
            this.jme.info("Error in stereoprocessing ! - t30");
        }
        int n = atom;
        slimak[n] = slimak[n] * stereoRef;
    }

    private void identifyNeighbors(int atom, int[] ax, int[] parent, int[] con1, int[] con2, int nconnections, int[] ref) {
        int i;
        int nref = -1;
        if (parent[atom] > 0) {
            ref[++nref] = parent[atom];
        }
        for (i = 1; i <= nconnections; ++i) {
            if (con1[i] == atom) {
                ref[++nref] = con2[i];
            }
            if (con2[i] != atom) continue;
            ref[++nref] = con1[i];
        }
        for (i = nref + 1; i < this.nv[atom]; ++i) {
            int min = this.natoms + 1;
            block2: for (int j = 1; j <= this.nv[atom]; ++j) {
                int atomx = this.v[atom][j];
                for (int k = 0; k < i; ++k) {
                    if (atomx == ref[k]) continue block2;
                }
                if (ax[atomx] >= min) continue;
                min = ax[atomx];
                ref[i] = atomx;
            }
        }
        if (parent[atom] == 0 && this.nh[atom] > 0) {
            ref[3] = ref[2];
            ref[2] = ref[1];
            ref[1] = ref[0];
            ref[0] = -1;
            System.out.println("stereowarning #7");
        } else if (this.nh[atom] > 0) {
            ref[3] = ref[2];
            ref[2] = ref[1];
            ref[1] = -1;
        }
    }

    int[] C4order(int center, int ref0, int[] ref) {
        int[] ox = new int[4];
        double dx = this.x[ref0] - this.x[center];
        double dy = this.y[ref0] - this.y[center];
        double rx = Math.sqrt(dx * dx + dy * dy);
        if (rx < 0.001) {
            rx = 0.001;
        }
        double sin0 = dy / rx;
        double cos0 = dx / rx;
        int[] p = new int[4];
        for (int i = 0; i < 4; ++i) {
            if (ref[i] == ref0 || ref[i] <= 0) continue;
            if (p[1] == 0) {
                p[1] = ref[i];
                continue;
            }
            if (p[2] == 0) {
                p[2] = ref[i];
                continue;
            }
            if (p[3] != 0) continue;
            p[3] = ref[i];
        }
        double[] sin = new double[4];
        double[] cos = new double[4];
        for (int i = 1; i <= 3; ++i) {
            if (i == 3 && p[3] == 0) continue;
            dx = (this.x[p[i]] - this.x[center]) * cos0 + (this.y[p[i]] - this.y[center]) * sin0;
            dy = (this.y[p[i]] - this.y[center]) * cos0 - (this.x[p[i]] - this.x[center]) * sin0;
            rx = Math.sqrt(dx * dx + dy * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            sin[i] = dy / rx;
            cos[i] = dx / rx;
        }
        int c12 = this.compareAngles(sin[1], cos[1], sin[2], cos[2]);
        if (p[3] > 0) {
            int c23 = this.compareAngles(sin[2], cos[2], sin[3], cos[3]);
            int c13 = this.compareAngles(sin[1], cos[1], sin[3], cos[3]);
            if (c12 > 0 && c23 > 0) {
                ox[1] = p[1];
                ox[2] = p[2];
                ox[3] = p[3];
            } else if (c13 > 0 && c23 < 0) {
                ox[1] = p[1];
                ox[2] = p[3];
                ox[3] = p[2];
            } else if (c12 < 0 && c13 > 0) {
                ox[1] = p[2];
                ox[2] = p[1];
                ox[3] = p[3];
            } else if (c23 > 0 && c13 < 0) {
                ox[1] = p[2];
                ox[2] = p[3];
                ox[3] = p[1];
            } else if (c13 < 0 && c12 > 0) {
                ox[1] = p[3];
                ox[2] = p[1];
                ox[3] = p[2];
            } else if (c23 < 0 && c12 < 0) {
                ox[1] = p[3];
                ox[2] = p[2];
                ox[3] = p[1];
            }
        } else if (c12 > 0) {
            ox[1] = p[1];
            ox[2] = p[2];
        } else {
            ox[1] = p[2];
            ox[2] = p[1];
        }
        ox[0] = ref0;
        return ox;
    }

    private void stereoTransformation(int[] t, int[] ref) {
        int d = 0;
        if (ref[0] == t[1]) {
            d = t[0];
            t[0] = t[1];
            t[1] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        } else if (ref[0] == t[2]) {
            d = t[2];
            t[2] = t[0];
            t[0] = d;
            d = t[1];
            t[1] = t[3];
            t[3] = d;
        } else if (ref[0] == t[3]) {
            d = t[3];
            t[3] = t[0];
            t[0] = d;
            d = t[1];
            t[1] = t[2];
            t[2] = d;
        }
        if (ref[1] == t[2]) {
            d = t[1];
            t[1] = t[2];
            t[2] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        } else if (ref[1] == t[3]) {
            d = t[1];
            t[1] = t[3];
            t[3] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        }
    }

    private void stereoEZ(int bond, int[] ax, int[] slashBond, boolean[] isRingBond) {
        int bi;
        if (this.nasv[bond] != 2 || this.btype[bond] == 5) {
            return;
        }
        if (this.stereob[bond] != 10 && (!this.jme.autoez || isRingBond[bond])) {
            return;
        }
        int atom1 = this.va[bond];
        int atom2 = this.vb[bond];
        if (this.nv[atom1] < 2 || this.nv[atom2] < 2 || this.nv[atom1] > 3 || this.nv[atom2] > 3) {
            return;
        }
        if (ax[atom1] > ax[atom2]) {
            int d = atom1;
            atom1 = atom2;
            atom2 = d;
        }
        int ref1 = 0;
        int ref11 = 0;
        int ref12 = 0;
        boolean ref1x = false;
        for (int j = 1; j <= this.nv[atom1]; ++j) {
            int atomx = this.v[atom1][j];
            if (atomx == atom2) continue;
            if (ref11 == 0) {
                ref11 = atomx;
                continue;
            }
            ref12 = atomx;
        }
        if (ref12 > 0 && ax[ref11] > ax[ref12]) {
            int d = ref11;
            ref11 = ref12;
            ref12 = d;
        }
        if (slashBond[bi = this.bondIdentity(atom1, ref11)] != 0) {
            ref1 = ref11;
        } else if (this.nasv[bi] == 1 && this.btype[bi] != 5) {
            ref1 = ref11;
        }
        if (ref1 == 0) {
            bi = this.bondIdentity(atom1, ref12);
            if (slashBond[bi] != 0) {
                ref1 = ref12;
            } else if (this.nasv[bi] == 1 && this.btype[bi] != 5) {
                ref1 = ref12;
            }
        }
        if (ax[ref1] > ax[atom1]) {
            ref1x = true;
        }
        int ref2 = 0;
        int ref21 = 0;
        int ref22 = 0;
        for (int j = 1; j <= this.nv[atom2]; ++j) {
            int atomx = this.v[atom2][j];
            if (atomx == atom1) continue;
            if (ref21 == 0) {
                ref21 = atomx;
                continue;
            }
            ref22 = atomx;
        }
        if (ref22 > 0 && ax[ref21] < ax[ref22]) {
            int d = ref21;
            ref21 = ref22;
            ref22 = d;
        }
        if (this.nasv[bi = this.bondIdentity(atom2, ref21)] == 1 && this.btype[bi] != 5 && slashBond[bi] == 0) {
            ref2 = ref21;
        }
        if (ref2 == 0 && this.nasv[bi = this.bondIdentity(atom2, ref22)] == 1 && this.btype[bi] != 5) {
            ref2 = ref22;
        }
        if (ref1 == 0 || ref2 == 0) {
            return;
        }
        double dx = this.x[atom2] - this.x[atom1];
        double dy = this.y[atom2] - this.y[atom1];
        double rx = Math.sqrt(dx * dx + dy * dy);
        if (rx < 0.001) {
            rx = 0.001;
        }
        double sina = dy / rx;
        double cosa = dx / rx;
        double y1 = (this.y[ref1] - this.y[atom1]) * cosa - (this.x[ref1] - this.x[atom1]) * sina;
        double y2 = (this.y[ref2] - this.y[atom1]) * cosa - (this.x[ref2] - this.x[atom1]) * sina;
        if (Math.abs(y1) < 2.0 || Math.abs(y2) < 2.0) {
            this.jme.info("Not unique E/Z geometry !");
            return;
        }
        int b1 = this.bondIdentity(ref1, atom1);
        int b2 = this.bondIdentity(ref2, atom2);
        int newSlash = 1;
        if (slashBond[b1] == 0) {
            for (int j = 1; j <= this.nv[ref1]; ++j) {
                int atomx = this.v[ref1][j];
                if (atomx == atom1 || slashBond[bi = this.bondIdentity(ref1, atomx)] == 0) continue;
                if (ax[atomx] > ax[ref1]) {
                    newSlash = -slashBond[bi];
                    break;
                }
                newSlash = slashBond[bi];
                break;
            }
            slashBond[b1] = newSlash;
        }
        if (slashBond[b2] != 0) {
            System.err.println("E/Z internal error !");
            return;
        }
        slashBond[b2] = y1 > 0.0 && y2 > 0.0 || y1 < 0.0 && y2 < 0.0 ? -slashBond[b1] : slashBond[b1];
        if (ref1x) {
            slashBond[b2] = -slashBond[b2];
        }
    }

    private int compareAngles(double sina, double cosa, double sinb, double cosb) {
        int qa = 0;
        int qb = 0;
        if (sina >= 0.0 && cosa >= 0.0) {
            qa = 1;
        } else if (sina >= 0.0 && cosa < 0.0) {
            qa = 2;
        } else if (sina < 0.0 && cosa < 0.0) {
            qa = 3;
        } else if (sina < 0.0 && cosa >= 0.0) {
            qa = 4;
        }
        if (sinb >= 0.0 && cosb >= 0.0) {
            qb = 1;
        } else if (sinb >= 0.0 && cosb < 0.0) {
            qb = 2;
        } else if (sinb < 0.0 && cosb < 0.0) {
            qb = 3;
        } else if (sinb < 0.0 && cosb >= 0.0) {
            qb = 4;
        }
        if (qa < qb) {
            return 1;
        }
        if (qa > qb) {
            return -1;
        }
        switch (qa) {
            case 1: 
            case 4: {
                return sina < sinb ? 1 : -1;
            }
            case 2: 
            case 3: {
                return sina > sinb ? 1 : -1;
            }
        }
        System.err.println("stereowarning #31");
        return 0;
    }

    private int upDownBond(int bond, int atom) {
        int sb = this.stereob[bond];
        if (sb < 1 || sb > 4) {
            return 0;
        }
        if (sb == 1 && this.va[bond] == atom) {
            return 1;
        }
        if (sb == 2 && this.va[bond] == atom) {
            return -1;
        }
        if (sb == 3 && this.vb[bond] == atom) {
            return 1;
        }
        if (sb == 4 && this.vb[bond] == atom) {
            return -1;
        }
        return 0;
    }

    private void stereoAllene(int i, int[] ax, int[] slimak, int[] parent, int[] con1, int[] con2, int nconnections) {
        double sina;
        double cosa;
        double y2;
        int d;
        int bi;
        int atomx;
        int j;
        boolean ok;
        int nal = 1;
        int ala = i;
        int[] al = new int[this.natoms + 1];
        al[1] = i;
        block0: do {
            ok = false;
            for (int j2 = 1; j2 <= this.nv[ala]; ++j2) {
                int bi2;
                int atomx2 = this.v[ala][j2];
                if (atomx2 == al[1] || atomx2 == al[nal - 1] || this.nasv[bi2 = this.bondIdentity(ala, atomx2)] != 2 || this.btype[bi2] == 5) continue;
                al[++nal] = atomx2;
                ala = atomx2;
                ok = true;
                continue block0;
            }
        } while (ok);
        if (nal % 2 == 0) {
            return;
        }
        if (this.nv[al[nal]] < 2 || this.nv[al[nal]] > 3) {
            return;
        }
        int start = al[1];
        int center = al[(nal + 1) / 2];
        int end = al[nal];
        int ref11 = 0;
        int ref12 = 0;
        int ref21 = 0;
        int ref22 = 0;
        int ref1 = 0;
        int ref2 = 0;
        boolean ref1x = false;
        boolean ref2x = false;
        for (j = 1; j <= this.nv[start]; ++j) {
            atomx = this.v[start][j];
            bi = this.bondIdentity(start, atomx);
            if (this.nasv[bi] != 1 || this.btype[bi] == 5) continue;
            if (ref11 == 0) {
                ref11 = atomx;
                continue;
            }
            ref12 = atomx;
        }
        if (ax[ref12] > 0 && ax[ref11] > ax[ref12]) {
            d = ref11;
            ref11 = ref12;
            ref12 = d;
        }
        if ((ref1 = ref11) == 0) {
            ref1 = ref12;
            ref1x = true;
        }
        for (j = 1; j <= this.nv[end]; ++j) {
            atomx = this.v[end][j];
            bi = this.bondIdentity(end, atomx);
            if (this.nasv[bi] != 1 || this.btype[bi] == 5) continue;
            if (ref21 == 0) {
                ref21 = atomx;
                continue;
            }
            ref22 = atomx;
        }
        if (ax[ref22] > 0 && ax[ref21] > ax[ref22]) {
            d = ref21;
            ref21 = ref22;
            ref22 = d;
        }
        if ((ref2 = ref21) == 0) {
            ref2 = ref22;
            ref2x = true;
        }
        int ref11x = this.upDownBond(this.bondIdentity(start, ref11), start);
        int ref12x = this.upDownBond(this.bondIdentity(start, ref12), start);
        int ref21x = this.upDownBond(this.bondIdentity(end, ref21), end);
        int ref22x = this.upDownBond(this.bondIdentity(end, ref22), end);
        if (Math.abs(ref11x + ref12x) > 1 || ref21x != 0 || ref22x != 0) {
            this.jme.info("Bad stereoinfo on allene !");
            return;
        }
        double dx = this.x[al[nal - 1]] - this.x[end];
        double dy = this.y[al[nal - 1]] - this.y[end];
        double rx = Math.sqrt(dx * dx + dy * dy);
        if (rx < 0.001) {
            rx = 0.001;
        }
        slimak[center] = (y2 = (this.y[ref2] - this.y[al[nal - 1]]) * (cosa = dx / rx) - (this.x[ref2] - this.x[al[nal - 1]]) * (sina = dy / rx)) > 0.0 ? 1 : -1;
        if (ref1x) {
            int n = center;
            slimak[n] = slimak[n] * -1;
        }
        if (ref2x) {
            int n = center;
            slimak[n] = slimak[n] * -1;
        }
        if (ref1 == ref11 && ref11x < 0) {
            int n = center;
            slimak[n] = slimak[n] * -1;
        }
        if (ref1 == ref12 && ref12x < 0) {
            int n = center;
            slimak[n] = slimak[n] * -1;
        }
        if (ax[ref1] > ax[ref2]) {
            int n = center;
            slimak[n] = slimak[n] * -1;
        }
    }

    String createJME() {
        int i;
        String s = "" + this.natoms + " " + this.nbonds;
        double scale = 0.055999999999999994;
        for (i = 1; i <= this.natoms; ++i) {
            String z = this.getAtomLabel(i);
            if (this.jme.jmeh && this.nh[i] > 0) {
                z = z + "H";
                if (this.nh[i] > 1) {
                    z = z + this.nh[i];
                }
            }
            if (this.q[i] != 0) {
                z = this.q[i] > 0 ? z + "+" : z + "-";
                if (Math.abs(this.q[i]) > 1) {
                    z = z + Math.abs(this.q[i]);
                }
            }
            int lmark = -1;
            for (int j = 1; j <= this.nmarked; ++j) {
                if (this.mark[j][0] != i) continue;
                lmark = this.mark[j][1];
                break;
            }
            if (this.jme.star && this.abg[i] > 0) {
                lmark = 1;
            }
            if (lmark > -1) {
                z = z + ":" + lmark;
            }
            s = s + " " + z + " " + JMEmol.fformat(this.x[i] * scale, 0, 2) + " " + JMEmol.fformat(-this.y[i] * scale, 0, 2);
        }
        for (i = 1; i <= this.nbonds; ++i) {
            int d;
            int a1 = this.va[i];
            int a2 = this.vb[i];
            int nas = this.nasv[i];
            if (this.stereob[i] == 1) {
                nas = -1;
            } else if (this.stereob[i] == 2) {
                nas = -2;
            } else if (this.stereob[i] == 3) {
                nas = -1;
                d = a1;
                a1 = a2;
                a2 = d;
            } else if (this.stereob[i] == 4) {
                nas = -2;
                d = a1;
                a1 = a2;
                a2 = d;
            } else if (this.stereob[i] == 10) {
                nas = -5;
            }
            if (this.nasv[i] == 9) {
                nas = this.stereob[i];
            }
            s = s + " " + a1 + " " + a2 + " " + nas;
        }
        return s;
    }

    String createMolFile(String title) {
        int i;
        if (this.natoms == 0) {
            return "";
        }
        String s = "";
        s = title;
        if (s.length() > 79) {
            s = s.substring(0, 76) + "...";
        }
        s = s + "\n";
        s = s + PropertyManager.getSDFDateLine("JME2023.01", true);
        s = s + "JME 2023.01 " + new Date() + "\n";
        s = s + JMEmol.iformat(this.natoms, 3) + JMEmol.iformat(this.nbonds, 3);
        s = s + "  0  0  0  0  0  0  0  0999 V2000\n";
        double scale = 0.055999999999999994;
        double ymax = -1.7976931348623157E308;
        double xmin = Double.MAX_VALUE;
        for (i = 1; i <= this.natoms; ++i) {
            if (this.y[i] > ymax) {
                ymax = this.y[i];
            }
            if (!(this.x[i] < xmin)) continue;
            xmin = this.x[i];
        }
        for (i = 1; i <= this.natoms; ++i) {
            s = s + JMEmol.fformat((this.x[i] - xmin) * scale, 10, 4) + JMEmol.fformat((ymax - this.y[i]) * scale, 10, 4) + JMEmol.fformat(0.0, 10, 4);
            String z = this.getAtomLabel(i);
            if (z.length() == 1) {
                z = z + "  ";
            } else if (z.length() == 2) {
                z = z + " ";
            } else if (z.length() > 3) {
                z = "Q  ";
            }
            s = s + " " + z;
            int charge = 0;
            if (this.q[i] > 0 && this.q[i] < 4) {
                charge = 4 - this.q[i];
            } else if (this.q[i] < 0 && this.q[i] > -4) {
                charge = 4 - this.q[i];
            }
            z = " 0" + JMEmol.iformat(charge, 3) + "  0  0  0  0  0  0  0";
            int lmark = -1;
            for (int j = 1; j <= this.nmarked; ++j) {
                if (this.mark[j][0] != i) continue;
                lmark = this.mark[j][1];
                break;
            }
            z = lmark > -1 ? z + JMEmol.iformat(lmark, 3) : z + "  0";
            s = s + z + "  0  0" + "\n";
        }
        for (i = 1; i <= this.nbonds; ++i) {
            int nas = this.nasv[i];
            if (this.isSingle(i)) {
                nas = 1;
            } else if (this.isDouble(i)) {
                nas = 2;
            }
            String bonds = JMEmol.iformat(this.va[i], 3) + JMEmol.iformat(this.vb[i], 3);
            int stereo = 0;
            if (this.nasv[i] == 1 && this.stereob[i] == 1) {
                stereo = 1;
            } else if (this.nasv[i] == 1 && this.stereob[i] == 2) {
                stereo = 6;
            }
            if (this.nasv[i] == 1 && this.stereob[i] == 3) {
                stereo = 1;
                bonds = JMEmol.iformat(this.vb[i], 3) + JMEmol.iformat(this.va[i], 3);
            }
            if (this.nasv[i] == 1 && this.stereob[i] == 4) {
                stereo = 6;
                bonds = JMEmol.iformat(this.vb[i], 3) + JMEmol.iformat(this.va[i], 3);
            }
            s = s + bonds + JMEmol.iformat(nas, 3) + JMEmol.iformat(stereo, 3) + "  0  0  0" + "\n";
        }
        for (i = 1; i <= this.natoms; ++i) {
            if (this.q[i] == 0) continue;
            s = s + "M  CHG  1" + JMEmol.iformat(i, 4) + JMEmol.iformat(this.q[i], 4) + "\n";
        }
        s = s + "M  END\n";
        return s;
    }

    String createExtendedMolFile(String smiles) {
        int i;
        int i2;
        int chiral = 0;
        for (int i3 = 1; i3 <= this.nbonds; ++i3) {
            if (this.stereob[i3] == 0) continue;
            chiral = 1;
            break;
        }
        String mv30 = "M  V30 ";
        String s = "";
        s = smiles;
        if (s.length() > 79) {
            s = s.substring(0, 76) + "...";
        }
        s = s + "\n";
        s = s + PropertyManager.getSDFDateLine("JME2023.01", true) + "JME " + "2023.01" + " " + new Date() + "\n";
        s = s + "  0  0  0  0  0  0  0  0  0  0999 V3000\n";
        s = s + mv30 + "BEGIN CTAB" + "\n";
        s = s + mv30 + "COUNTS " + this.natoms + " " + this.nbonds + " 0 0 " + chiral + "\n";
        s = s + mv30 + "BEGIN ATOM" + "\n";
        double scale = 0.055999999999999994;
        double ymax = -1.7976931348623157E308;
        double xmin = Double.MAX_VALUE;
        for (i2 = 1; i2 <= this.natoms; ++i2) {
            if (this.y[i2] > ymax) {
                ymax = this.y[i2];
            }
            if (!(this.x[i2] < xmin)) continue;
            xmin = this.x[i2];
        }
        for (i2 = 1; i2 <= this.natoms; ++i2) {
            s = s + mv30;
            String z = this.getAtomLabel(i2);
            s = s + i2 + " " + z;
            int m = 0;
            int lmark = -1;
            for (int j = 1; j <= this.nmarked; ++j) {
                if (this.mark[j][0] != i2) continue;
                lmark = this.mark[j][1];
                break;
            }
            if (lmark > -1) {
                m = lmark;
            }
            s = s + " " + JMEmol.fformat((this.x[i2] - xmin) * scale, 0, 4) + " " + JMEmol.fformat((ymax - this.y[i2]) * scale, 0, 4) + " " + JMEmol.fformat(0.0, 0, 4) + " " + m;
            if (this.q[i2] != 0) {
                s = s + " CHG=" + this.q[i2];
            }
            s = s + "\n";
        }
        s = s + mv30 + "END ATOM" + "\n";
        s = s + mv30 + "BEGIN BOND" + "\n";
        for (i2 = 1; i2 <= this.nbonds; ++i2) {
            s = s + mv30 + i2;
            int nas = this.nasv[i2];
            if (this.isSingle(i2)) {
                nas = 1;
            } else if (this.isDouble(i2)) {
                nas = 2;
            }
            String bonds = this.va[i2] + " " + this.vb[i2];
            int stereo = 0;
            if (this.nasv[i2] == 1 && this.stereob[i2] == 1) {
                stereo = 1;
            } else if (this.nasv[i2] == 1 && this.stereob[i2] == 2) {
                stereo = 3;
            }
            if (this.nasv[i2] == 1 && this.stereob[i2] == 3) {
                stereo = 1;
                bonds = this.vb[i2] + " " + this.va[i2];
            }
            if (this.nasv[i2] == 1 && this.stereob[i2] == 4) {
                stereo = 3;
                bonds = this.vb[i2] + " " + this.va[i2];
            }
            s = s + " " + bonds + " " + nas;
            if (stereo != 0) {
                s = s + " CFG=" + stereo;
            }
            s = s + "\n";
        }
        s = s + mv30 + "END BOND" + "\n";
        ArrayList<Integer> abs = new ArrayList<Integer>();
        ArrayList orlists = new ArrayList();
        ArrayList mixlists = new ArrayList();
        for (i = 0; i < 10; ++i) {
            orlists.add(null);
            mixlists.add(null);
        }
        for (i = 1; i <= this.natoms; ++i) {
            ArrayList<Integer> l;
            ArrayList<Integer> o;
            int n;
            if (this.atag[i] == null || this.atag[i].length() == 0) continue;
            if (this.atag[i].equals("abs")) {
                abs.add(new Integer(i));
                continue;
            }
            if (this.atag[i].startsWith("mix")) {
                n = Integer.parseInt(this.atag[i].substring(3));
                o = null;
                if (mixlists.size() > n) {
                    o = (ArrayList)mixlists.get(n);
                }
                l = o == null ? new ArrayList<Integer>() : o;
                l.add(new Integer(i));
                mixlists.set(n, l);
                continue;
            }
            if (!this.atag[i].startsWith("or")) continue;
            n = Integer.parseInt(this.atag[i].substring(2));
            o = null;
            if (orlists.size() > n) {
                o = (ArrayList)orlists.get(n);
            }
            l = o == null ? new ArrayList<Integer>() : o;
            l.add(new Integer(i));
            orlists.set(n, l);
        }
        s = s + this.addCollection("MDLV30/STEABS", abs, mv30);
        if (orlists.size() > 0) {
            for (i = 1; i < orlists.size(); ++i) {
                s = s + this.addCollection("MDLV30/STEREL" + i, (ArrayList)orlists.get(i), mv30);
            }
        }
        if (mixlists.size() > 0) {
            for (i = 1; i < mixlists.size(); ++i) {
                s = s + this.addCollection("MDLV30/STERAC" + i, (ArrayList)mixlists.get(i), mv30);
            }
        }
        s = s + mv30 + "END CTAB" + "\n";
        s = s + "M  END\n";
        return s;
    }

    String addCollection(String name, ArrayList<Integer> list, String mv30) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String s = "";
        s = s + mv30 + "BEGIN COLLECTION" + "\n";
        s = s + mv30 + name + " [ATOMS=(" + list.size();
        Iterator<Integer> i = list.iterator();
        while (i.hasNext()) {
            s = s + " " + i.next();
        }
        s = s + ")]\n";
        s = s + mv30 + "END COLLECTION" + "\n";
        return s;
    }

    String getAtomLabel(int i) {
        String z = JME.zlabel[this.an[i]];
        if (this.an[i] == 18) {
            z = this.label[i];
        }
        return z;
    }

    static String iformat(int number, int len) {
        Integer n = new Integer(number);
        String s = n.toString();
        if (s.length() > len) {
            s = "?";
        }
        String space = "";
        for (int i = 1; i <= len - s.length(); ++i) {
            space = space + " ";
        }
        s = space + s;
        return s;
    }

    static String fformat(double number, int len, int dec) {
        String s;
        int dotpos;
        if (dec == 0) {
            return JMEmol.iformat((int)number, len);
        }
        if (Math.abs(number) < 9.0E-4) {
            number = 0.0;
        }
        if ((dotpos = (s = new Double(number = (double)((int)Math.round(number * Math.pow(10.0, dec))) / Math.pow(10.0, dec)).toString()).indexOf(46)) < 0) {
            s = s + ".";
            dotpos = s.indexOf(46);
        }
        int slen = s.length();
        for (int i = 1; i <= dec - slen + dotpos + 1; ++i) {
            s = s + "0";
        }
        if (len == 0) {
            return s;
        }
        if (s.length() > len) {
            s = "?";
        }
        String space = "";
        for (int i = 1; i <= len - s.length(); ++i) {
            space = space + " ";
        }
        s = space + s;
        return s;
    }

    static int checkAtomicSymbol(String s) {
        if (s.equals("C")) {
            return 3;
        }
        if (s.equals("B")) {
            return 2;
        }
        if (s.equals("N")) {
            return 4;
        }
        if (s.equals("O")) {
            return 5;
        }
        if (s.equals("P")) {
            return 7;
        }
        if (s.equals("S")) {
            return 8;
        }
        if (s.equals("F")) {
            return 9;
        }
        if (s.equals("Cl")) {
            return 10;
        }
        if (s.equals("Br")) {
            return 11;
        }
        if (s.equals("I")) {
            return 12;
        }
        if (s.equals("H")) {
            return 1;
        }
        if (s.equals("Se")) {
            return 13;
        }
        if (s.equals("Si")) {
            return 6;
        }
        if (s.equals("R")) {
            return 19;
        }
        if (s.equals("R1")) {
            return 20;
        }
        if (s.equals("R2")) {
            return 21;
        }
        if (s.equals("R3")) {
            return 22;
        }
        return 18;
    }

    void deleteHydrogens() {
        if (this.jme.keepHydrogens) {
            return;
        }
        block0: for (int i = this.natoms; i >= 1; --i) {
            int parent = this.v[i][1];
            if (this.an[i] != 1 || this.nv[i] != 1 || this.q[i] != 0 || this.an[parent] == 1 || this.an[parent] >= 18) continue;
            for (int j = 1; j <= this.nmarked; ++j) {
                if (this.mark[j][0] == i) continue block0;
            }
            int bi = this.bondIdentity(i, parent);
            if (this.nasv[bi] != 1 || this.stereob[bi] != 0 && this.jme.stereo) continue;
            this.deleteAtom(i);
        }
    }

    int bondIdentity(int atom1, int atom2) {
        for (int i = 1; i <= this.nbonds; ++i) {
            if (this.va[i] == atom1 && this.vb[i] == atom2) {
                return i;
            }
            if (this.va[i] != atom2 || this.vb[i] != atom1) continue;
            return i;
        }
        return 0;
    }

    boolean isSingle(int bond) {
        return this.nasv[bond] == 1;
    }

    private boolean isDouble(int bond) {
        return this.nasv[bond] == 2;
    }

    void valenceState() {
        for (int i = 1; i <= this.natoms; ++i) {
            this.atomValenceState(i);
        }
    }

    void atomValenceState(int i) {
        int sbo = this.sumBondOrders(i);
        if (sbo == -1) {
            this.nh[i] = 0;
            return;
        }
        switch (this.an[i]) {
            case 1: {
                this.q[i] = sbo == 2 ? 1 : 0;
                this.nh[i] = 0;
                break;
            }
            case 2: {
                if (sbo == 3 || sbo == 5) {
                    this.nh[i] = 0;
                    this.q[i] = 0;
                    break;
                }
                if (sbo < 3) {
                    this.nh[i] = 3 - sbo - this.q[i];
                    break;
                }
                if (sbo == 4) {
                    this.q[i] = -1;
                    this.nh[i] = 0;
                    break;
                }
                if (sbo <= 5) break;
                this.q[i] = sbo - 5;
                this.nh[i] = 0;
                break;
            }
            case 3: 
            case 6: {
                if (sbo < 4) {
                    if (this.q[i] > 0) {
                        this.nh[i] = 2 - sbo + this.q[i];
                        break;
                    }
                    if (this.q[i] < 0) {
                        this.nh[i] = 2 - sbo - this.q[i];
                        break;
                    }
                    this.nh[i] = 4 - sbo;
                    break;
                }
                this.q[i] = sbo - 4;
                this.nh[i] = 4 - sbo + this.q[i];
                break;
            }
            case 4: 
            case 7: {
                if (sbo < 3) {
                    this.nh[i] = 3 - sbo + this.q[i];
                    break;
                }
                if (sbo == 3) {
                    if (this.q[i] < 0) {
                        this.q[i] = 0;
                        this.nh[i] = 0;
                        break;
                    }
                    if (this.q[i] > 0) {
                        this.nh[i] = this.q[i];
                        break;
                    }
                    this.nh[i] = 3 - sbo;
                    break;
                }
                if (sbo == 4) {
                    this.q[i] = 1;
                    this.nh[i] = 0;
                    break;
                }
                if (sbo == 6) {
                    this.q[i] = -1;
                    this.nh[i] = 0;
                    break;
                }
                this.q[i] = sbo - 5;
                this.nh[i] = 0;
                break;
            }
            case 5: {
                if (sbo == 2) {
                    if (this.q[i] < 0) {
                        this.q[i] = 0;
                        this.nh[i] = 0;
                    } else {
                        this.nh[i] = this.q[i] > 0 ? this.q[i] : 2 - sbo;
                    }
                }
                if (sbo > 2) {
                    this.q[i] = sbo - 2;
                }
                this.nh[i] = 2 - sbo + this.q[i];
                break;
            }
            case 8: 
            case 13: {
                if (sbo < 2) {
                    this.nh[i] = 2 - sbo + this.q[i];
                    break;
                }
                if (sbo == 2) {
                    if (this.q[i] < 0) {
                        this.q[i] = 0;
                        this.nh[i] = 0;
                        break;
                    }
                    if (this.q[i] > 0) {
                        this.nh[i] = this.q[i];
                        break;
                    }
                    this.nh[i] = 2 - sbo;
                    break;
                }
                if (sbo == 3) {
                    if (this.nv[i] == 2) {
                        this.q[i] = 0;
                        this.nh[i] = 1;
                        break;
                    }
                    this.q[i] = 1;
                    this.nh[i] = 0;
                    break;
                }
                if (sbo == 4) {
                    this.q[i] = 0;
                    this.nh[i] = 0;
                    break;
                }
                if (sbo == 5) {
                    this.q[i] = 0;
                    this.nh[i] = 1;
                    break;
                }
                this.q[i] = sbo - 6;
                this.nh[i] = 0;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (sbo >= 1) {
                    this.q[i] = sbo - 1;
                }
                this.nh[i] = 1 - sbo + this.q[i];
                if (sbo <= 2) break;
                this.q[i] = 0;
                this.nh[i] = 0;
                break;
            }
            case 18: 
            case 19: {
                this.nh[i] = 0;
            }
        }
        if (this.nh[i] < 0) {
            this.nh[i] = 0;
        }
        if (this.jme.relativeStereo && this.atag[i] != null && this.atag[i].length() > 0) {
            boolean ok = false;
            for (int j = 1; j <= this.nv[i]; ++j) {
                int bond = this.bondIdentity(i, this.v[i][j]);
                if (i == this.va[bond] && (this.stereob[bond] == 1 || this.stereob[bond] == 2)) {
                    ok = true;
                    break;
                }
                if (i != this.vb[bond] || this.stereob[bond] != 3 && this.stereob[bond] != 4) continue;
                ok = true;
                break;
            }
            if (!ok) {
                this.atag[i] = "";
            }
        }
    }

    void changeCharge(int atom, int type) {
        String np = "Charge change not possible on ";
        if (type == 1) {
            int n = atom;
            this.q[n] = this.q[n] + 1;
            return;
        }
        if (type == -1) {
            int n = atom;
            this.q[n] = this.q[n] - 1;
            return;
        }
        int sbo = this.sumBondOrders(atom);
        if (sbo == -1 && type == 0) {
            if (this.q[atom] == 0) {
                this.q[atom] = 1;
            } else if (this.q[atom] == 1) {
                this.q[atom] = -1;
            } else if (this.q[atom] == -1) {
                this.q[atom] = 0;
            }
        }
        switch (this.an[atom]) {
            case 2: {
                if (sbo > 2) {
                    this.jme.info(np + "this boron !");
                }
                if (this.q[atom] == 0) {
                    this.q[atom] = 1;
                    break;
                }
                if (this.q[atom] != 1) break;
                this.q[atom] = 0;
                break;
            }
            case 3: {
                if (sbo > 3) {
                    this.jme.info(np + "this carbon !");
                    break;
                }
                if (sbo >= 4) break;
                if (this.q[atom] == 0) {
                    this.q[atom] = -1;
                    break;
                }
                if (this.q[atom] == -1) {
                    this.q[atom] = 1;
                    break;
                }
                if (this.q[atom] != 1) break;
                this.q[atom] = 0;
                break;
            }
            case 4: 
            case 7: {
                if (sbo > 3) {
                    this.jme.info(np + "multibonded N or P !");
                    break;
                }
                if (sbo == 3 && this.q[atom] == 0) {
                    this.q[atom] = 1;
                    break;
                }
                if (sbo == 3 && this.q[atom] == 1) {
                    this.q[atom] = 0;
                    break;
                }
                if (sbo < 3 && this.q[atom] == 0) {
                    this.q[atom] = 1;
                    break;
                }
                if (sbo < 3 && this.q[atom] == 1) {
                    this.q[atom] = -1;
                    break;
                }
                if (sbo >= 3 || this.q[atom] != -1) break;
                this.q[atom] = 0;
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                if (sbo > 2) {
                    this.jme.info(np + "multibonded O or S !");
                    break;
                }
                if (sbo == 2 && this.q[atom] == 0) {
                    this.q[atom] = 1;
                    break;
                }
                if (sbo == 2 && this.q[atom] == 1) {
                    this.q[atom] = 0;
                    break;
                }
                if (sbo < 2 && this.q[atom] == 0) {
                    this.q[atom] = -1;
                    break;
                }
                if (sbo < 2 && this.q[atom] == -1) {
                    this.q[atom] = 1;
                    break;
                }
                if (sbo >= 2 || this.q[atom] != 1) break;
                this.q[atom] = 0;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (sbo == 0 && this.q[atom] == 0) {
                    this.q[atom] = -1;
                    break;
                }
                if (sbo == 0 && this.q[atom] == -1) {
                    this.q[atom] = 0;
                    break;
                }
                this.jme.info(np + "the halogen !");
                break;
            }
            case 18: {
                this.jme.info("Use X button to change charge on the X atom !");
            }
        }
    }

    int sumBondOrders(int atom) {
        int sbo = 0;
        for (int i = 1; i <= this.nv[atom]; ++i) {
            int bond = this.bondIdentity(atom, this.v[atom][i]);
            if (this.isSingle(bond)) {
                ++sbo;
                continue;
            }
            if (this.isDouble(bond)) {
                sbo += 2;
                continue;
            }
            if (this.nasv[bond] == 3) {
                sbo += 3;
                continue;
            }
            if (this.nasv[bond] != 9) continue;
            return -1;
        }
        return sbo;
    }

    public void mark() {
        this.jme.markUsed = true;
        if (this.jme.star) {
            this.doColoring = -1;
            this.abg[this.touchedAtom] = this.abg[this.touchedAtom] == 0 ? 4 : 0;
            return;
        }
        for (int i = 1; i <= this.nmarked; ++i) {
            if (this.touchedAtom != this.mark[i][0]) continue;
            if (this.jme.currentMark == -1) {
                for (int j = i; j < this.nmarked; ++j) {
                    this.mark[j][0] = this.mark[j + 1][0];
                    this.mark[j][1] = this.mark[j + 1][1];
                }
                --this.nmarked;
            } else {
                int n = this.jme.currentMark;
                if (this.jme.autonumber) {
                    if (!this.jme.mouseShift) {
                        ++this.maxMark;
                    }
                    n = this.maxMark;
                }
                this.mark[i][1] = n;
            }
            return;
        }
        int storage = this.mark.length;
        if (++this.nmarked > storage - 1) {
            int[][] n_m = new int[storage + 5][2];
            System.arraycopy(this.mark, 0, n_m, 0, this.mark.length);
            this.mark = n_m;
        }
        this.mark[this.nmarked][0] = this.touchedAtom;
        int n = this.jme.currentMark;
        if (this.jme.autonumber) {
            if (!this.jme.mouseShift) {
                ++this.maxMark;
            }
            n = this.maxMark;
        }
        this.mark[this.nmarked][1] = n;
    }

    public void numberAtoms() {
        this.nmarked = 0;
        this.maxMark = 0;
        this.createSmiles();
        int i = 1;
        while (i <= this.natoms) {
            this.touchedAtom = i++;
            this.mark();
        }
        this.touchedAtom = 0;
    }

    public void setLabel(int n, String s) {
        if (this.label == null || this.label.length < this.natoms + 1) {
            this.label = new String[this.natoms + 1];
        }
        this.label[n] = s;
    }

    public int reactionPart() {
        double[] center = new double[4];
        this.centerPoint(center);
        int xpix = this.jme.dimension.width;
        if (!this.jme.depict) {
            xpix -= this.jme.sd;
        }
        if (center[0] < (double)(xpix / 2 - this.jme.arrowWidth / 2)) {
            return 1;
        }
        if (center[0] > (double)(xpix / 2 + this.jme.arrowWidth / 2)) {
            return 3;
        }
        return 2;
    }

    private static long[] generatePrimes(int n) {
        long[] pn = new long[n + 2];
        int[] prime = new int[100];
        int index = 0;
        int num = 0;
        boolean check = true;
        prime[0] = 3;
        pn[1] = 2L;
        pn[2] = 3L;
        int npn = 2;
        if (n < 3) {
            return pn;
        }
        for (int test = 5; test < prime[num] * prime[num]; test += 2) {
            index = 0;
            check = true;
            while (check && index <= num && test >= prime[index] * prime[index]) {
                if (test % prime[index] == 0) {
                    check = false;
                    continue;
                }
                ++index;
            }
            if (!check) continue;
            pn[++npn] = test;
            if (npn >= n) {
                return pn;
            }
            if (num >= prime.length - 1) continue;
            prime[++num] = test;
        }
        System.err.println("ERROR - Prime Number generator failed !");
        return pn;
    }

    public double[][] saveXY() {
        double[] x = new double[this.natoms + 1];
        double[] y = new double[this.natoms + 1];
        System.arraycopy(this.x, 1, x, 1, this.natoms);
        System.arraycopy(this.y, 1, y, 1, this.natoms);
        return new double[][]{x, y};
    }

    public void restoreXY(double[][] xy) {
        System.arraycopy(xy[0], 1, this.x, 1, this.natoms);
        System.arraycopy(xy[1], 1, this.y, 1, this.natoms);
    }
}

