/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.TreeConsistencyError;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.IrTreeSymbolsVisitor;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001BA\u00120\u0010\u0002\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010&\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0016J\u001a\u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u001eH\u0002J\"\u00100\u001a\u00020\b2\u0006\u0010&\u001a\u00020.2\b\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020\u001eH\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005H\u0002R;\u0010\u0002\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0019j\b\u0012\u0004\u0012\u00020\u0005`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/common/CheckTreeConsistencyVisitor;", "Lorg/jetbrains/kotlin/ir/util/IrTreeSymbolsVisitor;", "reportError", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "", "Lorg/jetbrains/kotlin/backend/common/ReportIrValidationError;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "<init>", "(Lkotlin/jvm/functions/Function4;Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;)V", "getReportError", "()Lkotlin/jvm/functions/Function4;", "getConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "hasInconsistency", "", "getHasInconsistency", "()Z", "setHasInconsistency", "(Z)V", "visitedElements", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "parentChain", "", "currentActualParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitElement", "element", "visitTypeRecursively", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "visitSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "handleParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "actualParent", "reportWrongParent", "expectedParent", "checkDuplicateNode", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/CheckTreeConsistencyVisitor\n+ 2 Utils.kt\norg/jetbrains/kotlin/backend/common/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,602:1\n24#2,6:603\n24#2,6:611\n1869#3,2:609\n*S KotlinDebug\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/CheckTreeConsistencyVisitor\n*L\n375#1:603,6\n395#1:611,6\n385#1:609,2\n*E\n"})
final class CheckTreeConsistencyVisitor
extends IrTreeSymbolsVisitor {
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;
    @NotNull
    private final IrValidatorConfig config;
    private boolean hasInconsistency;
    @NotNull
    private final HashSet<IrElement> visitedElements;
    @NotNull
    private final List<IrElement> parentChain;
    @Nullable
    private IrDeclarationParent currentActualParent;

    public CheckTreeConsistencyVisitor(@NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError, @NotNull IrValidatorConfig config) {
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.reportError = reportError;
        this.config = config;
        this.visitedElements = new HashSet();
        this.parentChain = new ArrayList();
    }

    @NotNull
    public final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    public final boolean getHasInconsistency() {
        return this.hasInconsistency;
    }

    public final void setHasInconsistency(boolean bl) {
        this.hasInconsistency = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull IrElement element) {
        void $this$temporarilyPushing$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.checkDuplicateNode(element);
        List<IrElement> list = this.parentChain;
        IrElement element$iv = element;
        boolean $i$f$temporarilyPushing = false;
        UtilsKt.push($this$temporarilyPushing$iv, element$iv);
        IrElement it = element$iv;
        boolean bl = false;
        IrVisitorsKt.acceptChildrenVoid(element, this);
        Unit result$iv = Unit.INSTANCE;
        UtilsKt.pop($this$temporarilyPushing$iv);
    }

    @Override
    public void visitTypeRecursively(@NotNull IrElement container, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.visitType(container, type);
        if (type instanceof IrSimpleType) {
            Iterable $this$forEach$iv = ((IrSimpleType)type).getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeArgument it = (IrTypeArgument)element$iv;
                boolean bl = false;
                if (!(it instanceof IrTypeProjection)) continue;
                this.visitTypeRecursively(container, ((IrTypeProjection)it).getType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        void $this$temporarilyPushing$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkDuplicateNode(declaration);
        List<IrElement> list = this.parentChain;
        IrDeclarationBase element$iv = declaration;
        boolean $i$f$temporarilyPushing = false;
        UtilsKt.push($this$temporarilyPushing$iv, element$iv);
        IrElement it = element$iv;
        boolean bl = false;
        this.handleParent(declaration, this.currentActualParent);
        IrDeclarationParent previousActualParent = this.currentActualParent;
        IrDeclarationParent irDeclarationParent = declaration instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = this.currentActualParent;
        }
        this.currentActualParent = irDeclarationParent;
        IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
        this.currentActualParent = previousActualParent;
        Unit result$iv = Unit.INSTANCE;
        UtilsKt.pop($this$temporarilyPushing$iv);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.currentActualParent = declaration;
        this.visitElement(declaration);
    }

    @Override
    public void visitSymbol(@NotNull IrElement container, @NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (this.config.getCheckUnboundSymbols() && !symbol.isBound()) {
            this.hasInconsistency = true;
            this.reportError.invoke(null, (Object)container, (Object)"Unexpected unbound symbol", this.parentChain);
        }
    }

    private final void handleParent(IrDeclaration declaration, IrDeclarationParent actualParent) {
        if (actualParent == null) {
            return;
        }
        try {
            IrDeclarationParent assignedParent = declaration.getParent();
            if (!Intrinsics.areEqual((Object)assignedParent, (Object)actualParent)) {
                this.reportWrongParent(declaration, assignedParent, actualParent);
            }
        }
        catch (Exception exception) {
            this.reportWrongParent(declaration, null, actualParent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportWrongParent(IrDeclaration declaration, IrDeclarationParent expectedParent, IrDeclarationParent actualParent) {
        void $this$reportWrongParent_u24lambda_u240;
        StringBuilder stringBuilder;
        this.hasInconsistency = true;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrDeclaration irDeclaration = declaration;
        Object var8_7 = null;
        Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> function4 = this.reportError;
        boolean bl = false;
        $this$reportWrongParent_u24lambda_u240.append("Declaration with wrong parent:").append('\n');
        $this$reportWrongParent_u24lambda_u240.append("declaration: " + RenderIrElementKt.render$default(declaration, null, 1, null)).append('\n');
        IrDeclarationParent irDeclarationParent = expectedParent;
        $this$reportWrongParent_u24lambda_u240.append("expectedParent: " + (irDeclarationParent != null ? RenderIrElementKt.render$default(irDeclarationParent, null, 1, null) : null)).append('\n');
        $this$reportWrongParent_u24lambda_u240.append("actualParent: " + RenderIrElementKt.render$default(actualParent, null, 1, null)).append('\n');
        Unit unit = Unit.INSTANCE;
        function4.invoke(var8_7, (Object)irDeclaration, (Object)stringBuilder.toString(), this.parentChain);
    }

    private final void checkDuplicateNode(IrElement element) {
        if (!this.visitedElements.add(element)) {
            String renderString = element instanceof IrTypeParameter ? RenderIrElementKt.render$default(element, null, 1, null) + " of " + RenderIrElementKt.render$default(((IrTypeParameter)element).getParent(), null, 1, null) : RenderIrElementKt.render$default(element, null, 1, null);
            this.reportError.invoke(null, (Object)element, (Object)("Duplicate IR node: " + renderString), this.parentChain);
            throw new TreeConsistencyError(element);
        }
    }
}

