/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.FunctionSemantics;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.DefaultAnalysisSchemaKt;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.ExpectedTypeData;
import org.gradle.internal.declarativedsl.analysis.ExpressionResolver;
import org.gradle.internal.declarativedsl.analysis.FunctionCallResolver;
import org.gradle.internal.declarativedsl.analysis.NamedReferenceResolver;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.PropertyReferenceResolution;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.analysis.StatementResolver;
import org.gradle.internal.declarativedsl.analysis.TypedOrigin;
import org.gradle.internal.declarativedsl.analysis.UtilsKt;
import org.gradle.internal.declarativedsl.language.Assignment;
import org.gradle.internal.declarativedsl.language.AugmentingAssignment;
import org.gradle.internal.declarativedsl.language.DataStatement;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.FunctionCall;
import org.gradle.internal.declarativedsl.language.LocalValue;
import org.gradle.internal.declarativedsl.language.NamedReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JB\u0010\u001b\u001a\u0004\u0018\u00010\r*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001a2\u001a\u0010!\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010\r0\"H\u0002J\u0014\u0010%\u001a\u00020\u0015*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/StatementResolverImpl;", "Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;", "namedReferenceResolver", "Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;", "functionCallResolver", "Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;", "expressionResolver", "Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;", "errorCollector", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "<init>", "(Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;)V", "doResolveAssignment", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "assignment", "Lorg/gradle/internal/declarativedsl/language/Assignment;", "doResolveAugmentingAssignment", "Lorg/gradle/internal/declarativedsl/language/AugmentingAssignment;", "doResolveLocalValue", "", "localValue", "Lorg/gradle/internal/declarativedsl/language/LocalValue;", "doResolveExpressionStatement", "expr", "Lorg/gradle/internal/declarativedsl/language/Expr;", "doAnalyzeAssignmentLikeStatement", "statement", "Lorg/gradle/internal/declarativedsl/language/DataStatement;", "lhs", "Lorg/gradle/internal/declarativedsl/language/NamedReference;", "rhs", "doRecordAssignment", "Lkotlin/Function2;", "Lorg/gradle/internal/declarativedsl/analysis/PropertyReferenceResolution;", "Lorg/gradle/internal/declarativedsl/analysis/TypedOrigin;", "doAnalyzeLocal", "isDanglingPureCall", "", "obj", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$FunctionOrigin;", "declarative-dsl-core"})
public final class StatementResolverImpl
implements StatementResolver {
    @NotNull
    private final NamedReferenceResolver namedReferenceResolver;
    @NotNull
    private final FunctionCallResolver functionCallResolver;
    @NotNull
    private final ExpressionResolver expressionResolver;
    @NotNull
    private final ErrorCollector errorCollector;

    public StatementResolverImpl(@NotNull NamedReferenceResolver namedReferenceResolver, @NotNull FunctionCallResolver functionCallResolver, @NotNull ExpressionResolver expressionResolver, @NotNull ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)namedReferenceResolver, (String)"namedReferenceResolver");
        Intrinsics.checkNotNullParameter((Object)functionCallResolver, (String)"functionCallResolver");
        Intrinsics.checkNotNullParameter((Object)expressionResolver, (String)"expressionResolver");
        Intrinsics.checkNotNullParameter((Object)errorCollector, (String)"errorCollector");
        this.namedReferenceResolver = namedReferenceResolver;
        this.functionCallResolver = functionCallResolver;
        this.expressionResolver = expressionResolver;
        this.errorCollector = errorCollector;
    }

    @Override
    @Nullable
    public AssignmentRecord doResolveAssignment(@NotNull AnalysisContext context, @NotNull Assignment assignment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        return this.doAnalyzeAssignmentLikeStatement(context, assignment, assignment.getLhs(), assignment.getRhs(), (Function2<? super PropertyReferenceResolution, ? super TypedOrigin, AssignmentRecord>)((Function2)(arg_0, arg_1) -> StatementResolverImpl.doResolveAssignment$lambda$0(context, assignment, arg_0, arg_1)));
    }

    @Override
    @Nullable
    public AssignmentRecord doResolveAugmentingAssignment(@NotNull AnalysisContext context, @NotNull AugmentingAssignment assignment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        return this.doAnalyzeAssignmentLikeStatement(context, assignment, assignment.getLhs(), assignment.getRhs(), (Function2<? super PropertyReferenceResolution, ? super TypedOrigin, AssignmentRecord>)((Function2)(arg_0, arg_1) -> StatementResolverImpl.doResolveAugmentingAssignment$lambda$0(assignment, this, context, arg_0, arg_1)));
    }

    @Override
    public void doResolveLocalValue(@NotNull AnalysisContext context, @NotNull LocalValue localValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localValue, (String)"localValue");
        this.doAnalyzeLocal(context, localValue);
    }

    @Override
    public void doResolveExpressionStatement(@NotNull AnalysisContext context, @NotNull Expr expr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        TypedOrigin resolvedExpr = this.expressionResolver.doResolveExpression(context, expr, ExpectedTypeData.NoExpectedType.INSTANCE);
        if (expr instanceof FunctionCall) {
            ObjectOrigin objectOrigin;
            TypedOrigin typedOrigin = resolvedExpr;
            ObjectOrigin objectOrigin2 = objectOrigin = typedOrigin != null ? typedOrigin.getObjectOrigin() : null;
            if (objectOrigin instanceof ObjectOrigin.FunctionOrigin && this.isDanglingPureCall((ObjectOrigin.FunctionOrigin)objectOrigin)) {
                this.errorCollector.collect(new ResolutionError(expr, ErrorReason.DanglingPureExpression.INSTANCE));
            }
        } else {
            this.errorCollector.collect(new ResolutionError(expr, ErrorReason.DanglingPureExpression.INSTANCE));
        }
    }

    private final AssignmentRecord doAnalyzeAssignmentLikeStatement(AnalysisContext $this$doAnalyzeAssignmentLikeStatement, DataStatement statement, NamedReference lhs, Expr rhs, Function2<? super PropertyReferenceResolution, ? super TypedOrigin, AssignmentRecord> doRecordAssignment) {
        AssignmentRecord assignmentRecord;
        PropertyReferenceResolution lhsResolution = this.namedReferenceResolver.doResolveNamedReferenceToAssignable($this$doAnalyzeAssignmentLikeStatement, lhs);
        if (lhsResolution == null) {
            $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(lhs, new ErrorReason.UnresolvedReference(lhs)));
            $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, ErrorReason.UnresolvedAssignmentLhs.INSTANCE));
            assignmentRecord = null;
        } else {
            TypedOrigin rhsResolution;
            boolean hasErrors = false;
            if (DefaultAnalysisSchemaKt.isReadOnly(lhsResolution.getProperty())) {
                $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, new ErrorReason.ReadOnlyPropertyAssignment(lhsResolution.getProperty())));
                hasErrors = true;
            }
            if ((rhsResolution = this.expressionResolver.doResolveExpression($this$doAnalyzeAssignmentLikeStatement, rhs, new ExpectedTypeData.ExpectedByProperty(lhsResolution.getProperty().getValueType()))) == null) {
                $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, ErrorReason.UnresolvedAssignmentRhs.INSTANCE));
                assignmentRecord = null;
            } else {
                Map typeSubstitution;
                Map map;
                DataType rhsType = rhsResolution.getInferredType();
                DataType lhsExpectedType = $this$doAnalyzeAssignmentLikeStatement.resolveRef(lhsResolution.getProperty().getValueType());
                if (rhsType instanceof DataType.UnitType) {
                    $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, ErrorReason.UnitAssignment.INSTANCE));
                    hasErrors = true;
                }
                if ((map = UtilsKt.computeGenericTypeSubstitution($this$doAnalyzeAssignmentLikeStatement, DefaultAnalysisSchemaKt.getRef(lhsExpectedType), DefaultAnalysisSchemaKt.getRef(rhsType))) == null) {
                    map = MapsKt.emptyMap();
                }
                if (!UtilsKt.checkIsAssignable($this$doAnalyzeAssignmentLikeStatement, rhsType, lhsExpectedType, typeSubstitution = map)) {
                    $this$doAnalyzeAssignmentLikeStatement.getErrorCollector().collect(new ResolutionError(statement, new ErrorReason.AssignmentTypeMismatch(lhsExpectedType, rhsType)));
                    hasErrors = true;
                }
                assignmentRecord = !hasErrors ? (AssignmentRecord)doRecordAssignment.invoke((Object)lhsResolution, (Object)rhsResolution) : null;
            }
        }
        return assignmentRecord;
    }

    private final void doAnalyzeLocal(AnalysisContext $this$doAnalyzeLocal, LocalValue localValue) {
        TypedOrigin rhs = this.expressionResolver.doResolveExpression($this$doAnalyzeLocal, localValue.getRhs(), ExpectedTypeData.NoExpectedType.INSTANCE);
        if (rhs == null) {
            $this$doAnalyzeLocal.getErrorCollector().collect(new ResolutionError(localValue, ErrorReason.UnresolvedAssignmentRhs.INSTANCE));
        } else {
            if (rhs.getInferredType() instanceof DataType.UnitType) {
                $this$doAnalyzeLocal.getErrorCollector().collect(new ResolutionError(localValue, ErrorReason.UnitAssignment.INSTANCE));
            }
            ((AnalysisScope)CollectionsKt.last($this$doAnalyzeLocal.getCurrentScopes())).declareLocal(localValue, rhs.getObjectOrigin(), $this$doAnalyzeLocal.getErrorCollector());
        }
    }

    private final boolean isDanglingPureCall(ObjectOrigin.FunctionOrigin obj) {
        return obj.getFunction().getSemantics() instanceof FunctionSemantics.Pure ? true : (obj instanceof ObjectOrigin.BuilderReturnedReceiver ? !StatementResolverImpl.isDanglingPureCall$isPotentiallyPersistentReceiver(((ObjectOrigin.BuilderReturnedReceiver)obj).getReceiver()) : false);
    }

    private static final AssignmentRecord doResolveAssignment$lambda$0(AnalysisContext $context, Assignment $assignment, PropertyReferenceResolution lhsResolution, TypedOrigin rhsResolution) {
        Intrinsics.checkNotNullParameter((Object)lhsResolution, (String)"lhsResolution");
        Intrinsics.checkNotNullParameter((Object)rhsResolution, (String)"rhsResolution");
        return $context.recordAssignment(lhsResolution, rhsResolution, AssignmentMethod.Property.INSTANCE, $assignment);
    }

    private static final AssignmentRecord doResolveAugmentingAssignment$lambda$0(AugmentingAssignment $assignment, StatementResolverImpl this$0, AnalysisContext $context, PropertyReferenceResolution lhsResolution, TypedOrigin rhsResolution) {
        AssignmentRecord assignmentRecord;
        Intrinsics.checkNotNullParameter((Object)lhsResolution, (String)"lhsResolution");
        Intrinsics.checkNotNullParameter((Object)rhsResolution, (String)"rhsResolution");
        ObjectOrigin.PropertyReference augmentedProperty = new ObjectOrigin.PropertyReference(lhsResolution.getReceiverObject(), lhsResolution.getProperty(), $assignment.getLhs());
        TypedOrigin augmentationCallResult = this$0.functionCallResolver.doResolveAugmentation(augmentedProperty, rhsResolution, $context, $assignment.getAugmentationKind(), $assignment);
        if (augmentationCallResult != null) {
            ObjectOrigin.AugmentationOrigin augmentedOrigin = new ObjectOrigin.AugmentationOrigin(augmentedProperty, rhsResolution.getObjectOrigin(), $assignment.getAugmentationKind(), augmentationCallResult.getObjectOrigin(), $assignment);
            assignmentRecord = $context.recordAugmentingAssignment(lhsResolution, augmentedOrigin, $assignment);
        } else {
            DataType propertyType = $context.resolveRef(lhsResolution.getProperty().getValueType());
            this$0.errorCollector.collect(new ResolutionError($assignment, new ErrorReason.AugmentingAssignmentNotResolved(propertyType)));
            assignmentRecord = null;
        }
        return assignmentRecord;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isDanglingPureCall$isPotentiallyPersistentReceiver(ObjectOrigin objectOrigin) {
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.AccessAndConfigureReceiver) {
            return true;
        }
        if (objectOrigin2 instanceof ObjectOrigin.ImplicitThisReceiver) {
            return true;
        }
        if (objectOrigin2 instanceof ObjectOrigin.FromLocalValue) {
            return true;
        }
        if (!(objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin)) {
            if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.EnumConstantOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.GroupedVarargValue) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.External) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.FunctionOrigin) {
                FunctionSemantics semantics = ((ObjectOrigin.FunctionOrigin)objectOrigin).getFunction().getSemantics();
                FunctionSemantics functionSemantics = semantics;
                if (functionSemantics instanceof FunctionSemantics.Builder) {
                    throw new IllegalStateException("should be impossible?".toString());
                }
                if (functionSemantics instanceof FunctionSemantics.AccessAndConfigure) {
                    return true;
                }
                if (functionSemantics instanceof FunctionSemantics.AddAndConfigure) {
                    return true;
                }
                if (!(functionSemantics instanceof FunctionSemantics.Pure)) throw new NoWhenBranchMatchedException();
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
                return true;
            }
            if (!(objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor)) throw new NoWhenBranchMatchedException();
            return true;
        }
        boolean bl = StatementResolverImpl.isDanglingPureCall$isPotentiallyPersistentReceiver(((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        return bl;
    }
}

