/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOListener;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.utils.CommonUtils;

public class DBFResourceListener
implements EFSNIOListener {
    private static final Log log = Log.getLog(DBFResourceListener.class);
    private final DBNFileSystems fileSystems;

    public DBFResourceListener(DBNFileSystems fileSystems) {
        this.fileSystems = fileSystems;
    }

    @Override
    public void resourceChanged(EFSNIOResource resource, EFSNIOListener.Action action) {
        RCPProject rcpProject;
        DBPProject dBPProject = this.fileSystems.getOwnerProject();
        if (!(dBPProject instanceof RCPProject) || !CommonUtils.equalObjects((Object)(rcpProject = (RCPProject)dBPProject).getEclipseProject(), (Object)resource.getProject())) {
            return;
        }
        if (this.fileSystems.getCachedChildren() == null) {
            return;
        }
        DBFVirtualFileSystemRoot dbfRoot = resource.getRoot().getRoot();
        DBNFileSystem[] dBNFileSystemArray = this.fileSystems.getCachedChildren();
        int n = dBNFileSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fs = dBNFileSystemArray[n2];
            if (CommonUtils.equalObjects((Object)fs.getFileSystem(), (Object)dbfRoot.getFileSystem())) {
                DBNFileSystemRoot rootNode = fs.getRoot(dbfRoot);
                if (rootNode == null) break;
                String[] pathSegments = fs.getFileSystem().getURISegments(resource.getFileStore().getPath().toUri());
                DBNFileSystemRoot parentNode = rootNode;
                int i = 1;
                while (i < pathSegments.length - 1) {
                    String itemName = pathSegments[i];
                    DBNPathBase childNode = parentNode.getChild(itemName);
                    if (childNode == null) {
                        log.debug((Object)("Cannot find child node '" + itemName + "' in '" + parentNode.getNodeUri() + "'"));
                        return;
                    }
                    parentNode = childNode;
                    ++i;
                }
                switch (action) {
                    case CREATE: {
                        parentNode.addChildResource(resource.getNioPath());
                        break;
                    }
                    case DELETE: {
                        parentNode.removeChildResource(resource.getNioPath());
                        break;
                    }
                }
                break;
            }
            ++n2;
        }
    }
}

