/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences.format.tokenized;

import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.preferences.format.BaseFormatterConfigurationPage;
import org.jkiss.utils.CommonUtils;

public class SQLTokenizedFormatterConfigurationPage
extends BaseFormatterConfigurationPage {
    private Spinner indentSizeSpinner;
    private Button useSpacesCheck;
    private Combo keywordCaseCombo;
    private Button lineFeedBeforeCommaCheck;
    private Button breakLineBeforeCloseBracket;
    private Button insertDelimiterInEmptyLines;

    @Override
    protected Composite createFormatSettings(Composite parent) {
        Composite settings = UIUtils.createTitledComposite((Composite)parent, (String)SQLEditorMessages.pref_page_sql_format_label_settings, (int)4, (int)768, (int)0);
        SelectionAdapter selectListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLTokenizedFormatterConfigurationPage.this.changeListener.run();
            }
        };
        this.keywordCaseCombo = UIUtils.createLabelCombo((Composite)settings, (String)SQLEditorMessages.pref_page_sql_format_label_keyword_case, (int)12);
        this.keywordCaseCombo.setLayoutData((Object)new GridData(32));
        this.keywordCaseCombo.add("Default");
        DBPIdentifierCase[] dBPIdentifierCaseArray = DBPIdentifierCase.values();
        int n = dBPIdentifierCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPIdentifierCase c = dBPIdentifierCaseArray[n2];
            this.keywordCaseCombo.add(DBPIdentifierCase.capitalizeCaseName((String)c.name()));
            ++n2;
        }
        this.keywordCaseCombo.addSelectionListener((SelectionListener)selectListener);
        this.indentSizeSpinner = UIUtils.createLabelSpinner((Composite)settings, (String)SQLEditorMessages.pref_page_sql_format_label_indent_size, (String)SQLEditorMessages.pref_page_sql_format_label_indent_size, (int)4, (int)0, (int)100);
        this.indentSizeSpinner.addSelectionListener((SelectionListener)selectListener);
        this.useSpacesCheck = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.pref_page_sql_format_label_insert_spaces_for_tabs, (String)SQLEditorMessages.pref_page_sql_format_label_insert_spaces_for_tabs, (boolean)true, (int)2);
        this.useSpacesCheck.addSelectionListener((SelectionListener)selectListener);
        this.lineFeedBeforeCommaCheck = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.pref_page_sql_format_label_insert_line_feed_before_commas, (String)SQLEditorMessages.pref_page_sql_format_label_insert_line_feed_before_commas, (boolean)true, (int)2);
        this.lineFeedBeforeCommaCheck.addSelectionListener((SelectionListener)selectListener);
        this.breakLineBeforeCloseBracket = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.pref_page_sql_format_label_add_line_feed_before_close_bracket, (String)SQLEditorMessages.pref_page_sql_format_label_add_line_feed_before_close_bracket, (boolean)true, (int)2);
        this.breakLineBeforeCloseBracket.addSelectionListener((SelectionListener)selectListener);
        this.insertDelimiterInEmptyLines = UIUtils.createCheckbox((Composite)settings, (String)SQLEditorMessages.pref_page_sql_format_label_insert_delimiters_in_empty_lines, (String)SQLEditorMessages.pref_page_sql_format_tip_insert_delimiters_in_empty_lines, (boolean)true, (int)2);
        this.insertDelimiterInEmptyLines.addSelectionListener((SelectionListener)selectListener);
        return parent;
    }

    private IPreferenceStore getTextEditorsPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public void loadSettings(@NotNull DBPPreferenceStore preferenceStore, boolean useDefaults) {
        DBPIdentifierCase keywordCase;
        super.loadSettings(preferenceStore, useDefaults);
        String caseName = useDefaults ? preferenceStore.getDefaultString("sql.format.keywordCase") : preferenceStore.getString("sql.format.keywordCase");
        DBPIdentifierCase dBPIdentifierCase = keywordCase = CommonUtils.isEmpty((String)caseName) ? null : (DBPIdentifierCase)CommonUtils.valueOf(DBPIdentifierCase.class, (String)caseName);
        if (keywordCase == null) {
            this.keywordCaseCombo.select(0);
        } else {
            UIUtils.setComboSelection((Combo)this.keywordCaseCombo, (String)DBPIdentifierCase.capitalizeCaseName((String)keywordCase.name()));
        }
        this.lineFeedBeforeCommaCheck.setSelection(useDefaults ? preferenceStore.getDefaultBoolean("sql.format.lf.before.comma") : preferenceStore.getBoolean("sql.format.lf.before.comma"));
        this.breakLineBeforeCloseBracket.setSelection(useDefaults ? preferenceStore.getDefaultBoolean("sql.format.break.before.close.bracket") : preferenceStore.getBoolean("sql.format.break.before.close.bracket"));
        this.insertDelimiterInEmptyLines.setSelection(useDefaults ? preferenceStore.getDefaultBoolean("sql.format.insert.delimiters.in.empty_lines") : preferenceStore.getBoolean("sql.format.insert.delimiters.in.empty_lines"));
        IPreferenceStore textEditorPrefs = this.getTextEditorsPreferenceStore();
        this.indentSizeSpinner.setSelection(useDefaults ? textEditorPrefs.getDefaultInt("tabWidth") : textEditorPrefs.getInt("tabWidth"));
        this.useSpacesCheck.setSelection(useDefaults ? textEditorPrefs.getDefaultBoolean("spacesForTabs") : textEditorPrefs.getBoolean("spacesForTabs"));
    }

    @Override
    public void saveSettings(@NotNull DBPPreferenceStore preferenceStore) {
        super.saveSettings(preferenceStore);
        String caseName = this.keywordCaseCombo.getSelectionIndex() == 0 ? "" : this.keywordCaseCombo.getText().toUpperCase(Locale.ENGLISH);
        preferenceStore.setValue("sql.format.keywordCase", caseName);
        preferenceStore.setValue("sql.format.lf.before.comma", this.lineFeedBeforeCommaCheck.getSelection());
        preferenceStore.setValue("sql.format.break.before.close.bracket", this.breakLineBeforeCloseBracket.getSelection());
        preferenceStore.setValue("sql.format.insert.delimiters.in.empty_lines", this.insertDelimiterInEmptyLines.getSelection());
        IPreferenceStore textEditorPrefs = this.getTextEditorsPreferenceStore();
        textEditorPrefs.setValue("tabWidth", this.indentSizeSpinner.getSelection());
        textEditorPrefs.setValue("spacesForTabs", this.useSpacesCheck.getSelection());
    }

    @Override
    public void resetSettings(@NotNull DBPPreferenceStore preferenceStore) {
        super.resetSettings(preferenceStore);
        preferenceStore.setToDefault("sql.format.keywordCase");
        preferenceStore.setToDefault("sql.format.lf.before.comma");
        preferenceStore.setToDefault("sql.format.break.before.close.bracket");
        preferenceStore.setToDefault("sql.format.insert.delimiters.in.empty_lines");
    }
}

