/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.xml;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.text.NonRuleBasedDamagerRepairer;
import org.jkiss.dbeaver.ui.editors.xml.XMLContentAssistantProcessor;
import org.jkiss.dbeaver.ui.editors.xml.XMLDoubleClickStrategy;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;
import org.jkiss.dbeaver.ui.editors.xml.XMLFormattingStrategy;
import org.jkiss.dbeaver.ui.editors.xml.XMLReconcilingStrategy;
import org.jkiss.dbeaver.ui.editors.xml.XMLScanner;
import org.jkiss.dbeaver.ui.editors.xml.XMLTagScanner;

public class XMLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private static final String COLOR_XML_COMMENT = "org.jkiss.dbeaver.xml.editor.color.comment";
    static final String COLOR_XML_STRING = "org.jkiss.dbeaver.xml.editor.color.text";
    private static final String COLOR_XML_TAG = "org.jkiss.dbeaver.xml.editor.color.tag";
    private final XMLEditor editor;

    public XMLSourceViewerConfiguration(XMLEditor editor) {
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__xml_partitioning";
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new XMLDoubleClickStrategy();
    }

    private XMLTagScanner getXMLTagScanner() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        XMLTagScanner tagScanner = new XMLTagScanner(colorRegistry);
        tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(colorRegistry.get(COLOR_XML_TAG))));
        return tagScanner;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setDocumentPartitioning("__dftl_partition_content_type");
        XMLFormattingStrategy formattingStrategy = new XMLFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__dftl_partition_content_type");
        formatter.enablePartitionAwareFormatting(false);
        return formatter;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new XMLContentAssistantProcessor(), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        return assistant;
    }

    private XMLScanner getXMLScanner() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        XMLScanner scanner = new XMLScanner(colorRegistry);
        scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(colorRegistry.get(COLOR_XML_STRING))));
        return scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(colorRegistry.get(COLOR_XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        XMLReconcilingStrategy strategy = new XMLReconcilingStrategy();
        strategy.setEditor(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }
}

