/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class ContributionContextTypeRegistry
extends ContextTypeRegistry {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String CONTEXT_TYPE = "contextType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String RESOLVER = "resolver";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String REGISTRY = "contextTypeRegistry";
    private static final String REGISTRY_ID = "registryId";

    public ContributionContextTypeRegistry(String registryId) {
        this.readRegistry(registryId);
    }

    public ContributionContextTypeRegistry() {
    }

    private void readRegistry(String registryId) {
        IConfigurationElement[] extensions;
        Assert.isNotNull((Object)registryId);
        IConfigurationElement[] iConfigurationElementArray = extensions = ContributionContextTypeRegistry.getTemplateExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getName().equals(REGISTRY) && registryId.equals(id = extension.getAttribute(ID))) {
                IConfigurationElement[] iConfigurationElementArray2 = extensions;
                int n3 = extensions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement extension2 = iConfigurationElementArray2[n4];
                    if (extension2.getName().equals(CONTEXT_TYPE) && registryId.equals(extension2.getAttribute(REGISTRY_ID))) {
                        this.addContextType(extension2.getAttribute(ID));
                    }
                    ++n4;
                }
                return;
            }
            ++n2;
        }
        Assert.isTrue((boolean)false, (String)"invalid registry id");
    }

    public void addContextType(String id) {
        Assert.isNotNull((Object)id);
        if (this.getContextType(id) != null) {
            return;
        }
        TemplateContextType type = ContributionContextTypeRegistry.createContextType(id);
        if (type != null) {
            this.addContextType(type);
        }
    }

    public static TemplateContextType createContextType(String id) {
        TemplateContextType type;
        Assert.isNotNull((Object)id);
        IConfigurationElement[] extensions = ContributionContextTypeRegistry.getTemplateExtensions();
        try {
            type = ContributionContextTypeRegistry.createContextType(extensions, id);
            if (type != null) {
                TemplateVariableResolver[] resolvers;
                TemplateVariableResolver[] templateVariableResolverArray = resolvers = ContributionContextTypeRegistry.createResolvers(extensions, id);
                int n = resolvers.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateVariableResolver resolver = templateVariableResolverArray[n2];
                    type.addResolver(resolver);
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            EditorsPlugin.log(e);
            type = null;
        }
        return type;
    }

    private static TemplateContextType createContextType(IConfigurationElement[] extensions, String contextTypeId) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getName().equals(CONTEXT_TYPE) && contextTypeId.equals(id = extension.getAttribute(ID))) {
                return ContributionContextTypeRegistry.createContextType(extension);
            }
            ++n2;
        }
        return null;
    }

    private static TemplateVariableResolver[] createResolvers(IConfigurationElement[] extensions, String contextTypeId) {
        ArrayList<TemplateVariableResolver> resolvers = new ArrayList<TemplateVariableResolver>();
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String declaredId;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getName().equals(RESOLVER) && contextTypeId.equals(declaredId = extension.getAttribute(CONTEXT_TYPE_ID))) {
                try {
                    TemplateVariableResolver resolver = ContributionContextTypeRegistry.createResolver(extension);
                    if (resolver != null) {
                        resolvers.add(resolver);
                    }
                }
                catch (CoreException e) {
                    EditorsPlugin.log(e);
                }
            }
            ++n2;
        }
        return resolvers.toArray(new TemplateVariableResolver[resolvers.size()]);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private static TemplateContextType createContextType(IConfigurationElement element) throws CoreException {
        String id = element.getAttribute(ID);
        try {
            TemplateContextType contextType = (TemplateContextType)element.createExecutableExtension(CLASS);
            String name = element.getAttribute(NAME);
            if (name == null) {
                name = id;
            }
            if (contextType.getId() == null) {
                contextType.setId(id);
            }
            if (contextType.getName() == null) {
                contextType.setName(name);
            }
            return contextType;
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + TemplateContextType.class.getName(), (Throwable)e));
        }
    }

    private static TemplateVariableResolver createResolver(IConfigurationElement element) throws CoreException {
        try {
            String type = element.getAttribute(TYPE);
            if (type != null) {
                TemplateVariableResolver resolver = (TemplateVariableResolver)element.createExecutableExtension(CLASS);
                if (resolver.getType() != null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, String.valueOf(resolver.getClass()) + "() must call super() and not set the variable's type", null));
                }
                resolver.setType(type);
                if (resolver.getDescription() != null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, String.valueOf(resolver.getClass()) + "() must call super() and not set the variable's description", null));
                }
                String desc = element.getAttribute(DESCRIPTION);
                resolver.setDescription(desc == null ? "" : desc);
                return resolver;
            }
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + TemplateVariableResolver.class.getName(), (Throwable)e));
        }
        return null;
    }
}

