﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift-serverless/RedshiftServerless_EXPORTS.h>
#include <aws/redshift-serverless/model/SnapshotCopyConfiguration.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RedshiftServerless {
namespace Model {
class CreateSnapshotCopyConfigurationResult {
 public:
  AWS_REDSHIFTSERVERLESS_API CreateSnapshotCopyConfigurationResult() = default;
  AWS_REDSHIFTSERVERLESS_API CreateSnapshotCopyConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_REDSHIFTSERVERLESS_API CreateSnapshotCopyConfigurationResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The snapshot copy configuration object that is returned.</p>
   */
  inline const SnapshotCopyConfiguration& GetSnapshotCopyConfiguration() const { return m_snapshotCopyConfiguration; }
  template <typename SnapshotCopyConfigurationT = SnapshotCopyConfiguration>
  void SetSnapshotCopyConfiguration(SnapshotCopyConfigurationT&& value) {
    m_snapshotCopyConfigurationHasBeenSet = true;
    m_snapshotCopyConfiguration = std::forward<SnapshotCopyConfigurationT>(value);
  }
  template <typename SnapshotCopyConfigurationT = SnapshotCopyConfiguration>
  CreateSnapshotCopyConfigurationResult& WithSnapshotCopyConfiguration(SnapshotCopyConfigurationT&& value) {
    SetSnapshotCopyConfiguration(std::forward<SnapshotCopyConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateSnapshotCopyConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  SnapshotCopyConfiguration m_snapshotCopyConfiguration;

  Aws::String m_requestId;
  bool m_snapshotCopyConfigurationHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RedshiftServerless
}  // namespace Aws
