# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_repo_files_global_optspecs
	string join \n h/help V/version
end

function __fish_alpm_repo_files_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_repo_files_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_repo_files_using_subcommand
	set -l cmd (__fish_alpm_repo_files_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-repo-files -n "__fish_alpm_repo_files_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_needs_command" -s V -l version -d 'Print version'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_needs_command" -f -a "create" -d 'Create alpm-repo-files data from a directory.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_needs_command" -f -a "format" -d 'Read and validate alpm-repo-files data and return it in another file format.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_needs_command" -f -a "validate" -d 'Validate an alpm-repo-files file.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand create" -s o -l output -d 'A file path to write to.' -r -F
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand create" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand format" -s i -l input-file -d 'An input file to read from.' -r -F
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand format" -s f -l format -d 'Set the output format.' -r -f -a "json\t'The JSON output format.'
v1\t'The alpm-repo-files output format.'"
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand format" -s o -l output -d 'A file path to write to.' -r -F
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand format" -s p -l pretty -d 'Determines whether the output will be displayed in a pretty non-minimized fashion.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand validate" -s i -l input-file -d 'An input file to read from.' -r -F
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand help; and not __fish_seen_subcommand_from create format validate help" -f -a "create" -d 'Create alpm-repo-files data from a directory.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand help; and not __fish_seen_subcommand_from create format validate help" -f -a "format" -d 'Read and validate alpm-repo-files data and return it in another file format.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand help; and not __fish_seen_subcommand_from create format validate help" -f -a "validate" -d 'Validate an alpm-repo-files file.'
complete -c alpm-repo-files -n "__fish_alpm_repo_files_using_subcommand help; and not __fish_seen_subcommand_from create format validate help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
