/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import io.netty.channel.EventLoopGroup;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.repositories.s3.AmazonAsyncS3Reference;
import org.opensearch.repositories.s3.AmazonAsyncS3WithCredentials;
import org.opensearch.repositories.s3.ProxySettings;
import org.opensearch.repositories.s3.S3ClientSettings;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.S3Service;
import org.opensearch.repositories.s3.async.AsyncExecutorContainer;
import org.opensearch.repositories.s3.async.AsyncTransferEventLoopGroup;
import org.opensearch.secure_sm.AccessController;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.crt.AwsCrtAsyncHttpClient;
import software.amazon.awssdk.http.crt.ProxyConfiguration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.LegacyMd5Plugin;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsWebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

class S3AsyncService
implements Closeable {
    private static final Logger logger = LogManager.getLogger(S3AsyncService.class);
    private static final String STS_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY = "aws.stsEndpointOverride";
    private static final String DEFAULT_S3_ENDPOINT = "s3.amazonaws.com";
    private volatile Map<String, Map<S3ClientSettings, AmazonAsyncS3Reference>> s3HttpClientTypesClientsCache = Collections.emptyMap();
    private volatile Map<String, S3ClientSettings> staticClientSettings;
    private volatile Map<Settings, S3ClientSettings> derivedClientSettings = Collections.emptyMap();
    @Nullable
    private final ScheduledExecutorService clientExecutorService;

    S3AsyncService(Path configPath, @Nullable ScheduledExecutorService clientExecutorService) {
        this.staticClientSettings = MapBuilder.newMapBuilder().put((Object)this.buildClientName("default", "crt"), (Object)S3ClientSettings.getClientSettings(Settings.EMPTY, "default", configPath)).put((Object)this.buildClientName("default", "netty"), (Object)S3ClientSettings.getClientSettings(Settings.EMPTY, "default", configPath)).immutableMap();
        this.clientExecutorService = clientExecutorService;
    }

    private String buildClientName(String clientValue, String asyncClientType) {
        return clientValue + "-" + asyncClientType;
    }

    S3AsyncService(Path configPath) {
        this(configPath, null);
    }

    public synchronized void refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.releaseCachedClients();
        MapBuilder defaultBuilder = MapBuilder.newMapBuilder();
        for (Map.Entry<String, S3ClientSettings> entrySet : clientsSettings.entrySet()) {
            defaultBuilder.put((Object)this.buildClientName(entrySet.getKey(), "crt"), (Object)clientsSettings.get(entrySet.getKey()));
            defaultBuilder.put((Object)this.buildClientName(entrySet.getKey(), "netty"), (Object)clientsSettings.get(entrySet.getKey()));
        }
        this.staticClientSettings = defaultBuilder.immutableMap();
        this.derivedClientSettings = Collections.emptyMap();
        assert (this.staticClientSettings.containsKey(this.buildClientName("default", "netty"))) : "Static Client Settings should contain default Netty client";
        assert (this.staticClientSettings.containsKey(this.buildClientName("default", "crt"))) : "Static Client Settings should contain default CRT client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonAsyncS3Reference client(RepositoryMetadata repositoryMetadata, AsyncExecutorContainer urgentExecutorBuilder, AsyncExecutorContainer priorityExecutorBuilder, AsyncExecutorContainer normalExecutorBuilder) {
        S3ClientSettings clientSettings;
        String asyncHttpClientType = (String)S3Repository.S3_ASYNC_HTTP_CLIENT_TYPE.get(repositoryMetadata.settings());
        AmazonAsyncS3Reference clientReference = this.getCachedClientForHttpTypeAndClientSettings(asyncHttpClientType, clientSettings = this.settings(repositoryMetadata));
        if (clientReference != null) {
            return clientReference;
        }
        S3AsyncService s3AsyncService = this;
        synchronized (s3AsyncService) {
            AmazonAsyncS3Reference existingClient = this.getCachedClientForHttpTypeAndClientSettings(asyncHttpClientType, clientSettings);
            if (existingClient != null) {
                return existingClient;
            }
            AmazonAsyncS3Reference newClientReference = new AmazonAsyncS3Reference(this.buildClient(clientSettings, urgentExecutorBuilder, priorityExecutorBuilder, normalExecutorBuilder, asyncHttpClientType));
            newClientReference.incRef();
            Map clientsCacheForType = this.s3HttpClientTypesClientsCache.getOrDefault(asyncHttpClientType, Collections.emptyMap());
            this.s3HttpClientTypesClientsCache = MapBuilder.newMapBuilder(this.s3HttpClientTypesClientsCache).put((Object)asyncHttpClientType, (Object)MapBuilder.newMapBuilder(clientsCacheForType).put((Object)clientSettings, (Object)newClientReference).immutableMap()).immutableMap();
            return newClientReference;
        }
    }

    private AmazonAsyncS3Reference getCachedClientForHttpTypeAndClientSettings(String asyncHttpClientType, S3ClientSettings clientSettings) {
        AmazonAsyncS3Reference clientReference;
        Map<S3ClientSettings, AmazonAsyncS3Reference> clientsCacheMap = this.s3HttpClientTypesClientsCache.get(asyncHttpClientType);
        if (clientsCacheMap != null && !clientsCacheMap.isEmpty() && (clientReference = clientsCacheMap.get(clientSettings)) != null && clientReference.tryIncRef()) {
            return clientReference;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S3ClientSettings settings(RepositoryMetadata repositoryMetadata) {
        Settings settings = repositoryMetadata.settings();
        S3ClientSettings existing = this.derivedClientSettings.get(settings);
        if (existing != null) {
            return existing;
        }
        String clientName = this.buildClientName((String)S3Repository.CLIENT_NAME.get(settings), (String)S3Repository.S3_ASYNC_HTTP_CLIENT_TYPE.get(repositoryMetadata.settings()));
        S3ClientSettings staticSettings = this.staticClientSettings.get(clientName);
        if (staticSettings != null) {
            S3AsyncService s3AsyncService = this;
            synchronized (s3AsyncService) {
                S3ClientSettings existing2 = this.derivedClientSettings.get(settings);
                if (existing2 != null) {
                    return existing2;
                }
                S3ClientSettings newSettings = staticSettings.refine(settings);
                this.derivedClientSettings = MapBuilder.newMapBuilder(this.derivedClientSettings).put((Object)settings, (Object)newSettings).immutableMap();
                return newSettings;
            }
        }
        throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.staticClientSettings.keySet(), (String)","));
    }

    synchronized AmazonAsyncS3WithCredentials buildClient(S3ClientSettings clientSettings, AsyncExecutorContainer urgentExecutorBuilder, AsyncExecutorContainer priorityExecutorBuilder, AsyncExecutorContainer normalExecutorBuilder, String asyncHttpClientType) {
        S3AsyncService.setDefaultAwsProfilePath();
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        builder.overrideConfiguration(S3AsyncService.buildOverrideConfiguration(clientSettings, this.clientExecutorService));
        AwsCredentialsProvider credentials = S3AsyncService.buildCredentials(logger, clientSettings);
        builder.credentialsProvider(credentials);
        Object endpoint = Strings.hasLength((String)clientSettings.endpoint) ? clientSettings.endpoint : DEFAULT_S3_ENDPOINT;
        if (!(((String)endpoint).startsWith("http://") || ((String)endpoint).startsWith("https://"))) {
            endpoint = clientSettings.protocol.toString() + "://" + (String)endpoint;
        }
        logger.debug("using endpoint [{}] and region [{}]", endpoint, (Object)clientSettings.region);
        builder.endpointOverride(URI.create((String)endpoint));
        builder.region(Region.of((String)clientSettings.region));
        if (clientSettings.pathStyleAccess) {
            builder.forcePathStyle(Boolean.valueOf(true));
        }
        builder.httpClient(S3AsyncService.buildHttpClient(clientSettings, urgentExecutorBuilder.getAsyncTransferEventLoopGroup(), asyncHttpClientType));
        builder.asyncConfiguration((ClientAsyncConfiguration)ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)urgentExecutorBuilder.getFutureCompletionExecutor()).build());
        S3AsyncClient urgentClient = (S3AsyncClient)AccessController.doPrivileged(() -> ((S3AsyncClientBuilder)builder).build());
        builder.httpClient(S3AsyncService.buildHttpClient(clientSettings, priorityExecutorBuilder.getAsyncTransferEventLoopGroup(), asyncHttpClientType));
        builder.asyncConfiguration((ClientAsyncConfiguration)ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)priorityExecutorBuilder.getFutureCompletionExecutor()).build());
        S3AsyncClient priorityClient = (S3AsyncClient)AccessController.doPrivileged(() -> ((S3AsyncClientBuilder)builder).build());
        builder.httpClient(S3AsyncService.buildHttpClient(clientSettings, normalExecutorBuilder.getAsyncTransferEventLoopGroup(), asyncHttpClientType));
        builder.asyncConfiguration((ClientAsyncConfiguration)ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)normalExecutorBuilder.getFutureCompletionExecutor()).build());
        ((S3AsyncClientBuilder)builder.responseChecksumValidation(ResponseChecksumValidation.WHEN_REQUIRED)).requestChecksumCalculation(RequestChecksumCalculation.WHEN_REQUIRED);
        if (clientSettings.legacyMd5ChecksumCalculation) {
            builder.addPlugin(LegacyMd5Plugin.create());
        }
        S3AsyncClient client = (S3AsyncClient)AccessController.doPrivileged(() -> ((S3AsyncClientBuilder)builder).build());
        return AmazonAsyncS3WithCredentials.create(client, priorityClient, urgentClient, credentials);
    }

    static SdkAsyncHttpClient buildHttpClient(S3ClientSettings clientSettings, AsyncTransferEventLoopGroup asyncTransferEventLoopGroup, String asyncHttpClientType) {
        logger.debug("S3 Http client type [{}]", (Object)asyncHttpClientType);
        if ("netty".equals(asyncHttpClientType)) {
            return S3AsyncService.buildAsyncNettyHttpClient(clientSettings, asyncTransferEventLoopGroup);
        }
        return S3AsyncService.buildAsyncCrtHttpClient(clientSettings);
    }

    static SdkAsyncHttpClient buildAsyncNettyHttpClient(S3ClientSettings clientSettings, AsyncTransferEventLoopGroup asyncTransferEventLoopGroup) {
        NettyNioAsyncHttpClient.Builder clientBuilder = NettyNioAsyncHttpClient.builder();
        if (clientSettings.proxySettings.getType() != ProxySettings.ProxyType.DIRECT) {
            ProxyConfiguration.Builder proxyConfiguration = software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder();
            proxyConfiguration.scheme(clientSettings.proxySettings.getType().toProtocol().toString());
            proxyConfiguration.host(clientSettings.proxySettings.getHostName());
            proxyConfiguration.port(clientSettings.proxySettings.getPort());
            proxyConfiguration.username(clientSettings.proxySettings.getUsername());
            proxyConfiguration.password(clientSettings.proxySettings.getPassword());
            clientBuilder.proxyConfiguration((software.amazon.awssdk.http.nio.netty.ProxyConfiguration)proxyConfiguration.build());
        }
        clientBuilder.connectionTimeout(Duration.ofMillis(clientSettings.connectionTimeoutMillis));
        clientBuilder.connectionAcquisitionTimeout(Duration.ofMillis(clientSettings.connectionAcquisitionTimeoutMillis));
        clientBuilder.maxPendingConnectionAcquires(Integer.valueOf(10000));
        clientBuilder.maxConcurrency(Integer.valueOf(clientSettings.maxConnections));
        clientBuilder.eventLoopGroup(SdkEventLoopGroup.create((EventLoopGroup)asyncTransferEventLoopGroup.getEventLoopGroup()));
        clientBuilder.tcpKeepAlive(Boolean.valueOf(true));
        return clientBuilder.build();
    }

    static SdkAsyncHttpClient buildAsyncCrtHttpClient(S3ClientSettings clientSettings) {
        AwsCrtAsyncHttpClient.Builder crtClientBuilder = AwsCrtAsyncHttpClient.builder();
        if (clientSettings.proxySettings.getType() != ProxySettings.ProxyType.DIRECT) {
            ProxyConfiguration.Builder crtProxyConfiguration = ProxyConfiguration.builder();
            crtProxyConfiguration.scheme(clientSettings.proxySettings.getType().toProtocol().toString());
            crtProxyConfiguration.host(clientSettings.proxySettings.getHostName());
            crtProxyConfiguration.port(clientSettings.proxySettings.getPort());
            crtProxyConfiguration.username(clientSettings.proxySettings.getUsername());
            crtProxyConfiguration.password(clientSettings.proxySettings.getPassword());
            crtClientBuilder.proxyConfiguration(crtProxyConfiguration.build());
        }
        crtClientBuilder.connectionTimeout(Duration.ofMillis(clientSettings.connectionTimeoutMillis));
        crtClientBuilder.maxConcurrency(Integer.valueOf(clientSettings.maxConnections));
        return crtClientBuilder.build();
    }

    static ClientOverrideConfiguration buildOverrideConfiguration(S3ClientSettings clientSettings, ScheduledExecutorService clientExecutorService) {
        RetryPolicy retryPolicy = (RetryPolicy)AccessController.doPrivileged(() -> RetryPolicy.builder().numRetries(Integer.valueOf(clientSettings.maxRetries)).throttlingBackoffStrategy(clientSettings.throttleRetries ? BackoffStrategy.defaultThrottlingStrategy((RetryMode)RetryMode.STANDARD) : BackoffStrategy.none()).build());
        ClientOverrideConfiguration.Builder builder = ClientOverrideConfiguration.builder();
        if (clientExecutorService != null) {
            builder = builder.scheduledExecutorService(clientExecutorService);
        }
        return (ClientOverrideConfiguration)builder.retryPolicy(retryPolicy).apiCallAttemptTimeout(Duration.ofMillis(clientSettings.requestTimeoutMillis)).build();
    }

    static AwsCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        AwsCredentials basicCredentials = clientSettings.credentials;
        S3ClientSettings.IrsaCredentials irsaCredentials = S3AsyncService.buildFromEnvironment(clientSettings.irsaCredentials);
        if (irsaCredentials != null) {
            logger.debug("Using IRSA credentials");
            Region region = Region.of((String)clientSettings.region);
            StsClient stsClient = (StsClient)AccessController.doPrivileged(() -> {
                StsClientBuilder builder = (StsClientBuilder)StsClient.builder().region(region);
                String stsEndpoint = System.getProperty(STS_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY);
                if (stsEndpoint != null) {
                    builder = (StsClientBuilder)builder.endpointOverride(URI.create(stsEndpoint));
                }
                builder = basicCredentials != null ? (StsClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)basicCredentials)) : (StsClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
                return (StsClient)builder.build();
            });
            if (irsaCredentials.getIdentityTokenFile() == null) {
                StsAssumeRoleCredentialsProvider.Builder stsCredentialsProviderBuilder = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(irsaCredentials.getRoleArn()).roleSessionName(irsaCredentials.getRoleSessionName()).build());
                StsAssumeRoleCredentialsProvider stsCredentialsProvider = (StsAssumeRoleCredentialsProvider)AccessController.doPrivileged(() -> ((StsAssumeRoleCredentialsProvider.Builder)stsCredentialsProviderBuilder).build());
                return new PrivilegedSTSAssumeRoleSessionCredentialsProvider<StsAssumeRoleCredentialsProvider>(stsClient, stsCredentialsProvider);
            }
            StsWebIdentityTokenFileCredentialsProvider.Builder stsCredentialsProviderBuilder = StsWebIdentityTokenFileCredentialsProvider.builder().stsClient(stsClient).roleArn(irsaCredentials.getRoleArn()).roleSessionName(irsaCredentials.getRoleSessionName()).webIdentityTokenFile(Path.of(irsaCredentials.getIdentityTokenFile(), new String[0]));
            StsWebIdentityTokenFileCredentialsProvider stsCredentialsProvider = (StsWebIdentityTokenFileCredentialsProvider)AccessController.doPrivileged(() -> ((StsWebIdentityTokenFileCredentialsProvider.Builder)stsCredentialsProviderBuilder).build());
            return new PrivilegedSTSAssumeRoleSessionCredentialsProvider<StsWebIdentityTokenFileCredentialsProvider>(stsClient, stsCredentialsProvider);
        }
        if (basicCredentials != null) {
            logger.debug("Using basic key/secret credentials");
            return StaticCredentialsProvider.create((AwsCredentials)basicCredentials);
        }
        logger.debug("Using instance profile credentials");
        return new PrivilegedInstanceProfileCredentialsProvider();
    }

    @SuppressForbidden(reason="Need to provide this override to v2 SDK so that path does not default to home path")
    private static void setDefaultAwsProfilePath() {
        S3Service.setDefaultAwsProfilePath();
    }

    private static S3ClientSettings.IrsaCredentials buildFromEnvironment(S3ClientSettings.IrsaCredentials defaults) {
        String roleSessionName;
        String roleArn;
        if (defaults == null) {
            return null;
        }
        String webIdentityTokenFile = defaults.getIdentityTokenFile();
        if (webIdentityTokenFile == null) {
            webIdentityTokenFile = System.getenv(SdkSystemSetting.AWS_WEB_IDENTITY_TOKEN_FILE.environmentVariable());
        }
        if ((roleArn = defaults.getRoleArn()) == null) {
            roleArn = System.getenv(SdkSystemSetting.AWS_ROLE_ARN.environmentVariable());
        }
        if ((roleSessionName = defaults.getRoleSessionName()) == null) {
            roleSessionName = System.getenv(SdkSystemSetting.AWS_ROLE_SESSION_NAME.environmentVariable());
        }
        return new S3ClientSettings.IrsaCredentials(webIdentityTokenFile, roleArn, roleSessionName);
    }

    public synchronized void releaseCachedClients() {
        for (Map<S3ClientSettings, AmazonAsyncS3Reference> clientTypeCaches : this.s3HttpClientTypesClientsCache.values()) {
            for (AmazonAsyncS3Reference clientReference : clientTypeCaches.values()) {
                clientReference.decRef();
            }
        }
        this.s3HttpClientTypesClientsCache = Collections.emptyMap();
        this.derivedClientSettings = Collections.emptyMap();
    }

    @Override
    public void close() {
        this.releaseCachedClients();
    }

    @Nullable
    ScheduledExecutorService getClientExecutorService() {
        return this.clientExecutorService;
    }

    static class PrivilegedSTSAssumeRoleSessionCredentialsProvider<P extends AwsCredentialsProvider & AutoCloseable>
    implements AwsCredentialsProvider,
    Closeable {
        private final P credentials;
        private final StsClient stsClient;

        private PrivilegedSTSAssumeRoleSessionCredentialsProvider(@Nullable StsClient stsClient, P credentials) {
            this.stsClient = stsClient;
            this.credentials = credentials;
        }

        @Override
        public void close() throws IOException {
            try {
                AccessController.doPrivilegedChecked(() -> {
                    ((AutoCloseable)this.credentials).close();
                    if (this.stsClient != null) {
                        this.stsClient.close();
                    }
                });
            }
            catch (Exception e) {
                throw (IOException)e;
            }
        }

        public AwsCredentials resolveCredentials() {
            return (AwsCredentials)AccessController.doPrivileged(() -> this.credentials.resolveCredentials());
        }
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AwsCredentialsProvider {
        private final AwsCredentialsProvider credentials = this.initializeProvider();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        private AwsCredentialsProvider initializeProvider() {
            if (SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.getStringValue().isPresent() || SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.getStringValue().isPresent()) {
                return ((ContainerCredentialsProvider.Builder)ContainerCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
            }
            return ((InstanceProfileCredentialsProvider.Builder)InstanceProfileCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
        }

        public AwsCredentials resolveCredentials() {
            return (AwsCredentials)AccessController.doPrivileged(() -> ((AwsCredentialsProvider)this.credentials).resolveCredentials());
        }
    }
}

