/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.AutomatonQueries;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.compositeindex.datacube.DimensionType;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.BytesRefsCollectionBuilder;
import org.opensearch.index.mapper.DerivedFieldGenerator;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SortedSetDocValuesFetcher;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.StoredFieldFetcher;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextParams;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityProvider;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public final class KeywordFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String nullValue;
    private final boolean eagerGlobalOrdinals;
    private final int ignoreAbove;
    private final String indexOptions;
    private final FieldType fieldType;
    private final SimilarityProvider similarity;
    private final boolean useSimilarity;
    private final String normalizerName;
    private final boolean splitQueriesOnWhitespace;
    private final IndexAnalyzers indexAnalyzers;

    private static KeywordFieldMapper toType(FieldMapper in) {
        return (KeywordFieldMapper)in;
    }

    @Override
    protected void canDeriveSourceInternal() {
        if (this.ignoreAbove != Integer.MAX_VALUE || !Objects.equals(this.normalizerName, "default")) {
            throw new UnsupportedOperationException("Unable to derive source for [" + this.name() + "] with ignore_above and/or normalizer set");
        }
        this.checkStoredAndDocValuesForDerivedSource();
    }

    @Override
    protected DerivedFieldGenerator derivedFieldGenerator() {
        return new DerivedFieldGenerator(this.mappedFieldType, new SortedSetDocValuesFetcher(this.mappedFieldType, this.simpleName()), new StoredFieldFetcher(this.mappedFieldType, this.simpleName()));
    }

    protected KeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals.getValue();
        this.ignoreAbove = builder.ignoreAbove.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.fieldType = fieldType;
        this.similarity = builder.similarity.getValue();
        this.useSimilarity = builder.useSimilarity.getValue();
        this.normalizerName = builder.normalizer.getValue();
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace.getValue();
        this.indexAnalyzers = builder.indexAnalyzers;
    }

    public int ignoreAbove() {
        return this.ignoreAbove;
    }

    boolean useSimilarity() {
        return this.useSimilarity;
    }

    @Override
    protected KeywordFieldMapper clone() {
        return (KeywordFieldMapper)super.clone();
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = KeywordFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        BytesRef binaryValue = new BytesRef((CharSequence)value);
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            KeywordField field = new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
            context.doc().add((IndexableField)field);
            if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    static String normalizeValue(NamedAnalyzer normalizer, String field, String value) throws IOException {
        try (TokenStream ts = normalizer.tokenStream(field, value);){
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (!ts.incrementToken()) {
                throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + String.valueOf((Object)normalizer) + " and input \"" + value + "\"");
            }
            String newValue = termAtt.toString();
            if (ts.incrementToken()) {
                throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + String.valueOf((Object)normalizer) + " and input \"" + value + "\"");
            }
            ts.end();
            String string = newValue;
            return string;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers).init(this);
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> KeywordFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> KeywordFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> KeywordFieldMapper.toType((FieldMapper)m).fieldType.stored(), false);
        private final ParametrizedFieldMapper.Parameter<String> nullValue = ParametrizedFieldMapper.Parameter.stringParam("null_value", false, m -> KeywordFieldMapper.toType((FieldMapper)m).nullValue, null).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Boolean> eagerGlobalOrdinals = ParametrizedFieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> KeywordFieldMapper.toType((FieldMapper)m).eagerGlobalOrdinals, false);
        private final ParametrizedFieldMapper.Parameter<Integer> ignoreAbove = ParametrizedFieldMapper.Parameter.intParam("ignore_above", true, m -> KeywordFieldMapper.toType((FieldMapper)m).ignoreAbove, Integer.MAX_VALUE);
        private final ParametrizedFieldMapper.Parameter<String> indexOptions = ParametrizedFieldMapper.Parameter.restrictedStringParam("index_options", false, m -> KeywordFieldMapper.toType((FieldMapper)m).indexOptions, "docs", "freqs");
        private final ParametrizedFieldMapper.Parameter<Boolean> hasNorms = TextParams.norms(false, m -> !KeywordFieldMapper.toType((FieldMapper)m).fieldType.omitNorms());
        private final ParametrizedFieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> KeywordFieldMapper.toType((FieldMapper)m).similarity);
        private final ParametrizedFieldMapper.Parameter<Boolean> useSimilarity = ParametrizedFieldMapper.Parameter.boolParam("use_similarity", true, m -> KeywordFieldMapper.toType((FieldMapper)m).useSimilarity, false);
        private final ParametrizedFieldMapper.Parameter<String> normalizer = ParametrizedFieldMapper.Parameter.stringParam("normalizer", false, m -> KeywordFieldMapper.toType((FieldMapper)m).normalizerName, "default");
        private final ParametrizedFieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = ParametrizedFieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> KeywordFieldMapper.toType((FieldMapper)m).splitQueriesOnWhitespace, false);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final IndexAnalyzers indexAnalyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
        }

        public Builder(String name) {
            this(name, null);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.hasNorms, this.similarity, this.useSimilarity, this.normalizer, this.splitQueriesOnWhitespace, this.boost, this.meta);
        }

        protected KeywordFieldType buildFieldType(Mapper.BuilderContext context, FieldType fieldType) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            String normalizerName = this.normalizer.getValue();
            if (!Objects.equals(normalizerName, "default")) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
                if (normalizer == null) {
                    throw new MapperParsingException("normalizer [" + normalizerName + "] not found for field [" + this.name + "]");
                }
                searchAnalyzer = this.splitQueriesOnWhitespace.getValue().booleanValue() ? this.indexAnalyzers.getWhitespaceNormalizer(normalizerName) : normalizer;
            } else if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                searchAnalyzer = Lucene.WHITESPACE_ANALYZER;
            }
            return new KeywordFieldType(this.buildFullName(context), fieldType, normalizer, searchAnalyzer, this);
        }

        @Override
        public KeywordFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            fieldtype.setOmitNorms(this.hasNorms.getValue() == false);
            fieldtype.setIndexOptions(TextParams.toIndexOptions(this.indexed.getValue(), this.indexOptions.getValue()));
            fieldtype.setStored(this.stored.getValue().booleanValue());
            return new KeywordFieldMapper(this.name, fieldtype, this.buildFieldType(context, fieldtype), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }

        @Override
        public Optional<DimensionType> getSupportedDataCubeDimensionType() {
            return Optional.of(DimensionType.ORDINAL);
        }
    }

    public static class KeywordFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final boolean useSimilarity;
        private final boolean splitQueriesOnWhitespace;

        public KeywordFieldType(String name, FieldType fieldType, NamedAnalyzer normalizer, NamedAnalyzer searchAnalyzer, Builder builder) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, fieldType.stored(), builder.hasDocValues.getValue(), new TextSearchInfo(fieldType, builder.similarity.getValue(), searchAnalyzer, searchAnalyzer), builder.meta.getValue());
            this.setEagerGlobalOrdinals(builder.eagerGlobalOrdinals.getValue());
            this.setIndexAnalyzer(normalizer);
            this.setBoost(builder.boost.getValue().floatValue());
            this.ignoreAbove = builder.ignoreAbove.getValue();
            this.nullValue = builder.nullValue.getValue();
            this.useSimilarity = builder.useSimilarity.getValue();
            this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace.getValue();
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            this(name, isSearchable, hasDocValues, false, meta);
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, boolean useSimilarity, Map<String, String> meta) {
            this(name, isSearchable, hasDocValues, useSimilarity, false, meta);
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, boolean useSimilarity, boolean splitQueriesOnWhitespace, Map<String, String> meta) {
            super(name, isSearchable, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.useSimilarity = useSimilarity;
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
        }

        public KeywordFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        public KeywordFieldType(String name, FieldType fieldType) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, false, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.useSimilarity = false;
            this.splitQueriesOnWhitespace = false;
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.useSimilarity = false;
            this.splitQueriesOnWhitespace = false;
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return keywordValue;
                    }
                    try {
                        return KeywordFieldMapper.normalizeValue(normalizer, this.name(), keywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        protected Object rewriteForDocValue(Object value) {
            return value;
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable()) {
                return super.termQueryCaseInsensitive(value, context);
            }
            BytesRef bytesRef = this.indexedValueForSearch(this.rewriteForDocValue(value));
            Term term = new Term(this.name(), bytesRef);
            AutomatonQuery query = AutomatonQueries.createAutomatonQuery(term, AutomatonQueries.toCaseInsensitiveString(bytesRef.utf8ToString()), MultiTermQuery.DOC_VALUES_REWRITE);
            if (this.boost() != 1.0f) {
                query = new BoostQuery((Query)query, this.boost());
            }
            return query;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable()) {
                Query query = super.termQuery(value, context);
                if (!this.useSimilarity) {
                    query = new ConstantScoreQuery(super.termQuery(value, context));
                }
                if (this.boost() != 1.0f) {
                    query = new BoostQuery(query, this.boost());
                }
                return query;
            }
            Query query = SortedSetDocValuesField.newSlowRangeQuery((String)this.name(), (BytesRef)this.indexedValueForSearch(this.rewriteForDocValue(value)), (BytesRef)this.indexedValueForSearch(this.rewriteForDocValue(value)), (boolean)true, (boolean)true);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable() && this.hasDocValues()) {
                if (!context.keywordFieldIndexOrDocValuesEnabled()) {
                    return super.termsQuery(values, context);
                }
                BytesRefsCollectionBuilder iBytesRefs = new BytesRefsCollectionBuilder(values.size());
                BytesRefsCollectionBuilder dVByteRefs = null;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    BytesRef idxBytes = this.indexedValueForSearch(value);
                    iBytesRefs.accept(idxBytes);
                    Object rewritten = this.rewriteForDocValue(value);
                    if (dVByteRefs == null) {
                        if (rewritten == value || rewritten.equals(value)) continue;
                        dVByteRefs = new BytesRefsCollectionBuilder(values.size());
                        for (int rewind = 0; rewind <= i; ++rewind) {
                            Object rewrittenOld = rewind < i ? this.rewriteForDocValue(values.get(rewind)) : rewritten;
                            BytesRef dvBytesOld = this.indexedValueForSearch(rewrittenOld);
                            dVByteRefs.accept(dvBytesOld);
                        }
                        continue;
                    }
                    BytesRef dvBytes = this.indexedValueForSearch(rewritten);
                    dVByteRefs.accept(dvBytes);
                }
                if (dVByteRefs == null) {
                    return TermInSetQuery.newIndexOrDocValuesQuery((MultiTermQuery.RewriteMethod)MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE, (String)this.name(), (Collection)iBytesRefs.get());
                }
                TermInSetQuery indexQuery = new TermInSetQuery(MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE, this.name(), (Collection)iBytesRefs.get());
                TermInSetQuery dvQuery = new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, this.name(), (Collection)dVByteRefs.get());
                return new IndexOrDocValuesQuery((Query)indexQuery, (Query)dvQuery);
            }
            if (this.hasDocValues()) {
                BytesRefsCollectionBuilder bytesCollector = new BytesRefsCollectionBuilder(values.size());
                for (Object value : values) {
                    BytesRef dvBytes = this.indexedValueForSearch(this.rewriteForDocValue(value));
                    bytesCollector.accept(dvBytes);
                }
                return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, this.name(), (Collection)bytesCollector.get());
            }
            return super.termsQuery(values, context);
        }

        @Override
        public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[prefix] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false. For optimised prefix queries on text fields please enable [index_prefixes].", new Object[0]);
            }
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable() && this.hasDocValues()) {
                if (!context.keywordFieldIndexOrDocValuesEnabled()) {
                    return super.prefixQuery(value, method, caseInsensitive, context);
                }
                Query indexQuery = super.prefixQuery(value, method, caseInsensitive, context);
                Query dvQuery = super.prefixQuery((String)this.rewriteForDocValue(value), MultiTermQuery.DOC_VALUES_REWRITE, caseInsensitive, context);
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            if (this.hasDocValues()) {
                if (caseInsensitive) {
                    return AutomatonQueries.caseInsensitivePrefixQuery(new Term(this.name(), this.indexedValueForSearch(this.rewriteForDocValue(value))), MultiTermQuery.DOC_VALUES_REWRITE);
                }
                return new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(this.rewriteForDocValue(value))), MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return super.prefixQuery(value, method, caseInsensitive, context);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[regexp] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable() && this.hasDocValues()) {
                if (!context.keywordFieldIndexOrDocValuesEnabled()) {
                    return super.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
                }
                Query indexQuery = super.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
                Query dvQuery = super.regexpQuery((String)this.rewriteForDocValue(value), syntaxFlags, matchFlags, maxDeterminizedStates, MultiTermQuery.DOC_VALUES_REWRITE, context);
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            if (this.hasDocValues()) {
                return new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(this.rewriteForDocValue(value))), syntaxFlags, matchFlags, RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return super.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable() && this.hasDocValues()) {
                TermRangeQuery indexQuery = new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
                TermRangeQuery dvQuery = new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(this.rewriteForDocValue(lowerTerm)), upperTerm == null ? null : this.indexedValueForSearch(this.rewriteForDocValue(upperTerm)), includeLower, includeUpper, MultiTermQuery.DOC_VALUES_REWRITE);
                return new IndexOrDocValuesQuery((Query)indexQuery, (Query)dvQuery);
            }
            if (this.hasDocValues()) {
                return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(this.rewriteForDocValue(lowerTerm)), upperTerm == null ? null : this.indexedValueForSearch(this.rewriteForDocValue(upperTerm)), includeLower, includeUpper, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[fuzzy] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            if (this.isSearchable() && this.hasDocValues()) {
                if (!context.keywordFieldIndexOrDocValuesEnabled()) {
                    return super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, method, context);
                }
                Query indexQuery = super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, method, context);
                Query dvQuery = super.fuzzyQuery(this.rewriteForDocValue(value), fuzziness, prefixLength, maxExpansions, transpositions, MultiTermQuery.DOC_VALUES_REWRITE, context);
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            if (this.hasDocValues()) {
                return new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(this.rewriteForDocValue(value))), fuzziness.asDistance(BytesRefs.toString(this.rewriteForDocValue(value))), prefixLength, maxExpansions, transpositions, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, method, context);
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            this.failIfNotIndexedAndNoDocValues();
            this.checkToDisableCaching(context);
            if (this.isSearchable() && this.hasDocValues()) {
                if (!context.keywordFieldIndexOrDocValuesEnabled()) {
                    return super.wildcardQuery(value, method, caseInsensitive, true, context);
                }
                Query indexQuery = super.wildcardQuery(value, method, caseInsensitive, true, context);
                Query dvQuery = super.wildcardQuery((String)this.rewriteForDocValue(value), MultiTermQuery.DOC_VALUES_REWRITE, caseInsensitive, true, context);
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            if (this.hasDocValues()) {
                value = KeywordFieldType.normalizeWildcardPattern(this.name(), value, (Analyzer)this.getTextSearchInfo().getSearchAnalyzer());
                Term term = new Term(this.name(), (String)this.rewriteForDocValue(value));
                if (caseInsensitive) {
                    return AutomatonQueries.caseInsensitiveWildcardQuery(term, method);
                }
                return new WildcardQuery(term, 10000, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return super.wildcardQuery(value, method, caseInsensitive, true, context);
        }

        private void checkToDisableCaching(QueryShardContext context) {
            if (this.useSimilarity || this.splitQueriesOnWhitespace) {
                context.setIsCacheable(false);
            }
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

