# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ChangeCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The entity that made the change."""

    USER = "User"
    """User initiated change"""
    SYSTEM = "System"
    """System initiated change"""


class ChangeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of change that was captured in the resource."""

    UPDATE = "Update"
    """An existing resource underwent a change"""
    DELETE = "Delete"
    """An existing resource was deleted"""
    CREATE = "Create"
    """A newly created resource"""


class PropertyChangeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of change that occurred."""

    UPDATE = "Update"
    """An existing property underwent a change"""
    INSERT = "Insert"
    """A property was newly created"""
    REMOVE = "Remove"
    """An existing property was deleted"""
