#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hard West expansions:
# - Scars of Freedom
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251017.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='hard-west'
GAME_NAME='Hard West'

EXPANSION_ID_SCARS='scars-of-freedom'
EXPANSION_NAME_SCARS='Scars of Freedom'

ARCHIVE_BASE_SCARS_0_NAME='gog_hard_west_scars_of_freedom_dlc_2.3.0.4.sh'
ARCHIVE_BASE_SCARS_0_MD5='bb4368afaf670f0d8ebc09f7bb1f3713'
ARCHIVE_BASE_SCARS_0_SIZE='200000'
ARCHIVE_BASE_SCARS_0_VERSION='1.0-gog2.3.0.4'
ARCHIVE_BASE_SCARS_0_URL='https://www.gog.com/game/hard_west_scars_of_freedom'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Data_dlc1'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_default

# Build package.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
