/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EntityLabelMax;
import com.paterva.maltego.ui.graph.view2d.EntityLabelOptions;
import com.paterva.maltego.ui.graph.view2d.PartTypeHelper;
import com.paterva.maltego.util.StringUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import yguard.A.J.gB;

public class CollectionNodeLabel
extends gB {
    private static final Logger LOG = Logger.getLogger(CollectionNodeLabel.class.getName());

    public void setText(String text) {
    }

    public void setCollectionNodeLabelText(GraphPart<? extends Guid> graphPart) {
        GraphID graphID = graphPart.getGraphID();
        boolean isEntity = graphPart instanceof GraphEntity;
        if (isEntity) {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            EntityID entityID = (EntityID)graphPart.getID();
            try {
                String type = PartTypeHelper.getType(graphID, entityID);
                MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(type);
                String displayType = type;
                if (spec != null) {
                    displayType = spec.getDisplayName();
                }
                int size = CollectionNodeUtils.getModelEntityCount(graphID, entityID);
                String displayName = size + " " + displayType;
                this.setTextInternal(displayName);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void setTextInternal(String text) {
        LOG.log(Level.FINE, "text = {0}", text);
        if (EntityLabelOptions.isEnabled(EntityLabelMax.VALUE)) {
            text = StringUtilities.chompLines((String)text, (int)EntityLabelOptions.getMaxLength(EntityLabelMax.VALUE));
            LOG.log(Level.FINE, "text (truncated) = {0}", text);
        }
        super.setText(text);
    }
}

