/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class SystemClientUtil {
    public static final String SYSTEM_CLIENT_ID = "_system";
    private static final Logger logger = Logger.getLogger(SystemClientUtil.class);

    public static ClientModel getSystemClient(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client != null) {
            return client;
        }
        client = realm.getClientByClientId(SYSTEM_CLIENT_ID);
        if (client != null) {
            return client;
        }
        logger.warnf("Client '%s' not available. Creating system client '%s' for system operations", (Object)"account", (Object)SYSTEM_CLIENT_ID);
        client = realm.addClient(SYSTEM_CLIENT_ID);
        client.setName(SYSTEM_CLIENT_ID);
        return client;
    }

    public static void checkSkipLink(KeycloakSession session, AuthenticationSessionModel authSession) {
        String usedClientId = Optional.ofNullable(authSession).map(it -> it.getClient().getClientId()).orElseGet(() -> (String)session.getContext().getUri().getQueryParameters().getFirst((Object)"client_id"));
        if (usedClientId != null && usedClientId.equals(SystemClientUtil.getSystemClient(session.getContext().getRealm()).getClientId())) {
            ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAttribute("skipLink", true);
        }
    }
}

