/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSDoubleToStringNode.class)
public final class JSDoubleToStringNodeGen
extends JSDoubleToStringNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private DoubleData double_cache;

    private JSDoubleToStringNodeGen() {
    }

    @Override
    public String executeString(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return JSDoubleToStringNode.doInt(arg0Value_);
        }
        if ((state_0 & 2) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return JSDoubleToStringNode.doLong(arg0Value_);
        }
        if ((state_0 & 4) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x78) >>> 3, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x78) >>> 3, arg0Value);
            DoubleData s2_ = this.double_cache;
            if (s2_ != null) {
                return JSDoubleToStringNode.doDouble(arg0Value_, s2_.isInt_, s2_.isNaN_, s2_.isPositiveInfinity_, s2_.isNegativeInfinity_, s2_.isZero_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private String executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                String string = JSDoubleToStringNode.doInt(arg0Value_);
                return string;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                String string = JSDoubleToStringNode.doLong(arg0Value_);
                return string;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                DoubleData s2_ = new DoubleData();
                s2_.isInt_ = ConditionProfile.createBinaryProfile();
                s2_.isNaN_ = ConditionProfile.createBinaryProfile();
                s2_.isPositiveInfinity_ = ConditionProfile.createBinaryProfile();
                s2_.isNegativeInfinity_ = ConditionProfile.createBinaryProfile();
                s2_.isZero_ = ConditionProfile.createBinaryProfile();
                MemoryFence.storeStore();
                this.double_cache = s2_;
                state_0 |= doubleCast0 << 3;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                String string = JSDoubleToStringNode.doDouble(arg0Value_, s2_.isInt_, s2_.isNaN_, s2_.isPositiveInfinity_, s2_.isNegativeInfinity_, s2_.isZero_);
                return string;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
            DoubleData s2_ = this.double_cache;
            if (s2_ != null) {
                cached.add(Arrays.asList(s2_.isInt_, s2_.isNaN_, s2_.isPositiveInfinity_, s2_.isNegativeInfinity_, s2_.isZero_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSDoubleToStringNode create() {
        return new JSDoubleToStringNodeGen();
    }

    @GeneratedBy(value=JSDoubleToStringNode.class)
    private static final class DoubleData {
        @CompilerDirectives.CompilationFinal
        ConditionProfile isInt_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isNaN_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isPositiveInfinity_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isNegativeInfinity_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isZero_;

        DoubleData() {
        }
    }
}

