/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import com.pinkmatter.types.Converter;
import com.pinkmatter.types.Coordinate;
import com.pinkmatter.types.Polygon;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.DatelineRule;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.shape.PinkmatterShapeCollection;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.util.List;

class SpatialFactory {
    private static SpatialFactory _instance;
    private final JtsSpatialContext _ctx;

    public SpatialFactory(JtsSpatialContext ctx) {
        this._ctx = ctx;
    }

    public static SpatialFactory getDefault() {
        if (_instance == null) {
            JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
            factory.datelineRule = DatelineRule.width180;
            factory.allowMultiOverlap = false;
            factory.autoIndex = false;
            factory.geo = true;
            factory.normWrapLongitude = true;
            _instance = new SpatialFactory(new PinkmatterSpatialContext(factory));
        }
        return _instance;
    }

    public MultiPolygon createJtsMultiPolygon(Polygon[] polygons) {
        com.vividsolutions.jts.geom.Polygon[] jtsPolygons = new com.vividsolutions.jts.geom.Polygon[polygons.length];
        for (int i = 0; i < polygons.length; ++i) {
            jtsPolygons[i] = Converter.toJts(polygons[i]);
        }
        return this._ctx.getGeometryFactory().createMultiPolygon(jtsPolygons);
    }

    public com.vividsolutions.jts.geom.Polygon createJtsPolygon(Coordinate ... coords) {
        return this._ctx.getGeometryFactory().createPolygon(Converter.toClosedJts(coords));
    }

    public LineString createJtsLineString(Coordinate ... coords) {
        return this._ctx.getGeometryFactory().createLineString(Converter.toJts(coords));
    }

    public com.vividsolutions.jts.geom.Polygon createJtsPolygon(Coordinate[] ring, Coordinate[] ... holes) {
        GeometryFactory factory = this._ctx.getGeometryFactory();
        LinearRing[] jtsHoles = new LinearRing[holes.length];
        for (int i = 0; i < holes.length; ++i) {
            jtsHoles[i] = factory.createLinearRing(Converter.toClosedJts(holes[i]));
        }
        return factory.createPolygon(factory.createLinearRing(Converter.toClosedJts(ring)), jtsHoles);
    }

    GeometryFactory getGeometryFactory() {
        return this._ctx.getGeometryFactory();
    }

    JtsSpatialContext getContext() {
        return this._ctx;
    }

    private static class PinkmatterSpatialContext
    extends JtsSpatialContext {
        public PinkmatterSpatialContext(JtsSpatialContextFactory factory) {
            super(factory);
        }

        public <S extends Shape> ShapeCollection<S> makeCollection(List<S> coll) {
            return new PinkmatterShapeCollection<S>(coll, (SpatialContext)this);
        }
    }
}

