/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.inputform;

import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="MaltegoErrorMessage", strict=false)
class FormError {
    @ElementList(inline=true, type=MaltegoException.class, required=false)
    private ArrayList<MaltegoException> _exceptions;

    public FormError() {
    }

    public FormError(Exception e) {
        this();
        this.getExceptions().add(new MaltegoException(e));
    }

    public ArrayList<MaltegoException> getExceptions() {
        if (this._exceptions == null) {
            this._exceptions = new ArrayList();
        }
        return this._exceptions;
    }

    public String getMessages() {
        StringBuffer buffer = new StringBuffer();
        for (MaltegoException e : this.getExceptions()) {
            buffer.append(e.getMessage());
            if (e.getCode() != 0) {
                buffer.append(String.format(" (%d)", e.getCode()));
            }
            buffer.append(StringUtilities.newLine());
        }
        return buffer.toString();
    }

    @Root(name="Exception", strict=false)
    static class MaltegoException {
        private String _message;
        private int _code = 0;

        public MaltegoException() {
        }

        public MaltegoException(String message) {
            this._message = message;
        }

        public MaltegoException(Exception e) {
            this(MaltegoException.toString(e));
        }

        private static String toString(Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(e.toString());
            buffer.append("\n");
            for (StackTraceElement element : e.getStackTrace()) {
                buffer.append("             ");
                buffer.append(element);
                buffer.append("\n");
            }
            return buffer.toString();
        }

        @Text
        public String getMessage() {
            return this._message;
        }

        @Text
        public void setMessage(String message) {
            this._message = message;
        }

        @Attribute(name="code", required=false)
        public int getCode() {
            return this._code;
        }

        @Attribute(name="code", required=false)
        public void setCode(int code) {
            this._code = code;
        }
    }
}

