/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.IdentityProvider;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.graph.table.io.TabularGraphImporter;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.TabularGraphConvertResult;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.io.convert.TabularGraphPartFactory;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.convert.TabularTranslator;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightPart;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphMatchableEntities;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;

public class TabularGraphBuilder {
    protected static final Random RAND = new Random();
    protected final TabularGraph _tabularGraph;
    protected final TabularGraphConvertResult _result;
    protected final ProgressHandle _handle;
    protected final TabularGraphTypes _types;
    protected final TabularGraphPartFactory _partFactory;
    protected final List<TabularGraphLightweightLink> _allLinks = new ArrayList<TabularGraphLightweightLink>();
    protected final List<File> _files;
    protected int _allEntityCount = 0;
    protected int _entitiesMerged = 0;

    public TabularGraphBuilder(GraphID graphID, TabularGraph tabularGraph, List<File> files, ProgressHandle handle) {
        this._tabularGraph = tabularGraph;
        this._files = files;
        this._result = new TabularGraphConvertResult();
        this._result.setGraphID(graphID);
        this._result.setSavedName(this._tabularGraph.getName());
        this._handle = handle;
        this._types = this.createTypes();
        this._partFactory = this.createPartFactory();
    }

    public GraphID getGraphID() {
        return this._result.getGraphID();
    }

    public List<TabularGraphLink> getLinks() {
        return this._tabularGraph.getLinks();
    }

    public List<TabularGraphEntity> getEntities() {
        return this._tabularGraph.getEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabularGraphConvertResult build() throws Exception {
        int validRowCount = 0;
        try {
            List<TabularGraphFileImporter> importers = TabularGraphFileImporterFactory.createImporters(this._files);
            block12: for (TabularGraphImporter tabularGraphImporter : importers) {
                TabularGraphIterator rowIterator = tabularGraphImporter.open();
                Throwable throwable = null;
                try {
                    int rowCount = this._tabularGraph.hasHeaderRow() && this._tabularGraph.hasTypeRow() ? -2 : (this._tabularGraph.hasHeaderRow() || this._tabularGraph.hasTypeRow() ? -1 : 0);
                    while (rowIterator.hasNext()) {
                        if (!TabularGraphUtils.ignoreRow(rowCount)) {
                            if (this.processRow(rowIterator)) {
                                ++validRowCount;
                            }
                            this.logProgress(validRowCount, "rows read");
                            if (this.checkInterrupted()) continue block12;
                        }
                        ++rowCount;
                        rowIterator.next();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rowIterator == null) continue;
                    if (throwable != null) {
                        try {
                            rowIterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rowIterator.close();
                }
            }
            this.generateGraph();
        }
        finally {
            this._result.setRowsSucceeded(validRowCount);
        }
        return this._result;
    }

    protected TabularGraphTypes createTypes() {
        return new TabularGraphTypes(this._tabularGraph);
    }

    protected TabularGraphPartFactory createPartFactory() {
        return new TabularGraphPartFactory(this._types);
    }

    protected boolean processRow(TabularGraphIterator rowIterator) throws Exception {
        List<Object> row = rowIterator.getRow(this._types.getEntityColumnTypes());
        TabularGraphUtils.trimRowValues(row);
        List<TabularGraphLightweightEntity> entities = this._partFactory.processEntities(row);
        if (!entities.isEmpty()) {
            row = rowIterator.getRow(this._types.getLinkColumnTypes());
            TabularGraphUtils.trimRowValues(row);
            List<TabularGraphLightweightLink> links = this._partFactory.processLinks(row, entities);
            this.filterEntities(links, entities);
            this._allEntityCount += entities.size();
            for (TabularGraphLightweightEntity entity : entities) {
                ((TabularGraphEntityType)entity.type).matchableEntities.entities.add(entity);
            }
            this._allLinks.addAll(links);
        }
        return !entities.isEmpty();
    }

    protected void filterEntities(List<TabularGraphLightweightLink> lightLinks, List<TabularGraphLightweightEntity> lightEntities) {
    }

    protected void generateGraph() throws TypeInstantiationException, TabularTranslator.RowImportException {
        GraphID graphID = this._result.getGraphID();
        List<MaltegoEntity> maltegoEntities = this.generateEntities();
        this._handle.progress("Adding entities to store");
        GraphStoreWriter.addEntities((GraphID)graphID, maltegoEntities);
        Map<MaltegoLink, LinkEntityIDs> linkMap = this.generateLinks(maltegoEntities);
        if (!linkMap.isEmpty()) {
            this._handle.progress("Adding links to store");
            GraphStoreWriter.addLinks((GraphID)graphID, linkMap);
        }
        this._handle.progress("Updating positions");
        this.randomizePositions(graphID, maltegoEntities);
    }

    protected List<MaltegoEntity> generateEntities() throws TypeInstantiationException, TabularTranslator.RowImportException {
        List<TabularGraphLightweightEntity> uniqueEntities = this.getUniqueEntities();
        this._handle.switchToDeterminate(this._allEntityCount + uniqueEntities.size() + this._allLinks.size());
        TabularTranslator translator = new TabularTranslator();
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(uniqueEntities.size());
        AtomicBoolean limitReached = new AtomicBoolean(false);
        uniqueEntities.parallelStream().forEach(uniqueEntity -> {
            if (!limitReached.get()) {
                List list = entities;
                synchronized (list) {
                    if (!limitReached.get() && TabularGraphUtils.isEntityLimitReached(entities.size())) {
                        this._result.getErrors().add("Warning: Entity limit of " + TabularGraphImportOptions.getEntityLimit() + " reached");
                        limitReached.set(true);
                    }
                }
                TabularGraphLightweightEntity entity = uniqueEntity;
                List<TabularGraphLightweightEntity> duplicates = uniqueEntity.duplicates;
                MaltegoEntity maltegoEntity = null;
                try {
                    maltegoEntity = this.translate(translator, entity);
                }
                catch (TabularTranslator.RowImportException | TypeInstantiationException ex) {
                    this._result.getErrors().add(ex.getMessage());
                }
                if (maltegoEntity != null) {
                    List list2 = entities;
                    synchronized (list2) {
                        if (!limitReached.get()) {
                            entities.add(maltegoEntity);
                            entity.maltegoEntity = maltegoEntity;
                            if (duplicates != null) {
                                for (TabularGraphLightweightEntity duplicate : duplicates) {
                                    duplicate.maltegoEntity = maltegoEntity;
                                }
                            }
                        }
                        this.logProgress(entities.size(), "entities converted", this._allEntityCount + entities.size());
                    }
                }
            }
        });
        return entities;
    }

    protected MaltegoEntity translate(TabularTranslator translator, TabularGraphLightweightEntity entity) throws TypeInstantiationException, TabularTranslator.RowImportException {
        TabularGraphEntityType type = (TabularGraphEntityType)entity.type;
        return translator.translate(type.tabularEntity, (List<Object>)entity.row);
    }

    protected List<TabularGraphLightweightEntity> getUniqueEntities() {
        this._handle.switchToDeterminate(2 * this._allEntityCount + this._allLinks.size());
        ArrayList<TabularGraphLightweightEntity> uniques = new ArrayList<TabularGraphLightweightEntity>();
        for (TabularGraphMatchableEntities matchableEntities : this._types.getMatchableEntities()) {
            Collection<TabularGraphLightweightEntity> uniqueEntities = this.getUniqueEntities(matchableEntities);
            uniques.addAll(uniqueEntities);
        }
        return uniques;
    }

    protected Collection<TabularGraphLightweightEntity> getUniqueEntities(TabularGraphMatchableEntities matchableEntities) {
        matchableEntities.entities.parallelStream().forEach(TabularGraphLightweightPart::cacheHashCode);
        HashMap<TabularGraphLightweightEntity, TabularGraphLightweightEntity> uniques = new HashMap<TabularGraphLightweightEntity, TabularGraphLightweightEntity>();
        ArrayList<TabularGraphLightweightEntity> duplicates = new ArrayList<TabularGraphLightweightEntity>();
        for (TabularGraphLightweightEntity entity : matchableEntities.entities) {
            TabularGraphLightweightEntity previous = uniques.put(entity, entity);
            if (previous != null) {
                duplicates.add(previous);
                continue;
            }
            ++this._entitiesMerged;
            if (this._handle == null || this._entitiesMerged >= 100 && this._entitiesMerged % 100 != 0) continue;
            this._handle.progress(this._entitiesMerged + " of " + this._allEntityCount + " entities merged", this._entitiesMerged);
        }
        uniques.entrySet().forEach(entry -> {
            ((TabularGraphLightweightEntity)entry.getValue()).duplicates = Collections.synchronizedList(new ArrayList());
        });
        duplicates.parallelStream().forEach(duplicate -> {
            TabularGraphLightweightEntity unique = (TabularGraphLightweightEntity)uniques.get(duplicate);
            unique.duplicates.add((TabularGraphLightweightEntity)duplicate);
            this.logEntitiesMerged();
        });
        return uniques.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logEntitiesMerged() {
        if (this._handle != null) {
            ProgressHandle progressHandle = this._handle;
            synchronized (progressHandle) {
                ++this._entitiesMerged;
                if (this._handle != null && (this._entitiesMerged < 100 || this._entitiesMerged % 1000 == 0)) {
                    this._handle.progress(this._entitiesMerged + " of " + this._allEntityCount + " entities merged", this._entitiesMerged);
                }
            }
        }
    }

    protected Map<MaltegoLink, LinkEntityIDs> generateLinks(List<MaltegoEntity> entities) throws TabularTranslator.RowImportException {
        TabularTranslator translator = new TabularTranslator();
        Collection<TabularGraphLightweightLink> links = this._allLinks;
        if (TabularGraphImportOptions.isMergeLinks()) {
            links = new HashSet<TabularGraphLightweightLink>(this._allLinks);
        }
        this._handle.switchToDeterminate(this._allEntityCount + entities.size() + links.size());
        HashMap<MaltegoLink, LinkEntityIDs> linkMap = new HashMap<MaltegoLink, LinkEntityIDs>();
        for (TabularGraphLightweightLink link : links) {
            TabularGraphLinkType type = (TabularGraphLinkType)link.type;
            TabularGraphLink tabularLink = type.tabularLink;
            MaltegoEntity source = link.sourceEntity.maltegoEntity;
            MaltegoEntity target = link.targetEntity.maltegoEntity;
            if (source != null && target != null) {
                MaltegoLink maltegoLink = translator.translate(tabularLink, (List<Object>)link.row);
                linkMap.put(maltegoLink, new LinkEntityIDs((EntityID)source.getID(), (EntityID)target.getID()));
            }
            this.logProgress(linkMap.size(), "links converted", this._allEntityCount + entities.size() + linkMap.size());
        }
        return linkMap;
    }

    protected void randomizePositions(GraphID graphID, Collection<MaltegoEntity> maltegoEntities) {
        try {
            int areaSize = maltegoEntities.size() * 100;
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
            Map<EntityID, Point> points = maltegoEntities.stream().collect(Collectors.toMap(IdentityProvider::getID, ignored -> new Point(RAND.nextInt(areaSize), RAND.nextInt(areaSize))));
            layoutWriter.setCenters(points);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected boolean checkInterrupted() {
        boolean interrupted = Thread.interrupted();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return interrupted;
    }

    protected void logProgress(int count, String msg) {
        if (this._handle != null && (count < 100 || count % 100 == 0)) {
            this._handle.progress(count + " " + msg);
        }
    }

    protected void logProgress(int count, String msg, int units) {
        if (this._handle != null && (count < 100 || count % 100 == 0)) {
            this._handle.progress(count + " " + msg, units);
        }
    }
}

