/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class WebAuthnCredentialData {
    private final String aaguid;
    private final String credentialId;
    private long counter;
    private String attestationStatement;
    private String credentialPublicKey;
    private String attestationStatementFormat;
    private Set<String> transports;

    @JsonCreator
    public WebAuthnCredentialData(@JsonProperty(value="aaguid") String aaguid, @JsonProperty(value="credentialId") String credentialId, @JsonProperty(value="counter") long counter, @JsonProperty(value="attestationStatement") String attestationStatement, @JsonProperty(value="credentialPublicKey") String credentialPublicKey, @JsonProperty(value="attestationStatementFormat") String attestationStatementFormat, @JsonProperty(value="transports") Set<String> transports) {
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.counter = counter;
        this.attestationStatement = attestationStatement;
        this.credentialPublicKey = credentialPublicKey;
        this.attestationStatementFormat = attestationStatementFormat;
        this.transports = transports;
    }

    public String getAaguid() {
        return this.aaguid;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getAttestationStatement() {
        return this.attestationStatement;
    }

    public String getCredentialPublicKey() {
        return this.credentialPublicKey;
    }

    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public String getAttestationStatementFormat() {
        return this.attestationStatementFormat;
    }

    public void setAttestationStatementFormat(String attestationStatementFormat) {
        this.attestationStatementFormat = attestationStatementFormat;
    }

    public Set<String> getTransports() {
        return this.transports != null ? this.transports : Collections.emptySet();
    }

    public void setTransports(Set<String> transports) {
        this.transports = transports;
    }

    public String toString() {
        return "WebAuthnCredentialData { aaguid='" + this.aaguid + "', credentialId='" + this.credentialId + "', counter=" + this.counter + ", credentialPublicKey=" + this.credentialPublicKey + ", attestationStatement='" + this.attestationStatement + "', credentialPublicKey='" + this.credentialPublicKey + "', attestationStatementFormat='" + this.attestationStatementFormat + "', transports=" + Arrays.toString(this.getTransports().toArray()) + " }";
    }
}

