/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.treelist.lazy.outline.LazyOutline;
import com.paterva.maltego.treelist.parts.PartNode;
import com.paterva.maltego.treelist.parts.PartsTreeModelEvent;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class PartsTreeModel<PartID extends Guid, Part extends MaltegoPart<PartID>>
implements TreeModel {
    private static final Logger LOG = Logger.getLogger(PartsTreeModel.class.getName());
    private final LazyOutline _outline;
    private final PartsTreelistModel<PartID, Part> _model;
    private final Object _rootObject = new Object();
    private final List<TreeModelListener> _listeners = new LinkedList<TreeModelListener>();
    private PropertyChangeListener _modelListener;

    public PartsTreeModel(LazyOutline outline, PartsTreelistModel<PartID, Part> model) {
        this._outline = outline;
        this._model = model;
    }

    public boolean isFiringDataChange() {
        return this._model.isFiringDataChange();
    }

    @Override
    public Object getRoot() {
        return this._rootObject;
    }

    @Override
    public Object getChild(Object parent, int index) {
        PartNode<PartID, Part> partNode = new PartNode<PartID, Part>(this._model, this._model.getModelPartID(index));
        LOG.log(Level.FINE, "Part node: {0}->{1}", new Object[]{index, partNode});
        return partNode;
    }

    @Override
    public int getChildCount(Object parent) {
        int childCount = 0;
        if (this._rootObject.equals(parent)) {
            childCount = this._model.getModelPartCount();
        }
        LOG.log(Level.FINE, "Child count: {0}", childCount);
        return childCount;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean leaf = !this._rootObject.equals(node) || this._model.getModelPartCount() == 0;
        LOG.log(Level.FINE, "Leaf: {0}->{1}", new Object[]{node, leaf});
        return leaf;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index = this._model.getModelPartIndex(this.getPartID(child));
        LOG.log(Level.FINE, "Index: {0}->{1}", new Object[]{child, index});
        return index;
    }

    public void fireStructureChanged() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        LOG.log(Level.FINE, "Event: {0}", event);
        for (TreeModelListener listener : this._listeners) {
            LOG.log(Level.FINE, "Fire structure changed to: {0}", listener);
            listener.treeStructureChanged(event);
        }
    }

    public void firePartsAdded(PartsTreeModelEvent<PartID> e) {
        TreeModelEvent event = this.toSwingEvent(e);
        LOG.log(Level.FINE, "Event: {0}", event);
        for (TreeModelListener listener : this._listeners) {
            LOG.log(Level.FINE, "Fire parts added to: {0}", listener);
            listener.treeNodesInserted(event);
        }
        this.expand(event);
    }

    public void firePartsRemoved(PartsTreeModelEvent<PartID> e) {
        TreeModelEvent event = this.toSwingEvent(e);
        LOG.log(Level.FINE, "Event: {0}", event);
        for (TreeModelListener listener : this._listeners) {
            LOG.log(Level.FINE, "Fire parts removed to: {0}", listener);
            listener.treeNodesRemoved(event);
        }
        this.expand(event);
    }

    public void firePartsChanged(PartsTreeModelEvent<PartID> e) {
        TreeModelEvent event = this.toSwingEvent(e);
        LOG.log(Level.FINE, "Event: {0}", event);
        for (TreeModelListener listener : this._listeners) {
            LOG.log(Level.FINE, "Fire parts changed to: {0}", listener);
            listener.treeNodesChanged(event);
        }
        this.expand(event);
    }

    private void expand(TreeModelEvent event) {
        this._outline.expandPath(event.getTreePath());
    }

    public void addListeners() {
        this._model.addListeners();
        this._modelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName;
                switch (propName = evt.getPropertyName()) {
                    case "graphChanged": {
                        PartsTreeModel.this.fireStructureChanged();
                        break;
                    }
                    case "partsAdded": {
                        PartsTreeModel.this.firePartsAdded((PartsTreeModelEvent)evt.getNewValue());
                        break;
                    }
                    case "partsRemoved": {
                        PartsTreeModel.this.firePartsRemoved((PartsTreeModelEvent)evt.getNewValue());
                        break;
                    }
                    case "partsChanged": {
                        PartsTreeModel.this.firePartsChanged((PartsTreeModelEvent)evt.getNewValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown property fired: " + propName);
                    }
                }
            }
        };
        this._model.addPropertyChangeListener(this._modelListener);
    }

    public void removeListeners() {
        this._model.removePropertyChangeListener(this._modelListener);
        this._modelListener = null;
        this._model.removeListeners();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._listeners.remove(l);
    }

    public Set<PartID> getSelectedPartIDs() {
        HashSet<PartID> partIDs = new HashSet<PartID>();
        for (int selectedRow : this._outline.getSelectedRows()) {
            int modelIndex = this._outline.convertRowIndexToModel(selectedRow);
            if (modelIndex < 0) continue;
            partIDs.add(this.getPartID(modelIndex));
        }
        return partIDs;
    }

    public Set<PartID> getPartIDs(int[] modelIndexes) {
        HashSet<PartID> partIDs = new HashSet<PartID>();
        for (int index : modelIndexes) {
            partIDs.add(this.getPartID(index));
        }
        return partIDs;
    }

    public PartID getPartID(int modelIndex) {
        Object child = this.getChild(this._rootObject, modelIndex);
        return this.getPartID(child);
    }

    private PartID getPartID(Object node) {
        return this.toPartNode(node).getPartID();
    }

    private PartNode<PartID, Part> toPartNode(Object node) {
        return (PartNode)node;
    }

    private PartNode[] getNodes(List<PartID> parts) {
        PartNode[] nodeArr = new PartNode[parts.size()];
        int num = 0;
        for (Guid partID : parts) {
            nodeArr[num] = new PartNode<Guid, Part>(this._model, partID);
            ++num;
        }
        return nodeArr;
    }

    private TreeModelEvent toSwingEvent(PartsTreeModelEvent<PartID> e) {
        int[] indexes = e.getIndexes();
        Object[] nodes = this.getNodes(e.getParts());
        return new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, indexes, nodes);
    }
}

