/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    private Connection connection;
    private Socks5BytestreamManager manager;

    Socks5TransferNegotiator(Connection connection) {
        this.connection = connection;
        this.manager = Socks5BytestreamManager.getBytestreamManager(this.connection);
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        try {
            return this.manager.establishSession(target, streamID).getOutputStream();
        }
        catch (IOException e) {
            throw new XMPPException("error establishing SOCKS5 Bytestream", e);
        }
        catch (InterruptedException e) {
            throw new XMPPException("error establishing SOCKS5 Bytestream", e);
        }
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException, InterruptedException {
        this.manager.ignoreBytestreamRequestOnce(initiation.getSessionID());
        Packet streamInitiation = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(streamInitiation);
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        this.manager.ignoreBytestreamRequestOnce(streamID);
        return new AndFilter(new FromMatchesFilter(from), new BytestreamSIDFilter(streamID));
    }

    @Override
    public String[] getNamespaces() {
        return new String[]{"http://jabber.org/protocol/bytestreams"};
    }

    @Override
    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException, InterruptedException {
        ByteStreamRequest request = new ByteStreamRequest(this.manager, (Bytestream)streamInitiation);
        Socks5BytestreamSession session = request.accept();
        try {
            PushbackInputStream stream = new PushbackInputStream(session.getInputStream());
            int firstByte = stream.read();
            stream.unread(firstByte);
            return stream;
        }
        catch (IOException e) {
            throw new XMPPException("Error establishing input stream", e);
        }
    }

    @Override
    public void cleanup() {
    }

    private static class ByteStreamRequest
    extends Socks5BytestreamRequest {
        private ByteStreamRequest(Socks5BytestreamManager manager, Bytestream byteStreamRequest) {
            super(manager, byteStreamRequest);
        }
    }

    private static class BytestreamSIDFilter
    extends PacketTypeFilter {
        private String sessionID;

        public BytestreamSIDFilter(String sessionID) {
            super(Bytestream.class);
            if (sessionID == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = sessionID;
        }

        @Override
        public boolean accept(Packet packet) {
            if (super.accept(packet)) {
                Bytestream bytestream = (Bytestream)packet;
                return this.sessionID.equals(bytestream.getSessionID()) && IQ.Type.SET.equals(bytestream.getType());
            }
            return false;
        }
    }
}

