/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransformRunResultCache {
    private final Map<EntityID, MaltegoEntity> entities = new HashMap<EntityID, MaltegoEntity>();
    private final Map<MaltegoLink, List<EntityID>> links = new HashMap<MaltegoLink, List<EntityID>>();
    private final Map<EntityID, Set<EntityID>> mergedEntityIdMap = new HashMap<EntityID, Set<EntityID>>();
    private final Set<EntityID> mergedEntityIdQuickLookup = new HashSet<EntityID>();
    private final Map<LinkID, Set<LinkEntityIDs>> linkEnityIdsQuickLookup = new HashMap<LinkID, Set<LinkEntityIDs>>();
    private final Map<LinkEntityIDs, Set<MaltegoLink>> linksBetweenEntities = new HashMap<LinkEntityIDs, Set<MaltegoLink>>();
    private int addedEntityCount = 0;

    void addEntities(Set<MaltegoEntity> addedEntities) {
        for (MaltegoEntity entity : addedEntities) {
            this.entities.put((EntityID)entity.getID(), entity);
        }
    }

    void addLinks(Map<MaltegoLink, List<EntityID>> addedLinks) {
        this.links.putAll(addedLinks);
    }

    void addLinksBetweenEntities(LinkEntityIDs linkEntitiesIds, MaltegoLink link) {
        if (!this.linksBetweenEntities.containsKey(linkEntitiesIds)) {
            this.linksBetweenEntities.put(linkEntitiesIds, new HashSet<MaltegoLink>(Arrays.asList(link)));
        } else {
            this.linksBetweenEntities.get(linkEntitiesIds).add(link);
        }
        if (!this.linkEnityIdsQuickLookup.containsKey(link.getID())) {
            this.linkEnityIdsQuickLookup.put((LinkID)link.getID(), new HashSet<LinkEntityIDs>(Arrays.asList(linkEntitiesIds)));
        } else {
            this.linkEnityIdsQuickLookup.get(link.getID()).add(linkEntitiesIds);
        }
    }

    void applyEntityMergeResults(Map<MaltegoEntity, List<MaltegoEntity>> mergedEntityMap) {
        for (Map.Entry<MaltegoEntity, List<MaltegoEntity>> entry : mergedEntityMap.entrySet()) {
            MaltegoEntity srcEntity = entry.getKey();
            EntityID srcEntityId = (EntityID)srcEntity.getID();
            Set mergedToEntityIds = entry.getValue().stream().map(e -> (EntityID)e.getID()).collect(Collectors.toSet());
            if (this.mergedEntityIdMap.containsKey(srcEntity.getID())) {
                this.mergedEntityIdMap.get(srcEntity.getID()).addAll(mergedToEntityIds);
            } else {
                this.mergedEntityIdMap.put(srcEntityId, mergedToEntityIds);
            }
            this.mergedEntityIdQuickLookup.addAll(mergedToEntityIds);
        }
    }

    EntityID getMergedEntityId(EntityID entityId) {
        if (!this.mergedEntityIdQuickLookup.contains(entityId)) {
            return entityId;
        }
        for (Map.Entry<EntityID, Set<EntityID>> entry : this.mergedEntityIdMap.entrySet()) {
            if (!entry.getValue().contains(entityId)) continue;
            return entry.getKey();
        }
        return entityId;
    }

    MaltegoEntity getMergedEntity(EntityID updatedEntityId) {
        EntityID mergedToEntityId = this.getMergedEntityId(updatedEntityId);
        return this.entities.get(mergedToEntityId);
    }

    LinkEntityIDs getMergedLinkEntityIds(EntityID sourceEntityId, EntityID targetEntityId) {
        EntityID mergedEntitySourceId = this.getMergedEntityId(sourceEntityId);
        EntityID mergedEntityTargetId = this.getMergedEntityId(targetEntityId);
        return new LinkEntityIDs(mergedEntitySourceId, mergedEntityTargetId);
    }

    Map<MaltegoLink, LinkEntityIDs> getMergedLink(LinkID linkId) {
        HashMap<MaltegoLink, LinkEntityIDs> mergedLink = new HashMap<MaltegoLink, LinkEntityIDs>();
        for (Map.Entry<MaltegoLink, List<EntityID>> link : this.links.entrySet()) {
            if (!((LinkID)link.getKey().getID()).equals((Object)linkId)) continue;
            EntityID sourceEntityId = link.getValue().get(0);
            EntityID targetEntityId = link.getValue().get(1);
            LinkEntityIDs mergedLinkEntityIds = this.getMergedLinkEntityIds(sourceEntityId, targetEntityId);
            mergedLink.put(link.getKey(), mergedLinkEntityIds);
            break;
        }
        return mergedLink;
    }

    Set<MaltegoLink> getMergedLinksBetweenEntities(LinkEntityIDs mergedLinkEntityId) {
        return new HashSet<MaltegoLink>(this.linksBetweenEntities.getOrDefault(mergedLinkEntityId, new HashSet()));
    }

    void incrementAddedEntityCount() {
        ++this.addedEntityCount;
    }

    int getAddedEntityCount() {
        return this.addedEntityCount;
    }
}

