/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class GraphStoreStats {
    private static final Logger LOG = Logger.getLogger(GraphStoreStats.class.getName());

    public static void logStats(GraphID graphID) {
        try {
            StringBuilder sb = new StringBuilder();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            sb.append("Graph:");
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
            GraphStoreStats.write(sb, "D", dataReader.getEntityCount(), dataReader.getLinkCount());
            GraphStoreStats.write(sb, "S", structureReader.getEntityCount(), structureReader.getLinkCount());
            GraphStoreStats.write(sb, "L", layoutReader.getEntityCount(), layoutReader.getLinkCount());
            LOG.info(sb.toString());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void write(StringBuilder sb, String storeType, int entityCount, int linkCount) {
        sb.append(" ").append(storeType).append(":");
        sb.append(" E: ").append(entityCount);
        sb.append(" L: ").append(linkCount);
    }
}

