/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.tools.javac.code.Source;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.base.SourceLevelUtils;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.netbeans.modules.java.source.parsing.MultiReleaseJarFileObject;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Exceptions;

final class ModuleFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getLogger(ModuleFileManager.class.getName());
    private final CachingArchiveProvider cap;
    private final ClassPath modulePath;
    private final Function<URL, Collection<? extends URL>> peers;
    private final Source sourceLevel;
    private final boolean cacheFile;
    private final JavaFileManager.Location forLocation;
    private Set<ModuleLocation> moduleLocations;

    public ModuleFileManager(@NonNull CachingArchiveProvider cap, @NonNull ClassPath modulePath, @NonNull Function<URL, Collection<? extends URL>> peers, @NullAllowed Source sourceLevel, @NonNull JavaFileManager.Location forLocation, boolean cacheFile) {
        assert (cap != null);
        assert (modulePath != null);
        assert (peers != null);
        assert (forLocation != null);
        this.cap = cap;
        this.modulePath = modulePath;
        this.peers = peers;
        this.sourceLevel = sourceLevel;
        this.forLocation = forLocation;
        this.cacheFile = cacheFile;
    }

    @Override
    public Iterable<JavaFileObject> list(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull Set<JavaFileObject.Kind> kinds, boolean recursive) {
        ModuleLocation ml = ModuleLocation.cast(l);
        String folderName = FileObjects.convertPackage2Folder(packageName);
        try {
            ArrayList<Iterable<JavaFileObject>> res = new ArrayList<Iterable<JavaFileObject>>();
            List<? extends String> prefixes = null;
            boolean supportsMultiRelease = this.sourceLevel != null && this.sourceLevel.compareTo(SourceLevelUtils.JDK1_9) >= 0;
            for (URL uRL : ml.getModuleRoots()) {
                Archive archive = this.cap.getArchive(uRL, this.cacheFile);
                if (archive != null) {
                    Iterable<JavaFileObject> entries;
                    if (supportsMultiRelease && archive.isMultiRelease()) {
                        if (prefixes == null) {
                            prefixes = this.multiReleaseRelocations();
                        }
                        HashMap<String, JavaFileObject> fqn2f = new HashMap<String, JavaFileObject>();
                        HashSet<String> seenPackages = new HashSet<String>();
                        for (String string : prefixes) {
                            Iterable<JavaFileObject> fos = archive.getFiles(ModuleFileManager.join(string, folderName), null, kinds, null, recursive);
                            for (JavaFileObject fo : fos) {
                                boolean base = string.isEmpty();
                                if (!base) {
                                    fo = new MultiReleaseJarFileObject((InferableJavaFileObject)fo, string);
                                }
                                String fqn = this.inferBinaryName(l, fo);
                                String pkg = FileObjects.getPackageAndName(fqn)[0];
                                String name = pkg + "/" + FileObjects.getName(fo, false);
                                if (base) {
                                    seenPackages.add(pkg);
                                    fqn2f.put(name, fo);
                                    continue;
                                }
                                if (!seenPackages.contains(pkg)) continue;
                                fqn2f.put(name, fo);
                            }
                        }
                        entries = fqn2f.values();
                    } else {
                        entries = archive.getFiles(folderName, null, kinds, null, recursive);
                    }
                    res.add(entries);
                    if (!LOG.isLoggable(Level.FINEST)) continue;
                    ModuleFileManager.logListedFiles(l, packageName, kinds, entries);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.log(Level.FINEST, "No archive for: {0}", ml.getModuleRoots());
            }
            return Iterators.chained(res);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public FileObject getFileForInput(@NonNull JavaFileManager.Location l, @NonNull String pkgName, @NonNull String relativeName) {
        return this.findFile(ModuleLocation.cast(l), pkgName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(@NonNull JavaFileManager.Location l, @NonNull String className, @NonNull JavaFileObject.Kind kind) {
        ModuleLocation ml = ModuleLocation.cast(l);
        String[] namePair = FileObjects.getParentRelativePathAndName(className);
        boolean supportsMultiRelease = this.sourceLevel != null && this.sourceLevel.compareTo(SourceLevelUtils.JDK1_9) >= 0;
        List<? extends String> reloc = null;
        for (URL uRL : ml.getModuleRoots()) {
            try {
                List<String> prefixes;
                Archive archive = this.cap.getArchive(uRL, this.cacheFile);
                if (archive == null) continue;
                if (supportsMultiRelease && archive.isMultiRelease()) {
                    if (reloc == null) {
                        reloc = this.multiReleaseRelocations();
                    }
                    prefixes = reloc;
                } else {
                    prefixes = Collections.singletonList("");
                }
                for (int i = prefixes.size() - 1; i >= 0; --i) {
                    String prefix = prefixes.get(i);
                    Iterable<JavaFileObject> files = archive.getFiles(ModuleFileManager.join(prefix, namePair[0]), null, null, null, false);
                    for (JavaFileObject e : files) {
                        String ename = e.getName();
                        if (!namePair[1].equals(FileObjects.stripExtension(ename)) || kind != FileObjects.getKind(FileObjects.getExtension(ename))) continue;
                        return prefix.isEmpty() ? e : new MultiReleaseJarFileObject((InferableJavaFileObject)e, prefix);
                    }
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(@NonNull JavaFileManager.Location l, @NonNull String pkgName, @NonNull String relativeName, @NullAllowed FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Output is unsupported.");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("Output is unsupported.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof InferableJavaFileObject) {
            return ((InferableJavaFileObject)javaFileObject).inferBinaryName();
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a instanceof FileObjects.FileBase && b instanceof FileObjects.FileBase && ((FileObjects.FileBase)a).getFile().equals(((FileObjects.FileBase)b).getFile());
    }

    @Override
    @NonNull
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.moduleLocations(location).stream().map(ml -> Collections.singleton(ml)).collect(Collectors.toList());
    }

    @Override
    @NullUnknown
    public String inferModuleName(@NonNull JavaFileManager.Location location) throws IOException {
        ModuleLocation ml = ModuleLocation.cast(location);
        return ml.getModuleName();
    }

    @Override
    @CheckForNull
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        return null;
    }

    @Override
    @CheckForNull
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return this.moduleLocations(location).stream().filter(ml -> moduleName != null && moduleName.equals(ml.getModuleName())).findFirst().orElse(null);
    }

    private Set<ModuleLocation> moduleLocations(JavaFileManager.Location baseLocation) {
        if (!this.forLocation.equals(baseLocation)) {
            throw new IllegalStateException(String.format("Locations computed for: %s, but queried for: %s", this.forLocation, baseLocation));
        }
        if (this.moduleLocations == null) {
            HashSet<ModuleLocation> moduleRoots = new HashSet<ModuleLocation>();
            HashSet<? extends URL> seen = new HashSet<URL>();
            for (ClassPath.Entry e : this.modulePath.entries()) {
                String moduleName;
                URL root = e.getURL();
                if (seen.contains(root) || (moduleName = SourceUtils.getModuleName(root)) == null) continue;
                Collection<? extends URL> p = this.peers.apply(root);
                moduleRoots.add(ModuleLocation.create(baseLocation, p, moduleName));
                seen.addAll(p);
            }
            this.moduleLocations = moduleRoots;
        }
        return this.moduleLocations;
    }

    private JavaFileObject findFile(@NonNull ModuleLocation ml, @NonNull String pkgName, @NonNull String relativeName) {
        assert (ml != null);
        assert (pkgName != null);
        assert (relativeName != null);
        String resourceName = FileObjects.resolveRelativePath(pkgName, relativeName);
        boolean supportsMultiRelease = this.sourceLevel != null && this.sourceLevel.compareTo(SourceLevelUtils.JDK1_9) >= 0;
        List<? extends String> reloc = null;
        for (URL uRL : ml.getModuleRoots()) {
            try {
                List<String> prefixes;
                Archive archive = this.cap.getArchive(uRL, this.cacheFile);
                if (archive == null) continue;
                if (supportsMultiRelease && archive.isMultiRelease()) {
                    if (reloc == null) {
                        reloc = this.multiReleaseRelocations();
                    }
                    prefixes = reloc;
                } else {
                    prefixes = Collections.singletonList("");
                }
                for (int i = prefixes.size() - 1; i >= 0; --i) {
                    String prefix = prefixes.get(i);
                    JavaFileObject file = archive.getFile(ModuleFileManager.join(prefix, resourceName));
                    if (file == null) continue;
                    return prefix.isEmpty() ? file : new MultiReleaseJarFileObject((InferableJavaFileObject)file, prefix);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    private static void logListedFiles(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NullAllowed Set<? extends JavaFileObject.Kind> kinds, @NonNull Iterable<? extends JavaFileObject> entries) {
        StringBuilder urls = new StringBuilder();
        for (JavaFileObject javaFileObject : entries) {
            urls.append(javaFileObject.toUri().toString());
            urls.append(", ");
        }
        LOG.log(Level.FINEST, "Filesfor {0} package: {1} type: {2} files: [{3}]", new Object[]{l, packageName, kinds, urls});
    }

    @NonNull
    private List<? extends String> multiReleaseRelocations() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("");
        Source[] sources = Source.values();
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i].compareTo(SourceLevelUtils.JDK1_9) < 0 || sources[i].compareTo(this.sourceLevel) > 0) continue;
            prefixes.add(String.format("META-INF/versions/%s", ModuleFileManager.normalizeSourceLevel(sources[i].name)));
        }
        return prefixes;
    }

    @NonNull
    private static String normalizeSourceLevel(@NonNull String sl) {
        int index = sl.indexOf(46);
        return index < 0 ? sl : sl.substring(index + 1);
    }

    @NonNull
    private static String join(@NonNull String prefix, @NonNull String path) {
        return prefix.isEmpty() ? path : (path.isEmpty() ? prefix : prefix + '/' + path);
    }
}

