/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.TranslucentGlassPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class WindowUtil {
    public static int _showCount = 0;
    private static Frame win;
    private static Component standardGlassPane;
    private static TranslucentGlassPane translucentGlassPane;

    public static void showWaitCursor() {
        Component glassPane;
        if (++_showCount == 1 && (glassPane = WindowUtil.getMainWindowGlassPane()) != null) {
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        }
    }

    public static void hideWaitCursor() {
        Component glassPane;
        if (--_showCount == 0 && (glassPane = WindowUtil.getMainWindowGlassPane()) != null) {
            glassPane.setVisible(false);
        }
    }

    public static void showWaitCursor(JComponent component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void hideWaitCursor(JComponent component) {
        component.setCursor(null);
    }

    private static Component getMainWindowGlassPane() {
        Component glassPane = null;
        Frame mainWindow = WindowUtil.getMainWindow();
        if (mainWindow instanceof JFrame) {
            JFrame frame = (JFrame)mainWindow;
            glassPane = frame.getGlassPane();
        }
        return glassPane;
    }

    private static void setMainWindowGlassPane(Component glassPane) {
        Frame mainWindow = WindowUtil.getMainWindow();
        if (mainWindow instanceof JFrame) {
            JFrame frame = (JFrame)mainWindow;
            frame.setGlassPane(glassPane);
        }
    }

    public static Component getTitlePane() {
        Frame mainWindow = WindowUtil.getMainWindow();
        if (mainWindow instanceof JFrame) {
            JFrame frame = (JFrame)mainWindow;
            JLayeredPane layeredPane = frame.getLayeredPane();
            for (Component component : layeredPane.getComponents()) {
                String simpleName = component.getClass().getSimpleName();
                if (!"OfficeTitlePane".equals(simpleName)) continue;
                return component;
            }
        }
        return null;
    }

    public static void selectRibbonTab(String tabTitle) {
        Frame mainWindow = WindowUtil.getMainWindow();
        if (mainWindow instanceof JFrame) {
            JFrame frame = (JFrame)mainWindow;
            JLayeredPane layeredPane = frame.getLayeredPane();
            for (Component component : layeredPane.getComponents()) {
                String simpleName = component.getClass().getSimpleName();
                if (!"JRibbon".equals(simpleName)) continue;
                JRibbon ribbon = (JRibbon)component;
                for (int i = 0; i < ribbon.getTaskCount(); ++i) {
                    RibbonTask task = ribbon.getTask(i);
                    if (!task.getTitle().equals(tabTitle)) continue;
                    ribbon.setSelectedTask(task);
                }
            }
        }
    }

    public static Frame getMainWindow() {
        if (win == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                win = WindowManager.getDefault().getMainWindow();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            win = WindowManager.getDefault().getMainWindow();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return win;
    }

    public static void showTranslucentGlassPane() {
        WindowUtil.showTranslucentGlassPane(new TranslucentGlassPane.GlassPaneCustomizer());
    }

    public static void showTranslucentGlassPane(TranslucentGlassPane.GlassPaneCustomizer customizer) {
        if (translucentGlassPane == null) {
            standardGlassPane = WindowUtil.getMainWindowGlassPane();
            translucentGlassPane = new TranslucentGlassPane();
            WindowUtil.setMainWindowGlassPane(translucentGlassPane);
        }
        translucentGlassPane.setCustomizer(customizer);
        translucentGlassPane.setVisible(true);
        translucentGlassPane.invalidate();
        translucentGlassPane.repaint();
    }

    public static void hideTranslucentGlassPane() {
        if (translucentGlassPane != null) {
            translucentGlassPane.setVisible(false);
            translucentGlassPane = null;
            WindowUtil.setMainWindowGlassPane(standardGlassPane);
        }
    }

    public static Point locationRelativeToGlassPane(Component c) {
        Point location = c.getLocation();
        Point converted = SwingUtilities.convertPoint(c, location, WindowUtil.getMainWindowGlassPane());
        return converted;
    }
}

