/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.imex;

import com.paterva.maltego.importexport.ConfigFolderNode;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.ui.imex.HubSeedConfig;
import com.paterva.maltego.seeds.ui.imex.HubSeedInstalledInfo;
import com.paterva.maltego.seeds.ui.imex.HubSeedNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class HubSeedConfigNode
extends ConfigFolderNode {
    HubSeedConfigNode(HubSeedConfig seedConfig, HubSeedInstalledInfo existInfo) {
        this(seedConfig, new InstanceContent(), existInfo);
    }

    private HubSeedConfigNode(HubSeedConfig seedConfig, InstanceContent content, HubSeedInstalledInfo existInfo) {
        super((Children)new SeedChildren(seedConfig, existInfo), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)seedConfig);
        content.add((Object)this);
        this.setName("Maltego Data Hub Items");
        this.setShortDescription(((HubSeedDescriptor[])seedConfig.getAll()).length + " Items");
        this.setSelectedNonRecursive(((HubSeedDescriptor[])seedConfig.getSelected()).length != 0);
    }

    private static class SeedChildren
    extends Children.Keys<HubSeedDescriptor> {
        private final HubSeedConfig _config;
        private final HubSeedInstalledInfo _existInfo;

        public SeedChildren(HubSeedConfig seedConfig, HubSeedInstalledInfo existInfo) {
            this._config = seedConfig;
            this._existInfo = existInfo;
            this.setKeys(seedConfig.getAll());
        }

        protected Node[] createNodes(HubSeedDescriptor seed) {
            HubSeedNode seedNode = new HubSeedNode(this._config, seed, this._existInfo);
            seedNode.setSelectedNonRecursive(this._config.isSelected(seed));
            return new Node[]{seedNode};
        }
    }
}

