/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details.entities;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformEntityNames;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceCreator;
import com.paterva.maltego.transforms.tabular.ui.details.EditMappingsHelper;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.Exceptions;

public class TabularTransformEntitiesTableModel
extends RowTableModel<TabularGraphEntity> {
    public static final String[] COLUMNS = new String[]{"Entity Name", "Entity Type"};
    private final TabularTransformSource transformSource;

    public TabularTransformEntitiesTableModel(TabularTransformSource transformSource) {
        super(COLUMNS, TabularTransformEntitiesTableModel.getEntities(transformSource));
        this.transformSource = transformSource;
    }

    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public Object getValueFor(TabularGraphEntity entity, int column) {
        switch (column) {
            case 0: {
                return this.getEntityName(entity);
            }
            case 1: {
                return this.getTypeDisplayName(entity);
            }
        }
        throw new IllegalArgumentException("No column for index: " + column);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String strValue;
        if (columnIndex == 0 && value != null && StringUtils.isNotBlank((CharSequence)(strValue = value.toString()))) {
            try {
                TabularGraph tabularGraph = MappingRegistry.getDefault().get(this.transformSource.getTabularGraphName());
                tabularGraph = new DefaultTabularGraph(tabularGraph);
                EditMappingsHelper.updateColumns(this.transformSource, tabularGraph);
                TabularGraphEntity entity = (TabularGraphEntity)this.getRow(rowIndex);
                HashMap<Integer, String> entityNames = new HashMap<Integer, String>(this.transformSource.getEntityNames().toMap());
                entityNames.put(entity.getColumns()[0], value.toString());
                TabularTransformSource txSource = this.transformSource.setEntityNames(new TabularTransformEntityNames(entityNames));
                txSource = TabularTransformSourceCreator.getDefault().recreate(txSource, tabularGraph, false);
                TabularTransformSourceRepository.getInstance().update((Object)txSource);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void removeRow(int index) {
        this.removeRows(new int[]{index});
    }

    public void removeRows(int[] indices) {
        List entities = this.getRows(indices);
        this.remove(entities);
    }

    private void remove(List<TabularGraphEntity> entities) {
        try {
            Args.notNull(entities, (String)"entities");
            int[] columns = entities.stream().flatMapToInt(entity -> Arrays.stream(entity.getColumns())).toArray();
            TabularGraph tabularGraph = MappingRegistry.getDefault().get(this.transformSource.getTabularGraphName());
            tabularGraph = new DefaultTabularGraph(tabularGraph);
            tabularGraph.removeColumnsFromEntities(columns);
            TabularTransformSourceRepository.getInstance().update((Object)TabularTransformSourceCreator.getDefault().recreate(this.transformSource, tabularGraph, false));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getTypeDisplayName(TabularGraphEntity entity) {
        Args.notNull((Object)entity, (String)"entity");
        MaltegoEntitySpec spec = (MaltegoEntitySpec)EntityRegistry.getDefault().get(entity.getEntitySpecName());
        String specDisplayName = spec != null ? spec.getDisplayName() : "";
        return specDisplayName != null ? specDisplayName : entity.getEntitySpecName();
    }

    private String getEntityName(TabularGraphEntity entity) {
        Args.notNull((Object)entity, (String)"entity");
        return this.transformSource.getEntityNames().getName(entity).orElse("Unknown Name");
    }

    private static List<TabularGraphEntity> getEntities(TabularTransformSource transformSource) {
        Args.notNull((Object)transformSource, (String)"transformSource");
        String tabularGraphName = transformSource.getTabularGraphName();
        TabularGraph tabularGraph = MappingRegistry.getDefault().get(tabularGraphName);
        return tabularGraph.getEntities();
    }
}

