/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: wangyan <wangyan@kylinos.cn>
 *
 */

#include "appwidgetconfiguration.h"
#include <QDebug>
#include <QSettings>
#include <QTextCodec>
namespace AppWidget {
AppWidgetConfiguration::AppWidgetConfiguration(QObject *parent) : QObject(parent)
{
    //! \todo init
}
QString AppWidgetConfiguration::getProviderNameByAppWidgetName(const QString &appwidgetname)
{
    if(appwidgetname.isEmpty()) {
        qWarning() << __FILE__ << __FUNCTION__ << "parameter is empty";
        return QString();
    }
    QString path = QString("/usr/share/appwidget/config/%1.conf").arg(appwidgetname);
    QSettings setting(path, QSettings::IniFormat);
    setting.beginGroup("AppWidget");
    QString providerName = setting.value("providerName").toString();
    qDebug() << __FILE__ << __FUNCTION__ << appwidgetname << " `s appwidgetname is :" <<providerName;
    setting.endGroup();
    setting.sync();
    return providerName;
}
QString AppWidgetConfiguration::getAppWidgetUiFile(const QString &appwidgetname)
{
    if(appwidgetname.isEmpty()) {
        qWarning() << "parameter is empty";
        return QString();
    }
    QString path = QString("/usr/share/appwidget/config/%1.conf").arg(appwidgetname);
    QSettings setting(path, QSettings::IniFormat);
    setting.beginGroup("AppWidget");
    QString qmlFile = setting.value("qmlFile").toString();
    qDebug() << __FILE__ << __FUNCTION__ << appwidgetname << " `s qmlFile is :" <<qmlFile;
    setting.endGroup();
    setting.sync();
    return qmlFile;
}
//获取ui文件
QString AppWidgetConfiguration::getAppWidgetConfig(const QString &appwidgetname, const QString &config)
{
    if(appwidgetname.isEmpty() || config.isEmpty()) {
        qWarning() << __FILE__ << __FUNCTION__ << "parameter is empty";
        return QString();
    }
    QString path = QString("/usr/share/appwidget/config/%1.conf").arg(appwidgetname);
    return getConfigurationByKey(path, config);
}

//获取属性
QMap<QString, QVariant> AppWidgetConfiguration::getAppWidgetConfigs(const QString &appwidgetname, QString begianName)
{
    if(appwidgetname.isEmpty()) {
        qWarning() << __FILE__ << __FUNCTION__ << "parameter is empty";
        return QMap<QString, QVariant>();
    }
    QMap<QString, QVariant> configs;
    QString path = QString("/usr/share/appwidget/config/%1.conf").arg(appwidgetname);
    QSettings setting(path, QSettings::IniFormat);
    setting.beginGroup(begianName);
    QStringList keylist = setting.allKeys();
    for (int i = 0; i < keylist.count(); i++) {
        configs.insert(keylist.at(i),setting.value(keylist.at(i)));
    }
    setting.endGroup();
    setting.sync();
    return configs;
}
QString AppWidgetConfiguration::getConfigurationByKey(const QString &path, const QString &key)
{
    if(path.isEmpty() || key.isEmpty()) {
        qWarning() << __FILE__ << __FUNCTION__ << "parameter is empty";
        return QString();
    }
    QSettings setting(path, QSettings::IniFormat);
    setting.setIniCodec(QTextCodec::codecForName("utf-8"));
    setting.beginGroup("AppWidget");
    QString value = setting.value(key).toString();
    setting.endGroup();
    setting.sync();
    return value;
}
} // namespace AppWidget
