// Code generated by go generate; DO NOT EDIT.
package common

import "errors"

type Permission int

const (
    Invalid Permission = iota
    DataRecordsRead Permission = iota
    DataRecordsWrite Permission = iota
    DataRecordcommentsRead Permission = iota
    DataRecordcommentsWrite Permission = iota
    SchemaBasesRead Permission = iota
    SchemaBasesWrite Permission = iota
    WebhookManage Permission = iota
    BlockManage Permission = iota
    UserEmailRead Permission = iota
    EnterpriseGroupsRead Permission = iota
    WorkspacesandbasesRead Permission = iota
    WorkspacesandbasesWrite Permission = iota
    WorkspacesandbasesSharesManage Permission = iota
    EnterpriseScimUsersandgroupsManage Permission = iota
    EnterpriseAuditlogsRead Permission = iota
    EnterpriseChangeeventsRead Permission = iota
    EnterpriseExportsManage Permission = iota
    EnterpriseAccountRead Permission = iota
    EnterpriseAccountWrite Permission = iota
    EnterpriseUserRead Permission = iota
    EnterpriseUserWrite Permission = iota
    EnterpriseGroupsManage Permission = iota
    WorkspacesandbasesManage Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        DataRecordsRead: "data.records:read",
        DataRecordsWrite: "data.records:write",
        DataRecordcommentsRead: "data.recordComments:read",
        DataRecordcommentsWrite: "data.recordComments:write",
        SchemaBasesRead: "schema.bases:read",
        SchemaBasesWrite: "schema.bases:write",
        WebhookManage: "webhook:manage",
        BlockManage: "block:manage",
        UserEmailRead: "user.email:read",
        EnterpriseGroupsRead: "enterprise.groups:read",
        WorkspacesandbasesRead: "workspacesAndBases:read",
        WorkspacesandbasesWrite: "workspacesAndBases:write",
        WorkspacesandbasesSharesManage: "workspacesAndBases.shares:manage",
        EnterpriseScimUsersandgroupsManage: "enterprise.scim.usersAndGroups:manage",
        EnterpriseAuditlogsRead: "enterprise.auditLogs:read",
        EnterpriseChangeeventsRead: "enterprise.changeEvents:read",
        EnterpriseExportsManage: "enterprise.exports:manage",
        EnterpriseAccountRead: "enterprise.account:read",
        EnterpriseAccountWrite: "enterprise.account:write",
        EnterpriseUserRead: "enterprise.user:read",
        EnterpriseUserWrite: "enterprise.user:write",
        EnterpriseGroupsManage: "enterprise.groups:manage",
        WorkspacesandbasesManage: "workspacesAndBases:manage",
    }

    StringToPermission = map[string]Permission{
        "data.records:read": DataRecordsRead,
        "data.records:write": DataRecordsWrite,
        "data.recordComments:read": DataRecordcommentsRead,
        "data.recordComments:write": DataRecordcommentsWrite,
        "schema.bases:read": SchemaBasesRead,
        "schema.bases:write": SchemaBasesWrite,
        "webhook:manage": WebhookManage,
        "block:manage": BlockManage,
        "user.email:read": UserEmailRead,
        "enterprise.groups:read": EnterpriseGroupsRead,
        "workspacesAndBases:read": WorkspacesandbasesRead,
        "workspacesAndBases:write": WorkspacesandbasesWrite,
        "workspacesAndBases.shares:manage": WorkspacesandbasesSharesManage,
        "enterprise.scim.usersAndGroups:manage": EnterpriseScimUsersandgroupsManage,
        "enterprise.auditLogs:read": EnterpriseAuditlogsRead,
        "enterprise.changeEvents:read": EnterpriseChangeeventsRead,
        "enterprise.exports:manage": EnterpriseExportsManage,
        "enterprise.account:read": EnterpriseAccountRead,
        "enterprise.account:write": EnterpriseAccountWrite,
        "enterprise.user:read": EnterpriseUserRead,
        "enterprise.user:write": EnterpriseUserWrite,
        "enterprise.groups:manage": EnterpriseGroupsManage,
        "workspacesAndBases:manage": WorkspacesandbasesManage,
    }

    PermissionIDs = map[Permission]int{
        DataRecordsRead: 1,
        DataRecordsWrite: 2,
        DataRecordcommentsRead: 3,
        DataRecordcommentsWrite: 4,
        SchemaBasesRead: 5,
        SchemaBasesWrite: 6,
        WebhookManage: 7,
        BlockManage: 8,
        UserEmailRead: 9,
        EnterpriseGroupsRead: 10,
        WorkspacesandbasesRead: 11,
        WorkspacesandbasesWrite: 12,
        WorkspacesandbasesSharesManage: 13,
        EnterpriseScimUsersandgroupsManage: 14,
        EnterpriseAuditlogsRead: 15,
        EnterpriseChangeeventsRead: 16,
        EnterpriseExportsManage: 17,
        EnterpriseAccountRead: 18,
        EnterpriseAccountWrite: 19,
        EnterpriseUserRead: 20,
        EnterpriseUserWrite: 21,
        EnterpriseGroupsManage: 22,
        WorkspacesandbasesManage: 23,
    }

    IdToPermission = map[int]Permission{
        1: DataRecordsRead,
        2: DataRecordsWrite,
        3: DataRecordcommentsRead,
        4: DataRecordcommentsWrite,
        5: SchemaBasesRead,
        6: SchemaBasesWrite,
        7: WebhookManage,
        8: BlockManage,
        9: UserEmailRead,
        10: EnterpriseGroupsRead,
        11: WorkspacesandbasesRead,
        12: WorkspacesandbasesWrite,
        13: WorkspacesandbasesSharesManage,
        14: EnterpriseScimUsersandgroupsManage,
        15: EnterpriseAuditlogsRead,
        16: EnterpriseChangeeventsRead,
        17: EnterpriseExportsManage,
        18: EnterpriseAccountRead,
        19: EnterpriseAccountWrite,
        20: EnterpriseUserRead,
        21: EnterpriseUserWrite,
        22: EnterpriseGroupsManage,
        23: WorkspacesandbasesManage,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
