/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AuxiliaryAxis;
import cds.healpix.HashComputerWithAux;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixProjector;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.fillingcurve.ZOrderCurve3D;

class HealpixNestedHashComputerWithAux
implements HashComputerWithAux {
    public static final int DEPTH_MAX = 16;
    private final HealpixNested h;
    private final AuxiliaryAxis auxAxis;
    private final long halfNside4IEEEdouble;
    private final HealpixProjector proj = new HealpixProjector();
    private double[] xy = new double[2];
    private double x;
    private double y;
    private long xInt;
    private long yInt;
    private int iBaseCell;
    private int jBaseCell;
    private int iInBaseCell;
    private int jInBaseCell;
    private long baseCellBits;

    HealpixNestedHashComputerWithAux(HealpixNested healpixNested, AuxiliaryAxis auxAxis) {
        this.h = healpixNested;
        this.auxAxis = auxAxis;
        if (this.h.depth > 19) {
            throw new IllegalArgumentException("depth with auxiliary axis limited to 19 (inclusive)");
        }
        this.halfNside4IEEEdouble = this.h.depth == 0 ? 0L : (long)this.h.depth - 1L << 52;
    }

    @Override
    public int depth() {
        return this.h.depth;
    }

    @Override
    public long hash(double lonRad, double latRad, double auxValue) {
        this.project(lonRad, latRad);
        this.shiftAndRotateAndScale();
        this.discretize();
        this.computeBaseCellCoos();
        this.computeCoosInBaseCell();
        this.computeBaseCellBits();
        int aux = this.computeAuxValue(auxValue);
        return this.baseCellBits | ZOrderCurve3D.INSTANCE.ijk2hash(this.iInBaseCell, this.jInBaseCell, aux);
    }

    private void project(double lon, double lat) {
        this.proj.project(lon, lat, this.xy);
        this.x = this.xy[0];
        assert (-8.0 < this.x && this.x < 8.0);
        this.y = this.xy[1];
        assert (-2.0 <= this.y && this.y <= 2.0);
        if (this.x < 0.0) {
            this.x += 8.0;
        }
        assert (0.0 <= this.x && this.x < 8.0);
    }

    private void shiftAndRotateAndScale() {
        this.y += 1.0;
        this.x += this.y;
        this.y -= this.xy[0];
        this.y += 8.0;
        this.x = HackersDelight.fromBits(this.halfNside4IEEEdouble + HackersDelight.toBits(this.x));
        this.y = HackersDelight.fromBits(this.halfNside4IEEEdouble + HackersDelight.toBits(this.y));
        assert (0.0 <= this.x && this.x <= (double)(5 * this.h.nside));
        assert (0.0 <= this.y && this.y <= (double)(5 * this.h.nside));
    }

    private void discretize() {
        this.xInt = HackersDelight.floorLongP(this.x);
        assert (0L <= this.xInt && this.xInt <= (long)(5 * this.h.nside)) : this.xInt + " <= " + 4 * this.h.nside;
        this.yInt = HackersDelight.floorLongP(this.y);
        assert (0L <= this.yInt && this.yInt <= (long)(5 * this.h.nside)) : this.yInt + " <= " + 4 * this.h.nside;
    }

    private void computeBaseCellCoos() {
        this.iBaseCell = this.h.dividedByNsideQuotient(this.xInt);
        assert (0 <= this.iBaseCell && this.iBaseCell <= 4);
        this.jBaseCell = this.h.dividedByNsideQuotient(this.yInt);
        assert (0 <= this.jBaseCell && this.jBaseCell <= 4);
    }

    private void computeCoosInBaseCell() {
        this.iInBaseCell = this.h.moduloNside(this.xInt);
        assert (0 <= this.iInBaseCell && this.iInBaseCell < this.h.nside);
        this.jInBaseCell = this.h.moduloNside(this.yInt);
        assert (0 <= this.jInBaseCell && this.jInBaseCell < this.h.nside);
    }

    private int computeAuxValue(double auxValue) {
        double normalized = this.auxAxis.project(auxValue);
        if (normalized < 0.0 || 1.0 <= normalized) {
            throw new IllegalArgumentException("Wrong auxiliary value: f(auxValue) must be in [0, 1[");
        }
        return HackersDelight.floorIntP(normalized * (double)this.h.nside);
    }

    private void computeBaseCellBits() {
        this.jBaseCell = 5 - (this.iBaseCell + this.jBaseCell);
        if (this.jBaseCell >= 0) {
            assert (this.jBaseCell <= 2);
            this.baseCellBits = (long)((this.jBaseCell << 2) + (this.iBaseCell - (--this.jBaseCell >>> 63) & 3)) << this.h.twiceDepth + this.h.depth;
        } else if (this.jBaseCell == -1) {
            this.baseCellBits = (long)(this.iBaseCell - 1 & 3) << this.h.twiceDepth + this.h.depth | this.h.yMask;
        } else if (this.jBaseCell == -2) {
            this.baseCellBits = (long)(this.iBaseCell - 2) << this.h.twiceDepth + this.h.depth | this.h.xyMask;
        } else assert (false);
    }
}

