# Additional references for documentation

- [/proc/stat explained](http://www.linuxhowtos.org/System/procstat.htm)
- [Gathering CPU utilization from /proc/stat](https://www.idnt.net/en-US/kb/941772)
- [proc filesystem documentation](https://www.mjmwired.net/kernel/Documentation/filesystems/proc.txt#1212)
- [CPU usage on Linux](https://www.opsdash.com/blog/cpu-usage-linux.html)
- [Using RAPL to read PP0 and DRAM energy on Haswell](https://community.intel.com/t5/Software-Tuning-Performance/Using-RAPL-to-read-PP0-and-DRAM-energy-on-haswell/td-p/1076202)
- [RAPL reference](http://web.eece.maine.edu/~vweaver/projects/rapl/)
- [How to measure linux performance avoiding most typical mistakes: CPU](https://ma.ttias.be/how-to-measure-linux-performance-avoiding-most-typical-mistakes-cpu/)
- [How to calculate cpu utilization](https://www.embedded.com/how-to-calculate-cpu-utilization/)

# Powercap/RAPL source code in the kernel

- arch/x86/events/intel/rapl.c
- drivers/powercap

# Topics to investigate

- [PSI](https://facebookmicrosites.github.io/psi/docs/overview)
- [Linux PSI by example](https://unixism.net/2019/08/linux-pressure-stall-information-psi-by-example/)
- [PSI - Pressure Stall Information](https://www.kernel.org/doc/html/latest/accounting/psi.html)
- [How to measure linux performance avoiding most typical mistakes: memory](https://ma.ttias.be/how-to-measure-linux-performance-avoiding-most-typical-mistakes-memory/)
