% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_font.R
\name{add_fonts}
\alias{add_fonts}
\alias{scan_local_fonts}
\alias{clear_local_fonts}
\title{Add local font files to the search path}
\usage{
add_fonts(files)

scan_local_fonts()

clear_local_fonts()
}
\arguments{
\item{files}{A character vector of font file paths to add}
}
\value{
This function is called for its sideeffects
}
\description{
systemfonts is mainly about getting system native access to the fonts
installed on the OS you are executing the code on. However, you may want to
access fonts without doing a full installation, either because you want your
project to be reproducible on all systems, because you don't have
administrator priviliges on the system, or for a different reason entirely.
\code{add_fonts()} provide a way to side load font files so that they are found
during font matching. The function differs from \code{\link[=register_font]{register_font()}} and
\code{\link[=register_variant]{register_variant()}} in that they add the font file as-is using the family
name etc that are provided by the font. \code{scan_local_fonts()} is run when
systemfonts is loaded and will automatically add font files stored in
\code{./fonts} (project local) and \verb{~/fonts} (user local).
}
\section{Font matching}{
During font matching, systemfonts has to look in three different locations.
The font registry (populated by \code{\link[=register_font]{register_font()}}/\code{\link[=register_variant]{register_variant()}}), the
local fonts (populated with \code{\link[=add_fonts]{add_fonts()}}/\code{\link[=scan_local_fonts]{scan_local_fonts()}}), and the
fonts installed on the system. It does so in that order: registry > local >
installed.

The matching performed at each step also differs. The fonts in the registry
is only matched by family name. The local fonts are matched based on all the
provided parameters (family, weight, italic, etc) in a way that is local to
systemfonts, but try to emulate the system native matching. The installed
fonts are matched using the system native matching functionality on macOS and
Linux. On Windows the installed fonts are read from the system registry and
matched using the same approach as for local fonts. Matching will always find
a font no matter what you throw at it, defaulting to "sans" if nothing else
is found.
}

\examples{
# example code
empty_font <- system.file("unfont.ttf", package = "systemfonts")

add_fonts(empty_font)

clear_local_fonts()

}
